###############################################################################
# OpenVAS Vulnerability Test
# $Id: postgresql_37973.nasl 8287 2010-07-05 10:40:56Z mime $
#
# PostgreSQL 'bitsubstr' Buffer Overflow Vulnerability
#
# Authors:
# Michael Meyer
#
# Update By : Antu Sanadi <santu@secpod.com> 2010-02-04 #7085
# Updated the CVE-2010-0442 and version check according to CVE.
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100470);
 script_cve_id("CVE-2010-0442");
 script_bugtraq_id(37973);
 script_version ("1.0-$Revision: 8287 $");
 script_tag(name:"cvss_base", value:"6.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("PostgreSQL 'bitsubstr' Buffer Overflow Vulnerability");
desc = "Overview:
PostgreSQL is prone to a buffer-overflow vulnerability because the
application fails to perform adequate boundary checks on user-
supplied data.

Attackers can exploit this issue to execute arbitrary code with
elevated privileges or crash the affected application.

PostgreSQL version 8.0.x, 8.1.x, 8.3.x is vulnerable; other versions may also be affected.

References:
http://www.postgresql.org/
http://www.securityfocus.com/bid/37973
http://xforce.iss.net/xforce/xfdb/55902
http://intevydis.blogspot.com/2010/01/postgresql-8023-bitsubstr-overflow.html

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if PostgreSQL version");
 script_category(ACT_GATHER_INFO);
 script_family("Databases");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencie("postgresql_detect.nasl");
 script_require_ports("Services/postgresql", 5432);
 exit(0);
}

include("version_func.inc");
include("misc_func.inc");

port = get_kb_item("Services/postgresql");

if(!port)port = 5432;

if(!get_tcp_port_state(port))exit(0);

if(!ver = get_kb_list(string("PostgreSQL/Remote/", port, "/Ver")))exit(0);

if(version_in_range(version:ver, test_version:"8.0", test_version2:"8.0.23") ||
   version_in_range(version:ver, test_version:"8.1", test_version2:"8.1.11") ||
   version_in_range(version:ver, test_version:"8.3", test_version2:"8.3.8")){
  security_warning(port:port);
  exit(0);
}

exit(0);
