###############################################################################
# OpenVAS Vulnerability Test
# $Id: php_restriction_bypass.nasl 8287 2010-07-05 10:40:56Z mime $
#
# PHP multiple Restriction-Bypass Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100281);
 script_bugtraq_id(36555,36554);
 script_version ("1.0-$Revision: 8287 $");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");

 script_name("PHP multiple Restriction-Bypass Vulnerabilities");

desc = "Overview:
PHP is prone to a 'safe_mode' and to a 'open_basedir'
restriction-bypass vulnerability. Successful exploits could allow an
attacker to access files in unauthorized locations or create files in
any writable directory and in unauthorized locations.

This vulnerability would be an issue in shared-hosting configurations
where multiple users can create and execute arbitrary PHP script code;
the 'safe_mode' and the 'open_basedir' restrictions are assumed to
isolate users from each other.

PHP 5.2.11 and 5.3.0 are vulnerable; other versions may also be
affected.

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/36555
http://www.securityfocus.com/bid/36554
http://svn.php.net/viewvc/php/php-src/branches/PHP_5_2/ext/standard/file.c?view=log
http://svn.php.net/viewvc/php/php-src/branches/PHP_5_3/ext/standard/file.c?view=log
http://svn.php.net/viewvc/php/php-src/branches/PHP_5_2/ext/posix/posix.c?view=log
http://svn.php.net/viewvc/php/php-src/branches/PHP_5_3/ext/posix/posix.c?view=log
http://securityreason.com/securityalert/6601
http://securityreason.com/securityalert/6600
http://www.php.net

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if php version is 5.3.0 or 5.2.11");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("gb_php_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("version_func.inc");

phpPort = get_kb_item("Services/www");
if(!phpPort){
  exit(0);
}

phpVer = get_kb_item("www/" + phpPort + "/PHP");
if(!phpVer){
  exit(0);
}

if(version_is_equal(version:phpVer, test_version:"5.2.11") ||
   version_is_equal(version:phpVer, test_version:"5.3.0")) {

   security_warning(port:phpPort);
   exit(0);
}

exit(0);
