###############################################################################
# OpenVAS Vulnerability Test
# $Id: firestats_35367.nasl 8131 2010-06-22 12:20:06Z mime $
#
# FireStats 'firestats-wordpress.php' Remote File Include
# Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100227);
 script_bugtraq_id(35367);
 script_version ("1.0");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");

 script_name("FireStats 'firestats-wordpress.php' Remote File Include Vulnerability");
 desc = "

 Overview:
  FireStats is prone to a remote file-include vulnerability because it
  fails to sufficiently sanitize user-supplied data.

  Exploiting this issue may allow an attacker to compromise the
  application and the underlying system; other attacks are also
  possible.

  FireStats 1.6.1 is vulnerable; prior versions may also be affected. 

 Solution:
  The vendor has released 'FireStats 1.6.2' to address this issue. See
  http://firestats.cc/ for more information.

 See also:
  http://www.securityfocus.com/bid/35367

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if FireStats version < 1.6.2");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("firestats_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

if(!version = get_kb_item(string("www/", port, "/FireStats")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

version  = matches[1];

if( ! isnull(version)) {

  if(version_is_less(version: version, test_version: "1.6.2")) {

    security_warning(port: port);
    exit(0);

  }  

}  

exit(0);
