# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1913-1 (bugzilla)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66096);
 script_cve_id("CVE-2009-3165");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1913-1 (bugzilla)");

 desc = "The remote host is missing an update to bugzilla
announced via advisory DSA 1913-1.

Max Kanat-Alexander, Bradley Baetz, and Frdric Buclin discovered an SQL
injection vulnerability in the Bug.create WebService function in Bugzilla, a
web-based bug tracking system, which allows remote attackers to execute
arbitrary SQL commands.


For the stable distribution (lenny), this problem has been fixed in version
3.0.4.1-2+lenny2.

The oldstable distribution (etch) isn't affected by this problem.

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem will be fixed soon.


We recommend that you upgrade your bugzilla packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201913-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1913-1 (bugzilla)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bugzilla3", ver:"3.0.4.1-2+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bugzilla3-doc", ver:"3.0.4.1-2+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
