##################################################################################
#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 03 $
#
# Modified to implement through 'smb_nt.inc'
#  - By Sharath S <sharaths@secpod.com> On 2009-09-17
#
###############################################################################

if(description)
{
  script_id(90013);
  script_version ("$Revision: 03 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2008-1238", "CVE-2008-1240", "CVE-2008-1241");
  script_bugtraq_id(28448);
  script_name("Mozilla Firefox, Thunderbird, Seamonkey. Several vulnerabilitys (Win)");
  desc = "
  The remote host is probable affected by the vulnerabilities described in
  CVE-2008-0416, CVE-2007-4879, CVE-2008-1195, CVE-2008-1233,
  CVE-2008-1234, CVE-2008-1235, CVE-2008-1236, CVE-2008-1237,
  CVE-2008-1238, CVE-2008-1240, CVE-2008-1241 and more.

  Impact:
  Mozilla contributors moz_bug_r_a4, Boris Zbarsky, and Johnny Stenback reported
  a series of vulnerabilities which allow scripts from page content to run with
  elevated privileges. moz_bug_r_a4 demonstrated additional variants of MFSA
  2007-25 and MFSA2007-35 (arbitrary code execution through XPCNativeWrapper
  pollution). Additional vulnerabilities reported separately by Boris Zbarsky,
  Johnny Stenback, and moz_bug_r_a4 showed that the browser could be forced to
  run JavaScript code using the wrong principal leading to universal XSS
  and arbitrary code execution.

  References:
  http://www.mozilla.org/security/announce/2008/mfsa2008-14.html
  http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0412
  http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0416
  http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1238
  http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1240
  http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1241

  Solution:
  All Users should upgrade to the latest versions of Firefox, Thunderbird or
  Seamonkey.
  http://www.mozilla.com/en-US/firefox/all.html
  http://www.seamonkey-project.org/releases/
  http://www.mozillamessaging.com/en-US/thunderbird/all.html

  Risk factor : High";

  script_description(desc);
  script_summary("Mozilla Firefox, Thunderbird, Seamonkey. Several vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is under GPLv2");
  script_family("General");
  script_dependencies("gb_firefox_detect_win.nasl", "gb_seamonkey_detect_win.nasl",
                      "gb_thunderbird_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver", "Seamonkey/Win/Ver",
                      "Thunderbird/Win/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");

# Firefox Check
ffVer = get_kb_item("Firefox/Win/Ver");
if(ffVer)
{
  # Grep for Firefox version < 2.0.0.14
  if(version_is_less(version:ffVer, test_version:"2.0.0.14"))
  {
    security_hole(0);
    exit(0);
  }
}

# Seamonkey Check
smVer = get_kb_item("Seamonkey/Win/Ver");
if(smVer)
{
  # Grep for Seamonkey version < 1.1.9
  if(version_is_less(version:smVer, test_version:"1.1.9"))
  {
    security_hole(0);
    exit(0);
  }
}

# Thunderbird Check
tbVer = get_kb_item("Thunderbird/Win/Ver");
if(tbVer)
{
  # Grep for Thunderbird version < 2.0.0.14
  if(version_is_less(version:tbVer, test_version:"2.0.0.14")){
    security_hole(0);
  }
}
