##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_sun_virtualbox_detect_lin.nasl 5287 2009-11-18 09:52:37Z nov $
#
# Sun VirtualBox Version Detection (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901051);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Sun VirtualBox Version Detection (Linux)");
  desc = "
  Overview: This script detects installed version of Sun VirtualBox and
  sets the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set KB for the version of Sun VirtualBox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

getPath = find_bin(prog_name:"VBoxManage", sock:sock);
foreach binaryFile (getPath)
{
  vbVer = get_bin_version(full_prog_name:chomp(binaryFile), sock:sock,
                          version_argv:"--version",
                          ver_pattern:"([0-9.]+([a-z0-9]+)?)");
  if(vbVer[1] != NULL)
  {
    vbVer = ereg_replace(pattern:"([a-z])", string:vbVer[1], replace:".");
    if(vbVer){
      set_kb_item(name:"Sun/VirtualBox/Lin/Ver", value:vbVer);
      security_note(data:"Sun VirtualBox version " + vbVer + " running at " +
                         "location " + binaryFile +
                         " was detected on the host");
    }
  }
}
ssh_close_connection();
