###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# OpenCart Detection
#
# Authors:
# Michael Meyer
#
# Updated By : Sooraj KS <kssooraj@secpod.com> on 2010-06-15
#    Added code for detecting version from /admin/index.php
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "

 Overview:
  This host is running OpenCart, an open source PHP-based online
  shopping cart system.

 See also:
  http://www.opencart.com/

 Risk factor : None";

if (description)
{
 script_id(100178);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"None");

 script_name("OpenCart Detection");

 script_description(desc);
 script_summary("Checks for the presence of OpenCart");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dirs = make_list("/shop","/store","/opencart",cgi_dirs());
foreach dir (dirs) {

 url = string(dir, "/index.php");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
 if( buf == NULL )continue;

 if(
    (egrep(pattern: "Powered By <a [^>]+>OpenCart", string: buf, icase: TRUE) ||
     egrep(pattern: "<title>.* \(Powered By OpenCart\)</title>", string: buf, icase: TRUE)) &&
     egrep(pattern: 'Set-Cookie: language=', string: buf, icase: TRUE) )
 {
     if(strlen(dir)>0) {
        install=dir;
     } else {
        install=string("/");
     }

    vers = string("unknown");

    ## Send and Recieve the response
    sndReq = http_get(item:string(dir, "/admin/index.php"), port:port);
    rcvRes = http_keepalive_send_recv(port:port, data:sndReq);

    ## Try to get the version
    cartVer = eregmatch(pattern:">Version ([0-9.]+)<", string:rcvRes);
    if(cartVer[1]) {
      vers = cartVer[1];
    }

    set_kb_item(name: string("www/", port, "/opencart"), value: string(vers, " under ", install));

    info = string("None\n\nOpenCart Version ");
    info += string(vers);
    info += string(" was detected on the remote host in the following directory(s):\n\n");
    info += string(install, "\n");

    desc = ereg_replace(
        string:desc,
        pattern:"None$",
        replace:info
    );

       if(report_verbosity > 0) {
         security_note(port:port,data:desc);
       }
 }
}
exit(0);
