###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_yahoo_msg_actvx_ctrl_dos_vuln.nasl 6032 2009-12-05 13:33:29Z dec $
#
# Yahoo! Messenger 'YahooBridgeLib.dll' ActiveX Control DOS Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801150);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-4171");
  script_bugtraq_id(37007);
  script_name("Yahoo! Messenger 'YahooBridgeLib.dll' ActiveX Control DOS Vulnerability");
  desc = "
  Overview: This host is installed with Yahoo! Messenger and is prone to Denial
  of Service Vulnerability.

  Vulnerability Insight:
  The flaw is due to a NULL pointer dereference error in 'RegisterMe()' method
  in 'YahooBridgeLib.dll', which can be exploited by causing victim to visit a
  specially crafted Web page.

  Impact:
  Successful exploitation will let the remote attackers to cause Denial of
  Service condition on the affected applicaion.

  Impact Level: Application

  Affected Software/OS:
  Yahoo! Messenger version 9.x to 9.0.0.2162 on Windows.

  Fix: Upgrade to Yahoo! Messenger version 10.0.0.1270 or later
  For updates refer, http://messenger.yahoo.com/download/

  References:
  http://xforce.iss.net/xforce/xfdb/54263
  http://www.securityfocus.com/archive/1/archive/1/507818/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Yahoo! Messenger");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_yahoo_msg_detect.nasl", "yahoo_msg_running.nasl");
  script_require_keys("YahooMessenger/Ver");
  script_require_ports("Services/yahoo_messenger");
  exit(0);
}


include("version_func.inc");

ymsgPort = get_kb_item("Services/yahoo_messenger");
if(!ymsgPort){
  ymsgPort = 5101;
}

if(!get_port_state(ymsgPort)){
  exit(0);
}

ymsgVer = get_kb_item("YahooMessenger/Ver");
if(!ymsgVer){
  exit(0);
}

# Check for Yahoo! Messenger version 9.x to 9.0.0.2162
if(version_in_range(version:ymsgVer, test_version:"9.0", test_version2:"9.0.0.2162")){
  security_warning(ymsgPort);
}
