###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ibm_db2_info_disc_vuln_lin.nasl 1465 2009-05-05 17:10:24Z may $
#
# IBM DB2 Information Disclosure Vulnerability (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800703);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1239");
  script_bugtraq_id(34650);
  script_name("IBM DB2 Information Disclosure Vulnerability (Linux)");
  desc = "

  Overview: This host is installed with IBM DB2 and is prone to Information
  Disclosure Vulnerability.

  Vulnerability Insight:
  This flaw is due to the 'INNER JOIN' and 'OUTER JOIN' predicate which allows
  remote attackers to execute arbitrary queries.

  Impact:
  Successful exploitation will let the attacker gain sensitive information of
  the affected remote system.

  Impact Level: Application/System

  Affected Software/OS:
  IBM DB2 Enterprise Server 9.1 before 9.1 FP7.
  IBM DB2 Workgroup Server 9.1 before 9.1 FP7.
  IBM DB2 Express Server 9.1 before 9.1 FP7.
  IBM DB2 Personal Server 9.1 before 9.1 FP7.
  IBM DB2 Connect Server 9.1 before 9.1 FP7.

  Fix: Apply the security update.
  http://www-01.ibm.com/support/docview.wss?rs=0&uid=swg24022678

  *****
  NOTE: Please, ignore the warning if Patch is already applied.
  *****

  References:
  http://xforce.iss.net/xforce/xfdb/49864
  http://www.vupen.com/english/advisories/2009/0912
  http://www-01.ibm.com/support/docview.wss?uid=swg21381257

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of IBM DB2 Servers");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("secpod_ibm_db2_detect_linux_900217.nasl");
  script_require_keys("Linux/IBM_db2/Ver");
  exit(0);
}


include("version_func.inc");

appVer = get_kb_item("Linux/IBM_db2/Ver");
if(appVer == NULL){
  exit(0);
}

# Check for IBM DB2 Server Products Version 9.1 before 9.1 FP7 (9.1.0.7)
# version 9.1 FP6 => 9.1.0.6
if(version_in_range(version:appVer, test_version:"9.1", test_version2:"9.1.0.6")){
  security_warning(0);
}
