###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_argosoft_ftp_38756.nasl 7370 2010-04-20 14:29:03Z chandra $
#
# ArGoSoft FTP Server .NET Directory Traversal Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100539);
 script_bugtraq_id(38756);
 script_version ("1.0-$Revision: 7370 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("ArGoSoft FTP Server .NET Directory Traversal Vulnerability");

desc = "Overview:
ArGoSoft FTP Server .NET is prone to a directory-traversal
vulnerability because it fails to sufficiently sanitize user-
supplied input.

Exploiting this issue can allow an attacker to upload and download
arbitrary files outside of the FTP server root directory. This could
help the attacker launch further attacks.

ArGoSoft FTP Server .NET 1.0.2.1 is vulnerable; other versions may
also be affected.

References:
http://www.securityfocus.com/bid/38756
http://www.argosoft.com/rootpages/FtpServerNet/Default.aspx

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if ArGoSoft FTP Server version is 1.0.2.1");
 script_category(ACT_GATHER_INFO);
 script_family("FTP");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes","secpod_ftp_anonymous.nasl","ftpserver_detect_type_nd_version.nasl");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

include("ftp_func.inc");
include("version_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

if(get_kb_item('ftp/'+port+'/broken'))exit(0);

if(!get_port_state(ftpPort)){
  exit(0);
}

banner = get_ftp_banner(port: ftpPort);  
if(!banner || "ArGoSoft" >!< banner)exit(0);     

version = eregmatch(pattern: "v.([0-9.]+)", string:banner);
if(isnull(version[1]))exit(0);

if(version_is_equal(version: version[1], test_version: "1.0.2.1")) {
  security_warning(port: ftpPort);
  exit(0);
}

exit(0);
