# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-11062 (cups)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66435);
 script_cve_id("CVE-2009-2820", "CVE-2008-5183", "CVE-2008-5286", "CVE-2008-1722");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 10 FEDORA-2009-11062 (cups)");

 desc = "The remote host is missing an update to cups
announced via advisory FEDORA-2009-11062.

Update Information:

This fixes CVE-2009-2820, an XSS vulnerability in the web interface.    This
also updates cups to the latest stable release on the 1.3 branch, and fixes a
problem with number-up handling.

ChangeLog:

* Tue Nov 10 2009 Tim Waugh  1:1.3.11-2
- Added fix for CVE-2009-2820 (bug #529833).
* Tue Nov  3 2009 Tim Waugh  1:1.3.11-1
- 1.3.11.
* Tue Nov  3 2009 Tim Waugh  1:1.3.10-7
- Removed stale patch from STR #2831 which was causing problems with
number-up (bug #532516).

References:

[ 1 ] Bug #529833 - CVE-2009-2820 cups: Several XSS flaws in forms processed by CUPS web interface
https://bugzilla.redhat.com/show_bug.cgi?id=529833

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update cups' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-11062

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-11062 (cups)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"cups", rpm:"cups~1.3.11~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.3.11~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.3.11~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-lpd", rpm:"cups-lpd~1.3.11~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-php", rpm:"cups-php~1.3.11~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-debuginfo", rpm:"cups-debuginfo~1.3.11~2.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
