# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 659-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53492);
 script_cve_id("CVE-2004-1340", "CVE-2005-0108");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 659-1 (libpam-radius-auth)";
 script_name(name);

 desc = "The remote host is missing an update to libpam-radius-auth
announced via advisory DSA 659-1.

Two problems have been discovered in the libpam-radius-auth package,
the PAM RADIUS authentication module.  The Common Vulnerabilities and
Exposures Project identifies the following problems:

CVE-2004-1340

The Debian package accidently installed its configuration file
/etc/pam_radius_auth.conf world-readable.  Since it may possibly
contain secrets all local users are able to read them if the
administrator hasn't adjusted file permissions.  This problem is
Debian specific.

CVE-2005-0108

Leon Juranic discoverd an integer underflow in the mod_auth_radius
module for Apache which is also present in libpam-radius-auth.

For the stable distribution (woody) these problems have been fixed in
version 1.3.14-1.3.

For the unstable distribution (sid) these problems have been fixed in
version 1.3.16-3.

We recommend that you upgrade your libpam-radius-auth package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20659-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 659-1 (libpam-radius-auth)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libpam-radius-auth", ver:"1.3.14-1.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
