# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1936-1 (libgd2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66296);
 script_cve_id("CVE-2007-0455", "CVE-2009-3546");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1936-1 (libgd2)");

 desc = "The remote host is missing an update to libgd2
announced via advisory DSA 1936-1.

Several vulnerabilities have been discovered in libgd2, a library for
programmatic graphics creation and manipulation. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2007-0455

Kees Cook discovered a buffer overflow in libgd2's font renderer. An
attacker could cause denial of service (application crash) and
possibly execute arbitrary code via a crafted string with a JIS
encoded font. This issue only affects the oldstable distribution
(etch).

CVE-2009-3546

Tomas Hoger discovered a boundary error in the _gdGetColors()
function. An attacker could conduct a buffer overflow or buffer
over-read attacks via a crafted GD file.

For the oldstable distribution (etch), these problems have been fixed in
version 2.0.33-5.2etch2.

For the stable distribution (lenny), these problems have been fixed in
version 2.0.36~rc1~dfsg-3+lenny1.

For the upcoming stable distribution (squeeze) and the unstable
distribution ion (sid), these problems have been fixed in version
2.0.36~rc1~dfsg-3.1.

We recommend that you upgrade your libgd2 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201936-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1936-1 (libgd2)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libgd2-noxpm", ver:"2.0.33-5.2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgd2-xpm", ver:"2.0.33-5.2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgd-tools", ver:"2.0.33-5.2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgd2-xpm-dev", ver:"2.0.33-5.2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgd2-noxpm-dev", ver:"2.0.33-5.2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgd2-xpm", ver:"2.0.36~rc1~dfsg-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgd2-noxpm", ver:"2.0.36~rc1~dfsg-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgd2-xpm-dev", ver:"2.0.36~rc1~dfsg-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgd2-noxpm-dev", ver:"2.0.36~rc1~dfsg-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgd-tools", ver:"2.0.36~rc1~dfsg-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
