# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1905-1 (python-django)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66052);
 script_version ("$Revision$");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1905-1 (python-django)");

 desc = "The remote host is missing an update to python-django
announced via advisory DSA 1905-1.

The forms library of python-django, a high-level Python web development
framework, is using a badly chosen regular expression when validating
email addresses and URLs.  An attacker can use this to perform denial
of service attacks (100% CPU consumption) due to bad backtracking
via a specially crafted email address or URL which is validated by the
django forms library.


python-django in the oldstable distribution (etch), is not affected by
this problem.

For the stable distribution (lenny), this problem has been fixed in
version 1.0.2-1+lenny2.

For the testing distribution (squeeze), this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 1.1.1-1.


We recommend that you upgrade your python-django packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201905-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1905-1 (python-django)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"python-django", ver:"1.0.2-1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
