# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1685-1 (uw-imap)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(62955);
 script_cve_id("CVE-2008-5005", "CVE-2008-5006");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1685-1 (uw-imap)";
 script_name(name);

 desc = "The remote host is missing an update to uw-imap
announced via advisory DSA 1685-1.

Two vulnerabilities have been found in uw-imap, an IMAP
implementation. The Common Vulnerabilities and Exposures project
identifies the following problems:

It was discovered that several buffer overflows can be triggered via a
long folder extension argument to the tmail or dmail program. This
could lead to arbitrary code execution (CVE-2008-5005).

It was discovered that a NULL pointer dereference could be triggered by
a malicious response to the QUIT command leading to a denial of service
(CVE-2008-5006).

For the stable distribution (etch), these problems have been fixed in
version 2002edebian1-13.1+etch1.

For the unstable distribution (sid) and the testing distribution
(lenny), these problems have been fixed in version 2007d~dfsg-1.

We recommend that you upgrade your uw-imap packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201685-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1685-1 (uw-imap)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ipopd-ssl", ver:"2002edebian1-13.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"uw-imapd-ssl", ver:"2002edebian1-13.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"uw-mailutils", ver:"2002edebian1-13.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc-client2002edebian", ver:"2002edebian1-13.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ipopd", ver:"2002edebian1-13.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mlock", ver:"2002edebian1-13.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"uw-imapd", ver:"2002edebian1-13.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc-client-dev", ver:"2002edebian1-13.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
