# octocatalog-diff v1 API documentation

## API calls

#### catalog

`catalog` allows you to build a catalog using the octocatalog-diff compiler or to obtain a catalog from a Puppet server.

[Read more about the `catalog` call](/doc/dev/api/v1/calls/catalog.md)

#### catalog-diff

`catalog-diff` allows you compare two catalogs and obtain the differences between them. Catalogs can be built if necessary.

[Read more about the `catalog-diff` call](/doc/dev/api/v1/calls/catalog-diff.md)

#### config

`config` allows you read and parse an [octocatalog-diff configuration file](/doc/configuration.md).

[Read more about the `config` call](/doc/dev/api/v1/calls/config.md)

## Objects

#### OctocatalogDiff::API::V1::Catalog

The `OctocatalogDiff::API::V1::Catalog` object represents a compiled catalog and supports several methods to get information about the catalog.

[Read more about the `OctocatalogDiff::API::V1::Catalog` object](/doc/dev/api/v1/objects/catalog.md)

#### OctocatalogDiff::API::V1::Diff

The `OctocatalogDiff::API::V1::Diff` object represents a difference between two catalogs and supports several methods to get information about the difference.

[Read more about the `OctocatalogDiff::API::V1::Diff` object](/doc/dev/api/v1/objects/diff.md)

#### OctocatalogDiff::API::V1::Override

The `OctocatalogDiff::API::V1::Override` object represents a user-supplied fact or ENC parameter that will be used when compiling a catalog.

[Read more about the `OctocatalogDiff::API::V1::Override` object](/doc/dev/api/v1/objects/override.md)
