/*

Copyright (C) 2015 Olaf Till <i7tiol@t-online.de>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; If not, see <http://www.gnu.org/licenses/>.

*/

#include "parallel-gnutls.h"

void sensitive_string::fill (int n, bool lock)
{
  valid = false;

  if (internally_allocated || locked_length)
    {
      error ("internal error in filling");

      return;
    }

  val.data = new unsigned char[n + 1];

  if (val.data)
    {
      internally_allocated = true;

      val.size = n;

      if (lock)
        {
          if (mlock (val.data, n))
            {
              error ("could not lock memory pages");

              return;
            }
          else
            locked_length = n;
        }
    }
  else
    {
      val.size = 0;

      error ("could not allocate memory");

      return;
    }

  int rfd;

  if ((rfd = open ("/dev/random", O_RDONLY)) == -1)
    {
      error ("could not open /dev/random");

      return;
    }

  // reduces each random byte to the 128 characters from 0x20 to 0x9F,
  // in order to disallow value 0x0 (end of string) without unevenly
  // redistributing the probability of the allowed values
  for (int i = 0; i < n; i++)
    {
      if (read (rfd, &(val.data[i]), 1) != 1)
        {
          error ("could not read from /dev/random");

          break;
        }

      val.data[i] = (unsigned char) (((unsigned int) (val.data[i]>>1)) + 0x20);
    }

  val.data[n] = '\0';

  if (close (rfd))
    error ("could not close /dev/random");

  if (! error_state)
    valid = true;
}
