#define VALUE_NOT_FOUND 0xFFFFFFF

static const int64_t SWR_DITHER_TYPE_TAB[][2] = {
  {(2019771531), SWR_DITHER_RECTANGULAR},
  {(618477025), SWR_DITHER_TRIANGULAR},
  {(1572988741), SWR_DITHER_TRIANGULAR_HIGHPASS},
};

#define SWR_DITHER_TYPE_TAB_LEN 3
enum SwrDitherType DitherType_val(value v){
int i;
for(i=0;i<SWR_DITHER_TYPE_TAB_LEN;i++){
if(v==SWR_DITHER_TYPE_TAB[i][0])return SWR_DITHER_TYPE_TAB[i][1];
}
return VALUE_NOT_FOUND;
}
value Val_DitherType(enum SwrDitherType t){
int i;
for(i=0;i<SWR_DITHER_TYPE_TAB_LEN; i++){
if(t==SWR_DITHER_TYPE_TAB[i][1])return SWR_DITHER_TYPE_TAB[i][0];
}
return VALUE_NOT_FOUND;
}
static const int64_t SWR_ENGINE_TAB[][2] = {
  {(-695694749), SWR_ENGINE_SWR},
  {(-521899353), SWR_ENGINE_SOXR},
};

#define SWR_ENGINE_TAB_LEN 2
enum SwrEngine Engine_val(value v){
int i;
for(i=0;i<SWR_ENGINE_TAB_LEN;i++){
if(v==SWR_ENGINE_TAB[i][0])return SWR_ENGINE_TAB[i][1];
}
return VALUE_NOT_FOUND;
}
value Val_Engine(enum SwrEngine t){
int i;
for(i=0;i<SWR_ENGINE_TAB_LEN; i++){
if(t==SWR_ENGINE_TAB[i][1])return SWR_ENGINE_TAB[i][0];
}
return VALUE_NOT_FOUND;
}
static const int64_t SWR_FILTER_TYPE_TAB[][2] = {
  {(2111532569), SWR_FILTER_TYPE_CUBIC},
  {(-903086999), SWR_FILTER_TYPE_BLACKMAN_NUTTALL},
  {(153331415), SWR_FILTER_TYPE_KAISER},
};

#define SWR_FILTER_TYPE_TAB_LEN 3
enum SwrFilterType FilterType_val(value v){
int i;
for(i=0;i<SWR_FILTER_TYPE_TAB_LEN;i++){
if(v==SWR_FILTER_TYPE_TAB[i][0])return SWR_FILTER_TYPE_TAB[i][1];
}
return VALUE_NOT_FOUND;
}
value Val_FilterType(enum SwrFilterType t){
int i;
for(i=0;i<SWR_FILTER_TYPE_TAB_LEN; i++){
if(t==SWR_FILTER_TYPE_TAB[i][1])return SWR_FILTER_TYPE_TAB[i][0];
}
return VALUE_NOT_FOUND;
}
