<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/ebpf.plugin/integrations/ebpf_processes.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/ebpf.plugin/metadata.yaml"
sidebar_label: "eBPF Processes"
learn_status: "Published"
learn_rel_path: "Data Collection/eBPF"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# eBPF Processes


<img src="https://netdata.cloud/img/ebpf.jpg" width="150"/>


Plugin: ebpf.plugin
Module: processes

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitor calls for function creating tasks (threads and processes) inside Linux kernel.

Attach tracing (kprobe or tracepoint, and trampoline) to internal kernel functions.

This collector is only supported on the following platforms:

- Linux

This collector supports collecting metrics from multiple instances of this integration, including remote instances.

The plugin needs setuid because it loads data inside kernel. Netada sets necessary permission during installation time.

### Default Behavior

#### Auto-Detection

The plugin checks kernel compilation flags (CONFIG_KPROBES, CONFIG_BPF, CONFIG_BPF_SYSCALL, CONFIG_BPF_JIT), files inside debugfs, and presence of BTF files to decide which eBPF program will be attached.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

This thread will add overhead every time that an internal kernel function monitored by this thread is called.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per eBPF Processes instance

These metrics show total number of calls to functions inside kernel.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.process_thread | process | calls/s |
| system.process_status | process, zombie | difference |
| system.exit | process | calls/s |
| system.task_error | task | calls/s |

### Per apps

These Metrics show grouped information per apps group.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| apps.process_create | a dimension per app group | calls/s |
| apps.thread_create | a dimension per app group | calls/s |
| apps.task_exit | a dimension per app group | calls/s |
| apps.task_close | a dimension per app group | calls/s |
| apps.task_error | a dimension per app group | calls/s |

### Per cgroup

These Metrics show grouped information per cgroup/service.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| cgroup.process_create | process | calls/s |
| cgroup.thread_create | thread | calls/s |
| cgroup.task_exit | exit | calls/s |
| cgroup.task_close | process | calls/s |
| cgroup.task_error | process | calls/s |
| services.process_create | a dimension per systemd service | calls/s |
| services.thread_create | a dimension per systemd service | calls/s |
| services.task_close | a dimension per systemd service | calls/s |
| services.task_exit | a dimension per systemd service | calls/s |
| services.task_error | a dimension per systemd service | calls/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Compile kernel

Check if your kernel was compiled with necessary options (CONFIG_KPROBES, CONFIG_BPF, CONFIG_BPF_SYSCALL, CONFIG_BPF_JIT) in `/proc/config.gz` or inside /boot/config file. Some cited names can be different accoring preferences of Linux distributions.
When you do not have options set, it is necessary to get the kernel source code from https://kernel.org or a kernel package from your distribution, this last is preferred. The kernel compilation has a well definedd pattern, but distributions can deliver their configuration files
with different names.

Now follow steps:
1. Copy the configuration file to /usr/src/linux/.config.
2. Select the necessary options: make oldconfig
3. Compile your kernel image: make bzImage
4. Compile your modules: make modules
5. Copy your new kernel image for boot loader directory
6. Install the new modules: make modules_install
7. Generate an initial ramdisk image (`initrd`) if it is necessary.
8. Update your boot loader


#### Debug Filesystem

This thread needs to attach a tracepoint to monitor when a process schedule an exit event. To allow this specific feaure, it is necessary to mount `debugfs` (`mount -t debugfs none /sys/kernel/debug/`).



### Configuration

#### File

The configuration file name for this integration is `ebpf.d/process.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config ebpf.d/process.conf
```
#### Options

All options are defined inside section `[global]`.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update every | Data collection frequency. | 5 | False |
| ebpf load mode | Define whether plugin will monitor the call (`entry`) for the functions or it will also monitor the return (`return`). | entry | False |
| apps | Enable or disable integration with apps.plugin | no | False |
| cgroups | Enable or disable integration with cgroup.plugin | no | False |
| pid table size | Number of elements stored inside hash tables used to monitor calls per PID. | 32768 | False |
| ebpf type format | Define the file type to load an eBPF program. Three options are available: `legacy` (Attach only `kprobe`), `co-re` (Plugin tries to use `trampoline` when available), and `auto` (plugin check OS configuration before to load). | auto | False |
| ebpf co-re tracing | Select the attach method used by plugin when `co-re` is defined in previous option. Two options are available: `trampoline` (Option with lowest overhead), and `probe` (the same of legacy code). This plugin will always try to attach a tracepoint, so option here will impact only function used to monitor task (thread and process) creation. | trampoline | False |
| maps per core | Define how plugin will load their hash maps. When enabled (`yes`) plugin will load one hash table per core, instead to have centralized information. | yes | False |
| lifetime | Set default lifetime for thread when enabled by cloud. | 300 | False |

</details>

#### Examples
There are no configuration examples.


