/* 
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _LF_TABLE_H_
#define _LF_TABLE_H_

#include "mforms/table.h"

#include "lf_view.h"
#include <gtkmm/alignment.h>

namespace mforms {
namespace gtk {

class TableImpl : public ViewImpl
{  
protected:
  Gtk::Table *_table;
  Gtk::Alignment *_alignment;
  virtual Gtk::Widget *get_outer() const { return _alignment; }
  virtual Gtk::Widget *get_inner() const { return _table; }
  
  TableImpl(::mforms::Table *self)
    : ViewImpl(self)
  {
    _alignment= new Gtk::Alignment();
    _table= new Gtk::Table();
    _table->show();
    _alignment->add(*_table);
    _alignment->show();
    _alignment->set(0.5, 0.5, 1.0, 1.0);
  }

  virtual ~TableImpl()
  {
    delete _table;
    delete _alignment;
  }

  static bool create(::mforms::Table *self)
  {
    return new TableImpl(self);
  }
  
  
  static void set_row_count(Table *self, int count)
  {
    TableImpl *table= self->get_data<TableImpl>();
    
    table->_table->property_n_rows()= count;
  }


  static void set_col_count(Table *self, int count)
  {
    TableImpl *table= self->get_data<TableImpl>();
    
    table->_table->property_n_columns()= count;
  }


  static void add(Table *self, View *child, int left, int right,
                  int top, int bottom, int flags)
  {
    TableImpl *table= self->get_data<TableImpl>();
    Gtk::AttachOptions roptions= (Gtk::AttachOptions)0, coptions= (Gtk::AttachOptions)0;

    roptions= Gtk::SHRINK;
    coptions= Gtk::SHRINK;
    
    if (flags & mforms::VExpandFlag)
      roptions|= Gtk::EXPAND;
    if (flags & mforms::VFillFlag)
      roptions|= Gtk::FILL;
    
    if (flags & mforms::HExpandFlag)
      coptions|= Gtk::EXPAND;
    if (flags & mforms::HFillFlag)
      coptions|= Gtk::FILL;

    table->_table->attach(*child->get_data<ViewImpl>()->get_outer(), 
                                           left, right, top, bottom,
                                           coptions, roptions);
    child->show();
  }

  static void remove(Table *self, View *child)
  {
    TableImpl *table= self->get_data<TableImpl>();

    table->_table->remove(*child->get_data<ViewImpl>()->get_outer());
  }
  
  static void set_row_spacing(Table *self, int space)
  {
    TableImpl *table= self->get_data<TableImpl>();
    
    table->_table->set_row_spacings(space);
  }


  static void set_col_spacing(Table *self, int space)
  {
    TableImpl *table= self->get_data<TableImpl>();
    
    table->_table->set_col_spacings(space);
  }

  static void set_homogeneous(Table *self, bool flag)
  {
    TableImpl *table= self->get_data<TableImpl>();

    table->_table->set_homogeneous(flag);
  }

  virtual void set_padding_impl(int left, int top, int right, int bottom)
  {
    if (left < 0 && top < 0 && right < 0 && bottom < 0)
    {
      _alignment->set(0.5, 0.5, 0.0, 0.0);
      _table->set_border_width(0);
    }
    else
    {
      _alignment->set(0.5, 0.5, 1.0, 1.0);
      _table->set_border_width(left);
    }
  }

public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_table_impl.create= &TableImpl::create;
    f->_table_impl.set_row_count= &TableImpl::set_row_count;
    f->_table_impl.set_column_count= &TableImpl::set_col_count;
    f->_table_impl.add= &TableImpl::add;
    f->_table_impl.remove= &TableImpl::remove;
    f->_table_impl.set_row_spacing= &TableImpl::set_row_spacing;
    f->_table_impl.set_column_spacing= &TableImpl::set_col_spacing;
    f->_table_impl.set_homogeneous= &TableImpl::set_homogeneous;
  }
};

}
}


#endif /* _LF_TABLE_H_ */
