%define pyver %(%{__python} -c "import sys; print sys.version[:3]")
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}

Name:           morituri
Version:        0.2.0
Release:        1%{?dist}
Summary:        CD ripper
Source:         %{name}-%{version}.tar.bz2
URL:            https://thomas.apestaart.org/morituri/trac/
License:        GPLv3
Group:          Applications/Archiving
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildArch:      noarch

BuildRequires:  pygobject2
BuildRequires:  gstreamer-python
BuildRequires:  python-setuptools

Requires:       cdparanoia
Requires:       cdrdao > 1.2.3-0.rc2.2
Requires:       gstreamer-plugins-good >= 0.10.16
Requires:       gstreamer-python
Requires:       python-musicbrainz2
Requires:       python-CDDB
Requires:       pycdio
Requires:       pyxdg

# we use parse_version in code
Requires:       python-setuptools

%description
Morituri is a CD ripper.

%prep

%setup -q
%configure --sysconfdir=%{_sysconfdir}

%build

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

mkdir -p $RPM_BUILD_ROOT%{_libdir}/morituri/plugins
%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc README morituri.doap NEWS RELEASE ChangeLog
%{_bindir}/rip
%{_libdir}/morituri/plugins
%{_mandir}/man1/rip.1*
%{python_sitelib}/morituri
%{_sysconfdir}/bash_completion.d/

%changelog
* Sun Jan 20 2013 Thomas Vander Stichele <thomas at apestaart dot org>
- Added python-setuptools now that we use it for plugins

* Sun Dec 02 2012 Thomas Vander Stichele <thomas at apestaart dot org>
- Require pyxdg for XDG config file.

* Sun Jan 09 2011 Thomas Vander Stichele <thomas at apestaart dot org>
- Fix URL

* Sun May 23 2010 Thomas Vander Stichele <thomas at apestaart dot org>
- Add python-setuptools requirement

* Sun Sep 06 2009 Thomas Vander Stichele <thomas at apestaart dot org>
- added requires

* Wed May 20 2009 Thomas Vander Stichele <thomas at apestaart dot org>
- created package
