//
// Copyright (c) 2007 Novell, Inc. (http://www.novell.com)
//
// Author:
//	DataGridViewTest.GenerateClipboardTest (true);
//
#if NET_2_0
using NUnit.Framework;
using System;
using System.Drawing;
using System.Windows.Forms;
using System.ComponentModel;
using System.Collections;
using System.Text;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
namespace MonoTests.System.Windows.Forms {
	[TestFixture]
	public class DataGridViewClipboardHeaderTest : TestHelper {
		[Test]
		public void Test () {
			DataObject data;
			DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell row_header_cell;
			DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell col_header_cell;
			string code = null;
			using (DataGridView dgv = DataGridViewCommon.CreateAndFillForClipboard ()) {
				dgv.SelectionMode = DataGridViewSelectionMode.CellSelect;
				dgv.ClipboardCopyMode = DataGridViewClipboardCopyMode.EnableAlwaysIncludeHeaderText;
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, true, "Text") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#0-0");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#0-1");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR></TABLE>", code, "#EnableAlwaysIncludeHeaderText#0-2");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, true, "Csv") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#0-3");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, false, "Text") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-4");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-5");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR>", code, "#EnableAlwaysIncludeHeaderText#0-6");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, false, "Csv") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-7");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, true, "Text") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#0-8");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#0-9");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR></TABLE>", code, "#EnableAlwaysIncludeHeaderText#0-10");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, true, "Csv") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#0-11");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, false, "Text") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-12");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-13");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR>", code, "#EnableAlwaysIncludeHeaderText#0-14");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, false, "Csv") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-15");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, true, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#0-16");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#0-17");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#0-18");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, true, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#0-19");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, false, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#0-20");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, false, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#0-21");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#0-22");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, false, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#0-23");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, true, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#0-24");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#0-25");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#0-26");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, true, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#0-27");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, false, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#0-28");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, false, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#0-29");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#0-30");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, false, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#0-31");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, true, "Text") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#0-32");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#0-33");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR></TABLE>", code, "#EnableAlwaysIncludeHeaderText#0-34");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, true, "Csv") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#0-35");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, false, "Text") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-36");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-37");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR>", code, "#EnableAlwaysIncludeHeaderText#0-38");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, false, "Csv") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-39");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, true, "Text") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#0-40");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#0-41");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR></TABLE>", code, "#EnableAlwaysIncludeHeaderText#0-42");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, true, "Csv") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#0-43");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, false, "Text") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-44");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-45");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR>", code, "#EnableAlwaysIncludeHeaderText#0-46");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, false, "Csv") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-47");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, true, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#0-48");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#0-49");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#0-50");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, true, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#0-51");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, false, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#0-52");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, false, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#0-53");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#0-54");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, false, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#0-55");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, true, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#0-56");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#0-57");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#0-58");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, true, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#0-59");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, false, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#0-60");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, false, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#0-61");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#0-62");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, false, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#0-63");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, true, "Text") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#0-64");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, true, "UnicodeText") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#0-65");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH></THEAD></TABLE>", code, "#EnableAlwaysIncludeHeaderText#0-66");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, true, "Csv") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#0-67");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, false, "Text") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-68");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-69");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH></THEAD>", code, "#EnableAlwaysIncludeHeaderText#0-70");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, false, "Csv") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-71");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, true, "Text") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#0-72");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, true, "UnicodeText") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#0-73");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH></THEAD></TABLE>", code, "#EnableAlwaysIncludeHeaderText#0-74");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, true, "Csv") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#0-75");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, false, "Text") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-76");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-77");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH></THEAD>", code, "#EnableAlwaysIncludeHeaderText#0-78");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, false, "Csv") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-79");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, true, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#0-80");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, true, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#0-81");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#0-82");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, true, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#0-83");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, false, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#0-84");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, false, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#0-85");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#0-86");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, false, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#0-87");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, true, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#0-88");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, true, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#0-89");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#0-90");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, true, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#0-91");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, false, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#0-92");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, false, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#0-93");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#0-94");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, false, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#0-95");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, true, "Text") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#0-96");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, true, "UnicodeText") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#0-97");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH></THEAD></TABLE>", code, "#EnableAlwaysIncludeHeaderText#0-98");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, true, "Csv") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#0-99");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, false, "Text") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-100");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-101");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH></THEAD>", code, "#EnableAlwaysIncludeHeaderText#0-102");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, false, "Csv") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-103");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, true, "Text") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#0-104");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, true, "UnicodeText") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#0-105");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH></THEAD></TABLE>", code, "#EnableAlwaysIncludeHeaderText#0-106");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, true, "Csv") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#0-107");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, false, "Text") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-108");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-109");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH></THEAD>", code, "#EnableAlwaysIncludeHeaderText#0-110");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, false, "Csv") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#0-111");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, true, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#0-112");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, true, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#0-113");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#0-114");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, true, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#0-115");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, false, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#0-116");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, false, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#0-117");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#0-118");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, false, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#0-119");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, true, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#0-120");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, true, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#0-121");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#0-122");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, true, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#0-123");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, false, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#0-124");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, false, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#0-125");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#0-126");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, false, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#0-127");
			}
			using (DataGridView dgv = DataGridViewCommon.CreateAndFillForClipboard ()) {
				dgv.SelectionMode = DataGridViewSelectionMode.CellSelect;
				dgv.ClipboardCopyMode = DataGridViewClipboardCopyMode.EnableAlwaysIncludeHeaderText;
				dgv.Rows [0].Cells [0].Selected = true;
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, true, "Text") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#1-0");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#1-1");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR></TABLE>", code, "#EnableAlwaysIncludeHeaderText#1-2");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, true, "Csv") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#1-3");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, false, "Text") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-4");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-5");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR>", code, "#EnableAlwaysIncludeHeaderText#1-6");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, false, "Csv") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-7");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, true, "Text") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#1-8");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#1-9");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR></TABLE>", code, "#EnableAlwaysIncludeHeaderText#1-10");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, true, "Csv") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#1-11");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, false, "Text") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-12");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-13");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR>", code, "#EnableAlwaysIncludeHeaderText#1-14");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, false, "Csv") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-15");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, true, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#1-16");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#1-17");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#1-18");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, true, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#1-19");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, false, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#1-20");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, false, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#1-21");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#1-22");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, false, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#1-23");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, true, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#1-24");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#1-25");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#1-26");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, true, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#1-27");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, false, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#1-28");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, false, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#1-29");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#1-30");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, false, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#1-31");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, true, "Text") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#1-32");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#1-33");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR></TABLE>", code, "#EnableAlwaysIncludeHeaderText#1-34");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, true, "Csv") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#1-35");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, false, "Text") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-36");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-37");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR>", code, "#EnableAlwaysIncludeHeaderText#1-38");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, false, "Csv") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-39");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, true, "Text") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#1-40");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#1-41");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR></TABLE>", code, "#EnableAlwaysIncludeHeaderText#1-42");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, true, "Csv") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#1-43");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, false, "Text") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-44");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-45");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR>", code, "#EnableAlwaysIncludeHeaderText#1-46");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, false, "Csv") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-47");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, true, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#1-48");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#1-49");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#1-50");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, true, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#1-51");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, false, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#1-52");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, false, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#1-53");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#1-54");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, false, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#1-55");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, true, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#1-56");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#1-57");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#1-58");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, true, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#1-59");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, false, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#1-60");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, false, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#1-61");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#1-62");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, false, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#1-63");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, true, "Text") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#1-64");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, true, "UnicodeText") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#1-65");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH></THEAD></TABLE>", code, "#EnableAlwaysIncludeHeaderText#1-66");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, true, "Csv") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#1-67");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, false, "Text") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-68");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-69");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH></THEAD>", code, "#EnableAlwaysIncludeHeaderText#1-70");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, false, "Csv") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-71");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, true, "Text") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#1-72");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, true, "UnicodeText") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#1-73");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH></THEAD></TABLE>", code, "#EnableAlwaysIncludeHeaderText#1-74");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, true, "Csv") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#1-75");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, false, "Text") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-76");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-77");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH></THEAD>", code, "#EnableAlwaysIncludeHeaderText#1-78");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, false, "Csv") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-79");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, true, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#1-80");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, true, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#1-81");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#1-82");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, true, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#1-83");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, false, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#1-84");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, false, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#1-85");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#1-86");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, false, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#1-87");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, true, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#1-88");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, true, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#1-89");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#1-90");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, true, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#1-91");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, false, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#1-92");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, false, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#1-93");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#1-94");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, false, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#1-95");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, true, "Text") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#1-96");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, true, "UnicodeText") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#1-97");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH></THEAD></TABLE>", code, "#EnableAlwaysIncludeHeaderText#1-98");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, true, "Csv") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#1-99");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, false, "Text") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-100");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-101");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH></THEAD>", code, "#EnableAlwaysIncludeHeaderText#1-102");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, false, "Csv") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-103");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, true, "Text") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#1-104");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, true, "UnicodeText") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#1-105");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH></THEAD></TABLE>", code, "#EnableAlwaysIncludeHeaderText#1-106");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, true, "Csv") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#1-107");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, false, "Text") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-108");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-109");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH></THEAD>", code, "#EnableAlwaysIncludeHeaderText#1-110");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, false, "Csv") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#1-111");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, true, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#1-112");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, true, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#1-113");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#1-114");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, true, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#1-115");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, false, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#1-116");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, false, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#1-117");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#1-118");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, false, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#1-119");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, true, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#1-120");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, true, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#1-121");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#1-122");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, true, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#1-123");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, false, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#1-124");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, false, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#1-125");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#1-126");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, false, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#1-127");
			}
			using (DataGridView dgv = DataGridViewCommon.CreateAndFillForClipboard ()) {
				dgv.SelectionMode = DataGridViewSelectionMode.CellSelect;
				dgv.ClipboardCopyMode = DataGridViewClipboardCopyMode.EnableAlwaysIncludeHeaderText;
				dgv.Rows [2].Cells [2].Selected = true;
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, true, "Text") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#2-0");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#2-1");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR></TABLE>", code, "#EnableAlwaysIncludeHeaderText#2-2");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, true, "Csv") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#2-3");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, false, "Text") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-4");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-5");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR>", code, "#EnableAlwaysIncludeHeaderText#2-6");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, true, false, "Csv") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-7");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, true, "Text") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#2-8");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#2-9");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR></TABLE>", code, "#EnableAlwaysIncludeHeaderText#2-10");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, true, "Csv") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#2-11");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, false, "Text") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-12");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-13");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR>", code, "#EnableAlwaysIncludeHeaderText#2-14");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, true, false, false, "Csv") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-15");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, true, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#2-16");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#2-17");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#2-18");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, true, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#2-19");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, false, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#2-20");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, false, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#2-21");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#2-22");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, true, false, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#2-23");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, true, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#2-24");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#2-25");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#2-26");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, true, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#2-27");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, false, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#2-28");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, false, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#2-29");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#2-30");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, true, false, false, false, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#2-31");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, true, "Text") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#2-32");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#2-33");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR></TABLE>", code, "#EnableAlwaysIncludeHeaderText#2-34");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, true, "Csv") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#2-35");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, false, "Text") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-36");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-37");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR>", code, "#EnableAlwaysIncludeHeaderText#2-38");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, true, false, "Csv") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-39");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, true, "Text") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#2-40");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#2-41");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR></TABLE>", code, "#EnableAlwaysIncludeHeaderText#2-42");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, true, "Csv") as string;
				Assert.AreEqual ("Row#1", code, "#EnableAlwaysIncludeHeaderText#2-43");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, false, "Text") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-44");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-45");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD></TR>", code, "#EnableAlwaysIncludeHeaderText#2-46");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, true, false, false, "Csv") as string;
				Assert.AreEqual (string.Format ("Row#1{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-47");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, true, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#2-48");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#2-49");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#2-50");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, true, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#2-51");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, false, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#2-52");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, false, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#2-53");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#2-54");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, true, false, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#2-55");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, true, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#2-56");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, true, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#2-57");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#2-58");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, true, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#2-59");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, false, "Text") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#2-60");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, false, "UnicodeText") as string;
				Assert.AreEqual ("Row#1\t", code, "#EnableAlwaysIncludeHeaderText#2-61");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TR><TD ALIGN=\"center\"><B>Row#1</B></TD>", code, "#EnableAlwaysIncludeHeaderText#2-62");
				row_header_cell = dgv.Rows [0].HeaderCell as DataGridViewRowHeaderTest.DataGridViewRowHeaderClipboardCell;
				code = row_header_cell.GetClipboardContentPublic (0, false, false, false, false, "Csv") as string;
				Assert.AreEqual ("Row#1,", code, "#EnableAlwaysIncludeHeaderText#2-63");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, true, "Text") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#2-64");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, true, "UnicodeText") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#2-65");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH></THEAD></TABLE>", code, "#EnableAlwaysIncludeHeaderText#2-66");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, true, "Csv") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#2-67");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, false, "Text") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-68");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-69");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH></THEAD>", code, "#EnableAlwaysIncludeHeaderText#2-70");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, true, false, "Csv") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-71");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, true, "Text") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#2-72");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, true, "UnicodeText") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#2-73");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH></THEAD></TABLE>", code, "#EnableAlwaysIncludeHeaderText#2-74");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, true, "Csv") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#2-75");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, false, "Text") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-76");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-77");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH></THEAD>", code, "#EnableAlwaysIncludeHeaderText#2-78");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, true, false, false, "Csv") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-79");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, true, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#2-80");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, true, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#2-81");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#2-82");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, true, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#2-83");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, false, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#2-84");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, false, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#2-85");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#2-86");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, true, false, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#2-87");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, true, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#2-88");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, true, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#2-89");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#2-90");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, true, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#2-91");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, false, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#2-92");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, false, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#2-93");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TABLE><THEAD><TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#2-94");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, true, false, false, false, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#2-95");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, true, "Text") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#2-96");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, true, "UnicodeText") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#2-97");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH></THEAD></TABLE>", code, "#EnableAlwaysIncludeHeaderText#2-98");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, true, "Csv") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#2-99");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, false, "Text") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-100");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-101");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH></THEAD>", code, "#EnableAlwaysIncludeHeaderText#2-102");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, true, false, "Csv") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-103");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, true, "Text") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#2-104");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, true, "UnicodeText") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#2-105");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH></THEAD></TABLE>", code, "#EnableAlwaysIncludeHeaderText#2-106");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, true, "Csv") as string;
				Assert.AreEqual ("A", code, "#EnableAlwaysIncludeHeaderText#2-107");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, false, "Text") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-108");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, false, "UnicodeText") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-109");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH></THEAD>", code, "#EnableAlwaysIncludeHeaderText#2-110");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, true, false, false, "Csv") as string;
				Assert.AreEqual (string.Format ("A{0}", Environment.NewLine), code, "#EnableAlwaysIncludeHeaderText#2-111");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, true, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#2-112");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, true, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#2-113");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, true, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#2-114");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, true, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#2-115");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, false, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#2-116");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, false, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#2-117");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, false, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#2-118");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, true, false, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#2-119");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, true, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#2-120");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, true, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#2-121");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, true, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#2-122");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, true, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#2-123");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, false, "Text") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#2-124");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, false, "UnicodeText") as string;
				Assert.AreEqual ("A\t", code, "#EnableAlwaysIncludeHeaderText#2-125");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, false, "HTML Format") as string;
				Assert.AreEqual ("<TH>A</TH>", code, "#EnableAlwaysIncludeHeaderText#2-126");
				col_header_cell = dgv.Columns [0].HeaderCell as DataGridViewColumnHeaderTest.DataGridViewColumnHeaderClipboardCell;
				code = col_header_cell.GetClipboardContentPublic (-1, false, false, false, false, "Csv") as string;
				Assert.AreEqual ("A,", code, "#EnableAlwaysIncludeHeaderText#2-127");
			}
		}
	}
}
#endif
