"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class PowerMon(google.protobuf.message.Message):
    """Note: There are no 'PowerMon' messages normally in use (PowerMons are sent only as structured logs - slogs).
    But we wrap our State enum in this message to effectively nest a namespace (without our linter yelling at us)
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _State:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PowerMon._State.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        CPU_DeepSleep: PowerMon._State.ValueType  # 1
        CPU_LightSleep: PowerMon._State.ValueType  # 2
        Vext1_On: PowerMon._State.ValueType  # 4
        """
        The external Vext1 power is on.  Many boards have auxillary power rails that the CPU turns on only
        occasionally.  In cases where that rail has multiple devices on it we usually want to have logging on
        the state of that rail as an independent record.
        For instance on the Heltec Tracker 1.1 board, this rail is the power source for the GPS and screen.

        The log messages will be short and complete (see PowerMon.Event in the protobufs for details).
        something like "S:PM:C,0x00001234,REASON" where the hex number is the bitmask of all current states.
        (We use a bitmask for states so that if a log message gets lost it won't be fatal)
        """
        Lora_RXOn: PowerMon._State.ValueType  # 8
        Lora_TXOn: PowerMon._State.ValueType  # 16
        Lora_RXActive: PowerMon._State.ValueType  # 32
        BT_On: PowerMon._State.ValueType  # 64
        LED_On: PowerMon._State.ValueType  # 128
        Screen_On: PowerMon._State.ValueType  # 256
        Screen_Drawing: PowerMon._State.ValueType  # 512
        Wifi_On: PowerMon._State.ValueType  # 1024
        GPS_Active: PowerMon._State.ValueType  # 2048
        """
        GPS is actively trying to find our location
        See GPSPowerState for more details
        """

    class State(_State, metaclass=_StateEnumTypeWrapper):
        """Any significant power changing event in meshtastic should be tagged with a powermon state transition.
        If you are making new meshtastic features feel free to add new entries at the end of this definition.
        """

    CPU_DeepSleep: PowerMon.State.ValueType  # 1
    CPU_LightSleep: PowerMon.State.ValueType  # 2
    Vext1_On: PowerMon.State.ValueType  # 4
    """
    The external Vext1 power is on.  Many boards have auxillary power rails that the CPU turns on only
    occasionally.  In cases where that rail has multiple devices on it we usually want to have logging on
    the state of that rail as an independent record.
    For instance on the Heltec Tracker 1.1 board, this rail is the power source for the GPS and screen.

    The log messages will be short and complete (see PowerMon.Event in the protobufs for details).
    something like "S:PM:C,0x00001234,REASON" where the hex number is the bitmask of all current states.
    (We use a bitmask for states so that if a log message gets lost it won't be fatal)
    """
    Lora_RXOn: PowerMon.State.ValueType  # 8
    Lora_TXOn: PowerMon.State.ValueType  # 16
    Lora_RXActive: PowerMon.State.ValueType  # 32
    BT_On: PowerMon.State.ValueType  # 64
    LED_On: PowerMon.State.ValueType  # 128
    Screen_On: PowerMon.State.ValueType  # 256
    Screen_Drawing: PowerMon.State.ValueType  # 512
    Wifi_On: PowerMon.State.ValueType  # 1024
    GPS_Active: PowerMon.State.ValueType  # 2048
    """
    GPS is actively trying to find our location
    See GPSPowerState for more details
    """

    def __init__(
        self,
    ) -> None: ...

global___PowerMon = PowerMon
