<?php
/**
 * Internationalization file for the GraphViz extension.
 *
 * @file GraphViz.i18n.php
 * @ingroup GraphViz
 *
 * @author Jeroen De Dauw < jeroendedauw@gmail.com >
 */

$messages = array();

/** English
 * @author Jeroen De Dauw
 */
$messages['en'] = array(
	'graphviz-desc' => 'Allows embedding [http://www.graphviz.org Graphviz] markup and generates inline images',
);

/** Asturian (Asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'graphviz-desc' => 'Permite incorporar llinguax de marques de [http://www.graphviz.org Graphviz] y xenera imaxes en llinia',
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author Wizardist
 */
$messages['be-tarask'] = array(
	'graphviz-desc' => 'Дазваляе выкарыстаньне разьметкі [http://www.graphviz.org Graphviz] і стварэньня ўбудаваных выяваў',
);

/** German (Deutsch)
 * @author Kghbln
 */
$messages['de'] = array(
	'graphviz-desc' => 'Ermöglicht das Einbetten und Anzeigen von Grafiken mit Hilfe von [http://www.graphviz.org Graphviz]',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'graphviz-desc' => 'Zmóžnja zasajźowanje a  napóranje wobrazow z pomocu [http://www.graphviz.org Graphviz]',
);

/** French (Français)
 * @author Gomoko
 */
$messages['fr'] = array(
	'graphviz-desc' => 'Permet un balisage [http://www.graphviz.org Graphviz] embarqué et génère les images en ligne',
);

/** Galician (Galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'graphviz-desc' => 'Permite a incorporación de formato [http://www.graphviz.org Graphviz] e xera imaxes en liña',
);

/** Hebrew (עברית)
 * @author Amire80
 */
$messages['he'] = array(
	'graphviz-desc' => 'מאפשרת הטמעת סימון [http://www.graphviz.org Graphviz] ומייצרת תמונות מתוך הטקסט',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'graphviz-desc' => 'Zmóžnja zasadźowanje a  wutworjenje wobrazow z pomocu [http://www.graphviz.org Graphviz]',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'graphviz-desc' => 'Permitte incorporar le marcation [http://www.graphviz.org Graphviz] e genera imagines pro insertion in pagina',
);

/** Japanese (日本語)
 * @author Whym
 */
$messages['ja'] = array(
	'graphviz-desc' => '[http://www.graphviz.org Graphviz]記法の埋め込みとインライン画像の生成を可能にする',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'graphviz-desc' => 'Määd_et müjjelesch, <i lang="en">[http://www.graphviz.org Graphviz]</i> sing Befähle enzebenge un Belder enzefööje.',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'graphviz-desc' => "Erlaabt d'Abannen an d'Weise vu Biller mat Hëllef vu [http://www.graphviz.org Graphviz]",
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'graphviz-desc' => 'Овозможува вметнување на кодово означување „[http://www.graphviz.org Graphviz]“ и создава слики во самите редови текст',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'graphviz-desc' => 'Maakt het mogelijk [http://www.graphviz.org Graphviz-markup] te gebruiken en inline afbeeldingen aan te maken',
);

/** Piedmontese (Piemontèis)
 * @author Dragonòt
 */
$messages['pms'] = array(
	'graphviz-desc' => "A përmëtt d'anserì dij marcador [http://www.graphviz.org Graphviz] e a génera dle figure an linia",
);

/** Russian (Русский)
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'graphviz-desc' => 'Позволяет использовать разметку [http://www.graphviz.org Graphviz] и создавать встроенные изображения',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Linforest
 */
$messages['zh-hans'] = array(
	'graphviz-desc' => '允许内置 [http://www.graphviz.org Graphviz] 标记，并生成内嵌式图像',
);

