/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file WindPlotting.cc
    \brief Implementation of the Template class Wind.
    
    Magics Team - ECMWF 2005
    
    Started: Thu 17-Mar-2005
    
    Changes:
    
*/

#include "FlagPlotting.h"
#include "LegendVisitor.h"
#include "Histogram.h"

using namespace magics;

void FlagPlotting::operator()(const UserPoint& geo, const PaperPoint& point, double x, double y,double) 
{ 
		double speed = sqrt((x*x)+(y*y));
		if (speed < this->min_speed_ || speed > this->max_speed_) return;
		
	   if ((*this->calm_)(point, x, y)) return; 
	
		if ( geo.y() >= 0 ) 
			northFlags_->push_back(ArrowPoint(x, y, point));
		else southFlags_->push_back(ArrowPoint(x, y, point));
		
		
}

void FlagPlotting::prepare(BasicGraphicsObjectContainer& task, double)
{ 

    // Calm Indicator 
    (*this->calm_).colour(*this->colour_);
    (*this->calm_).height(this->calm_indicator_size_);
    (*this->calm_).below(this->calm_below_);
    (*this->calm_).prepare(task);
    
  
    
    
    // Setting for south Hemisphere wind	
	southFlags_ = new Flag();
	southFlags_->setColour(*this->colour_); 
	southFlags_->setThickness(this->thickness_);
	southFlags_->setStyle(this->style_);
	southFlags_->setCrossBoundary(this->cross_boundary_);
	southFlags_->setHemisphere(SOUTH);
	southFlags_->setOriginHeight(this->calm_indicator_size_);
	southFlags_->setLength(this->length_);
	
	// Setting for south Hemisphere wind	
	northFlags_ = new Flag();
	northFlags_->setColour(*this->colour_); 
	northFlags_->setThickness(this->thickness_);
	northFlags_->setCrossBoundary(this->cross_boundary_);
	northFlags_->setOriginHeight(this->calm_indicator_size_);
	northFlags_->setHemisphere(NORTH);
	northFlags_->setLength(this->length_);
	
	// Origin Indicator 	  
    (*this->origin_).prepare(*southFlags_);
    (*this->origin_).prepare(*northFlags_);
    
    northFlags_->setOriginHeight(this->origin_marker_size_);
    southFlags_->setOriginHeight(this->origin_marker_size_);
	if ( this->legend_only_) return;
	task.push_back(southFlags_);	
	task.push_back(northFlags_);	
}

void FlagPlotting::visit(LegendVisitor& legend)
{
	if ( !this->legend_ ) return;
	   
	   
	  
	   
	  
	   Flag* flags = new Flag();
	   flags->setColour(*this->colour_); 
	   flags->setThickness(this->thickness_);
	   flags->setCrossBoundary(this->cross_boundary_); 
	   (*this->origin_).prepare(*flags);
	   flags->setOriginHeight(this->origin_marker_size_);
	   flags->setHemisphere(NORTH);
	   flags->setLength(this->length_);

	   ostringstream text;

	   if (legend_text_ == "vector" ) legend_text_ = " ";
	   LegendEntry * entry = new FlagEntry(legend_text_, flags);

	   legend.add(entry);
	   legend.add(new EmptyEntry());
}

void FlagPlotting::visit(Data& data, PointsHandler& points, HistoVisitor& visitor)
{
    IntervalMap<Colour> beans;
    if ( !visitor.basic() ) {

	vector<double>::iterator from = this->levels_->begin();
        vector<double>::iterator to = this->levels_->begin();
        ++to;
        for (;  to != this->levels_->end(); ++to)
	{
	    	Colour colour;	    	
	    	if (magCompare(advanced_method_, "advanced") ||  
		    magCompare(advanced_method_, "on") ) 
		{	  	  	
			colour=colourMethod_->right(*from);
		}
		else
		{
		  	colour=*this->colour_;;
		} 	
            	beans.insert(make_pair(Interval(*from, *to), colour ));
            	++from;
        }		  	
    }
    
    Histogram helper;
    helper.visit(beans, data, points, visitor);
}  