/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisAttributes.h
    \brief Definition of Axis Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Apr 15 17:55:26 2013
*/
   

#ifndef AxisAttributes_H
#define AxisAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "AxisMethod.h"
#include "Colour.h"

namespace magics {

class XmlNode;



class AxisAttributes 
{
public:
//  --  constructor
    AxisAttributes();
    
//  --  destructor
    virtual ~AxisAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const AxisAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

	

public:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream& out) const;
	//  --  members:
	string tag_;
	string orientation_;
	string position_;
	auto_ptr<AxisMethod> method_;
	double interval_;
	floatarray positions_;
	bool line_;
	auto_ptr<Colour> line_colour_;
	LineStyle line_style_;
	int line_thickness_;
	bool grid_;
	auto_ptr<Colour> grid_colour_;
	LineStyle grid_style_;
	int grid_thickness_;
	double grid_reference_level_;
	auto_ptr<Colour> grid_reference_colour_;
	LineStyle grid_reference_style_;
	int grid_reference_thickness_;
	bool title_;
	string title_text_;
	string title_orientation_;
	auto_ptr<Colour> title_colour_;
	double title_height_;
	string title_font_;
	string title_font_style_;
	bool tick_;
	string tick_position_;
	auto_ptr<Colour> tick_colour_;
	double tick_length_;
	int tick_thickness_;
	bool label_;
	string label_type_;
	int label_frequency_;
	bool label_first_;
	bool label_last_;
	string label_position_;
	string label_orientation_;
	string label_font_;
	string label_font_style_;
	auto_ptr<Colour> label_colour_;
	double label_height_;
	stringarray label_labels_;
	string label_format_;
	bool minor_tick_;
	int minor_tick_count_;
	auto_ptr<Colour> minor_tick_colour_;
	int minor_tick_thickness_;
	bool tip_;
	string tip_text_;
	auto_ptr<Colour> tip_colour_;
	double tip_height_;
	string tip_quality_;

private:
  
	friend ostream& operator<<(ostream& s,const AxisAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
