/* ***************************************************************************
 *
 * Pico Technology USB Device Driver
 *
 *//**
 * \file      TC08Enumerator.h 
 * \brief     TC08 enumerator class
 **//*
 *
 * Copyright (c) 2007, Pico Technology.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * The name of Pico Technology may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY PICO TECHNOLOGY "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL PICO TECHNOLOGY BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Version $Id: TC08Enumerator.h,v 1.4 2007/05/14 21:16:32 douglas Exp $
 *
 *************************************************************************** */

/* Avoid including this header more than once */
#ifndef TC08ENUMERATOR_H
#define TC08ENUMERATOR_H

//////////////////////////////////////////////////////////////////////////
// Null function - used to dynamically determine if framework is present
//////////////////////////////////////////////////////////////////////////
// extern void TC08EnumeratorFramework() __attribute__((weak_import));
//
// int isTC08FrameworkInstalled() {
//   return(TC08EnumeratorFramework != NULL);
// }
//
#ifdef __cplusplus
extern "C" {
#endif
void TC08EnumeratorFramework();
#ifdef __cplusplus
}
#endif

//////////////////////////////////////////////////////////////////////////
// Enumerator class
//////////////////////////////////////////////////////////////////////////
class TC08Enumerator {
	// Public functions
	public:
		TC08Enumerator();
		~TC08Enumerator();
		
		int Count();
		int Ready();
		int Enumerate(class TC08Device **list,int length);
		class TC08Device* Open();
		class TC08Device* Open(char *serialString);
		
	private:
		class TC08EnumeratorInternalData * internalData;
};
#endif /* not defined TC08ENUMERATOR_H */
