/* ***************************************************************************
 *
 * Pico Technology USB Device Driver
 *
 *//**
 * \file      PicoStatus.h 
 * \brief     Return codes and device status information for
 *            Pico Technology USB devices
 **//*
 *
 * Copyright (c) 2007, Pico Technology.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * The name of Pico Technology may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY PICO TECHNOLOGY "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL PICO TECHNOLOGY BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Version $Id: PicoStatus.h,v 1.2 2007/07/30 17:13:20 douglas Exp $
 *
 *************************************************************************** */

/* Avoid including this header more than once */
#ifndef PICOSTATUS_H
#define PICOSTATUS_H

/** Return values for any Pico USB driver functions which return a status.
 *  Negative values indicate an error, zero indicates success. Error codes 
 *  below -1000 are used internally in the driver and will not be returned to
 *  user callers */
typedef enum {
	/* Return codes from PicoUsbDevice for internal driver use */
	/** A USB read/write did not transfer the correct number of bytes */ 
	PICO_INCOMPLETE_USB_TRANSFER = -1002,
	/** A USB transfer did not complete in the specified timeout */
	PICO_USB_TIMEOUT             = -1001,
	
	/* Return codes which can be passed to user functions */
	/** Invalid function argument */
	PICO_ARGUMENT_ERROR  =-6,
	/** The unit is not in the proper operating state for a call (e.g. it is closed) */
	PICO_UNIT_STATE_ERROR=-4,      
	/** Can't collect data without enabling at least one channel */
	PICO_NO_ENABLED_CHANNELS=-3,
	/** The USB device has been unplugged from the PC */
	PICO_DEVICE_DISCONNECTED     = -2,
	/** Any other error has occurred */
	PICO_FAILURE                 = -1,
	/** The function call succeded */
	PICO_SUCCESS                 =  0
} PICO_RETURNS;


/** Status of a Pico USB device */
typedef enum {
	/** The device has been unplugged since the object representing it was created */
	PICODEVICE_STATE_DISCONNECTED     = -2,
	/** The device is open by another process */
	PICODEVICE_STATE_LOCKED           = -1,
	/** The device is connected and available for attempts at opening */
	PICODEVICE_STATE_CLOSED           =  0,
	/** The device is open and not busy */
	PICODEVICE_STATE_OPEN             =  1,
	/** The device is open and not busy (same value as PICODEVICE_STATE_OPEN) */
	PICODEVICE_STATE_IDLE             =  1
} PICODEVICE_STATES;

#endif /* not defined PICOSTATUS_H */
