%feature("docstring") getLibSBMLVersion "
Returns the version number of this copy of libSBML as an integer.

Returns the libSBML version as an integer; version 1.2.3 becomes
10203.
";


%feature("docstring") getLibSBMLDottedVersion "
Returns the version number of this copy of libSBML as a string.

Returns the libSBML version as a string; version 1.2.3 becomes
'1.2.3'.

See also getLibSBMLVersionString().
";


%feature("docstring") getLibSBMLVersionString "
Returns the version number of this copy of libSBML as a string without
periods.

Returns the libSBML version as a string: version 1.2.3 becomes
'10203'.

See also getLibSBMLDottedVersion().
";


%feature("docstring") isLibSBMLCompiledWith "
Returns an indication whether libSBML has been compiled with against a
specific library.

Parameter 'option' is the library to test against, this can be one of
'expat', 'libxml', 'xerces-c', 'bzip2', 'zip'

Returns 0 in case the libSBML has not been compiled against  that
library and non-zero otherwise (for libraries  that define an integer
version number that number will  be returned).

See also getLibSBMLDependencyVersionOf().
";


%feature("docstring") getLibSBMLDependencyVersionOf "
Returns the version string for the dependency library used.

Parameter 'option' is the library for which the version should be
retrieved, this can be one of 'expat', 'libxml', 'xerces-c', 'bzip2',
'zip'

Returns None in case libSBML has not been compiled against  that
library and a version string otherwise.

See also isLibSBMLCompiledWith().
";


%feature("docstring") OperationReturnValue_toString "
This method takes an SBML operation return value and returns a string
representing the code.

Parameter 'returnValue' is the operation return value to convert to a
string.

Returns a human readable name for the given operation return value .

Note: The caller does not own the returned string and is therefore not
allowed to modify it.
";


%feature("docstring") IdList "
Internal implementation method.
";


%feature("docstring") IdList::append "
Internal implementation method.
";


%feature("docstring") IdList::contains "
Internal implementation method.
";


%feature("docstring") IdList::removeIdsBefore "
Internal implementation method.
";


%feature("docstring") IdList::size "
Internal implementation method.
";


%feature("docstring") IdentifierTransformer "
Internal implementation method.
";


%feature("docstring") ElementFilter "
Base class for filter functions.

This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  It is a class used in the
implementation of extra functionality provided by libSBML.

Some libSBML objects provide the ability to return lists of
components. To provide callers with greater control over exactly what
is returned, these methods take optional arguments in the form of
filters. The ElementFilter class is the parent class for these
filters.
";


%feature("docstring") ElementFilter::ElementFilter "
Creates a new ElementFilter object.
";


%feature("docstring") ElementFilter::filter "
Predicate to test elements.

This is the central predicate of the ElementFilter class.  In
subclasses of ElementFilter, callers should implement this method such
that it returns 'True' for 'element' arguments that are 'desirable'
and 'False' for those that are 'undesirable' in whatever filtering
context the ElementFilter subclass is designed to be used.

Parameter 'element' is the element to be tested.

Returns 'True' if the 'element' is desirable or should be kept,
'False' otherwise.
";


%feature("docstring") ElementFilter::getUserData "
Returns the user data that has been previously set via setUserData().

Callers can attach private data to ElementFilter objects using
setUserData().  This user data can be used by an application to store
custom information to be accessed by the ElementFilter in its work.
In case of a deep copy, the data will passed as it is.  The attribute
will never be interpreted by libSBML.

Returns the user data of this node, or 'None' if no user data has been
set.

WARNING:

This user data is specific to an ElementFilter object instance, and is
not the same as the user data that may be attached to an SBML object
using SBase.setUserData().

See also setUserData().
";


%feature("docstring") ElementFilter::setUserData "
Sets the user data of this element.

Callers can attach private data to ElementFilter objects using this
method, and retrieve them using getUserData().  Such user data can be
used by an application to store information to be accessed by the
ElementFilter in its work.  In case of a deep copy, this data will
passed as it is.  The attribute will never be interpreted by libSBML.

Parameter 'userData' is specifies the new user data.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

WARNING:

This user data is specific to an ElementFilter object instance, and is
not the same as the user data that may be attached to an SBML object
using SBase.setUserData().

See also getUserData().
";


%feature("docstring") SBMLReader "
File and text-string SBML reader.

This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed
by the SBML specifications, although it is used to implement features
defined in SBML.

The SBMLReader class provides the main interface for reading SBML
content from files and strings.  The methods for reading SBML all
return an SBMLDocument object representing the results.  In the case
of failures (such as if the SBML contains errors or a file cannot be
read), the errors will be recorded with the SBMLErrorLog object kept
in the SBMLDocument returned by SBMLReader.  Consequently, immediately
after calling a method on SBMLReader, callers should always check for
errors and warnings using the methods for this purpose provided by
SBMLDocument.

For convenience as well as easy access from other languages besides
C++, this file also defines two global functions,
@sbmlglobalfunction{readSBML, String} and
@sbmlglobalfunction{readSBMLFromString, String}.  They are equivalent
to creating an SBMLReader object and then calling the
SBMLReader.readSBML() and SBMLReader.readSBMLFromString() methods,
respectively.

Support for reading compressed files
======================================================================

LibSBML provides support for reading (as well as writing) compressed
SBML files.  The process is transparent to the calling application---
the application does not need to do anything deliberate to invoke the
functionality.  If a given SBML filename ends with an extension for
the gzip, zip or bzip2 compression formats (respectively, '.gz,'
'.zip,' or '.bz2),' then the methods SBMLReader.readSBML() and
SBMLWriter.writeSBML() will automatically decompress and compress the
file while reading and writing it.  If the filename has no such
extension, it will be read and written uncompressed as normal.

The compression feature requires that the zlib (for gzip and zip
formats) and/or bzip2 (for bzip2 format) be available on the system
running libSBML, and that libSBML was configured with their support
compiled-in.  Please see the libSBML installation instructions for
more information about this.  The methods hasZlib() and hasBzip2() can
be used by an application to query at run-time whether support for the
compression libraries is available in the present copy of libSBML.

Support for compression is not mandated by the SBML standard, but
applications may find it helpful, particularly when large SBML models
are being communicated across data links of limited bandwidth.
";


%feature("docstring") SBMLReader::SBMLReader "
Creates a new SBMLReader object and returns it.

The libSBML SBMLReader object offers methods for reading SBML in XML
form from files and text strings.
";


%feature("docstring") SBMLReader::readSBML "
Reads an SBML document from the given file.

If the file named 'filename' does not exist or its content is not
valid SBML, one or more errors will be logged with the SBMLDocument
object returned by this method.  Callers can use the methods on
SBMLDocument such as SBMLDocument.getNumErrors(),
SBMLDocument.getNumErrors() and SBMLDocument.getError()

to get the errors.  The object returned by SBMLDocument.getError()

is an SBMLError object, and it has methods to get the error code,
category, and severity level of the problem, as well as a textual
description of the problem.  The possible severity levels range from
informational messages to fatal errors; see the documentation for
SBMLError for more information.

If the file 'filename' could not be read, the file-reading error will
appear first.  The error code  can provide a clue about what happened.
For example, a file might be unreadable (either because it does not
actually exist or because the user does not have the necessary access
privileges to read it) or some sort of file operation error may have
been reported by the underlying operating system.  Callers can check
for these situations using a program fragment such as the following:

  reader = SBMLReader()
  if reader == None:
    # Handle the truly exceptional case of no object created here.
  
  doc = reader.readSBMLFromFile(filename)
  if doc.getNumErrors() > 0:
    if doc.getError(0).getErrorId() == XMLFileUnreadable:
      # Handle case of unreadable file here.
    elif doc.getError(0).getErrorId() == XMLFileOperationError:
      # Handle case of other file error here.
    else:
      # Handle other error cases here.

If the given filename ends with the suffix ''.gz'' (for example,
''myfile.xml.gz'),' the file is assumed to be compressed in gzip
format and will be automatically decompressed upon reading. Similarly,
if the given filename ends with ''.zip'' or ''.bz2',' the file is
assumed to be compressed in zip or bzip2 format (respectively).  Files
whose names lack these suffixes will be read uncompressed.  Note that
if the file is in zip format but the archive contains more than one
file, only the first file in the archive will be read and the rest
ignored.

To read a gzip/zip file, libSBML needs to be configured and linked
with the zlib library at compile time.  It also needs to be linked
with the bzip2 library to read files in bzip2 format.  (Both of these
are the default configurations for libSBML.)  Errors about unreadable
files will be logged if a compressed filename is given and libSBML was
not linked with the corresponding required library.

This method is identical to SBMLReader.readSBMLFromFile().

Parameter 'filename' is the name or full pathname of the file to be
read.

Returns a pointer to the SBMLDocument object created from the SBML
content in 'filename'.

Note: LibSBML versions 2.x and later versions behave differently in
error handling in several respects.  One difference is how early some
errors are caught and whether libSBML continues processing a file in
the face of some early errors.  In general, libSBML versions after 2.x
stop parsing SBML inputs sooner than libSBML version 2.x in the face
of XML errors, because the errors may invalidate any further SBML
content.  For example, a missing XML declaration at the beginning of
the file was ignored by libSBML 2.x but in version 3.x and later, it
will cause libSBML to stop parsing the rest of the input altogether.
While this behavior may seem more severe and intolerant, it was
necessary in order to provide uniform behavior regardless of which
underlying XML parser (Expat, Xerces, libxml2) is being used by
libSBML.  The XML parsers themselves behave differently in their error
reporting, and sometimes libSBML has to resort to the lowest common
denominator.

See also readSBMLFromString(), SBMLError, SBMLDocument.
";


%feature("docstring") SBMLReader::readSBMLFromFile "
Reads an SBML document from the given file.

If the file named 'filename' does not exist or its content is not
valid SBML, one or more errors will be logged with the SBMLDocument
object returned by this method.  Callers can use the methods on
SBMLDocument such as SBMLDocument.getNumErrors(),
SBMLDocument.getNumErrors() and SBMLDocument.getError()

to get the errors.  The object returned by SBMLDocument.getError()

is an SBMLError object, and it has methods to get the error code,
category, and severity level of the problem, as well as a textual
description of the problem.  The possible severity levels range from
informational messages to fatal errors; see the documentation for
SBMLError for more information.

If the file 'filename' could not be read, the file-reading error will
appear first.  The error code  can provide a clue about what happened.
For example, a file might be unreadable (either because it does not
actually exist or because the user does not have the necessary access
privileges to read it) or some sort of file operation error may have
been reported by the underlying operating system.  Callers can check
for these situations using a program fragment such as the following:

  reader = SBMLReader()
  if reader == None:
    # Handle the truly exceptional case of no object created here.
  
  doc = reader.readSBMLFromFile(filename)
  if doc.getNumErrors() > 0:
    if doc.getError(0).getErrorId() == XMLFileUnreadable:
      # Handle case of unreadable file here.
    elif doc.getError(0).getErrorId() == XMLFileOperationError:
      # Handle case of other file error here.
    else:
      # Handle other error cases here.

If the given filename ends with the suffix ''.gz'' (for example,
''myfile.xml.gz'),' the file is assumed to be compressed in gzip
format and will be automatically decompressed upon reading. Similarly,
if the given filename ends with ''.zip'' or ''.bz2',' the file is
assumed to be compressed in zip or bzip2 format (respectively).  Files
whose names lack these suffixes will be read uncompressed.  Note that
if the file is in zip format but the archive contains more than one
file, only the first file in the archive will be read and the rest
ignored.

To read a gzip/zip file, libSBML needs to be configured and linked
with the zlib library at compile time.  It also needs to be linked
with the bzip2 library to read files in bzip2 format.  (Both of these
are the default configurations for libSBML.)  Errors about unreadable
files will be logged if a compressed filename is given and libSBML was
not linked with the corresponding required library.

This method is identical to SBMLReader.readSBML().

Parameter 'filename' is the name or full pathname of the file to be
read.

Returns a pointer to the SBMLDocument object created from the SBML
content in 'filename'.

Note: LibSBML versions 2.x and later versions behave differently in
error handling in several respects.  One difference is how early some
errors are caught and whether libSBML continues processing a file in
the face of some early errors.  In general, libSBML versions after 2.x
stop parsing SBML inputs sooner than libSBML version 2.x in the face
of XML errors, because the errors may invalidate any further SBML
content.  For example, a missing XML declaration at the beginning of
the file was ignored by libSBML 2.x but in version 3.x and later, it
will cause libSBML to stop parsing the rest of the input altogether.
While this behavior may seem more severe and intolerant, it was
necessary in order to provide uniform behavior regardless of which
underlying XML parser (Expat, Xerces, libxml2) is being used by
libSBML.  The XML parsers themselves behave differently in their error
reporting, and sometimes libSBML has to resort to the lowest common
denominator.

See also readSBMLFromString(), SBMLError, SBMLDocument.
";


%feature("docstring") SBMLReader::readSBMLFromString "
Reads an SBML document from a text string.

This method is flexible with respect to the presence of an XML
declaration at the beginning of the string.  In particular, if the
string in 'xml' does not begin with the XML declaration

  <?xml version=\'1.0\' encoding=\'UTF-8\'?>

then this method will automatically prepend the declaration to 'xml'.

This method will log a fatal error if the content given in the
parameter 'xml' is not in SBML format.  See the method documentation
for SBMLReader.readSBML()

for an example of code for testing the returned error code.

Parameter 'xml' is a string containing a full SBML model.

Returns a pointer to the SBMLDocument created from the SBML content,
or a null pointer if 'xml' is 'None.'

Note: When using this method to read an SBMLDocument that uses the
SBML Level 3 Hierarchical Model Composition package (comp) the
document location cannot be set automatically. Thus, if the model
contains references to ExternalModelDefinition objects, it will be
necessary to manually set the document URI location
(SBMLDocument.setLocationURI()

) in order to facilitate resolving these models.

See also SBMLReader.readSBML().
";


%feature("docstring") SBMLReader::hasZlib "
Static method; returns 'True' if this copy of libSBML supports gzip
and zip format compression.

Returns 'True' if libSBML has been linked with the zlib library,
'False' otherwise.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.

See also SBMLReader.hasBzip2().
";


%feature("docstring") SBMLReader::hasBzip2 "
Static method; returns 'True' if this copy of libSBML supports bzip2
format compression.

Returns 'True' if libSBML is linked with the bzip2 libraries, 'False'
otherwise.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.

See also SBMLReader.hasZlib().
";


%feature("docstring") SBMLReader::readInternal "
Internal implementation method.
";


%feature("docstring") readSBML "
Reads an SBML document from the given file.

If the file named 'filename' does not exist or its content is not
valid SBML, one or more errors will be logged with the SBMLDocument
object returned by this method.  Callers can use the methods on
SBMLDocument such as SBMLDocument.getNumErrors(),
SBMLDocument.getNumErrors() and SBMLDocument.getError()

to get the errors.  The object returned by SBMLDocument.getError()

is an SBMLError object, and it has methods to get the error code,
category, and severity level of the problem, as well as a textual
description of the problem.  The possible severity levels range from
informational messages to fatal errors; see the documentation for
SBMLError for more information.

If the file 'filename' could not be read, the file-reading error will
appear first.  The error code  can provide a clue about what happened.
For example, a file might be unreadable (either because it does not
actually exist or because the user does not have the necessary access
privileges to read it) or some sort of file operation error may have
been reported by the underlying operating system.  Callers can check
for these situations using a program fragment such as the following:

  reader = SBMLReader()
  if reader == None:
    # Handle the truly exceptional case of no object created here.
  
  doc = reader.readSBMLFromFile(filename)
  if doc.getNumErrors() > 0:
    if doc.getError(0).getErrorId() == XMLFileUnreadable:
      # Handle case of unreadable file here.
    elif doc.getError(0).getErrorId() == XMLFileOperationError:
      # Handle case of other file error here.
    else:
      # Handle other error cases here.

If the given filename ends with the suffix ''.gz'' (for example,
''myfile.xml.gz'),' the file is assumed to be compressed in gzip
format and will be automatically decompressed upon reading. Similarly,
if the given filename ends with ''.zip'' or ''.bz2',' the file is
assumed to be compressed in zip or bzip2 format (respectively).  Files
whose names lack these suffixes will be read uncompressed.  Note that
if the file is in zip format but the archive contains more than one
file, only the first file in the archive will be read and the rest
ignored.

To read a gzip/zip file, libSBML needs to be configured and linked
with the zlib library at compile time.  It also needs to be linked
with the bzip2 library to read files in bzip2 format.  (Both of these
are the default configurations for libSBML.)  Errors about unreadable
files will be logged if a compressed filename is given and libSBML was
not linked with the corresponding required library.
";


%feature("docstring") readSBMLFromFile "
Reads an SBML document from the given file.

If the file named 'filename' does not exist or its content is not
valid SBML, one or more errors will be logged with the SBMLDocument
object returned by this method.  Callers can use the methods on
SBMLDocument such as SBMLDocument.getNumErrors(),
SBMLDocument.getNumErrors() and SBMLDocument.getError()

to get the errors.  The object returned by SBMLDocument.getError()

is an SBMLError object, and it has methods to get the error code,
category, and severity level of the problem, as well as a textual
description of the problem.  The possible severity levels range from
informational messages to fatal errors; see the documentation for
SBMLError for more information.

If the file 'filename' could not be read, the file-reading error will
appear first.  The error code  can provide a clue about what happened.
For example, a file might be unreadable (either because it does not
actually exist or because the user does not have the necessary access
privileges to read it) or some sort of file operation error may have
been reported by the underlying operating system.  Callers can check
for these situations using a program fragment such as the following:

  reader = SBMLReader()
  if reader == None:
    # Handle the truly exceptional case of no object created here.
  
  doc = reader.readSBMLFromFile(filename)
  if doc.getNumErrors() > 0:
    if doc.getError(0).getErrorId() == XMLFileUnreadable:
      # Handle case of unreadable file here.
    elif doc.getError(0).getErrorId() == XMLFileOperationError:
      # Handle case of other file error here.
    else:
      # Handle other error cases here.

If the given filename ends with the suffix ''.gz'' (for example,
''myfile.xml.gz'),' the file is assumed to be compressed in gzip
format and will be automatically decompressed upon reading. Similarly,
if the given filename ends with ''.zip'' or ''.bz2',' the file is
assumed to be compressed in zip or bzip2 format (respectively).  Files
whose names lack these suffixes will be read uncompressed.  Note that
if the file is in zip format but the archive contains more than one
file, only the first file in the archive will be read and the rest
ignored.

To read a gzip/zip file, libSBML needs to be configured and linked
with the zlib library at compile time.  It also needs to be linked
with the bzip2 library to read files in bzip2 format.  (Both of these
are the default configurations for libSBML.)  Errors about unreadable
files will be logged if a compressed filename is given and libSBML was
not linked with the corresponding required library.

Parameter 'filename' is the name or full pathname of the file to be
read.

Returns a pointer to the SBMLDocument structure created from the SBML
content in 'filename'.
";


%feature("docstring") readSBMLFromString "
Reads an SBML document from a text string.

This method is flexible with respect to the presence of an XML
declaration at the beginning of the string.  In particular, if the
string in 'xml' does not begin with the XML declaration

  <?xml version=\'1.0\' encoding=\'UTF-8\'?>

then this method will automatically prepend the declaration to 'xml'.

This method will log a fatal error if the content given in the
parameter 'xml' is not in SBML format.  See the method documentation
for SBMLReader.readSBML()

for an example of code for testing the returned error code.

Parameter 'xml' is a string containing a full SBML model.

Returns a pointer to the SBMLDocument structure created from the SBML
content in 'xml'.

Note: When using this method to read an SBMLDocument that uses the
SBML Level 3 Hierarchical Model Composition package (comp) the
document location cannot be set automatically. Thus, if the model
contains references to ExternalModelDefinition objects, it will be
necessary to manually set the document URI location
(SBMLDocument.setLocationURI()

) in order to facilitate resolving these models.
";


%feature("docstring") SBMLWriter "
File and text-string SBML writer.

This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed
by the SBML specifications, although it is used to implement features
defined in SBML.

The SBMLWriter class is the converse of SBMLReader, and provides the
main interface for serializing SBML models into XML and writing the
result to an output stream or to files and text strings.  The methods
for writing SBML all take an SBMLDocument object and a destination.
They return a boolean or integer value to indicate success or failure.

Support for writing compressed files
======================================================================

LibSBML provides support for writing (as well as reading) compressed
SBML files.  The process is transparent to the calling application---
the application does not need to do anything deliberate to invoke the
functionality.  If a given SBML filename ends with an extension for
the gzip, zip or bzip2 compression formats (respectively, \".gz\",
\".zip\", or \".bz2\"), then the methods SBMLWriter.writeSBML() and
SBMLReader.readSBML() will automatically compress and decompress the
file while writing and reading it.  If the filename has no such
extension, it will be written and read uncompressed as normal.

The compression feature requires that the zlib (for gzip and zip
formats) and/or bzip2 (for bzip2 format) be available on the system
running libSBML, and that libSBML was configured with their support
compiled-in.  Please see the libSBML installation instructions for
more information about this.  The methods SBMLWriter.hasZlib() and
SBMLWriter.hasBzip2() can be used by an application to query at run-
time whether support for the compression libraries is available in the
present copy of libSBML.

Support for compression is not mandated by the SBML standard, but
applications may find it helpful, particularly when large SBML models
are being communicated across data links of limited bandwidth.
";


%feature("docstring") SBMLWriter::SBMLWriter "
Creates a new SBMLWriter.

The libSBML SBMLWriter objects offer methods for writing SBML in XML
form to files and text strings.
";


%feature("docstring") SBMLWriter::setProgramName "
Sets the name of this program, i.e., the program that is about to
write out the SBMLDocument.

If the program name and version are set (see
SBMLWriter.setProgramVersion()), the following XML comment, intended
for human consumption, will be written at the beginning of the XML
document:

   <!-- Created by <program name> version <program version>
   on yyyy-MM-dd HH:mm with libSBML version <libsbml version>. -->

If the program name and version are not set at some point before
calling the writeSBML() methods, no such comment is written out.

Parameter 'name' is the name of this program (where 'this program'
refers to program in which libSBML is embedded, not libSBML itself!)

Returns integer value indicating success/failure of the function.
This particular function only does one thing irrespective of user
input or  object state, and thus will only return a single value:

* LIBSBML_OPERATION_SUCCESS

See also setProgramVersion().
";


%feature("docstring") SBMLWriter::setProgramVersion "
Sets the version of this program, i.e., the program that is about to
write out the SBMLDocument.

If the program version and name are set (see
SBMLWriter.setProgramName()), the following XML comment, intended for
human consumption, will be written at the beginning of the document:

   <!-- Created by <program name> version <program version>
   on yyyy-MM-dd HH:mm with libSBML version <libsbml version>. -->

If the program version and name are not set at some point before
calling the writeSBML() methods, no such comment is written out.

Parameter 'version' is the version of this program (where 'this
program' refers to program in which libSBML is embedded, not libSBML
itself!)

Returns integer value indicating success/failure of the function.
This particular function only does one thing irrespective of user
input or  object state, and thus will only return a single value:

* LIBSBML_OPERATION_SUCCESS

See also setProgramName().
";


%feature("docstring") SBMLWriter::writeSBML "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    writeSBML(SBMLDocument d, string filename)

Writes the given SBML document to filename.

If the given filename ends with the suffix \".gz\" (for example,
\"myfile.xml.gz\"), libSBML assumes the caller wants the file to be
written compressed in gzip format. Similarly, if the given filename
ends with \".zip\" or \".bz2\", libSBML assumes the caller wants the
file to be compressed in zip or bzip2 format (respectively). Files
whose names lack these suffixes will be written uncompressed. Special
considerations for the zip format: If the given filename ends with
\".zip\", the file placed in the zip archive will have the suffix
\".xml\" or \".sbml\".  For example, the file in the zip archive will
be named \"test.xml\" if the given filename is \"test.xml.zip\" or
\"test.zip\". Similarly, the filename in the archive will be
\"test.sbml\" if the given filename is \"test.sbml.zip\".

Parameter 'd' is the SBML document to be written.

Parameter 'filename' is the name or full pathname of the file where
the SBML is to be written.

Returns 'True' on success and 'False' if the filename could not be
opened for writing.

Note: To write a gzip/zip file, libSBML needs to be configured and
linked with the zlib library at compile time.  It also needs to be
linked with the bzip2 library to write files in bzip2 format.  (Both
of these are the default configurations for libSBML.)  Errors about
unreadable files will be logged and this method will return false if a
compressed filename is given and libSBML was not linked with the
corresponding required library.

See also setProgramVersion(), setProgramName().

______________________________________________________________________
Method variant with the following signature:

    writeSBML(SBMLDocument d, std::ostream stream)

Writes the given SBML document to the output stream.

Parameter 'd' is the SBML document to be written.

Parameter 'stream' is the stream object where the SBML is to be
written.

Returns 'True' on success and 'False' if one of the underlying parser
components fail (rare).

See also setProgramVersion(), setProgramName().
";


%feature("docstring") SBMLWriter::writeToString "
Internal implementation method.
";


%feature("docstring") SBMLWriter::writeSBMLToFile "
Writes the given SBML document to filename.

If the given filename ends with the suffix \".gz\" (for example,
\"myfile.xml.gz\"), libSBML assumes the caller wants the file to be
written compressed in gzip format. Similarly, if the given filename
ends with \".zip\" or \".bz2\", libSBML assumes the caller wants the
file to be compressed in zip or bzip2 format (respectively). Files
whose names lack these suffixes will be written uncompressed. Special
considerations for the zip format: If the given filename ends with
\".zip\", the file placed in the zip archive will have the suffix
\".xml\" or \".sbml\".  For example, the file in the zip archive will
be named \"test.xml\" if the given filename is \"test.xml.zip\" or
\"test.zip\". Similarly, the filename in the archive will be
\"test.sbml\" if the given filename is \"test.sbml.zip\".

Parameter 'd' is the SBML document to be written.

Parameter 'filename' is the name or full pathname of the file where
the SBML is to be written.

Returns 'True' on success and 'False' if the filename could not be
opened for writing.

Note: To write a gzip/zip file, libSBML needs to be configured and
linked with the zlib library at compile time.  It also needs to be
linked with the bzip2 library to write files in bzip2 format.  (Both
of these are the default configurations for libSBML.)  Errors about
unreadable files will be logged and this method will return false if a
compressed filename is given and libSBML was not linked with the
corresponding required library.

See also setProgramVersion(), setProgramName().
";


%feature("docstring") SBMLWriter::writeSBMLToString "
Writes the given SBML document to an in-memory string and returns a
pointer to it.

The string is owned by the caller and should be freed (with 'free())'
when no longer needed.

Parameter 'd' is the SBML document to be written.

Returns the string on success and '0' if one of the underlying parser
components fail.

See also setProgramVersion(), setProgramName().
";


%feature("docstring") SBMLWriter::hasZlib "
Predicate returning 'True' if this copy of libSBML has been linked
with the zlib library.

LibSBML supports reading and writing files compressed with either
bzip2 or zip/gzip compression.  The facility depends on libSBML having
been compiled with the necessary support libraries.  This method
allows a calling program to inquire whether that is the case for the
copy of libSBML it is using.

Returns 'True' if libSBML is linked with zlib, 'False' otherwise.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.

See also SBMLWriter.hasBzip2() .
";


%feature("docstring") SBMLWriter::hasBzip2 "
Predicate returning 'True' if this copy of libSBML has been linked
with the bzip2 library.

LibSBML supports reading and writing files compressed with either
bzip2 or zip/gzip compression.  The facility depends on libSBML having
been compiled with the necessary support libraries.  This method
allows a calling program to inquire whether that is the case for the
copy of libSBML it is using.

Returns 'True' if libSBML is linked with bzip2, 'False' otherwise.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.

See also SBMLWriter.hasZlib() .
";


%feature("docstring") writeSBML "
Writes the given SBML document 'd' to the file named by 'filename'.
This convenience function is functionally equivalent to:

SBMLWriter_writeSBML(SBMLWriter_create(), d, filename);

If the given filename ends with the suffix \".gz\" (for example,
\"myfile.xml.gz\"), libSBML assumes the caller wants the file to be
written compressed in gzip format. Similarly, if the given filename
ends with \".zip\" or \".bz2\", libSBML assumes the caller wants the
file to be compressed in zip or bzip2 format (respectively). Files
whose names lack these suffixes will be written uncompressed. Special
considerations for the zip format: If the given filename ends with
\".zip\", the file placed in the zip archive will have the suffix
\".xml\" or \".sbml\".  For example, the file in the zip archive will
be named \"test.xml\" if the given filename is \"test.xml.zip\" or
\"test.zip\". Similarly, the filename in the archive will be
\"test.sbml\" if the given filename is \"test.sbml.zip\".

Parameter 'd' is the SBMLDocument object to be written out in XML
format.

Parameter 'filename' is a string giving the path to a file where the
XML content is to be written.

Returns '1' (true) on success and '0' (false) if 'filename' could not
be written.  Some possible reasons for failure include (a) being
unable to open the file, and (b) using a filename that indicates a
compressed SBML file (i.e., a filename ending in \".zip\" or similar)
when the compression functionality has not been enabled in the
underlying copy of libSBML.

See also SBMLWriter.hasZlib(), SBMLWriter.hasBzip2().
";


%feature("docstring") writeSBMLToString "
Writes the given SBML document 'd' to an in-memory string and returns
a pointer to it.  The string is owned by the caller and should be
freed (with free()) when no longer needed.  This convenience function
is functionally equivalent to:

SBMLWriter_writeSBMLToString(SBMLWriter_create(), d);

but does not require the caller to create an SBMLWriter object first.

Parameter 'd' is an SBMLDocument object to be written out in XML
format.

Returns the string on success and 'None' if one of the underlying
parser components fail.
";


%feature("docstring") writeSBMLToFile "
Writes the given SBML document 'd' to the file 'filename'. This
convenience function is functionally equivalent to:

SBMLWriter_writeSBMLToFile(SBMLWriter_create(), d, filename);

but that does not require the caller to create an SBMLWriter object
first.

If the given filename ends with the suffix \".gz\" (for example,
\"myfile.xml.gz\"), libSBML assumes the caller wants the file to be
written compressed in gzip format. Similarly, if the given filename
ends with \".zip\" or \".bz2\", libSBML assumes the caller wants the
file to be compressed in zip or bzip2 format (respectively). Files
whose names lack these suffixes will be written uncompressed. Special
considerations for the zip format: If the given filename ends with
\".zip\", the file placed in the zip archive will have the suffix
\".xml\" or \".sbml\".  For example, the file in the zip archive will
be named \"test.xml\" if the given filename is \"test.xml.zip\" or
\"test.zip\". Similarly, the filename in the archive will be
\"test.sbml\" if the given filename is \"test.sbml.zip\".

Parameter 'd' is an SBMLDocument object to be written out in XML
format.

Parameter 'filename' is a string giving the path to a file where the
XML content is to be written.

Returns '1' (true) on success and '0' (false) if 'filename' could not
be written.  Some possible reasons for failure include (a) being
unable to open the file, and (b) using a filename that indicates a
compressed SBML file (i.e., a filename ending in \".zip\" or similar)
when the compression functionality has not been enabled in the
underlying copy of libSBML.

See also SBMLWriter.hasZlib(), SBMLWriter.hasBzip2().
";


%feature("docstring") SBMLTypeCode_toString "
This method takes an SBML type code and returns a string representing
the code.

LibSBML attaches an identifying code to every kind of SBML object.
These are known as SBML type codes.  In the Python language interface
for libSBML, the type codes are defined as static integer constants in
the interface class 'libsbml'.  The names of the type codes all begin
with the characters 'SBML_.'

Returns a human readable name for the given SBML type code.

Note: The caller does not own the returned string and is therefore not
allowed to modify it.
";


%feature("docstring") SBase "
SBML's SBase class, base class of most SBML objects.

Most components in SBML are derived from a single abstract base type,
SBase.  In addition to serving as the parent class for most other
classes of objects in SBML, this base type is designed to allow a
modeler or a software package to attach arbitrary information to each
major element or list in an SBML model.

SBase has an optional subelement called 'notes'.  It is intended to
serve as a place for storing optional information intended to be seen
by humans.  An example use of the 'notes' element would be to contain
formatted user comments about the model element in which the 'notes'
element is enclosed.  There are certain conditions on the XHTML
content permitted inside the 'notes' element; please consult the SBML
specification document corresponding to the SBML Level and Version of
your model for more information about the requirements for 'notes'
content.

SBase has another optional subelement called 'annotation'.  Whereas
the 'notes' element described above is a container for content to be
shown directly to humans, the 'annotation' element is a container for
optional software-generated content not meant to be shown to humans.
The element's content type is XML type 'any', allowing essentially
arbitrary data content.  SBML places only a few restrictions on the
organization of the content; these are intended to help software tools
read and write the data as well as help reduce conflicts between
annotations added by different tools.  As is the case with 'notes', it
is important to refer to the SBML specification document corresponding
to the SBML Level and Version of your model for more information about
the requirements for 'annotation' content.

It is worth pointing out that the 'annotation' element in the
definition of SBase exists in order that software developers may
attach optional application-specific data to the elements in an SBML
model.  However, it is important that this facility not be misused.
In particular, it is critical that data essential to a model
definition or that can be encoded in existing SBML elements is not
stored in 'annotation'. Parameter values, functional dependencies
between model elements, etc., should not be recorded as annotations.
It is crucial to keep in mind the fact that data placed in annotations
can be freely ignored by software applications.  If such data affects
the interpretation of a model, then software interoperability is
greatly impeded.

SBML Level 2 introduced an optional SBase attribute named 'metaid' for
supporting metadata annotations using RDF (Resource Description
Format). The attribute value has the data type XML ID, the XML
identifier type, which means each 'metaid' value must be globally
unique within an SBML file.  (Importantly, this uniqueness criterion
applies across any attribute with type XML ID, not just the 'metaid'
attribute used by SBML---something to be aware of if your application-
specific XML content inside the 'annotation' subelement happens to use
XML ID.)  The 'metaid' value serves to identify a model component for
purposes such as referencing that component from metadata placed
within 'annotation' subelements.

Beginning with SBML Level 2 Version 2, SBase has an optional attribute
named 'sboTerm' for supporting the use of the Systems Biology
Ontology.  In SBML proper, the data type of the attribute is a string
of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a seven digit integer
number; libSBML simplifies the representation by only storing the
'NNNNNNN' integer portion.  Thus, in libSBML, the 'sboTerm' attribute
on SBase has data type 'int,' and SBO identifiers are stored simply as
integers. (For convenience, SBase offers methods for returning both
the integer form and a text-string form of the SBO identifier.)  SBO
terms are a type of optional annotation, and each different class of
SBML object derived from SBase imposes its own requirements about the
values permitted for 'sboTerm'.  More details can be found in SBML
specifications for Level 2 Version 2 and above.

Finally, note that, in the list of methods on SBase, there is no
public constructor because SBase is an abstract class.  The
constructors reside in the subclasses derived from SBase.

Standard format for annotations linking data resources
======================================================================

SBML Level 2 Versions 2, 3 and 4, and Level 3, define a proposed
regular format for encoding two particular categories of annotations:
(a) references to controlled vocabulary terms and database identifiers
which define and describe biological and biochemical entities in a
model; and (b) descriptions of the provenance of a model, including
its author(s) and modification history.
";


%feature("docstring") SBase::accept "
Internal implementation method.
";


%feature("docstring") SBase::clone "
Creates and returns a deep copy of this SBase object.

Returns the (deep) copy of this SBase object.
";


%feature("docstring") SBase::getElementBySId "
Returns the first child element found that has the given 'id' in the
model-wide 'SId' namespace, or 'None' if no such object is found.

Parameter 'id' is string representing the 'id' attribute value of the
object to find.

Returns pointer to the first element found with the given identifier.
";


%feature("docstring") SBase::getElementByMetaId "
Returns the first child element it can find with a specific 'metaid'
attribute value, or 'None' if no such object is found.

The optional attribute named 'metaid', present on every major SBML
component type, is for supporting metadata annotations using RDF
(Resource Description Format).  The attribute value has the data type
XML ID, the XML identifier type, which means each 'metaid' value must
be globally unique within an SBML file.  The latter point is
important, because the uniqueness criterion applies across any
attribute with type ID anywhere in the file, not just the 'metaid'
attribute used by SBML---something to be aware of if your application-
specific XML content inside the 'annotation' subelement happens to use
the XML ID type.  Although SBML itself specifies the use of XML ID
only for the 'metaid' attribute, SBML-compatible applications should
be careful if they use XML ID's in XML portions of a model that are
not defined by SBML, such as in the application-specific content of
the 'annotation' subelement.  Finally, note that LibSBML does not
provide an explicit XML ID data type; it uses ordinary character
strings, which is easier for applications to support.

Parameter 'metaid' is string representing the 'metaid' attribute value
of the object to find.

Returns pointer to the first element found with the given meta-
identifier.
";


%feature("docstring") SBase::getAllElements "
Returns a List of all child SBase objects, including those nested to
an arbitrary depth.

Parameter 'filter' is a pointer to an ElementFilter, which causes the
function  to return only elements that match a particular set of
constraints.   If None (the default), the function will return all
child objects.

Returns a pointer to a List of pointers to all objects that are
children of this object.
";


%feature("docstring") SBase::renameSIdRefs "
Replaces all uses of a given 'SIdRef' type attribute value with
another value.

In SBML, object identifiers are of a data type called SId. In SBML
Level 3, an explicit data type called SIdRef was introduced for
attribute values that refer to SId values; in previous Levels of SBML,
this data type did not exist and attributes were simply described to
as 'referring to an identifier', but the effective data type was the
same as SIdRef in Level 3.  These and other methods of libSBML refer
to the type SIdRef for all Levels of SBML, even if the corresponding
SBML specification did not explicitly name the data type.

This method works by looking at all attributes and (if appropriate)
mathematical formulas in MathML content, comparing the referenced
identifiers to the value of 'oldid'.  If any matches are found, the
matching values are replaced with 'newid'.  The method does not
descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") SBase::renameMetaIdRefs "
Replaces all uses of a given meta identifier attribute value with
another value.

In SBML, object 'meta' identifiers are of the XML data type ID; the
SBML object attribute itself is typically named metaid.  All
attributes that hold values referring to values of type ID are of the
XML data type IDREF.  They are also sometimes informally referred to
as 'metaid refs', in analogy to the SBML-defined type SIdRef.

This method works by looking at all meta-identifier attribute values,
comparing the identifiers to the value of 'oldid'.  If any matches are
found, the matching identifiers are replaced with 'newid'.  The method
does not descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") SBase::renameUnitSIdRefs "
Replaces all uses of a given 'UnitSIdRef' type attribute value with
another value.

In SBML, unit definitions have identifiers of type UnitSId.  In SBML
Level 3, an explicit data type called UnitSIdRef was introduced for
attribute values that refer to UnitSId values; in previous Levels of
SBML, this data type did not exist and attributes were simply
described to as 'referring to a unit identifier', but the effective
data type was the same as UnitSIdRef in Level 3.  These and other
methods of libSBML refer to the type UnitSIdRef for all Levels of
SBML, even if the corresponding SBML specification did not explicitly
name the data type.

This method works by looking at all unit identifier attribute values
(including, if appropriate, inside mathematical formulas), comparing
the referenced unit identifiers to the value of 'oldid'.  If any
matches are found, the matching values are replaced with 'newid'.  The
method does not descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") SBase::replaceSIDWithFunction "
Internal implementation method.
";


%feature("docstring") SBase::divideAssignmentsToSIdByFunction "
Internal implementation method.
";


%feature("docstring") SBase::multiplyAssignmentsToSIdByFunction "
Internal implementation method.
";


%feature("docstring") SBase::getElementFromPluginsBySId "
Internal implementation method.
";


%feature("docstring") SBase::getElementFromPluginsByMetaId "
Internal implementation method.
";


%feature("docstring") SBase::hasNonstandardIdentifierBeginningWith "
Internal implementation method.
";


%feature("docstring") SBase::prependStringToAllIdentifiers "
Internal implementation method.
";


%feature("docstring") SBase::transformIdentifiers "
Internal implementation method.
";


%feature("docstring") SBase::getAllElementsFromPlugins "
Returns a List of all child SBase objects contained in SBML package
plug-ins.

SBML Level 3 consists of a Core definition that can be extended via
optional SBML Level 3 packages.  A given model may indicate that it
uses one or more SBML packages, and likewise, a software tool may be
able to support one or more packages.  LibSBML does not come
preconfigured with all possible packages included and enabled, in part
because not all package specifications have been finalized.  To
support the ability for software systems to enable support for the
Level 3 packages they choose, libSBML features a plug-in mechanism.
Each SBML Level 3 package is implemented in a separate code plug-in
that can be enabled by the application to support working with that
SBML package.  A given SBML model may thus contain not only objects
defined by SBML Level 3 Core, but also objects created by libSBML
plug-ins supporting additional Level 3 packages.

This method walks down the list of all SBML Level 3 packages used by
this object and returns all child objects defined by those packages.

Parameter 'filter' is a pointer to an ElementFilter, which causes the
function  to return only elements that match a particular set of
constraints.   If None (the default), the function will return all
child objects.

Returns a pointer to a List of pointers to all children objects from
plug-ins.

</dl><dl class=\"docnote\"><dt>Documentation note:</dt><dd> The native
C++ implementation of this method defines a default argument value. In
the documentation generated for different libSBML language bindings,
you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is
handled by declaring two separate methods, with one of them having the
argument and the other one lacking the argument. However, the libSBML
documentation will be identical for both methods. Consequently, if you
are reading this and do not see an argument even though one is
described, please look for descriptions of other variants of this
method near where this one appears in the documentation. </dd></dl>
";


%feature("docstring") SBase::getMetaId "
Returns the value of the 'metaid' attribute of this SBML object.

The optional attribute named 'metaid', present on every major SBML
component type, is for supporting metadata annotations using RDF
(Resource Description Format).  The attribute value has the data type
XML ID, the XML identifier type, which means each 'metaid' value must
be globally unique within an SBML file.  The latter point is
important, because the uniqueness criterion applies across any
attribute with type ID anywhere in the file, not just the 'metaid'
attribute used by SBML---something to be aware of if your application-
specific XML content inside the 'annotation' subelement happens to use
the XML ID type.  Although SBML itself specifies the use of XML ID
only for the 'metaid' attribute, SBML-compatible applications should
be careful if they use XML ID's in XML portions of a model that are
not defined by SBML, such as in the application-specific content of
the 'annotation' subelement.  Finally, note that LibSBML does not
provide an explicit XML ID data type; it uses ordinary character
strings, which is easier for applications to support.

Returns the meta-identifier of this SBML object.

See also isSetMetaId(), setMetaId().
";


%feature("docstring") SBase::getId "
Returns the value of the 'id' attribute of this SBML object, if it has
one,  or the 'variable' attribute of a Rule, or the 'symbol' attribute
of an InitialAssignment.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
getIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns the id of this SBML object, or the 'variable' if the object
is a Rule, or the 'symbol' if the object is an InitialAssignment.

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") SBase::getIdAttribute "
Returns the value of the 'id' attribute of this SBML object.

Note: Because of the inconsistent behavior of the old SBase.getId()
function with respect to assignments and rules, it is now  recommended
to use this getIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns the id of this SBML object, if set and valid for this level
and version of SBML; an empty string otherwise.

See also setIdAttribute(), isSetIdAttribute(), unsetIdAttribute().
";


%feature("docstring") SBase::getName "
Returns the value of the 'name' attribute of this SBML object.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns the name of this SBML object, or the empty string if not set
or unsettable.

See also getIdAttribute(), isSetName(), setName(), unsetName().
";


%feature("docstring") SBase::getNotes "
Returns the content of the 'notes' subelement of this object as a tree
of XMLNode objects.

The optional SBML element named 'notes', present on every major SBML
component type (and in SBML Level 3, the 'message' subelement of
Constraint), is intended as a place for storing optional information
intended to be seen by humans.  An example use of the 'notes' element
would be to contain formatted user comments about the model element in
which the 'notes' element is enclosed.  Every object derived directly
or indirectly from type SBase can have a separate value for 'notes',
allowing users considerable freedom when adding comments to their
models.

The format of 'notes' elements conform to the definition of XHTML 1.0.
However, the content cannot be entirely free-form; it must satisfy
certain requirements defined in the SBML specifications for specific
SBML Levels.  To help verify the formatting of 'notes' content,
libSBML provides the static utility method
SyntaxChecker.hasExpectedXHTMLSyntax(); this method implements a
verification process that lets callers check whether the content of a
given XMLNode object conforms to the SBML requirements for 'notes' and
'message' structure.  Developers are urged to consult the appropriate
SBML specification document for the Level and Version of their model
for more in-depth explanations of using 'notes' in SBML.  The SBML
Level 2 and 3 specifications have considerable detail about how
'notes' element content must be structured.

The 'notes' element content returned by this method will be in XML
form, but libSBML does not provide an object model specifically for
the content of notes.  Callers will need to traverse the XML tree
structure using the facilities available on XMLNode and related
objects.  For an alternative method of accessing the notes, see
getNotesString().

Returns the content of the 'notes' subelement of this SBML object as a
tree structure composed of XMLNode objects.

See also getNotesString(), isSetNotes(), setNotes(), setNotes(),
appendNotes(), appendNotes(), unsetNotes(),
SyntaxChecker.hasExpectedXHTMLSyntax().
";


%feature("docstring") SBase::getNotesString "
Returns the content of the 'notes' subelement of this object as a
string.

The optional SBML element named 'notes', present on every major SBML
component type (and in SBML Level 3, the 'message' subelement of
Constraint), is intended as a place for storing optional information
intended to be seen by humans.  An example use of the 'notes' element
would be to contain formatted user comments about the model element in
which the 'notes' element is enclosed.  Every object derived directly
or indirectly from type SBase can have a separate value for 'notes',
allowing users considerable freedom when adding comments to their
models.

The format of 'notes' elements conform to the definition of XHTML 1.0.
However, the content cannot be entirely free-form; it must satisfy
certain requirements defined in the SBML specifications for specific
SBML Levels.  To help verify the formatting of 'notes' content,
libSBML provides the static utility method
SyntaxChecker.hasExpectedXHTMLSyntax(); this method implements a
verification process that lets callers check whether the content of a
given XMLNode object conforms to the SBML requirements for 'notes' and
'message' structure.  Developers are urged to consult the appropriate
SBML specification document for the Level and Version of their model
for more in-depth explanations of using 'notes' in SBML.  The SBML
Level 2 and 3 specifications have considerable detail about how
'notes' element content must be structured.

For an alternative method of accessing the notes, see getNotes(),
which returns the content as an XMLNode tree structure.  Depending on
an application's needs, one or the other method may be more
convenient.

Returns the content of the 'notes' subelement of this SBML object as a
string.

See also getNotes(), isSetNotes(), setNotes(), setNotes(),
appendNotes(), appendNotes(), unsetNotes(),
SyntaxChecker.hasExpectedXHTMLSyntax().
";


%feature("docstring") SBase::getAnnotation "
Returns the content of the 'annotation' subelement of this object as a
tree of XMLNode objects.

Whereas the SBML 'notes' subelement is a container for content to be
shown directly to humans, the 'annotation' element is a container for
optional software-generated content not meant to be shown to humans.
Every object derived from SBase can have its own value for
'annotation'.  The element's content type is XML type 'any', allowing
essentially arbitrary well-formed XML data content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.

The annotations returned by this method will be in XML form.  LibSBML
provides an object model and related interfaces for certain specific
kinds of annotations, namely model history information and RDF
content.  See the ModelHistory, CVTerm and RDFAnnotationParser classes
for more information about the facilities available.

Returns the annotation of this SBML object as a tree of XMLNode
objects.

See also getAnnotationString(), isSetAnnotation(), setAnnotation(),
setAnnotation(), appendAnnotation(), appendAnnotation(),
unsetAnnotation().
";


%feature("docstring") SBase::getAnnotationString "
Returns the content of the 'annotation' subelement of this object as a
character string.

Whereas the SBML 'notes' subelement is a container for content to be
shown directly to humans, the 'annotation' element is a container for
optional software-generated content not meant to be shown to humans.
Every object derived from SBase can have its own value for
'annotation'.  The element's content type is XML type 'any', allowing
essentially arbitrary well-formed XML data content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.

The annotations returned by this method will be in string form.  See
the method getAnnotation() for a version that returns annotations in
XML form.

Returns the annotation of this SBML object as a character string.

See also getAnnotation(), isSetAnnotation(), setAnnotation(),
setAnnotation(), appendAnnotation(), appendAnnotation(),
unsetAnnotation().
";


%feature("docstring") SBase::getNamespaces "
Returns a list of the XML Namespaces declared on the SBML document
owning this object.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.

Returns the XML Namespaces associated with this SBML object, or 'None'
in certain very usual circumstances where a namespace is not set.

See also getLevel(), getVersion().
";


%feature("docstring") SBase::getSBMLDocument "
Returns the SBMLDocument object containing this object instance.

LibSBML uses the class SBMLDocument as a top-level container for
storing SBML content and data associated with it (such as warnings and
error messages).  An SBML model in libSBML is contained inside an
SBMLDocument object.  SBMLDocument corresponds roughly to the class
SBML defined in the SBML Level 3 and Level 2 specifications, but it
does not have a direct correspondence in SBML Level 1.  (But, it is
created by libSBML no matter whether the model is Level 1, Level 2 or
Level 3.)

This method allows the caller to obtain the SBMLDocument for the
current object.

Returns the parent SBMLDocument object of this SBML object.

See also getParentSBMLObject(), getModel().
";


%feature("docstring") SBase::getParentSBMLObject "
Returns the parent SBML object containing this object.

This returns the immediately-containing object.  This method is
convenient when holding an object nested inside other objects in an
SBML model.

Returns the parent SBML object of this SBML object.

See also getSBMLDocument(), getModel().
";


%feature("docstring") SBase::getAncestorOfType "
Returns the first ancestor object that has the given SBML type code
from the given package.

LibSBML attaches an identifying code to every kind of SBML object.
These are known as SBML type codes.  In the Python language interface
for libSBML, the type codes are defined as static integer constants in
the interface class 'libsbml'.  The names of the type codes all begin
with the characters 'SBML_.'

This method searches the tree of objects that are parents of this
object, and returns the first one that has the given SBML type code
from  the given 'pkgName'.

Parameter 'type' is the SBML type code of the object sought.

Parameter 'pkgName' is (optional) the short name of an SBML Level 3
package to which the sought-after object must belong.

Returns the ancestor SBML object of this SBML object that corresponds
to the given SBML object type code, or 'None' if no ancestor exists.

WARNING:

The optional argument 'pkgName' must be used for all type codes from
SBML Level 3 packages.  Otherwise, the function will search the
'core' namespace alone, not find any corresponding elements, and
return  None.

</dl><dl class=\"docnote\"><dt>Documentation note:</dt><dd> The native
C++ implementation of this method defines a default argument value. In
the documentation generated for different libSBML language bindings,
you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is
handled by declaring two separate methods, with one of them having the
argument and the other one lacking the argument. However, the libSBML
documentation will be identical for both methods. Consequently, if you
are reading this and do not see an argument even though one is
described, please look for descriptions of other variants of this
method near where this one appears in the documentation. </dd></dl>

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") SBase::getSBOTerm "
Returns the integer portion of the value of the 'sboTerm' attribute of
this object.

Beginning with SBML Level 2 Version 2, objects derived from SBase
have an optional attribute named 'sboTerm' for supporting the use of
the Systems Biology Ontology.  In SBML proper, the data type of the
attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
seven digit integer number; libSBML simplifies the representation by
only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
'sboTerm' attribute on SBase has data type 'int,' and SBO identifiers
are stored simply as integers.

SBO terms are a type of optional annotation, and each different class
of SBML object derived from SBase imposes its own requirements about
the values permitted for 'sboTerm'. More details can be found in SBML
specifications for Level 2 Version 2 and above.

Returns the value of the 'sboTerm' attribute as an integer, or '-1' if
the value is not set.
";


%feature("docstring") SBase::getSBOTermID "
Returns the string representation of the 'sboTerm' attribute of this
object.

Beginning with SBML Level 2 Version 2, objects derived from SBase
have an optional attribute named 'sboTerm' for supporting the use of
the Systems Biology Ontology.  In SBML proper, the data type of the
attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
seven digit integer number; libSBML simplifies the representation by
only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
'sboTerm' attribute on SBase has data type 'int,' and SBO identifiers
are stored simply as integers.

SBO terms are a type of optional annotation, and each different class
of SBML object derived from SBase imposes its own requirements about
the values permitted for 'sboTerm'. More details can be found in SBML
specifications for Level 2 Version 2 and above.

Returns the value of the 'sboTerm' attribute as a string (its value
will be of the form 'SBO:NNNNNNN'), or an empty string if the value is
not set.
";


%feature("docstring") SBase::getSBOTermAsURL "
Returns the URL representation of the 'sboTerm' attribute of this
object.

This method returns the entire SBO identifier as a text string in the
form http://identifiers.org/biomodels.sbo/SBO:NNNNNNN'.

SBO terms are a type of optional annotation, and each different class
of SBML object derived from SBase imposes its own requirements about
the values permitted for 'sboTerm'. More details can be found in SBML
specifications for Level 2 Version 2 and above.

Returns the value of the 'sboTerm' attribute as an identifiers.org
URL, or an empty string if the value is not set.
";


%feature("docstring") SBase::getLine "
Returns the line number where this object first appears in the XML
representation of the SBML document.

Returns the line number of this SBML object.  If this object was
created programmatically and not read from a file, this method will
return the value '0.'

Note: The line number for each construct in an SBML model is set upon
reading the model.  The accuracy of the line number depends on the
correctness of the XML representation of the model, and on the
particular XML parser library being used.  The former limitation
relates to the following problem: if the model is actually invalid
XML, then the parser may not be able to interpret the data correctly
and consequently may not be able to establish the real line number.
The latter limitation is simply that different parsers seem to have
their own accuracy limitations, and out of all the parsers supported
by libSBML, none have been 100% accurate in all situations. (At this
time, libSBML supports the use of libxml2, Expat and Xerces.)

See also getColumn().
";


%feature("docstring") SBase::getColumn "
Returns the column number where this object first appears in the XML
representation of the SBML document.

Returns the column number of this SBML object.  If this object was
created programmatically and not read from a file, this method will
return the value '0.'

Note: The column number for each construct in an SBML model is set
upon reading the model.  The accuracy of the column number depends on
the correctness of the XML representation of the model, and on the
particular XML parser library being used.  The former limitation
relates to the following problem: if the model is actually invalid
XML, then the parser may not be able to interpret the data correctly
and consequently may not be able to establish the real column number.
The latter limitation is simply that different parsers seem to have
their own accuracy limitations, and out of all the parsers supported
by libSBML, none have been 100% accurate in all situations. (At this
time, libSBML supports the use of libxml2, Expat and Xerces.)

See also getLine().
";


%feature("docstring") SBase::getModelHistory "
Returns the ModelHistory object, if any, attached to this object.

Returns the ModelHistory object attached to this object, or 'None' if
none exist.

Note: In SBML Level 2, model history annotations were only permitted
on the Model element.  In SBML Level 3, they are permitted on all SBML
components derived from SBase.
";


%feature("docstring") SBase::isSetMetaId "
Predicate returning 'True' if this object's 'metaid' attribute is set.

The optional attribute named 'metaid', present on every major SBML
component type, is for supporting metadata annotations using RDF
(Resource Description Format).  The attribute value has the data type
XML ID, the XML identifier type, which means each 'metaid' value must
be globally unique within an SBML file.  The latter point is
important, because the uniqueness criterion applies across any
attribute with type ID anywhere in the file, not just the 'metaid'
attribute used by SBML---something to be aware of if your application-
specific XML content inside the 'annotation' subelement happens to use
the XML ID type.  Although SBML itself specifies the use of XML ID
only for the 'metaid' attribute, SBML-compatible applications should
be careful if they use XML ID's in XML portions of a model that are
not defined by SBML, such as in the application-specific content of
the 'annotation' subelement.  Finally, note that LibSBML does not
provide an explicit XML ID data type; it uses ordinary character
strings, which is easier for applications to support.

Returns 'True' if the 'metaid' attribute of this SBML object is set,
'False' otherwise.

See also getMetaId(), setMetaId().
";


%feature("docstring") SBase::isSetId "
Predicate returning 'True' if a call to getId() returns a  non-empty
string.  This means that for most objects, this  function will return
'True' if its 'id' attribute is set, and 'False' if it is not, or if
the object has no 'id' attribute at all.  However, for an
EventAssignment or a Rule, isSetId()  checks whether the 'variable'
attribute is set, and for an InitialAssignment, it checks whether the
'symbol' attribute is set.  Because those elements will also have an
'id' attribute in SBML Level 3 Version 2 which isSetId() will not
check, the function itself is deprecated, and it is recommended to use
isSetIdAttribute() in all cases where one needs to know whether the
'id' attribute is set, and to use EventAssignment.isSetVariable(),
Rule.isSetVariable() and InitialAssignment.isSetSymbol() when the
status of the 'variable' or 'symbol' attributes need to be checked.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
isSetIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns 'True' if the 'id' attribute of this SBML object is set,
'False' otherwise.

See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
isSetIdAttribute().
";


%feature("docstring") SBase::isSetIdAttribute "
Predicate returning 'True' if this object's 'id' attribute is set.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns 'True' if the 'id' attribute of this SBML object is set,
'False' otherwise.

See also getIdAttribute(), setIdAttribute(), unsetIdAttribute().
";


%feature("docstring") SBase::isSetName "
Predicate returning 'True' if this object's 'name' attribute is set.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns 'True' if the 'name' attribute of this SBML object is set,
'False' otherwise.

See also getName(), setName(), unsetName().
";


%feature("docstring") SBase::isSetNotes "
Predicate returning 'True' if this object's 'notes' subelement exists
and has content.

The optional SBML element named 'notes', present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
'notes' element would be to contain formatted user comments about the
model element in which the 'notes' element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for 'notes', allowing users considerable freedom when adding
comments to their models.

The format of 'notes' elements must be XHTML 1.0.  To help verify the
formatting of 'notes' content, libSBML provides the static utility
method SyntaxChecker.hasExpectedXHTMLSyntax(); however, readers are
urged to consult the appropriate SBML specification document for the
Level and Version of their model for more in-depth explanations.  The
SBML Level 2 and 3 specifications have considerable detail about how
'notes' element content must be structured.

Returns 'True' if a 'notes' subelement exists, 'False' otherwise.

See also getNotes(), getNotesString(), setNotes(), setNotes(),
appendNotes(), appendNotes(), unsetNotes(),
SyntaxChecker.hasExpectedXHTMLSyntax().
";


%feature("docstring") SBase::isSetAnnotation "
Predicate returning 'True' if this object's 'annotation' subelement
exists and has content.

Whereas the SBase 'notes' subelement is a container for content to be
shown directly to humans, the 'annotation' element is a container for
optional software-generated content not meant to be shown to humans.
Every object derived from SBase can have its own value for
'annotation'.  The element's content type is XML type 'any', allowing
essentially arbitrary well-formed XML data content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.

Returns 'True' if a 'annotation' subelement exists, 'False' otherwise.

See also getAnnotation(), getAnnotationString(), setAnnotation(),
setAnnotation(), appendAnnotation(), appendAnnotation(),
unsetAnnotation().
";


%feature("docstring") SBase::isSetSBOTerm "
Predicate returning 'True' if this object's 'sboTerm' attribute is
set.

Returns 'True' if the 'sboTerm' attribute of this SBML object is set,
'False' otherwise.
";


%feature("docstring") SBase::setMetaId "
Sets the value of the meta-identifier attribute of this SBML object.

The optional attribute named 'metaid', present on every major SBML
component type, is for supporting metadata annotations using RDF
(Resource Description Format).  The attribute value has the data type
XML ID, the XML identifier type, which means each 'metaid' value must
be globally unique within an SBML file.  The latter point is
important, because the uniqueness criterion applies across any
attribute with type ID anywhere in the file, not just the 'metaid'
attribute used by SBML---something to be aware of if your application-
specific XML content inside the 'annotation' subelement happens to use
the XML ID type.  Although SBML itself specifies the use of XML ID
only for the 'metaid' attribute, SBML-compatible applications should
be careful if they use XML ID's in XML portions of a model that are
not defined by SBML, such as in the application-specific content of
the 'annotation' subelement.  Finally, note that LibSBML does not
provide an explicit XML ID data type; it uses ordinary character
strings, which is easier for applications to support.

The string 'metaid' is copied.

Parameter 'metaid' is the identifier string to use as the value of the
'metaid' attribute.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

See also getMetaId(), isSetMetaId().
";


%feature("docstring") SBase::isSetModelHistory "
Predicate returning 'True' if this object has a ModelHistory object
attached to it.

Returns 'True' if the ModelHistory of this object is set, 'False'
otherwise.

Note: In SBML Level 2, model history annotations were only permitted
on the Model element.  In SBML Level 3, they are permitted on all SBML
components derived from SBase.
";


%feature("docstring") SBase::setId "
Sets the value of the 'id' attribute of this SBML object.

The string 'sid' is copied.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Parameter 'sid' is the string to use as the identifier of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") SBase::setIdAttribute "
Sets the value of the 'id' attribute of this SBML object.

The string 'sid' is copied.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Parameter 'sid' is the string to use as the identifier of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") SBase::setName "
Sets the value of the 'name' attribute of this SBML object.

The string in 'name' is copied.

Parameter 'name' is the new name for the SBML object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") SBase::setAnnotation "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    setAnnotation(XMLNode annotation)

Sets the value of the 'annotation' subelement of this SBML object.

The content of 'annotation' is copied, and any previous content of
this object's 'annotation' subelement is deleted.

Whereas the SBase 'notes' subelement is a container for content to be
shown directly to humans, the 'annotation' element is a container for
optional software-generated content not meant to be shown to humans.
Every object derived from SBase can have its own value for
'annotation'.  The element's content type is XML type 'any', allowing
essentially arbitrary well-formed XML data content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.

Call this method will result in any existing content of the
'annotation' subelement to be discarded.  Unless you have taken steps
to first copy and reconstitute any existing annotations into the
'annotation' that is about to be assigned, it is likely that
performing such wholesale replacement is unfriendly towards other
software applications whose annotations are discarded.  An alternative
may be to use SBase.appendAnnotation() or SBase.appendAnnotation().

Parameter 'annotation' is an XML structure that is to be used as the
new content of the 'annotation' subelement of this object.

Returns integer value indicating success/failure of the function.
This particular function only does one thing irrespective of user
input or  object state, and thus will only return a single value:

* LIBSBML_OPERATION_SUCCESS

See also getAnnotationString(), isSetAnnotation(), setAnnotation(),
appendAnnotation(), appendAnnotation(), unsetAnnotation().

______________________________________________________________________
Method variant with the following signature:

    setAnnotation(string annotation)

Sets the value of the 'annotation' subelement of this SBML object.

The content of 'annotation' is copied, and any previous content of
this object's 'annotation' subelement is deleted.

Whereas the SBase 'notes' subelement is a container for content to be
shown directly to humans, the 'annotation' element is a container for
optional software-generated content not meant to be shown to humans.
Every object derived from SBase can have its own value for
'annotation'.  The element's content type is XML type 'any', allowing
essentially arbitrary well-formed XML data content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.

Call this method will result in any existing content of the
'annotation' subelement to be discarded.  Unless you have taken steps
to first copy and reconstitute any existing annotations into the
'annotation' that is about to be assigned, it is likely that
performing such wholesale replacement is unfriendly towards other
software applications whose annotations are discarded.  An alternative
may be to use SBase.appendAnnotation() or SBase.appendAnnotation().

Parameter 'annotation' is an XML string that is to be used as the
content of the 'annotation' subelement of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also getAnnotationString(), isSetAnnotation(), setAnnotation(),
appendAnnotation(), appendAnnotation(), unsetAnnotation().
";


%feature("docstring") SBase::appendAnnotation "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    appendAnnotation(XMLNode annotation)

Appends the given 'annotation' to the 'annotation' subelement of this
object.

Whereas the SBase 'notes' subelement is a container for content to be
shown directly to humans, the 'annotation' element is a container for
optional software-generated content not meant to be shown to humans.
Every object derived from SBase can have its own value for
'annotation'.  The element's content type is XML type 'any', allowing
essentially arbitrary well-formed XML data content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.

Unlike SBase.setAnnotation() or SBase.setAnnotation(), this method
allows other annotations to be preserved when an application adds its
own data.

Parameter 'annotation' is an XML structure that is to be copied and
appended to the content of the 'annotation' subelement of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

* LIBSBML_UNEXPECTED_ATTRIBUTE (if the parent element does not have
the 'metaid' attribute set)

* LIBSBML_DUPLICATE_ANNOTATION_NS (if the parent was already
annotated with the annotation in question)

See also getAnnotationString(), isSetAnnotation(), setAnnotation(),
setAnnotation(), appendAnnotation(), unsetAnnotation().

______________________________________________________________________
Method variant with the following signature:

    appendAnnotation(string annotation)

Appends the given 'annotation' to the 'annotation' subelement of this
object.

Whereas the SBase 'notes' subelement is a container for content to be
shown directly to humans, the 'annotation' element is a container for
optional software-generated content not meant to be shown to humans.
Every object derived from SBase can have its own value for
'annotation'.  The element's content type is XML type 'any', allowing
essentially arbitrary well-formed XML data content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.

Unlike SBase.setAnnotation() or SBase.setAnnotation(), this method
allows other annotations to be preserved when an application adds its
own data.

Parameter 'annotation' is an XML string that is to be copied and
appended to the content of the 'annotation' subelement of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

* LIBSBML_UNEXPECTED_ATTRIBUTE (if the parent element does not have
the 'metaid' attribute set)

* LIBSBML_DUPLICATE_ANNOTATION_NS (if the parent was already
annotated with the annotation in question)

See also getAnnotationString(), isSetAnnotation(), setAnnotation(),
setAnnotation(), appendAnnotation(), unsetAnnotation().
";


%feature("docstring") SBase::removeTopLevelAnnotationElement "
Removes the top-level element within the 'annotation' subelement of
this SBML object with the given name and optional URI.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.

Calling this method allows a particular annotation element to be
removed whilst the remaining annotations remain intact.

Parameter 'elementName' is a string representing the name of the top
level annotation element that is to be removed. Parameter 'elementURI'
is an optional string that is used to check both the name and URI of
the top level element to be removed. Parameter 'removeEmpty' is if
after removing of the element, the annotation is  empty, and the
removeEmpty argument is true, the annotation node will be  deleted
(default).

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

* LIBSBML_ANNOTATION_NAME_NOT_FOUND

* LIBSBML_ANNOTATION_NS_NOT_FOUND

See also replaceTopLevelAnnotationElement(),
replaceTopLevelAnnotationElement().

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") SBase::replaceTopLevelAnnotationElement "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    replaceTopLevelAnnotationElement(XMLNode annotation)

Replaces the given top-level element within the 'annotation'
subelement of this SBML object and with the annotation element
supplied.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.

This method determines the name of the element to be replaced from the
annotation argument. Functionally it is equivalent to calling
removeTopLevelAnnotationElement(name) followed by calling
appendAnnotation(annotation_with_name), with the exception that the
placement of the annotation element remains the same.

Parameter 'annotation' is XMLNode representing the replacement top
level annotation.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

* LIBSBML_INVALID_OBJECT

See also removeTopLevelAnnotationElement(),
replaceTopLevelAnnotationElement().

______________________________________________________________________
Method variant with the following signature:

    replaceTopLevelAnnotationElement(string annotation)

Replaces the given top-level element within the 'annotation'
subelement of this SBML object and with the annotation element
supplied.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.

This method determines the name of the element to be replaced from the
annotation argument. Functionally it is equivalent to calling
removeTopLevelAnnotationElement(name) followed by calling
appendAnnotation(annotation_with_name), with the exception that the
placement of the annotation element remains the same.

Parameter 'annotation' is string representing the replacement top
level annotation.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

* LIBSBML_INVALID_OBJECT

See also removeTopLevelAnnotationElement(),
replaceTopLevelAnnotationElement().
";


%feature("docstring") SBase::setNotes "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    setNotes(string notes, bool addXHTMLMarkup = false)

Sets the value of the 'notes' subelement of this SBML object to a copy
of the string 'notes'.

The content of 'notes' is copied, and any existing content of this
object's 'notes' subelement is deleted.

The optional SBML element named 'notes', present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
'notes' element would be to contain formatted user comments about the
model element in which the 'notes' element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for 'notes', allowing users considerable freedom when adding
comments to their models.

The format of 'notes' elements must be XHTML 1.0.  To help verify the
formatting of 'notes' content, libSBML provides the static utility
method SyntaxChecker.hasExpectedXHTMLSyntax(); however, readers are
urged to consult the appropriate SBML specification document for the
Level and Version of their model for more in-depth explanations.  The
SBML Level 2 and 3 specifications have considerable detail about how
'notes' element content must be structured.

The following code illustrates a very simple way of setting the notes
using this method.  Here, the object being annotated is the whole SBML
document, but that is for illustration purposes only; you could of
course use this same approach to annotate any other SBML component.

  try:
    sbmlDoc = SBMLDocument(3, 1)
  except ValueError:
    print(\'Could not create SBMLDocument object\')
    sys.exit(1)
  
  note = \'<body xmlns=\'http://www.w3.org/1999/xhtml\'><p>here is my note</p></body>\'
  
  status = sbmlDoc.setNotes(note)
  if status != LIBSBML_OPERATION_SUCCESS:
    # Do something to handle the error here.
    print(\'Unable to set notes on the SBML document object\')
    sys.exit(1)

Parameter 'notes' is an XML string that is to be used as the content
of the 'notes' subelement of this object.

Parameter 'addXHTMLMarkup' is a boolean indicating whether to wrap the
contents of the 'notes' argument with XHTML paragraph (<p>) tags.
This is appropriate when the string in 'notes' does not already
containg the appropriate XHTML markup.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_OBJECT

* LIBSBML_OPERATION_FAILED

See also getNotesString(), isSetNotes(), setNotes(), appendNotes(),
appendNotes(), unsetNotes(), SyntaxChecker.hasExpectedXHTMLSyntax().

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.

______________________________________________________________________
Method variant with the following signature:

    setNotes(XMLNode notes)

Sets the value of the 'notes' subelement of this SBML object.

The content of 'notes' is copied, and any existing content of this
object's 'notes' subelement is deleted.

The optional SBML element named 'notes', present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
'notes' element would be to contain formatted user comments about the
model element in which the 'notes' element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for 'notes', allowing users considerable freedom when adding
comments to their models.

The format of 'notes' elements must be XHTML 1.0.  To help verify the
formatting of 'notes' content, libSBML provides the static utility
method SyntaxChecker.hasExpectedXHTMLSyntax(); however, readers are
urged to consult the appropriate SBML specification document for the
Level and Version of their model for more in-depth explanations.  The
SBML Level 2 and 3 specifications have considerable detail about how
'notes' element content must be structured.

Parameter 'notes' is an XML structure that is to be used as the
content of the 'notes' subelement of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_OBJECT

See also getNotesString(), isSetNotes(), setNotes(), appendNotes(),
appendNotes(), unsetNotes(), SyntaxChecker.hasExpectedXHTMLSyntax().
";


%feature("docstring") SBase::appendNotes "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    appendNotes(string notes)

Appends the given 'notes' to the 'notes' subelement of this object.

The content of the parameter 'notes' is copied.

The optional SBML element named 'notes', present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
'notes' element would be to contain formatted user comments about the
model element in which the 'notes' element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for 'notes', allowing users considerable freedom when adding
comments to their models.

The format of 'notes' elements must be XHTML 1.0.  To help verify the
formatting of 'notes' content, libSBML provides the static utility
method SyntaxChecker.hasExpectedXHTMLSyntax(); however, readers are
urged to consult the appropriate SBML specification document for the
Level and Version of their model for more in-depth explanations.  The
SBML Level 2 and 3 specifications have considerable detail about how
'notes' element content must be structured.

Parameter 'notes' is an XML string that is to appended to the content
of the 'notes' subelement of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_OBJECT

* LIBSBML_OPERATION_FAILED

See also getNotesString(), isSetNotes(), setNotes(), setNotes(),
appendNotes(), unsetNotes(), SyntaxChecker.hasExpectedXHTMLSyntax().

______________________________________________________________________
Method variant with the following signature:

    appendNotes(XMLNode notes)

Appends the given 'notes' to the 'notes' subelement of this object.

The content of 'notes' is copied.

The optional SBML element named 'notes', present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
'notes' element would be to contain formatted user comments about the
model element in which the 'notes' element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for 'notes', allowing users considerable freedom when adding
comments to their models.

The format of 'notes' elements must be XHTML 1.0.  To help verify the
formatting of 'notes' content, libSBML provides the static utility
method SyntaxChecker.hasExpectedXHTMLSyntax(); however, readers are
urged to consult the appropriate SBML specification document for the
Level and Version of their model for more in-depth explanations.  The
SBML Level 2 and 3 specifications have considerable detail about how
'notes' element content must be structured.

Parameter 'notes' is an XML node structure that is to appended to the
content of the 'notes' subelement of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_OBJECT

* LIBSBML_OPERATION_FAILED

See also getNotesString(), isSetNotes(), setNotes(), setNotes(),
appendNotes(), unsetNotes(), SyntaxChecker.hasExpectedXHTMLSyntax().
";


%feature("docstring") SBase::setModelHistory "
Sets the ModelHistory of this object.

The content of 'history' is copied, and this object's existing model
history content is deleted.

Parameter 'history' is ModelHistory of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_INVALID_OBJECT

Note: In SBML Level 2, model history annotations were only permitted
on the Model element.  In SBML Level 3, they are permitted on all SBML
components derived from SBase.
";


%feature("docstring") SBase::setSBMLDocument "
Internal implementation method.
";


%feature("docstring") SBase::connectToParent "
Internal implementation method.
";


%feature("docstring") SBase::setSBOTerm "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    setSBOTerm(int value)

Sets the value of the 'sboTerm' attribute.

Beginning with SBML Level 2 Version 2, objects derived from SBase
have an optional attribute named 'sboTerm' for supporting the use of
the Systems Biology Ontology.  In SBML proper, the data type of the
attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
seven digit integer number; libSBML simplifies the representation by
only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
'sboTerm' attribute on SBase has data type 'int,' and SBO identifiers
are stored simply as integers.

SBO terms are a type of optional annotation, and each different class
of SBML object derived from SBase imposes its own requirements about
the values permitted for 'sboTerm'. More details can be found in SBML
specifications for Level 2 Version 2 and above.

Parameter 'value' is the NNNNNNN integer portion of the SBO
identifier.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

See also setSBOTerm().

______________________________________________________________________
Method variant with the following signature:

    setSBOTerm(string &sboid)

Sets the value of the 'sboTerm' attribute by string.

Beginning with SBML Level 2 Version 2, objects derived from SBase
have an optional attribute named 'sboTerm' for supporting the use of
the Systems Biology Ontology.  In SBML proper, the data type of the
attribute is a string of the form 'SBO:NNNNNNN', where 'NNNNNNN' is a
seven digit integer number; libSBML simplifies the representation by
only storing the 'NNNNNNN' integer portion.  Thus, in libSBML, the
'sboTerm' attribute on SBase has data type 'int,' and SBO identifiers
are stored simply as integers.

SBO terms are a type of optional annotation, and each different class
of SBML object derived from SBase imposes its own requirements about
the values permitted for 'sboTerm'. More details can be found in SBML
specifications for Level 2 Version 2 and above.

Parameter 'sboid' is the SBO identifier string of the form
'SBO:NNNNNNN'.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

See also setSBOTerm().
";


%feature("docstring") SBase::setNamespaces "
Sets the namespaces relevant of this SBML object.

The content of 'xmlns' is copied, and this object's existing namespace
content is deleted.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.

Parameter 'xmlns' is the namespaces to set.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS
";


%feature("docstring") SBase::unsetMetaId "
Unsets the value of the 'metaid' attribute of this SBML object.

The optional attribute named 'metaid', present on every major SBML
component type, is for supporting metadata annotations using RDF
(Resource Description Format).  The attribute value has the data type
XML ID, the XML identifier type, which means each 'metaid' value must
be globally unique within an SBML file.  The latter point is
important, because the uniqueness criterion applies across any
attribute with type ID anywhere in the file, not just the 'metaid'
attribute used by SBML---something to be aware of if your application-
specific XML content inside the 'annotation' subelement happens to use
the XML ID type.  Although SBML itself specifies the use of XML ID
only for the 'metaid' attribute, SBML-compatible applications should
be careful if they use XML ID's in XML portions of a model that are
not defined by SBML, such as in the application-specific content of
the 'annotation' subelement.  Finally, note that LibSBML does not
provide an explicit XML ID data type; it uses ordinary character
strings, which is easier for applications to support.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_OPERATION_FAILED
";


%feature("docstring") SBase::unsetId "
Unsets the value of the 'id' attribute of this SBML object.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") SBase::unsetIdAttribute "
Unsets the value of the 'id' attribute of this SBML object.

Most (but not all) objects in SBML include two common attributes: 'id'
and 'name'.  The identifier given by an object's 'id' attribute value
is used to identify the object within the SBML model definition. Other
objects can refer to the component using this identifier.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute().
";


%feature("docstring") SBase::unsetName "
Unsets the value of the 'name' attribute of this SBML object.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also getName(), setName(), isSetName().
";


%feature("docstring") SBase::unsetNotes "
Unsets the value of the 'notes' subelement of this SBML object.

The optional SBML element named 'notes', present on every major SBML
component type, is intended as a place for storing optional
information intended to be seen by humans.  An example use of the
'notes' element would be to contain formatted user comments about the
model element in which the 'notes' element is enclosed.  Every object
derived directly or indirectly from type SBase can have a separate
value for 'notes', allowing users considerable freedom when adding
comments to their models.

The format of 'notes' elements must be XHTML 1.0.  To help verify the
formatting of 'notes' content, libSBML provides the static utility
method SyntaxChecker.hasExpectedXHTMLSyntax(); however, readers are
urged to consult the appropriate SBML specification document for the
Level and Version of their model for more in-depth explanations.  The
SBML Level 2 and 3 specifications have considerable detail about how
'notes' element content must be structured.

Returns integer value indicating success/failure of the function.
This particular function only does one thing irrespective of user
input or  object state, and thus will only return a single value:

* LIBSBML_OPERATION_SUCCESS

See also getNotesString(), isSetNotes(), setNotes(), setNotes(),
appendNotes(), appendNotes(), SyntaxChecker.hasExpectedXHTMLSyntax().
";


%feature("docstring") SBase::unsetAnnotation "
Unsets the value of the 'annotation' subelement of this SBML object.

Whereas the SBase 'notes' subelement is a container for content to be
shown directly to humans, the 'annotation' element is a container for
optional software-generated content not meant to be shown to humans.
Every object derived from SBase can have its own value for
'annotation'.  The element's content type is XML type 'any', allowing
essentially arbitrary well-formed XML data content.

SBML places a few restrictions on the organization of the content of
annotations; these are intended to help software tools read and write
the data as well as help reduce conflicts between annotations added by
different tools.  Please see the SBML specifications for more details.

Returns integer value indicating success/failure of the function.
This particular function only does one thing irrespective of user
input or  object state, and thus will only return a single value:

* LIBSBML_OPERATION_SUCCESS

See also getAnnotation(), getAnnotationString(), isSetAnnotation(),
setAnnotation(), setAnnotation(), appendAnnotation(),
appendAnnotation().
";


%feature("docstring") SBase::unsetSBOTerm "
Unsets the value of the 'sboTerm' attribute of this SBML object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE
";


%feature("docstring") SBase::addCVTerm "
Adds a copy of the given CVTerm object to this SBML object.

Parameter 'term' is the CVTerm to assign.

Parameter 'newBag' is if 'True,' creates a new RDF bag with the same
identifier as a previous bag, and if 'False,' adds the term to an
existing RDF bag with the same type of qualifier as the term being
added.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

* LIBSBML_UNEXPECTED_ATTRIBUTE, if this object lacks a 'metaid'
attribute

* LIBSBML_INVALID_OBJECT

Note: Since the CV Term uses the 'metaid' attribute of the object as a
reference, if the object has no 'metaid' attribute value set, then the
CVTerm will not be added.

Note: This method should be used with some caution.  The fact that
this method copies the object passed to it means that the caller will
be left holding a physically different object instance than the one
contained inside this object.  Changes made to the original object
instance (such as resetting attribute values) will not affect the
instance in this object.  In addition, the caller should make sure to
free the original object if it is no longer being used, or else a
memory leak will result.  Please see other methods on this class
(particularly a corresponding method whose name begins with the word
create) for alternatives that do not lead to these issues.

</dl><dl class=\"docnote\"><dt>Documentation note:</dt><dd> The native
C++ implementation of this method defines a default argument value. In
the documentation generated for different libSBML language bindings,
you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is
handled by declaring two separate methods, with one of them having the
argument and the other one lacking the argument. However, the libSBML
documentation will be identical for both methods. Consequently, if you
are reading this and do not see an argument even though one is
described, please look for descriptions of other variants of this
method near where this one appears in the documentation. </dd></dl>

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") SBase::getCVTerms "
Returns a list of CVTerm objects in the annotations of this SBML
object.

Returns the list of CVTerms for this SBML object.
";


%feature("docstring") SBase::getNumCVTerms "
Returns the number of CVTerm objects in the annotations of this SBML
object.

Returns the number of CVTerms for this SBML object.
";


%feature("docstring") SBase::getCVTerm "
Returns the nth CVTerm in the list of CVTerms of this SBML object.

Parameter 'n' is long the index of the CVTerm to retrieve.

Returns the nth CVTerm in the list of CVTerms for this SBML object.
";


%feature("docstring") SBase::unsetCVTerms "
Clears the list of CVTerm objects attached to this SBML object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED
";


%feature("docstring") SBase::unsetModelHistory "
Unsets the ModelHistory object attached to this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_OPERATION_FAILED

Note: In SBML Level 2, model history annotations were only permitted
on the Model element.  In SBML Level 3, they are permitted on all SBML
components derived from SBase.
";


%feature("docstring") SBase::getResourceBiologicalQualifier "
Returns the MIRIAM biological qualifier associated with the given
resource.

In MIRIAM, qualifiers are an optional means of indicating the
relationship between a model component and its annotations.  There are
two broad kinds of annotations: model and biological.  The latter kind
is used to qualify the relationship between a model component and a
biological entity which it represents.  Examples of relationships
include 'is' and 'has part', but many others are possible.  MIRIAM
defines numerous relationship qualifiers to enable different software
tools to qualify biological annotations in the same standardized way.
In libSBML, the MIRIAM controlled-vocabulary annotations on an SBML
model element are represented using lists of CVTerm objects, and the
the MIRIAM biological qualifiers are represented using values whose
names begin with BQB_ in the interface class libsbml.

This method searches the controlled-vocabulary annotations (i.e., the
list of CVTerm objects) on the present object, then out of those that
have biological qualifiers, looks for an annotation to the given
'resource'.  If such an annotation is found, it returns the type of
biological qualifier associated with that resource as a  value whose
name begins with BQB_ from the interface class libsbml.

Parameter 'resource' is string representing the resource; e.g.,
'http://www.geneontology.org/#GO:0005892'.

Returns the qualifier associated with the resource, or BQB_UNKNOWN if
the resource does not exist.

Note: The set of MIRIAM biological qualifiers grows over time,
although relatively slowly.  The values are up to date with MIRIAM at
the time of a given libSBML release.  The set of values in list of
BQB_ constants defined in libsbml may be expanded in later libSBML
releases, to match the values defined by MIRIAM at that later time.
";


%feature("docstring") SBase::getResourceModelQualifier "
Returns the MIRIAM model qualifier associated with the given resource.

In MIRIAM, qualifiers are an optional means of indicating the
relationship between a model component and its annotations.  There are
two broad kinds of annotations: model and biological.  The former kind
is used to qualify the relationship between a model component and
another modeling object.  An example qualifier is 'isDerivedFrom', to
indicate that a given component of the model is derived from the
modeling object represented by the referenced resource.  MIRIAM
defines numerous relationship qualifiers to enable different software
tools to qualify model annotations in the same standardized way.  In
libSBML, the MIRIAM controlled-vocabulary annotations on an SBML model
element are represented using lists of CVTerm objects, and the  the
MIRIAM model qualifiers are represented using values whose names begin
with BQM_ in the interface class libsbml.

This method method searches the controlled-vocabulary annotations
(i.e., the list of CVTerm objects) on the present object, then out of
those that have model qualifiers, looks for an annotation to the given
'resource'.  If such an annotation is found, it returns the type of
type of model qualifier associated with that resource as a  value
whose name begins with BQM_ from the interface class libsbml.

Parameter 'resource' is string representing the resource; e.g.,
'http://www.geneontology.org/#GO:0005892'.

Returns the model qualifier type associated with the resource, or
BQM_UNKNOWN if the resource does not exist.

Note: The set of MIRIAM model qualifiers grows over time, although
relatively slowly.  The values are up to date with MIRIAM at the time
of a given libSBML release.  The set of values in list of BQM_
constants defined in libsbml may be expanded in later libSBML
releases, to match the values defined by MIRIAM at that later time.
";


%feature("docstring") SBase::getModel "
Returns the Model object for the SBML Document in which the current
object is located.

Returns the Model object for the SBML Document of this SBML object.

See also getParentSBMLObject(), getSBMLDocument().
";


%feature("docstring") SBase::getLevel "
Returns the SBML Level of the SBMLDocument object containing this
object.

LibSBML uses the class SBMLDocument as a top-level container for
storing SBML content and data associated with it (such as warnings and
error messages).  An SBML model in libSBML is contained inside an
SBMLDocument object.  SBMLDocument corresponds roughly to the class
SBML defined in the SBML Level 3 and Level 2 specifications, but it
does not have a direct correspondence in SBML Level 1.  (But, it is
created by libSBML no matter whether the model is Level 1, Level 2 or
Level 3.)

Returns the SBML level of this SBML object.

See also getVersion(), getNamespaces(), getPackageVersion().
";


%feature("docstring") SBase::getVersion "
Returns the Version within the SBML Level of the SBMLDocument object
containing this object.

LibSBML uses the class SBMLDocument as a top-level container for
storing SBML content and data associated with it (such as warnings and
error messages).  An SBML model in libSBML is contained inside an
SBMLDocument object.  SBMLDocument corresponds roughly to the class
SBML defined in the SBML Level 3 and Level 2 specifications, but it
does not have a direct correspondence in SBML Level 1.  (But, it is
created by libSBML no matter whether the model is Level 1, Level 2 or
Level 3.)

Returns the SBML version of this SBML object.

See also getLevel(), getNamespaces().
";


%feature("docstring") SBase::getPackageCoreVersion "
Returns the SBML Core Version within the SBML Level of the actual
object.

LibSBML uses the class SBMLDocument as a top-level container for
storing SBML content and data associated with it (such as warnings and
error messages).  An SBML model in libSBML is contained inside an
SBMLDocument object.  SBMLDocument corresponds roughly to the class
SBML defined in the SBML Level 3 and Level 2 specifications, but it
does not have a direct correspondence in SBML Level 1.  (But, it is
created by libSBML no matter whether the model is Level 1, Level 2 or
Level 3.)

Returns the SBML core version of this SBML object.
";


%feature("docstring") SBase::getPackageVersion "
Returns the Version of the SBML Level 3 package to which this element
belongs to.

Returns the version of the SBML Level 3 package to which this element
belongs. The value '0' will be returned if this element belongs to the
SBML Level 3 Core package.

See also getLevel(), getVersion().
";


%feature("docstring") SBase::getPackageName "
Returns the name of the SBML Level 3 package in which this element is
defined.

Returns the name of the SBML package in which this element is defined.
The string \"core\" will be returned if this element is defined in
SBML Level 3 Core. The string \"unknown\" will be returned if this
element is not defined in any SBML package.
";


%feature("docstring") SBase::getTypeCode "
Returns the libSBML type code for this object.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Here follow some additional general information about libSBML type
codes:

* The codes are the possible return values (integers) for the
following functions:

* SBase.getTypeCode()

* ListOf.getItemTypeCode() (Compatibility note: in libSBML 5, the
type of return values of these functions changed from an enumeration
to an integer for extensibility in the face of different programming
languages.)

* Each package extension must define similar sets of values for
each SBase subclass (e.g. SBMLLayoutTypeCode_t for the SBML Level 3
Layout extension, SBMLFbcTypeCode_t for the SBML Level 3 Flux Balance
Constraints extension, etc.).

* The value of each package-specific type code can be duplicated
between those of different packages.  (This is necessary because the
development of libSBML extensions for different SBML packages may be
undertaken by different developers at different times; requiring the
developers to coordinate their use of type codes would be nettlesome
and probably doomed to failure.)

* To distinguish between the type codes of different packages,
both the return value of SBase.getTypeCode() and
SBase.getPackageName() must be checked.  This is particularly
important for functions that take an SBML type code as an argument,
such as SBase.getAncestorOfType(), which by default assumes you are
handing it a core type, and will return 'None' if the value you give
it is actually from a package.

The following example code illustrates the combined use of
SBase.getPackageName() and SBase.getTypeCode():

  def example(item):
    pkg_name  = item.getPackageName()
    type_code = item.getTypeCode()
    if pkg_name == \'core\':
      print(\'Got a \' + SBMLTypeCode_toString(type_code, \'core\') + \' object\')
      if type_code == SBML_MODEL:
        print(\'This is a very, very nice model\')
        # Do whatever the application wants to do with the model.
      elif type_code == SBML_COMPARTMENT:
        print(\'This is a very, very nice compartment\')
        # Do whatever the application wants to do with the compartment.
      elif type_code == SBML_SPECIES:
        print(\'This is a very, very nice species\')
        # Do whatever the application wants to do with the species.
      elif ...
        ...
    elif pkg_name == \'layout\':
      print(\'Got a \' + SBMLTypeCode_toString(type_code, \'layout\') + \' object\')
      if type_code == SBML_LAYOUT_POINT:
        print(\'This is a very, very nice layout point\')
        # Do whatever the application wants to do with the layout point.
      elif type_code == SBML_LAYOUT_BOUNDINGBOX:
        print(\'This is a very, very nice layout bounding box\')
        # Do whatever the application wants to do with the layout bounding box.
      elif ...
        ...
    elif pkg_name == \'unknown\':
      print(\'Something went wrong -- libSBML did not recognize the object type\')
      # Handle errors

Returns the SBML object type code of this SBML object, or
SBML_UNKNOWN (the default).  The latter is possible because subclasses
of SBase are not required to implement this method to return a type
code.

WARNING:

The specific integer values of the possible type codes may be reused
by different libSBML plug-ins for SBML Level 3. packages,  To fully
identify the correct code, it is necessary to invoke both
getTypeCode() and getPackageName().

See also getPackageName(), getElementName().
";


%feature("docstring") SBase::getElementName "
Returns the XML element name of this object.

This is overridden by subclasses to return a string appropriate to the
SBML component.  For example, Model defines it as returning ''model','
CompartmentType defines it as returning ''compartmentType',' and so
on.
";


%feature("docstring") SBase::toSBML "
Returns a string consisting of a partial SBML corresponding to just
this object.

Returns the partial SBML that describes this SBML object.

WARNING:

This is primarily provided for testing and debugging purposes.  It may
be removed in a future version of libSBML.
";


%feature("docstring") SBase::toXMLNode "
Returns this element as an XMLNode.

Returns this element as an XMLNode.

WARNING:

This operation is computationally expensive, because the element has
to be fully serialized to a string and then parsed into the XMLNode
structure.  Attempting to convert a large tree structure (e.g., a
large Model) may consume significant computer memory and time.
";


%feature("docstring") SBase::getPlugin "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    getPlugin(long n)

Returns the nth plug-in object (extension interface) for an SBML Level
3 package extension. The returned plug-in will be the appropriate type
of plugin requested: calling Model.getPlugin() will return an
FbcModelPlugin; calling Parameter.getPlugin() will return
CompSBasePlugin, etc.

If no such plugin exists, None is returned.

SBML Level 3 consists of a Core definition that can be extended via
optional SBML Level 3 packages.  A given model may indicate that it
uses one or more SBML packages, and likewise, a software tool may be
able to support one or more packages.  LibSBML does not come
preconfigured with all possible packages included and enabled, in part
because not all package specifications have been finalized.  To
support the ability for software systems to enable support for the
Level 3 packages they choose, libSBML features a plug-in mechanism.
Each SBML Level 3 package is implemented in a separate code plug-in
that can be enabled by the application to support working with that
SBML package.  A given SBML model may thus contain not only objects
defined by SBML Level 3 Core, but also objects created by libSBML
plug-ins supporting additional Level 3 packages.

Parameter 'n' is the index of the plug-in to return.

Returns the nth plug-in object (the libSBML extension interface) of a
package extension.

See also getNumPlugins(), getPlugin().

______________________________________________________________________
Method variant with the following signature:

    getPlugin(string package)

Returns a plug-in object (extension interface) for an SBML Level 3
package extension with the given package name or URI. The returned
plug-in will be the appropriate type of plugin requested: calling
Model.getPlugin() will return an FbcModelPlugin; calling
Parameter.getPlugin() will return CompSBasePlugin, etc.

If no such plugin exists, None is returned.

SBML Level 3 consists of a Core definition that can be extended via
optional SBML Level 3 packages.  A given model may indicate that it
uses one or more SBML packages, and likewise, a software tool may be
able to support one or more packages.  LibSBML does not come
preconfigured with all possible packages included and enabled, in part
because not all package specifications have been finalized.  To
support the ability for software systems to enable support for the
Level 3 packages they choose, libSBML features a plug-in mechanism.
Each SBML Level 3 package is implemented in a separate code plug-in
that can be enabled by the application to support working with that
SBML package.  A given SBML model may thus contain not only objects
defined by SBML Level 3 Core, but also objects created by libSBML
plug-ins supporting additional Level 3 packages.

Parameter 'package' is the name or URI of the package.

Returns the plug-in object (the libSBML extension interface) of a
package extension with the given package name or URI.

See also getPlugin().
";


%feature("docstring") SBase::getDisabledPlugin "
Returns the nth disabled plug-in object (extension interface) for an
SBML Level 3 package extension.  If no such plugin exists, None is
returned.

SBML Level 3 consists of a Core definition that can be extended via
optional SBML Level 3 packages.  A given model may indicate that it
uses one or more SBML packages, and likewise, a software tool may be
able to support one or more packages.  LibSBML does not come
preconfigured with all possible packages included and enabled, in part
because not all package specifications have been finalized.  To
support the ability for software systems to enable support for the
Level 3 packages they choose, libSBML features a plug-in mechanism.
Each SBML Level 3 package is implemented in a separate code plug-in
that can be enabled by the application to support working with that
SBML package.  A given SBML model may thus contain not only objects
defined by SBML Level 3 Core, but also objects created by libSBML
plug-ins supporting additional Level 3 packages.

If a plugin is disabled, the package information it contains is no
longer considered to be part of the SBML document for the purposes of
searching the document or writing out the document.  However, the
information is still retained, so if the plugin is enabled again, the
same information will once again be available, and will be written out
to the final model.

Parameter 'n' is the index of the disabled plug-in to return.

Returns the nth disabled plug-in object (the libSBML extension
interface) of a package extension.

See also getNumDisabledPlugins(), getPlugin().
";


%feature("docstring") SBase::getNumPlugins "
Returns the number of plug-in objects (extenstion interfaces) for SBML
Level 3 package extensions known.

SBML Level 3 consists of a Core definition that can be extended via
optional SBML Level 3 packages.  A given model may indicate that it
uses one or more SBML packages, and likewise, a software tool may be
able to support one or more packages.  LibSBML does not come
preconfigured with all possible packages included and enabled, in part
because not all package specifications have been finalized.  To
support the ability for software systems to enable support for the
Level 3 packages they choose, libSBML features a plug-in mechanism.
Each SBML Level 3 package is implemented in a separate code plug-in
that can be enabled by the application to support working with that
SBML package.  A given SBML model may thus contain not only objects
defined by SBML Level 3 Core, but also objects created by libSBML
plug-ins supporting additional Level 3 packages.

Returns the number of plug-in objects (extension interfaces) of
package extensions known by this instance of libSBML.

See also getPlugin().
";


%feature("docstring") SBase::getNumDisabledPlugins "
Returns the number of disabled plug-in objects (extension interfaces)
for SBML Level 3 package extensions known.

SBML Level 3 consists of a Core definition that can be extended via
optional SBML Level 3 packages.  A given model may indicate that it
uses one or more SBML packages, and likewise, a software tool may be
able to support one or more packages.  LibSBML does not come
preconfigured with all possible packages included and enabled, in part
because not all package specifications have been finalized.  To
support the ability for software systems to enable support for the
Level 3 packages they choose, libSBML features a plug-in mechanism.
Each SBML Level 3 package is implemented in a separate code plug-in
that can be enabled by the application to support working with that
SBML package.  A given SBML model may thus contain not only objects
defined by SBML Level 3 Core, but also objects created by libSBML
plug-ins supporting additional Level 3 packages.

If a plugin is disabled, the package information it contains is no
longer considered to be part of the SBML document for the purposes of
searching the document or writing out the document.  However, the
information is still retained, so if the plugin is enabled again, the
same information will once again be available, and will be written out
to the final model.

Returns the number of disabled plug-in objects (extension interfaces)
of package extensions known by this instance of libSBML.
";


%feature("docstring") SBase::deleteDisabledPlugins "
Deletes all information stored in disabled plugins.  If the plugin is
re-enabled later, it will then not have any previously-stored
information.

SBML Level 3 consists of a Core definition that can be extended via
optional SBML Level 3 packages.  A given model may indicate that it
uses one or more SBML packages, and likewise, a software tool may be
able to support one or more packages.  LibSBML does not come
preconfigured with all possible packages included and enabled, in part
because not all package specifications have been finalized.  To
support the ability for software systems to enable support for the
Level 3 packages they choose, libSBML features a plug-in mechanism.
Each SBML Level 3 package is implemented in a separate code plug-in
that can be enabled by the application to support working with that
SBML package.  A given SBML model may thus contain not only objects
defined by SBML Level 3 Core, but also objects created by libSBML
plug-ins supporting additional Level 3 packages.

If a plugin is disabled, the package information it contains is no
longer considered to be part of the SBML document for the purposes of
searching the document or writing out the document.  However, the
information is still retained, so if the plugin is enabled again, the
same information will once again be available, and will be written out
to the final model.

Parameter 'recursive' is if 'True,' the disabled information will be
deleted also from all child elements, otherwise only from this SBase
element.

See also getNumDisabledPlugins().
";


%feature("docstring") SBase::enablePackage "
Enables or disables the given SBML Level 3 package on this object.

This method enables the specified package on this object and other
objects connected by child-parent links in the same SBMLDocument
object. This method is the converse of SBase.disablePackage().

Parameter 'pkgURI' is the URI of the package.

Parameter 'pkgPrefix' is the XML prefix of the package.

Parameter 'flag' is whether to enable ('True)' or disable ('False)'
the package.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_PKG_UNKNOWN

* LIBSBML_PKG_VERSION_MISMATCH

* LIBSBML_PKG_CONFLICTED_VERSION

See also disablePackage().
";


%feature("docstring") SBase::disablePackage "
Disables the given SBML Level 3 package on this object.

This method disables the specified package on this object and other
objects connected by child-parent links in the same SBMLDocument
object.

An example of when this may be useful is during construction of model
components when mixing existing and new models.  Suppose your
application read an SBML document containing a model that used the
SBML Hierarchical Model Composition (\"comp\") package, and extracted
parts of that model in order to construct a new model in memory.  The
new, in-memory model will not accept a component drawn from an other
SBMLDocument with different package namespace declarations. You could
reconstruct the same namespaces in the in-memory model first, but as a
shortcut, you could also disable the package namespace on the object
being added.  Here is a code example to help clarify this:

  import sys
  import os.path
  from libsbml import *
  
  # We read an SBML L3V1 model that uses the \'comp\' package.
  
  doc = readSBML(\'sbml-file-with-comp-elements.xml\');
  if doc.getNumErrors() > 0:
    print(\'readSBML encountered errors while reading the file.\')
    doc.printErrors()
    sys.exit(1)
  
  # We extract one of the species from the model.
  
  model = doc.getModel()
  if model == None:
    print(\'Unable to retrieve Model object\')
    sys.exit(1)
  
  s1 = model.getSpecies(0)
  if s1 == None:
    print(\'Unable to retrieve Species object\')
    sys.exit(1)
  
  # We construct a new model.
  # This model does not use the \'comp\' package.
  
  try:
    newDoc = SBMLDocument(3, 1)
  except ValueError:
    print(\'Could not create SBMLDocument object\')
    sys.exit(1)
  
  newModel = newDoc.createModel()
  if newModel == None:
    print(\'Unable to create new Model object\')
    sys.exit(1)
  
  # The following would normally fail with an error, because
  # addSpecies() would first check that the parent of the given
  # object has namespaces declared, and will discover that s1
  # does but newModel does not.
  
  #   newModel.addSpecies(s1)
  
  # However, if we disable the \'comp\' package on s1, then the
  # call to addSpecies will work.
  
  compNS = \'http://www.sbml.org/sbml/level3/version1/comp/version1\'
  status = s1.disablePackage(compNS, \'comp\')
  if status != LIBSBML_OPERATION_SUCCESS:
    print(\'Unable to disable package.\')
    sys.exit(1)
  
  newSpecies = newModel.addSpecies(s1)   # This will work now.
  if newSpecies == None:
    print(\'Could not add Species\')       # (This will not happen,
    sys.exit(1)                          # but always check errors.)

Parameter 'pkgURI' is the URI of the package.

Parameter 'pkgPrefix' is the XML prefix of the package.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_PKG_UNKNOWN

* LIBSBML_PKG_VERSION_MISMATCH

* LIBSBML_PKG_CONFLICTED_VERSION

See also enablePackage().
";


%feature("docstring") SBase::enablePackageInternal "
Internal implementation method.
";


%feature("docstring") SBase::isPackageURIEnabled "
Predicate returning 'True' if an SBML Level 3 package with the given
URI is enabled with this object.

Parameter 'pkgURI' is the URI of the package.

Returns 'True' if the given package is enabled within this object,
'False' otherwise.

See also isPackageEnabled().
";


%feature("docstring") SBase::isPackageEnabled "
Predicate returning 'True' if the given SBML Level 3 package is
enabled with this object.

The search ignores the package version.

Parameter 'pkgName' is the name of the package.

Returns 'True' if the given package is enabled within this object,
'False' otherwise.

See also isPackageURIEnabled().
";


%feature("docstring") SBase::isPkgURIEnabled "
Predicate returning 'True' if an SBML Level 3 package with the given
URI is enabled with this object.

Parameter 'pkgURI' is the URI of the package.

Returns 'True' if the given package is enabled within this object,
'False' otherwise.

DEPRECATED. Replaced in libSBML 5.2.0 by SBase.isPackageURIEnabled().

See also isPkgEnabled().
";


%feature("docstring") SBase::isPkgEnabled "
Predicate returning 'True' if the given SBML Level 3 package is
enabled with this object.

The search ignores the package version.

Parameter 'pkgName' is the name of the package.

Returns 'True' if the given package is enabled within this object,
'False' otherwise.

DEPRECATED. Replaced in libSBML 5.2.0 by SBase.isPackageEnabled().

See also isPkgURIEnabled().
";


%feature("docstring") SBase::writeExtensionElements "
Internal implementation method.
";


%feature("docstring") SBase::write "
Internal implementation method.
";


%feature("docstring") SBase::writeElements "
Internal implementation method.
";


%feature("docstring") SBase::hasRequiredAttributes "
Internal implementation method.
";


%feature("docstring") SBase::hasRequiredElements "
Internal implementation method.
";


%feature("docstring") SBase::checkCompatibility "
Internal implementation method.
";


%feature("docstring") SBase::setSBMLNamespaces "
Internal implementation method.
";


%feature("docstring") SBase::setSBMLNamespacesAndOwn "
Internal implementation method.
";


%feature("docstring") SBase::getSBMLNamespaces "
Internal implementation method.
";


%feature("docstring") SBase::removeDuplicateAnnotations "
Internal implementation method.
";


%feature("docstring") SBase::checkMathMLNamespace "
Internal implementation method.
";


%feature("docstring") SBase::getDerivedUnitDefinition "
Internal implementation method.
";


%feature("docstring") SBase::containsUndeclaredUnits "
Internal implementation method.
";


%feature("docstring") SBase::removeFromParentAndDelete "
Removes this object from its parent.

If the parent was storing this object as a pointer, it is deleted.  If
not, it is simply cleared (as in ListOf objects).  This is a pure
virtual method, as every SBase element has different parents, and
therefore different methods of removing itself.  Will fail (and not
delete itself) if it has no parent object.  This function is designed
to be overridden, but for all objects whose parent is of the class
ListOf, the default implementation will work.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED
";


%feature("docstring") SBase::matchesSBMLNamespaces "
Returns 'True' if this object's set of XML namespaces are the same as
the given object's XML namespaces.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

Parameter 'sb' is an object to compare with respect to namespaces.

Returns boolean, 'True' if this object's collection of namespaces is
the same as 'sb's', 'False' otherwise.
";


%feature("docstring") SBase::matchesRequiredSBMLNamespacesForAddition "
Returns 'True' if this object's set of XML namespaces are a subset of
the given object's XML namespaces.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

Parameter 'sb' is an object to compare with respect to namespaces.

Returns boolean, 'True' if this object's collection of namespaces is a
subset of 'sb's', 'False' otherwise.
";


%feature("docstring") SBase::setUserData "
Sets the user data of this element.

The user data associated with an SBML object can be used by an
application developer to attach custom information to that object in
the model.  In case of a deep copy, this data will passed as-is.  The
data attribute will never be interpreted by libSBML.

Parameter 'userData' is specifies the new user data.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED
";


%feature("docstring") SBase::*getUserData "
Returns the user data that has been previously set via setUserData().

The user data associated with an SBML object can be used by an
application developer to attach custom information to that object in
the model.  In case of a deep copy, this data will passed as-is.  The
data attribute will never be interpreted by libSBML.

Returns the user data of this node, or 'None' if no user data has been
set.
";


%feature("docstring") SBase::isSetUserData "
Predicate returning true or false depending on whether the user data
of this element has been set.

The user data associated with an SBML object can be used by an
application developer to attach custom information to that object in
the model.  In case of a deep copy, this data will passed as-is.  The
data attribute will never be interpreted by libSBML.

Returns boolean, 'True' if this object's user data has been set,
'False' otherwise.
";


%feature("docstring") SBase::unsetUserData "
Unsets the user data of this element.

The user data associated with an SBML object can be used by an
application developer to attach custom information to that object in
the model.  In case of a deep copy, this data will passed as-is.  The
data attribute will never be interpreted by libSBML.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED
";


%feature("docstring") SBase::getURI "
Gets the namespace URI to which this element belongs to.

For example, all elements that belong to SBML Level 3 Version 1 Core
must would have the URI
'http://www.sbml.org/sbml/level3/version1/core'; all elements that
belong to Layout Extension Version 1 for SBML Level 3 Version 1 Core
must would have the URI
'http://www.sbml.org/sbml/level3/version1/layout/version1'.

This function first returns the URI for this element by looking into
the SBMLNamespaces object of the document with the its package name.
If not found, it will then look for the namespace associated with the
element itself.

Returns the URI of this element, as a text string.

See also getSBMLDocument(), getPackageName().
";


%feature("docstring") SBase::getPrefix "
Returns the XML namespace prefix of this element.

This reports the XML namespace prefix chosen for this class of object
in the current SBML document.  This may be an empty string if the
component has no explicit prefix (for instance, if it is a core SBML
object placed in the default SBML namespace of the document).  If it
is not empty, then it corresponds to the XML namespace prefix used set
the object, whatever that may be in a given SBML document.

Returns a text string representing the XML namespace prefix.
";


%feature("docstring") SBase::hasOptionalAttributes "
Internal implementation method.
";


%feature("docstring") SBase::hasOptionalElements "
Internal implementation method.
";


%feature("docstring") SBase::setElementText "
Internal implementation method.
";


%feature("docstring") SBase::matchesCoreSBMLNamespace "
Internal implementation method.
";


%feature("docstring") SBase::createObject "
Internal implementation method.
";


%feature("docstring") SBase::readOtherXML "
Internal implementation method.
";


%feature("docstring") SBase::getElementPosition "
Internal implementation method.
";


%feature("docstring") SBase::getErrorLog "
Internal implementation method.
";


%feature("docstring") SBase::logError "
Internal implementation method.
";


%feature("docstring") SBase::logUnknownAttribute "
Internal implementation method.
";


%feature("docstring") SBase::logUnknownElement "
Internal implementation method.
";


%feature("docstring") SBase::logEmptyString "
Internal implementation method.
";


%feature("docstring") SBase::addExpectedAttributes "
Internal implementation method.
";


%feature("docstring") SBase::readAttributes "
Internal implementation method.
";


%feature("docstring") SBase::writeAttributes "
Internal implementation method.
";


%feature("docstring") SBase::writeXMLNS "
Internal implementation method.
";


%feature("docstring") SBase::syncAnnotation "
Internal implementation method.
";


%feature("docstring") SBase::reconstructRDFAnnotation "
Internal implementation method.
";


%feature("docstring") SBase::checkOrderAndLogError "
Internal implementation method.
";


%feature("docstring") SBase::checkListOfPopulated "
Internal implementation method.
";


%feature("docstring") SBase::checkDefaultNamespace "
Internal implementation method.
";


%feature("docstring") SBase::checkAnnotation "
Internal implementation method.
";


%feature("docstring") SBase::checkXHTML "
Internal implementation method.
";


%feature("docstring") SBase::loadPlugins "
Internal implementation method.
";


%feature("docstring") SBase::createExtensionObject "
Internal implementation method.
";


%feature("docstring") SBase::setElementNamespace "
Internal implementation method.
";


%feature("docstring") SBase::getElementNamespace "
Internal implementation method.
";


%feature("docstring") SBase::readExtensionAttributes "
Internal implementation method.
";


%feature("docstring") SBase::writeExtensionAttributes "
Internal implementation method.
";


%feature("docstring") SBase::storeUnknownExtAttribute "
Internal implementation method.
";


%feature("docstring") SBase::storeUnknownExtElement "
Internal implementation method.
";


%feature("docstring") SBase::getSBMLPrefix "
Internal implementation method.
";


%feature("docstring") SBase::getRootElement "
Internal implementation method.
";


%feature("docstring") SBase::getHasBeenDeleted "
Internal implementation method.
";


%feature("docstring") SBase::setSBaseFields "
Internal implementation method.
";


%feature("docstring") SBase::readAnnotation "
Internal implementation method.
";


%feature("docstring") SBase::removeDuplicatedResources "
Internal implementation method.
";


%feature("docstring") SBase::addTermToExistingBag "
Internal implementation method.
";


%feature("docstring") SBase::readNotes "
Internal implementation method.
";


%feature("docstring") ListOf "
Parent class for libSBML's 'ListOfXYZ' classes.

This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed
by the SBML specifications, although it is used to implement features
defined in SBML.

The ListOf class in libSBML is a utility class that serves as the
parent class for implementing the ListOf__ classes.  It provides
methods for working generically with the various SBML lists of objects
in a program. LibSBML uses this separate list class rather than
ordinary Python lists, so that it can provide the methods and features
associated with SBase.

Whether a given ListOf element may be empty or not depends on the
element in question, and on what level and version of SBML it is being
used for.  For ListOf elements in SBML Level 3 Version 1 and prior, no
core list and few package lists could be empty.  As of SBML Level 3
Version 2, the rules were relaxed, and lists were allowed to be empty.
In libSBML, documents created for Level 3 Version 2 will be written
with empty ListOf's if that ListOf contains some other 'extra'
information: an attribute such as metaid or sboTerm, a child '<notes>'
or '<annotation>', or information from a SBML  Level 3 package.

The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  In libSBML's
implementation, ListOf___ classes are derived from the intermediate
utility class ListOf, which is not defined by the SBML specifications
but serves as a useful programmatic construct.  ListOf is itself is in
turn derived from SBase, which provides all of the various ListOf___
classes with common features defined by the SBML specification, such
as 'metaid' attributes and annotations.

The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level 2 Version 4):

  <?xml version=\"1.0\" encoding=\"UTF-8\"?>
  <sbml xmlns=\"http://www.sbml.org/sbml/level3/version1/core\" 
        level=\"3\" version=\"1\">
    <model id=\"My_Model\">
      <listOfFunctionDefinitions>
        <functionDefinition> ... </functionDefinition> 
      </listOfFunctionDefinitions>
      <listOfUnitDefinitions>
        <unitDefinition> ... </unitDefinition> 
      </listOfUnitDefinitions>
      <listOfCompartments>
        <compartment> ... </compartment> 
      </listOfCompartments>
      <listOfSpecies>
        <species> ... </species> 
      </listOfSpecies>
      <listOfParameters>
        <parameter> ... </parameter> 
      </listOfParameters>
      <listOfInitialAssignments>
        <initialAssignment> ... </initialAssignment> 
      </listOfInitialAssignments>
      <listOfRules>
        ... elements of subclasses of Rule ...
      </listOfRules>
      <listOfConstraints>
        <constraint> ... </constraint> 
      </listOfConstraints>
      <listOfReactions>
        <reaction> ... </reaction> 
      </listOfReactions>
      <listOfEvents>
        <event> ... </event> 
      </listOfEvents>
    </model>
  </sbml>

SBML Level 3 Version 1 has essentially the same structure as  Level
2 Version 4, depicted above, but SBML Level 3  Version 2 allows
containers to contain zero or more of the relevant object, instead of
requiring at least one.  As such, libsbml will write out an
otherwise-empty ListOf___ element that has any optional attribute set
(such as 'id' or 'metaid'), that has an optional child (such  as a
'notes' or 'annotation'), or that has attributes or children set from
any SBML Level 3 package, whether or not the ListOf___ has  any other
children.

Readers may wonder about the motivations for using the ListOf___
containers in SBML.  A simpler approach in XML might be to place the
components all directly at the top level of the model definition.  The
choice made in SBML is to group them within XML elements named after
ListOfClassname, in part because it helps organize the components.
More importantly, the fact that the container classes are derived from
SBase means that software tools can add information about the lists
themselves into each list container's 'annotation'.

See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.
";


%feature("docstring") ListOf::ListOf "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    ListOf(SBMLNamespaces sbmlns)

Creates a new ListOf with a given SBMLNamespaces object.

Parameter 'sbmlns' is the set of SBML namespaces that this ListOf
should contain.

Note: Bare ListOf objects are impossible to add to SBML models.  The
ListOf class is simply the base of other classes in libSBML.  Calling
programs are not intended to create bare ListOf objects themselves.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    ListOf(long level   = SBML_DEFAULT_LEVEL, long version =
SBML_DEFAULT_VERSION)

Creates a new ListOf object.

Parameter 'level' is the SBML Level; if not assigned, defaults to the
value of SBMLDocument.getDefaultLevel().

Parameter 'version' is the Version within the SBML Level; if not
assigned, defaults to the value of SBMLDocument.getDefaultVersion().

Note: Bare ListOf objects are impossible to add to SBML models.  The
ListOf class is simply the base of other classes in libSBML.  Calling
programs are not intended to create bare ListOf objects themselves.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

</dl><dl class=\"docnote\"><dt>Documentation note:</dt><dd> The native
C++ implementation of this method defines a default argument value. In
the documentation generated for different libSBML language bindings,
you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is
handled by declaring two separate methods, with one of them having the
argument and the other one lacking the argument. However, the libSBML
documentation will be identical for both methods. Consequently, if you
are reading this and do not see an argument even though one is
described, please look for descriptions of other variants of this
method near where this one appears in the documentation. </dd></dl>

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.

______________________________________________________________________
Method variant with the following signature:

    ListOf(ListOf orig)

Copy constructor; creates a copy of this ListOf.

Parameter 'orig' is the ListOf instance to copy.
";


%feature("docstring") ListOf::accept "
Internal implementation method.
";


%feature("docstring") ListOf::clone "
Creates and returns a deep copy of this ListOf object.

Returns the (deep) copy of this ListOf object.
";


%feature("docstring") ListOf::append "
Adds an item to the end of this ListOf's list of items.

This method makes a clone of the 'item' handed to it.  This means that
when the ListOf object is destroyed, the original items will not be
destroyed.  For a method with an alternative ownership behavior, see
the ListOf.appendAndOwn() method.

Parameter 'item' is the item to be added to the list.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_OBJECT

See also appendAndOwn(), appendFrom().
";


%feature("docstring") ListOf::appendAndOwn "
Adds an item to the end of this ListOf's list of items.

This method does not clone the 'disownedItem' handed to it; instead,
it assumes ownership of it.  This means that when the ListOf is
destroyed, the item will be destroyed along with it.  For a method
with an alternative ownership behavior, see the ListOf.append()
method.

Parameter 'disownedItem' is the item to be added to the list. Will
become a child of the parent list.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_OBJECT

See also append(), appendFrom().
";


%feature("docstring") ListOf::appendFrom "
Adds a clone of a list of items to this ListOf's list.

Note that because this clones the objects handed to it, the original
items will not be destroyed when this ListOf object is destroyed.

Parameter 'list' is a list of items to be added.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_OBJECT

See also append(), appendAndOwn().
";


%feature("docstring") ListOf::insert "
Inserts an item at a given position in this ListOf's list of items.

This variant of the method makes a clone of the 'item' handed to it.
This means that when the ListOf is destroyed, the original 'item' will
not be destroyed.

Parameter 'location' is the location in the list where to insert the
item. Parameter 'item' is the item to be inserted to the list.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_OBJECT

See also insertAndOwn().
";


%feature("docstring") ListOf::insertAndOwn "
Inserts an item at a given position in this ListOf's list of items.

This variant of the method does not make a clone of the 'disownedItem'
handed to it. This means that when the ListOf is destroyed, the
original 'item' will be destroyed.

Parameter 'location' is the location where to insert the item.
Parameter 'disownedItem' is the item to be inserted to the list. Will
become a child of the parent list.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_OBJECT

See also insert().
";


%feature("docstring") ListOf::get "
Get an item from the list.

Parameter 'n' is the index number of the item to get.

Returns the nth item in this ListOf items, or a null pointer if the
index number 'n' refers to a nonexistent position in this list.

See also size().
";


%feature("docstring") ListOf::getElementBySId "
Returns the first child element found that has the given identifier.

This method searches this ListOf's list of items for SBML objects
based on their 'id' attribute value in the model-wide SId identifier
namespace.

Parameter 'id' is string representing the id of the object to find.

Returns the first element found with the given 'id', or 'None' if no
such object is found.
";


%feature("docstring") ListOf::getElementByMetaId "
Returns the first child element found with the given meta-identifier.

Parameter 'metaid' is string representing the 'metaid' attribute of
the object to find.

Returns the first element found with the given 'metaid', or 'None' if
no such object is found.
";


%feature("docstring") ListOf::getAllElements "
Returns a List of all child SBase objects.

The values returned include all children of the objects in this ListOf
list, nested to an arbitrary depth.

Parameter 'filter' is a pointer to an ElementFilter, which causes the
function  to return only elements that match a particular set of
constraints.   If None (the default), the function will return all
child objects.

Returns a List of pointers to all child objects.
";


%feature("docstring") ListOf::clear "
Removes all items in this ListOf object.

If parameter 'doDelete' is 'True' (default), all items in this ListOf
object are deleted and cleared, and thus the caller doesn't have to
delete those items.  Otherwise, all items are cleared only from this
ListOf object; the caller is still responsible for deleting the actual
items.  (In the latter case, callers are advised to store pointers to
all items elsewhere before calling this function.)

Parameter 'doDelete' is if 'True' (default), all items are deleted and
cleared. Otherwise, all items are just cleared and not deleted.

</dl><dl class=\"docnote\"><dt>Documentation note:</dt><dd> The native
C++ implementation of this method defines a default argument value. In
the documentation generated for different libSBML language bindings,
you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is
handled by declaring two separate methods, with one of them having the
argument and the other one lacking the argument. However, the libSBML
documentation will be identical for both methods. Consequently, if you
are reading this and do not see an argument even though one is
described, please look for descriptions of other variants of this
method near where this one appears in the documentation. </dd></dl>

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") ListOf::removeFromParentAndDelete "
Removes all items in this ListOf object and deletes its properties
too.

This performs a call to clear() with an argument of 'True' (thus
removing all the child objects in the list), followed by calls to
various libSBML unsetFoo methods to delete everything else: CVTerm
objects, model history objects, etc.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS
";


%feature("docstring") ListOf::remove "
Removes the nth item from this ListOf list of items and returns it.

The caller owns the returned item and is responsible for deleting it.

Parameter 'n' is the index of the item to remove.

See also size().
";


%feature("docstring") ListOf::size "
Returns number of items in this ListOf list.

Returns the number of items in this ListOf items.
";


%feature("docstring") ListOf::setSBMLDocument "
Internal implementation method.
";


%feature("docstring") ListOf::getTypeCode "
Returns the libSBML type code for this object, namely, SBML_LIST_OF.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for this object: SBML_LIST_OF (default).

Note: The various ListOf classes mostly differ from each other in what
they contain.  Hence, one must call getItemTypeCode() to fully
determine the class of this SBML object.

WARNING:

The specific integer values of the possible type codes may be reused
by different libSBML plug-ins for SBML Level 3. packages,  To fully
identify the correct code, it is necessary to invoke both
getTypeCode() and getPackageName().

See also getItemTypeCode(), getElementName(), getPackageName().
";


%feature("docstring") ListOf::getItemTypeCode "
Get the type code of the objects contained in this ListOf.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Classes that inherit from the ListOf class should override this method
to return the SBML type code for the objects contained in this ListOf.
If they do not, this method will return SBML_UNKNOWN

Returns The ListOf base class contains no SBML objects, and therefore
this method returns SBML_UNKNOWN.

See also getElementName(), getPackageName().
";


%feature("docstring") ListOf::getElementName "
Returns the XML element name of this object, which for ListOf, is
always ''listOf'.'

Returns the XML name of this element.
";


%feature("docstring") ListOf::writeElements "
Internal implementation method.
";


%feature("docstring") ListOf::enablePackageInternal "
Internal implementation method.
";


%feature("docstring") ListOf::hasOptionalElements "
Internal implementation method.
";


%feature("docstring") ListOf::isExplicitlyListed "
Internal implementation method.
";


%feature("docstring") ListOf::setExplicitlyListed "
Internal implementation method.
";


%feature("docstring") ListOf::addExpectedAttributes "
Internal implementation method.
";


%feature("docstring") ListOf::readAttributes "
Internal implementation method.
";


%feature("docstring") ListOf::writeAttributes "
Internal implementation method.
";


%feature("docstring") ListOf::isValidTypeForList "
Internal implementation method.
";


%feature("docstring") Model "
An SBML model.

In an SBML model definition, a single object of class Model serves as
the overall container for the lists of the various model components.
All of the lists are optional, but if a given list container is
present within the model, the list must not be empty; that is, it must
have length one or more.  The following are the components and lists
permitted in different Levels and Versions of SBML in version 5.16.0
of libSBML:

* In SBML Level 1, the components are: UnitDefinition, Compartment,
Species, Parameter, Rule, and Reaction.  Instances of the classes are
placed inside instances of classes ListOfUnitDefinitions,
ListOfCompartments, ListOfSpecies, ListOfParameters, ListOfRules, and
ListOfReactions.

* In SBML Level 2 Version 1, the components are: FunctionDefinition,
UnitDefinition, Compartment, Species, Parameter, Rule, Reaction and
Event.  Instances of the classes are placed inside instances of
classes ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartments, ListOfSpecies, ListOfParameters, ListOfRules,
ListOfReactions, and ListOfEvents.

* In SBML Level 2 Versions 2, 3 and 4, the components are:
FunctionDefinition, UnitDefinition, CompartmentType, SpeciesType,
Compartment, Species, Parameter, InitialAssignment, Rule, Constraint,
Reaction and Event.  Instances of the classes are placed inside
instances of classes ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
ListOfRules, ListOfConstraints, ListOfReactions, and ListOfEvents.

* In SBML Level 3 Version 1, the components are: FunctionDefinition,
UnitDefinition, Compartment, Species, Parameter, InitialAssignment,
Rule, Constraint, Reaction and Event.  Instances of the classes are
placed inside instances of classes ListOfFunctionDefinitions,
ListOfUnitDefinitions, ListOfCompartments, ListOfSpecies,
ListOfParameters, ListOfInitialAssignments, ListOfRules,
ListOfConstraints, ListOfReactions, and ListOfEvents.   Although all
the lists are optional, there are dependencies between SBML components
such that defining some components requires defining others. An
example is that defining a species requires defining a compartment,
and defining a reaction requires defining a species.  The dependencies
are explained in more detail in the SBML specifications.

In addition to the above lists and attributes, the Model class in both
SBML Level 2 and Level 3 has the usual two attributes of 'id' and
'name', and both are optional.  As is the case for other SBML
components with 'id' and 'name' attributes, they must be used
according to the guidelines described in the SBML specifications.
(Within the frameworks of SBML Level 2 and Level 3, a Model object
identifier has no assigned meaning, but extension packages planned for
SBML Level 3 are likely to make use of this identifier.)

Finally, SBML Level 3 has introduced a number of additional Model
attributes.  They are discussed in a separate section below.

Approaches to creating objects using the libSBML API
======================================================================

LibSBML provides two main mechanisms for creating objects: class
constructors (e.g., Species.Species() ),  and createObject() methods
(such as Model.createSpecies()) provided by certain Object classes
such as Model.  These multiple mechanisms are provided by libSBML for
flexibility and to support different use-cases, but they also have
different implications for the overall model structure.

In general, the recommended approach is to use the createObject()
methods.  These methods both create an object and link it to the
parent in one step. Here is an example:

  # Create an SBMLDocument object in Level 3 Version 1 format.
  # Make sure to check for possible failures.
  
  try:
    sbmlDoc = SBMLDocument(3, 1)
  except ValueError:
    print(\'Could not create SBMLDocument object\')
    sys.exit(1)
  
  # Create a Model object inside the SBMLDocument object and set its
  # identifier, checking the returned values.  The call to setId() returns a
  # status code to indicate whether the assignment was successful.
  
  model = sbmlDoc.createModel()
  if model == None:
    # Do something to handle the error here.
    print(\'Unable to create Model object.\')
    sys.exit(1)
  
  status = model.setId(\'BestModelEver\')
  if status != LIBSBML_OPERATION_SUCCESS:
    # Do something to handle the error here.
    print(\'Unable to set identifier on the Model object\')
    sys.exit(1)
  
  # Create a Species object inside the Model and set its identifier.
  # Again, the setId() returns a status code to indicate whether the
  # assignment was successful.
  
  sp = model.createSpecies()
  if sp == None:
    # Do something to handle the error here.
    print(\'Unable to create Species object.\')
    sys.exit(1)
  
  status = sp.setId(\'BestSpeciesEver\')
  if status != LIBSBML_OPERATION_SUCCESS:
    # Do something to handle the error here.
    print(\'Unable to set identifier on the Species object\')
    sys.exit(1)

The createObject() methods return a pointer to the object created,
but they also add the object to the relevant list of object instances
contained in the parent.  (These lists become the <listOfObjects>
elements in the finished XML rendition of SBML.)  In the example
above, Model.createSpecies() adds the created species directly to the
<listOfSpeciesgt; list in the model.  Subsequently, methods called on
the species change the species in the model (which is what is expected
in most situations).

Consistency and adherence to SBML specifications
======================================================================

To make it easier for applications to do whatever they need, libSBML
version 5.16.0 is relatively lax when it comes to enforcing
correctness and completeness of models during model construction and
editing. Essentially, libSBML will not in most cases check
automatically that a model's components have valid attribute values,
or that the overall model is consistent and free of errors---even
obvious errors such as duplication of identifiers.  This allows
applications great leeway in how they build their models, but it means
that software authors must take deliberate steps to ensure that the
model will be, in the end, valid SBML.  These steps include such
things as keeping track of the identifiers used in a model, manually
performing updates in certain situations where an entity is referenced
in more than one place (e.g., a species that is referenced by multiple
SpeciesReference objects), and so on.

That said, libSBML does provide powerful features for deliberately
performing validation of SBML when an application decides it is time
to do so.  The interfaces to these facilities are on the SBMLDocument
class, in the form of SBMLDocument.checkInternalConsistency() and
SBMLDocument.checkConsistency().  Please refer to the documentation
for SBMLDocument for more information about this.

While applications may play fast and loose and live like free spirits
during the construction and editing of SBML models, they should always
make sure to call SBMLDocument.checkInternalConsistency() and/or
SBMLDocument.checkConsistency() before writing out the final version
of an SBML model.

Model attributes introduced in SBML Level 3
======================================================================

As mentioned above, the Model class has a number of optional
attributes in SBML Level 3.  These are 'substanceUnits', 'timeUnits',
'volumeUnits', 'areaUnits', 'lengthUnits', 'extentUnits', and
'conversionFactor.  The following provide more information about them.

The 'substanceUnits' attribute
......................................................................

The 'substanceUnits' attribute is used to specify the unit of
measurement associated with substance quantities of Species objects
that do not specify units explicitly.  If a given Species object
definition does not specify its unit of substance quantity via the
'substanceUnits' attribute on the Species object instance, then that
species inherits the value of the Model 'substanceUnits' attribute.
If the Model does not define a value for this attribute, then there is
no unit to inherit, and all species that do not specify individual
'substanceUnits' attribute values then have no declared units for
their quantities.  The SBML Level 3 specifications provide more
details.

Note that when the identifier of a species appears in a model's
mathematical expressions, the unit of measurement associated with that
identifier is not solely determined by setting 'substanceUnits' on
Model or Species.  Please see the discussion about units given in the
documentation for the Species class.

The 'timeUnits' attribute
......................................................................

The 'timeUnits' attribute on SBML Level 3's Model object is used to
specify the unit in which time is measured in the model.  This
attribute on Model is the only way to specify a unit for time in a
model. It is a global attribute; time is measured in the model
everywhere in the same way.  This is particularly relevant to Reaction
and RateRule objects in a model: all Reaction and RateRule objects in
SBML define per-time values, and the unit of time is given by the
'timeUnits' attribute on the Model object instance.  If the Model
'timeUnits' attribute has no value, it means that the unit of time is
not defined for the model's reactions and rate rules.  Leaving it
unspecified in an SBML model does not result in an invalid model in
SBML Level 3; however, as a matter of best practice, we strongly
recommend that all models specify units of measurement for time.

The 'volumeUnits', 'areaUnits', and 'lengthUnits' attributes
......................................................................

The attributes 'volumeUnits', 'areaUnits' and 'lengthUnits' together
are used to set the units of measurements for the sizes of Compartment
objects in an SBML Level 3 model when those objects do not otherwise
specify units.  The three attributes correspond to the most common
cases of compartment dimensions: 'volumeUnits' for compartments having
a 'spatialDimensions' attribute value of ''3',' 'areaUnits' for
compartments having a 'spatialDimensions' attribute value of ''2','
and 'lengthUnits' for compartments having a 'spatialDimensions'
attribute value of ''1'.'  The attributes are not applicable to
compartments whose 'spatialDimensions' attribute values are not one of
''1',' ''2'' or ''3'.'

If a given Compartment object instance does not provide a value for
its 'units' attribute, then the unit of measurement of that
compartment's size is inherited from the value specified by the Model
'volumeUnits', 'areaUnits' or 'lengthUnits' attribute, as appropriate
based on the Compartment object's 'spatialDimensions' attribute value.
If the Model object does not define the relevant attribute, then there
are no units to inherit, and all Compartment objects that do not set a
value for their 'units' attribute then have no units associated with
their compartment sizes.

The use of three separate attributes is a carry-over from SBML Level
2.  Note that it is entirely possible for a model to define a value
for two or more of the attributes 'volumeUnits', 'areaUnits' and
'lengthUnits' simultaneously, because SBML models may contain
compartments with different numbers of dimensions.

The 'extentUnits' attribute
......................................................................

Reactions are processes that occur over time.  These processes involve
events of some sort, where a single ``reaction event'' is one in which
some set of entities (known as reactants, products and modifiers in
SBML) interact, once.  The extent of a reaction is a measure of how
many times the reaction has occurred, while the time derivative of the
extent gives the instantaneous rate at which the reaction is
occurring.  Thus, what is colloquially referred to as the 'rate of the
reaction' is in fact equal to the rate of change of reaction extent.

In SBML Level 3, the combination of 'extentUnits' and 'timeUnits'
defines the units of kinetic laws in SBML and establishes how the
numerical value of each KineticLaw object's mathematical formula is
meant to be interpreted in a model.  The units of the kinetic laws are
taken to be 'extentUnits' divided by 'timeUnits'.

Note that this embodies an important principle in SBML Level 3 models:
all reactions in an SBML model must have the same units for the rate
of change of extent.  In other words, the units of all reaction rates
in the model must be the same.  There is only one global value for
'extentUnits' and one global value for 'timeUnits'.

The 'conversionFactor' attribute
......................................................................

The attribute 'conversionFactor' in SBML Level 3's Model object
defines a global value inherited by all Species object instances that
do not define separate values for their 'conversionFactor' attributes.
The value of this attribute must refer to a Parameter object instance
defined in the model.  The Parameter object in question must be a
constant; ie it must have its 'constant' attribute value set to
''True'.'

If a given Species object definition does not specify a conversion
factor via the 'conversionFactor' attribute on Species, then the
species inherits the conversion factor specified by the Model
'conversionFactor' attribute.  If the Model does not define a value
for this attribute, then there is no conversion factor to inherit.
More information about conversion factors is provided in the SBML
Level 3 specifications.
";


%feature("docstring") Model::Model "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    Model(SBMLNamespaces sbmlns)

Creates a new Model using the given SBMLNamespaces object 'sbmlns'.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

Parameter 'sbmlns' is an SBMLNamespaces object.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    Model(long level, long version)

Creates a new Model using the given SBML 'level' and 'version' values.

Parameter 'level' is a long integer, the SBML Level to assign to this
Model.

Parameter 'version' is a long integer, the SBML Version to assign to
this Model.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    Model(Model orig)

Copy constructor; creates a (deep) copy of the given Model object.

Parameter 'orig' is the object to copy.
";


%feature("docstring") Model::accept "
Internal implementation method.
";


%feature("docstring") Model::clone "
Creates and returns a deep copy of this Model object.

Returns the (deep) copy of this Model object.
";


%feature("docstring") Model::getElementBySId "
Returns the first child element found that has the given 'id'.

This operation searches the model-wide SId identifier type namespace

Parameter 'id' is string representing the id of the object to find.

Returns pointer to the first element found with the given 'id', or
'None' if no such object is found.
";


%feature("docstring") Model::getElementByMetaId "
Returns the first child element it can find with the given 'metaid'.

Parameter 'metaid' is string representing the meta-identifier of the
object to find.

Returns pointer to the first element found with the given 'metaid', or
None if no such object is found.
";


%feature("docstring") Model::getAllElements "
Returns a List of all child objects.

This returns all child objects nested to an arbitrary depth.  If an
optional element filter is provided, only those objects for which the
'filter's' filter() method returns true will be added to  the list.

Parameter 'filter' is a pointer to an ElementFilter, which causes the
function  to return only elements that match a particular set of
constraints.   If None (the default), the function will return all
child objects.

Returns a List of pointers to all children objects.
";


%feature("docstring") Model::getId "
Returns the value of the 'id' attribute of this Model.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
getIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns the id of this Model.

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") Model::getName "
Returns the value of the 'name' attribute of this Model object.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns the name of this SBML object, or the empty string if not set
or unsettable.

See also getIdAttribute(), isSetName(), setName(), unsetName().
";


%feature("docstring") Model::getSubstanceUnits "
Returns the value of the 'substanceUnits' attribute of this Model.

Returns the substanceUnits of this Model.

Note: The 'substanceUnits' attribute is available in SBML Level 3 but
is not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::getTimeUnits "
Returns the value of the 'timeUnits' attribute of this Model.

Returns the timeUnits of this Model.

Note: The 'timeUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::getVolumeUnits "
Returns the value of the 'volumeUnits' attribute of this Model.

Returns the volumeUnits of this Model.

Note: The 'volumeUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::getAreaUnits "
Returns the value of the 'areaUnits' attribute of this Model.

Returns the areaUnits of this Model.

Note: The 'areaUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::getLengthUnits "
Returns the value of the 'lengthUnits' attribute of this Model.

Returns the lengthUnits of this Model.

Note: The 'lengthUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::getExtentUnits "
Returns the value of the 'extentUnits' attribute of this Model.

Returns the extentUnits of this Model.

Note: The 'extentUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::getConversionFactor "
Returns the value of the 'conversionFactor' attribute of this Model.

Returns the conversionFactor of this Model.

Note: The 'conversionFactor' attribute is available in  SBML Level 3
but is not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::isSetId "
Predicate returning 'True' if this Model's 'id' attribute is set.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
isSetIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns 'True' if the 'id' attribute of this SBML object is set,
'False' otherwise.

See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
isSetIdAttribute().
";


%feature("docstring") Model::isSetName "
Predicate returning 'True' if this Model's 'name' attribute is set.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns 'True' if the 'name' attribute of this SBML object is set,
'False' otherwise.

See also getName(), setName(), unsetName().
";


%feature("docstring") Model::isSetSubstanceUnits "
Predicate returning 'True' if this Model's 'substanceUnits' attribute
is set.

Returns 'True' if the 'substanceUnits' attribute of this Model is set,
'False' otherwise.

Note: The 'substanceUnits' attribute is available in  SBML Level 3 but
is not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::isSetTimeUnits "
Predicate returning 'True' if this Model's 'timeUnits' attribute is
set.

Returns 'True' if the 'timeUnits' attribute of this Model is set,
'False' otherwise.

Note: The 'substanceUnits' attribute is available in  SBML Level 3 but
is not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::isSetVolumeUnits "
Predicate returning 'True' if this Model's 'volumeUnits' attribute is
set.

Returns 'True' if the 'volumeUnits' attribute of this Model is set,
'False' otherwise.

Note: The 'volumeUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::isSetAreaUnits "
Predicate returning 'True' if this Model's 'areaUnits' attribute is
set.

Returns 'True' if the 'areaUnits' attribute of this Model is set,
'False' otherwise.

Note: The 'areaUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::isSetLengthUnits "
Predicate returning 'True' if this Model's 'lengthUnits' attribute is
set.

Returns 'True' if the 'lengthUnits' attribute of this Model is set,
'False' otherwise.

Note: The 'lengthUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::isSetExtentUnits "
Predicate returning 'True' if this Model's 'extentUnits' attribute is
set.

Returns 'True' if the 'extentUnits' attribute of this Model is set,
'False' otherwise.

Note: The 'extentUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::isSetConversionFactor "
Predicate returning 'True' if this Model's 'conversionFactor'
attribute is set.

Returns 'True' if the 'conversionFactor' attribute of this Model is
set, 'False' otherwise.

Note: The 'conversionFactor' attribute is available in  SBML Level 3
but is not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::setId "
Sets the value of the 'id' attribute of this Model.

The string 'sid' is copied.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Parameter 'sid' is the string to use as the identifier of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") Model::setName "
Sets the value of the 'name' attribute of this Model.

The string in 'name' is copied.

Parameter 'name' is the new name for the SBML object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") Model::setSubstanceUnits "
Sets the value of the 'substanceUnits' attribute of this Model.

The string in 'units' is copied.

Parameter 'units' is the new substanceUnits for the Model.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_INVALID_ATTRIBUTE_VALUE

Note: The 'substanceUnits' attribute is available in  SBML Level 3 but
is not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::setTimeUnits "
Sets the value of the 'timeUnits' attribute of this Model.

The string in 'units' is copied.

Parameter 'units' is the new timeUnits for the Model.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_INVALID_ATTRIBUTE_VALUE

Note: The 'timeUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::setVolumeUnits "
Sets the value of the 'volumeUnits' attribute of this Model.

The string in 'units' is copied.

Parameter 'units' is the new volumeUnits for the Model.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_INVALID_ATTRIBUTE_VALUE

Note: The 'volumeUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::setAreaUnits "
Sets the value of the 'areaUnits' attribute of this Model.

The string in 'units' is copied.

Parameter 'units' is the new areaUnits for the Model.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_INVALID_ATTRIBUTE_VALUE

Note: The 'areaUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::setLengthUnits "
Sets the value of the 'lengthUnits' attribute of this Model.

The string in 'units' is copied.

Parameter 'units' is the new lengthUnits for the Model.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_INVALID_ATTRIBUTE_VALUE

Note: The 'lengthUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::setExtentUnits "
Sets the value of the 'extentUnits' attribute of this Model.

The string in 'units' is copied.

Parameter 'units' is the new extentUnits for the Model.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_INVALID_ATTRIBUTE_VALUE

Note: The 'extentUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::setConversionFactor "
Sets the value of the 'conversionFactor' attribute of this Model.

The string in 'units' is copied.

Parameter 'units' is the new conversionFactor for the Model.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_INVALID_ATTRIBUTE_VALUE

Note: The 'conversionFactor' attribute is available in  SBML Level 3
but is not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::unsetId "
Unsets the value of the 'id' attribute of this Model.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") Model::unsetName "
Unsets the value of the 'name' attribute of this Model.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also getName(), setName(), isSetName().
";


%feature("docstring") Model::unsetSubstanceUnits "
Unsets the value of the 'substanceUnits' attribute of this Model.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

Note: The 'substanceUnits' attribute is available in  SBML Level 3 but
is not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::unsetTimeUnits "
Unsets the value of the 'timeUnits' attribute of this Model.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

Note: The 'timeUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::unsetVolumeUnits "
Unsets the value of the 'volumeUnits' attribute of this Model.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

Note: The 'volumeUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::unsetAreaUnits "
Unsets the value of the 'areaUnits' attribute of this Model.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_OPERATION_FAILED

Note: The 'areaUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::unsetLengthUnits "
Unsets the value of the 'lengthUnits' attribute of this Model.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_OPERATION_FAILED

Note: The 'lengthUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::unsetExtentUnits "
Unsets the value of the 'extentUnits' attribute of this Model.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_OPERATION_FAILED

Note: The 'extentUnits' attribute is available in  SBML Level 3 but is
not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::unsetConversionFactor "
Unsets the value of the 'conversionFactor' attribute of this Model.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_OPERATION_FAILED

Note: The 'conversionFactor' attribute is available in  SBML Level 3
but is not present on Model in lower Levels of SBML.
";


%feature("docstring") Model::addFunctionDefinition "
Adds a copy of the given FunctionDefinition object to this Model.

Parameter 'fd' is the FunctionDefinition to add.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_LEVEL_MISMATCH

* LIBSBML_VERSION_MISMATCH

* LIBSBML_DUPLICATE_OBJECT_ID

* LIBSBML_INVALID_OBJECT

* LIBSBML_OPERATION_FAILED

Note: This method should be used with some caution.  The fact that
this method copies the object passed to it means that the caller will
be left holding a physically different object instance than the one
contained inside this object.  Changes made to the original object
instance (such as resetting attribute values) will not affect the
instance in this object.  In addition, the caller should make sure to
free the original object if it is no longer being used, or else a
memory leak will result.  Please see other methods on this class
(particularly a corresponding method whose name begins with the word
create) for alternatives that do not lead to these issues.

See also createFunctionDefinition().
";


%feature("docstring") Model::addUnitDefinition "
Adds a copy of the given UnitDefinition object to this Model.

Parameter 'ud' is the UnitDefinition object to add.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_LEVEL_MISMATCH

* LIBSBML_VERSION_MISMATCH

* LIBSBML_DUPLICATE_OBJECT_ID

* LIBSBML_INVALID_OBJECT

* LIBSBML_OPERATION_FAILED

Note: This method should be used with some caution.  The fact that
this method copies the object passed to it means that the caller will
be left holding a physically different object instance than the one
contained inside this object.  Changes made to the original object
instance (such as resetting attribute values) will not affect the
instance in this object.  In addition, the caller should make sure to
free the original object if it is no longer being used, or else a
memory leak will result.  Please see other methods on this class
(particularly a corresponding method whose name begins with the word
create) for alternatives that do not lead to these issues.

See also createUnitDefinition().
";


%feature("docstring") Model::addCompartmentType "
Adds a copy of the given CompartmentType object to this Model.

Parameter 'ct' is the CompartmentType object to add.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_LEVEL_MISMATCH

* LIBSBML_VERSION_MISMATCH

* LIBSBML_DUPLICATE_OBJECT_ID

* LIBSBML_INVALID_OBJECT

* LIBSBML_OPERATION_FAILED

Note: This method should be used with some caution.  The fact that
this method copies the object passed to it means that the caller will
be left holding a physically different object instance than the one
contained inside this object.  Changes made to the original object
instance (such as resetting attribute values) will not affect the
instance in this object.  In addition, the caller should make sure to
free the original object if it is no longer being used, or else a
memory leak will result.  Please see other methods on this class
(particularly a corresponding method whose name begins with the word
create) for alternatives that do not lead to these issues.

Note: The CompartmentType object class is only available in SBML Level
2 Versions 2-4.  It is not available in Level 1 nor Level 3.

See also createCompartmentType().
";


%feature("docstring") Model::addSpeciesType "
Adds a copy of the given SpeciesType object to this Model.

Parameter 'st' is the SpeciesType object to add.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_LEVEL_MISMATCH

* LIBSBML_VERSION_MISMATCH

* LIBSBML_DUPLICATE_OBJECT_ID

* LIBSBML_INVALID_OBJECT

* LIBSBML_OPERATION_FAILED

Note: This method should be used with some caution.  The fact that
this method copies the object passed to it means that the caller will
be left holding a physically different object instance than the one
contained inside this object.  Changes made to the original object
instance (such as resetting attribute values) will not affect the
instance in this object.  In addition, the caller should make sure to
free the original object if it is no longer being used, or else a
memory leak will result.  Please see other methods on this class
(particularly a corresponding method whose name begins with the word
create) for alternatives that do not lead to these issues.

Note: The SpeciesType object class is only available in SBML Level 2
Versions 2-4.  It is not available in Level 1 nor Level 3.

See also createSpeciesType().
";


%feature("docstring") Model::addCompartment "
Adds a copy of the given Compartment object to this Model.

Parameter 'c' is the Compartment object to add.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_LEVEL_MISMATCH

* LIBSBML_VERSION_MISMATCH

* LIBSBML_DUPLICATE_OBJECT_ID

* LIBSBML_INVALID_OBJECT

* LIBSBML_OPERATION_FAILED

Note: This method should be used with some caution.  The fact that
this method copies the object passed to it means that the caller will
be left holding a physically different object instance than the one
contained inside this object.  Changes made to the original object
instance (such as resetting attribute values) will not affect the
instance in this object.  In addition, the caller should make sure to
free the original object if it is no longer being used, or else a
memory leak will result.  Please see other methods on this class
(particularly a corresponding method whose name begins with the word
create) for alternatives that do not lead to these issues.

See also createCompartment().
";


%feature("docstring") Model::addSpecies "
Adds a copy of the given Species object to this Model.

Parameter 's' is the Species object to add.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_LEVEL_MISMATCH

* LIBSBML_VERSION_MISMATCH

* LIBSBML_DUPLICATE_OBJECT_ID

* LIBSBML_INVALID_OBJECT

* LIBSBML_OPERATION_FAILED

Note: This method should be used with some caution.  The fact that
this method copies the object passed to it means that the caller will
be left holding a physically different object instance than the one
contained inside this object.  Changes made to the original object
instance (such as resetting attribute values) will not affect the
instance in this object.  In addition, the caller should make sure to
free the original object if it is no longer being used, or else a
memory leak will result.  Please see other methods on this class
(particularly a corresponding method whose name begins with the word
create) for alternatives that do not lead to these issues.

See also createSpecies().
";


%feature("docstring") Model::addParameter "
Adds a copy of the given Parameter object to this Model.

Parameter 'p' is the Parameter object to add.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_LEVEL_MISMATCH

* LIBSBML_VERSION_MISMATCH

* LIBSBML_DUPLICATE_OBJECT_ID

* LIBSBML_INVALID_OBJECT

* LIBSBML_OPERATION_FAILED

Note: This method should be used with some caution.  The fact that
this method copies the object passed to it means that the caller will
be left holding a physically different object instance than the one
contained inside this object.  Changes made to the original object
instance (such as resetting attribute values) will not affect the
instance in this object.  In addition, the caller should make sure to
free the original object if it is no longer being used, or else a
memory leak will result.  Please see other methods on this class
(particularly a corresponding method whose name begins with the word
create) for alternatives that do not lead to these issues.

See also createParameter().
";


%feature("docstring") Model::addInitialAssignment "
Adds a copy of the given InitialAssignment object to this Model.

Parameter 'ia' is the InitialAssignment object to add.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_LEVEL_MISMATCH

* LIBSBML_VERSION_MISMATCH

* LIBSBML_DUPLICATE_OBJECT_ID

* LIBSBML_INVALID_OBJECT

* LIBSBML_OPERATION_FAILED

Note: This method should be used with some caution.  The fact that
this method copies the object passed to it means that the caller will
be left holding a physically different object instance than the one
contained inside this object.  Changes made to the original object
instance (such as resetting attribute values) will not affect the
instance in this object.  In addition, the caller should make sure to
free the original object if it is no longer being used, or else a
memory leak will result.  Please see other methods on this class
(particularly a corresponding method whose name begins with the word
create) for alternatives that do not lead to these issues.

See also createInitialAssignment().
";


%feature("docstring") Model::addRule "
Adds a copy of the given Rule object to this Model.

Parameter 'r' is the Rule object to add.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_LEVEL_MISMATCH

* LIBSBML_VERSION_MISMATCH

* LIBSBML_DUPLICATE_OBJECT_ID

* LIBSBML_INVALID_OBJECT

* LIBSBML_OPERATION_FAILED

Note: This method should be used with some caution.  The fact that
this method copies the object passed to it means that the caller will
be left holding a physically different object instance than the one
contained inside this object.  Changes made to the original object
instance (such as resetting attribute values) will not affect the
instance in this object.  In addition, the caller should make sure to
free the original object if it is no longer being used, or else a
memory leak will result.  Please see other methods on this class
(particularly a corresponding method whose name begins with the word
create) for alternatives that do not lead to these issues.

See also createAlgebraicRule(), createAssignmentRule(),
createRateRule().
";


%feature("docstring") Model::addConstraint "
Adds a copy of the given Constraint object to this Model.

Parameter 'c' is the Constraint object to add.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_LEVEL_MISMATCH

* LIBSBML_VERSION_MISMATCH

* LIBSBML_INVALID_OBJECT

* LIBSBML_OPERATION_FAILED

Note: This method should be used with some caution.  The fact that
this method copies the object passed to it means that the caller will
be left holding a physically different object instance than the one
contained inside this object.  Changes made to the original object
instance (such as resetting attribute values) will not affect the
instance in this object.  In addition, the caller should make sure to
free the original object if it is no longer being used, or else a
memory leak will result.  Please see other methods on this class
(particularly a corresponding method whose name begins with the word
create) for alternatives that do not lead to these issues.

See also createConstraint().
";


%feature("docstring") Model::addReaction "
Adds a copy of the given Reaction object to this Model.

Parameter 'r' is the Reaction object to add.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_LEVEL_MISMATCH

* LIBSBML_VERSION_MISMATCH

* LIBSBML_DUPLICATE_OBJECT_ID

* LIBSBML_INVALID_OBJECT

* LIBSBML_OPERATION_FAILED

Note: This method should be used with some caution.  The fact that
this method copies the object passed to it means that the caller will
be left holding a physically different object instance than the one
contained inside this object.  Changes made to the original object
instance (such as resetting attribute values) will not affect the
instance in this object.  In addition, the caller should make sure to
free the original object if it is no longer being used, or else a
memory leak will result.  Please see other methods on this class
(particularly a corresponding method whose name begins with the word
create) for alternatives that do not lead to these issues.

See also createReaction().
";


%feature("docstring") Model::addEvent "
Adds a copy of the given Event object to this Model.

Parameter 'e' is the Event object to add.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_LEVEL_MISMATCH

* LIBSBML_VERSION_MISMATCH

* LIBSBML_DUPLICATE_OBJECT_ID

* LIBSBML_INVALID_OBJECT

* LIBSBML_OPERATION_FAILED

Note: This method should be used with some caution.  The fact that
this method copies the object passed to it means that the caller will
be left holding a physically different object instance than the one
contained inside this object.  Changes made to the original object
instance (such as resetting attribute values) will not affect the
instance in this object.  In addition, the caller should make sure to
free the original object if it is no longer being used, or else a
memory leak will result.  Please see other methods on this class
(particularly a corresponding method whose name begins with the word
create) for alternatives that do not lead to these issues.

See also createEvent().
";


%feature("docstring") Model::createFunctionDefinition "
Creates a new FunctionDefinition inside this Model and returns it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

Returns the FunctionDefinition object created.

See also addFunctionDefinition().
";


%feature("docstring") Model::createUnitDefinition "
Creates a new UnitDefinition inside this Model and returns it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

Returns the UnitDefinition object created.

See also addUnitDefinition().
";


%feature("docstring") Model::createUnit "
Creates a new Unit object within the last UnitDefinition object
created in this model and returns a pointer to it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

The mechanism by which the UnitDefinition was created is not
significant.  If a UnitDefinition object does not exist in this model,
a new Unit is not created and 'None' is returned instead.

Returns the Unit object created.

See also addUnitDefinition().
";


%feature("docstring") Model::createCompartmentType "
Creates a new CompartmentType inside this Model and returns it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

Returns the CompartmentType object created.

Note: The CompartmentType object class is only available in SBML Level
2 Versions 2-4.  It is not available in Level 1 nor Level 3.

See also addCompartmentType().
";


%feature("docstring") Model::createSpeciesType "
Creates a new SpeciesType inside this Model and returns it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

Returns the SpeciesType object created.

Note: The SpeciesType object class is only available in SBML Level 2
Versions 2-4.  It is not available in Level 1 nor Level 3.

See also addSpeciesType().
";


%feature("docstring") Model::createCompartment "
Creates a new Compartment inside this Model and returns it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

Returns the Compartment object created.

See also addCompartment().
";


%feature("docstring") Model::createSpecies "
Creates a new Species inside this Model and returns it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

Returns the Species object created.

See also addSpecies().
";


%feature("docstring") Model::createParameter "
Creates a new Parameter inside this Model and returns it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

Returns the Parameter object created.

See also addParameter().
";


%feature("docstring") Model::createInitialAssignment "
Creates a new InitialAssignment inside this Model and returns it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

Returns the InitialAssignment object created.

See also addInitialAssignment().
";


%feature("docstring") Model::createAlgebraicRule "
Creates a new AlgebraicRule inside this Model and returns it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

Returns the AlgebraicRule object created.

See also addRule().
";


%feature("docstring") Model::createAssignmentRule "
Creates a new AssignmentRule inside this Model and returns it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

Returns the AssignmentRule object created.

See also addRule().
";


%feature("docstring") Model::createRateRule "
Creates a new RateRule inside this Model and returns it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

Returns the RateRule object created.

See also addRule().
";


%feature("docstring") Model::createConstraint "
Creates a new Constraint inside this Model and returns it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

Returns the Constraint object created.

See also addConstraint().
";


%feature("docstring") Model::createReaction "
Creates a new Reaction inside this Model and returns it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

Returns the Reaction object created.

See also addReaction().
";


%feature("docstring") Model::createReactant "
Creates a new SpeciesReference object for a reactant inside the last
Reaction object in this Model, and returns a pointer to it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

The mechanism by which the last Reaction object was created and added
to this Model is not significant.  It could have been created in a
variety of ways, for example using createReaction().  If a Reaction
does not exist for this model, a new SpeciesReference is not created
and 'None' is returned instead.

Returns the SpeciesReference object created.  If a Reaction does not
exist for this model, a new SpeciesReference is not created and 'None'
is returned.
";


%feature("docstring") Model::createProduct "
Creates a new SpeciesReference object for a product inside the last
Reaction object in this Model, and returns a pointer to it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

The mechanism by which the last Reaction object was created and added
to this Model is not significant.  It could have been created in a
variety of ways, for example using createReaction().  If a Reaction
does not exist for this model, a new SpeciesReference is not created
and 'None' is returned instead.

Returns the SpeciesReference object created. If a Reaction does not
exist for this model, a new SpeciesReference is not created and 'None'
is returned.
";


%feature("docstring") Model::createModifier "
Creates a new ModifierSpeciesReference object for a modifier species
inside the last Reaction object in this Model, and returns a pointer
to it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

The mechanism by which the last Reaction object was created and added
to this Model is not significant.  It could have been created in a
variety of ways, for example using createReaction().  If a Reaction
does not exist for this model, a new SpeciesReference is not created
and 'None' is returned instead.

Returns the SpeciesReference object created.  If a Reaction does not
exist for this model, a new SpeciesReference is not created and 'None'
is returned.
";


%feature("docstring") Model::createKineticLaw "
Creates a new KineticLaw inside the last Reaction object created in
this Model, and returns a pointer to it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

The mechanism by which the last Reaction object was created and added
to this Model is not significant.  It could have been created in a
variety of ways, for example using createReaction().  If a Reaction
does not exist for this model, a new SpeciesReference is not created
and 'None' is returned instead.

Returns the KineticLaw object created.  If a Reaction does not exist
for this model, or a Reaction does exist but already has a KineticLaw,
a new KineticLaw is not created and 'None' is returned.
";


%feature("docstring") Model::createKineticLawParameter "
Creates a new local Parameter inside the KineticLaw object of the last
Reaction created inside this Model, and returns a pointer to it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

The last KineticLaw object in this Model could have been created in a
variety of ways.  For example, it could have been added using
createKineticLaw(), or it could be the result of using
Reaction.createKineticLaw() on the Reaction object created by a
createReaction().  If a Reaction does not exist for this model, or the
last Reaction does not contain a KineticLaw object, a new Parameter is
not created and 'None' is returned instead.

Returns the Parameter object created.  If a Reaction does not exist
for this model, or a KineticLaw for the Reaction does not exist, a new
Parameter is not created and 'None' is returned.
";


%feature("docstring") Model::createKineticLawLocalParameter "
Creates a new LocalParameter inside the KineticLaw object of the last
Reaction created inside this Model, and returns a pointer to it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

The last KineticLaw object in this Model could have been created in a
variety of ways.  For example, it could have been added using
createKineticLaw(), or it could be the result of using
Reaction.createKineticLaw() on the Reaction object created by a
createReaction().  If a Reaction does not exist for this model, or the
last Reaction does not contain a KineticLaw object, a new Parameter is
not created and 'None' is returned instead.

Returns the Parameter object created.  If a Reaction does not exist
for this model, or a KineticLaw for the Reaction does not exist, a new
Parameter is not created and 'None' is returned.
";


%feature("docstring") Model::createEvent "
Creates a new Event inside this Model and returns it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

Returns the Event object created.
";


%feature("docstring") Model::createEventAssignment "
Creates a new EventAssignment inside the last Event object created in
this Model, and returns a pointer to it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

The mechanism by which the last Event object in this model was
created is not significant.  It could have been created in a variety
of ways, for example by using createEvent().  If no Event object
exists in this Model object, a new EventAssignment is not created and
'None' is returned instead.

Returns the EventAssignment object created.
";


%feature("docstring") Model::createTrigger "
Creates a new Trigger inside the last Event object created in this
Model, and returns a pointer to it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

The mechanism by which the last Event object in this model was
created is not significant.  It could have been created in a variety
of ways, for example by using createEvent().  If no Event object
exists in this Model object, a new EventAssignment is not created and
'None' is returned instead.

Returns the Trigger object created.
";


%feature("docstring") Model::createDelay "
Creates a new Delay inside the last Event object created in this
Model, and returns a pointer to it.

The SBML Level and Version of the enclosing Model object, as well as
any SBML package namespaces, are used to initialize this object's
corresponding attributes.

The mechanism by which the last Event object in this model was
created is not significant.  It could have been created in a variety
of ways, for example by using createEvent().  If no Event object
exists in this Model object, a new EventAssignment is not created and
'None' is returned instead.

Returns the Delay object created.
";


%feature("docstring") Model::setAnnotation "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    setAnnotation(XMLNode annotation)

Sets the value of the 'annotation' subelement of this SBML object to a
copy of 'annotation'.

Any existing content of the 'annotation' subelement is discarded.
Unless you have taken steps to first copy and reconstitute any
existing annotations into the 'annotation' that is about to be
assigned, it is likely that performing such wholesale replacement is
unfriendly towards other software applications whose annotations are
discarded.  An alternative may be to use appendAnnotation().

Parameter 'annotation' is an XML structure that is to be used as the
content of the 'annotation' subelement of this object.

Returns integer value indicating success/failure of the function.
This particular function only does one thing irrespective of user
input or  object state, and thus will only return a single value:

* LIBSBML_OPERATION_SUCCESS

See also appendAnnotation().

______________________________________________________________________
Method variant with the following signature:

    setAnnotation(string annotation)

Sets the value of the 'annotation' subelement of this SBML object to a
copy of 'annotation'.

Any existing content of the 'annotation' subelement is discarded.
Unless you have taken steps to first copy and reconstitute any
existing annotations into the 'annotation' that is about to be
assigned, it is likely that performing such wholesale replacement is
unfriendly towards other software applications whose annotations are
discarded.  An alternative may be to use appendAnnotation().

Parameter 'annotation' is an XML string that is to be used as the
content of the 'annotation' subelement of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also appendAnnotation().
";


%feature("docstring") Model::appendAnnotation "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    appendAnnotation(XMLNode annotation)

Appends annotation content to any existing content in the 'annotation'
subelement of this object.

The content in 'annotation' is copied.  Unlike setAnnotation(), this
method allows other annotations to be preserved when an application
adds its own data.

Parameter 'annotation' is an XML structure that is to be copied and
appended to the content of the 'annotation' subelement of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also setAnnotation().

______________________________________________________________________
Method variant with the following signature:

    appendAnnotation(string annotation)

Appends annotation content to any existing content in the 'annotation'
subelement of this object.

The content in 'annotation' is copied.  Unlike setAnnotation(), this
method allows other annotations to be preserved when an application
adds its own data.

Parameter 'annotation' is an XML string that is to be copied and
appended to the content of the 'annotation' subelement of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also setAnnotation().
";


%feature("docstring") Model::getListOfFunctionDefinitions "
Get the ListOfFunctionDefinitions object in this Model.

Returns the list of FunctionDefinitions for this Model.
";


%feature("docstring") Model::getListOfUnitDefinitions "
Get the ListOfUnitDefinitions object in this Model.

Returns the list of UnitDefinitions for this Model.
";


%feature("docstring") Model::getListOfCompartmentTypes "
Get the ListOfCompartmentTypes object in this Model.

Returns the list of CompartmentTypes for this Model.

Note: The CompartmentType object class is only available in SBML Level
2 Versions 2-4.  It is not available in Level 1 nor Level 3.
";


%feature("docstring") Model::getListOfSpeciesTypes "
Get the ListOfSpeciesTypes object in this Model.

Returns the list of SpeciesTypes for this Model.

Note: The SpeciesType object class is only available in SBML Level 2
Versions 2-4.  It is not available in Level 1 nor Level 3.
";


%feature("docstring") Model::getListOfCompartments "
Get the ListOfCompartments object in this Model.

Returns the list of Compartments for this Model.
";


%feature("docstring") Model::getListOfSpecies "
Get the ListOfSpecies object in this Model.

Returns the list of Species for this Model.
";


%feature("docstring") Model::getListOfParameters "
Get the ListOfParameters object in this Model.

Returns the list of Parameters for this Model.
";


%feature("docstring") Model::getListOfInitialAssignments "
Get the ListOfInitialAssignments object in this Model.

Returns the list of InitialAssignments for this Model.
";


%feature("docstring") Model::getListOfRules "
Get the ListOfRules object in this Model.

Returns the list of Rules for this Model.
";


%feature("docstring") Model::getListOfConstraints "
Get the ListOfConstraints object in this Model.

Returns the list of Constraints for this Model.
";


%feature("docstring") Model::getListOfReactions "
Get the ListOfReactions object in this Model.

Returns the list of Reactions for this Model.
";


%feature("docstring") Model::getListOfEvents "
Get the ListOfEvents object in this Model.

Returns the list of Events for this Model.
";


%feature("docstring") Model::getFunctionDefinition "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    getFunctionDefinition(long n)

Get the nth FunctionDefinitions object in this Model.

Parameter 'n' is the index of the object to return.

Returns the nth FunctionDefinition of this Model.

______________________________________________________________________
Method variant with the following signature:

    getFunctionDefinition(string sid)

Get a FunctionDefinition object based on its identifier.

Parameter 'sid' is the identifier to search for.

Returns the FunctionDefinition in this Model with the identifier 'sid'
or 'None' if no such FunctionDefinition exists.
";


%feature("docstring") Model::getUnitDefinition "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    getUnitDefinition(long n)

Get the nth UnitDefinition object in this Model.

Parameter 'n' is the index of the object to return.

Returns the nth UnitDefinition of this Model.

______________________________________________________________________
Method variant with the following signature:

    getUnitDefinition(string sid)

Get a UnitDefinition based on its identifier.

Parameter 'sid' is the identifier to search for.

Returns the UnitDefinition in this Model with the identifier 'sid' or
'None' if no such UnitDefinition exists.
";


%feature("docstring") Model::getCompartmentType "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    getCompartmentType(long n)

Get the nth CompartmentType object in this Model.

Parameter 'n' is the index of the object to return.

Returns the nth CompartmentType of this Model.

Note: The CompartmentType object class is only available in SBML Level
2 Versions 2-4.  It is not available in Level 1 nor Level 3.

______________________________________________________________________
Method variant with the following signature:

    getCompartmentType(string sid)

Get a CompartmentType object based on its identifier.

Parameter 'sid' is the identifier to search for.

Returns the CompartmentType in this Model with the identifier 'sid' or
'None' if no such CompartmentType exists.

Note: The CompartmentType object class is only available in SBML Level
2 Versions 2-4.  It is not available in Level 1 nor Level 3.
";


%feature("docstring") Model::getSpeciesType "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    getSpeciesType(long n)

Get the nth SpeciesType object in this Model.

Parameter 'n' is the index of the object to return.

Returns the nth SpeciesType of this Model.

Note: The SpeciesType object class is only available in SBML Level 2
Versions 2-4.  It is not available in Level 1 nor Level 3.

______________________________________________________________________
Method variant with the following signature:

    getSpeciesType(string sid)

Get a SpeciesType object based on its identifier.

Parameter 'sid' is the identifier to search for.

Returns the SpeciesType in this Model with the identifier 'sid' or
'None' if no such SpeciesType exists.

Note: The SpeciesType object class is only available in SBML Level 2
Versions 2-4.  It is not available in Level 1 nor Level 3.
";


%feature("docstring") Model::getCompartment "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    getCompartment(long n)

Get the nth Compartment object in this Model.

Parameter 'n' is the index of the object to return.

Returns the nth Compartment of this Model.

______________________________________________________________________
Method variant with the following signature:

    getCompartment(string sid)

Get a Compartment object based on its identifier.

Parameter 'sid' is the identifier to search for.

Returns the Compartment in this Model with the identifier 'sid' or
'None' if no such Compartment exists.
";


%feature("docstring") Model::getSpecies "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    getSpecies(long n)

Get the nth Species object in this Model.

Parameter 'n' is the index of the object to return.

Returns the nth Species of this Model.

______________________________________________________________________
Method variant with the following signature:

    getSpecies(string sid)

Get a Species object based on its identifier.

Parameter 'sid' is the identifier to search for.

Returns the Species in this Model with the identifier 'sid' or 'None'
if no such Species exists.
";


%feature("docstring") Model::getParameter "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    getParameter(long n)

Get the nth Parameter object in this Model.

Parameter 'n' is the index of the object to return.

Returns the nth Parameter of this Model.

______________________________________________________________________
Method variant with the following signature:

    getParameter(string sid)

Get a Parameter object based on its identifier.

Parameter 'sid' is the identifier to search for.

Returns the Parameter in this Model with the identifier 'sid' or
'None' if no such Parameter exists.
";


%feature("docstring") Model::getInitialAssignment "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    getInitialAssignment(string symbol)

Get an InitialAssignment object based on the symbol to which it
assigns a value.

Parameter 'symbol' is the symbol to search for.

Returns the InitialAssignment in this Model with the given 'symbol'
attribute value or 'None' if no such InitialAssignment exists.

______________________________________________________________________
Method variant with the following signature:

    getInitialAssignment(long n)

Get the nth InitialAssignment object in this Model.

Parameter 'n' is the index of the object to return.

Returns the nth InitialAssignment of this Model.
";


%feature("docstring") Model::getInitialAssignmentBySymbol "
Get an InitialAssignment object based on the symbol to which it
assigns a value.

Parameter 'symbol' is the symbol to search for.

Returns the InitialAssignment in this Model with the given 'symbol'
attribute value or 'None' if no such InitialAssignment exists.
";


%feature("docstring") Model::getRule "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    getRule(string variable)

Get a Rule object based on the variable to which it assigns a value.

Parameter 'variable' is the variable to search for.

Returns the Rule in this Model with the given 'variable' attribute
value or 'None' if no such Rule exists.

______________________________________________________________________
Method variant with the following signature:

    getRule(long n)

Get the nth Rule object in this Model.

Parameter 'n' is the index of the object to return.

Returns the nth Rule of this Model.
";


%feature("docstring") Model::getRuleByVariable "
Get a Rule object based on the variable to which it assigns a value.

Parameter 'variable' is the variable to search for.

Returns the Rule in this Model with the given 'variable' attribute
value or 'None' if no such Rule exists.
";


%feature("docstring") Model::getAssignmentRule "
Get a Rule object based on the variable to which it assigns a value.

Parameter 'variable' is the variable to search for.

Returns the Rule in this Model with the given 'variable' attribute
value or 'None' if no such Rule exists.
";


%feature("docstring") Model::getRateRule "
Get a Rule object based on the variable to which it assigns a value.

Parameter 'variable' is the symbol to search for.

Returns the Rule in this Model with the given 'variable' attribute
value or 'None' if no such Rule exists.
";


%feature("docstring") Model::getAssignmentRuleByVariable "
Get a Rule object based on the variable to which it assigns a value.

Parameter 'variable' is the variable to search for.

Returns the Rule in this Model with the given 'variable' attribute
value or 'None' if no such Rule exists.
";


%feature("docstring") Model::getRateRuleByVariable "
Get a Rule object based on the variable to which it assigns a value.

Parameter 'variable' is the variable to search for.

Returns the Rule in this Model with the given 'variable' attribute
value or 'None' if no such Rule exists.
";


%feature("docstring") Model::getConstraint "
Get the nth Constraint object in this Model.

Parameter 'n' is the index of the object to return.

Returns the nth Constraint of this Model.
";


%feature("docstring") Model::getReaction "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    getReaction(long n)

Get the nth Reaction object in this Model.

Parameter 'n' is the index of the object to return.

Returns the nth Reaction of this Model.

______________________________________________________________________
Method variant with the following signature:

    getReaction(string sid)

Get a Reaction object based on its identifier.

Parameter 'sid' is the identifier to search for.

Returns the Reaction in this Model with the identifier 'sid' or 'None'
if no such Reaction exists.
";


%feature("docstring") Model::getSpeciesReference "
Get a SpeciesReference object based on its identifier.

Parameter 'sid' is the identifier to search for.

Returns the SpeciesReference in this Model with the identifier 'sid'
or 'None' if no such SpeciesReference exists.
";


%feature("docstring") Model::getModifierSpeciesReference "
Get a ModifierSpeciesReference object based on its identifier.

Parameter 'sid' is the identifier to search for.

Returns the ModifierSpeciesReference in this Model with the
identifier 'sid' or 'None' if no such ModifierSpeciesReference exists.
";


%feature("docstring") Model::getEvent "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    getEvent(long n)

Get the nth Event object in this Model.

Parameter 'n' is the index of the object to return.

Returns the nth Event of this Model.

______________________________________________________________________
Method variant with the following signature:

    getEvent(string sid)

Get an Event object based on its identifier.

Parameter 'sid' is the identifier to search for.

Returns the Event in this Model with the identifier 'sid' or 'None' if
no such Event exists.
";


%feature("docstring") Model::getNumFunctionDefinitions "
Get the number of FunctionDefinition objects in this Model.

Returns the number of FunctionDefinitions in this Model.
";


%feature("docstring") Model::getNumUnitDefinitions "
Get the number of UnitDefinition objects in this Model.

Returns the number of UnitDefinitions in this Model.
";


%feature("docstring") Model::getNumCompartmentTypes "
Get the number of CompartmentType objects in this Model.

Returns the number of CompartmentTypes in this Model.

Note: The CompartmentType object class is only available in SBML Level
2 Versions 2-4.  It is not available in Level 1 nor Level 3.
";


%feature("docstring") Model::getNumSpeciesTypes "
Get the number of SpeciesType objects in this Model.

Returns the number of SpeciesTypes in this Model.

Note: The SpeciesType object class is only available in SBML Level 2
Versions 2-4.  It is not available in Level 1 nor Level 3.
";


%feature("docstring") Model::getNumCompartments "
Get the number of Compartment objects in this Model.

Returns the number of Compartments in this Model.
";


%feature("docstring") Model::getNumSpecies "
Get the number of Species objects in this Model.

Returns the number of Species in this Model.
";


%feature("docstring") Model::getNumSpeciesWithBoundaryCondition "
Get the number of Species in this Model having their
'boundaryCondition' attribute value set to 'True.'

Returns the number of Species in this Model with boundaryCondition set
to true.
";


%feature("docstring") Model::getNumParameters "
Get the number of Parameter objects in this Model.

Returns the number of Parameters in this Model.  Parameters defined in
KineticLaws are not included.
";


%feature("docstring") Model::getNumInitialAssignments "
Get the number of InitialAssignment objects in this Model.

Returns the number of InitialAssignments in this Model.
";


%feature("docstring") Model::getNumRules "
Get the number of Rule objects in this Model.

Returns the number of Rules in this Model.
";


%feature("docstring") Model::getNumConstraints "
Get the number of Constraint objects in this Model.

Returns the number of Constraints in this Model.
";


%feature("docstring") Model::getNumReactions "
Get the number of Reaction objects in this Model.

Returns the number of Reactions in this Model.
";


%feature("docstring") Model::getNumEvents "
Get the number of Event objects in this Model.

Returns the number of Events in this Model.
";


%feature("docstring") Model::removeFromParentAndDelete "
Remove this Model from its parent SBMLDocument object.

This works by finding this Model's parent SBMLDocument and then
calling setModel(None) on it, indirectly deleting itself. Overridden
from the SBase function since the parent is not a ListOf.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED
";


%feature("docstring") Model::renameAllIds "
Internal implementation method.
";


%feature("docstring") Model::renameIDs "
Internal implementation method.
";


%feature("docstring") Model::renameSIdRefs "
Replaces all uses of a given 'SIdRef' type attribute value with
another value.

In SBML, object identifiers are of a data type called SId. In SBML
Level 3, an explicit data type called SIdRef was introduced for
attribute values that refer to SId values; in previous Levels of SBML,
this data type did not exist and attributes were simply described to
as 'referring to an identifier', but the effective data type was the
same as SIdRef in Level 3.  These and other methods of libSBML refer
to the type SIdRef for all Levels of SBML, even if the corresponding
SBML specification did not explicitly name the data type.

This method works by looking at all attributes and (if appropriate)
mathematical formulas in MathML content, comparing the referenced
identifiers to the value of 'oldid'.  If any matches are found, the
matching values are replaced with 'newid'.  The method does not
descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") Model::renameUnitSIdRefs "
Replaces all uses of a given 'UnitSIdRef' type attribute value with
another value.

In SBML, unit definitions have identifiers of type UnitSId.  In SBML
Level 3, an explicit data type called UnitSIdRef was introduced for
attribute values that refer to UnitSId values; in previous Levels of
SBML, this data type did not exist and attributes were simply
described to as 'referring to a unit identifier', but the effective
data type was the same as UnitSIdRef in Level 3.  These and other
methods of libSBML refer to the type UnitSIdRef for all Levels of
SBML, even if the corresponding SBML specification did not explicitly
name the data type.

This method works by looking at all unit identifier attribute values
(including, if appropriate, inside mathematical formulas), comparing
the referenced unit identifiers to the value of 'oldid'.  If any
matches are found, the matching values are replaced with 'newid'.  The
method does not descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") Model::isBoolean "
Internal implementation method.
";


%feature("docstring") Model::convertL1ToL2 "
Internal implementation method.
";


%feature("docstring") Model::convertL1ToL3 "
Internal implementation method.
";


%feature("docstring") Model::convertL2ToL3 "
Internal implementation method.
";


%feature("docstring") Model::convertL2ToL1 "
Internal implementation method.
";


%feature("docstring") Model::convertL3ToL1 "
Internal implementation method.
";


%feature("docstring") Model::convertL3ToL2 "
Internal implementation method.
";


%feature("docstring") Model::convertFromL3V2 "
Internal implementation method.
";


%feature("docstring") Model::dealWithFast "
Internal implementation method.
";


%feature("docstring") Model::dealWithL3Fast "
Internal implementation method.
";


%feature("docstring") Model::addModifiers "
Internal implementation method.
";


%feature("docstring") Model::addConstantAttribute "
Internal implementation method.
";


%feature("docstring") Model::setSpatialDimensions "
Internal implementation method.
";


%feature("docstring") Model::addDefinitionsForDefaultUnits "
Internal implementation method.
";


%feature("docstring") Model::dealWithDefaultValues "
Internal implementation method.
";


%feature("docstring") Model::convertParametersToLocals "
Internal implementation method.
";


%feature("docstring") Model::setSpeciesReferenceConstantValueAndStoichiometry "
Internal implementation method.
";


%feature("docstring") Model::removeMetaId "
Internal implementation method.
";


%feature("docstring") Model::removeSBOTerms "
Internal implementation method.
";


%feature("docstring") Model::removeHasOnlySubstanceUnits "
Internal implementation method.
";


%feature("docstring") Model::removeSBOTermsNotInL2V2 "
Internal implementation method.
";


%feature("docstring") Model::removeDuplicateTopLevelAnnotations "
Internal implementation method.
";


%feature("docstring") Model::removeParameterRuleUnits "
Internal implementation method.
";


%feature("docstring") Model::convertStoichiometryMath "
Internal implementation method.
";


%feature("docstring") Model::assignRequiredValues "
Internal implementation method.
";


%feature("docstring") Model::dealWithModelUnits "
Internal implementation method.
";


%feature("docstring") Model::dealWithStoichiometry "
Internal implementation method.
";


%feature("docstring") Model::dealWithEvents "
Internal implementation method.
";


%feature("docstring") Model::removeSpeciesTypes "
Internal implementation method.
";


%feature("docstring") Model::removeCompartmentTypes "
Internal implementation method.
";


%feature("docstring") Model::setSBMLDocument "
Internal implementation method.
";


%feature("docstring") Model::getTypeCode "
Returns the libSBML type code for this SBML object.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for this object: SBML_MODEL (default).

WARNING:

The specific integer values of the possible type codes may be reused
by different libSBML plug-ins for SBML Level 3. packages,  To fully
identify the correct code, it is necessary to invoke both
getTypeCode() and getPackageName().

See also getElementName(), getPackageName().
";


%feature("docstring") Model::getElementName "
Returns the XML element name of this object, which for Model, is
always ''model'.'

Returns the name of this element, i.e., ''model'.'
";


%feature("docstring") Model::getElementPosition "
Internal implementation method.
";


%feature("docstring") Model::writeElements "
Internal implementation method.
";


%feature("docstring") Model::populateListFormulaUnitsData "
Populates the internal list of derived units for this Model object.

This method tells libSBML to (re)calculate all units for all
components of the enclosing Model object.  The result is stored in an
internal list of unit data.  Users can access the resulting data by
calling the method SBase.getDerivedUnitDefinition() available on most
objects.  (The name 'formula units data' is drawn from the name of the
internal objects libSBML uses to store the data; note that these
internal objects are not exposed to callers, because callers can
interact with the results using the ordinary SBML unit objects.)

This method is used by libSBML itself in the validator concerned with
unit consistency.  The unit consistency validator (like all other
validators in libSBML) is invoked by using
SBMLDocument.checkConsistency(), with the consistency checks for the
category LIBSBML_CAT_UNITS_CONSISTENCY turned on.  The method
populateListFormulaUnitsData() does not need to be called prior to
invoking the validator if unit consistency checking has not been
turned off.  This method is only provided for cases when callers have
a special need to force the unit data to be recalculated.  For
instance, during construction of a model, a caller may want to
interrogate libSBML's inferred units without invoking full-blown model
validation; this is a scenario in which calling
populateListFormulaUnitsData() may be useful.

WARNING:

Computing and inferring units is a time-consuming operation. Callers
may want to call isPopulatedListFormulaUnitsData() to determine
whether the units may already have been computed, to save themselves
the need of invoking unit inference unnecessarily.

See also isPopulatedListFormulaUnitsData().
";


%feature("docstring") Model::isPopulatedListFormulaUnitsData "
Predicate returning 'True' if libSBML has derived units for the
components of this model.

LibSBML can infer the units of measurement associated with different
elements of a model.  When libSBML does that, it builds a complex
internal structure during a resource-intensive operation.  This is
done automatically only when callers invoke validation (via
SBMLDocument.checkConsistency()) and have not turned off the unit
validation option.

Callers can force units to be recalculated by calling
populateListFormulaUnitsData().  To avoid calling that method
unnecessarily, calling programs may first want to invoke this method
(isPopulatedListFormulaUnitsData()) to determine whether it is even
necessary.

Returns 'True' if the units have already been computed, 'False'
otherwise.
";


%feature("docstring") Model::addFormulaUnitsData "
Internal implementation method.
";


%feature("docstring") Model::createFormulaUnitsData "
Internal implementation method.
";


%feature("docstring") Model::getFormulaUnitsDataForVariable "
Internal implementation method.
";


%feature("docstring") Model::getFormulaUnitsDataForAssignment "
Internal implementation method.
";


%feature("docstring") Model::getNumFormulaUnitsData "
Internal implementation method.
";


%feature("docstring") Model::getListFormulaUnitsData "
Internal implementation method.
";


%feature("docstring") Model::populateAllElementIdList "
Populates the internal list of the identifiers of all elements within
this Model object.

This method tells libSBML to retrieve the identifiers of all elements
of the enclosing Model object.  The result is stored in an internal
list of ids.  Users can access the resulting data by calling the
method getAllElementIdList().

WARNING:

Retrieving all elements within a model is a time-consuming operation.
Callers may want to call isPopulatedAllElementIdList() to determine
whether the id list may already have been populated.

See also isPopulatedAllElementIdList().
";


%feature("docstring") Model::isPopulatedAllElementIdList "
Predicate returning 'True' if libSBML has a list of the ids of all
components of this model.

Returns 'True' if the id list has already been populated, 'False'
otherwise.
";


%feature("docstring") Model::getAllElementIdList "
Returns the internal list of the identifiers of all elements within
this Model object.

Returns an IdList of all the identifiers in the model.

See also populateAllElementIdList(), isPopulatedAllElementIdList().
";


%feature("docstring") Model::clearAllElementIdList "
Clears the internal list of the identifiers of all elements within
this Model object.

See also populateAllElementIdList(), isPopulatedAllElementIdList().
";


%feature("docstring") Model::populateAllElementMetaIdList "
Populates the internal list of the metaids of all elements within this
Model object.

This method tells libSBML to retrieve the identifiers of all elements
of the enclosing Model object.  The result is stored in an internal
list of metaids.  Users can access the resulting data by calling the
method getAllElementMetaIdList().

WARNING:

Retrieving all elements within a model is a time-consuming operation.
Callers may want to call isPopulatedAllElementMetaIdList() to
determine whether the metaid list may already have been populated.

See also isPopulatedAllElementMetaIdList().
";


%feature("docstring") Model::isPopulatedAllElementMetaIdList "
Predicate returning 'True' if libSBML has a list of the metaids of all
components of this model.

Returns 'True' if the metaid list has already been populated, 'False'
otherwise.
";


%feature("docstring") Model::getAllElementMetaIdList "
Returns the internal list of the metaids of all elements within this
Model object.

Returns an IdList of all the metaids in the model.

See also populateAllElementMetaIdList(),
isPopulatedAllElementMetaIdList().
";


%feature("docstring") Model::clearAllElementMetaIdList "
Clears the internal list of the metaids of all elements within this
Model object.

See also populateAllElementMetaIdList(),
isPopulatedAllElementMetaIdList().
";


%feature("docstring") Model::hasRequiredElements "
Predicate returning 'True' if all the required elements for this Model
object have been set.

Returns a boolean value indicating whether all the required elements
for this object have been defined.
";


%feature("docstring") Model::removeFunctionDefinition "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    removeFunctionDefinition(long n)

Removes the nth FunctionDefinition object from this Model object and
returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'n' is the index of the FunctionDefinition object to remove.

Returns the FunctionDefinition object removed, or 'None' if the given
index is out of range.

______________________________________________________________________
Method variant with the following signature:

    removeFunctionDefinition(string sid)

Removes the FunctionDefinition object with the given identifier from
this Model  object and returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'sid' is the identifier of the FunctionDefinition object to
remove.

Returns the FunctionDefinition object removed, or 'None' if no
FunctionDefinition object with the identifier exists in this Model
object.
";


%feature("docstring") Model::removeUnitDefinition "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    removeUnitDefinition(long n)

Removes the nth UnitDefinition object from this Model object and
returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'n' is the index of the UnitDefinition object to remove.

Returns the UnitDefinition object removed., or 'None' if the given
index is out of range.

______________________________________________________________________
Method variant with the following signature:

    removeUnitDefinition(string sid)

Removes the UnitDefinition object with the given identifier from this
Model object and returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'sid' is the identifier of the UnitDefinition object to
remove.

Returns the UnitDefinition object removed, or 'None' if no
UnitDefinition object with the identifier exists in this Model object.
";


%feature("docstring") Model::removeCompartmentType "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    removeCompartmentType(long n)

Removes the nth CompartmentType object from this Model object and
returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'n' is the index of the CompartmentType object to remove.

Returns the ComapartmentType object removed, or 'None' if the given
index is out of range.

______________________________________________________________________
Method variant with the following signature:

    removeCompartmentType(string sid)

Removes the CompartmentType object with the given identifier from this
Model object and returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'sid' is the identifier of the object to remove.

Returns the CompartmentType object removed, or 'None' if no
CompartmentType object with the identifier exists in this Model
object.
";


%feature("docstring") Model::removeSpeciesType "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    removeSpeciesType(long n)

Removes the nth SpeciesType object from this Model object and returns
a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'n' is the index of the SpeciesType object to remove.

Returns the SpeciesType object removed, or 'None' if the given index
is out of range.

______________________________________________________________________
Method variant with the following signature:

    removeSpeciesType(string sid)

Removes the SpeciesType object with the given identifier from this
Model object and returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'sid' is the identifier of the SpeciesType object to remove.

Returns the SpeciesType object removed, or 'None' if no SpeciesType
object with the identifier exists in this Model object.
";


%feature("docstring") Model::removeCompartment "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    removeCompartment(long n)

Removes the nth Compartment object from this Model object and returns
a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'n' is the index of the Compartment object to remove.

Returns the Compartment object removed, or 'None' if the given index
is out of range.

______________________________________________________________________
Method variant with the following signature:

    removeCompartment(string sid)

Removes the Compartment object with the given identifier from this
Model object and returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'sid' is the identifier of the Compartment object to remove.

Returns the Compartment object removed, or 'None' if no Compartment
object with the identifier exists in this Model object.
";


%feature("docstring") Model::removeSpecies "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    removeSpecies(long n)

Removes the nth Species object from this Model object and returns a
pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'n' is the index of the Species object to remove.

Returns the Species object removed, or 'None' if the given index is
out of range.

______________________________________________________________________
Method variant with the following signature:

    removeSpecies(string sid)

Removes the Species object with the given identifier from this Model
object and returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'sid' is the identifier of the Species object to remove.

Returns the Species object removed, or 'None' if no Species object
with the identifier exists in this Model object.
";


%feature("docstring") Model::removeParameter "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    removeParameter(long n)

Removes the nth Parameter object from this Model object and returns a
pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'n' is the index of the Parameter object to remove.

Returns the Parameter object removed, or 'None' if the given index is
out of range.

______________________________________________________________________
Method variant with the following signature:

    removeParameter(string sid)

Removes the Parameter object with the given identifier from this Model
object and returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'sid' is the identifier of the Parameter object to remove.

Returns the Parameter object removed, or 'None' if no Parameter object
with the identifier exists in this Model object.
";


%feature("docstring") Model::removeInitialAssignment "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    removeInitialAssignment(string symbol)

Removes the InitialAssignment object with the given 'symbol' attribute
from this Model object and returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'symbol' is the 'symbol' attribute of the InitialAssignment
object to remove.

Returns the InitialAssignment object removed, or 'None' if no
InitialAssignment object with the 'symbol' attribute exists in this
Model object.

______________________________________________________________________
Method variant with the following signature:

    removeInitialAssignment(long n)

Removes the nth InitialAssignment object from this Model object and
returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'n' is the index of the InitialAssignment object to remove.

Returns the InitialAssignment object removed, or 'None' if the given
index is out of range.
";


%feature("docstring") Model::removeRule "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    removeRule(string variable)

Removes the Rule object with the given 'variable' attribute from this
Model  object and returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'variable' is the 'variable' attribute of the Rule object to
remove.

Returns the Rule object removed, or 'None' if no Rule object with the
'variable' attribute exists in this Model object.

______________________________________________________________________
Method variant with the following signature:

    removeRule(long n)

Removes the nth Rule object from this Model object and returns a
pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'n' is the index of the Rule object to remove.

Returns the Rule object removed, or 'None' if the given index is out
of range.
";


%feature("docstring") Model::removeRuleByVariable "
Removes the Rule object with the given 'variable' attribute from this
Model  object and returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'variable' is the 'variable' attribute of the Rule object to
remove.

Returns the Rule object removed, or 'None' if no Rule object with the
'variable' attribute exists in this Model object.
";


%feature("docstring") Model::removeConstraint "
Removes the nth Constraint object from this Model object and returns a
pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'n' is the index of the Constraint object to remove.

Returns the Constraint object removed, or 'None' if the given index is
out of range.
";


%feature("docstring") Model::removeReaction "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    removeReaction(long n)

Removes the nth Reaction object from this Model object and returns a
pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'n' is the index of the Reaction object to remove.

Returns the Reaction object removed, or 'None' if the given index is
out of range.

______________________________________________________________________
Method variant with the following signature:

    removeReaction(string sid)

Removes the Reaction object with the given identifier from this Model
object and returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'sid' is the identifier of the Reaction object to remove.

Returns the Reaction object removed, or 'None' if no Reaction object
with the identifier exists in this Model object.
";


%feature("docstring") Model::removeEvent "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    removeEvent(long n)

Removes the nth Event object from this Model object and returns a
pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'n' is the index of the Event object to remove.

Returns the Event object removed, or 'None' if the given index is out
of range.

______________________________________________________________________
Method variant with the following signature:

    removeEvent(string sid)

Removes the Event object with the given identifier from this Model
object and returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'sid' is the identifier of the Event object to remove.

Returns the Event object removed, or 'None' if no Event object with
the identifier exists in this Model object.
";


%feature("docstring") Model::appendFrom "
Copies a given Model object's subcomponents and appends the copies to
the appropriate places in this Model.

This method also calls the appendFrom method on all libSBML plug-in
objects.

SBML Level 3 consists of a Core definition that can be extended via
optional SBML Level 3 packages.  A given model may indicate that it
uses one or more SBML packages, and likewise, a software tool may be
able to support one or more packages.  LibSBML does not come
preconfigured with all possible packages included and enabled, in part
because not all package specifications have been finalized.  To
support the ability for software systems to enable support for the
Level 3 packages they choose, libSBML features a plug-in mechanism.
Each SBML Level 3 package is implemented in a separate code plug-in
that can be enabled by the application to support working with that
SBML package.  A given SBML model may thus contain not only objects
defined by SBML Level 3 Core, but also objects created by libSBML
plug-ins supporting additional Level 3 packages.

Parameter 'model' is the Model to merge with this one.
";


%feature("docstring") Model::enablePackageInternal "
Internal implementation method.
";


%feature("docstring") Model::readOtherXML "
Internal implementation method.
";


%feature("docstring") Model::createObject "
Internal implementation method.
";


%feature("docstring") Model::addExpectedAttributes "
Internal implementation method.
";


%feature("docstring") Model::readAttributes "
Internal implementation method.
";


%feature("docstring") Model::readL1Attributes "
Internal implementation method.
";


%feature("docstring") Model::readL2Attributes "
Internal implementation method.
";


%feature("docstring") Model::readL3Attributes "
Internal implementation method.
";


%feature("docstring") Model::writeAttributes "
Internal implementation method.
";


%feature("docstring") Model::syncAnnotation "
Internal implementation method.
";


%feature("docstring") Model::populatePerTimeUnitDefinition "
Internal implementation method.
";


%feature("docstring") Model::createSpeciesReferenceUnitsData "
Internal implementation method.
";


%feature("docstring") Model::removeListFormulaUnitsData "
Internal implementation method.
";


%feature("docstring") Model::createSubstanceUnitsData "
Internal implementation method.
";


%feature("docstring") Model::getL3SubstanceUD "
Internal implementation method.
";


%feature("docstring") Model::getSubstanceUD "
Internal implementation method.
";


%feature("docstring") Model::createTimeUnitsData "
Internal implementation method.
";


%feature("docstring") Model::getL3TimeUD "
Internal implementation method.
";


%feature("docstring") Model::getTimeUD "
Internal implementation method.
";


%feature("docstring") Model::createVolumeUnitsData "
Internal implementation method.
";


%feature("docstring") Model::getL3VolumeUD "
Internal implementation method.
";


%feature("docstring") Model::getVolumeUD "
Internal implementation method.
";


%feature("docstring") Model::createAreaUnitsData "
Internal implementation method.
";


%feature("docstring") Model::getL3AreaUD "
Internal implementation method.
";


%feature("docstring") Model::getAreaUD "
Internal implementation method.
";


%feature("docstring") Model::createLengthUnitsData "
Internal implementation method.
";


%feature("docstring") Model::getL3LengthUD "
Internal implementation method.
";


%feature("docstring") Model::getLengthUD "
Internal implementation method.
";


%feature("docstring") Model::createExtentUnitsData "
Internal implementation method.
";


%feature("docstring") Model::getL3ExtentUD "
Internal implementation method.
";


%feature("docstring") Model::createSubstancePerTimeUnitsData "
Internal implementation method.
";


%feature("docstring") Model::getL3SubstancePerTimeUD "
Internal implementation method.
";


%feature("docstring") Model::getSubstancePerTimeUD "
Internal implementation method.
";


%feature("docstring") Model::createCompartmentUnitsData "
Internal implementation method.
";


%feature("docstring") Model::createSpeciesUnitsData "
Internal implementation method.
";


%feature("docstring") Model::createL3SpeciesUnitsData "
Internal implementation method.
";


%feature("docstring") Model::createParameterUnitsData "
Internal implementation method.
";


%feature("docstring") Model::createUnitsDataFromMath "
Internal implementation method.
";


%feature("docstring") Model::createInitialAssignmentUnitsData "
Internal implementation method.
";


%feature("docstring") Model::createConstraintUnitsData "
Internal implementation method.
";


%feature("docstring") Model::createRuleUnitsData "
Internal implementation method.
";


%feature("docstring") Model::createReactionUnitsData "
Internal implementation method.
";


%feature("docstring") Model::createEventUnitsData "
Internal implementation method.
";


%feature("docstring") Model::createDelayUnitsData "
Internal implementation method.
";


%feature("docstring") Model::createTriggerUnitsData "
Internal implementation method.
";


%feature("docstring") Model::createPriorityUnitsData "
Internal implementation method.
";


%feature("docstring") Model::createEventAssignmentUnitsData "
Internal implementation method.
";


%feature("docstring") Model::createLocalParameterUnitsData "
Internal implementation method.
";


%feature("docstring") SBMLDocument "
Overall SBML container object.

LibSBML uses the class SBMLDocument as a top-level container for
storing SBML content and data associated with it (such as warnings and
error messages).  The two primary means of reading an SBML model,
SBMLReader.readSBML() and SBMLReader.readSBMLFromString(), both return
a pointer to an SBMLDocument object.  From there, callers can inquire
about any errors encountered (e.g., using
SBMLDocument.getNumErrors()), access the Model object, and perform
other actions such as consistency-checking and model translation.

When creating fresh models programmatically, the starting point is
typically the creation of an SBMLDocument object instance.  The
SBMLDocument constructor accepts arguments for the SBML Level and
Version of the model to be created.  After creating the SBMLDocument
object, calling programs then typically call
SBMLDocument.createModel() almost immediately, and then proceed to
call the methods on the Model object to fill out the model's contents.

SBMLDocument corresponds roughly to the class Sbml defined in the SBML
Level 2 specification and SBML in the Level 3 specification.  It does
not have a direct correspondence in SBML Level 1.  (However, to make
matters simpler for applications, libSBML creates an SBMLDocument no
matter whether the model is Level 1, Level 2 or Level 3.)  In its
barest form, when written out in XML format for (e.g.) SBML Level 2
Version 4, the corresponding structure is the following:

  <sbml xmlns=\'http://www.sbml.org/sbml/level2/version4\' level=\'2\' version=\'4\'>
    ...
  </sbml>

SBMLDocument is derived from SBase, and therefore contains the usual
SBase attributes (in SBML Level 2 and Level 3) of 'metaid' and
'sboTerm', as well as the subelements 'notes' and 'annotation'.  It
also contains the attributes 'level' and 'version' indicating the
Level and Version of the SBML data structure.  These can be accessed
using the methods defined by the SBase class for that purpose.

Checking consistency and adherence to SBML specifications
======================================================================

One of the most important features of libSBML is its ability to
perform SBML validation to ensure that a model adheres to the SBML
specification for whatever Level+Version combination the model uses.
SBMLDocument provides the methods for running consistency-checking and
validation rules on the SBML content.

First, a brief explanation of the rationale is in order.  In libSBML
versions up to and including the version 3.3.x series, the individual
methods for creating and setting attributes and other components were
quite lenient, and allowed a caller to compose SBML entities that
might not, in the end, represent valid SBML.  This allowed
applications the freedom to do things such as save incomplete models
(which is useful when models are being developed over long periods of
time).  In the version 4.x series, libSBML is somewhat stricter, but
still permits structures to be created independently and the results
to be combined in a separate step.  In all these cases, it means that
a separate validation step is necessary when a calling program finally
wants to finish a complete SBML document.

The primary interface to this validation facility is SBMLDocument's
SBMLDocument.checkInternalConsistency() and
SBMLDocument.checkConsistency().  The former verifies the basic
internal consistency and syntax of an SBML document, and the latter
implements more elaborate validation rules (both those defined by the
SBML specifications, as well as additional rules offered by libSBML).

The checks performed by SBMLDocument.checkInternalConsistency() are
hardwired and cannot be changed by calling programs, but the
validation performed by SBMLDocument.checkConsistency() is under
program control using the method SBMLDocument.setConsistencyChecks().
Applications can selectively disable specific kinds of checks that
they may not be interested in, by calling
SBMLDocument.setConsistencyChecks() with appropriate parameters.

These methods have slightly different relevance depending on whether
a model is created programmaticaly from scratch, or whether it is read
in from a file or data stream.  The following list summarizes the
possible scenarios.

Scenario 1: Creating a model from scratch.  Before writing out the
model,

* Call SBMLDocument.checkInternalConsistency(), then inquire about
the results by calling SBMLDocument.getNumErrors()

* Call SBMLDocument.setConsistencyChecks()  to configure which
checks will be performed by SBMLDocument.checkConsistency()

* Call SBMLDocument.checkConsistency(), then inquire about the
results by calling SBMLDocument.getNumErrors()

Scenario 2: Reading a model from a file or data stream. After reading
the model,

* Basic consistency checks will have been performed automatically
by libSBML upon reading the content, so you only need to inquire about
the results by using SBMLDocument.getNumErrors()

* Call SBMLDocument.setConsistencyChecks()  to configure which
checks are performed by SBMLDocument.checkConsistency()

* Call SBMLDocument.checkConsistency(), then inquire about the
results by calling SBMLDocument.getNumErrors()

It should be noted that as of SBML Level 3 Version 2, the Model
became an optional child of SBMLDocument, instead of being required.
This means that one can no longer use SBMLDocument.getModel() as a
cheap method of checking if an SBML document was read in properly: the
more robust getError methods detailed above must be used instead.

Converting documents between Levels and Versions of SBML
======================================================================

LibSBML provides facilities for limited translation of SBML between
Levels and Versions of the SBML specifications.  The method for doing
is is setLevelAndVersion() .  In  general, models can be converted
upward without difficulty (e.g., from SBML Level 1 to Level 2, or from
an earlier Version of Level 2 to the latest Version of Level 2).
Sometimes models can be translated downward as well, if they do not
use constructs specific to more advanced Levels of SBML.

Calling SBMLDocument.setLevelAndVersion()  will not necessarily lead
to a successful conversion.  The method will return a boolean value to
indicate success or failure.  Callers must check the error log (see
next section) attached to the SBMLDocument object after calling
SBMLDocument.setLevelAndVersion()  in order to assess whether any
problems arose.

If an application is interested in translating to a lower Level and/or
Version of SBML within a Level, the following methods allow for prior
assessment of whether there is sufficient compatibility to make a
translation possible:

* SBMLDocument.checkL1Compatibility(),

* SBMLDocument.checkL2v1Compatibility(),

* SBMLDocument.checkL2v2Compatibility(),

* SBMLDocument.checkL2v3Compatibility(),

* SBMLDocument.checkL2v4Compatibility(),

* SBMLDocument.checkL2v5Compatibility(), and

* SBMLDocument.checkL3v1Compatibility().

Some changes between Versions of SBML Level 2 may lead to unexpected
behaviors when attempting conversions in either direction. For
example, SBML Level 2 Version 4 relaxed the requirement for
consistency in units of measurement between expressions annd
quantities in a model.  As a result, a model written in Version 4, if
converted to Version 3 with no other changes, may fail validation as a
Version 3 model because Version 3 imposed stricter requirements on
unit consistency.

Other changes between SBML Level 2 and Level 3 make downward
conversions challenging.  In some cases, it means that a model
converted to Level 2 from Level 3 will contain attributes that were
not explicitly given in the Level 3 model, because in Level 2 these
attributes may have been optional or have default values.

Error handling
======================================================================

Upon reading a model, SBMLDocument logs any problems encountered while
reading the model from the file or data stream.  The log contains
objects that record diagnostic information about any notable issues
that arose.  Whether the problems are warnings or errors, they are
both reported through a single common interface involving the object
class SBMLError.

The methods SBMLDocument.getNumErrors(), SBMLDocument.getError()  and
SBMLDocument.printErrors() allow callers to interact with the warnings
or errors logged.  Alternatively, callers may retrieve the entire log
as an SBMLErrorLog object using the method SBMLDocument.getErrorLog().
The SBMLErrorLog object provides some alternative methods for
interacting with the set of errors and warnings.  In either case,
applications typically should first call SBMLDocument.getNumErrors()
to find out if any issues have been logged after specific libSBML
operations such as the ones discussed in the sections above.  If they
have, then an application will should proceed to inspect the
individual reports using either the direct interfaces on SBMLDocument
or using the methods on the SBMLErrorLog object.
";


%feature("docstring") SBMLDocument::getDefaultLevel "
The default SBML Level of new SBMLDocument objects.

This 'default Level' corresponds to the most recent SBML
specification Level available at the time libSBML version 5.16.0 was
released.  The default Level is used by SBMLDocument if no Level is
explicitly specified at the time of the construction of an
SBMLDocument instance.

Returns an integer indicating the most recent SBML specification
Level.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.

See also SBMLDocument.getDefaultVersion() .
";


%feature("docstring") SBMLDocument::getDefaultVersion "
The default Version of new SBMLDocument objects.

This 'default Version' corresponds to the most recent Version within
the most recent Level of SBML available at the time libSBML version
5.16.0 was released.  The default Version is used by SBMLDocument if
no Version is explicitly specified at the time of the construction of
an SBMLDocument instance.

Returns an integer indicating the most recent SBML specification
Version.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.

See also SBMLDocument.getDefaultLevel() .
";


%feature("docstring") SBMLDocument::SBMLDocument "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    SBMLDocument(SBMLNamespaces sbmlns)

Creates a new SBMLDocument using the given SBMLNamespaces object
'sbmlns'.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

Parameter 'sbmlns' is an SBMLNamespaces object.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

______________________________________________________________________
Method variant with the following signature:

    SBMLDocument(long level = 0, long version = 0)

Creates a new SBMLDocument, optionally with given values for the SBML
Level and Version.

If both the SBML Level and Version attributes are not specified, the
SBML document is treated as having the latest Level and Version of
SBML as determined by SBMLDocument.getDefaultLevel() and
SBMLDocument.getDefaultVersion(); however, the SBMLDocument object is
otherwise left blank.  In particular, the blank SBMLDocument object
has no associated XML attributes, including (but not limited to) an
XML namespace declaration.  The XML namespace declaration is not added
until the model is written out, or the method
SBMLDocument.setLevelAndVersion() is called.  This may be important to
keep in mind if an application needs to add additional XML namespace
declarations on the <sbml> element.  Application writers should either
provide values for 'level' and 'version' on the call to this
constructor, or else call SBMLDocument.setLevelAndVersion() shortly
after creating the SBMLDocument object.

Parameter 'level' is an integer for the SBML Level.

Parameter 'version' is an integer for the Version within the SBML
Level.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

</dl><dl class=\"docnote\"><dt>Documentation note:</dt><dd> The native
C++ implementation of this method defines a default argument value. In
the documentation generated for different libSBML language bindings,
you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is
handled by declaring two separate methods, with one of them having the
argument and the other one lacking the argument. However, the libSBML
documentation will be identical for both methods. Consequently, if you
are reading this and do not see an argument even though one is
described, please look for descriptions of other variants of this
method near where this one appears in the documentation. </dd></dl>

See also SBMLDocument.setLevelAndVersion(), getDefaultLevel(),
getDefaultVersion().

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.

______________________________________________________________________
Method variant with the following signature:

    SBMLDocument(SBMLDocument orig)

Copy constructor; creates a copy of this SBMLDocument.

Parameter 'orig' is the object to copy.
";


%feature("docstring") SBMLDocument::accept "
Internal implementation method.
";


%feature("docstring") SBMLDocument::clone "
Creates and returns a deep copy of this SBMLDocument object.

Returns the (deep) copy of this SBMLDocument object.
";


%feature("docstring") SBMLDocument::isSetModel "
Returns 'True' if the Model object has been set, otherwise  returns
'False.'

Returns 'True' if the Model object has been set
";


%feature("docstring") SBMLDocument::getModel "
Returns the Model object stored in this SBMLDocument.

It is important to note that this method does not create a Model
instance.  The model in the SBMLDocument must have been created at
some prior time, for example using SBMLDocument.createModel()  or
SBMLDocument.setModel(). This method returns 'None' if a model does
not yet exist.

Returns the Model contained in this SBMLDocument, or 'None' if no such
model exists.

See also createModel().
";


%feature("docstring") SBMLDocument::getElementBySId "
Returns the first child element found that has the given 'id' in the
model-wide SId namespace, or 'None' if no such object is found.

Parameter 'id' is string representing the id of the object to find.

Returns pointer to the first element found with the given 'id'.
";


%feature("docstring") SBMLDocument::getElementByMetaId "
Returns the first child element it can find with the given 'metaid',
or itself if it has the given 'metaid', or 'None' if no such object is
found.

Parameter 'metaid' is string representing the metaid of the object to
find.

Returns pointer to the first element found with the given 'metaid'.
";


%feature("docstring") SBMLDocument::getAllElements "
Returns a List of all child SBase objects, including those nested to
an arbitrary depth

Parameter 'filter' is a pointer to an ElementFilter, which causes the
function  to return only elements that match a particular set of
constraints.   If None (the default), the function will return all
child objects.

Returns a List of pointers to all children objects.
";


%feature("docstring") SBMLDocument::expandFunctionDefinitions "
Removes FunctionDefinition constructs from the document and expands
any instances of their use within <math> elements.

For example, suppose a Model contains a FunctionDefinition with
identifier ''f'' representing the math expression: f(x, y) = x * y.
Suppose further that there is a reaction in which the <math> element
of the KineticLaw object contains f(s, p), where 's' and 'p' are other
identifiers defined in the model.  The outcome of invoking this method
is that the <math> of the KineticLaw now represents the expression s *
p and the model no longer contains any FunctionDefinition objects.

Returns bool 'True' if the transformation was successful,  'False,'
otherwise.

Note: This function will check the consistency of a model before
attemptimg the transformation.  If the model is not valid SBML, the
transformation will not be performed and the function will return
'False.'
";


%feature("docstring") SBMLDocument::expandInitialAssignments "
Removes InitialAssignment constructs from the document and replaces
them with appropriate values.

For example, suppose a Model contains a InitialAssignment to a symbol
''k'' where ''k'' is the identifier of a Parameter.  The outcome of
invoking this method is that the 'value' attribute of the Parameter
definition is set to the result calculated using the InitialAssignment
object's <math> formula, and the corresponding InitialAssignment is
then removed from the Model.

Returns bool 'True' if the transformation was successful,  'False,'
otherwise.

Note: This function will check the consistency of a model before
attemptimg the transformation.  If the model is not valid SBML, the
transformation will not be performed and the function will return
'False.'  As part of that process, this method will check that it has
values for any components referred to by the <math> elements of
InitialAssignment objects.  In cases where not all of the values have
been declared (e.g., if the mathematical expression refers to model
entities that have no declared values), the InitialAssignment in
question will not be removed and this method will return 'False.'
";


%feature("docstring") SBMLDocument::setLevelAndVersion "
Sets the SBML Level and Version of this SBMLDocument instance,
attempting to convert the model as needed.

This method is the principal way in libSBML to convert models between
Levels and Versions of SBML.  Generally, models can be converted
upward without difficulty (e.g., from SBML Level 1 to Level 2, or from
an earlier Version of Level 2 to the latest Version of Level 2).
Sometimes models can be translated downward as well, if they do not
use constructs specific to more advanced Levels of SBML.

Before calling this method, callers may check compatibility directly
using the methods SBMLDocument.checkL1Compatibility(),
SBMLDocument.checkL2v1Compatibility(),
SBMLDocument.checkL2v2Compatibility(),
SBMLDocument.checkL2v3Compatibility(),
SBMLDocument.checkL2v4Compatibility(),
SBMLDocument.checkL2v5Compatibility(),
SBMLDocument.checkL3v1Compatibility(), and
SBMLDocument.checkL3v2Compatibility().

The valid combinations of SBML Level and Version as of this release of
libSBML are the following:

* Level 1 Version 2

* Level 2 Version 1

* Level 2 Version 2

* Level 2 Version 3

* Level 2 Version 4

* Level 2 Version 5

* Level 3 Version 1

* Level 3 Version 2 Strict conversion applies the additional
criteria that both the source and the target model must be consistent
SBML.  Users can control the consistency checks that are applied using
the SBMLDocument.setConsistencyChecksForConversion() method.  If
either the source or the potential target model have validation
errors, the conversion is not performed.  When a strict conversion is
successful, the underlying SBML object model is altered to reflect the
new level and version.  Thus, information that cannot be converted
(e.g. sboTerms) will be lost.

Parameter 'level' is the desired SBML Level.

Parameter 'version' is the desired Version within the SBML Level.

Parameter 'strict' is boolean indicating whether to check consistency
of both the source and target model when performing conversion
(defaults to  true ).

Parameter 'ignorePackages' is boolean indicating whether the presence
of packages should be ignored by the conversion routine  (defaults to
false ).

Returns 'True' if the level and version of the document were
successfully set to the requested values (which may have required
conversion of the model), 'False' otherwise.

Note: Calling this method will not necessarily lead to a successful
conversion.  If the conversion fails, it will be logged in the error
list associated with this SBMLDocument.  Callers should consult
getNumErrors() to find out if the conversion succeeded without
problems.  For conversions from Level 2 to Level 1, callers can also
check the Level of the model after calling this method to find out
whether it is Level 1.  (If the conversion to Level 1 failed, the
Level of this model will be left unchanged.)

</dl><dl class=\"docnote\"><dt>Documentation note:</dt><dd> The native
C++ implementation of this method defines a default argument value. In
the documentation generated for different libSBML language bindings,
you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is
handled by declaring two separate methods, with one of them having the
argument and the other one lacking the argument. However, the libSBML
documentation will be identical for both methods. Consequently, if you
are reading this and do not see an argument even though one is
described, please look for descriptions of other variants of this
method near where this one appears in the documentation. </dd></dl>

See also checkL1Compatibility(), checkL2v1Compatibility(),
checkL2v2Compatibility(), checkL2v3Compatibility(),
checkL2v4Compatibility(), checkL2v5Compatibility(),
checkL3v1Compatibility().

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") SBMLDocument::updateSBMLNamespace "
Internal implementation method.
";


%feature("docstring") SBMLDocument::setModel "
Sets the Model for this SBMLDocument to a copy of the given Model.

Parameter 'm' is the new Model to use.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_LEVEL_MISMATCH

* LIBSBML_VERSION_MISMATCH

See also createModel(), getModel().
";


%feature("docstring") SBMLDocument::createModel "
Creates a new Model inside this SBMLDocument, and returns a pointer to
it.

In SBML Level 2, the use of an identifier on a Model object is
optional.  This method takes an optional argument, 'sid', for setting
the identifier.  If not supplied, the identifier attribute on the
Model instance is not set.

Parameter 'sid' is the identifier of the new Model to create.

</dl><dl class=\"docnote\"><dt>Documentation note:</dt><dd> The native
C++ implementation of this method defines a default argument value. In
the documentation generated for different libSBML language bindings,
you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is
handled by declaring two separate methods, with one of them having the
argument and the other one lacking the argument. However, the libSBML
documentation will be identical for both methods. Consequently, if you
are reading this and do not see an argument even though one is
described, please look for descriptions of other variants of this
method near where this one appears in the documentation. </dd></dl>

See also getModel(), SBMLDocument.setModel().

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") SBMLDocument::setLocationURI "
Sets the location of this SBMLDocument.

Called automatically when readSBMLFromFile is used, but may be set
manually as well.
";


%feature("docstring") SBMLDocument::getLocationURI "
Get the location of this SBMLDocument.

If this document was read from a file or had its location set
manually, that filename or set location will be returned, otherwise,
an empty string is returned.
";


%feature("docstring") SBMLDocument::setConsistencyChecks "
Controls the consistency checks that are performed when
SBMLDocument.checkConsistency() is called.

This method works by adding or subtracting consistency checks from the
set of all possible checks that SBMLDocument.checkConsistency() knows
how to perform.  This method may need to be called multiple times in
order to achieve the desired combination of checks.  The first
argument ('category') in a call to this method indicates the category
of consistency/error checks that are to be turned on or off, and the
second argument ('apply', a boolean) indicates whether to turn it on
(value of 'True)' or off (value of 'False).'

The possible categories (values to the argument 'category') are the
set of constants whose names begin with the characters LIBSBML_CAT_ in
the interface class libsbml. The following are the possible choices:

* LIBSBML_CAT_GENERAL_CONSISTENCY: Correctness and consistency of
specific SBML language constructs. Performing this set of checks is
highly recommended.  With respect to the SBML specification, these
concern failures in applying the validation rules numbered 2xxxx in
the Level 2 Versions 2-4 and Level 3 Versions 1-2 specifications.

* LIBSBML_CAT_IDENTIFIER_CONSISTENCY: Correctness and consistency of
identifiers used for model entities.  An example of inconsistency
would be using a species identifier in a reaction rate formula without
first having declared the species.  With respect to the SBML
specification, these concern failures in applying the validation rules
numbered 103xx in the Level 2 Versions 2-4 and Level 3 Versions 1-2
specifications.

* LIBSBML_CAT_UNITS_CONSISTENCY: Consistency of measurement units
associated with quantities in a model. With respect to the SBML
specification, these concern failures in applying the validation rules
numbered 105xx in the Level 2 Versions 2-4 and Level 3 Versions 1-2
specifications.

* LIBSBML_CAT_MATHML_CONSISTENCY: Syntax of MathML constructs.  With
respect to the SBML specification, these concern failures in applying
the validation rules numbered 102xx in the Level 2 Versions 2-4 and
Level 3 Versions 1-2 specifications.

* LIBSBML_CAT_SBO_CONSISTENCY: Consistency and validity of SBO
identifiers (if any) used in the model. With respect to the SBML
specification, these concern failures in applying the validation rules
numbered 107xx in the Level 2 Versions 2-4 and Level 3 Versions 1-2
specifications.

* LIBSBML_CAT_OVERDETERMINED_MODEL: Static analysis of whether the
system of equations implied by a model is mathematically
overdetermined.  With respect to the SBML specification, this is
validation rule #10601 in the Level 2 Versions 2-4 and Level 3
Versions 1-2 specifications.

* LIBSBML_CAT_MODELING_PRACTICE: Additional checks for recommended
good modeling practice. (These are tests performed by libSBML and do
not have equivalent SBML validation rules.)  By default, all
validation checks are applied to the model in an SBMLDocument object
unless SBMLDocument.setConsistencyChecks() is called to indicate that
only a subset should be applied.  Further, this default (i.e.,
performing all checks) applies separately to each new SBMLDocument
object created.  In other words, each time a model is read using
SBMLReader.readSBML(), SBMLReader.readSBMLFromString(), or the global
functions readSBML() and readSBMLFromString(), a new SBMLDocument is
created and for that document, a call to
SBMLDocument.checkConsistency() will default to applying all possible
checks. Calling programs must invoke
SBMLDocument.setConsistencyChecks() for each such new model if they
wish to change the consistency checks applied.

Parameter 'category' is a value drawn from the set of SBML error
categories indicating the consistency checking/validation to be turned
on or off.

Parameter 'apply' is a boolean indicating whether the checks indicated
by 'category' should be applied or not.

See also SBMLDocument.checkConsistency().
";


%feature("docstring") SBMLDocument::setConsistencyChecksForConversion "
Controls the consistency checks that are performed when
SBMLDocument.setLevelAndVersion() is called.

This method works by adding or subtracting consistency checks from the
set of all possible checks that may be performed to avoid conversion
to or from an invalid document.  This method may need to be called
multiple times in order to achieve the desired combination of checks.
The first argument ('category') in a call to this method indicates the
category of consistency/error checks that are to be turned on or off,
and the second argument ('apply', a boolean) indicates whether to turn
it on (value of 'True)' or off (value of 'False).'

The possible categories (values to the argument 'category') are the
set of constants whose names begin with the characters LIBSBML_CAT_ in
the interface class libsbml. The following are the possible choices:

* LIBSBML_CAT_GENERAL_CONSISTENCY: Correctness and consistency of
specific SBML language constructs. Performing this set of checks is
highly recommended.  With respect to the SBML specification, these
concern failures in applying the validation rules numbered 2xxxx in
the Level 2 Versions 2-4 and Level 3 Versions 1-2 specifications.

* LIBSBML_CAT_IDENTIFIER_CONSISTENCY: Correctness and consistency of
identifiers used for model entities.  An example of inconsistency
would be using a species identifier in a reaction rate formula without
first having declared the species.  With respect to the SBML
specification, these concern failures in applying the validation rules
numbered 103xx in the Level 2 Versions 2-4 and Level 3 Versions 1-2
specifications.

* LIBSBML_CAT_UNITS_CONSISTENCY: Consistency of measurement units
associated with quantities in a model. With respect to the SBML
specification, these concern failures in applying the validation rules
numbered 105xx in the Level 2 Versions 2-4 and Level 3 Versions 1-2
specifications.

* LIBSBML_CAT_MATHML_CONSISTENCY: Syntax of MathML constructs.  With
respect to the SBML specification, these concern failures in applying
the validation rules numbered 102xx in the Level 2 Versions 2-4 and
Level 3 Versions 1-2 specifications.

* LIBSBML_CAT_SBO_CONSISTENCY: Consistency and validity of SBO
identifiers (if any) used in the model. With respect to the SBML
specification, these concern failures in applying the validation rules
numbered 107xx in the Level 2 Versions 2-4 and Level 3 Versions 1-2
specifications.

* LIBSBML_CAT_OVERDETERMINED_MODEL: Static analysis of whether the
system of equations implied by a model is mathematically
overdetermined.  With respect to the SBML specification, this is
validation rule #10601 in the Level 2 Versions 2-4 and Level 3
Versions 1-2 specifications.

* LIBSBML_CAT_MODELING_PRACTICE: Additional checks for recommended
good modeling practice. (These are tests performed by libSBML and do
not have equivalent SBML validation rules.) By default, all validation
checks are applied to the model in an SBMLDocument object unless
SBMLDocument.setConsistencyChecks() is called to indicate that only a
subset should be applied.  Further, this default (i.e., performing all
checks) applies separately to each new SBMLDocument object created.
In other words, each time a model is read using SBMLReader.readSBML(),
SBMLReader.readSBMLFromString(), or the global functions readSBML()
and readSBMLFromString(), a new SBMLDocument is created and for that
document, a call to SBMLDocument.checkConsistency() will default to
applying all possible checks. Calling programs must invoke
SBMLDocument.setConsistencyChecks() for each such new model if they
wish to change the consistency checks applied.

Parameter 'category' is a value drawn from the set of SBML error
categories indicating the consistency checking/validation to be turned
on or off.

Parameter 'apply' is a boolean indicating whether the checks indicated
by 'category' should be applied or not.

See also SBMLDocument.setLevelAndVersion().
";


%feature("docstring") SBMLDocument::checkConsistency "
Performs consistency checking and validation on this SBML document.

If this method returns a nonzero value (meaning, one or more
consistency checks have failed for SBML document), the failures may be
due to warnings or errors.  Callers should inspect the severity flag
in the individual SBMLError objects returned by
SBMLDocument.getError() to determine the nature of the failures.

Returns the number of failed checks (errors) encountered.

See also SBMLDocument.checkInternalConsistency().
";


%feature("docstring") SBMLDocument::checkConsistencyWithStrictUnits "
Performs consistency checking and validation on this SBML document
using the ultra strict units validator that assumes that there are no
hidden numerical conversion factors.

If this method returns a nonzero value (meaning, one or more
consistency checks have failed for SBML document), the failures may be
due to warnings or errors.  Callers should inspect the severity flag
in the individual SBMLError objects returned by
SBMLDocument.getError() to determine the nature of the failures.

Returns the number of failed checks (errors) encountered.

See also SBMLDocument.checkInternalConsistency().
";


%feature("docstring") SBMLDocument::validateSBML "
Performs consistency checking and validation on this SBML document.

If this method returns a nonzero value (meaning, one or more
consistency checks have failed for SBML document), the failures may be
due to warnings or errors.  Callers should inspect the severity flag
in the individual SBMLError objects returned by
SBMLDocument.getError() to determine the nature of the failures.

Note: unlike checkConsistency this method will write the document in
order to determine all errors for the document. This will  also clear
the error log.

Returns the number of failed checks (errors) encountered.

See also SBMLDocument.checkConsistency().
";


%feature("docstring") SBMLDocument::checkInternalConsistency "
Performs consistency checking on libSBML's internal representation of
an SBML Model.

Callers should query the results of the consistency check by calling
SBMLDocument.getError().

Returns the number of failed checks (errors) encountered.

The distinction between this method and
SBMLDocument.checkConsistency() is that this method reports on
fundamental syntactic and structural errors that violate the XML
Schema for SBML; by contrast, SBMLDocument.checkConsistency() performs
more elaborate model verifications and also validation according to
the validation rules written in the appendices of the SBML Level 2
Versions 2-4 specification documents.

See also SBMLDocument.checkConsistency().
";


%feature("docstring") SBMLDocument::checkL1Compatibility "
Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level 1 and can be converted to
Level 1.

Callers should query the results of the consistency check by calling
SBMLDocument.getError().

Returns the number of failed checks (errors) encountered.

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") SBMLDocument::checkL2v1Compatibility "
Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level 2 Version 1 and can be
converted to Level 2 Version 1.

Callers should query the results of the consistency check by calling
SBMLDocument.getError().

Returns the number of failed checks (errors) encountered.

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") SBMLDocument::checkL2v2Compatibility "
Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level 2 Version 2 and can be
converted to Level 2 Version 2.

Callers should query the results of the consistency check by calling
SBMLDocument.getError().

Returns the number of failed checks (errors) encountered.

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") SBMLDocument::checkL2v3Compatibility "
Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level 2 Version 3 and can be
converted to Level 2 Version 3.

Callers should query the results of the consistency check by calling
SBMLDocument.getError().

Returns the number of failed checks (errors) encountered.

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") SBMLDocument::checkL2v4Compatibility "
Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level 2 Version 4 and can be
converted to Level 2 Version 4.

Callers should query the results of the consistency check by calling
SBMLDocument.getError().

Returns the number of failed checks (errors) encountered.
";


%feature("docstring") SBMLDocument::checkL2v5Compatibility "
Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level 2 Version 5 and can be
converted to Level 2 Version 5.

Callers should query the results of the consistency check by calling
SBMLDocument.getError().

Returns the number of failed checks (errors) encountered.
";


%feature("docstring") SBMLDocument::checkL3v1Compatibility "
Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level 3 Version 1 and can be
converted to Level 3 Version 1.

Callers should query the results of the consistency check by calling
SBMLDocument.getError().

Returns the number of failed checks (errors) encountered.
";


%feature("docstring") SBMLDocument::checkL3v2Compatibility "
Performs a set of consistency checks on the document to establish
whether it is compatible with SBML Level 3 Version 2 and can be
converted to Level 3 Version 2.

Callers should query the results of the consistency check by calling
SBMLDocument.getError().

Returns the number of failed checks (errors) encountered.
";


%feature("docstring") SBMLDocument::getError "
Returns the nth error or warning encountered during parsing,
consistency checking, or attempted translation of this model.

Callers can use method XMLError.getSeverity() on the result to assess
the severity of the problem.  The possible severity levels range from
informational messages to fatal errors.

Returns the error or warning indexed by integer 'n', or return 'None'
if n > (getNumErrors() - 1).

Parameter 'n' is the integer index of the error sought.

See also SBMLDocument.getNumErrors().
";


%feature("docstring") SBMLDocument::getErrorWithSeverity "
Returns the nth error or warning with the given severity encountered
during parsing, consistency checking, or attempted translation of this
model.

Returns the error or warning indexed by integer 'n', or return 'None'
if n > (getNumErrors(severity) - 1).

Parameter 'n' is the integer index of the error sought. Parameter
'severity' is the severity of the error sought.

See also SBMLDocument.getNumErrors().
";


%feature("docstring") SBMLDocument::getNumErrors "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    getNumErrors(long severity)

Returns the number of errors or warnings encountered with the given
severity during parsing, consistency checking, or attempted
translation of this model.

Parameter 'severity' is the severity of the error sought.

Returns the number of errors or warnings encountered.

See also SBMLDocument.getError().

______________________________________________________________________
Method variant with the following signature:

    getNumErrors()

Returns the number of errors or warnings encountered during parsing,
consistency checking, or attempted translation of this model.

Returns the number of errors or warnings encountered.

See also SBMLDocument.getError().
";


%feature("docstring") SBMLDocument::printErrors "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    printErrors(std::ostream stream, long severity)

Prints all the errors or warnings with the given severity encountered
trying to parse, check, or translate this SBML document.

It prints the text to the stream given by the parameter 'stream'.

If no errors have occurred, i.e., getNumErrors(severity) == 0, no
output will be sent to the stream.

The format of the output is:

      N error(s):
        line NNN: (id) message

Parameter 'stream' is the ostream or ostringstream object indicating
where the output should be printed. Parameter 'severity' is of the
errors sought.

See also getNumErrors(), getErrorLog(),
SBMLDocument.getErrorWithSeverity().

______________________________________________________________________
Method variant with the following signature:

    printErrors(std::ostream stream = std::cerr)

Prints all the errors or warnings encountered trying to parse, check,
or translate this SBML document.

It prints the text to the stream given by the optional parameter
'stream'.  If no parameter is given, it prints the output to the
standard error stream.

If no errors have occurred, i.e., getNumErrors() == 0, no output will
be sent to the stream.

The format of the output is:

     N error(s):
       line NNN: (id) message

Parameter 'stream' is the ostream or ostringstream object indicating
where the output should be printed.

</dl><dl class=\"docnote\"><dt>Documentation note:</dt><dd> The native
C++ implementation of this method defines a default argument value. In
the documentation generated for different libSBML language bindings,
you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is
handled by declaring two separate methods, with one of them having the
argument and the other one lacking the argument. However, the libSBML
documentation will be identical for both methods. Consequently, if you
are reading this and do not see an argument even though one is
described, please look for descriptions of other variants of this
method near where this one appears in the documentation. </dd></dl>

See also getNumErrors(), getErrorLog(), SBMLDocument.getError().

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") SBMLDocument::setSBMLDocument "
Internal implementation method.
";


%feature("docstring") SBMLDocument::convert "
Converts this document using the converter that best matches the given
conversion properties.

Parameter 'props' is the conversion properties to use.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

* LIBSBML_CONV_CONVERSION_NOT_AVAILABLE
";


%feature("docstring") SBMLDocument::enablePackageInternal "
Internal implementation method.
";


%feature("docstring") SBMLDocument::getTypeCode "
Returns the libSBML type code for this SBML object.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for this object: SBML_DOCUMENT (default).

WARNING:

The specific integer values of the possible type codes may be reused
by different libSBML plug-ins for SBML Level 3. packages,  To fully
identify the correct code, it is necessary to invoke both
getTypeCode() and getPackageName().

See also SBMLDocument.getElementName(), getPackageName().
";


%feature("docstring") SBMLDocument::getElementName "
Returns the XML element name of this object, which for SBMLDocument,
is always ''sbml'.'

Returns the name of this element, i.e., ''sbml'.'
";


%feature("docstring") SBMLDocument::getErrorLog "
Returns the list of errors or warnings logged during parsing,
consistency checking, or attempted translation of this model.

Returns the SBMLErrorLog used for this SBMLDocument.

See also SBMLDocument.getNumErrors().
";


%feature("docstring") SBMLDocument::getNamespaces "
Returns a list of XML Namespaces associated with the XML content of
this SBML document.

Returns the XML Namespaces associated with this SBML object.
";


%feature("docstring") SBMLDocument::enableDefaultNS "
Set/unset default namespace to each top-level element defined in the
given package extension.

This works by adding a xmlns=\"...\" attribute.  No prefix will be
written when writing elements defined in the given package extension
if 'True' is given as second argument.

Parameter 'package' is the name or URI of the package extension.
Parameter 'flag' is boolean value to indicate whether to write a
namespace prefix.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_PKG_UNKNOWN_VERSION
";


%feature("docstring") SBMLDocument::isEnabledDefaultNS "
Returns 'True' if a default namespace is added to each top-level
element defined in the given package extension, otherwise returns
'False.'

This basically checks if the attribute xmlns=\"...\" is present.

Parameter 'package' is the name or URI of the package extension.

Returns a boolean indicating whether the given package's default
namespace is enabled.
";


%feature("docstring") SBMLDocument::setPackageRequired "
Sets the required attribute value of the given package extension.

Parameter 'package' is the name or URI of the package extension.
Parameter 'flag' is Boolean value indicating whether the package is
required.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_PKG_UNKNOWN_VERSION
";


%feature("docstring") SBMLDocument::getPackageRequired "
Returns the required attribute of the given package extension.

Parameter 'package' is the name or URI of the package extension.

Returns Boolean flag indicating whether the package is flagged as
being required.
";


%feature("docstring") SBMLDocument::isSetPackageRequired "
Returns 'True' if the required attribute of the given package
extension is defined, otherwise returns 'False.'

Parameter 'package' is the name or URI of the package extension.

Returns a Boolean indicating whether the package's 'required' flag is
set.
";


%feature("docstring") SBMLDocument::isIgnoredPackage "
Returns 'True' if the given package extension is one of an ignored
packages, otherwise returns 'False.'

An ignored package is one that is defined to be used in this SBML
document, but the package is not enabled in this copy of libSBML.

Parameter 'pkgURI' is the URI of the package extension.

Returns a Boolean, 'True' if the package is being ignored and 'False'
otherwise.
";


%feature("docstring") SBMLDocument::isDisabledIgnoredPackage "
Returns 'True' if the given package extension is one of an ignored
packages that has been disabled, otherwise returns 'False.'

An ignored package is one that is defined to be used in this SBML
document, but the package is not enabled in this copy of libSBML. It
may have been disabled to avoid reproducing the package information
when writing out the file.

Parameter 'pkgURI' is the URI of the package extension.

Returns a Boolean, 'True' if the package is being ignored and 'False'
otherwise.
";


%feature("docstring") SBMLDocument::setPkgRequired "
Sets the value of the required attribute for the given package.

Parameter 'package' is the name or URI of the package extension.
Parameter 'flag' is a Boolean value.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_PKG_UNKNOWN_VERSION

DEPRECATED. Replaced in libSBML 5.2.0 by setPackageRequired()
";


%feature("docstring") SBMLDocument::getPkgRequired "
Returns the required attribute of the given package extension.

Parameter 'package' is the name or URI of the package extension.

Returns a Boolean value indicating whether the package is flagged as
being required in this SBML document.

DEPRECATED. Replaced in libSBML 5.2.0 by getPackageRequired()
";


%feature("docstring") SBMLDocument::isSetPkgRequired "
Returns 'True' if the required attribute of the given package
extension is defined, otherwise returns 'False.'

Parameter 'package' is the name or URI of the package extension.

Returns a Boolean value.

DEPRECATED. Replaced in libSBML 5.2.0 by isSetPackageRequired()
";


%feature("docstring") SBMLDocument::isIgnoredPkg "
Returns 'True' if the given package extension is one of ignored
packages, otherwise returns 'False.'

An ignored package is one that is defined to be used in this SBML
document, but the package is not enabled in this copy of libSBML.

Parameter 'pkgURI' is the URI of the package extension.

Returns a boolean indicating whether the given package is being
ignored.

DEPRECATED. Replaced in libSBML 5.2.0 by isIgnoredPackage()
";


%feature("docstring") SBMLDocument::getElementPosition "
Internal implementation method.
";


%feature("docstring") SBMLDocument::writeElements "
Internal implementation method.
";


%feature("docstring") SBMLDocument::getApplicableValidators "
Internal implementation method.
";


%feature("docstring") SBMLDocument::getConversionValidators "
Internal implementation method.
";


%feature("docstring") SBMLDocument::setApplicableValidators "
Internal implementation method.
";


%feature("docstring") SBMLDocument::setConversionValidators "
Internal implementation method.
";


%feature("docstring") SBMLDocument::getNumValidators "
Internal implementation method.
";


%feature("docstring") SBMLDocument::clearValidators "
Internal implementation method.
";


%feature("docstring") SBMLDocument::addValidator "
Internal implementation method.
";


%feature("docstring") SBMLDocument::getValidator "
Internal implementation method.
";


%feature("docstring") SBMLDocument::addUnknownPackageRequired "
Internal implementation method.
";


%feature("docstring") SBMLDocument::hasUnknownPackage "
Internal implementation method.
";


%feature("docstring") SBMLDocument::getNumUnknownPackages "
Internal implementation method.
";


%feature("docstring") SBMLDocument::getUnknownPackageURI "
Internal implementation method.
";


%feature("docstring") SBMLDocument::getUnknownPackagePrefix "
Internal implementation method.
";


%feature("docstring") SBMLDocument::createObject "
Internal implementation method.
";


%feature("docstring") SBMLDocument::addExpectedAttributes "
Internal implementation method.
";


%feature("docstring") SBMLDocument::readAttributes "
Internal implementation method.
";


%feature("docstring") SBMLDocument::writeAttributes "
Internal implementation method.
";


%feature("docstring") SBMLDocument::writeXMLNS "
Internal implementation method.
";


%feature("docstring") SBMLDocument::setInvalidLevel "
Internal implementation method.
";


%feature("docstring") FunctionDefinition "
A user-defined function in an SBML model.

The FunctionDefinition structure associates an identifier with a
function definition.  This identifier can then be used as the function
called in subsequent MathML content elsewhere in an SBML model.

FunctionDefinition has one required attribute, 'id', to give the
function a unique identifier by which other parts of an SBML model
definition can refer to it.  A FunctionDefinition instance can also
have an optional 'name' attribute of type 'string.'  Identifiers and
names must be used according to the guidelines described in the SBML
specification (e.g., Section 3.3 in the Level 2 Version 4
specification).

FunctionDefinition has a 'math' subelement containing a MathML
expression defining the function body.  In SBML Level 2 and SBML Level
3 Version 1, that 'math' subelement is required; in SBML Level 3
Version 2, this restriction was relaxed, making the 'math' subelement
optional.  The content of this element can only be a MathML 'lambda'
element.  The 'lambda' element must begin with zero or more 'bvar'
elements, followed by any other of the elements in the MathML subset
allowed in SBML Level 2 except 'lambda' (i.e., a 'lambda' element
cannot contain another 'lambda' element).  This is the only place in
SBML where a 'lambda' element can be used.  The function defined by a
FunctionDefinition is only available for use in other MathML elements
that follow the FunctionDefinition definition in the model.  (These
restrictions prevent recursive and mutually-recursive functions from
being expressed.)

A further restriction on the content of 'math' is that it cannot
contain references to variables other than the variables declared to
the 'lambda' itself.  That is, the contents of MathML 'ci' elements
inside the body of the 'lambda' can only be the variables declared by
its 'bvar' elements, or the identifiers of other FunctionDefinition
instances in the model.  This means must be written so that all
variables or parameters used in the MathML content are passed to them
via their function parameters.  In SBML Level 2, this restriction
applies also to the MathML 'csymbol' elements for time and delay; in
SBML Level 3, it additionally applies to the 'csymbol' element for
avogadro.

In SBML Level 3 Version 2, if no math element is present in  the
FunctionDefinition, the function has no mathematical meaning  defined
in SBML Level 3 Core. This situation may arise when models  are
incomplete, or when additional meanings are provided by an SBML  Level
3 package.

Note: Function definitions (also informally known as user-defined
functions) were introduced in SBML Level 2.  They have purposefully
limited capabilities.  A function cannot reference parameters or other
model quantities outside of itself; values must be passed as
parameters to the function.  Moreover, recursive and mutually-
recursive functions are not permitted.  The purpose of these
limitations is to balance power against complexity of implementation.
With the restrictions as they are, function definitions could be
implemented as textual substitutions---they are simply macros.
Software implementations therefore do not need the full function-
definition machinery typically associated with programming languages.

Another important point to note is FunctionDefinition does not have a
separate attribute for defining the units of the value returned by the
function.  The units associated with the function's return value, when
the function is called from within MathML expressions elsewhere in
SBML, are simply the overall units of the expression in
FunctionDefinition's 'math' subelement when applied to the arguments
supplied in the call to the function.  Ascertaining these units
requires performing dimensional analysis on the expression.  (Readers
may wonder why there is no attribute.  The reason is that having a
separate attribute for declaring the units would not only be
redundant, but also lead to the potential for having conflicting
information.  In the case of a conflict between the declared units and
those of the value actually returned by the function, the only logical
resolution rule would be to assume that the correct units are those of
the expression anyway.)
";


%feature("docstring") ListOfFunctionDefinitions "
A list of FunctionDefinition objects.

The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  In libSBML's
implementation, ListOf___ classes are derived from the intermediate
utility class ListOf, which is not defined by the SBML specifications
but serves as a useful programmatic construct.  ListOf is itself is in
turn derived from SBase, which provides all of the various ListOf___
classes with common features defined by the SBML specification, such
as 'metaid' attributes and annotations.

The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level 2 Version 4):

  <?xml version=\"1.0\" encoding=\"UTF-8\"?>
  <sbml xmlns=\"http://www.sbml.org/sbml/level3/version1/core\" 
        level=\"3\" version=\"1\">
    <model id=\"My_Model\">
      <listOfFunctionDefinitions>
        <functionDefinition> ... </functionDefinition> 
      </listOfFunctionDefinitions>
      <listOfUnitDefinitions>
        <unitDefinition> ... </unitDefinition> 
      </listOfUnitDefinitions>
      <listOfCompartments>
        <compartment> ... </compartment> 
      </listOfCompartments>
      <listOfSpecies>
        <species> ... </species> 
      </listOfSpecies>
      <listOfParameters>
        <parameter> ... </parameter> 
      </listOfParameters>
      <listOfInitialAssignments>
        <initialAssignment> ... </initialAssignment> 
      </listOfInitialAssignments>
      <listOfRules>
        ... elements of subclasses of Rule ...
      </listOfRules>
      <listOfConstraints>
        <constraint> ... </constraint> 
      </listOfConstraints>
      <listOfReactions>
        <reaction> ... </reaction> 
      </listOfReactions>
      <listOfEvents>
        <event> ... </event> 
      </listOfEvents>
    </model>
  </sbml>

SBML Level 3 Version 1 has essentially the same structure as  Level
2 Version 4, depicted above, but SBML Level 3  Version 2 allows
containers to contain zero or more of the relevant object, instead of
requiring at least one.  As such, libsbml will write out an
otherwise-empty ListOf___ element that has any optional attribute set
(such as 'id' or 'metaid'), that has an optional child (such  as a
'notes' or 'annotation'), or that has attributes or children set from
any SBML Level 3 package, whether or not the ListOf___ has  any other
children.

Readers may wonder about the motivations for using the ListOf___
containers in SBML.  A simpler approach in XML might be to place the
components all directly at the top level of the model definition.  The
choice made in SBML is to group them within XML elements named after
ListOfClassname, in part because it helps organize the components.
More importantly, the fact that the container classes are derived from
SBase means that software tools can add information about the lists
themselves into each list container's 'annotation'.

See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.
";


%feature("docstring") FunctionDefinition::FunctionDefinition "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    FunctionDefinition(SBMLNamespaces sbmlns)

Creates a new FunctionDefinition using the given SBMLNamespaces object
'sbmlns'.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

Parameter 'sbmlns' is an SBMLNamespaces object.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    FunctionDefinition(long level, long version)

Creates a new FunctionDefinition using the given SBML 'level' and
'version' values.

Parameter 'level' is a long integer, the SBML Level to assign to this
FunctionDefinition.

Parameter 'version' is a long integer, the SBML Version to assign to
this FunctionDefinition.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    FunctionDefinition(FunctionDefinition orig)

Copy constructor; creates a copy of this FunctionDefinition.

Parameter 'orig' is the object to copy.
";


%feature("docstring") FunctionDefinition::accept "
Internal implementation method.
";


%feature("docstring") FunctionDefinition::clone "
Creates and returns a deep copy of this FunctionDefinition object.

Returns the (deep) copy of this FunctionDefinition object.
";


%feature("docstring") FunctionDefinition::getId "
Returns the value of the 'id' attribute of this FunctionDefinition.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
getIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns the id of this FunctionDefinition.

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") FunctionDefinition::getName "
Returns the value of the 'name' attribute of this FunctionDefinition
object.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns the name of this SBML object, or the empty string if not set
or unsettable.

See also getIdAttribute(), isSetName(), setName(), unsetName().
";


%feature("docstring") FunctionDefinition::getMath "
Get the mathematical formula of this FunctionDefinition.

Returns an ASTNode, the value of the 'math' subelement of this
FunctionDefinition, or 'None' if the math is not set.
";


%feature("docstring") FunctionDefinition::isSetId "
Predicate returning 'True' if this FunctionDefinition's 'id' attribute
is set.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
isSetIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns 'True' if the 'id' attribute of this SBML object is set,
'False' otherwise.

See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
isSetIdAttribute().
";


%feature("docstring") FunctionDefinition::isSetName "
Predicate returning 'True' if this FunctionDefinition's 'name'
attribute is set.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns 'True' if the 'name' attribute of this SBML object is set,
'False' otherwise.

See also getName(), setName(), unsetName().
";


%feature("docstring") FunctionDefinition::isSetMath "
Predicate returning 'True' if this FunctionDefinition's 'math'
subelement contains a value.

Returns 'True' if the 'math' for this FunctionDefinition is set,
'False' otherwise.
";


%feature("docstring") FunctionDefinition::setId "
Sets the value of the 'id' attribute of this FunctionDefinition.

The string 'sid' is copied.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Parameter 'sid' is the string to use as the identifier of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") FunctionDefinition::setName "
Sets the value of the 'name' attribute of this FunctionDefinition.

The string in 'name' is copied.

Parameter 'name' is the new name for the SBML object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") FunctionDefinition::setMath "
Sets the 'math' subelement of this FunctionDefinition to the Abstract
Syntax Tree given in 'math'.

Parameter 'math' is an AST containing the mathematical expression to
be used as the formula for this FunctionDefinition.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_OBJECT
";


%feature("docstring") FunctionDefinition::unsetName "
Unsets the value of the 'name' attribute of this FunctionDefinition.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also getName(), setName(), isSetName().
";


%feature("docstring") FunctionDefinition::getArgument "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    getArgument(long n)

Get the nth argument to this function.

Callers should first find out the number of arguments to the function
by calling getNumArguments().

Parameter 'n' is an integer index for the argument sought.

Returns the nth argument (bound variable) passed to this
FunctionDefinition.

See also getNumArguments().

______________________________________________________________________
Method variant with the following signature:

    getArgument(string name)

Get the argument named 'name' to this FunctionDefinition.

Parameter 'name' is the exact name (case-sensitive) of the sought-
after argument.

Returns the argument (bound variable) having the given name, or 'None'
if no such argument exists.
";


%feature("docstring") FunctionDefinition::getBody "
Get the mathematical expression that is the body of this
FunctionDefinition object.

Returns the body of this FunctionDefinition as an Abstract Syntax
Tree, or 'None' if no body is defined.
";


%feature("docstring") FunctionDefinition::isSetBody "
Predicate returning 'True' if the body of this FunctionDefinition has
set.

Returns 'True' if the body of this FunctionDefinition is  set, 'False'
otherwise.
";


%feature("docstring") FunctionDefinition::getNumArguments "
Get the number of arguments (bound variables) taken by this
FunctionDefinition.

Returns the number of arguments (bound variables) that must be passed
to this FunctionDefinition.
";


%feature("docstring") FunctionDefinition::getTypeCode "
Returns the libSBML type code for this SBML object.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for this object: SBML_FUNCTION_DEFINITION
(default).

WARNING:

The specific integer values of the possible type codes may be reused
by different libSBML plug-ins for SBML Level 3. packages,  To fully
identify the correct code, it is necessary to invoke both
getTypeCode() and getPackageName().

See also getElementName(), getPackageName().
";


%feature("docstring") FunctionDefinition::getElementName "
Returns the XML element name of this object, which for
FunctionDefinition, is always ''functionDefinition'.'

Returns the name of this element, i.e., ''functionDefinition'.'
";


%feature("docstring") FunctionDefinition::writeElements "
Internal implementation method.
";


%feature("docstring") FunctionDefinition::hasRequiredAttributes "
Predicate returning 'True' if all the required attributes for this
FunctionDefinition object have been set.

The required attributes for a FunctionDefinition object are:

* 'id'

Returns 'True' if the required attributes have been set, 'False'
otherwise.
";


%feature("docstring") FunctionDefinition::hasRequiredElements "
Predicate returning 'True' if all the required elements for this
FunctionDefinition object have been set.

Note: The required elements for a FunctionDefinition object are:

* 'math' inSBML Level 2 and Level 3 Version 1.   (In SBML Level 3
Version 2+, it is no longer required.)

Returns a boolean value indicating whether all the required elements
for this object have been defined.
";


%feature("docstring") FunctionDefinition::renameUnitSIdRefs "
Renames all the 'UnitSIdRef' attributes on this element.

In SBML, unit definitions have identifiers of type UnitSId.  In SBML
Level 3, an explicit data type called UnitSIdRef was introduced for
attribute values that refer to UnitSId values; in previous Levels of
SBML, this data type did not exist and attributes were simply
described to as 'referring to a unit identifier', but the effective
data type was the same as UnitSIdRef in Level 3.  These and other
methods of libSBML refer to the type UnitSIdRef for all Levels of
SBML, even if the corresponding SBML specification did not explicitly
name the data type.

This method works by looking at all unit identifier attribute values
(including, if appropriate, inside mathematical formulas), comparing
the unit identifiers to the value of 'oldid'.  If any matches are
found, the matching identifiers are replaced with 'newid'.  The method
does not descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") FunctionDefinition::readOtherXML "
Internal implementation method.
";


%feature("docstring") FunctionDefinition::addExpectedAttributes "
Internal implementation method.
";


%feature("docstring") FunctionDefinition::readAttributes "
Internal implementation method.
";


%feature("docstring") FunctionDefinition::readL2Attributes "
Internal implementation method.
";


%feature("docstring") FunctionDefinition::readL3Attributes "
Internal implementation method.
";


%feature("docstring") FunctionDefinition::writeAttributes "
Internal implementation method.
";


%feature("docstring") ListOfFunctionDefinitions::ListOfFunctionDefinitions "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    ListOfFunctionDefinitions(SBMLNamespaces sbmlns)

Creates a new ListOfFunctionDefinitions object.

The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in
'sbmlns'.

Parameter 'sbmlns' is an SBMLNamespaces object that is used to
determine the characteristics of the ListOfFunctionDefinitions object
to be created.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    ListOfFunctionDefinitions(long level, long version)

Creates a new ListOfFunctionDefinitions object.

The object is constructed such that it is valid for the given SBML
Level and Version combination.

Parameter 'level' is the SBML Level.

Parameter 'version' is the Version within the SBML Level.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.
";


%feature("docstring") ListOfFunctionDefinitions::clone "
Creates and returns a deep copy of this ListOfFunctionDefinitions
object.

Returns the (deep) copy of this ListOfFunctionDefinitions object.
";


%feature("docstring") ListOfFunctionDefinitions::getItemTypeCode "
Returns the libSBML type code for the objects contained in this ListOf
(i.e., FunctionDefinition objects, if the list is non-empty).

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for the objects contained in this ListOf:
SBML_FUNCTION_DEFINITION (default).

See also getElementName(), getPackageName().
";


%feature("docstring") ListOfFunctionDefinitions::getElementName "
Returns the XML element name of this object.

For ListOfFunctionDefinitions, the XML element name is
''listOfFunctionDefinitions'.'

Returns the name of this element, i.e., ''listOfFunctionDefinitions'.'
";


%feature("docstring") ListOfFunctionDefinitions::get "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    get(long n)

Get a FunctionDefinition from the ListOfFunctionDefinitions.

Parameter 'n' is the index number of the FunctionDefinition to get.

Returns the nth FunctionDefinition in this ListOfFunctionDefinitions.

See also size().

______________________________________________________________________
Method variant with the following signature:

    get(string sid)

Get a FunctionDefinition from the ListOfFunctionDefinitions based on
its identifier.

Parameter 'sid' is a string representing the identifier  of the
FunctionDefinition to get.

Returns FunctionDefinition in this ListOfFunctionDefinitions with the
given 'sid' or 'None' if no such FunctionDefinition exists.

See also get(), size().
";


%feature("docstring") ListOfFunctionDefinitions::remove "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    remove(long n)

Removes the nth item from this ListOfFunctionDefinitions items and
returns a pointer to it.

The caller owns the returned item and is responsible for deleting it.

Parameter 'n' is the index of the item to remove.

See also size().

______________________________________________________________________
Method variant with the following signature:

    remove(string sid)

Removes item in this ListOfFunctionDefinitions items with the given
identifier.

The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier 'sid', then
'None' is returned.

Parameter 'sid' is the identifier of the item to remove.

Returns the item removed.  As mentioned above, the caller owns the
returned item.
";


%feature("docstring") ListOfFunctionDefinitions::getElementPosition "
Internal implementation method.
";


%feature("docstring") ListOfFunctionDefinitions::createObject "
Internal implementation method.
";


%feature("docstring") UnitKind_equals "
Tests for logical equality between two given UNIT_KIND_ code values.

This function behaves exactly like C's == operator, except for the
following two cases:

* UNIT_KIND_LITER == UNIT_KIND_LITRE

* UNIT_KIND_METER == UNIT_KIND_METRE In the two cases above, C
equality comparison would yield '0' (false) (because each of the above
is a distinct enumeration value), but this function returns 'True.'

Parameter 'uk1' is a UNIT_KIND_ value. Parameter 'uk2' is a second
UNIT_KIND_ value to compare to 'uk1'.

Returns '1' (true) if 'uk1' is logically equivalent to 'uk2', '0'
(false) otherwise.

Note: For more information about the libSBML unit codes, please refer
to the class documentation for Unit.
";


%feature("docstring") UnitKind_forName "
Converts a text string naming a kind of unit to its corresponding
libSBML UNIT_KIND_ constant/enumeration value.

Parameter 'name' is a string, the name of a predefined base unit in
SBML.

Returns a value the set of UNIT_KIND_ codes defined in class libsbml,
corresponding to the string 'name' (determined in a case-insensitive
manner).

Note: For more information about the libSBML unit codes, please refer
to the class documentation for Unit.
";


%feature("docstring") UnitKind_toString "
Converts a unit code to a text string equivalent.

Parameter 'uk' is a value from the set of UNIT_KIND_ codes defined in
the class libsbml

Returns the name corresponding to the given unit code.

Note: For more information about the libSBML unit codes, please refer
to the class documentation for Unit.

WARNING:

The string returned is a static data value.  The caller does not own
the returned string and is therefore not allowed to modify it.
";


%feature("docstring") UnitKind_isValidUnitKindString "
Predicate for testing whether a given string corresponds to a
predefined libSBML unit code.

Parameter 'str' is a text string naming a base unit defined by SBML.
Parameter 'level' is the Level of SBML. Parameter 'version' is the
Version within the Level of SBML.

Returns 1 (true) if string is the name of a valid UNIT_KIND_ value,
'0' (false) otherwise.

Note: For more information about the libSBML unit codes, please refer
to the class documentation for Unit.
";


%feature("docstring") Unit "
A single unit referenced in an SBML unit definition.

The SBML unit definition facility uses two classes of objects,
UnitDefinition and Unit.  The approach to defining units in SBML is
compositional; for example, meter second^-2 is constructed by
combining a Unit object representing meter with another Unit object
representing second^-2. The combination is wrapped inside a
UnitDefinition, which provides for assigning an identifier and
optional name to the combination.  The identifier can then be
referenced from elsewhere in a model.  Thus, the UnitDefinition class
is the container, and Unit instances are placed inside UnitDefinition
instances.

A Unit has four attributes named 'kind', 'exponent', 'scale' and
'multiplier'.  It represents a (possibly transformed) reference to a
base unit.  The attribute 'kind' on Unit indicates the chosen base
unit. Its value must be one of the text strings listed below; this
list corresponds to SBML Level 3:

   ampere         farad  joule     lux     radian     volt  
   avogadro       gram   katal     metre   second     watt  
   becquerel      gray   kelvin    mole    siemens    weber 
   candela        henry  kilogram  newton  sievert          
   coulomb        hertz  litre     ohm     steradian        
   dimensionless  item   lumen     pascal  tesla

A few small differences exist between the Level 3 list of base units
and the list defined in other Level/Version combinations of SBML.
Specifically, Levels of SBML before Level 3 do not define 'avogadro;'
conversely, Level 2 Version 1 defines 'Celsius,' and Level 1 defines
'celsius,' 'meter,' and 'liter,' none of which are available in Level
3.  In libSBML, each of the predefined base unit names is represented
by an enumeration value whose name begins with the characters
UNIT_KIND_, discussed in a separate section below.

The attribute named 'exponent' on Unit represents an exponent on the
unit.  In SBML Level 2, the attribute is optional and has a default
value of '1' (one); in SBML Level 3, the attribute is mandatory and
there is no default value.  A Unit also has an attribute called
'scale'; its value must be an integer exponent for a power-of-ten
multiplier used to set the scale of the unit.  For example, a unit
having a 'kind' value of 'gram' and a 'scale' value of '-3' signifies
10^-3 * gram, or milligrams.  In SBML Level 2, the attribute is
optional and has a default value of '0' (zero), because 10^0 = 1; in
SBML Level 3, the attribute is mandatory and has no default value.
Lastly, the attribute named 'multiplier' can be used to multiply the
unit by a real-numbered factor; this enables the definition of units
that are not power-of-ten multiples of SI units.  For instance, a
multiplier of 0.3048 could be used to define 'foot' as a measure of
length in terms of a 'metre.'  The 'multiplier' attribute is optional
in SBML Level 2, where it has a default value of '1' (one); in SBML
Level 3, the attribute is mandatory and has no default value.

Unit identification codes
......................................................................

As discussed above, SBML defines a set of base units which serves as
the starting point for new unit definitions.  This set of base units
consists of the SI units and a small number of additional convenience
units.

In SBML Level 2 Versions before Version 3, there existed an
enumeration of units called 'UnitKind.'  In Version 3, this
enumeration was removed and the identifier class 'UnitSId' redefined
to include the previous 'UnitKind' values as reserved symbols.  This
change has no net effect on permissible models, their representation
or their syntax.  The purpose of the change in the SBML specification
was simply to clean up an inconsistency about the contexts in which
these values were usable. However, libSBML maintains UnitKind in the
form of of a set of static integer constants whose names begin with
the characters UNIT_KIND_.  These constants are defined in the class
libsbml.

As a consequence of the fact that libSBML supports models in all
Levels and Versions of SBML, libSBML's set of 'UNIT_KIND_' values is a
union of all the possible base unit names defined in the different
SBML specifications.  However, not every base unit is allowed in every
Level+Version combination of SBML.  Note in particular the following
exceptions:

* The alternate spelling ''meter'' is included in addition to the
official SI spelling ''metre'.'  This spelling is only permitted in
SBML Level 1 models.

* The alternate spelling ''liter'' is included in addition to the
official SI spelling ''litre'.'  This spelling is only permitted in
SBML Level 1 models.

* The unit ''Celsius'' is included because of its presence in
specifications of SBML prior to SBML Level 2 Version 2.

* The unit 'avogadro' was introduced in SBML Level 3, and is only
permitted for use in SBML Level 3 models. The table below lists the
unit constants defined in libSBML, and their meanings.

  Enumerator              Meaning
  ---------               ---------
  UNIT_KIND_AMPERE        The ampere unit.
  UNIT_KIND_AVOGADRO      'dimensionless' multiplied by the value of Avogadro's constant.
  UNIT_KIND_BECQUEREL     The becquerel unit.
  UNIT_KIND_CANDELA       The candela unit.
  UNIT_KIND_CELSIUS       The Celsius unit. 
  UNIT_KIND_COULOMB       The coulomb unit.
  UNIT_KIND_DIMENSIONLESS A pseudo-unit indicating a dimensionless quantity.
  UNIT_KIND_FARAD         The farad unit.
  UNIT_KIND_GRAM          The gram unit.
  UNIT_KIND_GRAY          The gray unit.
  UNIT_KIND_HENRY         The henry unit.
  UNIT_KIND_HERTZ         The hertz unit.
  UNIT_KIND_ITEM          A pseudo-unit representing a single \"thing\".
  UNIT_KIND_JOULE         The joule unit.
  UNIT_KIND_KATAL         The katal unit.
  UNIT_KIND_KELVIN        The kelvin unit.
  UNIT_KIND_KILOGRAM      The kilogram unit.
  UNIT_KIND_LITER         Alternate spelling of litre.
  UNIT_KIND_LITRE         The litre unit.
  UNIT_KIND_LUMEN         The lumen unit.
  UNIT_KIND_LUX           The lux unit.
  UNIT_KIND_METER         Alternate spelling of metre.
  UNIT_KIND_METRE         The metre unit.
  UNIT_KIND_MOLE          The mole unit.
  UNIT_KIND_NEWTON        The newton unit.
  UNIT_KIND_OHM           The ohm unit.
  UNIT_KIND_PASCAL        The pascal unit.
  UNIT_KIND_RADIAN        The radian unit.
  UNIT_KIND_SECOND        The second unit.
  UNIT_KIND_SIEMENS       The siemens unit.
  UNIT_KIND_SIEVERT       The sievert unit.
  UNIT_KIND_STERADIAN     The steradian unit.
  UNIT_KIND_TESLA         The tesla unit.
  UNIT_KIND_VOLT          The volt unit.
  UNIT_KIND_WATT          The watt unit.
  UNIT_KIND_WEBER         The weber unit.
  UNIT_KIND_INVALID       Marker used by libSBML to indicate an invalid or unset unit.
";


%feature("docstring") ListOfUnits "
A list of Unit objects.

ListOfUnits is entirely contained within UnitDefinition.

The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  In libSBML's
implementation, ListOf___ classes are derived from the intermediate
utility class ListOf, which is not defined by the SBML specifications
but serves as a useful programmatic construct.  ListOf is itself is in
turn derived from SBase, which provides all of the various ListOf___
classes with common features defined by the SBML specification, such
as 'metaid' attributes and annotations.

The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level 2 Version 4):

  <?xml version=\"1.0\" encoding=\"UTF-8\"?>
  <sbml xmlns=\"http://www.sbml.org/sbml/level3/version1/core\" 
        level=\"3\" version=\"1\">
    <model id=\"My_Model\">
      <listOfFunctionDefinitions>
        <functionDefinition> ... </functionDefinition> 
      </listOfFunctionDefinitions>
      <listOfUnitDefinitions>
        <unitDefinition> ... </unitDefinition> 
      </listOfUnitDefinitions>
      <listOfCompartments>
        <compartment> ... </compartment> 
      </listOfCompartments>
      <listOfSpecies>
        <species> ... </species> 
      </listOfSpecies>
      <listOfParameters>
        <parameter> ... </parameter> 
      </listOfParameters>
      <listOfInitialAssignments>
        <initialAssignment> ... </initialAssignment> 
      </listOfInitialAssignments>
      <listOfRules>
        ... elements of subclasses of Rule ...
      </listOfRules>
      <listOfConstraints>
        <constraint> ... </constraint> 
      </listOfConstraints>
      <listOfReactions>
        <reaction> ... </reaction> 
      </listOfReactions>
      <listOfEvents>
        <event> ... </event> 
      </listOfEvents>
    </model>
  </sbml>

SBML Level 3 Version 1 has essentially the same structure as  Level
2 Version 4, depicted above, but SBML Level 3  Version 2 allows
containers to contain zero or more of the relevant object, instead of
requiring at least one.  As such, libsbml will write out an
otherwise-empty ListOf___ element that has any optional attribute set
(such as 'id' or 'metaid'), that has an optional child (such  as a
'notes' or 'annotation'), or that has attributes or children set from
any SBML Level 3 package, whether or not the ListOf___ has  any other
children.

Readers may wonder about the motivations for using the ListOf___
containers in SBML.  A simpler approach in XML might be to place the
components all directly at the top level of the model definition.  The
choice made in SBML is to group them within XML elements named after
ListOfClassname, in part because it helps organize the components.
More importantly, the fact that the container classes are derived from
SBase means that software tools can add information about the lists
themselves into each list container's 'annotation'.

See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.
";


%feature("docstring") Unit::Unit "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    Unit(SBMLNamespaces sbmlns)

Creates a new Unit using the given SBMLNamespaces object 'sbmlns'.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

Parameter 'sbmlns' is an SBMLNamespaces object.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    Unit(long level, long version)

Creates a new Unit using the given SBML 'level' and 'version' values.

Parameter 'level' is a long integer, the SBML Level to assign to this
Unit.

Parameter 'version' is a long integer, the SBML Version to assign to
this Unit.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    Unit(Unit orig)

Copy constructor; creates a copy of this Unit.

Parameter 'orig' is the object to copy.
";


%feature("docstring") Unit::accept "
Internal implementation method.
";


%feature("docstring") Unit::clone "
Creates and returns a deep copy of this Unit object.

Returns the (deep) copy of this Unit object.
";


%feature("docstring") Unit::initDefaults "
Initializes the fields of this Unit object to 'typical' default
values.

The SBML Unit component has slightly different aspects and default
attribute values in different SBML Levels and Versions.  This method
sets the values to certain common defaults, based mostly on what they
are in SBML Level 2.  Specifically:

* Sets attribute 'exponent' to '1'

* Sets attribute 'scale' to '0'

* Sets attribute 'multiplier' to '1.0' The 'kind' attribute is left
unchanged.
";


%feature("docstring") Unit::getKind "
Returns the 'kind' of Unit this is.

Returns the value of the 'kind' attribute of this Unit as a value from
the set of constants whose names begin with UNIT_KIND_ defined in the
class libsbml.
";


%feature("docstring") Unit::getExponent "
Returns the value of the 'exponent' attribute of this unit.

Returns the 'exponent' value of this Unit, as an integer.
";


%feature("docstring") Unit::getExponentAsDouble "
Returns the value of the 'exponent' attribute of this unit.

Returns the 'exponent' value of this Unit, as a double.
";


%feature("docstring") Unit::getScale "
Returns the value of the 'scale' attribute of this unit.

Returns the 'scale' value of this Unit, as an integer.
";


%feature("docstring") Unit::getMultiplier "
Returns the value of the 'multiplier' attribute of this Unit.

Returns the 'multiplier' value of this Unit, as a double.
";


%feature("docstring") Unit::getOffset "
Returns the value of the 'offset' attribute of this Unit.

Returns the 'offset' value of this Unit, as a double.

WARNING:

The 'offset' attribute is only available in SBML Level 2 Version 1.
This attribute is not present in SBML Level 2 Version 2 or above.
When producing SBML models using these later specifications, modelers
and software tools need to account for units with offsets explicitly.
The SBML specification document offers a number of suggestions for how
to achieve this.  LibSBML methods such as this one related to 'offset'
are retained for compatibility with earlier versions of SBML Level 2,
but their use is strongly discouraged.
";


%feature("docstring") Unit::isAmpere "
Predicate for testing whether this Unit is of the kind 'ampere.'

Returns 'True' if the kind of this Unit is 'ampere,' 'False'
otherwise.
";


%feature("docstring") Unit::isAvogadro "
Predicate for testing whether this Unit is of the kind 'avogadro.'

Returns 'True' if the kind of this Unit is 'avogadro,' 'False'
otherwise.

Note: The unit 'avogadro' was introduced in SBML Level 3, and is only
permitted for use in SBML Level 3 models.
";


%feature("docstring") Unit::isBecquerel "
Predicate for testing whether this Unit is of the kind 'becquerel'

Returns 'True' if the kind of this Unit is 'becquerel,' 'False'
otherwise.
";


%feature("docstring") Unit::isCandela "
Predicate for testing whether this Unit is of the kind 'candela'

Returns 'True' if the kind of this Unit is 'candela,' 'False'
otherwise.
";


%feature("docstring") Unit::isCelsius "
Predicate for testing whether this Unit is of the kind 'Celsius'

Returns 'True' if the kind of this Unit is 'Celsius,' 'False'
otherwise.

WARNING:

The predefined unit 'Celsius' was removed from the list of predefined
units in SBML Level 2 Version 2 at the same time that the 'offset'
attribute was removed from Unit definitions.  LibSBML methods such as
this one related to 'Celsius' are retained in order to support SBML
Level 2 Version 1, but their use is strongly discouraged.
";


%feature("docstring") Unit::isCoulomb "
Predicate for testing whether this Unit is of the kind 'coulomb'

Returns 'True' if the kind of this Unit is 'coulomb,' 'False'
otherwise.
";


%feature("docstring") Unit::isDimensionless "
Predicate for testing whether this Unit is of the kind
'dimensionless.'

Returns 'True' if the kind of this Unit is 'dimensionless,' 'False'
otherwise.
";


%feature("docstring") Unit::isFarad "
Predicate for testing whether this Unit is of the kind 'farad'

Returns 'True' if the kind of this Unit is 'farad,' 'False' otherwise.
";


%feature("docstring") Unit::isGram "
Predicate for testing whether this Unit is of the kind 'gram'

Returns 'True' if the kind of this Unit is 'gram,' 'False' otherwise.
";


%feature("docstring") Unit::isGray "
Predicate for testing whether this Unit is of the kind 'gray'

Returns 'True' if the kind of this Unit is 'gray,' 'False' otherwise.
";


%feature("docstring") Unit::isHenry "
Predicate for testing whether this Unit is of the kind 'henry'

Returns 'True' if the kind of this Unit is 'henry,' 'False' otherwise.
";


%feature("docstring") Unit::isHertz "
Predicate for testing whether this Unit is of the kind 'hertz'

Returns 'True' if the kind of this Unit is 'hertz,' 'False' otherwise.
";


%feature("docstring") Unit::isItem "
Predicate for testing whether this Unit is of the kind 'item'

Returns 'True' if the kind of this Unit is 'item,' 'False' otherwise.
";


%feature("docstring") Unit::isJoule "
Predicate for testing whether this Unit is of the kind 'joule'

Returns 'True' if the kind of this Unit is 'joule,' 'False' otherwise.
";


%feature("docstring") Unit::isKatal "
Predicate for testing whether this Unit is of the kind 'katal'

Returns 'True' if the kind of this Unit is 'katal,' 'False' otherwise.
";


%feature("docstring") Unit::isKelvin "
Predicate for testing whether this Unit is of the kind 'kelvin'

Returns 'True' if the kind of this Unit is 'kelvin,' 'False'
otherwise.
";


%feature("docstring") Unit::isKilogram "
Predicate for testing whether this Unit is of the kind 'kilogram'

Returns 'True' if the kind of this Unit is 'kilogram,' 'False'
otherwise.
";


%feature("docstring") Unit::isLitre "
Predicate for testing whether this Unit is of the kind 'litre'

Returns 'True' if the kind of this Unit is 'litre' or 'liter', 'False'
otherwise.
";


%feature("docstring") Unit::isLumen "
Predicate for testing whether this Unit is of the kind 'lumen'

Returns 'True' if the kind of this Unit is 'lumen,' 'False' otherwise.
";


%feature("docstring") Unit::isLux "
Predicate for testing whether this Unit is of the kind 'lux'

Returns 'True' if the kind of this Unit is 'lux,' 'False' otherwise.
";


%feature("docstring") Unit::isMetre "
Predicate for testing whether this Unit is of the kind 'metre'

Returns 'True' if the kind of this Unit is 'metre' or 'meter', 'False'
otherwise.
";


%feature("docstring") Unit::isMole "
Predicate for testing whether this Unit is of the kind 'mole'

Returns 'True' if the kind of this Unit is 'mole,' 'False' otherwise.
";


%feature("docstring") Unit::isNewton "
Predicate for testing whether this Unit is of the kind 'newton'

Returns 'True' if the kind of this Unit is 'newton,' 'False'
otherwise.
";


%feature("docstring") Unit::isOhm "
Predicate for testing whether this Unit is of the kind 'ohm'

Returns 'True' if the kind of this Unit is 'ohm,' 'False' otherwise.
";


%feature("docstring") Unit::isPascal "
Predicate for testing whether this Unit is of the kind 'pascal'

Returns 'True' if the kind of this Unit is 'pascal,' 'False'
otherwise.
";


%feature("docstring") Unit::isRadian "
Predicate for testing whether this Unit is of the kind 'radian'

Returns 'True' if the kind of this Unit is 'radian,' 'False'
otherwise.
";


%feature("docstring") Unit::isSecond "
Predicate for testing whether this Unit is of the kind 'second'

Returns 'True' if the kind of this Unit is 'second,' 'False'
otherwise.
";


%feature("docstring") Unit::isSiemens "
Predicate for testing whether this Unit is of the kind 'siemens'

Returns 'True' if the kind of this Unit is 'siemens,' 'False'
otherwise.
";


%feature("docstring") Unit::isSievert "
Predicate for testing whether this Unit is of the kind 'sievert'

Returns 'True' if the kind of this Unit is 'sievert,' 'False'
otherwise.
";


%feature("docstring") Unit::isSteradian "
Predicate for testing whether this Unit is of the kind 'steradian'

Returns 'True' if the kind of this Unit is 'steradian,' 'False'
otherwise.
";


%feature("docstring") Unit::isTesla "
Predicate for testing whether this Unit is of the kind 'tesla'

Returns 'True' if the kind of this Unit is 'tesla,' 'False' otherwise.
";


%feature("docstring") Unit::isVolt "
Predicate for testing whether this Unit is of the kind 'volt'

Returns 'True' if the kind of this Unit is 'volt,' 'False' otherwise.
";


%feature("docstring") Unit::isWatt "
Predicate for testing whether this Unit is of the kind 'watt'

Returns 'True' if the kind of this Unit is 'watt,' 'False' otherwise.
";


%feature("docstring") Unit::isWeber "
Predicate for testing whether this Unit is of the kind 'weber'

Returns 'True' if the kind of this Unit is 'weber,' 'False' otherwise.
";


%feature("docstring") Unit::isSetKind "
Predicate to test whether the 'kind' attribute of this Unit is set.

Returns 'True' if the 'kind' attribute of this Unit is set, 'False'
otherwise.
";


%feature("docstring") Unit::isSetExponent "
Predicate to test whether the 'exponent' attribute of this Unit  is
set.

Returns 'True' if the 'exponent' attribute of this Unit is set,
'False' otherwise.
";


%feature("docstring") Unit::isSetScale "
Predicate to test whether the 'scale' attribute of this Unit  is set.

Returns 'True' if the 'scale' attribute of this Unit is set,  'False'
otherwise.
";


%feature("docstring") Unit::isSetMultiplier "
Predicate to test whether the 'multiplier' attribute of this Unit  is
set.

Returns 'True' if the 'multiplier' attribute of this Unit is set,
'False' otherwise.
";


%feature("docstring") Unit::isSetOffset "
Predicate to test whether the 'offset' attribute of this Unit  is set.

Returns 'True' if the 'offset' attribute of this Unit is set,  'False'
otherwise.

WARNING:

The 'offset' attribute is only available in SBML Level 2 Version 1.
This attribute is not present in SBML Level 2 Version 2 or above.
When producing SBML models using these later specifications, modelers
and software tools need to account for units with offsets explicitly.
The SBML specification document offers a number of suggestions for how
to achieve this.  LibSBML methods such as this one related to 'offset'
are retained for compatibility with earlier versions of SBML Level 2,
but their use is strongly discouraged.
";


%feature("docstring") Unit::setKind "
Sets the 'kind' attribute value of this Unit.

Parameter 'kind' is a unit identifier chosen from the set of constants
whose names begin with UNIT_KIND_ in libsbml.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") Unit::setExponent "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    setExponent(int value)

Sets the 'exponent' attribute value of this Unit.

Parameter 'value' is the integer to which the attribute 'exponent'
should be set.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

______________________________________________________________________
Method variant with the following signature:

    setExponent(double value)

Sets the 'exponent' attribute value of this Unit.

Parameter 'value' is the double to which the attribute 'exponent'
should be set.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS
";


%feature("docstring") Unit::setScale "
Sets the 'scale' attribute value of this Unit.

Parameter 'value' is the integer to which the attribute 'scale' should
be set.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS
";


%feature("docstring") Unit::setMultiplier "
Sets the 'multipler' attribute value of this Unit.

Parameter 'value' is the floating-point value to which the attribute
'multiplier' should be set.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE
";


%feature("docstring") Unit::setOffset "
Sets the 'offset' attribute value of this Unit.

Parameter 'value' is the floating point value to which the attribute
'offset' should set.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

WARNING:

The 'offset' attribute is only available in SBML Level 2 Version 1.
This attribute is not present in SBML Level 2 Version 2 or above.
When producing SBML models using these later specifications, modelers
and software tools need to account for units with offsets explicitly.
The SBML specification document offers a number of suggestions for how
to achieve this.  LibSBML methods such as this one related to 'offset'
are retained for compatibility with earlier versions of SBML Level 2,
but their use is strongly discouraged.
";


%feature("docstring") Unit::unsetKind "
Unsets the 'kind' attribute value of this Unit.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") Unit::unsetExponent "
Unsets the 'exponent' attribute value of this Unit.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") Unit::unsetScale "
Unsets the 'scale' attribute value of this Unit.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS
";


%feature("docstring") Unit::unsetMultiplier "
Unsets the 'multipler' attribute value of this Unit.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE
";


%feature("docstring") Unit::unsetOffset "
Unsets the 'offset' attribute value of this Unit.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

WARNING:

The 'offset' attribute is only available in SBML Level 2 Version 1.
This attribute is not present in SBML Level 2 Version 2 or above.
When producing SBML models using these later specifications, modelers
and software tools need to account for units with offsets explicitly.
The SBML specification document offers a number of suggestions for how
to achieve this.  LibSBML methods such as this one related to 'offset'
are retained for compatibility with earlier versions of SBML Level 2,
but their use is strongly discouraged.
";


%feature("docstring") Unit::getTypeCode "
Returns the libSBML type code of this object instance.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for this object: SBML_UNIT (default).

WARNING:

The specific integer values of the possible type codes may be reused
by different libSBML plug-ins for SBML Level 3. packages,  To fully
identify the correct code, it is necessary to invoke both
getTypeCode() and getPackageName().

See also getPackageName(), getElementName().
";


%feature("docstring") Unit::getElementName "
Returns the XML element name of this object, which for Unit, is always
''unit'.'

Returns the name of this element, i.e., ''unit'.'
";


%feature("docstring") Unit::writeElements "
Internal implementation method.
";


%feature("docstring") Unit::isBuiltIn "
Predicate to test whether a given string is the name of a built-in
SBML unit, depending on the SBML level, since new predefined units
were added between level 2 versions 1 and 2, and then all predefined
units were removed again in SBML Level 3.

Parameter 'name' is a string to be tested against the built-in unit
names. Parameter 'level' is the level of SBML one is checking.

Returns 'True' if 'name' is one of ''substance',' ''volume',' or
''time'' and the 'level' is '1;' or if 'name' is one of ''substance','
''volume',' ''area',' ''length',' or ''time'' and the 'level' is '2;'
'False' otherwise (including all values when 'level' is '3).'

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.
";


%feature("docstring") Unit::isUnitKind "
Predicate to test whether a given string is the name of a valid base
unit in SBML (such as ''gram'' or ''mole').'

This method exists because prior to SBML Level 2 Version 3, an
enumeration called 'UnitKind' was defined by SBML.  This enumeration
was removed in SBML Level 2 Version 3 and its values were folded into
the space of values of a type called 'UnitSId.'  This method therefore
has less significance in SBML Level 2 Version 3 and Level 2 Version 4,
but remains for backward compatibility and support for reading models
in older Versions of Level 2.

Parameter 'name' is a string to be tested.

Parameter 'level' is a long integer representing the SBML
specification Level.

Parameter 'version' is a long integer representing the SBML
specification Version.

Returns 'True' if name is a valid SBML UnitKind, 'False' otherwise.

Note: The allowed unit names differ between SBML Levels 1 and 2 and
again slightly between Level 2 Versions 1 and 2.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.
";


%feature("docstring") Unit::areIdentical "
Predicate returning 'True' if two Unit objects are identical.

Two Unit objects are considered to be identical if they match in all
attributes.  (Contrast this to the method areEquivalent(), which
compares Unit objects only with respect to certain attributes.)

Parameter 'unit1' is the first Unit object to compare. Parameter
'unit2' is the second Unit object to compare.

Returns 'True' if all the attributes of unit1 are identical to the
attributes of unit2, 'False' otherwise.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.

See also Unit.areEquivalent() .
";


%feature("docstring") Unit::areEquivalent "
Predicate returning 'True' if  Unit objects are equivalent.

Two Unit objects are considered to be equivalent either if (1) both
have a 'kind' attribute value of 'dimensionless,' or (2) their 'kind',
'exponent' and (for SBML Level 2 Version 1) 'offset' attribute values
are equal. (Contrast this to the method areIdentical(), which compares
Unit objects with respect to all attributes, not just the 'kind' and
'exponent'.)

Parameter 'unit1' is the first Unit object to compare. Parameter
'unit2' is the second Unit object to compare.

Returns 'True' if the 'kind' and 'exponent' attributes of unit1 are
identical to the kind and exponent attributes of unit2, or if the kind
attributes of both are 'dimensionless;' 'False' otherwise.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.

See also Unit.areIdentical() .
";


%feature("docstring") Unit::removeScale "
Manipulates the attributes of the Unit to express the unit with the
value of the scale attribute reduced to zero.

For example, 1 millimetre can be expressed as a Unit with kind=
''metre'' multiplier=''1'' scale=''-3'' exponent=''1'.' It can also be
expressed as a Unit with kind=''metre'' multiplier='0.001' scale=''0''
exponent=''1'.'

Parameter 'unit' is the Unit object to manipulate.

Returns integer value indicating success/failure of the function.
This particular function only does one thing irrespective of user
input or  object state, and thus will only return a single value:

* LIBSBML_OPERATION_SUCCESS

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.

See also Unit.convertToSI() , Unit.merge() .
";


%feature("docstring") Unit::merge "
Merges two Unit objects with the same 'kind' attribute value into a
single Unit.

For example, the following,

   <unit kind=\'metre\' exponent=\'2\'/>
   <unit kind=\'metre\' exponent=\'1\'/>

would be merged to become

   <unit kind=\'metre\' exponent=\'3\'/>

Parameter 'unit1' is the first Unit object; the result of the
operation is left as a new version of this unit, modified in-place.
Not modified if the two units have different kinds.

Parameter 'unit2' is the second Unit object to merge with the first.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.

See also Unit.convertToSI() , Unit.removeScale() .
";


%feature("docstring") Unit::convertToSI "
Returns a UnitDefinition object containing the given 'unit' converted
to the appropriate SI unit.

This method exists because some units can be expressed in terms of
others when the same physical dimension is involved.  For example, one
hertz is identical to 1 sec^-1, one litre is equivalent to 1 cubic
decametre, and so on.

Parameter 'unit' is the Unit object to convert to SI.

Returns a UnitDefinition object containing the SI unit.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.

See also Unit.merge() .
";


%feature("docstring") Unit::hasRequiredAttributes "
Predicate returning 'True' if all the required attributes for this
Unit object have been set.

The required attributes for a Unit object are:

* 'kind'

* 'exponent' (required in SBML Level 3; optional in Level 2)

* 'multiplier' (required in SBML Level 3; optional in Level 2)

* 'scale' (required in SBML Level 3; optional in Level 2)

Returns 'True' if the required attributes have been set, 'False'
otherwise.
";


%feature("docstring") Unit::setExponentUnitChecking "
Internal implementation method.
";


%feature("docstring") Unit::getExponentUnitChecking "
Internal implementation method.
";


%feature("docstring") Unit::isUnitChecking "
Internal implementation method.
";


%feature("docstring") Unit::addExpectedAttributes "
Internal implementation method.
";


%feature("docstring") Unit::readAttributes "
Internal implementation method.
";


%feature("docstring") Unit::readL1Attributes "
Internal implementation method.
";


%feature("docstring") Unit::readL2Attributes "
Internal implementation method.
";


%feature("docstring") Unit::readL3Attributes "
Internal implementation method.
";


%feature("docstring") Unit::writeAttributes "
Internal implementation method.
";


%feature("docstring") Unit::isL1UnitKind "
Internal implementation method.
";


%feature("docstring") Unit::isL2V1UnitKind "
Internal implementation method.
";


%feature("docstring") Unit::isL2UnitKind "
Internal implementation method.
";


%feature("docstring") Unit::isL3UnitKind "
Internal implementation method.
";


%feature("docstring") Unit::isExplicitlySetExponent "
Internal implementation method.
";


%feature("docstring") Unit::isExplicitlySetMultiplier "
Internal implementation method.
";


%feature("docstring") Unit::isExplicitlySetScale "
Internal implementation method.
";


%feature("docstring") Unit::isExplicitlySetOffset "
Internal implementation method.
";


%feature("docstring") ListOfUnits::ListOfUnits "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    ListOfUnits(SBMLNamespaces sbmlns)

Creates a new ListOfUnits object.

The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in
'sbmlns'.

Parameter 'sbmlns' is an SBMLNamespaces object that is used to
determine the characteristics of the ListOfUnits object to be created.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    ListOfUnits(long level, long version)

Creates a new ListOfUnits object.

The object is constructed such that it is valid for the given SBML
Level and Version combination.

Parameter 'level' is the SBML Level.

Parameter 'version' is the Version within the SBML Level.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.
";


%feature("docstring") ListOfUnits::clone "
Creates and returns a deep copy of this ListOfUnits object.

Returns the (deep) copy of this ListOfUnits object.
";


%feature("docstring") ListOfUnits::getItemTypeCode "
Returns the libSBML type code for the objects contained in this ListOf
(i.e., Unit objects, if the list is non-empty).

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for objects contained in this list:
SBML_UNIT (default).

See also getElementName(), getPackageName().
";


%feature("docstring") ListOfUnits::getElementName "
Returns the XML element name of this object.

For ListOfUnits, the XML element name is ''listOfUnits'.'

Returns the name of this element, i.e., ''listOfUnits'.'
";


%feature("docstring") ListOfUnits::get "
Get a Unit from the ListOfUnits.

Parameter 'n' is the index number of the Unit to get.

Returns the nth Unit in this ListOfUnits.

See also size().
";


%feature("docstring") ListOfUnits::remove "
Removes the nth item from this ListOfUnits items and returns a pointer
to it.

The caller owns the returned item and is responsible for deleting it.

Parameter 'n' is the index of the item to remove.

See also size().
";


%feature("docstring") ListOfUnits::getElementPosition "
Internal implementation method.
";


%feature("docstring") ListOfUnits::createObject "
Internal implementation method.
";


%feature("docstring") UnitDefinition "
A definition of a unit used in an SBML model.

Units of measurement may be supplied in a number of contexts in an
SBML model.  The SBML unit definition facility uses two classes of
objects, UnitDefinition and Unit.  The approach to defining units in
SBML is compositional; for example, meter second^-2 is constructed by
combining a Unit object representing meter with another Unit object
representing second^-2. The combination is wrapped inside a
UnitDefinition, which provides for assigning an identifier and
optional name to the combination.  The identifier can then be
referenced from elsewhere in a model.  Thus, the UnitDefinition class
is the container, and Unit instances are placed inside UnitDefinition
instances.

Two points are worth discussing in the context of SBML units.  First,
unit declarations in SBML models are optional.  The consequence of
this is that a model must be numerically self-consistent independently
of unit declarations, for the benefit of software tools that cannot
interpret or manipulate units.  Unit declarations in SBML are thus
more akin to a type of annotation; they can indicate intentions, and
can be used by model readers for checking the consistency of the
model, labeling simulation output, etc., but any transformations of
values implied by different units must be incorporated explicitly into
a model.

Second, the vast majority of situations that require new SBML unit
definitions involve simple multiplicative combinations of base units
and factors.  An example is moles per litre per second.  What
distinguishes these sorts of unit definitions from more complex ones
is that they may be expressed without the use of an additive offset
from a zero point.  The use of offsets complicates all unit definition
systems, yet in the domain of SBML, the real-life cases requiring
offsets are few (and in fact, to the best of our knowledge, only
involve temperature). Consequently, the SBML unit system has been
consciously designed to simplify implementation of unit support for
the most common cases in systems biology.  The cost of this
simplification is to require units with offsets to be handled
explicitly by the modeler.

Summary of the UnitDefinition construct
======================================================================

UnitDefinition has two attributes and one subelement.  The two
attributes are 'id' and 'name', and the subelement is ListOfUnits.

The required attribute 'id' and optional attribute 'name' are both
strings.  The 'id' attribute is used to give the defined unit a unique
identifier by which other parts of an SBML model definition can refer
to it.  The 'name' attribute is intended to be used for giving the
unit definition an optional human-readable name.  Please see the next
section for information about the values permitted for 'id'.

A UnitDefinition may contain exactly one ListOfUnits, and this list
may contain one or more Unit definitions; see the definitions of these
other object classes for more information about them.  In SBML  Level
2 and SBML Level 3 Version 1, if the ListOfUnits was present, it must
have one or more Unit definitions.  In SBML Level 3 Version 2, this
restriction was relaxed, and  a ListOfUnits was allowed to be empty.
In either case, if a UnitDefinition had no child Unit elements, the
unit was considered to be undefined.

The following example illustrates a complete unit definition (when
written in XML) when all the pieces are combined together.  This
defines 'mmls' to be millimoles per litre per second.

   <listOfUnitDefinitions>
       <unitDefinition id=\'mmls\'>
           <listOfUnits>
               <unit kind=\'mole\'   scale=\'-3\'/>
               <unit kind=\'litre\'  exponent=\'-1\'/>
               <unit kind=\'second\' exponent=\'-1\'/>
           </listOfUnits>
       </unitDefinition>
   </listOfUnitDefinitions>

Special considerations for Unit object identifiers
======================================================================

The attribute 'id' in UnitDefinition cannot be given simply any value,
and the precise details of the values permitted differ slightly
between Levels of SBML:

* The 'id' of a UnitDefinition must not contain a value from the list
of SBML's predefined base unit names (i.e., the strings 'gram,'
'litre,' etc.).  In SBML Level 3, this list consists of the following:

   ampere         farad  joule     lux     radian     volt  
   avogadro       gram   katal     metre   second     watt  
   becquerel      gray   kelvin    mole    siemens    weber 
   candela        henry  kilogram  newton  sievert          
   coulomb        hertz  litre     ohm     steradian        
   dimensionless  item   lumen     pascal  tesla

This list of predefined base units is nearly identical in SBML Level
2 Version 4, the exception being that Level 2 does not define
'avogadro.'  SBML Level 2 Version 1 (and only this Level+Version
combination) provides an additional predefined unit name, 'Celsius,'
not available in Level 3.  Finally, SBML Level 1 Versions 2-3 provide
two more additional predefined unit names, 'meter' and 'liter.'  This
is explained in somewhat greater detail in the description of the Unit
class.

* In SBML Level 2 (all Versions), there is an additional set of
reserved identifiers: 'substance,' 'volume,' 'area,' 'length,' and
'time.'  Using one of these values for the attribute 'id' of a
UnitDefinition has the effect of redefining the model-wide default
units for the corresponding quantities.  The list of special unit
names in SBML Level 2 is given in the table below:

  +------------+-------------------------------------------+---------------+
  | Identifier | Possible scalable units                   | Default units |
  +------------+-------------------------------------------+---------------+
  | substance  | mole, item, gram, kilogram, dimensionless | mole          |
  | volume     | litre, cubic metre, dimensionless         | litre         |
  | area       | square metre, dimensionless               | square metre  |
  | length     | metre, dimensionless                      | metre         |
  | time       | second, dimensionless                     | second        |
  +------------+-------------------------------------------+---------------+

Also, SBML Level 2 imposes two limitations on redefining the
predefined unit 'substance,' 'volume,' 'area,' 'length,' and 'time:'
(1) The UnitDefinition of a predefined SBML unit can only contain a
single Unit object within it.  (2) The value of the 'kind' attribute
in a Unit instance must be drawn from one of the values in the second
column of the table above.

The special unit names 'substance,' 'volume,' 'area,' 'length,' and
'time' are not defined by SBML Level 3, which uses a different
approach to setting model-wide inherited units.

Further comments about SBML's unit definition system
======================================================================

The vast majority of modeling situations requiring new SBML unit
definitions involve simple multiplicative combinations of base units
and factors.  An example of this might be moles per litre per second.
What distinguishes these sorts of simpler unit definitions from more
complex ones is that they may be expressed without the use of an
additive offset from a zero point.  The use of offsets complicates all
unit definition systems, yet in the domain of SBML the real-life cases
requiring offsets are few (and in fact, to the best of our knowledge,
only involve temperature).  Consequently, the SBML unit system has
been consciously designed in a way that attempts to simplify
implementation of unit support for the most common cases in systems
biology.

As of SBML Level 2 Version 2, Unit no longer has the attribute called
'offset' introduced in SBML Level 2 Version 1.  It turned out that the
general case involving units with offsets was incorrectly defined, and
few (if any) developers even attempted to support offset-based units
in their software.  In the development of Level 2 Version 2, a
consensus among SBML developers emerged that a fully generalized unit
scheme is so confusing and complicated that it actually impedes
interoperability. SBML Level 2 Version 2, Version 3 and Version 4
acknowledge this reality by reducing and simplifying the unit system,
specifically by removing the 'offset' attribute on Unit and 'Celsius'
as a pre-defined unit.

The following guidelines suggest methods for handling units that do
require the use of zero offsets for their definitions:

* Handling Celsius.  A model in which certain quantities are
temperatures measured in degrees Celsius can be converted
straightforwardly to a model in which those temperatures are in
kelvin.  A software tool could do this by performing a straightforward
substitution using the following relationship: T_ kelvin = T_Celsius +
273.15.  In every mathematical formula of the model where a quantity
(call it x) in degrees Celsius appears, replace x with x_k+ 273.15,
where x_k is now in kelvin.  An alternative approach would  be to use
a FunctionDefinition object to define a function encapsulating this
relationship above and then using that in the rest of the model as
needed.  Since Celsius is a commonly-used unit, software tools could
help users by providing users with the ability to express temperatures
in Celsius in the tools' interfaces, and making substitutions
automatically when writing out the SBML.

* Other units requiring offsets.  One approach to handling other kinds
of units is to use a FunctionDefinition to define a function
encapsulating the necessary mathematical relationship, then
substituting a call to this function wherever the original quantity
appeared in the model.  For example, here is a possible definition for
converting Fahrenheit to Celsius degrees:

   <functionDefinition id=\'Fahrenheit_to_kelvin\'>
       <math xmlns=\'http://www.w3.org/1998/Math/MathML\'>
           <lambda>
               <bvar><ci> temp_in_fahrenheit </ci></bvar>
               <apply>
                   <divide/>
                   <apply>
                       <plus/>
                       <ci> temp_in_fahrenheit </ci>
                       <cn> 459.67 </cn>
                   </apply>
                   <cn> 1.8 </cn>
               </apply>
           </lambda>
       </math>
   </functionDefinition>

* An alternative approach not requiring the use of function
definitions is to use an AssignmentRule for each variable in
Fahrenheit units. The AssignmentRule could compute the conversion from
Fahrenheit to (say) kelvin, assign its value to a variable (in Kelvin
units), and then that variable could be used elsewhere in the model.

* Still another approach is to rewrite the mathematical formulas of a
model to directly incorporate the conversion formula wherever the
original quantity appeared. Please consult the SBML specifications for
more information about this and other issues involving units.
";


%feature("docstring") ListOfUnitDefinitions "
A list of UnitDefinition objects.

The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  In libSBML's
implementation, ListOf___ classes are derived from the intermediate
utility class ListOf, which is not defined by the SBML specifications
but serves as a useful programmatic construct.  ListOf is itself is in
turn derived from SBase, which provides all of the various ListOf___
classes with common features defined by the SBML specification, such
as 'metaid' attributes and annotations.

The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level 2 Version 4):

  <?xml version=\"1.0\" encoding=\"UTF-8\"?>
  <sbml xmlns=\"http://www.sbml.org/sbml/level3/version1/core\" 
        level=\"3\" version=\"1\">
    <model id=\"My_Model\">
      <listOfFunctionDefinitions>
        <functionDefinition> ... </functionDefinition> 
      </listOfFunctionDefinitions>
      <listOfUnitDefinitions>
        <unitDefinition> ... </unitDefinition> 
      </listOfUnitDefinitions>
      <listOfCompartments>
        <compartment> ... </compartment> 
      </listOfCompartments>
      <listOfSpecies>
        <species> ... </species> 
      </listOfSpecies>
      <listOfParameters>
        <parameter> ... </parameter> 
      </listOfParameters>
      <listOfInitialAssignments>
        <initialAssignment> ... </initialAssignment> 
      </listOfInitialAssignments>
      <listOfRules>
        ... elements of subclasses of Rule ...
      </listOfRules>
      <listOfConstraints>
        <constraint> ... </constraint> 
      </listOfConstraints>
      <listOfReactions>
        <reaction> ... </reaction> 
      </listOfReactions>
      <listOfEvents>
        <event> ... </event> 
      </listOfEvents>
    </model>
  </sbml>

SBML Level 3 Version 1 has essentially the same structure as  Level
2 Version 4, depicted above, but SBML Level 3  Version 2 allows
containers to contain zero or more of the relevant object, instead of
requiring at least one.  As such, libsbml will write out an
otherwise-empty ListOf___ element that has any optional attribute set
(such as 'id' or 'metaid'), that has an optional child (such  as a
'notes' or 'annotation'), or that has attributes or children set from
any SBML Level 3 package, whether or not the ListOf___ has  any other
children.

Readers may wonder about the motivations for using the ListOf___
containers in SBML.  A simpler approach in XML might be to place the
components all directly at the top level of the model definition.  The
choice made in SBML is to group them within XML elements named after
ListOfClassname, in part because it helps organize the components.
More importantly, the fact that the container classes are derived from
SBase means that software tools can add information about the lists
themselves into each list container's 'annotation'.

See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.
";


%feature("docstring") UnitDefinition::UnitDefinition "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    UnitDefinition(SBMLNamespaces sbmlns)

Creates a new UnitDefinition using the given SBMLNamespaces object
'sbmlns'.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

Parameter 'sbmlns' is an SBMLNamespaces object.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    UnitDefinition(long level, long version)

Creates a new UnitDefinition using the given SBML 'level' and
'version' values.

Parameter 'level' is a long integer, the SBML Level to assign to this
UnitDefinition.

Parameter 'version' is a long integer, the SBML Version to assign to
this UnitDefinition.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    UnitDefinition(UnitDefinition orig)

Copy constructor; creates a copy of this UnitDefinition.

Parameter 'orig' is the object to copy.
";


%feature("docstring") UnitDefinition::accept "
Internal implementation method.
";


%feature("docstring") UnitDefinition::clone "
Creates and returns a deep copy of this UnitDefinition object.

Returns the (deep) copy of this UnitDefinition object.
";


%feature("docstring") UnitDefinition::getElementBySId "
Returns the first child element found that has the given 'id' in the
model-wide SId namespace, or 'None' if no such object is found.

Parameter 'id' is string representing the id of the object to find.

Returns pointer to the first element found with the given 'id'.
";


%feature("docstring") UnitDefinition::getElementByMetaId "
Returns the first child element it can find with the given 'metaid',
or 'None' if no such object is found.

Parameter 'metaid' is string representing the metaid of the object to
find.

Returns pointer to the first element found with the given 'metaid'.
";


%feature("docstring") UnitDefinition::getAllElements "
Returns a List of all child SBase objects, including those nested to
an arbitrary depth

Parameter 'filter' is a pointer to an ElementFilter, which causes the
function  to return only elements that match a particular set of
constraints.   If None (the default), the function will return all
child objects.

Returns a List of pointers to all children objects.
";


%feature("docstring") UnitDefinition::getId "
Returns the value of the 'id' attribute of this UnitDefinition.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
getIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns the id of this UnitDefinition.

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") UnitDefinition::getName "
Returns the value of the 'name' attribute of this UnitDefinition
object.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns the name of this SBML object, or the empty string if not set
or unsettable.

See also getIdAttribute(), isSetName(), setName(), unsetName().
";


%feature("docstring") UnitDefinition::isSetId "
Predicate returning 'True' if this UnitDefinition's 'id' attribute is
set.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
isSetIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns 'True' if the 'id' attribute of this SBML object is set,
'False' otherwise.

See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
isSetIdAttribute().
";


%feature("docstring") UnitDefinition::isSetName "
Predicate returning 'True' if this UnitDefinition's 'name' attribute
is set.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns 'True' if the 'name' attribute of this SBML object is set,
'False' otherwise.

See also getName(), setName(), unsetName().
";


%feature("docstring") UnitDefinition::setId "
Sets the value of the 'id' attribute of this UnitDefinition.

The string 'sid' is copied.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Parameter 'sid' is the string to use as the identifier of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") UnitDefinition::setName "
Sets the value of the 'name' attribute of this UnitDefinition.

The string in 'name' is copied.

Parameter 'name' is the new name for the SBML object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") UnitDefinition::unsetName "
Unsets the value of the 'name' attribute of this UnitDefinition.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also getName(), setName(), isSetName().
";


%feature("docstring") UnitDefinition::isVariantOfArea "
Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier ''area'.'

Returns 'True' if this UnitDefinition is a variant of the predefined
unit 'area,' meaning square metres with only arbitrary variations in
scale or multiplier values; 'False' otherwise.

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") UnitDefinition::isVariantOfLength "
Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier ''length'.'

Returns 'True' if this UnitDefinition is a variant of the predefined
unit 'length,' meaning metres with only arbitrary variations in scale
or multiplier values; 'False' otherwise.

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") UnitDefinition::isVariantOfSubstance "
Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier ''substance'.'

Returns 'True' if this UnitDefinition is a variant of the predefined
unit 'substance,' meaning moles or items (and grams or kilograms from
SBML Level 2 Version 2 onwards) with only arbitrary variations in
scale or multiplier values; 'False' otherwise.

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") UnitDefinition::isVariantOfTime "
Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier ''time'.'

Returns 'True' if this UnitDefinition is a variant of the predefined
unit 'time,' meaning seconds with only arbitrary variations in scale
or multiplier values; 'False' otherwise.

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") UnitDefinition::isVariantOfVolume "
Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier ''volume'.'

Returns 'True' if this UnitDefinition is a variant of the predefined
unit 'volume,' meaning litre or cubic metre with only arbitrary
variations in scale or multiplier values; 'False' otherwise.

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") UnitDefinition::isVariantOfDimensionless "
Convenience function for testing if a given unit definition is a
variant of the unit ''dimensionless'.'

Returns 'True' if this UnitDefinition is a variant of 'dimensionless,'
meaning dimensionless with only arbitrary variations in scale or
multiplier values; 'False' otherwise.

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") UnitDefinition::isVariantOfMass "
Convenience function for testing if a given unit definition is a
variant of the predefined unit identifier ''mass'.'

Returns 'True' if this UnitDefinition is a variant of mass units,
meaning gram or kilogram with only arbitrary variations in scale or
multiplier values; 'False' otherwise.

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") UnitDefinition::isVariantOfSubstancePerTime "
Convenience function for testing if a given unit definition is a
variant of the predefined unit ''substance'' divided by the predefined
unit ''time'.'

Returns 'True' if this UnitDefinition is a variant of the predefined
unit 'substance' per predefined unit 'time,' meaning it contains two
units one of which is a variant of substance and the other is a
variant of time which an exponent of -1; 'False' otherwise.

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") UnitDefinition::addUnit "
Adds a copy of the given Unit to this UnitDefinition.

Parameter 'u' is the Unit instance to add to this UnitDefinition.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_LEVEL_MISMATCH

* LIBSBML_VERSION_MISMATCH

* LIBSBML_INVALID_OBJECT

* LIBSBML_OPERATION_FAILED

Note: This method should be used with some caution.  The fact that
this method copies the object passed to it means that the caller will
be left holding a physically different object instance than the one
contained inside this object.  Changes made to the original object
instance (such as resetting attribute values) will not affect the
instance in this object.  In addition, the caller should make sure to
free the original object if it is no longer being used, or else a
memory leak will result.  Please see other methods on this class
(particularly a corresponding method whose name begins with the word
create) for alternatives that do not lead to these issues.

See also createUnit().
";


%feature("docstring") UnitDefinition::createUnit "
Creates a new and empty Unit, adds it to this UnitDefinition's list of
units, and returns it.

Returns a newly constructed (and empty) Unit instance.

Note: It is worth emphasizing that the attribute 'kind' value of a
Unit is a required attribute for a valid Unit definition.  The
createUnit() method does not assign a valid kind to the constructed
unit (instead, it sets the 'kind' to UNIT_KIND_INVALID). Callers are
cautioned to set the newly-constructed Unit's kind using
Unit.setKind() soon after calling this method.

See also addUnit().
";


%feature("docstring") UnitDefinition::getListOfUnits "
Returns the list of Units for this UnitDefinition instance. Returns
the ListOfUnits value for this UnitDefinition.
";


%feature("docstring") UnitDefinition::getUnit "
Returns a specific Unit instance belonging to this UnitDefinition.

Parameter 'n' is an integer, the index of the Unit to be returned.

Returns the nth Unit of this UnitDefinition.

See also getNumUnits().
";


%feature("docstring") UnitDefinition::getNumUnits "
Returns the number of Unit objects contained within this
UnitDefinition.

Returns an integer representing the number of Units in this
UnitDefinition.
";


%feature("docstring") UnitDefinition::removeUnit "
Removes the nth Unit object from this UnitDefinition object and
returns a pointer to it.

The caller owns the returned object and is responsible for deleting
it.

Parameter 'n' is the index of the Unit object to remove.

Returns the Unit object removed, or 'None' if the given index  is out
of range.
";


%feature("docstring") UnitDefinition::setSBMLDocument "
Internal implementation method.
";


%feature("docstring") UnitDefinition::enablePackageInternal "
Internal implementation method.
";


%feature("docstring") UnitDefinition::getTypeCode "
Returns the libSBML type code for this object instance.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for this object: SBML_UNIT_DEFINITION
(default).

WARNING:

The specific integer values of the possible type codes may be reused
by different libSBML plug-ins for SBML Level 3. packages,  To fully
identify the correct code, it is necessary to invoke both
getTypeCode() and getPackageName().

See also getPackageName(), getElementName().
";


%feature("docstring") UnitDefinition::getElementName "
Returns the XML element name of this object, which for UnitDefinition,
is always ''unitDefinition'.'

Returns the name of this element, i.e., ''unitDefinition'.'
";


%feature("docstring") UnitDefinition::simplify "
Simplifies the UnitDefinition such that any given kind of Unit object
occurs only once in the ListOfUnits.

For example, the following definition,

   <unitDefinition>
    <listOfUnits>
      <unit kind=\'metre\' exponent=\'1\'/>
      <unit kind=\'metre\' exponent=\'2\'/>
    </listOfUnits>
   <unitDefinition>

will be simplified to

   <unitDefinition>
     <listOfUnits>
       <unit kind=\'metre\' exponent=\'3\'/>
     </listOfUnits>
   <unitDefinition>

Parameter 'ud' is the UnitDefinition object to be simplified.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.
";


%feature("docstring") UnitDefinition::reorder "
Alphabetically orders the Unit objects within the ListOfUnits of a
UnitDefinition.

Parameter 'ud' is the UnitDefinition object whose units are to be
reordered.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.
";


%feature("docstring") UnitDefinition::convertToSI "
Convert a given UnitDefinition into a new UnitDefinition object that
uses SI units.

Parameter 'ud' is the UnitDefinition object to convert to SI.

Returns a new UnitDefinition object representing the results of the
conversion.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.
";


%feature("docstring") UnitDefinition::areIdentical "
Predicate returning 'True' if two UnitDefinition objects are
identical.

For the purposes of performing this comparison, two UnitDefinition
objects are considered identical when they contain identical lists of
Unit objects.  Pairs of Unit objects in the lists are in turn
considered identical if they satisfy the predicate
Unit.areIdentical(). The predicate compares every attribute of the
Unit objects.

Parameter 'ud1' is the first UnitDefinition object to compare.
Parameter 'ud2' is the second UnitDefinition object to compare.

Returns 'True' if all the Unit objects in 'ud1' are identical to the
Unit objects of 'ud2', 'False' otherwise.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.

See also UnitDefinition.areEquivalent(), Unit.areIdentical().
";


%feature("docstring") UnitDefinition::areEquivalent "
Predicate returning 'True' if two UnitDefinition objects are
equivalent.

For the purposes of performing this comparison, two UnitDefinition
objects are considered equivalent when they contain equivalent list of
Unit objects.  Unit objects are in turn considered equivalent if they
satisfy the predicate Unit.areEquivalent(). The predicate tests a
subset of the objects's attributes.

Parameter 'ud1' is the first UnitDefinition object to compare.

Parameter 'ud2' is the second UnitDefinition object to compare.

Returns 'True' if all the Unit objects in 'ud1' are equivalent to the
Unit objects in 'ud2', 'False' otherwise.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.

See also UnitDefinition.areIdentical(), Unit.areEquivalent().
";


%feature("docstring") UnitDefinition::areIdenticalSIUnits "
Internal implementation method.
";


%feature("docstring") UnitDefinition::combine "
Combines two UnitDefinition objects into a single UnitDefinition.

This takes UnitDefinition objects 'ud1' and 'ud2', and creates a
UnitDefinition object that expresses the product of the units of 'ud1'
and 'ud2'.

Parameter 'ud1' is the first UnitDefinition object. Parameter 'ud2' is
the second UnitDefinition object.

Returns a UnitDefinition which represents the product of the  units of
the two argument UnitDefinitions.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.
";


%feature("docstring") UnitDefinition::divide "
Combines two UnitDefinition objects into a single UnitDefinition as a
division.

This takes UnitDefinition objects 'ud1' and 'ud2', and creates a
UnitDefinition object that expresses the division of the units of
'ud1' and 'ud2'.

Parameter 'ud1' is the first UnitDefinition object. Parameter 'ud2' is
the second UnitDefinition object.

Returns a UnitDefinition which represents the division of the  units
of the two argument UnitDefinitions.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.
";


%feature("docstring") UnitDefinition::printUnits "
Expresses the given definition in a plain-text form.

For example, UnitDefinition.printUnits() applied to

   <unitDefinition>
    <listOfUnits>
      <unit kind=\'metre\' exponent=\'1\'/>
      <unit kind=\'second\' exponent=\'-2\'/>
    </listOfUnits>
   <unitDefinition>

will return the string 'metre (exponent = 1, multiplier = 1, scale =
0) second (exponent = -2, multiplier = 1, scale = 0)' or, if the
optional parameter 'compact' is given the value 'True,' the string '(1
metre)^1 (1 second)^-2'.  This method may be useful for printing unit
information to human users, or in debugging software, or other
situations.

Parameter 'ud' is the UnitDefinition object. Parameter 'compact' is
boolean indicating whether the compact form should be used (defaults
to false).

Returns a string expressing the unit definition defined by the given
UnitDefinition object 'ud'.

Note: Because this is a static method on a class, the Python language
interface for libSBML will contain two variants.  One will be the
expected, normal static method on the class (i.e., a regular
methodName), and the other will be a standalone top-level function
with the name ClassName_methodName(). This is merely an artifact of
how the language interfaces are created in libSBML.  The methods are
functionally identical.

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.
";


%feature("docstring") UnitDefinition::writeElements "
Internal implementation method.
";


%feature("docstring") UnitDefinition::hasRequiredAttributes "
Predicate returning 'True' if all the required attributes for this
UnitDefinition object have been set.

The required attributes for a UnitDefinition object are:

* 'id'

Returns 'True' if the required attributes have been set, 'False'
otherwise.
";


%feature("docstring") UnitDefinition::hasRequiredElements "
Predicate returning 'True' if all the required elements for this
UnitDefinition object have been set.

Note: The required elements for a Constraint object are:

* 'listOfUnits' (required in SBML Level 2 only, optional in Level
3)

Returns a boolean value indicating whether all the required elements
for this object have been defined.
";


%feature("docstring") UnitDefinition::createObject "
Internal implementation method.
";


%feature("docstring") UnitDefinition::addExpectedAttributes "
Internal implementation method.
";


%feature("docstring") UnitDefinition::readAttributes "
Internal implementation method.
";


%feature("docstring") UnitDefinition::readL1Attributes "
Internal implementation method.
";


%feature("docstring") UnitDefinition::readL2Attributes "
Internal implementation method.
";


%feature("docstring") UnitDefinition::readL3Attributes "
Internal implementation method.
";


%feature("docstring") UnitDefinition::writeAttributes "
Internal implementation method.
";


%feature("docstring") ListOfUnitDefinitions::ListOfUnitDefinitions "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    ListOfUnitDefinitions(SBMLNamespaces sbmlns)

Creates a new ListOfUnitDefinitions object.

The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in
'sbmlns'.

Parameter 'sbmlns' is an SBMLNamespaces object that is used to
determine the characteristics of the ListOfUnitDefinitions object to
be created.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    ListOfUnitDefinitions(long level, long version)

Creates a new ListOfUnitDefinitions object.

The object is constructed such that it is valid for the given SBML
Level and Version combination.

Parameter 'level' is the SBML Level.

Parameter 'version' is the Version within the SBML Level.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.
";


%feature("docstring") ListOfUnitDefinitions::clone "
Creates and returns a deep copy of this ListOfUnitDefinitions object.

Returns the (deep) copy of this ListOfUnitDefinitions object.
";


%feature("docstring") ListOfUnitDefinitions::getItemTypeCode "
Returns the libSBML type code for the objects contained in this ListOf
(i.e., UnitDefinition objects, if the list is non-empty).

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for objects contained in this list:
SBML_UNIT_DEFINITION (default).

See also getElementName(), getPackageName().
";


%feature("docstring") ListOfUnitDefinitions::getElementName "
Returns the XML element name of this object.

For ListOfUnitDefinitions, the XML element name is
''listOfUnitDefinitions'.'

Returns the name of this element, i.e., ''listOfUnitDefinitions'.'
";


%feature("docstring") ListOfUnitDefinitions::get "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    get(long n)

Get a UnitDefinition from the ListOfUnitDefinitions.

Parameter 'n' is the index number of the UnitDefinition to get.

Returns the nth UnitDefinition in this ListOfUnitDefinitions.

See also size().

______________________________________________________________________
Method variant with the following signature:

    get(string sid)

Get a UnitDefinition from the ListOfUnitDefinitions based on its
identifier.

Parameter 'sid' is a string representing the identifier  of the
UnitDefinition to get.

Returns UnitDefinition in this ListOfUnitDefinitions with the given
'sid' or 'None' if no such UnitDefinition exists.

See also get(), size().
";


%feature("docstring") ListOfUnitDefinitions::getElementBySId "
Returns the first child element found that has the given 'id' in the
model-wide SId namespace, or 'None' if no such object is found.

Note that UnitDefinitions themselves are in the UnitId namespace, not
the SId namespace, so no UnitDefinition object will be returned from
this function (and is the reason we override the base
ListOf::getElementBySId function here).

Parameter 'id' is string representing the id of the object to find.

Returns pointer to the first element found with the given 'id'.
";


%feature("docstring") ListOfUnitDefinitions::remove "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    remove(long n)

Removes the nth item from this ListOfUnitDefinitions items and returns
a pointer to it.

The caller owns the returned item and is responsible for deleting it.

Parameter 'n' is the index of the item to remove.

See also size().

______________________________________________________________________
Method variant with the following signature:

    remove(string sid)

Removes item in this ListOfUnitDefinitions items with the given
identifier.

The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier 'sid', then
'None' is returned.

Parameter 'sid' is the identifier of the item to remove.

Returns the item removed.  As mentioned above, the caller owns the
returned item.
";


%feature("docstring") ListOfUnitDefinitions::getElementPosition "
Internal implementation method.
";


%feature("docstring") ListOfUnitDefinitions::createObject "
Internal implementation method.
";


%feature("docstring") CompartmentType "
A compartment type in SBML Level 2.

SBML Level 2 Versions 2-4 provide the compartment type as a grouping
construct that can be used to establish a relationship between
multiple Compartment objects.  A CompartmentType object only has an
identity, and this identity can only be used to indicate that
particular Compartment objects in the model belong to this type.  This
may be useful for conveying a modeling intention, such as when a model
contains many similar compartments, either by their biological
function or the reactions they carry.  Without a compartment type
construct, it would be impossible within SBML itself to indicate that
all of the compartments share an underlying conceptual relationship
because each SBML compartment must be given a unique and separate
identity.  A CompartmentType has no mathematical meaning in SBML---it
has no effect on a model's mathematical interpretation. Simulators and
other numerical analysis software may ignore CompartmentType
definitions and references to them in a model.

There is no mechanism in SBML Level 2 for representing hierarchies of
compartment types.  One CompartmentType instance cannot be the subtype
of another CompartmentType instance; SBML provides no means of
defining such relationships.

As with other major structures in SBML, CompartmentType has a
mandatory attribute, 'id', used to give the compartment type an
identifier.  The identifier must be a text string conforming to the
identifer syntax permitted in SBML.  CompartmentType also has an
optional 'name' attribute, of type 'string.'  The 'id' and 'name' must
be used according to the guidelines described in the SBML
specification (e.g., Section 3.3 in the Level 2 Version 4
specification).

CompartmentType was introduced in SBML Level 2 Version 2.  It is not
available in SBML Level 1 nor in Level 3.

See also Compartment, ListOfCompartmentTypes, SpeciesType,
ListOfSpeciesTypes.
";


%feature("docstring") ListOfCompartmentTypes "
A list of CompartmentType objects.

The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  In libSBML's
implementation, ListOf___ classes are derived from the intermediate
utility class ListOf, which is not defined by the SBML specifications
but serves as a useful programmatic construct.  ListOf is itself is in
turn derived from SBase, which provides all of the various ListOf___
classes with common features defined by the SBML specification, such
as 'metaid' attributes and annotations.

The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level 2 Version 4):

  <?xml version=\"1.0\" encoding=\"UTF-8\"?>
  <sbml xmlns=\"http://www.sbml.org/sbml/level3/version1/core\" 
        level=\"3\" version=\"1\">
    <model id=\"My_Model\">
      <listOfFunctionDefinitions>
        <functionDefinition> ... </functionDefinition> 
      </listOfFunctionDefinitions>
      <listOfUnitDefinitions>
        <unitDefinition> ... </unitDefinition> 
      </listOfUnitDefinitions>
      <listOfCompartments>
        <compartment> ... </compartment> 
      </listOfCompartments>
      <listOfSpecies>
        <species> ... </species> 
      </listOfSpecies>
      <listOfParameters>
        <parameter> ... </parameter> 
      </listOfParameters>
      <listOfInitialAssignments>
        <initialAssignment> ... </initialAssignment> 
      </listOfInitialAssignments>
      <listOfRules>
        ... elements of subclasses of Rule ...
      </listOfRules>
      <listOfConstraints>
        <constraint> ... </constraint> 
      </listOfConstraints>
      <listOfReactions>
        <reaction> ... </reaction> 
      </listOfReactions>
      <listOfEvents>
        <event> ... </event> 
      </listOfEvents>
    </model>
  </sbml>

SBML Level 3 Version 1 has essentially the same structure as  Level
2 Version 4, depicted above, but SBML Level 3  Version 2 allows
containers to contain zero or more of the relevant object, instead of
requiring at least one.  As such, libsbml will write out an
otherwise-empty ListOf___ element that has any optional attribute set
(such as 'id' or 'metaid'), that has an optional child (such  as a
'notes' or 'annotation'), or that has attributes or children set from
any SBML Level 3 package, whether or not the ListOf___ has  any other
children.

Readers may wonder about the motivations for using the ListOf___
containers in SBML.  A simpler approach in XML might be to place the
components all directly at the top level of the model definition.  The
choice made in SBML is to group them within XML elements named after
ListOfClassname, in part because it helps organize the components.
More importantly, the fact that the container classes are derived from
SBase means that software tools can add information about the lists
themselves into each list container's 'annotation'.

See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.
";


%feature("docstring") CompartmentType::CompartmentType "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    CompartmentType(SBMLNamespaces sbmlns)

Creates a new CompartmentType object using the given SBMLNamespaces
object 'sbmlns'.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level 2 and beyond, the 'id'
(identifier) attribute of a CompartmentType object is required to have
a value.  Thus, callers are cautioned to assign a value after calling
this constructor.  Setting the identifier can be accomplished using
the method setId().

Parameter 'sbmlns' is an SBMLNamespaces object.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    CompartmentType(long level, long version)

Creates a new CompartmentType object using the given SBML 'level' and
'version' values.

Parameter 'level' is a long integer, the SBML Level to assign to this
CompartmentType.

Parameter 'version' is a long integer, the SBML Version to assign to
this CompartmentType.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    CompartmentType(CompartmentType orig)

Copy constructor; creates a copy of this CompartmentType object.

Parameter 'orig' is the object to copy.
";


%feature("docstring") CompartmentType::accept "
Internal implementation method.
";


%feature("docstring") CompartmentType::clone "
Creates and returns a deep copy of this CompartmentType object.

Returns the (deep) copy of this CompartmentType object.
";


%feature("docstring") CompartmentType::getId "
Returns the value of the 'id' attribute of this CompartmentType.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
getIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns the id of this CompartmentType.

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") CompartmentType::getName "
Returns the value of the 'name' attribute of this CompartmentType
object.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns the name of this SBML object, or the empty string if not set
or unsettable.

See also getIdAttribute(), isSetName(), setName(), unsetName().
";


%feature("docstring") CompartmentType::isSetId "
Predicate returning 'True' if this CompartmentType object's 'id'
attribute is set.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
isSetIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns 'True' if the 'id' attribute of this SBML object is set,
'False' otherwise.

See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
isSetIdAttribute().
";


%feature("docstring") CompartmentType::isSetName "
Predicate returning 'True' if this CompartmentType object's 'name'
attribute is set.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns 'True' if the 'name' attribute of this SBML object is set,
'False' otherwise.

See also getName(), setName(), unsetName().
";


%feature("docstring") CompartmentType::setId "
Sets the value of the 'id' attribute of this CompartmentType.

The string 'sid' is copied.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Parameter 'sid' is the string to use as the identifier of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") CompartmentType::setName "
Sets the value of the 'name' attribute of this CompartmentType.

The string in 'name' is copied.

Parameter 'name' is the new name for the SBML object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") CompartmentType::unsetName "
Unsets the value of the 'name' attribute of this CompartmentType
object.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also getName(), setName(), isSetName().
";


%feature("docstring") CompartmentType::getTypeCode "
Returns the libSBML type code for this SBML object.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for this object: SBML_COMPARTMENT_TYPE
(default).

WARNING:

The specific integer values of the possible type codes may be reused
by different libSBML plug-ins for SBML Level 3. packages,  To fully
identify the correct code, it is necessary to invoke both
getTypeCode() and getPackageName().

See also getElementName(), getPackageName().
";


%feature("docstring") CompartmentType::getElementName "
Returns the XML element name of this object

For CompartmentType, the element name is always ''compartmentType'.'

Returns the name of this element.

See also getTypeCode(), getPackageName().
";


%feature("docstring") CompartmentType::writeElements "
Internal implementation method.
";


%feature("docstring") CompartmentType::hasRequiredAttributes "
Predicate returning 'True' if all the required attributes for this
CompartmentType object have been set.

The required attributes for a CompartmentType object are:

* 'id'

Returns 'True' if the required attributes have been set, 'False'
otherwise.
";


%feature("docstring") CompartmentType::addExpectedAttributes "
Internal implementation method.
";


%feature("docstring") CompartmentType::readAttributes "
Internal implementation method.
";


%feature("docstring") CompartmentType::readL2Attributes "
Internal implementation method.
";


%feature("docstring") CompartmentType::writeAttributes "
Internal implementation method.
";


%feature("docstring") ListOfCompartmentTypes::ListOfCompartmentTypes "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    ListOfCompartmentTypes(SBMLNamespaces sbmlns)

Creates a new ListOfCompartmentTypes object.

The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in
'sbmlns'.

Parameter 'sbmlns' is an SBMLNamespaces object that is used to
determine the characteristics of the ListOfCompartmentTypes object to
be created.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    ListOfCompartmentTypes(long level, long version)

Creates a new ListOfCompartmentTypes object.

The object is constructed such that it is valid for the given SBML
Level and Version combination.

Parameter 'level' is the SBML Level.

Parameter 'version' is the Version within the SBML Level.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.
";


%feature("docstring") ListOfCompartmentTypes::clone "
Creates and returns a deep copy of this ListOfCompartmentTypes object.

Returns the (deep) copy of this ListOfCompartmentTypes object.
";


%feature("docstring") ListOfCompartmentTypes::getItemTypeCode "
Returns the libSBML type code for the objects contained in this ListOf
(i.e., CompartmentType objects, if the list is non-empty).

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for the objects contained in this ListOf
instance: SBML_COMPARTMENT_TYPE (default).

See also getElementName(), getPackageName().
";


%feature("docstring") ListOfCompartmentTypes::getElementName "
Returns the XML element name of this object.

For ListOfCompartmentTypes, the XML element name is
''listOfCompartmentTypes'.'

Returns the name of this element, i.e., ''listOfCompartmentTypes'.'
";


%feature("docstring") ListOfCompartmentTypes::get "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    get(long n)

Get a CompartmentType object from the ListOfCompartmentTypes.

Parameter 'n' is the index number of the CompartmentType object to
get.

Returns the nth CompartmentType object in this ListOfCompartmentTypes.

See also size().

______________________________________________________________________
Method variant with the following signature:

    get(string sid)

Get a CompartmentType object from the ListOfCompartmentTypes based on
its identifier.

Parameter 'sid' is a string representing the identifier of the
CompartmentType object to get.

Returns CompartmentType object in this ListOfCompartmentTypes with the
given 'sid' or 'None' if no such CompartmentType object exists.

See also get(), size().
";


%feature("docstring") ListOfCompartmentTypes::remove "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    remove(long n)

Removes the nth item from this ListOfCompartmentTypes items and
returns a pointer to it.

The caller owns the returned item and is responsible for deleting it.

Parameter 'n' is the index of the item to remove.

See also size().

______________________________________________________________________
Method variant with the following signature:

    remove(string sid)

Removes item in this ListOfCompartmentTypes items with the given
identifier.

The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier 'sid', then
'None' is returned.

Parameter 'sid' is the identifier of the item to remove.

Returns the item removed.  As mentioned above, the caller owns the
returned item.
";


%feature("docstring") ListOfCompartmentTypes::getElementPosition "
Internal implementation method.
";


%feature("docstring") ListOfCompartmentTypes::createObject "
Internal implementation method.
";


%feature("docstring") SpeciesType "
A species type in SBML Level 2.

The term species type refers to reacting entities independent of
location.  These include simple ions (e.g., protons, calcium), simple
molecules (e.g., glucose, ATP), large molecules (e.g., RNA,
polysaccharides, and proteins), and others.

SBML Level 2 Versions 2-4 provide an explicit SpeciesType class of
object to enable Species objects of the same type to be related
together.  SpeciesType is a conceptual construct; the existence of
SpeciesType objects in a model has no effect on the model's numerical
interpretation.  Except for the requirement for uniqueness of
species/species type combinations located in compartments, simulators
and other numerical analysis software may ignore SpeciesType
definitions and references to them in a model.

There is no mechanism in SBML Level 2 for representing hierarchies of
species types.  One SpeciesType object cannot be the subtype of
another SpeciesType object; SBML provides no means of defining such
relationships.

As with other major structures in SBML, SpeciesType has a mandatory
attribute, 'id', used to give the species type an identifier.  The
identifier must be a text string conforming to the identifer syntax
permitted in SBML.  SpeciesType also has an optional 'name' attribute,
of type 'string.'  The 'id' and 'name' must be used according to the
guidelines described in the SBML specification (e.g., Section 3.3 in
the Level 2 Version 4 specification).

SpeciesType was introduced in SBML Level 2 Version 2.  It is not
available in SBML Level 1 nor in Level 3.

See also Species, ListOfSpeciesTypes, CompartmentType,
ListOfCompartmentTypes.
";


%feature("docstring") ListOfSpeciesTypes "
A list of SpeciesType objects.

The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  In libSBML's
implementation, ListOf___ classes are derived from the intermediate
utility class ListOf, which is not defined by the SBML specifications
but serves as a useful programmatic construct.  ListOf is itself is in
turn derived from SBase, which provides all of the various ListOf___
classes with common features defined by the SBML specification, such
as 'metaid' attributes and annotations.

The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level 2 Version 4):

  <?xml version=\"1.0\" encoding=\"UTF-8\"?>
  <sbml xmlns=\"http://www.sbml.org/sbml/level3/version1/core\" 
        level=\"3\" version=\"1\">
    <model id=\"My_Model\">
      <listOfFunctionDefinitions>
        <functionDefinition> ... </functionDefinition> 
      </listOfFunctionDefinitions>
      <listOfUnitDefinitions>
        <unitDefinition> ... </unitDefinition> 
      </listOfUnitDefinitions>
      <listOfCompartments>
        <compartment> ... </compartment> 
      </listOfCompartments>
      <listOfSpecies>
        <species> ... </species> 
      </listOfSpecies>
      <listOfParameters>
        <parameter> ... </parameter> 
      </listOfParameters>
      <listOfInitialAssignments>
        <initialAssignment> ... </initialAssignment> 
      </listOfInitialAssignments>
      <listOfRules>
        ... elements of subclasses of Rule ...
      </listOfRules>
      <listOfConstraints>
        <constraint> ... </constraint> 
      </listOfConstraints>
      <listOfReactions>
        <reaction> ... </reaction> 
      </listOfReactions>
      <listOfEvents>
        <event> ... </event> 
      </listOfEvents>
    </model>
  </sbml>

SBML Level 3 Version 1 has essentially the same structure as  Level
2 Version 4, depicted above, but SBML Level 3  Version 2 allows
containers to contain zero or more of the relevant object, instead of
requiring at least one.  As such, libsbml will write out an
otherwise-empty ListOf___ element that has any optional attribute set
(such as 'id' or 'metaid'), that has an optional child (such  as a
'notes' or 'annotation'), or that has attributes or children set from
any SBML Level 3 package, whether or not the ListOf___ has  any other
children.

Readers may wonder about the motivations for using the ListOf___
containers in SBML.  A simpler approach in XML might be to place the
components all directly at the top level of the model definition.  The
choice made in SBML is to group them within XML elements named after
ListOfClassname, in part because it helps organize the components.
More importantly, the fact that the container classes are derived from
SBase means that software tools can add information about the lists
themselves into each list container's 'annotation'.

See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.
";


%feature("docstring") SpeciesType::SpeciesType "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    SpeciesType(SBMLNamespaces sbmlns)

Creates a new SpeciesType using the given SBMLNamespaces object
'sbmlns'.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level 2 and beyond, the 'id'
(identifier) attribute of a SpeciesType object is required to have a
value. Thus, callers are cautioned to assign a value after calling
this constructor.  Setting the identifier can be accomplished using
the method SBase.setId().

Parameter 'sbmlns' is an SBMLNamespaces object.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    SpeciesType(long level, long version)

Creates a new SpeciesType using the given SBML 'level' and 'version'
values.

Parameter 'level' is a long integer, the SBML Level to assign to this
SpeciesType.

Parameter 'version' is a long integer, the SBML Version to assign to
this SpeciesType.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    SpeciesType(SpeciesType orig)

Copy constructor; creates a copy of this SpeciesType.

Parameter 'orig' is the object to copy.
";


%feature("docstring") SpeciesType::accept "
Internal implementation method.
";


%feature("docstring") SpeciesType::clone "
Creates and returns a deep copy of this SpeciesType object.

Returns the (deep) copy of this SpeciesType object.
";


%feature("docstring") SpeciesType::getId "
Returns the value of the 'id' attribute of this SpeciesType.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
getIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns the id of this SpeciesType.

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") SpeciesType::getName "
Returns the value of the 'name' attribute of this SpeciesType object.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns the name of this SBML object, or the empty string if not set
or unsettable.

See also getIdAttribute(), isSetName(), setName(), unsetName().
";


%feature("docstring") SpeciesType::isSetId "
Predicate returning 'True' if this SpeciesType's 'id' attribute is
set.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
isSetIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns 'True' if the 'id' attribute of this SBML object is set,
'False' otherwise.

See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
isSetIdAttribute().
";


%feature("docstring") SpeciesType::isSetName "
Predicate returning 'True' if this SpeciesType's 'name' attribute is
set.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns 'True' if the 'name' attribute of this SBML object is set,
'False' otherwise.

See also getName(), setName(), unsetName().
";


%feature("docstring") SpeciesType::setId "
Sets the value of the 'id' attribute of this SpeciesType.

The string 'sid' is copied.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Parameter 'sid' is the string to use as the identifier of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") SpeciesType::setName "
Sets the value of the 'name' attribute of this SpeciesType.

The string in 'name' is copied.

Parameter 'name' is the new name for the SBML object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") SpeciesType::unsetName "
Unsets the value of the 'name' attribute of this SpeciesType.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also getName(), setName(), isSetName().
";


%feature("docstring") SpeciesType::getTypeCode "
Returns the libSBML type code for this SBML object.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for this object: SBML_SPECIES_TYPE
(default).

WARNING:

The specific integer values of the possible type codes may be reused
by different libSBML plug-ins for SBML Level 3. packages,  To fully
identify the correct code, it is necessary to invoke both
getTypeCode() and getPackageName().

See also getElementName(), getPackageName().
";


%feature("docstring") SpeciesType::getElementName "
Returns the XML element name of this object, which for SpeciesType, is
always ''compartmentType'.'

Returns the name of this element, i.e., ''compartmentType'.'
";


%feature("docstring") SpeciesType::writeElements "
Internal implementation method.
";


%feature("docstring") SpeciesType::hasRequiredAttributes "
Predicate returning 'True' if all the required attributes for this
SpeciesType object have been set.

The required attributes for a SpeciesType object are:

* 'id'

Returns 'True' if the required attributes have been set, 'False'
otherwise.
";


%feature("docstring") SpeciesType::addExpectedAttributes "
Internal implementation method.
";


%feature("docstring") SpeciesType::readAttributes "
Internal implementation method.
";


%feature("docstring") SpeciesType::readL2Attributes "
Internal implementation method.
";


%feature("docstring") SpeciesType::writeAttributes "
Internal implementation method.
";


%feature("docstring") ListOfSpeciesTypes::ListOfSpeciesTypes "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    ListOfSpeciesTypes(SBMLNamespaces sbmlns)

Creates a new ListOfSpeciesTypes object.

The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in
'sbmlns'.

Parameter 'sbmlns' is an SBMLNamespaces object that is used to
determine the characteristics of the ListOfSpeciesTypes object to be
created.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    ListOfSpeciesTypes(long level, long version)

Creates a new ListOfSpeciesTypes object.

The object is constructed such that it is valid for the given SBML
Level and Version combination.

Parameter 'level' is the SBML Level.

Parameter 'version' is the Version within the SBML Level.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.
";


%feature("docstring") ListOfSpeciesTypes::clone "
Creates and returns a deep copy of this ListOfSpeciesTypes object.

Returns the (deep) copy of this ListOfSpeciesTypes object.
";


%feature("docstring") ListOfSpeciesTypes::getItemTypeCode "
Returns the libSBML type code for the objects contained in this ListOf
(i.e., SpeciesType objects, if the list is non-empty).

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for objects contained in this list:
SBML_SPECIES_TYPE (default).

See also getElementName(), getPackageName().
";


%feature("docstring") ListOfSpeciesTypes::getElementName "
Returns the XML element name of this object.

For ListOfSpeciesTypes, the XML element name is
''listOfSpeciesTypes'.'

Returns the name of this element, i.e., ''listOfSpeciesTypes'.'
";


%feature("docstring") ListOfSpeciesTypes::get "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    get(long n)

Get a SpeciesType from the ListOfSpeciesTypes.

Parameter 'n' is the index number of the SpeciesType to get.

Returns the nth SpeciesType in this ListOfSpeciesTypes.

See also size().

______________________________________________________________________
Method variant with the following signature:

    get(string sid)

Get a SpeciesType from the ListOfSpeciesTypes based on its identifier.

Parameter 'sid' is a string representing the identifier  of the
SpeciesType to get.

Returns SpeciesType in this ListOfSpeciesTypes with the given 'sid' or
'None' if no such SpeciesType exists.

See also get(), size().
";


%feature("docstring") ListOfSpeciesTypes::remove "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    remove(long n)

Removes the nth item from this ListOfSpeciesTypes items and returns a
pointer to it.

The caller owns the returned item and is responsible for deleting it.

Parameter 'n' is the index of the item to remove.

See also size().

______________________________________________________________________
Method variant with the following signature:

    remove(string sid)

Removes item in this ListOfSpeciesTypes items with the given
identifier.

The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier 'sid', then
'None' is returned.

Parameter 'sid' is the identifier of the item to remove.

Returns the item removed.  As mentioned above, the caller owns the
returned item.
";


%feature("docstring") ListOfSpeciesTypes::getElementPosition "
Internal implementation method.
";


%feature("docstring") ListOfSpeciesTypes::createObject "
Internal implementation method.
";


%feature("docstring") Compartment "
An SBML compartment, where species are located.

A compartment in SBML represents a bounded space in which species are
located.  Compartments do not necessarily have to correspond to actual
structures inside or outside of a biological cell.

It is important to note that although compartments are optional in the
overall definition of Model, every species in an SBML model must be
located in a compartment.  This in turn means that if a model defines
any species, the model must also define at least one compartment.  The
reason is simply that species represent physical things, and therefore
must exist somewhere.  Compartments represent the somewhere.

Compartment has one required attribute, 'id', to give the compartment
a unique identifier by which other parts of an SBML model definition
can refer to it.  A compartment can also have an optional 'name'
attribute of type 'string.'  Identifiers and names must be used
according to the guidelines described in the SBML specifications.

Compartment also has an optional attribute 'spatialDimensions' that is
used to indicate the number of spatial dimensions possessed by the
compartment.  Most modeling scenarios involve compartments with
integer values of 'spatialDimensions' of '3' (i.e., a three-
dimensional compartment, which is to say, a volume), or 2 (a two-
dimensional compartment, a surface), or '1' (a one-dimensional
compartment, a line).  In SBML Level 3, the type of this attribute is
'float,' there are no restrictions on the permitted values of the
'spatialDimensions' attribute, and there are no default values.  In
SBML Level 2, the value must be a positive 'integer,' and the default
value is '3;' the permissible values in SBML Level 2 are '3,' '2,'
'1,' and '0' (for a point).

Another optional attribute on Compartment is 'size', representing the
initial total size of that compartment in the model.  The 'size'
attribute must be a floating-point value and may represent a volume
(if the compartment is a three-dimensional one), or an area (if the
compartment is two-dimensional), or a length (if the compartment is
one-dimensional). There is no default value of compartment size in
SBML Level 2 or Level 3.  In particular, a missing 'size' value does
not imply that the compartment size is 1.  (This is unlike the
definition of compartment 'volume' in SBML Level 1.)  When the
compartment's 'spatialDimensions' attribute does not have a value of
'0,' a missing value of 'size' for a given compartment signifies that
the value either is unknown, or to be obtained from an external
source, or determined by an InitialAssignment, AssignmentRule,
AlgebraicRule or RateRule object elsewhere in the model.  In SBML
Level 2, there are additional special requirements on the values of
'size'; we discuss them in a separate section below.

The units associated with a compartment's 'size' attribute value may
be set using the optional attribute 'units'.  The rules for setting
and using compartment size units differ between SBML Level 2 and Level
3, and are discussed separately below.

Finally, the Compartment attribute named 'constant' is used to
indicate whether the compartment's size stays constant after
simulation begins.  A value of 'True' indicates the compartment's
'size' cannot be changed by any other construct except
InitialAssignment; a value of 'False' indicates the compartment's
'size' can be changed by other constructs in SBML.  In SBML Level 2,
there is an additional explicit restriction that if
'spatialDimensions'=''0',' the value cannot be changed by
InitialAssignment either.  Further, in Level 2, 'constant' is
optional, and has a default value of 'True.'  In SBML Level 3, there
is no default value for the 'constant' attribute, and it is required.

Additional considerations in SBML Level 2
======================================================================

In SBML Level 2, the default units of compartment size, and the kinds
of units allowed as values of the attribute 'units', interact with the
number of spatial dimensions of the compartment.  The value of the
'units' attribute of a Compartment object must be one of the base
units (see Unit), or the predefined unit identifiers 'volume,' 'area,'
'length' or 'dimensionless,' or a new unit defined by a UnitDefinition
object in the enclosing Model, subject to the restrictions detailed in
the following table:

  +----------------------------+---------------+----------------+-----------------------------------+----------------------------------+
  | Value of spatialDimensions | size allowed? | units allowed? | Allowable kinds of units          | Default value of attribute units |
  +----------------------------+---------------+----------------+-----------------------------------+----------------------------------+
  | 3                          | yes           | yes            | units of volume, or dimensionless | volume                           |
  | 2                          | yes           | yes            | units of area, or dimensionless   | area                             |
  | 1                          | yes           | yes            | units of length, or dimensionless | length                           |
  | 0                          | no            | no             | (no units allowed)                |                                  |
  +----------------------------+---------------+----------------+-----------------------------------+----------------------------------+

In SBML Level 2, the units of the compartment size, as defined by
the 'units' attribute or (if 'units' is not set) the default value
listed in the table above, are used in the following ways when the
compartment has a 'spatialDimensions' value greater than '0:'

* The value of the 'units' attribute is used as the units of the
compartment identifier when the identifier appears as a numerical
quantity in a mathematical formula expressed in MathML.

* The 'math' element of an AssignmentRule or InitialAssignment
referring to this compartment must (in Level 2 Versions 1-3) or should
(in Level 2 Version 4) have identical units.

* In RateRule objects that set the rate of change of the compartment's
size, the units of the rule's 'math' element must (in Level 2
Versions 1-3) or should (in Level 2 Version 4) be identical to the
compartment's units (whether defined by the 'units' attribute or by
taking the  default value from the Model) divided by the default time
units. (In other words, the units for the rate of change of
compartment size are compartment size/time units.

* When a Species is to be treated in terms of concentrations or
density, the units of the spatial size portion of the concentration
value (i.e., the denominator in the units formula substance/size) are
those indicated by the value of the 'units' attribute on the
compartment in which the species is located. Compartments with
'spatialDimensions'='0' require special treatment in this framework.
As implied above, the 'size' attribute must not have a value on an
SBML Level 2 Compartment object if the 'spatialDimensions' attribute
has a value of '0.'  An additional related restriction is that the
'constant' attribute must default to or be set to 'True' if the value
of the 'spatialDimensions' attribute is '0,' because a zero-
dimensional compartment cannot ever have a size.

If a compartment has no size or dimensional units, how should such a
compartment's identifier be interpreted when it appears in
mathematical formulas?  The answer is that such a compartment's
identifier should not appear in mathematical formulas in the first
place---it has no value, and its value cannot change.  Note also that
a zero-dimensional compartment is a point, and species located at
points can only be described in terms of amounts, not spatially-
dependent measures such as concentration.  Since SBML KineticLaw
formulas are already in terms of substance/time and not (say)
concentration/time, volume or other factors in principle are not
needed for species located in zero-dimensional compartments.

Finally, in SBML Level 2 Versions 2-4, each compartment in a model may
optionally be designated as belonging to a particular compartment
type.  The optional attribute 'compartmentType' is used identify the
compartment type represented by the Compartment structure. The
'compartmentType' attribute's value must be the identifier of a
CompartmentType instance defined in the model.  If the
'compartmentType' attribute is not present on a particular compartment
definition, a unique virtual compartment type is assumed for that
compartment, and no other compartment can belong to that compartment
type.  The values of 'compartmentType' attributes on compartments have
no effect on the numerical interpretation of a model.  Simulators and
other numerical analysis software may ignore 'compartmentType'
attributes.  The 'compartmentType' attribute and the CompartmentType
class of objects are not present in SBML Level 3 Core nor in SBML
Level 1.

Additional considerations in SBML Level 3
======================================================================

One difference between SBML Level 3 and lower Levels of SBML is that
there are no restrictions on the permissible values of the
'spatialDimensions' attribute, and there is no default value defined
for the attribute.  The value of 'spatialDimensions' does not have to
be an integer, either; this is to allow for the possibility of
representing structures with fractal dimensions.

The number of spatial dimensions possessed by a compartment cannot
enter into mathematical formulas, and therefore cannot directly alter
the numerical interpretation of a model.  However, the value of
'spatialDimensions' does affect the interpretation of the units
associated with a compartment's size.  Specifically, the value of
'spatialDimensions' is used to select among the Model attributes
'volumeUnits', 'areaUnits' and 'lengthUnits' when a Compartment
structure does not define a value for its 'units' attribute.

The 'units' attribute may be left unspecified for a given compartment
in a model; in that case, the compartment inherits the unit of
measurement specified by one of the attributes on the enclosing Model
object instance.  The applicable attribute on Model depends on the
value of the compartment's 'spatialDimensions' attribute; the
relationship is shown in the table below.  If the Model object does
not define the relevant attribute ('volumeUnits', 'areaUnits' or
'lengthUnits') for a given 'spatialDimensions' value, the unit
associated with that Compartment object's size is undefined.  If a
given Compartment's 'units' are left unset and  the
'spatialDimensions' either has a value other than '1,' '2,' or  '3' or
is left unset itself (as it has no default value), then no unit can be
chosen from among the Model's 'volumeUnits', 'areaUnits' or
'lengthUnits' attributes (even if the Model instance provides values
for those attributes), because there is no basis to select between
them. Leaving the units of compartments' sizes undefined in an SBML
model does not render the model invalid; however, as a matter of best
practice, we strongly recommend that all models specify the units of
measurement for all compartment sizes.

  +----------------------------------------+-------------------------------------------------+-----------------------------------+
  | Value of attribute 'spatialDimensions' | Attribute of Model used for inheriting the unit | Recommended candidate units       |
  +----------------------------------------+-------------------------------------------------+-----------------------------------+
  | 3                                      | \"volumeUnits\"                                 | units of volume, or dimensionless |
  | 2                                      | \"areaUnits\"                                   | units of area, or dimensionless   |
  | 1                                      | \"lengthUnits\"                                 | units of length, or dimensionless |
  | other                                  | no units inherited                              | no specific recommendations       |
  +----------------------------------------+-------------------------------------------------+-----------------------------------+

The unit of measurement associated with a compartment's size, as
defined by the 'units' attribute or (if 'units' is not set) the
inherited value from Model according to the table above, is used in
the following ways:

* When the identifier of the compartment appears as a numerical
quantity in a mathematical formula expressed in MathML, it represents
the size of the compartment, and the unit associated with the size is
the value of the 'units' attribute.

* When a Species is to be treated in terms of concentrations or
density, the unit associated with the spatial size portion of the
concentration value (i.e., the denominator in the formula amount/size)
is specified by the value of the 'units' attribute on the compartment
in which the species is located.

* The 'math' elements of AssignmentRule, InitialAssignment and
EventAssignment objects setting the value of the compartment size
should all have the same units as the unit associated with the
compartment's size.

* In a RateRule object that defines a rate of change for a
compartment's size, the unit of the rule's 'math' element should be
identical to the compartment's 'units' attribute divided by the model-
wide unit of time.  (In other words, {unit of compartment size}/{unit
of time}.)

Other aspects of Compartment
======================================================================

In SBML Level 1 and Level 2, Compartment has an optional attribute
named 'outside', whose value can be the identifier of another
Compartment object defined in the enclosing Model object.  Doing so
means that the other compartment contains it or is outside of it.
This enables the representation of simple topological relationships
between compartments, for those simulation systems that can make use
of the information (e.g., for drawing simple diagrams of
compartments).  It is worth noting that in SBML, there is no
relationship between compartment sizes when compartment positioning is
expressed using the 'outside' attribute.  The size of a given
compartment does not in any sense include the sizes of other
compartments having it as the value of their 'outside' attributes.  In
other words, if a compartment B has the identifier of compartment A as
its 'outside' attribute value, the size of A does not include the size
of B.  The compartment sizes are separate.

In Level 2, there are two restrictions on the 'outside' attribute.
First, because a compartment with 'spatialDimensions' of '0' has no
size, such a compartment cannot act as the container of any other
compartment except compartments that also have 'spatialDimensions'
values of '0.'  Second, the directed graph formed by representing
Compartment structures as vertexes and the 'outside' attribute values
as edges must be acyclic.  The latter condition is imposed to prevent
a compartment from being contained inside itself.  In the absence of a
value for 'outside', compartment definitions in SBML Level 2 do not
have any implied spatial relationships between each other.
";


%feature("docstring") ListOfCompartments "
A list of Compartment objects.

The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  In libSBML's
implementation, ListOf___ classes are derived from the intermediate
utility class ListOf, which is not defined by the SBML specifications
but serves as a useful programmatic construct.  ListOf is itself is in
turn derived from SBase, which provides all of the various ListOf___
classes with common features defined by the SBML specification, such
as 'metaid' attributes and annotations.

The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level 2 Version 4):

  <?xml version=\"1.0\" encoding=\"UTF-8\"?>
  <sbml xmlns=\"http://www.sbml.org/sbml/level3/version1/core\" 
        level=\"3\" version=\"1\">
    <model id=\"My_Model\">
      <listOfFunctionDefinitions>
        <functionDefinition> ... </functionDefinition> 
      </listOfFunctionDefinitions>
      <listOfUnitDefinitions>
        <unitDefinition> ... </unitDefinition> 
      </listOfUnitDefinitions>
      <listOfCompartments>
        <compartment> ... </compartment> 
      </listOfCompartments>
      <listOfSpecies>
        <species> ... </species> 
      </listOfSpecies>
      <listOfParameters>
        <parameter> ... </parameter> 
      </listOfParameters>
      <listOfInitialAssignments>
        <initialAssignment> ... </initialAssignment> 
      </listOfInitialAssignments>
      <listOfRules>
        ... elements of subclasses of Rule ...
      </listOfRules>
      <listOfConstraints>
        <constraint> ... </constraint> 
      </listOfConstraints>
      <listOfReactions>
        <reaction> ... </reaction> 
      </listOfReactions>
      <listOfEvents>
        <event> ... </event> 
      </listOfEvents>
    </model>
  </sbml>

SBML Level 3 Version 1 has essentially the same structure as  Level
2 Version 4, depicted above, but SBML Level 3  Version 2 allows
containers to contain zero or more of the relevant object, instead of
requiring at least one.  As such, libsbml will write out an
otherwise-empty ListOf___ element that has any optional attribute set
(such as 'id' or 'metaid'), that has an optional child (such  as a
'notes' or 'annotation'), or that has attributes or children set from
any SBML Level 3 package, whether or not the ListOf___ has  any other
children.

Readers may wonder about the motivations for using the ListOf___
containers in SBML.  A simpler approach in XML might be to place the
components all directly at the top level of the model definition.  The
choice made in SBML is to group them within XML elements named after
ListOfClassname, in part because it helps organize the components.
More importantly, the fact that the container classes are derived from
SBase means that software tools can add information about the lists
themselves into each list container's 'annotation'.

See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.
";


%feature("docstring") Compartment::Compartment "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    Compartment(SBMLNamespaces sbmlns)

Creates a new Compartment object using the given SBMLNamespaces object
'sbmlns'.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level 2 and beyond, the 'id'
(identifier) attribute of a Compartment object is required to have a
value.  Thus, callers are cautioned to assign a value after calling
this constructor.  Setting the identifier can be accomplished using
the method setId().

Parameter 'sbmlns' is an SBMLNamespaces object.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    Compartment(long level, long version)

Creates a new Compartment object using the given SBML 'level' and
'version' values.

Parameter 'level' is a long integer, the SBML Level to assign to this
Compartment.

Parameter 'version' is a long integer, the SBML Version to assign to
this Compartment.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    Compartment(Compartment orig)

Copy constructor.

This creates a copy of a Compartment object.

Parameter 'orig' is the Compartment instance to copy.
";


%feature("docstring") Compartment::accept "
Internal implementation method.
";


%feature("docstring") Compartment::clone "
Creates and returns a deep copy of this Compartment object.

Returns the (deep) copy of this Compartment object.
";


%feature("docstring") Compartment::initDefaults "
Initializes the fields of this Compartment object to 'typical' default
values.

The SBML Compartment component has slightly different aspects and
default attribute values in different SBML Levels and Versions. This
method sets the values to certain common defaults, based mostly on
what they are in SBML Level 2.  Specifically:

* Sets attribute 'spatialDimensions' to '3'

* Sets attribute 'constant' to 'True'

* (Applies to Level 1 models only) Sets attribute 'volume' to '1.0'

* (Applies to Level 3 models only) Sets attribute 'units' to
'litre'
";


%feature("docstring") Compartment::getId "
Returns the value of the 'id' attribute of this Compartment.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
getIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns the id of this Compartment.

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") Compartment::getName "
Returns the value of the 'name' attribute of this Compartment object.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns the name of this SBML object, or the empty string if not set
or unsettable.

See also getIdAttribute(), isSetName(), setName(), unsetName().
";


%feature("docstring") Compartment::getCompartmentType "
Get the value of the 'compartmentType' attribute of this Compartment
object.

Returns the value of the 'compartmentType' attribute of this
Compartment object as a string.

Note: The 'compartmentType' attribute is only available in SBML Level
2 Versions 2-4.

See also isSetCompartmentType(), setCompartmentType(),
unsetCompartmentType().
";


%feature("docstring") Compartment::getSpatialDimensions "
Get the number of spatial dimensions of this Compartment object.

Returns the value of the 'spatialDimensions' attribute of this
Compartment object as a long integereger.

Note: In SBML Level 3, the data type of the 'spatialDimensions'
attribute is 'float,' whereas in Level 2, it is 'integer.'  To avoid
backward compatibility issues, libSBML provides two separate methods
for obtaining the value as either an integer or a type 'float,' for
models where it is relevant.

See also getSpatialDimensionsAsDouble(), setSpatialDimensions(),
isSetSpatialDimensions(), unsetSpatialDimensions().
";


%feature("docstring") Compartment::getSpatialDimensionsAsDouble "
Get the number of spatial dimensions of this Compartment object, as a
double.

Returns the value of the 'spatialDimensions' attribute of this
Compartment object as a double, or 'NaN' if this model is not in SBML
Level 3 format.

Note: In SBML Level 3, the data type of the 'spatialDimensions'
attribute is 'float,' whereas in Level 2, it is 'integer.'  To avoid
backward compatibility issues, libSBML provides two separate methods
for obtaining the value as either an integer or a type 'float,' for
models where it is relevant.

See also getSpatialDimensions(), setSpatialDimensions(),
isSetSpatialDimensions(), unsetSpatialDimensions().
";


%feature("docstring") Compartment::getSize "
Get the size of this Compartment object.

In SBML Level 1, compartments are always three-dimensional constructs
and only have volumes, whereas in SBML Level 2 and higher,
compartments may be other than three-dimensional, and therefore the
'volume' attribute is named 'size' in Level 2 and above.  LibSBML
provides both getSize() and getVolume() for easier support of
different SBML Levels.

Returns the value of the 'size' attribute ('volume' in Level 1) of
this Compartment object as a floating-point number.

Note: This method is identical to getVolume().

See also getVolume(), isSetSize(), setSize(), unsetSize().
";


%feature("docstring") Compartment::getVolume "
Get the volume of this Compartment object.

In SBML Level 1, compartments are always three-dimensional constructs
and only have volumes, whereas in SBML Level 2 and higher,
compartments may be other than three-dimensional, and therefore the
'volume' attribute is named 'size' in Level 2 and above.  LibSBML
provides both getSize() and getVolume() for easier support of
different SBML Levels.

Returns the value of the 'volume' attribute ('size' in Level 2) of
this Compartment object, as a floating-point number.

Note: The attribute 'volume' only exists by that name in SBML Level 1.
In Level 2 and above, the equivalent attribute is named 'size'.  In
SBML Level 1, a compartment's volume has a default value ('1.0)' and
therefore methods such as isSetVolume() will always return 'True' for
a Level 1 model.  In Level 2, a compartment's size (the equivalent of
SBML Level 1's 'volume') is optional and has no default value, and
therefore may or may not be set.

Note: This method is identical to getSize().

See also getSize(), isSetVolume(), setVolume(), unsetVolume().
";


%feature("docstring") Compartment::getUnits "
Get the units of this Compartment object's size.

The value of an SBML compartment's 'units' attribute establishes the
unit of measurement associated with the compartment's size.

Returns the value of the 'units' attribute of this Compartment object,
as a string.  An empty string indicates that no units have been
assigned to the value of the size.

Note: There is an important distinction to be made between no units
assigned, and assuming a value without units has any specific unit
such as dimensionless.  In SBML, default units are never attributed to
numbers, and numbers without units are not automatically assumed to
have the unit dimensionless.  Please consult the relevant SBML
specification document for a more in-depth explanation of this topic
and the SBML unit system.

See also isSetUnits(), setUnits(), unsetUnits().
";


%feature("docstring") Compartment::getOutside "
Get the identifier, if any, of the Compartment object that is
designated as being outside of this one.

Returns the value of the 'outside' attribute of this Compartment
object.

Note: The 'outside' attribute is defined in SBML Level 1 and Level 2,
but does not exist in SBML Level 3.

See also isSetOutside(), setOutside(), unsetOutside().
";


%feature("docstring") Compartment::getConstant "
Get the value of the 'constant' attribute of this Compartment object.

Returns 'True' if this Compartment object's size is flagged as being
constant, 'False' otherwise.

See also isSetConstant(), setConstant().
";


%feature("docstring") Compartment::isSetId "
Predicate returning 'True' if this Compartment object's 'id' attribute
is set.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
isSetIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns 'True' if the 'id' attribute of this SBML object is set,
'False' otherwise.

See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
isSetIdAttribute().
";


%feature("docstring") Compartment::isSetName "
Predicate returning 'True' if this Compartment object's 'name'
attribute is set.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns 'True' if the 'name' attribute of this SBML object is set,
'False' otherwise.

See also getName(), setName(), unsetName().
";


%feature("docstring") Compartment::isSetCompartmentType "
Predicate returning 'True' if this Compartment object's
'compartmentType' attribute is set.

Returns 'True' if the 'compartmentType' attribute of this Compartment
is set, 'False' otherwise.

Note: The 'compartmentType' attribute is only available in SBML Level
2 Versions 2-4.

See also setCompartmentType(), getCompartmentType(),
unsetCompartmentType().
";


%feature("docstring") Compartment::isSetSize "
Predicate returning 'True' if this Compartment object's 'size'
attribute is set.

This method is similar but not identical to isSetVolume().  The latter
should be used in the context of SBML Level 1 models instead of
isSetSize() because isSetVolume() performs extra processing to take
into account the difference in default values between SBML Levels 1
and 2.

Returns 'True' if the 'size' attribute ('volume' in Level 2) of this
Compartment object is set, 'False' otherwise.

See also isSetVolume(), setSize(), getSize(), unsetSize().
";


%feature("docstring") Compartment::isSetVolume "
Predicate returning 'True' if this Compartment object's 'volume'
attribute is set.

This method is similar but not identical to isSetSize().  The latter
should not be used in the context of SBML Level 1 models because the
present method performs extra processing to take into account the
difference in default values between SBML Levels 1 and 2.

Returns 'True' if the 'volume' attribute ('size' in Level 2 and above)
of this Compartment object is set, 'False' otherwise.

Note: The attribute 'volume' only exists by that name in SBML Level 1.
In Level 2 and above, the equivalent attribute is named 'size'.  In
SBML Level 1, a compartment's volume has a default value ('1.0)' and
therefore methods such as isSetVolume() will always return 'True' for
a Level 1 model.  In Level 2, a compartment's size (the equivalent of
SBML Level 1's 'volume') is optional and has no default value, and
therefore may or may not be set.

See also isSetSize(), getVolume(), setVolume(), unsetVolume().
";


%feature("docstring") Compartment::isSetUnits "
Predicate returning 'True' if this Compartment object's 'units'
attribute is set.

Returns 'True' if the 'units' attribute of this Compartment object is
set, 'False' otherwise.

Note: There is an important distinction to be made between no units
assigned, and assuming a value without units has any specific unit
such as dimensionless.  In SBML, default units are never attributed to
numbers, and numbers without units are not automatically assumed to
have the unit dimensionless.  Please consult the relevant SBML
specification document for a more in-depth explanation of this topic
and the SBML unit system.

See also setUnits(), getUnits(), unsetUnits().
";


%feature("docstring") Compartment::isSetOutside "
Predicate returning 'True' if this Compartment object's 'outside'
attribute is set.

Returns 'True' if the 'outside' attribute of this Compartment object
is set, 'False' otherwise.

Note: The 'outside' attribute is defined in SBML Level 1 and Level 2,
but does not exist in SBML Level 3.

See also getOutside(), setOutside(), unsetOutside().
";


%feature("docstring") Compartment::isSetSpatialDimensions "
Predicate returning 'True' if this Compartment object's
'spatialDimensions' attribute is set.

Returns 'True' if the 'spatialDimensions' attribute of this
Compartment object is set, 'False' otherwise.

See also getSpatialDimensions(), setSpatialDimensions(),
unsetSpatialDimensions().
";


%feature("docstring") Compartment::isSetConstant "
Predicate returning 'True' if this Compartment object's 'constant'
attribute is set.

Returns 'True' if the 'constant' attribute of this Compartment object
is set, 'False' otherwise.

See also getConstant(), setConstant().
";


%feature("docstring") Compartment::setId "
Sets the value of the 'id' attribute of this Compartment object.

The string 'sid' is copied.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Parameter 'sid' is the string to use as the identifier of this
Compartment object. If the string is 'None,' this method will return
LIBSBML_INVALID_ATTRIBUTE_VALUE.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

See also getId(), unsetId(), isSetId().
";


%feature("docstring") Compartment::setName "
Sets the value of the 'name' attribute of this Compartment object.

The string in 'name' is copied.

Parameter 'name' is the new name for the SBML object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") Compartment::setCompartmentType "
Sets the 'compartmentType' attribute of this Compartment object.

Parameter 'sid' is the identifier of a CompartmentType object defined
elsewhere in this Model. If the string is 'None,' this method will
return LIBSBML_INVALID_ATTRIBUTE_VALUE.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

Note: The 'compartmentType' attribute is only available in SBML Level
2 Versions 2-4.

See also isSetCompartmentType(), getCompartmentType(),
unsetCompartmentType().
";


%feature("docstring") Compartment::setSpatialDimensions "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    setSpatialDimensions(double value)

Sets the 'spatialDimensions' attribute of this Compartment object as a
double.

Parameter 'value' is a double indicating the number of dimensions of
this compartment.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

See also getSpatialDimensions(), isSetSpatialDimensions(),
unsetSpatialDimensions().

______________________________________________________________________
Method variant with the following signature:

    setSpatialDimensions(long value)

Sets the 'spatialDimensions' attribute of this Compartment object.

Parameter 'value' is a long integereger indicating the number of
dimensions of this compartment.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

See also getSpatialDimensions(), isSetSpatialDimensions(),
unsetSpatialDimensions().
";


%feature("docstring") Compartment::setSize "
Sets the 'size' attribute (or 'volume' in SBML Level 1) of this
Compartment object.

Parameter 'value' is a 'float' representing the size of this
compartment instance in whatever units are in effect for the
compartment.

Returns integer value indicating success/failure of the function.
This particular function only does one thing irrespective of user
input or  object state, and thus will only return a single value:

* LIBSBML_OPERATION_SUCCESS

Note: This method is identical to setVolume().

See also setVolume(), getSize(), isSetSize(), unsetSize().
";


%feature("docstring") Compartment::setVolume "
Sets the 'volume' attribute (or 'size' in SBML Level 2) of this
Compartment object.

This method is identical to setSize() and is provided for
compatibility between SBML Level 1 and higher Levels of SBML.

Parameter 'value' is a 'float' representing the volume of this
compartment instance in whatever units are in effect for the
compartment.

Returns integer value indicating success/failure of the function.
This particular function only does one thing irrespective of user
input or  object state, and thus will only return a single value:

* LIBSBML_OPERATION_SUCCESS

Note: The attribute 'volume' only exists by that name in SBML Level 1.
In Level 2 and above, the equivalent attribute is named 'size'.  In
SBML Level 1, a compartment's volume has a default value ('1.0)' and
therefore methods such as isSetVolume() will always return 'True' for
a Level 1 model.  In Level 2, a compartment's size (the equivalent of
SBML Level 1's 'volume') is optional and has no default value, and
therefore may or may not be set.

See also setSize(), getVolume(), isSetVolume(), unsetVolume().
";


%feature("docstring") Compartment::setUnits "
Sets the 'units' attribute of this Compartment object.

Parameter 'sid' is the identifier of the defined units to use.  If
'sid' is 'None,' then this method will return
LIBSBML_INVALID_ATTRIBUTE_VALUE.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

See also isSetUnits(), getUnits(), unsetUnits().
";


%feature("docstring") Compartment::setOutside "
Sets the 'outside' attribute of this Compartment object.

Parameter 'sid' is the identifier of a compartment that encloses this
one. If 'sid' is 'None,' then this method will return
LIBSBML_INVALID_ATTRIBUTE_VALUE.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

Note: The 'outside' attribute is defined in SBML Level 1 and Level 2,
but does not exist in SBML Level 3.

See also isSetOutside(), getOutside(), unsetOutside().
";


%feature("docstring") Compartment::setConstant "
Sets the value of the 'constant' attribute of this Compartment object.

Parameter 'value' is a boolean indicating whether the size/volume of
this compartment should be considered constant ('True)' or variable
('False).'

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

See also isSetConstant(), getConstant().
";


%feature("docstring") Compartment::renameSIdRefs "
Replaces all uses of a given 'SIdRef' type attribute value with
another value.

In SBML, object identifiers are of a data type called SId. In SBML
Level 3, an explicit data type called SIdRef was introduced for
attribute values that refer to SId values; in previous Levels of SBML,
this data type did not exist and attributes were simply described to
as 'referring to an identifier', but the effective data type was the
same as SIdRef in Level 3.  These and other methods of libSBML refer
to the type SIdRef for all Levels of SBML, even if the corresponding
SBML specification did not explicitly name the data type.

This method works by looking at all attributes and (if appropriate)
mathematical formulas in MathML content, comparing the referenced
identifiers to the value of 'oldid'.  If any matches are found, the
matching values are replaced with 'newid'.  The method does not
descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") Compartment::renameUnitSIdRefs "
Replaces all uses of a given 'UnitSIdRef' type attribute value with
another value.

In SBML, unit definitions have identifiers of type UnitSId.  In SBML
Level 3, an explicit data type called UnitSIdRef was introduced for
attribute values that refer to UnitSId values; in previous Levels of
SBML, this data type did not exist and attributes were simply
described to as 'referring to a unit identifier', but the effective
data type was the same as UnitSIdRef in Level 3.  These and other
methods of libSBML refer to the type UnitSIdRef for all Levels of
SBML, even if the corresponding SBML specification did not explicitly
name the data type.

This method works by looking at all unit identifier attribute values
(including, if appropriate, inside mathematical formulas), comparing
the referenced unit identifiers to the value of 'oldid'.  If any
matches are found, the matching values are replaced with 'newid'.  The
method does not descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") Compartment::unsetName "
Unsets the value of the 'name' attribute of this Compartment object.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also getName(), setName(), isSetName().
";


%feature("docstring") Compartment::unsetCompartmentType "
Unsets the value of the 'compartmentType' attribute of this
Compartment object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

* LIBSBML_UNEXPECTED_ATTRIBUTE

Note: The 'compartmentType' attribute is only available in SBML Level
2 Versions 2-4.

See also setCompartmentType(), isSetCompartmentType(),
getCompartmentType().
";


%feature("docstring") Compartment::unsetConstant "
Unsets the value of the 'constant' attribute of this Compartment
object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also isSetConstant(), setConstant(), getConstant().
";


%feature("docstring") Compartment::unsetSize "
Unsets the value of the 'size' attribute of this Compartment object.

In SBML Level 1, a compartment's volume has a default value ('1.0)'
and therefore should always be set.  Calling this method on a Level 1
model resets the value to '1.0' rather than actually unsetting it.  In
Level 2, a compartment's 'size' is optional with no default value, and
unsetting it will result in the compartment having no defined size.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

Note: This method is identical to unsetVolume().

See also unsetVolume(), getSize(), isSetSize(), setSize().
";


%feature("docstring") Compartment::unsetVolume "
Unsets the value of the 'volume' attribute of this Compartment object.

This method is identical to unsetSize().  Please refer to that
method's documentation for more information about its behavior.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

Note: The attribute 'volume' only exists by that name in SBML Level 1.
In Level 2 and above, the equivalent attribute is named 'size'.  In
SBML Level 1, a compartment's volume has a default value ('1.0)' and
therefore methods such as isSetVolume() will always return 'True' for
a Level 1 model.  In Level 2, a compartment's size (the equivalent of
SBML Level 1's 'volume') is optional and has no default value, and
therefore may or may not be set.

See also unsetSize(), getVolume(), setVolume(), isSetVolume().
";


%feature("docstring") Compartment::unsetUnits "
Unsets the value of the 'units' attribute of this Compartment object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also isSetUnits(), setUnits(), getUnits().
";


%feature("docstring") Compartment::unsetOutside "
Unsets the value of the 'outside' attribute of this Compartment
object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

Note: The 'outside' attribute is defined in SBML Level 1 and Level 2,
but does not exist in SBML Level 3.

See also isSetOutside(), getOutside(), setOutside().
";


%feature("docstring") Compartment::unsetSpatialDimensions "
Unsets the value of the 'spatialDimensions' attribute of this
Compartment object.

In SBML Levels prior to Level 3, compartments must always have a value
for the number of dimensions.  Consequently, calling this method on a
model of SBML Level 1-2 will result in a return value of
LIBSBML_UNEXPECTED_ATTRIBUTE

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

* LIBSBML_UNEXPECTED_ATTRIBUTE

Note: This function is only valid for SBML Level 3.

See also getSpatialDimensions(), isSetSpatialDimensions(),
setSpatialDimensions().
";


%feature("docstring") Compartment::getDerivedUnitDefinition "
Constructs and returns a UnitDefinition that corresponds to the units
of this Compartment object's designated size.

Compartments in SBML have an attribute ('units') for declaring the
units of measurement intended for the value of the compartment's size.
In the absence of a value given for this attribute, the units are
inherited from values either defined on the enclosing Model (in SBML
Level 3) or in defaults (in SBML Level 2).  This method returns a
UnitDefinition object based on how this compartment's units are
interpreted according to the relevant SBML guidelines, or it returns
'None' if no units have been declared and no defaults are defined by
the relevant SBML specification.

Note that unit declarations for Compartment objects  are specified in
terms of the identifier of a unit, but this method returns an object ,
not a unit identifier.  It does this by constructing an appropriate
UnitDefinition object.  For SBML Level 2 models, it will do this even
when the value of the 'units' attribute is one of the special SBML
Level 2 unit identifiers ''substance',' ''volume',' ''area','
''length'' or ''time'.'  Callers may find this useful in conjunction
with the helper methods provided by the UnitDefinition class for
comparing different UnitDefinition objects.

Returns a UnitDefinition that expresses the units of this Compartment
object, or 'None' if one cannot be constructed.

Note: The libSBML system for unit analysis depends on the model as a
whole.  In cases where the Compartment object has not yet been added
to a model, or the model itself is incomplete, unit analysis is not
possible, and consequently this method will return 'None.'

See also isSetUnits(), getUnits().
";


%feature("docstring") Compartment::getTypeCode "
Returns the libSBML type code for this SBML object.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for this object: SBML_COMPARTMENT
(default).

WARNING:

The specific integer values of the possible type codes may be reused
by different libSBML plug-ins for SBML Level 3. packages,  To fully
identify the correct code, it is necessary to invoke both
getTypeCode() and getPackageName().

See also getElementName(), getPackageName().
";


%feature("docstring") Compartment::getElementName "
Returns the XML element name of this object

For Compartment, the XML element name is always ''compartment'.'

Returns the name of this element.
";


%feature("docstring") Compartment::writeElements "
Internal implementation method.
";


%feature("docstring") Compartment::hasRequiredAttributes "
Predicate returning 'True' if all the required attributes for this
Compartment object have been set.

The required attributes for a Compartment object are:

* 'id' (or 'name' in SBML Level 1)

* 'constant' (in SBML Level 3 only)

Returns 'True' if the required attributes have been set, 'False'
otherwise.
";


%feature("docstring") Compartment::addExpectedAttributes "
Internal implementation method.
";


%feature("docstring") Compartment::readAttributes "
Internal implementation method.
";


%feature("docstring") Compartment::readL1Attributes "
Internal implementation method.
";


%feature("docstring") Compartment::readL2Attributes "
Internal implementation method.
";


%feature("docstring") Compartment::readL3Attributes "
Internal implementation method.
";


%feature("docstring") Compartment::writeAttributes "
Internal implementation method.
";


%feature("docstring") Compartment::isExplicitlySetSpatialDimensions "
Internal implementation method.
";


%feature("docstring") Compartment::isExplicitlySetConstant "
Internal implementation method.
";


%feature("docstring") ListOfCompartments::ListOfCompartments "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    ListOfCompartments(SBMLNamespaces sbmlns)

Creates a new ListOfCompartments object.

The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in
'sbmlns'.

Parameter 'sbmlns' is an SBMLNamespaces object that is used to
determine the characteristics of the ListOfCompartments object to be
created.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    ListOfCompartments(long level, long version)

Creates a new ListOfCompartments object.

The object is constructed such that it is valid for the given SBML
Level and Version combination.

Parameter 'level' is the SBML Level.

Parameter 'version' is the Version within the SBML Level.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.
";


%feature("docstring") ListOfCompartments::clone "
Creates and returns a deep copy of this ListOfCompartments object.

Returns the (deep) copy of this ListOfCompartments object.
";


%feature("docstring") ListOfCompartments::getItemTypeCode "
Returns the libSBML type code for the objects contained in this ListOf
(i.e., Compartment objects, if the list is non-empty).

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for the objects contained in this ListOf
instance: SBML_COMPARTMENT (default).

See also getElementName(), getPackageName().
";


%feature("docstring") ListOfCompartments::getElementName "
Returns the XML element name of this object.

For ListOfCompartments, the XML element name is always
''listOfCompartments'.'

Returns the name of this element.
";


%feature("docstring") ListOfCompartments::get "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    get(long n)

Get a Compartment object from the ListOfCompartments.

Parameter 'n' is the index number of the Compartment object to get.

Returns the nth Compartment object in this ListOfCompartments.

See also size().

______________________________________________________________________
Method variant with the following signature:

    get(string sid)

Get a Compartment object from the ListOfCompartments based on its
identifier.

Parameter 'sid' is a string representing the identifier of the
Compartment object to get.

Returns Compartment object in this ListOfCompartments with the given
'sid' or 'None' if no such Compartment object exists.

See also get(), size().
";


%feature("docstring") ListOfCompartments::remove "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    remove(long n)

Removes the nth item from this ListOfCompartments items and returns a
pointer to it.

The caller owns the returned item and is responsible for deleting it.

Parameter 'n' is the index of the item to remove.

See also size().

______________________________________________________________________
Method variant with the following signature:

    remove(string sid)

Removes item in this ListOfCompartments items with the given
identifier.

The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier 'sid', then
'None' is returned.

Parameter 'sid' is the identifier of the item to remove.

Returns the item removed.  As mentioned above, the caller owns the
returned item.
";


%feature("docstring") ListOfCompartments::getElementPosition "
Internal implementation method.
";


%feature("docstring") ListOfCompartments::createObject "
Internal implementation method.
";


%feature("docstring") Species "
An SBML species - a pool of entities.

A species in SBML refers to a pool of entities that (a) are considered
indistinguishable from each other for the purposes of the model, (b)
participate in reactions, and (c) are located in a specific
compartment.  The SBML Species object class is intended to represent
these pools.

As with other major constructs in SBML, Species has a mandatory
attribute, 'id', used to give the species type an identifier in the
model.  The identifier must be a text string conforming to the
identifer syntax permitted in SBML.  Species also has an optional
'name' attribute, of type 'string.'  The 'id' and 'name' must be used
according to the guidelines described in the SBML specifications.

The required attribute 'compartment' is used to identify the
compartment in which the species is located.  The attribute's value
must be the identifier of an existing Compartment object.  It is
important to note that there is no default value for the 'compartment'
attribute on Species; every species in an SBML model must be assigned
a compartment explicitly.  (This also implies that every model with
one or more Species objects must define at least one Compartment
object.)

The initial amount and concentration of a species
======================================================================

The optional attributes 'initialAmount' and 'initialConcentration',
both having a data type of 'float,' can be used to set the initial
quantity of the species in the compartment where the species is
located. These attributes are mutually exclusive; i.e., only one can
have a value on any given instance of a Species object.  Missing
'initialAmount' and 'initialConcentration' values implies that their
values either are unknown, or to be obtained from an external source,
or determined by an InitialAssignment or other SBML construct
elsewhere in the model.

A species' initial quantity in SBML is set by the 'initialAmount' or
'initialConcentration' attribute exactly once.  If the 'constant'
attribute is 'True,' then the value of the species' quantity is fixed
and cannot be changed except by an InitialAssignment.  These methods
differ in that the 'initialAmount' and 'initialConcentration'
attributes can only be used to set the species quantity to a literal
floating-point number, whereas the use of an InitialAssignment object
allows the value to be set using an arbitrary mathematical expression
(which, thanks to MathML's expressiveness, may evaluate to a rational
number).  If the species' 'constant' attribute is 'False,' the
species' quantity value may be overridden by an InitialAssignment or
changed by AssignmentRule or AlgebraicRule, and in addition, for t >
0, it may also be changed by a RateRule, Event objects, and as a
result of being a reactant or product in one or more Reaction objects.
(However, some constructs are mutually exclusive; see the SBML
specifications for the precise details.)  It is not an error to define
'initialAmount' or 'initialConcentration' on a species and also
redefine the value using an InitialAssignment, but the 'initialAmount'
or 'initialConcentration' setting in that case is ignored.  The SBML
specifications provide additional information about the semantics of
assignments, rules and values for simulation time t <= 0.

SBML Level 2 additionally stipulates that in cases where a species'
compartment has a 'spatialDimensions' value of '0' (zero), the species
cannot have a value for 'initialConcentration' because the concepts of
concentration and density break down when a container has zero
dimensions.

The units of a species' amount or concentration
======================================================================

When the attribute 'initialAmount' is set, the unit of measurement
associated with the value of 'initialAmount' is specified by the
Species attribute 'substanceUnits'.  When the 'initialConcentration'
attribute is set, the unit of measurement associated with this
concentration value is {unit of amount} divided by {unit of size},
where the {unit of amount} is specified by the Species
'substanceUnits' attribute, and the {unit of size} is specified by the
'units' attribute of the Compartment object in which the species is
located.  Note that in either case, a unit of amount is involved and
determined by the 'substanceUnits' attribute.  Note these two
attributes alone do not determine the units of the species when the
species identifier appears in a mathematical expression; that aspect
is determined by the attribute 'hasOnlySubstanceUnits' discussed
below.

In SBML Level 3, if the 'substanceUnits' attribute is not set on a
given Species object instance, then the unit of amount for that
species is inherited from the 'substanceUnits' attribute on the
enclosing Model object instance.  If that attribute on Model is not
set either, then the unit associated with the species' quantity is
undefined.

In SBML Level 2, if the 'substanceUnits' attribute is not set on a
given Species object instance, then the unit of amount for that
species is taken from the predefined SBML unit identifier
''substance'.'  The value assigned to 'substanceUnits' must be chosen
from one of the following possibilities: one of the base unit
identifiers defined in SBML, the built-in unit identifier
''substance',' or the identifier of a new unit defined in the list of
unit definitions in the enclosing Model object.  The chosen units for
'substanceUnits' must be be ''dimensionless',' ''mole',' ''item','
''kilogram',' ''gram',' or units derived from these.

As noted at the beginning of this section, simply setting
'initialAmount' or 'initialConcentration' alone does not determine
whether a species identifier represents an amount or a concentration
when it appears elsewhere in an SBML model.  The role of the attribute
'hasOnlySubstanceUnits' is to indicate whether the units of the
species, when the species identifier appears in mathematical formulas,
are intended to be concentration or amount.  The attribute takes on a
boolean value.  In SBML Level 3, the attribute has no default value
and must always be set in a model; in SBML Level 2, it has a default
value of 'False.'

The units of the species are used in the following ways:

* When the species' identifier appears in a MathML formula, it
represents the species' quantity, and the unit of measurement
associated with the quantity is as described above.

* The 'math' elements of AssignmentRule, InitialAssignment and
EventAssignment objects referring to this species should all have the
same units as the unit of measurement associated with the species
quantity.

* In a RateRule object that defines the rate of change of the species'
quantity, the unit associated with the rule's 'math' element should be
equal to the unit of the species' quantity divided by the model-wide
unit of time; in other words, {unit of species quantity}/{unit of
time}.

The 'constant' and 'boundaryCondition' attributes
======================================================================

The Species object class has two boolean attributes named 'constant'
and 'boundaryCondition', used to indicate whether and how the quantity
of that species can vary during a simulation.  In SBML Level 2 they
are optional; in SBML Level 3 they are mandatory.  The following table
shows how to interpret the combined values of these attributes.

  +----------------+-------------------------+-----------------------------------+-----------------------------+----------------------------------------------------------------+
  | constant value | boundaryCondition value | Can have assignment or rate rule? | Can be reactant or product? | Species' quantity can be changed by                            |
  +----------------+-------------------------+-----------------------------------+-----------------------------+----------------------------------------------------------------+
  | true           | true                    | no                                | yes                         | (never changes)                                                |
  | false          | true                    | yes                               | yes                         | rules and events                                               |
  | true           | false                   | no                                | no                          | (never changes)                                                |
  | false          | false                   | yes                               | yes                         | reactions or rules (but not both at the same time), and events |
  +----------------+-------------------------+-----------------------------------+-----------------------------+----------------------------------------------------------------+

By default, when a species is a product or reactant of one or more
reactions, its quantity is determined by those reactions.  In SBML, it
is possible to indicate that a given species' quantity is not
determined by the set of reactions even when that species occurs as a
product or reactant; i.e., the species is on the boundary of the
reaction system, and its quantity is not determined by the reactions.
The boolean attribute 'boundaryCondition' can be used to indicate
this.  A value of 'False' indicates that the species is part of the
reaction system.  In SBML Level 2, the attribute has a default value
of 'False,' while in SBML Level 3, it has no default.

The 'constant' attribute indicates whether the species' quantity can
be changed at all, regardless of whether by reactions, rules, or
constructs other than InitialAssignment.  A value of 'False' indicates
that the species' quantity can be changed.  (This is also a common
value because the purpose of most simulations is precisely to
calculate changes in species quantities.)  In SBML Level 2, the
attribute has a default value of 'False,' while in SBML Level 3, it
has no default.  Note that the initial quantity of a species can be
set by an InitialAssignment irrespective of the value of the
'constant' attribute.

In practice, a 'boundaryCondition' value of 'True' means a
differential equation derived from the reaction definitions should not
be generated for the species.  However, the species' quantity may
still be changed by AssignmentRule, RateRule, AlgebraicRule, Event,
and InitialAssignment constructs if its 'constant' attribute is
'False.'  Conversely, if the species' 'constant' attribute is 'True,'
then its value cannot be changed by anything except InitialAssignment.

A species having 'boundaryCondition'='False' and 'constant'='False'
can appear as a product and/or reactant of one or more reactions in
the model.  If the species is a reactant or product of a reaction, it
must not also appear as the target of any AssignmentRule or RateRule
object in the model.  If instead the species has 'boundaryCondition'=
'False' and 'constant'='True,' then it cannot appear as a reactant or
product, or as the target of any AssignmentRule, RateRule or
EventAssignment object in the model.

Finally, it is worth clarifying that while the constant and
boundaryCondition attributes restrict whether and how the species
amount changes, the same is not true of a species' concentration. In
SBML, the concentration of a species is a quantity that depends on the
size of the compartment in which it is located. A compartment's size
may change, and therefore, so can the concentration of a species even
if the amount of the species remains unchanged. A species'
concentration  may therefore vary even if the Species object's
constant attribute is  set to 'True' in a model.

The conversionFactor attribute in SBML Level 3
======================================================================

In SBML Level 3, Species has an additional optional attribute,
'conversionFactor', that defines a conversion factor that applies to a
particular species.  The value must be the identifier of a Parameter
object instance defined in the model.  That Parameter object must be a
constant, meaning its 'constant' attribute must be set to 'True.' If a
given Species object definition defines a value for its
'conversionFactor' attribute, it takes precedence over any factor
defined by the Model object's 'conversionFactor' attribute.

The unit of measurement associated with a species' quantity can be
different from the unit of extent of reactions in the model.  SBML
Level 3 avoids implicit unit conversions by providing an explicit way
to indicate any unit conversion that might be required.  The use of a
conversion factor in computing the effects of reactions on a species'
quantity is explained in detail in the SBML Level 3 specification
document.  Because the value of the 'conversionFactor' attribute is
the identifier of a Parameter object, and because parameters can have
units attached to them, the transformation from reaction extent units
to species units can be completely specified using this approach.

Note that the unit conversion factor is only applied when calculating
the effect of a reaction on a species.  It is not used in any rules or
other SBML constructs that affect the species, and it is also not used
when the value of the species is referenced in a mathematical
expression.

The speciesType attribute in SBML Level 2 Versions 2-4
======================================================================

In SBML Level 2 Versions 2-4, each species in a model may optionally
be designated as belonging to a particular species type. The optional
attribute 'speciesType' is used to identify the species type of the
chemical entities that make up the pool represented by the Species
objects.  The attribute's value must be the identifier of an existing
SpeciesType object in the model.  If the 'speciesType' attribute is
not present on a particular species definition, it means the pool
contains chemical entities of a type unique to that pool; in effect, a
virtual species type is assumed for that species, and no other species
can belong to that species type.  The value of 'speciesType'
attributes on species have no effect on the numerical interpretation
of a model; simulators and other numerical analysis software may
ignore 'speciesType' attributes.

There can be only one species of a given species type in any given
compartment of a model.  More specifically, for all Species objects
having a value for the 'speciesType' attribute, the pair <center>
('speciesType' attribute value, 'compartment' attribute value)
</center>

must be unique across the set of all Species object in a model.

The spatialSizeUnits attribute in SBML Level 2 Versions 1-2
======================================================================

In versions of SBML Level 2 before Version 3, the class Species
included an attribute called 'spatialSizeUnits', which allowed
explicitly setting the units of size for initial concentration.
LibSBML retains this attribute for compatibility with older
definitions of Level 2, but its use is strongly discouraged because
many software tools do no properly interpret this unit declaration and
it is incompatible with all SBML specifications after Level 2 Version
3.

Additional considerations for interpreting the numerical value of a
species
======================================================================

Species are unique in SBML in that they have a kind of duality: a
species identifier may stand for either substance amount (meaning, a
count of the number of individual entities) or a concentration or
density (meaning, amount divided by a compartment size).  The previous
sections explain the meaning of a species identifier when it is
referenced in a mathematical formula or in rules or other SBML
constructs; however, it remains to specify what happens to a species
when the compartment in which it is located changes in size.

When a species definition has a 'hasOnlySubstanceUnits' attribute
value of 'False' and the size of the compartment in which the species
is located changes, the default in SBML is to assume that it is the
concentration that must be updated to account for the size change.
This follows from the principle that, all other things held constant,
if a compartment simply changes in size, the size change does not in
itself cause an increase or decrease in the number of entities of any
species in that compartment.  In a sense, the default is that the
amount of a species is preserved across compartment size changes.
Upon such size changes, the value of the concentration or density must
be recalculated from the simple relationship concentration = amount /
size if the value of the concentration is needed (for example, if the
species identifier appears in a mathematical formula or is otherwise
referenced in an SBML construct).  There is one exception: if the
species' quantity is determined by an AssignmentRule, RateRule,
AlgebraicRule, or an EventAssignment and the species has a
'hasOnlySubstanceUnits' attribute value of 'False,' it means that the
concentration is assigned by the rule or event; in that case, the
amount must be calculated when the compartment size changes.  (Events
also require additional care in this situation, because an event with
multiple assignments could conceivably reassign both a species
quantity and a compartment size simultaneously.  Please refer to the
SBML specifications for the details.)

Note that the above only matters if a species has a
'hasOnlySubstanceUnits' attribute value of 'False,' meaning that the
species identifier refers to a concentration wherever the identifier
appears in a mathematical formula.  If instead the attribute's value
is 'True,' then the identifier of the species always stands for an
amount wherever it appears in a mathematical formula or is referenced
by an SBML construct.  In that case, there is never a question about
whether an assignment or event is meant to affect the amount or
concentration: it is always the amount.

A particularly confusing situation can occur when the species has
'constant' attribute value of 'True' in combination with a
'hasOnlySubstanceUnits' attribute value of 'False.'  Suppose this
species is given a value for 'initialConcentration'.  Does a
'constant' value of 'True' mean that the concentration is held
constant if the compartment size changes?  No; it is still the amount
that is kept constant across a compartment size change.  The fact that
the species was initialized using a concentration value is irrelevant.
";


%feature("docstring") ListOfSpecies "
A list of Species objects.

The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  In libSBML's
implementation, ListOf___ classes are derived from the intermediate
utility class ListOf, which is not defined by the SBML specifications
but serves as a useful programmatic construct.  ListOf is itself is in
turn derived from SBase, which provides all of the various ListOf___
classes with common features defined by the SBML specification, such
as 'metaid' attributes and annotations.

The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level 2 Version 4):

  <?xml version=\"1.0\" encoding=\"UTF-8\"?>
  <sbml xmlns=\"http://www.sbml.org/sbml/level3/version1/core\" 
        level=\"3\" version=\"1\">
    <model id=\"My_Model\">
      <listOfFunctionDefinitions>
        <functionDefinition> ... </functionDefinition> 
      </listOfFunctionDefinitions>
      <listOfUnitDefinitions>
        <unitDefinition> ... </unitDefinition> 
      </listOfUnitDefinitions>
      <listOfCompartments>
        <compartment> ... </compartment> 
      </listOfCompartments>
      <listOfSpecies>
        <species> ... </species> 
      </listOfSpecies>
      <listOfParameters>
        <parameter> ... </parameter> 
      </listOfParameters>
      <listOfInitialAssignments>
        <initialAssignment> ... </initialAssignment> 
      </listOfInitialAssignments>
      <listOfRules>
        ... elements of subclasses of Rule ...
      </listOfRules>
      <listOfConstraints>
        <constraint> ... </constraint> 
      </listOfConstraints>
      <listOfReactions>
        <reaction> ... </reaction> 
      </listOfReactions>
      <listOfEvents>
        <event> ... </event> 
      </listOfEvents>
    </model>
  </sbml>

SBML Level 3 Version 1 has essentially the same structure as  Level
2 Version 4, depicted above, but SBML Level 3  Version 2 allows
containers to contain zero or more of the relevant object, instead of
requiring at least one.  As such, libsbml will write out an
otherwise-empty ListOf___ element that has any optional attribute set
(such as 'id' or 'metaid'), that has an optional child (such  as a
'notes' or 'annotation'), or that has attributes or children set from
any SBML Level 3 package, whether or not the ListOf___ has  any other
children.

Readers may wonder about the motivations for using the ListOf___
containers in SBML.  A simpler approach in XML might be to place the
components all directly at the top level of the model definition.  The
choice made in SBML is to group them within XML elements named after
ListOfClassname, in part because it helps organize the components.
More importantly, the fact that the container classes are derived from
SBase means that software tools can add information about the lists
themselves into each list container's 'annotation'.

See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.
";


%feature("docstring") Species::Species "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    Species(SBMLNamespaces sbmlns)

Creates a new Species using the given SBMLNamespaces object 'sbmlns'.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level 2 and beyond, the 'id'
(identifier) attribute of a Species is required to have a value. Thus,
callers are cautioned to assign a value after calling this
constructor.  Setting the identifier can be accomplished using the
method Species.setId().

Parameter 'sbmlns' is an SBMLNamespaces object.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    Species(long level, long version)

Creates a new Species using the given SBML 'level' and 'version'
values.

Parameter 'level' is a long integer, the SBML Level to assign to this
Species.

Parameter 'version' is a long integer, the SBML Version to assign to
this Species.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    Species(Species orig)

Copy constructor; creates a copy of this Species object.

Parameter 'orig' is the object to copy.
";


%feature("docstring") Species::accept "
Internal implementation method.
";


%feature("docstring") Species::clone "
Creates and returns a deep copy of this Species object.

Returns the (deep) copy of this Species object.
";


%feature("docstring") Species::initDefaults "
Initializes the fields of this Species object to 'typical' defaults
values.

The SBML Species component has slightly different aspects and default
attribute values in different SBML Levels and Versions. This method
sets the values to certain common defaults, based mostly on what they
are in SBML Level 2.  Specifically:

* Sets 'boundaryCondition' to 'False'

* Sets 'constant' to 'False'

* sets 'hasOnlySubstanceUnits' to 'False'

* (Applies to Level 3 models only) Sets attribute 'substanceUnits'
to 'mole'
";


%feature("docstring") Species::getId "
Returns the value of the 'id' attribute of this Species.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
getIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns the id of this Species.

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") Species::getName "
Returns the value of the 'name' attribute of this Species object.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns the name of this SBML object, or the empty string if not set
or unsettable.

See also getIdAttribute(), isSetName(), setName(), unsetName().
";


%feature("docstring") Species::getSpeciesType "
Get the type of this Species object object.

Returns the value of the 'speciesType' attribute of this Species as a
string.

Note: The 'speciesType' attribute is only available in SBML Level 2
Versions 2-4.
";


%feature("docstring") Species::getCompartment "
Get the compartment in which this species is located.

The compartment is designated by its identifier.

Returns the value of the 'compartment' attribute of this Species
object, as a string.
";


%feature("docstring") Species::getInitialAmount "
Get the value of the 'initialAmount' attribute.

Returns the initialAmount of this Species, as a floating point number.
";


%feature("docstring") Species::getInitialConcentration "
Get the value of the 'initialConcentration' attribute.

Returns the initialConcentration of this Species,, as a floating point
number.

Note: The attribute 'initialConcentration' is only available in SBML
Level 2 and 3.  It does not exist on Species in Level 1.
";


%feature("docstring") Species::getSubstanceUnits "
Get the value of the 'substanceUnits' attribute.

Returns the value of the 'substanceUnits' attribute of this Species,
as a string.  An empty string indicates that no units have been
assigned.

Note: There is an important distinction to be made between no units
assigned, and assuming a value without units has any specific unit
such as dimensionless.  In SBML, default units are never attributed to
numbers, and numbers without units are not automatically assumed to
have the unit dimensionless.  Please consult the relevant SBML
specification document for a more in-depth explanation of this topic
and the SBML unit system.

See also isSetSubstanceUnits(), setSubstanceUnits().
";


%feature("docstring") Species::getSpatialSizeUnits "
Get the value of the 'spatialSizeUnits' attribute.

Returns the value of the 'spatialSizeUnits' attribute of this Species
object, as a string.

WARNING:

In versions of SBML Level 2 before Version 3, the class Species
included an attribute called 'spatialSizeUnits', which allowed
explicitly setting the units of size for initial concentration.  This
attribute was removed in SBML Level 2 Version 3.  LibSBML retains this
attribute for compatibility with older definitions of Level 2, but its
use is strongly discouraged because it is incompatible with levels and
versions of SBML beyond Level 2 Version 2.
";


%feature("docstring") Species::getUnits "
Get the value of the 'units' attribute.

Returns the units of this Species (L1 only).

Note: The 'units' attribute is defined only in SBML Level 1.  In SBML
Level 2 and Level 3, it has been replaced by a combination of
'substanceUnits' and the units of the Compartment object in which a
species is located.  In SBML Level 2 Versions 1-2, an additional
attribute 'spatialSizeUnits' helps determine the units of the species
quantity, but this attribute was removed in later versions of SBML
Level 2.
";


%feature("docstring") Species::getHasOnlySubstanceUnits "
Get the value of the 'hasOnlySubstanceUnits' attribute.

Returns 'True' if this Species' 'hasOnlySubstanceUnits' attribute
value is 'True,' 'False' otherwise.

Note: The 'hasOnlySubstanceUnits' attribute does not exist in SBML
Level 1.
";


%feature("docstring") Species::getBoundaryCondition "
Get the value of the 'boundaryCondition' attribute.

Returns 'True' if this Species' 'boundaryCondition' attribute value is
'True,' 'False' otherwise.
";


%feature("docstring") Species::getCharge "
Get the value of the 'charge' attribute.

Returns the charge of this Species object.

Note: Beginning in SBML Level 2 Version 2, the 'charge' attribute on
Species is deprecated and in SBML Level 3 it does not exist at all.
Its use strongly discouraged.  Its presence is considered a misfeature
in earlier definitions of SBML because its implications for the
mathematics of a model were never defined, and in any case, no known
modeling system ever used it.  Instead, models take account of charge
values directly in their definitions of species by (for example)
having separate species identities for the charged and uncharged
versions of the same species.  This allows the condition to affect
model mathematics directly.  LibSBML retains this method for easier
compatibility with SBML Level 1.
";


%feature("docstring") Species::getConstant "
Get the value of the 'constant' attribute.

Returns 'True' if this Species's 'constant' attribute value is 'True,'
'False' otherwise.

Note: The attribute 'constant' is only available in SBML Levels 2 and
3.  It does not exist on Species in Level 1.
";


%feature("docstring") Species::getConversionFactor "
Get the value of the 'conversionFactor' attribute.

Returns the conversionFactor of this Species, as a string.

Note: The 'conversionFactor' attribute was introduced in SBML Level 3.
It does not exist on Species in SBML Levels 1 and 2.
";


%feature("docstring") Species::isSetId "
Predicate returning 'True' if this Species object's 'id' attribute is
set.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
isSetIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns 'True' if the 'id' attribute of this SBML object is set,
'False' otherwise.

See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
isSetIdAttribute().
";


%feature("docstring") Species::isSetName "
Predicate returning 'True' if this Species object's 'name' attribute
is set.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns 'True' if the 'name' attribute of this SBML object is set,
'False' otherwise.

See also getName(), setName(), unsetName().
";


%feature("docstring") Species::isSetSpeciesType "
Predicate returning 'True' if this Species object's 'speciesType'
attribute is set.

Returns 'True' if the 'speciesType' attribute of this Species is set,
'False' otherwise.

Note: The 'speciesType' attribute is only available in SBML Level 2
Versions 2-4.
";


%feature("docstring") Species::isSetCompartment "
Predicate returning 'True' if this Species object's 'compartment'
attribute is set.

Returns 'True' if the 'compartment' attribute of this Species is set,
'False' otherwise.
";


%feature("docstring") Species::isSetInitialAmount "
Predicate returning 'True' if this Species object's 'initialAmount'
attribute is set.

Returns 'True' if the 'initialAmount' attribute of this Species is
set, 'False' otherwise.

Note: In SBML Level 1, Species' 'initialAmount' is required and
therefore should always be set.  (However, in Level 1, the attribute
has no default value either, so this method will not return 'True'
until a value has been assigned.)  In SBML Level 2, 'initialAmount' is
optional and as such may or may not be set.
";


%feature("docstring") Species::isSetInitialConcentration "
Predicate returning 'True' if this Species object's
'initialConcentration' attribute is set.

Returns 'True' if the 'initialConcentration' attribute of this Species
is set, 'False' otherwise.

Note: The attribute 'initialConcentration' is only available in SBML
Level 2 and 3.  It does not exist on Species in Level 1.
";


%feature("docstring") Species::isSetSubstanceUnits "
Predicate returning 'True' if this Species object's 'substanceUnits'
attribute is set.

Returns 'True' if the 'substanceUnits' attribute of this Species is
set, 'False' otherwise.
";


%feature("docstring") Species::isSetSpatialSizeUnits "
Predicate returning 'True' if this Species object's 'spatialSizeUnits'
attribute is set.

Returns 'True' if the 'spatialSizeUnits' attribute of this Species is
set, 'False' otherwise.

WARNING:

In versions of SBML Level 2 before Version 3, the class Species
included an attribute called 'spatialSizeUnits', which allowed
explicitly setting the units of size for initial concentration.  This
attribute was removed in SBML Level 2 Version 3.  LibSBML retains this
attribute for compatibility with older definitions of Level 2, but its
use is strongly discouraged because it is incompatible with levels and
versions of SBML beyond Level 2 Version 2.
";


%feature("docstring") Species::isSetUnits "
Predicate returning 'True' if this Species object's 'units' attribute
is set.

Returns 'True' if the 'units' attribute of this Species is set,
'False' otherwise.
";


%feature("docstring") Species::isSetCharge "
Predicate returning 'True' if this Species object's 'charge' attribute
is set.

Returns 'True' if the 'charge' attribute of this Species is set,
'False' otherwise.

Note: Beginning in SBML Level 2 Version 2, the 'charge' attribute on
Species is deprecated and in SBML Level 3 it does not exist at all.
Its use strongly discouraged.  Its presence is considered a misfeature
in earlier definitions of SBML because its implications for the
mathematics of a model were never defined, and in any case, no known
modeling system ever used it.  Instead, models take account of charge
values directly in their definitions of species by (for example)
having separate species identities for the charged and uncharged
versions of the same species.  This allows the condition to affect
model mathematics directly.  LibSBML retains this method for easier
compatibility with SBML Level 1.
";


%feature("docstring") Species::isSetConversionFactor "
Predicate returning 'True' if this Species object's 'conversionFactor'
attribute is set.

Returns 'True' if the 'conversionFactor' attribute of this Species is
set, 'False' otherwise.

Note: The 'conversionFactor' attribute was introduced in SBML Level 3.
It does not exist on Species in SBML Levels 1 and 2.
";


%feature("docstring") Species::isSetBoundaryCondition "
Predicate returning 'True' if this Species object's
'boundaryCondition' attribute is set.

Returns 'True' if the 'boundaryCondition' attribute of this Species is
set, 'False' otherwise.
";


%feature("docstring") Species::isSetHasOnlySubstanceUnits "
Predicate returning 'True' if this Species object's
'hasOnlySubstanceUnits' attribute is set.

Returns 'True' if the 'hasOnlySubstanceUnits' attribute of this
Species is set, 'False' otherwise.

Note: The 'hasOnlySubstanceUnits' attribute does not exist in SBML
Level 1.
";


%feature("docstring") Species::isSetConstant "
Predicate returning 'True' if this Species object's 'constant'
attribute is set.

Returns 'True' if the 'constant' attribute of this Species is set,
'False' otherwise.

Note: The attribute 'constant' is only available in SBML Levels 2 and
3.  It does not exist on Species in Level 1.
";


%feature("docstring") Species::setId "
Sets the value of the 'id' attribute of this Species.

The string 'sid' is copied.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Parameter 'sid' is the string to use as the identifier of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") Species::setName "
Sets the value of the 'name' attribute of this Species.

The string in 'name' is copied.

Parameter 'name' is the new name for the SBML object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") Species::setSpeciesType "
Sets the 'speciesType' attribute of this Species object.

Parameter 'sid' is the identifier of a SpeciesType object defined
elsewhere in this Model.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

Note: The 'speciesType' attribute is only available in SBML Level 2
Versions 2-4.
";


%feature("docstring") Species::setCompartment "
Sets the 'compartment' attribute of this Species object.

Parameter 'sid' is the identifier of a Compartment object defined
elsewhere in this Model.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") Species::setInitialAmount "
Sets the 'initialAmount' attribute of this Species and marks the field
as set.

This method also unsets the 'initialConcentration' attribute.

Parameter 'value' is the value to which the 'initialAmount' attribute
should be set.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS
";


%feature("docstring") Species::setInitialConcentration "
Sets the 'initialConcentration' attribute of this Species and marks
the field as set.

This method also unsets the 'initialAmount' attribute.

Parameter 'value' is the value to which the 'initialConcentration'
attribute should be set.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

Note: The attribute 'initialConcentration' is only available in SBML
Level 2 and 3.  It does not exist on Species in Level 1.
";


%feature("docstring") Species::setSubstanceUnits "
Sets the 'substanceUnits' attribute of this Species object.

Parameter 'sid' is the identifier of the unit to use.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") Species::setSpatialSizeUnits "
(SBML Level 2 Versions 1-2) Sets the 'spatialSizeUnits' attribute of
this Species object.

Parameter 'sid' is the identifier of the unit to use.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

WARNING:

In versions of SBML Level 2 before Version 3, the class Species
included an attribute called 'spatialSizeUnits', which allowed
explicitly setting the units of size for initial concentration.  This
attribute was removed in SBML Level 2 Version 3.  LibSBML retains this
attribute for compatibility with older definitions of Level 2, but its
use is strongly discouraged because it is incompatible with levels and
versions of SBML beyond Level 2 Version 2.
";


%feature("docstring") Species::setUnits "
(SBML Level 1 only) Sets the units of this Species object.

Parameter 'sname' is the identifier of the unit to use.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") Species::setHasOnlySubstanceUnits "
Sets the 'hasOnlySubstanceUnits' attribute of this Species object.

Parameter 'value' is boolean value for the 'hasOnlySubstanceUnits'
attribute.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

Note: The 'hasOnlySubstanceUnits' attribute does not exist in SBML
Level 1.
";


%feature("docstring") Species::setBoundaryCondition "
Sets the 'boundaryCondition' attribute of this Species object.

Parameter 'value' is boolean value for the 'boundaryCondition'
attribute.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS
";


%feature("docstring") Species::setCharge "
Sets the 'charge' attribute of this Species object.

Parameter 'value' is an integer to which to set the 'charge' to.

Note: Beginning in SBML Level 2 Version 2, the 'charge' attribute on
Species is deprecated and in SBML Level 3 it does not exist at all.
Its use strongly discouraged.  Its presence is considered a misfeature
in earlier definitions of SBML because its implications for the
mathematics of a model were never defined, and in any case, no known
modeling system ever used it.  Instead, models take account of charge
values directly in their definitions of species by (for example)
having separate species identities for the charged and uncharged
versions of the same species.  This allows the condition to affect
model mathematics directly.  LibSBML retains this method for easier
compatibility with SBML Level 1.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE
";


%feature("docstring") Species::setConstant "
Sets the 'constant' attribute of this Species object.

Parameter 'value' is a boolean value for the 'constant' attribute.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

Note: The attribute 'constant' is only available in SBML Levels 2 and
3.  It does not exist on Species in Level 1.
";


%feature("docstring") Species::setConversionFactor "
Sets the value of the 'conversionFactor' attribute of this Species
object.

The string in 'sid' is copied.

Parameter 'sid' is the new conversionFactor for the Species.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_INVALID_ATTRIBUTE_VALUE

Note: The 'conversionFactor' attribute was introduced in SBML Level 3.
It does not exist on Species in SBML Levels 1 and 2.
";


%feature("docstring") Species::unsetName "
Unsets the value of the 'name' attribute of this Species object.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also getName(), setName(), isSetName().
";


%feature("docstring") Species::unsetConstant "
Unsets the value of the 'constant' attribute of this Species object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also isSetConstant(), setConstant(), getConstant().
";


%feature("docstring") Species::unsetSpeciesType "
Unsets the 'speciesType' attribute value of this Species object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

Note: The attribute 'speciesType' is only available in SBML Level 2
Versions 2-4.
";


%feature("docstring") Species::unsetInitialAmount "
Unsets the 'initialAmount' attribute value of this Species object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED
";


%feature("docstring") Species::unsetInitialConcentration "
Unsets the 'initialConcentration' attribute value of this Species
object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

Note: The attribute 'initialConcentration' is only available in SBML
Level 2 and 3.  It does not exist on Species in Level 1.
";


%feature("docstring") Species::unsetSubstanceUnits "
Unsets the 'substanceUnits' attribute value of this Species object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED
";


%feature("docstring") Species::unsetSpatialSizeUnits "
Unsets the 'spatialSizeUnits' attribute value of this Species object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

WARNING:

In versions of SBML Level 2 before Version 3, the class Species
included an attribute called 'spatialSizeUnits', which allowed
explicitly setting the units of size for initial concentration.  This
attribute was removed in SBML Level 2 Version 3.  LibSBML retains this
attribute for compatibility with older definitions of Level 2, but its
use is strongly discouraged because it is incompatible with levels and
versions of SBML beyond Level 2 Version 2.
";


%feature("docstring") Species::unsetUnits "
Unsets the 'units' attribute value of this Species object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED
";


%feature("docstring") Species::unsetCharge "
Unsets the 'charge' attribute value of this Species object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_OPERATION_FAILED

Note: Beginning in SBML Level 2 Version 2, the 'charge' attribute on
Species is deprecated and in SBML Level 3 it does not exist at all.
Its use strongly discouraged.  Its presence is considered a misfeature
in earlier definitions of SBML because its implications for the
mathematics of a model were never defined, and in any case, no known
modeling system ever used it.  Instead, models take account of charge
values directly in their definitions of species by (for example)
having separate species identities for the charged and uncharged
versions of the same species.  This allows the condition to affect
model mathematics directly.  LibSBML retains this method for easier
compatibility with SBML Level 1.
";


%feature("docstring") Species::unsetConversionFactor "
Unsets the 'conversionFactor' attribute value of this Species object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

* LIBSBML_OPERATION_FAILED

Note: The 'conversionFactor' attribute was introduced in SBML Level 3.
It does not exist on Species in SBML Levels 1 and 2.
";


%feature("docstring") Species::unsetCompartment "
Unsets the 'compartment' attribute value of this Species object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED
";


%feature("docstring") Species::unsetBoundaryCondition "
Unsets the 'boundaryCondition' attribute value of this Species object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED
";


%feature("docstring") Species::unsetHasOnlySubstanceUnits "
Unsets the 'hasOnlySubstanceUnits' attribute value of this Species
object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED
";


%feature("docstring") Species::getDerivedUnitDefinition "
Constructs and returns a UnitDefinition that corresponds to the units
of this Species' amount or concentration.

Species in SBML have an attribute ('substanceUnits') for declaring the
units of measurement intended for the species' amount or concentration
(depending on which one applies).  In the absence of a value given for
'substanceUnits', the units are taken from the enclosing Model's
definition of ''substance'' or ''substance'/(size' of the compartment)
in which the species is located, or finally, if these are not
redefined by the Model, the relevant SBML default units for those
quantities.  Following that procedure, the method
getDerivedUnitDefinition() returns a UnitDefinition based on the
interpreted units of this species's amount or concentration.

Note that the functionality that facilitates unit analysis depends  on
the model as a whole.  Thus, in cases where the object has not  been
added to a model or the model itself is incomplete, unit analysis is
not possible and this method will return 'None.'

Note also that unit declarations for Species are in terms of the
identifier of a unit, but this method returns a UnitDefinition object,
not a unit identifier.  It does this by constructing an appropriate
UnitDefinition.  Callers may find this particularly useful when used
in conjunction with the helper methods on UnitDefinition for comparing
different UnitDefinition objects.

In SBML Level 2 specifications prior to Version 3, Species includes an
additional attribute named 'spatialSizeUnits', which allows explicitly
setting the units of size for initial concentration. The
getDerivedUnitDefinition() takes this into account for models
expressed in SBML Level 2 Versions 1 and 2.

Returns a UnitDefinition that expresses the units of this  Species, or
'None' if one cannot be constructed.

See also getSubstanceUnits().
";


%feature("docstring") Species::getTypeCode "
Returns the libSBML type code for this SBML object.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for this object: SBML_SPECIES (default).

WARNING:

The specific integer values of the possible type codes may be reused
by different libSBML plug-ins for SBML Level 3. packages,  To fully
identify the correct code, it is necessary to invoke both
getTypeCode() and getPackageName().

See also getElementName(), getPackageName().
";


%feature("docstring") Species::getElementName "
Returns the XML element name of this object, which for Species, is
always ''species'.'

Returns the name of this element, i.e., ''species'.'
";


%feature("docstring") Species::writeElements "
Internal implementation method.
";


%feature("docstring") Species::hasRequiredAttributes "
Predicate returning 'True' if all the required attributes for this
Species object have been set.

The required attributes for a Species object are:

* 'id' (or 'name' in SBML Level 1)

* 'compartment'

* 'initialAmount' (required in SBML Level 1 only; optional
otherwise)

* 'hasOnlySubstanceUnits' (required in SBML Level 3; optional in
SBML Level 2)

* 'boundaryCondition' (required in SBML Level 3; optional in Levels
1 and 2)

* 'constant' (required in SBML Level 3; optional in SBML Level 2)

Returns 'True' if the required attributes have been set, 'False'
otherwise.
";


%feature("docstring") Species::renameSIdRefs "
Replaces all uses of a given 'SIdRef' type attribute value with
another value.

In SBML, object identifiers are of a data type called SId. In SBML
Level 3, an explicit data type called SIdRef was introduced for
attribute values that refer to SId values; in previous Levels of SBML,
this data type did not exist and attributes were simply described to
as 'referring to an identifier', but the effective data type was the
same as SIdRef in Level 3.  These and other methods of libSBML refer
to the type SIdRef for all Levels of SBML, even if the corresponding
SBML specification did not explicitly name the data type.

This method works by looking at all attributes and (if appropriate)
mathematical formulas in MathML content, comparing the referenced
identifiers to the value of 'oldid'.  If any matches are found, the
matching values are replaced with 'newid'.  The method does not
descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") Species::renameUnitSIdRefs "
Replaces all uses of a given 'UnitSIdRef' type attribute value with
another value.

In SBML, unit definitions have identifiers of type UnitSId.  In SBML
Level 3, an explicit data type called UnitSIdRef was introduced for
attribute values that refer to UnitSId values; in previous Levels of
SBML, this data type did not exist and attributes were simply
described to as 'referring to a unit identifier', but the effective
data type was the same as UnitSIdRef in Level 3.  These and other
methods of libSBML refer to the type UnitSIdRef for all Levels of
SBML, even if the corresponding SBML specification did not explicitly
name the data type.

This method works by looking at all unit identifier attribute values
(including, if appropriate, inside mathematical formulas), comparing
the referenced unit identifiers to the value of 'oldid'.  If any
matches are found, the matching values are replaced with 'newid'.  The
method does not descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") Species::addExpectedAttributes "
Internal implementation method.
";


%feature("docstring") Species::readAttributes "
Internal implementation method.
";


%feature("docstring") Species::readL1Attributes "
Internal implementation method.
";


%feature("docstring") Species::readL2Attributes "
Internal implementation method.
";


%feature("docstring") Species::readL3Attributes "
Internal implementation method.
";


%feature("docstring") Species::writeAttributes "
Internal implementation method.
";


%feature("docstring") Species::isExplicitlySetBoundaryCondition "
Internal implementation method.
";


%feature("docstring") Species::isExplicitlySetConstant "
Internal implementation method.
";


%feature("docstring") Species::isExplicitlySetHasOnlySubsUnits "
Internal implementation method.
";


%feature("docstring") ListOfSpecies::ListOfSpecies "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    ListOfSpecies(SBMLNamespaces sbmlns)

Creates a new ListOfSpecies object.

The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in
'sbmlns'.

Parameter 'sbmlns' is an SBMLNamespaces object that is used to
determine the characteristics of the ListOfSpecies object to be
created.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    ListOfSpecies(long level, long version)

Creates a new ListOfSpecies object.

The object is constructed such that it is valid for the given SBML
Level and Version combination.

Parameter 'level' is the SBML Level.

Parameter 'version' is the Version within the SBML Level.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.
";


%feature("docstring") ListOfSpecies::clone "
Creates and returns a deep copy of this ListOfSpecies object.

Returns the (deep) copy of this ListOfSpecies object.
";


%feature("docstring") ListOfSpecies::getItemTypeCode "
Returns the libSBML type code for the objects contained in this ListOf
(i.e., Species objects, if the list is non-empty).

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for objects contained in this list:
SBML_SPECIES (default).

See also getElementName(), getPackageName().
";


%feature("docstring") ListOfSpecies::getElementName "
Returns the XML element name of this object.

For ListOfSpeciess, the XML element name is ''listOfSpeciess'.'

Returns the name of this element, i.e., ''listOfSpeciess'.'
";


%feature("docstring") ListOfSpecies::get "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    get(long n)

Get a Species from the ListOfSpecies.

Parameter 'n' is the index number of the Species to get.

Returns the nth Species in this ListOfSpecies.

See also size().

______________________________________________________________________
Method variant with the following signature:

    get(string sid)

Get a Species from the ListOfSpecies based on its identifier.

Parameter 'sid' is a string representing the identifier  of the
Species to get.

Returns Species in this ListOfSpecies with the given 'sid' or 'None'
if no such Species exists.

See also get(), size().
";


%feature("docstring") ListOfSpecies::remove "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    remove(long n)

Removes the nth item from this ListOfSpeciess items and returns a
pointer to it.

The caller owns the returned item and is responsible for deleting it.

Parameter 'n' is the index of the item to remove.

See also size().

______________________________________________________________________
Method variant with the following signature:

    remove(string sid)

Removes item in this ListOfSpeciess items with the given identifier.

The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier 'sid', then
'None' is returned.

Parameter 'sid' is the identifier of the item to remove.

Returns the item removed.  As mentioned above, the caller owns the
returned item.
";


%feature("docstring") ListOfSpecies::getElementPosition "
Internal implementation method.
";


%feature("docstring") ListOfSpecies::createObject "
Internal implementation method.
";


%feature("docstring") Parameter "
An SBML parameter: a named symbol with a value.

A Parameter is used in SBML to define a symbol associated with a
value; this symbol can then be used in mathematical formulas in a
model.  By default, parameters have constant value for the duration of
a simulation, and for this reason are called parameters instead of
variables in SBML, although it is crucial to understand that SBML
parameters represent both concepts.  Whether a given SBML parameter is
intended to be constant or variable is indicated by the value of its
'constant' attribute.

SBML's Parameter has a required attribute, 'id', that gives the
parameter a unique identifier by which other parts of an SBML model
definition can refer to it.  A parameter can also have an optional
'name' attribute of type 'string.'  Identifiers and names must be used
according to the guidelines described in the SBML specifications.

The optional attribute 'value' determines the value (of type 'float)'
assigned to the parameter.  A missing value for 'value' implies that
the value either is unknown, or to be obtained from an external
source, or determined by an initial assignment.  The unit of
measurement associated with the value of the parameter can be
specified using the optional attribute 'units'.  Here we only mention
briefly some notable points about the possible unit choices, but
readers are urged to consult the SBML specification documents for more
information:

* In SBML Level 3, there are no constraints on the units that can be
assigned to parameters in a model; there are also no units to inherit
from the enclosing Model object (unlike the case for, e.g., Species
and Compartment).

* In SBML Level 2, the value assigned to the parameter's 'units'
attribute must be chosen from one of the following possibilities: one
of the base unit identifiers defined in SBML; one of the built-in unit
identifiers ''substance',' ''time',' ''volume',' ''area'' or
''length';' or the identifier of a new unit defined in the list of
unit definitions in the enclosing Model structure.  There are no
constraints on the units that can be chosen from these sets.  There
are no default units for parameters. The Parameter structure has
another boolean attribute named 'constant' that is used to indicate
whether the parameter's value can vary during a simulation.  (In SBML
Level 3, the attribute is mandatory and must be given a value; in SBML
Levels below Level 3, the attribute is optional.)  A value of 'True'
indicates the parameter's value cannot be changed by any construct
except InitialAssignment.  Conversely, if the value of 'constant' is
'False,' other constructs in SBML, such as rules and events, can
change the value of the parameter.

SBML Level 3 uses a separate object class, LocalParameter, for
parameters that are local to a Reaction's KineticLaw.  In Levels prior
to SBML Level 3, the Parameter class is used both for definitions of
global parameters, as well as reaction-local parameters stored in a
list within KineticLaw objects.  Parameter objects that are local to a
reaction (that is, those defined within the KineticLaw structure of a
Reaction) cannot be changed by rules and therefore are implicitly
always constant; consequently, in SBML Level 2, parameter definitions
within Reaction structures should not have their 'constant' attribute
set to 'False.'

What if a global parameter has its 'constant' attribute set to
'False,' but the model does not contain any rules, events or other
constructs that ever change its value over time?  Although the model
may be suspect, this situation is not strictly an error.  A value of
'False' for 'constant' only indicates that a parameter can change
value, not that it must.

As with all other major SBML components, Parameter is derived from
SBase, and the methods defined on SBase are available on Parameter.

Note: The use of the term parameter in SBML sometimes leads to
confusion among readers who have a particular notion of what something
called 'parameter' should be.  It has been the source of heated
debate, but despite this, no one has yet found an adequate replacement
term that does not have different connotations to different people and
hence leads to confusion among some subset of users.  Perhaps it would
have been better to have two constructs, one called constants and the
other called variables.  The current approach in SBML is simply more
parsimonious, using a single Parameter construct with the boolean flag
'constant' indicating which flavor it is.  In any case, readers are
implored to look past their particular definition of a parameter and
simply view SBML's Parameter as a single mechanism for defining both
constants and (additional) variables in a model.  (We write additional
because the species in a model are usually considered to be the
central variables.)  After all, software tools are not required to
expose to users the actual names of particular SBML constructs, and
thus tools can present to their users whatever terms their designers
feel best matches their target audience.

In SBML Level 3 Version 2, many restrictions were lifted  requiring
only Boolean values in Boolean contexts, and numeric values in numeric
contexts.  This means that a Parameter may now be used as a Boolean,
despite canonically having a numeric value. To be consistent, one
should always assign it a value of 'True' or 'False,' and use it in
Boolean contexts exclusively.  It would be appropriate to give it an
SBO value of 602 ('Logical parameter') if one chooses to do this.

See also ListOfParameters.
";


%feature("docstring") ListOfParameters "
A list of Parameter objects.

The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  In libSBML's
implementation, ListOf___ classes are derived from the intermediate
utility class ListOf, which is not defined by the SBML specifications
but serves as a useful programmatic construct.  ListOf is itself is in
turn derived from SBase, which provides all of the various ListOf___
classes with common features defined by the SBML specification, such
as 'metaid' attributes and annotations.

The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level 2 Version 4):

  <?xml version=\"1.0\" encoding=\"UTF-8\"?>
  <sbml xmlns=\"http://www.sbml.org/sbml/level3/version1/core\" 
        level=\"3\" version=\"1\">
    <model id=\"My_Model\">
      <listOfFunctionDefinitions>
        <functionDefinition> ... </functionDefinition> 
      </listOfFunctionDefinitions>
      <listOfUnitDefinitions>
        <unitDefinition> ... </unitDefinition> 
      </listOfUnitDefinitions>
      <listOfCompartments>
        <compartment> ... </compartment> 
      </listOfCompartments>
      <listOfSpecies>
        <species> ... </species> 
      </listOfSpecies>
      <listOfParameters>
        <parameter> ... </parameter> 
      </listOfParameters>
      <listOfInitialAssignments>
        <initialAssignment> ... </initialAssignment> 
      </listOfInitialAssignments>
      <listOfRules>
        ... elements of subclasses of Rule ...
      </listOfRules>
      <listOfConstraints>
        <constraint> ... </constraint> 
      </listOfConstraints>
      <listOfReactions>
        <reaction> ... </reaction> 
      </listOfReactions>
      <listOfEvents>
        <event> ... </event> 
      </listOfEvents>
    </model>
  </sbml>

SBML Level 3 Version 1 has essentially the same structure as  Level
2 Version 4, depicted above, but SBML Level 3  Version 2 allows
containers to contain zero or more of the relevant object, instead of
requiring at least one.  As such, libsbml will write out an
otherwise-empty ListOf___ element that has any optional attribute set
(such as 'id' or 'metaid'), that has an optional child (such  as a
'notes' or 'annotation'), or that has attributes or children set from
any SBML Level 3 package, whether or not the ListOf___ has  any other
children.

Readers may wonder about the motivations for using the ListOf___
containers in SBML.  A simpler approach in XML might be to place the
components all directly at the top level of the model definition.  The
choice made in SBML is to group them within XML elements named after
ListOfClassname, in part because it helps organize the components.
More importantly, the fact that the container classes are derived from
SBase means that software tools can add information about the lists
themselves into each list container's 'annotation'.

See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.
";


%feature("docstring") Parameter::Parameter "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    Parameter(SBMLNamespaces sbmlns)

Creates a new Parameter using the given SBMLNamespaces object
'sbmlns'.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level 2 and beyond, the 'id'
(identifier) attribute of a Parameter is required to have a value.
Thus, callers are cautioned to assign a value after calling this
constructor if no identifier is provided as an argument.  Setting the
identifier can be accomplished using the method setId().

Parameter 'sbmlns' is an SBMLNamespaces object.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    Parameter(long level, long version)

Creates a new Parameter using the given SBML 'level' and 'version'
values.

Parameter 'level' is a long integer, the SBML Level to assign to this
Parameter.

Parameter 'version' is a long integer, the SBML Version to assign to
this Parameter.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    Parameter(Parameter orig)

Copy constructor; creates a copy of a Parameter.

Parameter 'orig' is the Parameter instance to copy.
";


%feature("docstring") Parameter::accept "
Internal implementation method.
";


%feature("docstring") Parameter::clone "
Creates and returns a deep copy of this Parameter object.

Returns the (deep) copy of this Parameter object.
";


%feature("docstring") Parameter::initDefaults "
Initializes the fields of this Parameter object to 'typical' defaults
values.

The SBML Parameter component has slightly different aspects and
default attribute values in different SBML Levels and Versions.  Many
SBML object classes defined by libSBML have an initDefaults() method
to set the values to certain common defaults, based mostly on what
they are in SBML Level 2.  In the case of Parameter, this method only
sets the value of the 'constant' attribute to 'True.'

See also getConstant(), isSetConstant(), setConstant().
";


%feature("docstring") Parameter::getId "
Returns the value of the 'id' attribute of this Parameter.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
getIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns the id of this Parameter.

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") Parameter::getName "
Returns the value of the 'name' attribute of this Parameter object.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns the name of this SBML object, or the empty string if not set
or unsettable.

See also getIdAttribute(), isSetName(), setName(), unsetName().
";


%feature("docstring") Parameter::getValue "
Gets the numerical value of this Parameter.

Returns the value of the 'value' attribute of this Parameter, as a
number of type 'float.'

Note: It is crucial that callers not blindly call Parameter.getValue()
without first using Parameter.isSetValue() to determine whether a
value has ever been set.  Otherwise, the value return by
Parameter.getValue() may not actually represent a value assigned to
the parameter.  The reason is simply that the data type 'float' in a
program always has some value.  A separate test is needed to determine
whether the value is a true model value, or uninitialized data in a
computer's memory location.

See also isSetValue(), setValue(), getUnits().
";


%feature("docstring") Parameter::getUnits "
Gets the units defined for this Parameter.

The value of an SBML parameter's 'units' attribute establishes the
unit of measurement associated with the parameter's value.

Returns the value of the 'units' attribute of this Parameter, as a
string.  An empty string indicates that no units have been assigned.

Note: There is an important distinction to be made between no units
assigned, and assuming a value without units has any specific unit
such as dimensionless.  In SBML, default units are never attributed to
numbers, and numbers without units are not automatically assumed to
have the unit dimensionless.  Please consult the relevant SBML
specification document for a more in-depth explanation of this topic
and the SBML unit system.

See also isSetUnits(), setUnits(), getValue().
";


%feature("docstring") Parameter::getConstant "
Gets the value of the 'constant' attribute of this Parameter instance.

Returns 'True' if this Parameter is declared as being constant,
'False' otherwise.

Note: Readers who view the documentation for LocalParameter may be
confused about the presence of this method.  LibSBML derives
LocalParameter from Parameter; however, this does not precisely match
the object hierarchy defined by SBML Level 3, where LocalParameter is
derived directly from SBase and not Parameter.  We believe this
arrangement makes it easier for libSBML users to program applications
that work with both SBML Level 2 and SBML Level 3, but programmers
should also keep in mind this difference exists.  A side-effect of
libSBML's scheme is that certain methods on LocalParameter that are
inherited from Parameter do not actually have relevance to
LocalParameter objects.  An example of this is the methods pertaining
to Parameter's attribute 'constant' (i.e., isSetConstant(),
setConstant(), and getConstant()).

See also isSetConstant(), setConstant().
";


%feature("docstring") Parameter::isSetId "
Predicate returning 'True' if this Parameter's 'id' attribute is set.

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
isSetIdAttribute() function instead.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Returns 'True' if the 'id' attribute of this SBML object is set,
'False' otherwise.

See also getIdAttribute(), setIdAttribute(), unsetIdAttribute(),
isSetIdAttribute().
";


%feature("docstring") Parameter::isSetName "
Predicate returning 'True' if this Parameter's 'name' attribute is
set.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns 'True' if the 'name' attribute of this SBML object is set,
'False' otherwise.

See also getName(), setName(), unsetName().
";


%feature("docstring") Parameter::isSetValue "
Predicate returning 'True' if the 'value' attribute of this Parameter
is set.

In SBML definitions after SBML Level 1 Version 1, parameter values are
optional and have no defaults.  If a model read from a file does not
contain a setting for the 'value' attribute of a parameter, its value
is considered unset; it does not default to any particular value.
Similarly, when a Parameter object is created in libSBML, it has no
value until given a value.  The Parameter.isSetValue() method allows
calling applications to determine whether a given parameter's value
has ever been set.

In SBML Level 1 Version 1, parameters are required to have values and
therefore, the value of a Parameter should always be set.  In Level 1
Version 2 and beyond, the value is optional and as such, the 'value'
attribute may or may not be set.

Returns 'True' if the value of this Parameter is set, 'False'
otherwise.

See also getValue(), setValue().
";


%feature("docstring") Parameter::isSetUnits "
Predicate returning 'True' if the 'units' attribute of this Parameter
is set.

Returns 'True' if the 'units' attribute of this Parameter is set,
'False' otherwise.

Note: There is an important distinction to be made between no units
assigned, and assuming a value without units has any specific unit
such as dimensionless.  In SBML, default units are never attributed to
numbers, and numbers without units are not automatically assumed to
have the unit dimensionless.  Please consult the relevant SBML
specification document for a more in-depth explanation of this topic
and the SBML unit system.
";


%feature("docstring") Parameter::isSetConstant "
Predicate returning 'True' if the 'constant' attribute of this
Parameter is set.

Returns 'True' if the 'constant' attribute of this Parameter is set,
'False' otherwise.

Note: Readers who view the documentation for LocalParameter may be
confused about the presence of this method.  LibSBML derives
LocalParameter from Parameter; however, this does not precisely match
the object hierarchy defined by SBML Level 3, where LocalParameter is
derived directly from SBase and not Parameter.  We believe this
arrangement makes it easier for libSBML users to program applications
that work with both SBML Level 2 and SBML Level 3, but programmers
should also keep in mind this difference exists.  A side-effect of
libSBML's scheme is that certain methods on LocalParameter that are
inherited from Parameter do not actually have relevance to
LocalParameter objects.  An example of this is the methods pertaining
to Parameter's attribute 'constant' (i.e., isSetConstant(),
setConstant(), and getConstant()).

See also getConstant(), setConstant().
";


%feature("docstring") Parameter::setId "
Sets the value of the 'id' attribute of this Parameter.

The string 'sid' is copied.

The identifier given by an object's 'id' attribute value is used to
identify the object within the SBML model definition. Other objects
can refer to the component using this identifier.  The data type of
'id' is always SId or a type derived from that, such as UnitSId,
depending on the object in  question.  All data types are defined as
follows:

  letter ::= \'a\'..\'z\',\'A\'..\'Z\'
  digit  ::= \'0\'..\'9\'
  idChar ::= letter | digit | \'_\'
  SId    ::= ( letter | \'_\' ) idChar*

The characters ( and ) are used for grouping, the character * 'zero
or more times', and the character | indicates logical 'or'.  The
equality of SBML identifiers is determined by an exact character
sequence match; i.e., comparisons must be performed in a case-
sensitive manner.  This applies to all uses of SId,  SIdRef, and
derived types.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, check, and unset those
attributes, which  would fail or otherwise return empty strings if
executed on any object  for which those attributes were not defined.
Now that all SBase objects  define those attributes, those functions
now succeed for any object with  the appropriate level and version.

The exception to this rule is that for InitialAssignment,
EventAssignment,  AssignmentRule, and RateRule objects, the getId()
function and the isSetId()  functions (though not the setId() or
unsetId() functions) would instead  reference the value of the
'variable' attribute (for the rules and event  assignments) or the
'symbol' attribute (for initial assignments).   The AlgebraicRule fell
into this category as well, though because it  contained neither a
'variable' nor a 'symbol' attribute, getId() would  always return an
empty string, and isSetId() would always return 'False.' For this
reason, four new functions are now provided  (getIdAttribute(),
setIdAttribute(),  isSetIdAttribute(), and unsetIdAttribute()) that
will always act on the actual 'id' attribute, regardless of the
object's type.  The new functions should be used instead of the old
ones unless the old behavior is somehow necessary.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
identifiers).  If the object in question does not posess an 'id'
attribute  according to the SBML specification for the Level and
Version in use, libSBML will not allow the identifier to be set, nor
will it read or  write 'id' attributes for those objects.

Parameter 'sid' is the string to use as the identifier of this object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute().
";


%feature("docstring") Parameter::setName "
Sets the value of the 'name' attribute of this Parameter.

The string in 'name' is copied.

Parameter 'name' is the new name for the Parameter.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") Parameter::setValue "
Sets the 'value' attribute of this Parameter to the given 'float'
value and marks the attribute as set.

Parameter 'value' is a 'float,' the value to assign.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS
";


%feature("docstring") Parameter::setUnits "
Sets the 'units' attribute of this Parameter to a copy of the given
units identifier 'units'.

Parameter 'units' is a string, the identifier of the units to assign
to this Parameter instance.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") Parameter::setConstant "
Sets the 'constant' attribute of this Parameter to the given boolean
'flag'.

Parameter 'flag' is a boolean, the value for the 'constant' attribute
of this Parameter instance.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_UNEXPECTED_ATTRIBUTE

Note: Readers who view the documentation for LocalParameter may be
confused about the presence of this method.  LibSBML derives
LocalParameter from Parameter; however, this does not precisely match
the object hierarchy defined by SBML Level 3, where LocalParameter is
derived directly from SBase and not Parameter.  We believe this
arrangement makes it easier for libSBML users to program applications
that work with both SBML Level 2 and SBML Level 3, but programmers
should also keep in mind this difference exists.  A side-effect of
libSBML's scheme is that certain methods on LocalParameter that are
inherited from Parameter do not actually have relevance to
LocalParameter objects.  An example of this is the methods pertaining
to Parameter's attribute 'constant' (i.e., isSetConstant(),
setConstant(), and getConstant()).

See also getConstant(), isSetConstant().
";


%feature("docstring") Parameter::unsetName "
Unsets the value of the 'name' attribute of this Parameter.

In SBML Level 3 Version 2, the 'id' and 'name' attributes were moved
to SBase directly, instead of being defined individually for many (but
not all) objects.  Libsbml has for a long time provided functions
defined on SBase itself to get, set, and unset those attributes, which
would fail or otherwise return empty strings if executed on any object
for which those attributes were not defined.  Now that all SBase
objects  define those attributes, those functions now succeed for any
object with  the appropriate level and version.

The 'name' attribute is optional and is not intended to be used for
cross-referencing purposes within a model.  Its purpose instead is to
provide a human-readable label for the component.  The data type of
'name' is the type string defined in XML Schema.  SBML imposes no
restrictions as to the content of 'name' attributes beyond those
restrictions defined by the string type in XML Schema.

The recommended practice for handling 'name' is as follows.  If a
software tool has the capability for displaying the content of 'name'
attributes, it should display this content to the user as a
component's label instead of the component's 'id'.  If the user
interface does not have this capability (e.g., because it cannot
display or use special characters in symbol names), or if the 'name'
attribute is missing on a given component, then the user interface
should display the value of the 'id' attribute instead.  (Script
language interpreters are especially likely to display 'id' instead of
'name'.)

As a consequence of the above, authors of systems that automatically
generate the values of 'id' attributes should be aware some systems
may display the 'id''s to the user.  Authors therefore may wish to
take some care to have their software create 'id' values that are: (a)
reasonably easy for humans to type and read; and (b) likely to be
meaningful, for example by making the 'id' attribute be an abbreviated
form of the name attribute value.

An additional point worth mentioning is although there are
restrictions on the uniqueness of 'id' values, there are no
restrictions on the uniqueness of 'name' values in a model.  This
allows software applications leeway in assigning component
identifiers.

Regardless of the level and version of the SBML, these functions allow
client applications to use more generalized code in some situations
(for instance, when manipulating objects that are all known to have
names).  If the object in question does not posess a 'name' attribute
according to the SBML specification for the Level and Version in use,
libSBML will not allow the name to be set, nor will it read or  write
'name' attributes for those objects.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also getName(), setName(), isSetName().
";


%feature("docstring") Parameter::unsetConstant "
Unsets the value of the 'constant' attribute of this Parameter object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

See also isSetConstant(), setConstant(), getConstant().
";


%feature("docstring") Parameter::unsetValue "
Unsets the 'value' attribute of this Parameter instance.

Returns integer value indicating success/failure of the function.
This particular function only does one thing irrespective of user
input or  object state, and thus will only return a single value:

* LIBSBML_OPERATION_SUCCESS

In SBML Level 1 Version 1, parameters are required to have values and
therefore, the value of a Parameter should always be set.  In SBML
Level 1 Version 2 and beyond, the value is optional and as such, the
'value' attribute may or may not be set.
";


%feature("docstring") Parameter::unsetUnits "
Unsets the 'units' attribute of this Parameter instance.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED
";


%feature("docstring") Parameter::getDerivedUnitDefinition "
Constructs and returns a UnitDefinition that corresponds to the units
of this Parameter's value.

Parameters in SBML have an attribute ('units') for declaring the units
of measurement intended for the parameter's value.  No defaults are
defined by SBML in the absence of a definition for 'units'.  This
method returns a UnitDefinition object based on the units declared for
this Parameter using its 'units' attribute, or it returns 'None' if no
units have been declared.

Note that unit declarations for Parameter objects are specified in
terms of the identifier of a unit (e.g., using setUnits()), but this
method returns a UnitDefinition object, not a unit identifier.  It
does this by constructing an appropriate UnitDefinition.For SBML Level
2 models, it will do this even when the value of the 'units' attribute
is one of the special SBML Level 2 unit identifiers ''substance','
''volume',' ''area',' ''length'' or ''time'.'  Callers may find this
useful in conjunction with the helper methods provided by the
UnitDefinition class for comparing different UnitDefinition objects.

Returns a UnitDefinition that expresses the units of this  Parameter,
or 'None' if one cannot be constructed.

Note: The libSBML system for unit analysis depends on the model as a
whole.  In cases where the Parameter object has not yet been added to
a model, or the model itself is incomplete, unit analysis is not
possible, and consequently this method will return 'None.'

See also isSetUnits().
";


%feature("docstring") Parameter::getTypeCode "
Returns the libSBML type code for this SBML object.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for this object: SBML_PARAMETER (default).

WARNING:

The specific integer values of the possible type codes may be reused
by different libSBML plug-ins for SBML Level 3. packages,  To fully
identify the correct code, it is necessary to invoke both
getTypeCode() and getPackageName().

See also getElementName(), getPackageName().
";


%feature("docstring") Parameter::getElementName "
Returns the XML element name of this object, which for Parameter, is
always ''parameter'.'

Returns the name of this element, i.e., ''parameter'.'
";


%feature("docstring") Parameter::writeElements "
Internal implementation method.
";


%feature("docstring") Parameter::hasRequiredAttributes "
Predicate returning 'True' if all the required attributes for this
Parameter object have been set.

The required attributes for a Parameter object are:

* 'id' (or 'name' in SBML Level 1)

* 'value' (required in Level 1, optional otherwise)

Returns 'True' if the required attributes have been set, 'False'
otherwise.
";


%feature("docstring") Parameter::renameUnitSIdRefs "
Renames all the 'UnitSIdRef' attributes on this element.

In SBML, unit definitions have identifiers of type UnitSId.  In SBML
Level 3, an explicit data type called UnitSIdRef was introduced for
attribute values that refer to UnitSId values; in previous Levels of
SBML, this data type did not exist and attributes were simply
described to as 'referring to a unit identifier', but the effective
data type was the same as UnitSIdRef in Level 3.  These and other
methods of libSBML refer to the type UnitSIdRef for all Levels of
SBML, even if the corresponding SBML specification did not explicitly
name the data type.

This method works by looking at all unit identifier attribute values
(including, if appropriate, inside mathematical formulas), comparing
the unit identifiers to the value of 'oldid'.  If any matches are
found, the matching identifiers are replaced with 'newid'.  The method
does not descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") Parameter::setCalculatingUnits "
Internal implementation method.
";


%feature("docstring") Parameter::addExpectedAttributes "
Internal implementation method.
";


%feature("docstring") Parameter::readAttributes "
Internal implementation method.
";


%feature("docstring") Parameter::readL1Attributes "
Internal implementation method.
";


%feature("docstring") Parameter::readL2Attributes "
Internal implementation method.
";


%feature("docstring") Parameter::readL3Attributes "
Internal implementation method.
";


%feature("docstring") Parameter::writeAttributes "
Internal implementation method.
";


%feature("docstring") Parameter::isExplicitlySetConstant "
Internal implementation method.
";


%feature("docstring") Parameter::inferUnits "
Internal implementation method.
";


%feature("docstring") Parameter::inferUnitsFromAssignments "
Internal implementation method.
";


%feature("docstring") Parameter::inferUnitsFromRules "
Internal implementation method.
";


%feature("docstring") Parameter::inferUnitsFromReactions "
Internal implementation method.
";


%feature("docstring") Parameter::inferUnitsFromEvents "
Internal implementation method.
";


%feature("docstring") Parameter::inferUnitsFromEvent "
Internal implementation method.
";


%feature("docstring") Parameter::inferUnitsFromKineticLaw "
Internal implementation method.
";


%feature("docstring") Parameter::getCalculatingUnits "
Internal implementation method.
";


%feature("docstring") ListOfParameters::ListOfParameters "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    ListOfParameters(SBMLNamespaces sbmlns)

Creates a new ListOfParameters object.

The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in
'sbmlns'.

Parameter 'sbmlns' is an SBMLNamespaces object that is used to
determine the characteristics of the ListOfParameters object to be
created.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    ListOfParameters(long level, long version)

Creates a new ListOfParameters object.

The object is constructed such that it is valid for the given SBML
Level and Version combination.

Parameter 'level' is the SBML Level.

Parameter 'version' is the Version within the SBML Level.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.
";


%feature("docstring") ListOfParameters::clone "
Creates and returns a deep copy of this ListOfParameters object.

Returns the (deep) copy of this ListOfParameters object.
";


%feature("docstring") ListOfParameters::getItemTypeCode "
Returns the libSBML type code for the objects contained in this ListOf
(i.e., Parameter objects, if the list is non-empty).

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for this objects contained in this list:
SBML_PARAMETER (default).

See also getElementName(), getPackageName().
";


%feature("docstring") ListOfParameters::getElementName "
Returns the XML element name of this object.

For ListOfParameters, the XML element name is ''listOfParameters'.'

Returns the name of this element, i.e., ''listOfParameters'.'
";


%feature("docstring") ListOfParameters::get "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    get(long n)

Returns the Parameter object located at position 'n' within this
ListOfParameters instance.

Parameter 'n' is the index number of the Parameter to get.

Returns the nth Parameter in this ListOfParameters.  If the index 'n'
is out of bounds for the length of the list, then 'None' is returned.

See also size(), get().

______________________________________________________________________
Method variant with the following signature:

    get(string sid)

Returns the first Parameter object matching the given identifier.

Parameter 'sid' is a string representing the identifier of the
Parameter to get.

Returns the Parameter object found.  The caller owns the returned
object and is responsible for deleting it.  If none of the items have
an identifier matching 'sid', then 'None' is returned.

See also get(), size().
";


%feature("docstring") ListOfParameters::remove "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    remove(long n)

Removes the nth item from this ListOfParameters, and returns a pointer
to it.

Parameter 'n' is the index of the item to remove.

Returns the item removed.  The caller owns the returned object and is
responsible for deleting it.  If the index number 'n' is out of bounds
for the length of the list, then 'None' is returned.

See also size().

______________________________________________________________________
Method variant with the following signature:

    remove(string sid)

Removes the first Parameter object in this ListOfParameters matching
the given identifier, and returns a pointer to it.

Parameter 'sid' is the identifier of the item to remove.

Returns the item removed.  The caller owns the returned object and is
responsible for deleting it.  If none of the items have an identifier
matching 'sid', then 'None' is returned.
";


%feature("docstring") ListOfParameters::getElementPosition "
Internal implementation method.
";


%feature("docstring") ListOfParameters::createObject "
Internal implementation method.
";


%feature("docstring") LocalParameter "
A parameter inside an SBML reaction definition.

LocalParameter has been introduced in SBML Level 3 to serve as the
object class for parameter definitions that are intended to be local
to a Reaction.  Objects of class LocalParameter never appear at the
Model level; they are always contained within ListOfLocalParameters
lists which are in turn contained within KineticLaw objects.

Like its global Parameter counterpart, the LocalParameter object class
is used to define a symbol associated with a value; this symbol can
then be used in a model's mathematical formulas (and specifically, for
LocalParameter, reaction rate formulas).  Unlike Parameter, the
LocalParameter class does not have a 'constant' attribute: local
parameters within reactions are always constant.

LocalParameter has one required attribute, 'id', to give the parameter
a unique identifier by which other parts of an SBML model definition
can refer to it.  A parameter can also have an optional 'name'
attribute of type 'string.'  Identifiers and names must be used
according to the guidelines described in the SBML specifications.

The optional attribute 'value' determines the value (of type 'float)'
assigned to the parameter.  A missing value for 'value' implies that
the value either is unknown, or to be obtained from an external
source, or determined by an initial assignment.  The unit of
measurement associated with the value of the parameter can be
specified using the optional attribute 'units'.  Here we only mention
briefly some notable points about the possible unit choices, but
readers are urged to consult the SBML specification documents for more
information:

* In SBML Level 3, there are no constraints on the units that can be
assigned to parameters in a model; there are also no units to inherit
from the enclosing Model object.

* In SBML Level 2, the value assigned to the parameter's 'units'
attribute must be chosen from one of the following possibilities: one
of the base unit identifiers defined in SBML; one of the built-in unit
identifiers ''substance',' ''time',' ''volume',' ''area'' or
''length';' or the identifier of a new unit defined in the list of
unit definitions in the enclosing Model structure.  There are no
constraints on the units that can be chosen from these sets.  There
are no default units for local parameters. As with all other major
SBML components, LocalParameter is derived from SBase, and the methods
defined on SBase are available on LocalParameter.

In SBML Level 3 Version 2, the scope of the LocalParameter  was
expanded slightly to officially encompass the entire Reaction instead
of just the KineticLaw in which it appears.  This has no effect on
models using only SBML Level 3 Core constructs, but has the potential
to allow SBML Level 3 Packages to include elements in a Reaction that
could reference a LocalParameter from that Reaction's KineticLaw.  It
also means that no LocalParameter may have the same ''id'' as a
referenced Species in any SimpleSpeciesReference in that Reaction.

WARNING:

LibSBML derives LocalParameter from Parameter; however, this does not
precisely match the object hierarchy defined by SBML Level 3, where
LocalParameter is derived directly from SBase and not Parameter.  We
believe this arrangement makes it easier for libSBML users to program
applications that work with both SBML Level 2 and SBML Level 3, but
programmers should also keep in mind this difference exists.  A side-
effect of libSBML's scheme is that certain methods on LocalParameter
that are inherited from Parameter do not actually have relevance to
LocalParameter objects.  An example of this is the methods pertaining
to Parameter's attribute 'constant' (i.e., isSetConstant(),
setConstant(), and getConstant()).

See also ListOfLocalParameters, KineticLaw.
";


%feature("docstring") ListOfLocalParameters "
A list of LocalParameter objects.

The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  In libSBML's
implementation, ListOf___ classes are derived from the intermediate
utility class ListOf, which is not defined by the SBML specifications
but serves as a useful programmatic construct.  ListOf is itself is in
turn derived from SBase, which provides all of the various ListOf___
classes with common features defined by the SBML specification, such
as 'metaid' attributes and annotations.

The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level 2 Version 4):

  <?xml version=\"1.0\" encoding=\"UTF-8\"?>
  <sbml xmlns=\"http://www.sbml.org/sbml/level3/version1/core\" 
        level=\"3\" version=\"1\">
    <model id=\"My_Model\">
      <listOfFunctionDefinitions>
        <functionDefinition> ... </functionDefinition> 
      </listOfFunctionDefinitions>
      <listOfUnitDefinitions>
        <unitDefinition> ... </unitDefinition> 
      </listOfUnitDefinitions>
      <listOfCompartments>
        <compartment> ... </compartment> 
      </listOfCompartments>
      <listOfSpecies>
        <species> ... </species> 
      </listOfSpecies>
      <listOfParameters>
        <parameter> ... </parameter> 
      </listOfParameters>
      <listOfInitialAssignments>
        <initialAssignment> ... </initialAssignment> 
      </listOfInitialAssignments>
      <listOfRules>
        ... elements of subclasses of Rule ...
      </listOfRules>
      <listOfConstraints>
        <constraint> ... </constraint> 
      </listOfConstraints>
      <listOfReactions>
        <reaction> ... </reaction> 
      </listOfReactions>
      <listOfEvents>
        <event> ... </event> 
      </listOfEvents>
    </model>
  </sbml>

SBML Level 3 Version 1 has essentially the same structure as  Level
2 Version 4, depicted above, but SBML Level 3  Version 2 allows
containers to contain zero or more of the relevant object, instead of
requiring at least one.  As such, libsbml will write out an
otherwise-empty ListOf___ element that has any optional attribute set
(such as 'id' or 'metaid'), that has an optional child (such  as a
'notes' or 'annotation'), or that has attributes or children set from
any SBML Level 3 package, whether or not the ListOf___ has  any other
children.

Readers may wonder about the motivations for using the ListOf___
containers in SBML.  A simpler approach in XML might be to place the
components all directly at the top level of the model definition.  The
choice made in SBML is to group them within XML elements named after
ListOfClassname, in part because it helps organize the components.
More importantly, the fact that the container classes are derived from
SBase means that software tools can add information about the lists
themselves into each list container's 'annotation'.

See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.
";


%feature("docstring") LocalParameter::LocalParameter "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    LocalParameter(SBMLNamespaces sbmlns)

Creates a new LocalParameter object with the given SBMLNamespaces
object 'sbmlns'.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

It is worth emphasizing that although this constructor does not take
an identifier argument, in SBML Level 2 and beyond, the 'id'
(identifier) attribute of a LocalParameter is required to have a
value. Thus, callers are cautioned to assign a value after calling
this constructor if no identifier is provided as an argument.  Setting
the identifier can be accomplished using the method setId().

Parameter 'sbmlns' is an SBMLNamespaces object.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    LocalParameter(long level, long version)

Creates a new LocalParameter object with the given SBML 'level' and
'version' values.

Parameter 'level' is a long integer, the SBML Level to assign to this
LocalParameter.

Parameter 'version' is a long integer, the SBML Version to assign to
this LocalParameter.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    LocalParameter(LocalParameter orig)

Copy constructor; creates a copy of a given LocalParameter object.

Parameter 'orig' is the LocalParameter instance to copy.

______________________________________________________________________
Method variant with the following signature:

    LocalParameter(Parameter orig)

Copy constructor; creates a LocalParameter object by copying the
attributes of a given Parameter object.

Parameter 'orig' is the Parameter instance to copy.
";


%feature("docstring") LocalParameter::accept "
Internal implementation method.
";


%feature("docstring") LocalParameter::clone "
Creates and returns a deep copy of this LocalParameter object.

Returns the (deep) copy of this LocalParameter object.
";


%feature("docstring") LocalParameter::getDerivedUnitDefinition "
Constructs and returns a UnitDefinition that corresponds to the units
of this LocalParameter's value.

LocalParameters in SBML have an attribute ('units') for declaring the
units of measurement intended for the parameter's value.  No defaults
are defined by SBML in the absence of a definition for 'units'.  This
method returns a UnitDefinition object based on the units declared for
this LocalParameter using its 'units' attribute, or it returns 'None'
if no units have been declared.

Note that unit declarations for LocalParameter objects are specified
in terms of the identifier of a unit (e.g., using setUnits()), but
this method returns a UnitDefinition object, not a unit identifier.
It does this by constructing an appropriate UnitDefinition.  For SBML
Level 2 models, it will do this even when the value of the 'units'
attribute is one of the predefined SBML units ''substance','
''volume',' ''area',' ''length'' or ''time'.'  Callers may find this
useful in conjunction with the helper methods provided by the
UnitDefinition class for comparing different UnitDefinition objects.

Returns a UnitDefinition that expresses the units of this
LocalParameter, or 'None' if one cannot be constructed.

Note: The libSBML system for unit analysis depends on the model as a
whole.  In cases where the LocalParameter object has not yet been
added to a model, or the model itself is incomplete, unit analysis is
not possible, and consequently this method will return 'None.'

See also isSetUnits().
";


%feature("docstring") LocalParameter::getTypeCode "
Returns the libSBML type code for this SBML object.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for this object: SBML_LOCAL_PARAMETER
(default).

WARNING:

The specific integer values of the possible type codes may be reused
by different libSBML plug-ins for SBML Level 3. packages,  To fully
identify the correct code, it is necessary to invoke both
getTypeCode() and getPackageName().

See also getElementName(), getPackageName().
";


%feature("docstring") LocalParameter::getElementName "
Returns the XML element name of this object, which for LocalParameter,
is always ''localParameter'.'

Returns the name of this element, i.e., ''localParameter'.'
";


%feature("docstring") LocalParameter::hasRequiredAttributes "
Predicate returning 'True' if all the required attributes for this
LocalParameter object have been set.

The required attributes for a LocalParameter object are:

* 'id'

* 'value'

Returns 'True' if the required attributes have been set, 'False'
otherwise.
";


%feature("docstring") LocalParameter::getConstant "
Internal implementation method.
";


%feature("docstring") LocalParameter::isSetConstant "
Internal implementation method.
";


%feature("docstring") LocalParameter::setConstant "
Internal implementation method.
";


%feature("docstring") LocalParameter::unsetConstant "
Internal implementation method.
";


%feature("docstring") LocalParameter::addExpectedAttributes "
Internal implementation method.
";


%feature("docstring") LocalParameter::readAttributes "
Internal implementation method.
";


%feature("docstring") LocalParameter::readL3Attributes "
Internal implementation method.
";


%feature("docstring") LocalParameter::writeAttributes "
Internal implementation method.
";


%feature("docstring") ListOfLocalParameters::ListOfLocalParameters "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    ListOfLocalParameters(SBMLNamespaces sbmlns)

Creates a new ListOfLocalParameters object.

The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in
'sbmlns'.

Parameter 'sbmlns' is an SBMLNamespaces object that is used to
determine the characteristics of the ListOfLocalParameters object to
be created.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    ListOfLocalParameters(long level, long version)

Creates a new ListOfLocalParameters object.

The object is constructed such that it is valid for the given SBML
Level and Version combination.

Parameter 'level' is the SBML Level.

Parameter 'version' is the Version within the SBML Level.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.
";


%feature("docstring") ListOfLocalParameters::clone "
Creates and returns a deep copy of this ListOfLocalParameters object.

Returns the (deep) copy of this ListOfLocalParameters object.
";


%feature("docstring") ListOfLocalParameters::getItemTypeCode "
Returns the libSBML type code for the objects contained in this ListOf
(i.e., LocalParameter objects, if the list is non-empty).

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for the objects contained in this ListOf:
SBML_LOCAL_PARAMETER (default).

See also getElementName(), getPackageName().
";


%feature("docstring") ListOfLocalParameters::getElementName "
Returns the XML element name of this object.

For ListOfLocalParameters, the XML element name is
''listOfLocalParameters'.'

Returns the name of this element, i.e., ''listOfLocalParameters'.'
";


%feature("docstring") ListOfLocalParameters::get "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    get(long n)

Returns the LocalParameter object located at position 'n' within this
ListOfLocalParameters instance.

Parameter 'n' is the index number of the LocalParameter to get.

Returns the item at position 'n'.  The caller owns the returned object
and is responsible for deleting it.  If the index number 'n' is out of
bounds for the length of the list, then 'None' is returned.

See also size(), get().

______________________________________________________________________
Method variant with the following signature:

    get(string sid)

Returns the first LocalParameter object matching the given identifier.

Parameter 'sid' is a string representing the identifier of the
LocalParameter to get.

Returns the LocalParameter object found.  The caller owns the returned
object and is responsible for deleting it.  If none of the items have
an identifier matching 'sid', then 'None' is returned.

See also get(), size().
";


%feature("docstring") ListOfLocalParameters::getElementBySId "
Returns the first child element found that has the given 'id' in the
model-wide SId namespace, or 'None' if no such object is found.

Note that LocalParameters, while they use the SId namespace, are not
in the model-wide SId namespace, so no LocalParameter object will be
returned from this function (and is the reason we override the base
ListOf::getElementBySId function here).

Parameter 'id' is string representing the id of the object to find.

Returns pointer to the first element found with the given 'id'.
";


%feature("docstring") ListOfLocalParameters::remove "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    remove(long n)

Removes the nth item from this ListOfLocalParameters, and returns a
pointer to it.

Parameter 'n' is the index of the item to remove.

Returns the item removed.  The caller owns the returned object and is
responsible for deleting it.  If the index number 'n' is out of bounds
for the length of the list, then 'None' is returned.

See also size(), remove().

______________________________________________________________________
Method variant with the following signature:

    remove(string sid)

Removes the first LocalParameter object in this ListOfLocalParameters
matching the given identifier, and returns a pointer to it.

Parameter 'sid' is the identifier of the item to remove.

Returns the item removed.  The caller owns the returned object and is
responsible for deleting it.  If none of the items have an identifier
matching 'sid', then 'None' is returned.
";


%feature("docstring") ListOfLocalParameters::getElementPosition "
Internal implementation method.
";


%feature("docstring") ListOfLocalParameters::createObject "
Internal implementation method.
";


%feature("docstring") InitialAssignment "
An SBML initial assignment, evaluated once only.

SBML Level 2 Versions 2-4 and SBML Level 3 provide two ways of
assigning initial values to entities in a model.  The simplest and
most basic is to set the values of the appropriate attributes in the
relevant components; for example, the initial value of a model
parameter (whether it is a constant or a variable) can be assigned by
setting its 'value' attribute directly in the model definition.
However, this approach is not suitable when the value must be
calculated, because the initial value attributes on different
components such as species, compartments, and parameters are single
values and not mathematical expressions.  In those situations, the
InitialAssignment construct can be used; it permits the calculation of
the value of a constant or the initial value of a variable from the
values of other quantities in a model.

As explained below, the provision of InitialAssignment does not mean
that models necessarily must use this construct when defining initial
values of quantities in a model.  If a value can be set directly using
the relevant attribute of a component in a model, then that approach
may be more efficient and more portable to other software tools.
InitialAssignment should be used when the other mechanism is
insufficient for the needs of a particular model.

The InitialAssignment construct has some similarities to
AssignmentRule. The main differences are: (a) an InitialAssignment can
set the value of a constant whereas an AssignmentRule cannot, and (b)
unlike AssignmentRule, an InitialAssignment definition only applies up
to and including the beginning of simulation time, i.e., t <= 0, while
an AssignmentRule applies at all times.

InitialAssignment has a required attribute, 'symbol', whose value must
follow the guidelines for identifiers described in the SBML
specification (e.g., Section 3.3 in the Level 2 Version 4
specification).  The value of this attribute in an InitialAssignment
object can be the identifier of a Compartment, Species,
SpeciesReference  (in SBML Level 3),  global Parameter, or (as of SBML
Level 3 Version 2) the identifier of a SBML Level 3  package element
with mathematical meaning.  The InitialAssignment defines the initial
value of the constant or variable referred to by the 'symbol'
attribute.  (The attribute's name is 'symbol' rather than 'variable'
because it may assign values to constants as well as variables in a
model.)  Note that an initial assignment cannot be made to reaction
identifiers, that is, the 'symbol' attribute value of an
InitialAssignment cannot be an identifier that is the 'id' attribute
value of a Reaction object in the model.  This is identical to a
restriction placed on rules.

InitialAssignment also has a 'math' subelement that contains a MathML
expression used to calculate the value of the constant or the initial
value of the variable.  This subelement is required in SBML Level 2
and SBML Level 3 Version 1, but the requirement was relaxed in SBML
Level 3 Version 2, making it optional. The units of the value computed
by the formula in the 'math' subelement  should (in SBML Level 2
Version 4 and in SBML Level 3)  or must (in previous Versions) be
identical to be the units associated with the identifier given in the
'symbol' attribute. (That is, the units are the units of the species,
compartment, or parameter, as appropriate for the kind of object
identified by the value of 'symbol'.)

InitialAssignment was introduced in SBML Level 2 Version 2.  It is not
available in SBML Level 2 Version 1 nor in any version of Level 1.

Semantics of Initial Assignments
======================================================================

The value calculated by an InitialAssignment object overrides the
value assigned to the given symbol by the object defining that symbol.
For example, if a compartment's 'size' attribute is set in its
definition, and the model also contains an InitialAssignment having
that compartment's identifier as its 'symbol' attribute value, then
the interpretation is that the 'size' assigned in the Compartment
object should be ignored and the value assigned based on the
computation defined in the InitialAssignment.  Initial assignments can
take place for Compartment, Species, global Parameter,
SpeciesReference (in  Level 3), and SBML Level 3 package elements (in
Level 3 Version 2), regardless of the value of their  'constant'
attribute.

The actions of all InitialAssignment objects are in general terms the
same, but differ in the precise details depending on the type of
variable being set:

* In the case of a species, an InitialAssignment sets the referenced
species' initial quantity (concentration or amount of substance) to
the value determined by the formula in the 'math' subelement.    The
overall units of the formula should (in SBML Level 2 Version 4 and in
SBML Level 3) or must (in previous Versions) be the same as the units
specified for the species.

* In the case of a compartment, an InitialAssignment sets the
referenced compartment's initial size to the size determined by the
formula in 'math'.  The overall units of the formula should (in SBML
Level 2 Version 4 and in SBML Level 3) or must (in previous Versions)
be the same as the units specified for the size of the compartment.

* In the case of a parameter, an InitialAssignment sets the referenced
parameter's initial value to that determined by the formula in 'math'.
The overall units of the formula should (in SBML Level 2 Version 4 and
SBML Level 3) or must (in previous Versions) be the same as the units
defined for the parameter.

* (For SBML Level 3 only) In the case of a species reference, an
initial assignment sets the initial value of the  stoichiometry of the
referenced reactant or product to the value determined  by the formula
in 'math'.  The unit associated with the value produced by  the 'math'
formula should be consistent with the unit 'dimensionless', because
reactant and product stoichiometries in reactions are dimensionless
quantities.

* (For SBML Level 3 Version 2 only) In the case  of an object from an
SBML Level 3 package, an InitialAssignment  sets the referenced
object's initial value (however such values are  defined by the
package) to the value of the formula in math. The unit  of measurement
associated with the value produced by the formula  should be the same
as that object's units attribute value (if it has  such an attribute),
or be equal to the units of model components of  that type (if objects
of that class are defined by the package as  having the same units).

If the symbol attribute of an InitialAssignment object references  an
object in an SBML namespace that is not understood by the  interpreter
reading a given SBML document (that is, if the object  is defined by
an SBML Level 3 package that the software does  not support), the
assignment must be ignored--the object's initial  value will not need
to be set, as the interpreter could not understand  that package. If
an interpreter cannot establish whether a referenced  object is
missing from the model or instead is defined in an SBML  namespace not
understood by the interpreter, it may produce a  warning to the user.
(The latter situation may only arise if an SBML  package is present in
the SBML document with a package:required  attribute of 'true'.)

In the context of a simulation, initial assignments establish values
that are in effect prior to and including the start of simulation
time, i.e., t <= 0.  Section 3.4.8 in the SBML Level 2 Version 4  and
SBML Level 3 specifications  provides information about the
interpretation of assignments, rules, and entity values for simulation
time up to and including the start time t = 0; this is important for
establishing the initial conditions of a simulation if the model
involves expressions containing the delay 'csymbol'.

There cannot be two initial assignments for the same symbol in a
model; that is, a model must not contain two or more InitialAssignment
objects that both have the same identifier as their 'symbol' attribute
value.  A model must also not define initial assignments and
assignment rules for the same entity.  That is, there cannot be both
an InitialAssignment and an AssignmentRule for the same symbol in a
model, because both kinds of constructs apply prior to and at the
start of simulated time---allowing both to exist for a given symbol
would result in indeterminism).

The ordering of InitialAssignment objects is not significant.  The
combined set of InitialAssignment, AssignmentRule and KineticLaw
objects form a set of assignment statements that must be considered as
a whole.  The combined set of assignment statements should not contain
algebraic loops: a chain of dependency between these statements should
terminate.  (More formally, consider the directed graph of assignment
statements where nodes are a model's assignment statements and
directed arcs exist for each occurrence of a symbol in an assignment
statement 'math' attribute.  The directed arcs in this graph start
from the statement assigning the symbol and end at the statement that
contains the symbol in their math elements.  Such a graph must be
acyclic.)

Finally, it is worth being explicit about the expected behavior in the
following situation.  Suppose (1) a given symbol has a value x
assigned to it in its definition, and (2) there is an initial
assignment having the identifier as its 'symbol' value and reassigning
the value to y, and (3) the identifier is also used in the
mathematical formula of a second initial assignment.  What value
should the second initial assignment use?  It is y, the value assigned
to the symbol by the first initial assignment, not whatever value was
given in the symbol's definition.  This follows directly from the
behavior described above: if an InitialAssignment object exists for a
given symbol, then the symbol's value is overridden by that initial
assignment.
";


%feature("docstring") ListOfInitialAssignments "
A list of InitialAssignment objects.

The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  In libSBML's
implementation, ListOf___ classes are derived from the intermediate
utility class ListOf, which is not defined by the SBML specifications
but serves as a useful programmatic construct.  ListOf is itself is in
turn derived from SBase, which provides all of the various ListOf___
classes with common features defined by the SBML specification, such
as 'metaid' attributes and annotations.

The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level 2 Version 4):

  <?xml version=\"1.0\" encoding=\"UTF-8\"?>
  <sbml xmlns=\"http://www.sbml.org/sbml/level3/version1/core\" 
        level=\"3\" version=\"1\">
    <model id=\"My_Model\">
      <listOfFunctionDefinitions>
        <functionDefinition> ... </functionDefinition> 
      </listOfFunctionDefinitions>
      <listOfUnitDefinitions>
        <unitDefinition> ... </unitDefinition> 
      </listOfUnitDefinitions>
      <listOfCompartments>
        <compartment> ... </compartment> 
      </listOfCompartments>
      <listOfSpecies>
        <species> ... </species> 
      </listOfSpecies>
      <listOfParameters>
        <parameter> ... </parameter> 
      </listOfParameters>
      <listOfInitialAssignments>
        <initialAssignment> ... </initialAssignment> 
      </listOfInitialAssignments>
      <listOfRules>
        ... elements of subclasses of Rule ...
      </listOfRules>
      <listOfConstraints>
        <constraint> ... </constraint> 
      </listOfConstraints>
      <listOfReactions>
        <reaction> ... </reaction> 
      </listOfReactions>
      <listOfEvents>
        <event> ... </event> 
      </listOfEvents>
    </model>
  </sbml>

SBML Level 3 Version 1 has essentially the same structure as  Level
2 Version 4, depicted above, but SBML Level 3  Version 2 allows
containers to contain zero or more of the relevant object, instead of
requiring at least one.  As such, libsbml will write out an
otherwise-empty ListOf___ element that has any optional attribute set
(such as 'id' or 'metaid'), that has an optional child (such  as a
'notes' or 'annotation'), or that has attributes or children set from
any SBML Level 3 package, whether or not the ListOf___ has  any other
children.

Readers may wonder about the motivations for using the ListOf___
containers in SBML.  A simpler approach in XML might be to place the
components all directly at the top level of the model definition.  The
choice made in SBML is to group them within XML elements named after
ListOfClassname, in part because it helps organize the components.
More importantly, the fact that the container classes are derived from
SBase means that software tools can add information about the lists
themselves into each list container's 'annotation'.

See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.
";


%feature("docstring") InitialAssignment::InitialAssignment "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    InitialAssignment(SBMLNamespaces sbmlns)

Creates a new InitialAssignment using the given SBMLNamespaces object
'sbmlns'.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

Parameter 'sbmlns' is an SBMLNamespaces object.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    InitialAssignment(long level, long version)

Creates a new InitialAssignment using the given SBML 'level' and
'version' values.

Parameter 'level' is a long integer, the SBML Level to assign to this
InitialAssignment.

Parameter 'version' is a long integer, the SBML Version to assign to
this InitialAssignment.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    InitialAssignment(InitialAssignment orig)

Copy constructor; creates a copy of this InitialAssignment.

Parameter 'orig' is the object to copy.
";


%feature("docstring") InitialAssignment::accept "
Internal implementation method.
";


%feature("docstring") InitialAssignment::clone "
Creates and returns a deep copy of this InitialAssignment object.

Returns the (deep) copy of this InitialAssignment object.
";


%feature("docstring") InitialAssignment::getSymbol "
Get the value of the 'symbol' attribute of this InitialAssignment.

Returns the identifier string stored as the 'symbol' attribute value
in this InitialAssignment.
";


%feature("docstring") InitialAssignment::getMath "
Get the mathematical formula of this InitialAssignment.

Returns an ASTNode, the value of the 'math' subelement of this
InitialAssignment, or 'None' if the math is not set.
";


%feature("docstring") InitialAssignment::isSetSymbol "
Predicate returning 'True' if this InitialAssignment's 'symbol'
attribute is set.

Returns 'True' if the 'symbol' attribute of this InitialAssignment is
set, 'False' otherwise.
";


%feature("docstring") InitialAssignment::isSetMath "
Predicate returning 'True' if this InitialAssignment's 'math'
subelement contains a value.

Returns 'True' if the 'math' for this InitialAssignment is set,
'False' otherwise.
";


%feature("docstring") InitialAssignment::setSymbol "
Sets the 'symbol' attribute value of this InitialAssignment.

Parameter 'sid' is the identifier of an element defined in this model
whose value can be set.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") InitialAssignment::unsetSymbol "
Unsets the 'symbol' attribute value of this InitialAssignment.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE
";


%feature("docstring") InitialAssignment::setMath "
Sets the 'math' subelement of this InitialAssignment.

The AST passed in 'math' is copied.

Parameter 'math' is an AST containing the mathematical expression to
be used as the formula for this InitialAssignment.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_OBJECT
";


%feature("docstring") InitialAssignment::getDerivedUnitDefinition "
Calculates and returns a UnitDefinition that expresses the units of
measurement assumed for the 'math' expression of this
InitialAssignment.

The units are calculated based on the mathematical expression in the
InitialAssignment and the model quantities referenced by <ci> elements
used within that expression.  The method
InitialAssignment.getDerivedUnitDefinition() returns the calculated
units, to the extent that libSBML can compute them.

Note: The functionality that facilitates unit analysis depends on the
model as a whole.  Thus, in cases where the object has not been added
to a model or the model itself is incomplete, unit analysis is not
possible and this method will return 'None.'

WARNING:

Note that it is possible the 'math' expression in the
InitialAssignment contains literal numbers or parameters with
undeclared units.  In those cases, it is not possible to calculate the
units of the overall expression without making assumptions.  LibSBML
does not make assumptions about the units, and
InitialAssignment.getDerivedUnitDefinition() only returns the units as
far as it is able to determine them.  For example, in an expression X
+ Y, if X has unambiguously-defined units and Y does not, it will
return the units of X.  When using this method, it is critical that
callers also invoke the method
InitialAssignment.containsUndeclaredUnits() to determine whether this
situation holds.  Callers should take suitable action in those
situations.

Returns a UnitDefinition that expresses the units of the math
expression of this InitialAssignment, or 'None' if one cannot be
constructed.

See also containsUndeclaredUnits().
";


%feature("docstring") InitialAssignment::containsUndeclaredUnits "
Predicate returning 'True' if the math expression of this
InitialAssignment contains parameters/numbers with undeclared units.

Returns 'True' if the math expression of this InitialAssignment
includes parameters/numbers  with undeclared units, 'False' otherwise.

Note: A return value of 'True' indicates that the UnitDefinition
returned by InitialAssignment::getDerivedUnitDefinition may not
accurately represent the units of the expression.

See also getDerivedUnitDefinition().
";


%feature("docstring") InitialAssignment::getTypeCode "
Returns the libSBML type code for this SBML object.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for this object: SBML_INITIAL_ASSIGNMENT
(default).

WARNING:

The specific integer values of the possible type codes may be reused
by different libSBML plug-ins for SBML Level 3. packages,  To fully
identify the correct code, it is necessary to invoke both
getTypeCode() and getPackageName().

See also getElementName(), getPackageName().
";


%feature("docstring") InitialAssignment::getElementName "
Returns the XML element name of this object, which for
InitialAssignment, is always ''initialAssignment'.'

Returns the name of this element, i.e., ''initialAssignment'.'
";


%feature("docstring") InitialAssignment::writeElements "
Internal implementation method.
";


%feature("docstring") InitialAssignment::hasRequiredAttributes "
Predicate returning 'True' if all the required attributes for this
InitialAssignment object have been set.

The required attributes for an InitialAssignment object are:

* 'symbol'

Returns 'True' if the required attributes have been set, 'False'
otherwise.
";


%feature("docstring") InitialAssignment::hasRequiredElements "
Predicate returning 'True' if all the required elements for this
InitialAssignment object have been set.

Note: The required elements for a InitialAssignment object are:

* 'math' inSBML Level 2 and Level 3 Version 1.   (In SBML Level 3
Version 2+, it is no longer required.)

Returns a boolean value indicating whether all the required elements
for this object have been defined.
";


%feature("docstring") InitialAssignment::getId "
Returns the value of the 'symbol' attribute of this InitialAssignment
(NOT the 'id').

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
getIdAttribute() or InitialAssignment.getSymbol()  functions instead.

The 'symbol' attribute of an InitialAssignment indicates the element
which the results of the 'math' are to be applied.

Returns the symbol of this InitialAssignment.

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute(), getSymbol().
";


%feature("docstring") InitialAssignment::renameSIdRefs "
Replaces all uses of a given 'SIdRef' type attribute value with
another value.

In SBML, object identifiers are of a data type called SId. In SBML
Level 3, an explicit data type called SIdRef was introduced for
attribute values that refer to SId values; in previous Levels of SBML,
this data type did not exist and attributes were simply described to
as 'referring to an identifier', but the effective data type was the
same as SIdRef in Level 3.  These and other methods of libSBML refer
to the type SIdRef for all Levels of SBML, even if the corresponding
SBML specification did not explicitly name the data type.

This method works by looking at all attributes and (if appropriate)
mathematical formulas in MathML content, comparing the referenced
identifiers to the value of 'oldid'.  If any matches are found, the
matching values are replaced with 'newid'.  The method does not
descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") InitialAssignment::renameUnitSIdRefs "
Replaces all uses of a given 'UnitSIdRef' type attribute value with
another value.

In SBML, unit definitions have identifiers of type UnitSId.  In SBML
Level 3, an explicit data type called UnitSIdRef was introduced for
attribute values that refer to UnitSId values; in previous Levels of
SBML, this data type did not exist and attributes were simply
described to as 'referring to a unit identifier', but the effective
data type was the same as UnitSIdRef in Level 3.  These and other
methods of libSBML refer to the type UnitSIdRef for all Levels of
SBML, even if the corresponding SBML specification did not explicitly
name the data type.

This method works by looking at all unit identifier attribute values
(including, if appropriate, inside mathematical formulas), comparing
the referenced unit identifiers to the value of 'oldid'.  If any
matches are found, the matching values are replaced with 'newid'.  The
method does not descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") InitialAssignment::replaceSIDWithFunction "
Internal implementation method.
";


%feature("docstring") InitialAssignment::divideAssignmentsToSIdByFunction "
Internal implementation method.
";


%feature("docstring") InitialAssignment::multiplyAssignmentsToSIdByFunction "
Internal implementation method.
";


%feature("docstring") InitialAssignment::readOtherXML "
Internal implementation method.
";


%feature("docstring") InitialAssignment::addExpectedAttributes "
Internal implementation method.
";


%feature("docstring") InitialAssignment::readAttributes "
Internal implementation method.
";


%feature("docstring") InitialAssignment::readL2Attributes "
Internal implementation method.
";


%feature("docstring") InitialAssignment::readL3Attributes "
Internal implementation method.
";


%feature("docstring") InitialAssignment::writeAttributes "
Internal implementation method.
";


%feature("docstring") ListOfInitialAssignments::ListOfInitialAssignments "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    ListOfInitialAssignments(SBMLNamespaces sbmlns)

Creates a new ListOfInitialAssignments object.

The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in
'sbmlns'.

Parameter 'sbmlns' is an SBMLNamespaces object that is used to
determine the characteristics of the ListOfInitialAssignments object
to be created.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    ListOfInitialAssignments(long level, long version)

Creates a new ListOfInitialAssignments object.

The object is constructed such that it is valid for the given SBML
Level and Version combination.

Parameter 'level' is the SBML Level.

Parameter 'version' is the Version within the SBML Level.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.
";


%feature("docstring") ListOfInitialAssignments::clone "
Creates and returns a deep copy of this ListOfInitialAssignments
object.

Returns the (deep) copy of this ListOfInitialAssignments object.
";


%feature("docstring") ListOfInitialAssignments::getItemTypeCode "
Returns the libSBML type code for the objects contained in this ListOf
(i.e., InitialAssignment objects, if the list is non-empty).

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for the objects contained in this ListOf:
SBML_INITIAL_ASSIGNMENT (default).

See also getElementName(), getPackageName().
";


%feature("docstring") ListOfInitialAssignments::getElementName "
Returns the XML element name of this object.

For ListOfInitialAssignments, the XML element name is
''listOfInitialAssignments'.'

Returns the name of this element, i.e., ''listOfInitialAssignments'.'
";


%feature("docstring") ListOfInitialAssignments::get "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    get(long n)

Get a InitialAssignment from the ListOfInitialAssignments.

Parameter 'n' is the index number of the InitialAssignment to get.

Returns the nth InitialAssignment in this ListOfInitialAssignments.

See also size().

______________________________________________________________________
Method variant with the following signature:

    get(string sid)

Get a InitialAssignment from the ListOfInitialAssignments based on its
identifier.

Parameter 'sid' is a string representing the identifier  of the
InitialAssignment to get.

Returns InitialAssignment in this ListOfInitialAssignments with the
given 'sid' or 'None' if no such InitialAssignment exists.

See also get(), size().
";


%feature("docstring") ListOfInitialAssignments::remove "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    remove(long n)

Removes the nth item from this ListOfInitialAssignments items and
returns a pointer to it.

The caller owns the returned item and is responsible for deleting it.

Parameter 'n' is the index of the item to remove.

See also size().

______________________________________________________________________
Method variant with the following signature:

    remove(string sid)

Removes item in this ListOfInitialAssignments items with the given
identifier.

The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier 'sid', then
'None' is returned.

Parameter 'sid' is the identifier of the item to remove.

Returns the item removed.  As mentioned above, the caller owns the
returned item.
";


%feature("docstring") ListOfInitialAssignments::getElementBySId "
Returns the first child element found that has the given 'id' in the
model-wide SId namespace, or 'None' if no such object is found.

Note that InitialAssignments do not actually have IDs, though the
libsbml interface pretends that they do: no initial assignment is
returned by this function.

Parameter 'id' is string representing the id of the object to find.

Returns pointer to the first element found with the given 'id'.
";


%feature("docstring") ListOfInitialAssignments::getElementPosition "
Internal implementation method.
";


%feature("docstring") ListOfInitialAssignments::createObject "
Internal implementation method.
";


%feature("docstring") Rule "
Parent class for SBML rules in libSBML.

In SBML, rules provide additional ways to define the values of
variables in a model, their relationships, and the dynamical behaviors
of those variables.  They enable encoding relationships that cannot be
expressed using Reaction nor InitialAssignment objects alone.

The libSBML implementation of rules mirrors the SBML Level 3
definition (which is in turn is very similar to the Level 2 Version 4
definition), with Rule being the parent class of three subclasses as
explained below.  The Rule class itself cannot be instantiated by user
programs and has no constructor; only the subclasses AssignmentRule,
AlgebraicRule and RateRule can be instantiated directly.

General summary of SBML rules
======================================================================

In SBML Level 3 as well as Level 2, rules are separated into three
subclasses for the benefit of model analysis software.  The three
subclasses are based on the following three different possible
functional forms (where x is a variable, f is some arbitrary function
returning a numerical result, V is a vector of variables that does not
include x, and W is a vector of variables that may include x):

   Algebraic:   left-hand side is zero               0 = f(W)     
   Assignment:  left-hand side is a scalar:          x = f(V)     
   Rate:        left-hand side is a rate-of-change:  dx/dt = f(W)

In their general form given above, there is little to distinguish
between assignment and algebraic rules.  They are treated as separate
cases for the following reasons:

* Assignment rules can simply be evaluated to calculate
intermediate values for use in numerical methods.  They are statements
of equality that hold at all times.  (For assignments that are only
performed once, see InitialAssignment.)

* SBML needs to place restrictions on assignment rules, for example
the restriction that assignment rules cannot contain algebraic loops.

* Some simulators do not contain numerical solvers capable of
solving unconstrained algebraic equations, and providing more direct
forms such as assignment rules may enable those simulators to process
models they could not process if the same assignments were put in the
form of general algebraic equations;

* Those simulators that can solve these algebraic equations make a
distinction between the different categories listed above; and

* Some specialized numerical analyses of models may only be
applicable to models that do not contain algebraic rules.

The approach taken to covering these cases in SBML is to define an
abstract Rule structure containing a subelement, 'math', to hold the
right-hand side expression, then to derive subtypes of Rule that add
attributes to distinguish the cases of algebraic, assignment and rate
rules.  The 'math' subelement must contain a MathML expression
defining the mathematical formula of the rule.  This MathML formula
must return a numerical value.  The formula can be an arbitrary
expression referencing the variables and other entities in an SBML
model.

Each of the three subclasses of Rule (AssignmentRule, AlgebraicRule,
RateRule) inherit the the 'math' subelement and other fields from
SBase. The AssignmentRule and RateRule classes add an additional
attribute, 'variable'.  See the definitions of AssignmentRule,
AlgebraicRule and RateRule for details about the structure and
interpretation of each one.

Additional restrictions on SBML rules
======================================================================

An important design goal of SBML rule semantics is to ensure that a
model's simulation and analysis results will not be dependent on when
or how often rules are evaluated.  To achieve this, SBML needs to
place two restrictions on rule use.  The first concerns algebraic
loops in the system of assignments in a model, and the second concerns
overdetermined systems.

A model must not contain algebraic loops
......................................................................

The combined set of InitialAssignment, AssignmentRule and KineticLaw
objects in a model constitute a set of assignment statements that
should be considered as a whole.  (A KineticLaw object is counted as
an assignment because it assigns a value to the symbol contained in
the 'id' attribute of the Reaction object in which it is defined.)
This combined set of assignment statements must not contain algebraic
loops---dependency chains between these statements must terminate.  To
put this more formally, consider a directed graph in which nodes are
assignment statements and directed arcs exist for each occurrence of
an SBML species, compartment or parameter symbol in an assignment
statement's 'math' subelement.  Let the directed arcs point from the
statement assigning the symbol to the statements that contain the
symbol in their 'math' subelement expressions. This graph must be
acyclic.

Similarly, the combined set of RateRule and Reaction objects
constitute  a set of definitions for the rates of change of various
model entities  (namely, the objects identified by the values of the
'variable' attributes  of the RateRule objects, and the 'species'
attributes of the SpeciesReference  objects in each Reaction).  In
SBML Level 3 Version 2, these rates  of change may be referenced
directly  using the rateOf csymbol, but may not thereby contain
algebraic  loops---dependency chains between these statements must
terminate.  More  formally, consider a directed graph in which the
nodes are the definitions  of different variables' rates of change,
and directed arcs exist for each  occurrence of a variable referenced
by a rateOf csymbol from any  RateRule or KineticLaw object in the
model.  Let the directed arcs point  from the variable referenced by
the rateOf csymbol (call it  x) to the variable(s) determined by the
'math' expression in which x appears.  This graph must be acyclic.

SBML does not specify when or how often rules should be evaluated.
Eliminating algebraic loops ensures that assignment statements can be
evaluated any number of times without the result of those evaluations
changing.  As an example, consider the set of equations x = x + 1, y =
z + 200 and z = y + 100.  If this set of equations were interpreted as
a set of assignment statements, it would be invalid because the rule
for x refers to x (exhibiting one type of loop), and the rule for y
refers to z while the rule for z refers back to y (exhibiting another
type of loop). Conversely, the following set of equations would
constitute a valid set of assignment statements: x = 10, y = z + 200,
and z = x + 100.

A model must not be overdetermined
......................................................................

An SBML model must not be overdetermined; that is, a model must not
define more equations than there are unknowns in a model.  A valid
SBML model that does not contain AlgebraicRule structures cannot be
overdetermined.

LibSBML implements the static analysis procedure described in Appendix
B of the SBML Level 3 specification for assessing whether a model is
overdetermined.

(In summary, assessing whether a given continuous, deterministic,
mathematical model is overdetermined does not require dynamic
analysis; it can be done by analyzing the system of equations created
from the model. One approach is to construct a bipartite graph in
which one set of vertices represents the variables and the other the
set of vertices represents the equations.  Place edges between
vertices such that variables in the system are linked to the equations
that determine them.  For algebraic equations, there will be edges
between the equation and each variable occurring in the equation.  For
ordinary differential equations (such as those defined by rate rules
or implied by the reaction rate definitions), there will be a single
edge between the equation and the variable determined by that
differential equation.  A mathematical model is overdetermined if the
maximal matchings of the bipartite graph contain disconnected vertexes
representing equations.  If one maximal matching has this property,
then all the maximal matchings will have this property; i.e., it is
only necessary to find one maximal matching.)

Rule types for SBML Level 1
======================================================================

SBML Level 1 uses a different scheme than SBML Level 2 and Level 3 for
distinguishing rules; specifically, it uses an attribute whose value
is drawn from an enumeration of 3 values.  LibSBML supports this using
methods that work with the enumeration values  listed below.

* RULE_TYPE_RATE: Indicates the rule is a 'rate' rule.

* RULE_TYPE_SCALAR: Indicates the rule is a 'scalar' rule.

* RULE_TYPE_INVALID: Indicates the rule type is unknown or not yet
set.
";


%feature("docstring") ListOfRules "
A list of Rule objects.

The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  In libSBML's
implementation, ListOf___ classes are derived from the intermediate
utility class ListOf, which is not defined by the SBML specifications
but serves as a useful programmatic construct.  ListOf is itself is in
turn derived from SBase, which provides all of the various ListOf___
classes with common features defined by the SBML specification, such
as 'metaid' attributes and annotations.

The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level 2 Version 4):

  <?xml version=\"1.0\" encoding=\"UTF-8\"?>
  <sbml xmlns=\"http://www.sbml.org/sbml/level3/version1/core\" 
        level=\"3\" version=\"1\">
    <model id=\"My_Model\">
      <listOfFunctionDefinitions>
        <functionDefinition> ... </functionDefinition> 
      </listOfFunctionDefinitions>
      <listOfUnitDefinitions>
        <unitDefinition> ... </unitDefinition> 
      </listOfUnitDefinitions>
      <listOfCompartments>
        <compartment> ... </compartment> 
      </listOfCompartments>
      <listOfSpecies>
        <species> ... </species> 
      </listOfSpecies>
      <listOfParameters>
        <parameter> ... </parameter> 
      </listOfParameters>
      <listOfInitialAssignments>
        <initialAssignment> ... </initialAssignment> 
      </listOfInitialAssignments>
      <listOfRules>
        ... elements of subclasses of Rule ...
      </listOfRules>
      <listOfConstraints>
        <constraint> ... </constraint> 
      </listOfConstraints>
      <listOfReactions>
        <reaction> ... </reaction> 
      </listOfReactions>
      <listOfEvents>
        <event> ... </event> 
      </listOfEvents>
    </model>
  </sbml>

SBML Level 3 Version 1 has essentially the same structure as  Level
2 Version 4, depicted above, but SBML Level 3  Version 2 allows
containers to contain zero or more of the relevant object, instead of
requiring at least one.  As such, libsbml will write out an
otherwise-empty ListOf___ element that has any optional attribute set
(such as 'id' or 'metaid'), that has an optional child (such  as a
'notes' or 'annotation'), or that has attributes or children set from
any SBML Level 3 package, whether or not the ListOf___ has  any other
children.

Readers may wonder about the motivations for using the ListOf___
containers in SBML.  A simpler approach in XML might be to place the
components all directly at the top level of the model definition.  The
choice made in SBML is to group them within XML elements named after
ListOfClassname, in part because it helps organize the components.
More importantly, the fact that the container classes are derived from
SBase means that software tools can add information about the lists
themselves into each list container's 'annotation'.

See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.
";


%feature("docstring") Rule::accept "
Internal implementation method.
";


%feature("docstring") Rule::clone "
Creates and returns a deep copy of this Rule object.

Returns the (deep) copy of this Rule object.
";


%feature("docstring") Rule::getFormula "
Returns the mathematical expression of this Rule in text-string form.

The text string is produced by SBML_formulaToString(); please consult
the documentation for that function to find out more about the format
of the text-string formula.

Returns the formula text string for this Rule.

Note: The attribute 'formula' is specific to SBML Level 1; in higher
Levels of SBML, it has been replaced with a subelement named 'math'.
However, libSBML provides a unified interface to the underlying math
expression and this method can be used for models of all Levels of
SBML.

See also getMath().
";


%feature("docstring") Rule::getMath "
Get the mathematical formula of this Rule as an ASTNode tree.

Returns an ASTNode, the value of the 'math' subelement of this Rule,
or 'None' if the math is not set.

Note: The subelement 'math' is present in SBML Levels 2 and 3.  In
SBML Level 1, the equivalent construct is the attribute named
'formula'.  LibSBML provides a unified interface to the underlying
math expression and this method can be used for models of all Levels
of SBML.

See also getFormula().
";


%feature("docstring") Rule::getVariable "
Get the value of the 'variable' attribute of this Rule object.

In SBML Level 1, the different rule types each have a different name
for the attribute holding the reference to the object constituting the
left-hand side of the rule.  (E.g., for SBML Level 1's
SpeciesConcentrationRule the attribute is 'species', for
CompartmentVolumeRule it is 'compartment', etc.)  In SBML Levels 2 and
3, the only two types of Rule objects with a left-hand side object
reference are AssignmentRule and RateRule, and both of them use the
same name for attribute: 'variable'.  In order to make it easier for
application developers to work with all Levels of SBML, libSBML uses a
uniform name for all such attributes, and it is 'variable', regardless
of whether Level 1 rules or Level 2-3 rules are being used.

The 'variable' attribute of a Rule indicates the element which the
results of the 'math' are to be applied.  An AlgebraicRule has no
'variable', and will always return an empty string.

Returns the identifier string stored as the 'variable' attribute value
in this Rule, or 'None' if this object is an AlgebraicRule object, or
if  the attribute is unset.
";


%feature("docstring") Rule::getUnits "
Returns the units for the mathematical formula of this Rule.

Returns the identifier of the units for the expression of this Rule.

Note: The attribute 'units' exists on SBML Level 1 ParameterRule
objects only.  It is not present in SBML Levels 2 and 3.
";


%feature("docstring") Rule::isSetFormula "
Predicate returning 'True' if this Rule's mathematical expression is
set.

This method is equivalent to isSetMath().  This version is present for
easier compatibility with SBML Level 1, in which mathematical formulas
were written in text-string form.

Returns 'True' if the mathematical formula for this Rule is set,
'False' otherwise.

Note: The attribute 'formula' is specific to SBML Level 1; in higher
Levels of SBML, it has been replaced with a subelement named 'math'.
However, libSBML provides a unified interface to the underlying math
expression and this method can be used for models of all Levels of
SBML.

See also isSetMath().
";


%feature("docstring") Rule::isSetMath "
Predicate returning 'True' if this Rule's mathematical expression is
set.

This method is equivalent to isSetFormula().

Returns 'True' if the formula (or equivalently the math) for this Rule
is set, 'False' otherwise.

Note: The subelement 'math' is present in SBML Levels 2 and 3.  In
SBML Level 1, the equivalent construct is the attribute named
'formula'.  LibSBML provides a unified interface to the underlying
math expression and this method can be used for models of all Levels
of SBML.

See also isSetFormula().
";


%feature("docstring") Rule::isSetVariable "
Predicate returning 'True' if this Rule's 'variable' attribute is set.

In SBML Level 1, the different rule types each have a different name
for the attribute holding the reference to the object constituting the
left-hand side of the rule.  (E.g., for SBML Level 1's
SpeciesConcentrationRule the attribute is 'species', for
CompartmentVolumeRule it is 'compartment', etc.)  In SBML Levels 2 and
3, the only two types of Rule objects with a left-hand side object
reference are AssignmentRule and RateRule, and both of them use the
same name for attribute: 'variable'.  In order to make it easier for
application developers to work with all Levels of SBML, libSBML uses a
uniform name for all such attributes, and it is 'variable', regardless
of whether Level 1 rules or Level 2-3 rules are being used.

Returns 'True' if the 'variable' attribute value of this Rule is set,
'False' otherwise.
";


%feature("docstring") Rule::isSetUnits "
Predicate returning 'True' if this Rule's 'units' attribute is set.

Returns 'True' if the units for this Rule is set, 'False' otherwise.

Note: The attribute 'units' exists on SBML Level 1 ParameterRule
objects only.  It is not present in SBML Levels 2 and 3.
";


%feature("docstring") Rule::setFormula "
Sets the 'math' subelement of this Rule to an expression in text-
string form.

This is equivalent to setMath(ASTNode math).  The provision of using
text-string formulas is retained for easier SBML Level 1
compatibility.  The formula is converted to an ASTNode internally.

Parameter 'formula' is a mathematical formula in text-string form.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_OBJECT

Note: The attribute 'formula' is specific to SBML Level 1; in higher
Levels of SBML, it has been replaced with a subelement named 'math'.
However, libSBML provides a unified interface to the underlying math
expression and this method can be used for models of all Levels of
SBML.

See also setMath().
";


%feature("docstring") Rule::setMath "
Sets the 'math' subelement of this Rule to a copy of the given
ASTNode.

Parameter 'math' is the AST structure of the mathematical formula.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_OBJECT

Note: The subelement 'math' is present in SBML Levels 2 and 3.  In
SBML Level 1, the equivalent construct is the attribute named
'formula'.  LibSBML provides a unified interface to the underlying
math expression and this method can be used for models of all Levels
of SBML.

See also setFormula().
";


%feature("docstring") Rule::setVariable "
Sets the 'variable' attribute value of this Rule object.

In SBML Level 1, the different rule types each have a different name
for the attribute holding the reference to the object constituting the
left-hand side of the rule.  (E.g., for SBML Level 1's
SpeciesConcentrationRule the attribute is 'species', for
CompartmentVolumeRule it is 'compartment', etc.)  In SBML Levels 2 and
3, the only two types of Rule objects with a left-hand side object
reference are AssignmentRule and RateRule, and both of them use the
same name for attribute: 'variable'.  In order to make it easier for
application developers to work with all Levels of SBML, libSBML uses a
uniform name for all such attributes, and it is 'variable', regardless
of whether Level 1 rules or Level 2-3 rules are being used.

Parameter 'sid' is the identifier of a Compartment, Species or
Parameter elsewhere in the enclosing Model object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE
";


%feature("docstring") Rule::setUnits "
Sets the units for this Rule.

Parameter 'sname' is the identifier of the units.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE

* LIBSBML_UNEXPECTED_ATTRIBUTE

Note: The attribute 'units' exists on SBML Level 1 ParameterRule
objects only.  It is not present in SBML Levels 2 and 3.
";


%feature("docstring") Rule::unsetVariable "
Unsets the value of the 'variable' attribute of this Rule object.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

* LIBSBML_UNEXPECTED_ATTRIBUTE

See also setVariable(), isSetVariable(), getVariable().
";


%feature("docstring") Rule::unsetUnits "
Unsets the 'units' for this Rule.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED

* LIBSBML_UNEXPECTED_ATTRIBUTE

Note: The attribute 'units' exists on SBML Level 1 ParameterRule
objects only.  It is not present in SBML Levels 2 and 3.
";


%feature("docstring") Rule::getDerivedUnitDefinition "
Calculates and returns a UnitDefinition that expresses the units of
measurement assumed for the 'math' expression of this Rule.

The units are calculated based on the mathematical expression in the
Rule and the model quantities referenced by <ci> elements used within
that expression.  The method Rule.getDerivedUnitDefinition() returns
the calculated units, to the extent that libSBML can compute them.

Note: The functionality that facilitates unit analysis depends on the
model as a whole.  Thus, in cases where the object has not been added
to a model or the model itself is incomplete, unit analysis is not
possible and this method will return 'None.'

WARNING:

Note that it is possible the 'math' expression in the Rule contains
pure numbers or parameters with undeclared units.  In those cases, it
is not possible to calculate the units of the overall expression
without making assumptions.  LibSBML does not make assumptions about
the units, and Rule.getDerivedUnitDefinition() only returns the units
as far as it is able to determine them.  For example, in an expression
X + Y, if X has unambiguously-defined units and Y does not, it will
return the units of X. It is important that callers also invoke the
method Rule.containsUndeclaredUnits() to determine whether this
situation holds.  Callers may wish to take suitable actions in those
scenarios.

Returns a UnitDefinition that expresses the units of the math
expression of this Rule, or 'None' if one cannot be constructed.

See also containsUndeclaredUnits().
";


%feature("docstring") Rule::containsUndeclaredUnits "
Predicate returning 'True' if the math expression of this Rule
contains parameters/numbers with undeclared units.

Returns 'True' if the math expression of this Rule includes
parameters/numbers with undeclared units, 'False' otherwise.

Note: A return value of 'True' indicates that the UnitDefinition
returned by getDerivedUnitDefinition() may not accurately represent
the units of the expression.

See also getDerivedUnitDefinition().
";


%feature("docstring") Rule::getType "
Returns a code representing the type of rule this is.

Returns the rule type, which will be one of the following three
possible values:

* RULE_TYPE_RATE

* RULE_TYPE_SCALAR

* RULE_TYPE_INVALID

Note: The attribute 'type' on Rule objects is present only in SBML
Level 1.  In SBML Level 2 and later, the type has been replaced by
subclassing the Rule object.
";


%feature("docstring") Rule::isAlgebraic "
Predicate returning 'True' if this Rule is an AlgebraicRule.

Returns 'True' if this Rule is an AlgebraicRule, 'False' otherwise.
";


%feature("docstring") Rule::isAssignment "
Predicate returning 'True' if this Rule is an AssignmentRule.

Returns 'True' if this Rule is an AssignmentRule, 'False' otherwise.
";


%feature("docstring") Rule::isCompartmentVolume "
Predicate returning 'True' if this Rule is an CompartmentVolumeRule or
equivalent.

This libSBML method works for SBML Level 1 models (where there is such
a thing as an explicit CompartmentVolumeRule), as well as other Levels
of SBML.  For Levels above Level 1, this method checks the symbol
being affected by the rule, and returns 'True' if the symbol is the
identifier of a Compartment object defined in the model.

Returns 'True' if this Rule is a CompartmentVolumeRule, 'False'
otherwise.
";


%feature("docstring") Rule::isParameter "
Predicate returning 'True' if this Rule is an ParameterRule or
equivalent.

This libSBML method works for SBML Level 1 models (where there is such
a thing as an explicit ParameterRule), as well as other Levels of
SBML.  For Levels above Level 1, this method checks the symbol being
affected by the rule, and returns 'True' if the symbol is the
identifier of a Parameter object defined in the model.

Returns 'True' if this Rule is a ParameterRule, 'False' otherwise.
";


%feature("docstring") Rule::isRate "
Predicate returning 'True' if this Rule is a RateRule (SBML Levels
2-3) or has a 'type' attribute value of ''rate'' (SBML Level 1).

Returns 'True' if this Rule is a RateRule (Level 2) or has type 'rate'
(Level 1), 'False' otherwise.
";


%feature("docstring") Rule::isScalar "
Predicate returning 'True' if this Rule is an AssignmentRule (SBML
Levels 2-3) or has a 'type' attribute value of ''scalar'' (SBML Level
1).

Returns 'True' if this Rule is an AssignmentRule (Level 2) or has type
'scalar' (Level 1), 'False' otherwise.
";


%feature("docstring") Rule::isSpeciesConcentration "
Predicate returning 'True' if this Rule is a SpeciesConcentrationRule
or equivalent.

This libSBML method works for SBML Level 1 models (where there is such
a thing as an explicit SpeciesConcentrationRule), as well as other
Levels of SBML.  For Levels above Level 1, this method checks the
symbol being affected by the rule, and returns 'True' if the symbol is
the identifier of a Species object defined in the model.

Returns 'True' if this Rule is a SpeciesConcentrationRule, 'False'
otherwise.
";


%feature("docstring") Rule::getTypeCode "
Returns the libSBML type code for this SBML object.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for this object, either
SBML_ASSIGNMENT_RULE, SBML_RATE_RULE, or SBML_ALGEBRAIC_RULE  for SBML
Core.

WARNING:

The specific integer values of the possible type codes may be reused
by different libSBML plug-ins for SBML Level 3. packages,  To fully
identify the correct code, it is necessary to invoke both
getTypeCode() and getPackageName().

See also getElementName(), getPackageName().
";


%feature("docstring") Rule::getL1TypeCode "
Returns the SBML Level 1 type code for this Rule object.

This method only applies to SBML Level 1 model objects.  If this is
not an SBML Level 1 rule object, this method will return SBML_UNKNOWN.

Returns the SBML Level 1 type code for this Rule (namely,
SBML_COMPARTMENT_VOLUME_RULE, SBML_PARAMETER_RULE,
SBML_SPECIES_CONCENTRATION_RULE, or SBML_UNKNOWN).
";


%feature("docstring") Rule::getElementName "
Returns the XML element name of this object.

The returned value can be any of a number of different strings,
depending on the SBML Level in use and the kind of Rule object this
is.  The rules as of libSBML version 5.16.0 are the following:

* (Level 2 and 3) RateRule: returns ''rateRule''

* (Level 2 and 3) AssignmentRule: returns ''assignmentRule''

* (Level 2 and 3) AlgebraicRule: returns ''algebraicRule''

* (Level 1 Version 1) SpecieConcentrationRule: returns
''specieConcentrationRule''

* (Level 1 Version 2) SpeciesConcentrationRule: returns
''speciesConcentrationRule''

* (Level 1) CompartmentVolumeRule: returns
''compartmentVolumeRule''

* (Level 1) ParameterRule: returns ''parameterRule''

* Unknown rule type: returns ''unknownRule'' Beware that the last
(''unknownRule')' is not a valid SBML element name.

Returns the name of this element.
";


%feature("docstring") Rule::writeElements "
Internal implementation method.
";


%feature("docstring") Rule::setL1TypeCode "
Sets the SBML Level 1 type code for this Rule.

Parameter 'type' is the SBML Level 1 type code for this Rule. The
allowable values are SBML_COMPARTMENT_VOLUME_RULE,
SBML_PARAMETER_RULE, and SBML_SPECIES_CONCENTRATION_RULE.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_ATTRIBUTE_VALUE if given 'type' value is not one
of the above.
";


%feature("docstring") Rule::hasRequiredElements "
Predicate returning 'True' if all the required elements for this Rule
object have been set.

The only required element for a Rule object is the 'math' subelement
in SBML Level 2 and Level 3 Version 1.  In SBML Level 3 Version 2+, it
is no longer required.

Returns a boolean value indicating whether all the required elements
for this object have been defined.
";


%feature("docstring") Rule::hasRequiredAttributes "
Predicate returning 'True' if all the required attributes for this
Rule object have been set.

The required attributes for a Rule object depend on the type of Rule
it is.  For AssignmentRule and RateRule objects (and SBML Level 1's
SpeciesConcentrationRule, CompartmentVolumeRule, and ParameterRule
objects), the required attribute is 'variable'; for AlgebraicRule
objects, there is no required attribute.

Returns 'True' if the required attributes have been set, 'False'
otherwise.
";


%feature("docstring") Rule::renameSIdRefs "
Replaces all uses of a given 'SIdRef' type attribute value with
another value.

In SBML, object identifiers are of a data type called SId. In SBML
Level 3, an explicit data type called SIdRef was introduced for
attribute values that refer to SId values; in previous Levels of SBML,
this data type did not exist and attributes were simply described to
as 'referring to an identifier', but the effective data type was the
same as SIdRef in Level 3.  These and other methods of libSBML refer
to the type SIdRef for all Levels of SBML, even if the corresponding
SBML specification did not explicitly name the data type.

This method works by looking at all attributes and (if appropriate)
mathematical formulas in MathML content, comparing the referenced
identifiers to the value of 'oldid'.  If any matches are found, the
matching values are replaced with 'newid'.  The method does not
descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") Rule::renameUnitSIdRefs "
Replaces all uses of a given 'UnitSIdRef' type attribute value with
another value.

In SBML, unit definitions have identifiers of type UnitSId.  In SBML
Level 3, an explicit data type called UnitSIdRef was introduced for
attribute values that refer to UnitSId values; in previous Levels of
SBML, this data type did not exist and attributes were simply
described to as 'referring to a unit identifier', but the effective
data type was the same as UnitSIdRef in Level 3.  These and other
methods of libSBML refer to the type UnitSIdRef for all Levels of
SBML, even if the corresponding SBML specification did not explicitly
name the data type.

This method works by looking at all unit identifier attribute values
(including, if appropriate, inside mathematical formulas), comparing
the referenced unit identifiers to the value of 'oldid'.  If any
matches are found, the matching values are replaced with 'newid'.  The
method does not descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") Rule::getInternalId "
Internal implementation method.
";


%feature("docstring") Rule::setInternalId "
Internal implementation method.
";


%feature("docstring") Rule::getId "
Returns the value of the 'variable' attribute of this Rule (NOT the
'id').

Note: Because of the inconsistent behavior of this function with
respect to assignments and rules, it is now recommended to use the
getIdAttribute() or the getVariable() function instead.

The 'variable' attribute of a Rule indicates the element which the
results of the 'math' are to be applied.  An AlgebraicRule has no
'variable', and will always return an empty string.

Returns the variable of this Rule.

See also getIdAttribute(), setIdAttribute(), isSetIdAttribute(),
unsetIdAttribute(), getVariable().
";


%feature("docstring") Rule::replaceSIDWithFunction "
Internal implementation method.
";


%feature("docstring") Rule::divideAssignmentsToSIdByFunction "
Internal implementation method.
";


%feature("docstring") Rule::multiplyAssignmentsToSIdByFunction "
Internal implementation method.
";


%feature("docstring") Rule::readOtherXML "
Internal implementation method.
";


%feature("docstring") Rule::addExpectedAttributes "
Internal implementation method.
";


%feature("docstring") Rule::readAttributes "
Internal implementation method.
";


%feature("docstring") Rule::readL1Attributes "
Internal implementation method.
";


%feature("docstring") Rule::readL2Attributes "
Internal implementation method.
";


%feature("docstring") Rule::readL3Attributes "
Internal implementation method.
";


%feature("docstring") Rule::writeAttributes "
Internal implementation method.
";


%feature("docstring") ListOfRules::ListOfRules "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    ListOfRules(SBMLNamespaces sbmlns)

Creates a new ListOfRules object.

The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in
'sbmlns'.

Parameter 'sbmlns' is an SBMLNamespaces object that is used to
determine the characteristics of the ListOfRules object to be created.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    ListOfRules(long level, long version)

Creates a new ListOfRules object.

The object is constructed such that it is valid for the given SBML
Level and Version combination.

Parameter 'level' is the SBML Level.

Parameter 'version' is the Version within the SBML Level.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.
";


%feature("docstring") ListOfRules::clone "
Creates and returns a deep copy of this ListOfRules object.

Returns the (deep) copy of this ListOfRules object.
";


%feature("docstring") ListOfRules::getItemTypeCode "
Returns the libSBML type code for the objects contained in this ListOf
(i.e., Rule objects, if the list is non-empty).

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for objects contained in this list:
SBML_RULE (default).

See also getElementName(), getPackageName().
";


%feature("docstring") ListOfRules::getElementName "
Returns the XML element name of this object.

For ListOfRules, the XML element name is ''listOfRules'.'

Returns the name of this element, i.e., ''listOfRules'.'
";


%feature("docstring") ListOfRules::get "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    get(long n)

Get a Rule from the ListOfRules.

Parameter 'n' is the index number of the Rule to get.

Returns the nth Rule in this ListOfRules.

See also size().

______________________________________________________________________
Method variant with the following signature:

    get(string sid)

Get a Rule from the ListOfRules based on its identifier.

Parameter 'sid' is a string representing the identifier of the Rule to
get.

Returns Rule in this ListOfRules with the given 'sid' or 'None' if no
such Rule exists.

See also get(), size().
";


%feature("docstring") ListOfRules::remove "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    remove(long n)

Removes the nth item from this ListOfRules items and returns a pointer
to it.

The caller owns the returned item and is responsible for deleting it.

Parameter 'n' is the index of the item to remove.

See also size().

______________________________________________________________________
Method variant with the following signature:

    remove(string sid)

Removes item in this ListOfRules items with the given identifier.

The caller owns the returned item and is responsible for deleting it.
If none of the items in this list have the identifier 'sid', then
'None' is returned.

Parameter 'sid' is the identifier of the item to remove.

Returns the item removed.  As mentioned above, the caller owns the
returned item.
";


%feature("docstring") ListOfRules::getElementBySId "
Returns the first child element found that has the given 'id' in the
model-wide SId namespace, or 'None' if no such object is found.

Note that AssignmentRules and RateRules do not actually have IDs, but
the libsbml interface pretends that they do: no assignment rule or
rate rule is returned by this function.

Parameter 'id' is string representing the id of the object to find.

Returns pointer to the first element found with the given 'id'.
";


%feature("docstring") ListOfRules::getElementPosition "
Internal implementation method.
";


%feature("docstring") ListOfRules::createObject "
Internal implementation method.
";


%feature("docstring") ListOfRules::isValidTypeForList "
Internal implementation method.
";


%feature("docstring") AlgebraicRule "
An SBML algebraic rule representing 0 = f(W).

The rule type AlgebraicRule is derived from the parent class Rule.  It
is used to express equations that are neither assignments of model
variables nor rates of change.  AlgebraicRule does not add any
attributes to the basic Rule; its role is simply to distinguish this
case from the other cases.

In the context of a simulation, algebraic rules are in effect at all
times, t >= 0.  For purposes of evaluating expressions that involve
the delay 'csymbol' (see the SBML specification), algebraic rules are
considered to apply also at t <= 0.  Please consult the relevant SBML
specification for additional information about the semantics of
assignments, rules, and entity values for simulation time t <= 0.

An SBML model must not be overdetermined.  The ability to define
arbitrary algebraic expressions in an SBML model introduces the
possibility that a model is mathematically overdetermined by the
overall system of equations constructed from its rules, reactions and
events. Therefore, if an algebraic rule is introduced in a model, for
at least one of the entities referenced in the rule's 'math' element
the value of that entity must not be completely determined by other
constructs in the model.  This means that at least this entity must
not have the attribute 'constant'='True' and there must also not be a
rate rule or assignment rule for it.  Furthermore, if the entity is a
Species object, its value must not be determined by reactions, which
means that it must either have the attribute
'boundaryCondition'='True' or else not be involved in any reaction at
all.  These restrictions are explained in more detail in the SBML
specification documents.

In SBML Levels 2 and 3, Reaction object identifiers can be referenced
in the 'math' expression of an algebraic rule, but reaction rates can
never be determined by algebraic rules.  This is true even when a
reaction does not contain a KineticLaw object.  (In such cases of
missing kinetic law definitions, the model is valid but incomplete;
the rates of reactions lacking kinetic laws are simply undefined, and
not determined by the algebraic rule.)

In SBML Level 2 and Level 3 Version 1, the 'math' subelement of the
AlgebraicRule is required.  In SBML Level 3 Version 2, this rule is
relaxed, and the subelement is optional.  If an AlgebraicRule with no
'math' child is present in the model, no additional mathematical
constraints on the model are added by the rule.  This may represent a
situation where the model itself is unfinished, or the missing
information may be provided by an SBML Level 3 package.

Finally, any symbol that appears as the target of a rateOf csymbol
(AST_FUNCTION_RATE_OF, introduced in  SBML Level 3 Version 2) may  not
be determined by an AlgebraicRule. This is because the rateOf  csymbol
is defined as applying only to symbols whose rates of change  are
easily determinable.

Users should note that these rules about what symbols may not be
determined by an AlgebraicRule may be used to discover what symbol  is
being determined by an AlgebraicRule. If three symbols appear in  the
math element of an AlgebraicRule, the first of which is flagged
constant='True,' and the second of which appears as the target of a
rateOf csymbol, one may conclude that the AlgebraicRule must be used
to determine the value of the third symbol. This is, in fact, a
principle use (outside of validation) of the constant attribute: its
use in allowing software to properly identify the dependent variable
in an AlgebraicRule.

General summary of SBML rules
======================================================================

In SBML Level 3 as well as Level 2, rules are separated into three
subclasses for the benefit of model analysis software.  The three
subclasses are based on the following three different possible
functional forms (where x is a variable, f is some arbitrary function
returning a numerical result, V is a vector of variables that does not
include x, and W is a vector of variables that may include x):

   Algebraic:   left-hand side is zero               0 = f(W)     
   Assignment:  left-hand side is a scalar:          x = f(V)     
   Rate:        left-hand side is a rate-of-change:  dx/dt = f(W)

In their general form given above, there is little to distinguish
between assignment and algebraic rules.  They are treated as separate
cases for the following reasons:

* Assignment rules can simply be evaluated to calculate
intermediate values for use in numerical methods.  They are statements
of equality that hold at all times.  (For assignments that are only
performed once, see InitialAssignment.)

* SBML needs to place restrictions on assignment rules, for example
the restriction that assignment rules cannot contain algebraic loops.

* Some simulators do not contain numerical solvers capable of
solving unconstrained algebraic equations, and providing more direct
forms such as assignment rules may enable those simulators to process
models they could not process if the same assignments were put in the
form of general algebraic equations;

* Those simulators that can solve these algebraic equations make a
distinction between the different categories listed above; and

* Some specialized numerical analyses of models may only be
applicable to models that do not contain algebraic rules.

The approach taken to covering these cases in SBML is to define an
abstract Rule structure containing a subelement, 'math', to hold the
right-hand side expression, then to derive subtypes of Rule that add
attributes to distinguish the cases of algebraic, assignment and rate
rules.  The 'math' subelement must contain a MathML expression
defining the mathematical formula of the rule.  This MathML formula
must return a numerical value.  The formula can be an arbitrary
expression referencing the variables and other entities in an SBML
model.

Each of the three subclasses of Rule (AssignmentRule, AlgebraicRule,
RateRule) inherit the the 'math' subelement and other fields from
SBase. The AssignmentRule and RateRule classes add an additional
attribute, 'variable'.  See the definitions of AssignmentRule,
AlgebraicRule and RateRule for details about the structure and
interpretation of each one.

Additional restrictions on SBML rules
======================================================================

An important design goal of SBML rule semantics is to ensure that a
model's simulation and analysis results will not be dependent on when
or how often rules are evaluated.  To achieve this, SBML needs to
place two restrictions on rule use.  The first concerns algebraic
loops in the system of assignments in a model, and the second concerns
overdetermined systems.

A model must not contain algebraic loops
......................................................................

The combined set of InitialAssignment, AssignmentRule and KineticLaw
objects in a model constitute a set of assignment statements that
should be considered as a whole.  (A KineticLaw object is counted as
an assignment because it assigns a value to the symbol contained in
the 'id' attribute of the Reaction object in which it is defined.)
This combined set of assignment statements must not contain algebraic
loops---dependency chains between these statements must terminate.  To
put this more formally, consider a directed graph in which nodes are
assignment statements and directed arcs exist for each occurrence of
an SBML species, compartment or parameter symbol in an assignment
statement's 'math' subelement.  Let the directed arcs point from the
statement assigning the symbol to the statements that contain the
symbol in their 'math' subelement expressions. This graph must be
acyclic.

Similarly, the combined set of RateRule and Reaction objects
constitute  a set of definitions for the rates of change of various
model entities  (namely, the objects identified by the values of the
'variable' attributes  of the RateRule objects, and the 'species'
attributes of the SpeciesReference  objects in each Reaction).  In
SBML Level 3 Version 2, these rates  of change may be referenced
directly  using the rateOf csymbol, but may not thereby contain
algebraic  loops---dependency chains between these statements must
terminate.  More  formally, consider a directed graph in which the
nodes are the definitions  of different variables' rates of change,
and directed arcs exist for each  occurrence of a variable referenced
by a rateOf csymbol from any  RateRule or KineticLaw object in the
model.  Let the directed arcs point  from the variable referenced by
the rateOf csymbol (call it  x) to the variable(s) determined by the
'math' expression in which x appears.  This graph must be acyclic.

SBML does not specify when or how often rules should be evaluated.
Eliminating algebraic loops ensures that assignment statements can be
evaluated any number of times without the result of those evaluations
changing.  As an example, consider the set of equations x = x + 1, y =
z + 200 and z = y + 100.  If this set of equations were interpreted as
a set of assignment statements, it would be invalid because the rule
for x refers to x (exhibiting one type of loop), and the rule for y
refers to z while the rule for z refers back to y (exhibiting another
type of loop). Conversely, the following set of equations would
constitute a valid set of assignment statements: x = 10, y = z + 200,
and z = x + 100.

A model must not be overdetermined
......................................................................

An SBML model must not be overdetermined; that is, a model must not
define more equations than there are unknowns in a model.  A valid
SBML model that does not contain AlgebraicRule structures cannot be
overdetermined.

LibSBML implements the static analysis procedure described in Appendix
B of the SBML Level 3 specification for assessing whether a model is
overdetermined.

(In summary, assessing whether a given continuous, deterministic,
mathematical model is overdetermined does not require dynamic
analysis; it can be done by analyzing the system of equations created
from the model. One approach is to construct a bipartite graph in
which one set of vertices represents the variables and the other the
set of vertices represents the equations.  Place edges between
vertices such that variables in the system are linked to the equations
that determine them.  For algebraic equations, there will be edges
between the equation and each variable occurring in the equation.  For
ordinary differential equations (such as those defined by rate rules
or implied by the reaction rate definitions), there will be a single
edge between the equation and the variable determined by that
differential equation.  A mathematical model is overdetermined if the
maximal matchings of the bipartite graph contain disconnected vertexes
representing equations.  If one maximal matching has this property,
then all the maximal matchings will have this property; i.e., it is
only necessary to find one maximal matching.)

Rule types for SBML Level 1
======================================================================

SBML Level 1 uses a different scheme than SBML Level 2 and Level 3 for
distinguishing rules; specifically, it uses an attribute whose value
is drawn from an enumeration of 3 values.  LibSBML supports this using
methods that work with the enumeration values  listed below.

* RULE_TYPE_RATE: Indicates the rule is a 'rate' rule.

* RULE_TYPE_SCALAR: Indicates the rule is a 'scalar' rule.

* RULE_TYPE_INVALID: Indicates the rule type is unknown or not yet
set.
";


%feature("docstring") AlgebraicRule::AlgebraicRule "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    AlgebraicRule(SBMLNamespaces sbmlns)

Creates a new AlgebraicRule object using the given SBMLNamespaces
object 'sbmlns'.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

Parameter 'sbmlns' is an SBMLNamespaces object.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    AlgebraicRule(long level, long version)

Creates a new AlgebraicRule object using the given SBML 'level' and
'version' values.

Parameter 'level' is the SBML Level to assign to this AlgebraicRule
object.

Parameter 'version' is the SBML Version to assign to this
AlgebraicRule object.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.
";


%feature("docstring") AlgebraicRule::clone "
Creates and returns a deep copy of this AlgebraicRule object.

Returns the (deep) copy of this Rule object.
";


%feature("docstring") AlgebraicRule::accept "
Internal implementation method.
";


%feature("docstring") AlgebraicRule::setInternalIdOnly "
Internal implementation method.
";


%feature("docstring") AlgebraicRule::getInternalIdOnly "
Internal implementation method.
";


%feature("docstring") AlgebraicRule::hasRequiredAttributes "
Predicate returning 'True' if all the required attributes for this
AlgebraicRule object have been set.

In SBML Levels 2-3, there is no required attribute for an
AlgebraicRule object.  For Level 1, the only required attribute is
'formula'.

Returns 'True' if the required attributes have been set, 'False'
otherwise.
";


%feature("docstring") AssignmentRule "
An SBML assignment rule representing x = f(Y).

The rule type AssignmentRule is derived from the parent class Rule.
It is used to express equations that set the values of variables.  The
left-hand side (the attribute named 'variable') of an assignment rule
must refer to the identifier of a Species, SpeciesReference (in SBML
Level 3), Compartment, or global Parameter object in the model (but
not a Reaction).  In SBML Level 3 Version 2, it may also refer to the
SId of an element defined in an SBML Level 3 package with
mathematical meaning and the ability to be assigned. The entity
identified must have its 'constant' attribute set to 'False.'  The
effects of an assignment rule construct are in general terms the same,
but differ in the precise details depending on the type of SBML
component being set:

* In the case of a species, an SBML assignment rule sets the
referenced species' quantity (whether a 'concentration' or 'amount')
to the value determined by the formula in the MathML subelement
'math'. The unit associated with the value produced by the 'math'
formula should (in SBML Level 2 Version 4 and in SBML Level 3) or must
(in SBML releases prior to Level 2 version 4) be equal to the unit
associated with the species' quantity.  Restrictions: There must not
be both an AssignmentRule 'variable' attribute and a SpeciesReference
'species' attribute having the same value in a model, unless the
referenced Species object has its 'boundaryCondition' attribute set to
'True.'  In other words, an assignment rule cannot be defined for a
species that is created or destroyed in a reaction unless that species
is defined as a boundary condition in the model.

* (For SBML Level 3 only) In the case of a species reference, an
assignment rule sets the stoichiometry of the referenced reactant or
product to the value determined by the formula in 'math'.  The unit
associated with the value produced by the 'math' formula should be
consistent with the unit 'dimensionless', because reactant and product
stoichiometries in reactions are dimensionless quantities.

* In the case of a compartment, an SBML assignment rule sets the
referenced compartment's size to the value determined by the formula
in the 'math' subelement of the AssignmentRule object.  The overall
units of the formula in 'math' should (in SBML Level 2 Version 4 and
in SBML Level 3) or must (in SBML releases prior to Level 2 version 4)
be the same as the units of the size of the compartment.

* In the case of a parameter, an assignment rule sets the referenced
parameter's value to that determined by the formula in the 'math'
subelement of the AssignmentRule object.  The overall units of the
formula in the 'math' subelement should (in SBML Level 2 Version 4 and
in SBML Level 3) or must (in SBML releases prior to Level 2 version 4)
be the same as the units defined for the parameter.

* (For SBML Level 3 Version 2 only) In the case of  an object from an
SBML Level 3 package, an AssignmentRule sets  the referenced object's
value (as defined by that package) to the  value of the formula in
math. The unit of measurement associated  with the value produced by
the formula should be the same as that  object's units attribute value
(if it has such an attribute), or be  equal to the units of model
components of that type (if objects of  that class are defined by the
package as having the same units).

In SBML Level 2 and Level 3 Version 1, the 'math'  subelement of the
AssignmentRule is required.  In SBML Level 3 Version 2, this rule is
relaxed, and the subelement is optional.  If an AssignmentRule with no
'math' child is present in the model, the value of its referenced
'variable' is  undefined.  This may represent a situation where the
model itself is unfinished, or the missing information may be provided
by an SBML Level 3 package.

If the variable attribute of an AssignmentRule object references an
object in an SBML namespace not understood by the interpreter reading
a given SBML document (that is, if the object is defined by an SBML
Level 3 package that the software does not support), the assignment
rule must be ignored--the object's value will not need to be set, as
the  interpreter could not understand that package. If an interpreter
cannot  establish whether a referenced object is missing from the
model or  instead is defined in an SBML namespace not understood by
the interpreter,  it may produce a warning to the user. (The latter
situation may only  arise if an SBML package is present in the SBML
document with a  package:required attribute of 'true'.)

In the context of a simulation, assignment rules are in effect at all
times, t >= 0.  For purposes of evaluating expressions that involve
the delay 'csymbol' (see the SBML Level 2 specification), assignment
rules are considered to apply also at t <= 0.  Please consult the
relevant SBML specification for additional information about the
semantics of assignments, rules, and entity values for simulation time
t <= 0.

A model must not contain more than one AssignmentRule or RateRule
object having the same value of 'variable'; in other words, in the set
of all assignment rules and rate rules in an SBML model, each variable
appearing in the left-hand sides can only appear once.  This simply
follows from the fact that an indeterminate system would result if a
model contained more than one assignment rule for the same variable or
both an assignment rule and a rate rule for the same variable.

Similarly, a model must also not contain both an AssignmentRule and an
InitialAssignment definition for the same variable, because both kinds
of constructs apply prior to and at the start of simulation time,
i.e., t <= 0.  If a model contained both an initial assignment and an
assignment rule for the same variable, an indeterminate system would
result.

The value calculated by an AssignmentRule object overrides the value
assigned to the given symbol by the model component defining that
symbol.  For example, if a Compartment object's 'size' attribute value
is set in its definition, and the model also contains an
AssignmentRule object  having that compartment's 'id' as its
'variable' value, then the 'size' assigned in the Compartment object
definition is ignored and the value assigned based on the computation
defined in the AssignmentRule.  This does not mean that a definition
for a given symbol can be omitted if there is an AssignmentRule object
involving it.  For example,  there must be a Parameter object
definition for a given parameter if there is an AssignmentRule
definition for that parameter.  It is only a question of which value
definition takes precedence.

General summary of SBML rules
======================================================================

In SBML Level 3 as well as Level 2, rules are separated into three
subclasses for the benefit of model analysis software.  The three
subclasses are based on the following three different possible
functional forms (where x is a variable, f is some arbitrary function
returning a numerical result, V is a vector of variables that does not
include x, and W is a vector of variables that may include x):

   Algebraic:   left-hand side is zero               0 = f(W)     
   Assignment:  left-hand side is a scalar:          x = f(V)     
   Rate:        left-hand side is a rate-of-change:  dx/dt = f(W)

In their general form given above, there is little to distinguish
between assignment and algebraic rules.  They are treated as separate
cases for the following reasons:

* Assignment rules can simply be evaluated to calculate
intermediate values for use in numerical methods.  They are statements
of equality that hold at all times.  (For assignments that are only
performed once, see InitialAssignment.)

* SBML needs to place restrictions on assignment rules, for example
the restriction that assignment rules cannot contain algebraic loops.

* Some simulators do not contain numerical solvers capable of
solving unconstrained algebraic equations, and providing more direct
forms such as assignment rules may enable those simulators to process
models they could not process if the same assignments were put in the
form of general algebraic equations;

* Those simulators that can solve these algebraic equations make a
distinction between the different categories listed above; and

* Some specialized numerical analyses of models may only be
applicable to models that do not contain algebraic rules.

The approach taken to covering these cases in SBML is to define an
abstract Rule structure containing a subelement, 'math', to hold the
right-hand side expression, then to derive subtypes of Rule that add
attributes to distinguish the cases of algebraic, assignment and rate
rules.  The 'math' subelement must contain a MathML expression
defining the mathematical formula of the rule.  This MathML formula
must return a numerical value.  The formula can be an arbitrary
expression referencing the variables and other entities in an SBML
model.

Each of the three subclasses of Rule (AssignmentRule, AlgebraicRule,
RateRule) inherit the the 'math' subelement and other fields from
SBase. The AssignmentRule and RateRule classes add an additional
attribute, 'variable'.  See the definitions of AssignmentRule,
AlgebraicRule and RateRule for details about the structure and
interpretation of each one.

Additional restrictions on SBML rules
======================================================================

An important design goal of SBML rule semantics is to ensure that a
model's simulation and analysis results will not be dependent on when
or how often rules are evaluated.  To achieve this, SBML needs to
place two restrictions on rule use.  The first concerns algebraic
loops in the system of assignments in a model, and the second concerns
overdetermined systems.

A model must not contain algebraic loops
......................................................................

The combined set of InitialAssignment, AssignmentRule and KineticLaw
objects in a model constitute a set of assignment statements that
should be considered as a whole.  (A KineticLaw object is counted as
an assignment because it assigns a value to the symbol contained in
the 'id' attribute of the Reaction object in which it is defined.)
This combined set of assignment statements must not contain algebraic
loops---dependency chains between these statements must terminate.  To
put this more formally, consider a directed graph in which nodes are
assignment statements and directed arcs exist for each occurrence of
an SBML species, compartment or parameter symbol in an assignment
statement's 'math' subelement.  Let the directed arcs point from the
statement assigning the symbol to the statements that contain the
symbol in their 'math' subelement expressions. This graph must be
acyclic.

Similarly, the combined set of RateRule and Reaction objects
constitute  a set of definitions for the rates of change of various
model entities  (namely, the objects identified by the values of the
'variable' attributes  of the RateRule objects, and the 'species'
attributes of the SpeciesReference  objects in each Reaction).  In
SBML Level 3 Version 2, these rates  of change may be referenced
directly  using the rateOf csymbol, but may not thereby contain
algebraic  loops---dependency chains between these statements must
terminate.  More  formally, consider a directed graph in which the
nodes are the definitions  of different variables' rates of change,
and directed arcs exist for each  occurrence of a variable referenced
by a rateOf csymbol from any  RateRule or KineticLaw object in the
model.  Let the directed arcs point  from the variable referenced by
the rateOf csymbol (call it  x) to the variable(s) determined by the
'math' expression in which x appears.  This graph must be acyclic.

SBML does not specify when or how often rules should be evaluated.
Eliminating algebraic loops ensures that assignment statements can be
evaluated any number of times without the result of those evaluations
changing.  As an example, consider the set of equations x = x + 1, y =
z + 200 and z = y + 100.  If this set of equations were interpreted as
a set of assignment statements, it would be invalid because the rule
for x refers to x (exhibiting one type of loop), and the rule for y
refers to z while the rule for z refers back to y (exhibiting another
type of loop). Conversely, the following set of equations would
constitute a valid set of assignment statements: x = 10, y = z + 200,
and z = x + 100.

A model must not be overdetermined
......................................................................

An SBML model must not be overdetermined; that is, a model must not
define more equations than there are unknowns in a model.  A valid
SBML model that does not contain AlgebraicRule structures cannot be
overdetermined.

LibSBML implements the static analysis procedure described in Appendix
B of the SBML Level 3 specification for assessing whether a model is
overdetermined.

(In summary, assessing whether a given continuous, deterministic,
mathematical model is overdetermined does not require dynamic
analysis; it can be done by analyzing the system of equations created
from the model. One approach is to construct a bipartite graph in
which one set of vertices represents the variables and the other the
set of vertices represents the equations.  Place edges between
vertices such that variables in the system are linked to the equations
that determine them.  For algebraic equations, there will be edges
between the equation and each variable occurring in the equation.  For
ordinary differential equations (such as those defined by rate rules
or implied by the reaction rate definitions), there will be a single
edge between the equation and the variable determined by that
differential equation.  A mathematical model is overdetermined if the
maximal matchings of the bipartite graph contain disconnected vertexes
representing equations.  If one maximal matching has this property,
then all the maximal matchings will have this property; i.e., it is
only necessary to find one maximal matching.)

Rule types for SBML Level 1
======================================================================

SBML Level 1 uses a different scheme than SBML Level 2 and Level 3 for
distinguishing rules; specifically, it uses an attribute whose value
is drawn from an enumeration of 3 values.  LibSBML supports this using
methods that work with the enumeration values  listed below.

* RULE_TYPE_RATE: Indicates the rule is a 'rate' rule.

* RULE_TYPE_SCALAR: Indicates the rule is a 'scalar' rule.

* RULE_TYPE_INVALID: Indicates the rule type is unknown or not yet
set.
";


%feature("docstring") AssignmentRule::AssignmentRule "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    AssignmentRule(SBMLNamespaces sbmlns)

Creates a new AssignmentRule using the given SBMLNamespaces object
'sbmlns'.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

Parameter 'sbmlns' is an SBMLNamespaces object.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    AssignmentRule(long level, long version)

Creates a new AssignmentRule using the given SBML 'level' and
'version' values.

Parameter 'level' is a long integer, the SBML Level to assign to this
AssignmentRule.

Parameter 'version' is a long integer, the SBML Version to assign to
this AssignmentRule.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.
";


%feature("docstring") AssignmentRule::clone "
Creates and returns a deep copy of this AssignmentRule object.

Returns the (deep) copy of this Rule object.
";


%feature("docstring") AssignmentRule::accept "
Internal implementation method.
";


%feature("docstring") AssignmentRule::hasRequiredAttributes "
Predicate returning 'True' if all the required attributes for this
AssignmentRule object have been set.

In SBML Levels 2-3, the only required attribute for an AssignmentRule
object is 'variable'.  For Level 1, where the equivalent attribute is
known by different names ('compartment', 'species', or 'name',
depending on the type of object), there is an additional required
attribute called 'formula'.

Returns 'True' if the required attributes have been set, 'False'
otherwise.
";


%feature("docstring") AssignmentRule::renameSIdRefs "
Replaces all uses of a given 'SIdRef' type attribute value with
another value.

In SBML, object identifiers are of a data type called SId. In SBML
Level 3, an explicit data type called SIdRef was introduced for
attribute values that refer to SId values; in previous Levels of SBML,
this data type did not exist and attributes were simply described to
as 'referring to an identifier', but the effective data type was the
same as SIdRef in Level 3.  These and other methods of libSBML refer
to the type SIdRef for all Levels of SBML, even if the corresponding
SBML specification did not explicitly name the data type.

This method works by looking at all attributes and (if appropriate)
mathematical formulas in MathML content, comparing the referenced
identifiers to the value of 'oldid'.  If any matches are found, the
matching values are replaced with 'newid'.  The method does not
descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") RateRule "
An SBML rate rule representing dx/dt = f(Y).

The rule type RateRule is derived from the parent class Rule.  It is
used to express equations that determine the rates of change of
variables.  The left-hand side (the 'variable' attribute) can refer to
the identifier of a species, compartment, or parameter (but not a
reaction).  The entity identified must have its 'constant' attribute
set to 'False.'  The effects of a RateRule are in general terms the
same, but differ in the precise details depending on which variable is
being set:

* In the case of a species, a RateRule sets the rate of change of
the species' quantity (concentration or amount of substance) to the
value determined by the formula in the 'math' subelement of the
RateRule object.  The overall units of the formula in 'math' should
(in SBML Level 2 Version 4 and in SBML Level 3) or must (in SBML
releases prior to Level 2 version 4) be equal to the unit of species
quantity divided by the model-wide unit of time.  Restrictions: There
must not be both a RateRule 'variable' attribute and a
SpeciesReference 'species' attribute having the same value, unless
that species has its 'boundaryCondition' attribute is set to 'True.'
This means a rate rule cannot be defined for a species that is created
or destroyed in a reaction, unless that species is defined as a
boundary condition in the model.

* (For SBML Level 3 only) In the case of a species reference, a
RateRule sets the rate of change of the stoichiometry of the
referenced reactant or product to the value determined by the formula
in 'math'.  The unit associated with the value produced by the 'math'
formula should be consistent with the unit 'dimensionless' divided by
the model-wide unit of time.

* In the case of a compartment, a RateRule sets the rate of change of
the compartment's size to the value determined by the formula in the
'math' subelement of the RateRule object.  The overall units of the
formula should (in SBML Level 2 Version 4 and in SBML Level 3) or must
(in SBML releases prior to Level 2 version 4) be the units of the
compartment's size divided by the model-wide unit of time.

* In the case of a parameter, a RateRule sets the rate of change of
the parameter's value to that determined by the formula in the 'math'
subelement of the RateRule object.  The overall units of the formula
should (in SBML Level 2 Version 4 and in SBML Level 3) or must (in
SBML releases prior to Level 2 version 4) be the Parameter object's
'unit' attribute value divided by the model-wide unit of time.

* (For SBML Level 3 Version 2 only) In the case of  an object from an
SBML Level 3 package, a RateRule sets the rate  of change of the
referenced object's value (as defined by that package)  to the value
of the formula in 'math'.  The unit of measurement associated  with
the value produced by the formula should be the same as that object's
units attribute value (if it has such an attribute) divided by the
model-wide unit of time, or be equal to the units of model components
of that type (if objects of that class are defined by the package as
having  the same units) divided by the model-wide unit of time. In
SBML Level 2 and Level 3 Version 1, the 'math'  subelement of the
RateRule is required.  In SBML Level 3 Version 2, this rule is
relaxed, and the subelement is optional.  If a RateRule with no 'math'
child is present in the model,  the rate at which its referenced
'variable' changes over time is  undefined.  This may represent a
situation where the model itself is unfinished, or the missing
information may be provided by an SBML Level 3 package.

If the variable attribute of a RateRule object references an object in
an SBML namespace that is not understood by the interpreter reading a
given SBML document (that is, if the object is defined by an SBML
Level 3 package that the software does not support), the rate rule
must be ignored--the object's value will not need to be set, as the
interpreter could not understand that package. If an interpreter
cannot  establish whether a referenced object is missing from the
model or  instead is defined in an SBML namespace not understood by
the interpreter,  it may produce a warning to the user. (The latter
situation may only  arise if an SBML package is present in the SBML
document with a  package:required attribute of 'true'.)

In the context of a simulation, rate rules are in effect for
simulation time t > 0.  Please consult the relevant SBML specification
for additional information about the semantics of assignments, rules,
and entity values for simulation time t <= 0.

As mentioned in the description of AssignmentRule, a model must not
contain more than one RateRule or AssignmentRule object having the
same value of 'variable'; in other words, in the set of all assignment
rules and rate rules in an SBML model, each variable appearing in the
left-hand sides can only appear once.  This simply follows from the
fact that an indeterminate system would result if a model contained
more than one assignment rule for the same variable or both an
assignment rule and a rate rule for the same variable.

General summary of SBML rules
======================================================================

In SBML Level 3 as well as Level 2, rules are separated into three
subclasses for the benefit of model analysis software.  The three
subclasses are based on the following three different possible
functional forms (where x is a variable, f is some arbitrary function
returning a numerical result, V is a vector of variables that does not
include x, and W is a vector of variables that may include x):

   Algebraic:   left-hand side is zero               0 = f(W)     
   Assignment:  left-hand side is a scalar:          x = f(V)     
   Rate:        left-hand side is a rate-of-change:  dx/dt = f(W)

In their general form given above, there is little to distinguish
between assignment and algebraic rules.  They are treated as separate
cases for the following reasons:

* Assignment rules can simply be evaluated to calculate
intermediate values for use in numerical methods.  They are statements
of equality that hold at all times.  (For assignments that are only
performed once, see InitialAssignment.)

* SBML needs to place restrictions on assignment rules, for example
the restriction that assignment rules cannot contain algebraic loops.

* Some simulators do not contain numerical solvers capable of
solving unconstrained algebraic equations, and providing more direct
forms such as assignment rules may enable those simulators to process
models they could not process if the same assignments were put in the
form of general algebraic equations;

* Those simulators that can solve these algebraic equations make a
distinction between the different categories listed above; and

* Some specialized numerical analyses of models may only be
applicable to models that do not contain algebraic rules.

The approach taken to covering these cases in SBML is to define an
abstract Rule structure containing a subelement, 'math', to hold the
right-hand side expression, then to derive subtypes of Rule that add
attributes to distinguish the cases of algebraic, assignment and rate
rules.  The 'math' subelement must contain a MathML expression
defining the mathematical formula of the rule.  This MathML formula
must return a numerical value.  The formula can be an arbitrary
expression referencing the variables and other entities in an SBML
model.

Each of the three subclasses of Rule (AssignmentRule, AlgebraicRule,
RateRule) inherit the the 'math' subelement and other fields from
SBase. The AssignmentRule and RateRule classes add an additional
attribute, 'variable'.  See the definitions of AssignmentRule,
AlgebraicRule and RateRule for details about the structure and
interpretation of each one.

Additional restrictions on SBML rules
======================================================================

An important design goal of SBML rule semantics is to ensure that a
model's simulation and analysis results will not be dependent on when
or how often rules are evaluated.  To achieve this, SBML needs to
place two restrictions on rule use.  The first concerns algebraic
loops in the system of assignments in a model, and the second concerns
overdetermined systems.

A model must not contain algebraic loops
......................................................................

The combined set of InitialAssignment, AssignmentRule and KineticLaw
objects in a model constitute a set of assignment statements that
should be considered as a whole.  (A KineticLaw object is counted as
an assignment because it assigns a value to the symbol contained in
the 'id' attribute of the Reaction object in which it is defined.)
This combined set of assignment statements must not contain algebraic
loops---dependency chains between these statements must terminate.  To
put this more formally, consider a directed graph in which nodes are
assignment statements and directed arcs exist for each occurrence of
an SBML species, compartment or parameter symbol in an assignment
statement's 'math' subelement.  Let the directed arcs point from the
statement assigning the symbol to the statements that contain the
symbol in their 'math' subelement expressions. This graph must be
acyclic.

Similarly, the combined set of RateRule and Reaction objects
constitute  a set of definitions for the rates of change of various
model entities  (namely, the objects identified by the values of the
'variable' attributes  of the RateRule objects, and the 'species'
attributes of the SpeciesReference  objects in each Reaction).  In
SBML Level 3 Version 2, these rates  of change may be referenced
directly  using the rateOf csymbol, but may not thereby contain
algebraic  loops---dependency chains between these statements must
terminate.  More  formally, consider a directed graph in which the
nodes are the definitions  of different variables' rates of change,
and directed arcs exist for each  occurrence of a variable referenced
by a rateOf csymbol from any  RateRule or KineticLaw object in the
model.  Let the directed arcs point  from the variable referenced by
the rateOf csymbol (call it  x) to the variable(s) determined by the
'math' expression in which x appears.  This graph must be acyclic.

SBML does not specify when or how often rules should be evaluated.
Eliminating algebraic loops ensures that assignment statements can be
evaluated any number of times without the result of those evaluations
changing.  As an example, consider the set of equations x = x + 1, y =
z + 200 and z = y + 100.  If this set of equations were interpreted as
a set of assignment statements, it would be invalid because the rule
for x refers to x (exhibiting one type of loop), and the rule for y
refers to z while the rule for z refers back to y (exhibiting another
type of loop). Conversely, the following set of equations would
constitute a valid set of assignment statements: x = 10, y = z + 200,
and z = x + 100.

A model must not be overdetermined
......................................................................

An SBML model must not be overdetermined; that is, a model must not
define more equations than there are unknowns in a model.  A valid
SBML model that does not contain AlgebraicRule structures cannot be
overdetermined.

LibSBML implements the static analysis procedure described in Appendix
B of the SBML Level 3 specification for assessing whether a model is
overdetermined.

(In summary, assessing whether a given continuous, deterministic,
mathematical model is overdetermined does not require dynamic
analysis; it can be done by analyzing the system of equations created
from the model. One approach is to construct a bipartite graph in
which one set of vertices represents the variables and the other the
set of vertices represents the equations.  Place edges between
vertices such that variables in the system are linked to the equations
that determine them.  For algebraic equations, there will be edges
between the equation and each variable occurring in the equation.  For
ordinary differential equations (such as those defined by rate rules
or implied by the reaction rate definitions), there will be a single
edge between the equation and the variable determined by that
differential equation.  A mathematical model is overdetermined if the
maximal matchings of the bipartite graph contain disconnected vertexes
representing equations.  If one maximal matching has this property,
then all the maximal matchings will have this property; i.e., it is
only necessary to find one maximal matching.)

Rule types for SBML Level 1
======================================================================

SBML Level 1 uses a different scheme than SBML Level 2 and Level 3 for
distinguishing rules; specifically, it uses an attribute whose value
is drawn from an enumeration of 3 values.  LibSBML supports this using
methods that work with the enumeration values  listed below.

* RULE_TYPE_RATE: Indicates the rule is a 'rate' rule.

* RULE_TYPE_SCALAR: Indicates the rule is a 'scalar' rule.

* RULE_TYPE_INVALID: Indicates the rule type is unknown or not yet
set.
";


%feature("docstring") RateRule::RateRule "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    RateRule(SBMLNamespaces sbmlns)

Creates a new RateRule using the given SBMLNamespaces object 'sbmlns'.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

Parameter 'sbmlns' is an SBMLNamespaces object.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    RateRule(long level, long version)

Creates a new RateRule using the given SBML 'level' and 'version'
values.

Parameter 'level' is a long integer, the SBML Level to assign to this
RateRule.

Parameter 'version' is a long integer, the SBML Version to assign to
this RateRule.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.
";


%feature("docstring") RateRule::clone "
Creates and returns a deep copy of this RateRule object.

Returns the (deep) copy of this RateRule object.
";


%feature("docstring") RateRule::accept "
Internal implementation method.
";


%feature("docstring") RateRule::hasRequiredAttributes "
Predicate returning 'True' if all the required attributes for this
RateRule object have been set.

In SBML Levels 2-3, the only required attribute for a RateRule object
is 'variable'.  For Level 1, where the equivalent attribute is known
by different names ('compartment', 'species', or 'name', depending on
the type of object), there is an additional required attribute called
'formula'.

Returns 'True' if the required attributes have been set, 'False'
otherwise.
";


%feature("docstring") RateRule::renameSIdRefs "
Replaces all uses of a given 'SIdRef' type attribute value with
another value.

In SBML, object identifiers are of a data type called SId. In SBML
Level 3, an explicit data type called SIdRef was introduced for
attribute values that refer to SId values; in previous Levels of SBML,
this data type did not exist and attributes were simply described to
as 'referring to an identifier', but the effective data type was the
same as SIdRef in Level 3.  These and other methods of libSBML refer
to the type SIdRef for all Levels of SBML, even if the corresponding
SBML specification did not explicitly name the data type.

This method works by looking at all attributes and (if appropriate)
mathematical formulas in MathML content, comparing the referenced
identifiers to the value of 'oldid'.  If any matches are found, the
matching values are replaced with 'newid'.  The method does not
descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") Constraint "
An SBML constraint, for stating validity assumptions.

The Constraint object class was introduced in SBML Level 2 Version 2
as a mechanism for stating the assumptions under which a model is
designed to operate.  The constraints are statements about permissible
values of different quantities in a model. Constraints are not used to
compute dynamical values for simulation or analysis, but rather, they
serve an advisory role for simulation/analysis tools.

SBML's Constraint object class has one required attribute, 'id', to
give the parameter a unique identifier by which other parts of an SBML
model definition can refer to it.  A Constraint object can also have
an optional 'name' attribute of type 'string.'  Identifiers and names
must be used according to the guidelines described in the SBML
specification (e.g., Section 3.3 in the Level 2 Version 4
specification).

Constraint has one subelement, 'math', containing a MathML formula
defining the condition of the constraint.  This formula will return a
Boolean value of 'True' when the model is a valid state.  The formula
can be an arbitrary expression referencing the variables and other
entities in an SBML model.  The evaluation of 'math' and behavior of
constraints are described in more detail below.

In SBML Level 2 and SBML Level 3 Version 1, the 'math' subelement is
required, and its formula must be a Boolean value.  In SBML Level 3
Version 2, these restrictions were relaxed: the 'math' subelement is
optional, and numeric values are allowed in Boolean contexts (a '0' is
interpreted as 'False,' and all other values are interpreted as
'True).'  If a Constraint with no 'math' is present in a Model, no
restriction on the Model's behavior is implied or enforced.

A Constraint structure also has an optional subelement called
'message'. This can contain a message in XHTML format that may be
displayed to the user when the condition of the formula in the 'math'
subelement evaluates to a value of 'False.'  Software tools are not
required to display the message, but it is recommended that they do so
as a matter of best practice.  The XHTML content within a 'message'
subelement must follow the same restrictions as for the 'notes'
element on SBase described in in the SBML Level 2 specification;
please consult the SBML specification document corresponding to the
SBML Level and Version of your model for more information about the
requirements for 'notes' content.

Constraint was introduced in SBML Level 2 Version 2.  It is not
available in earlier versions of Level 2 nor in any version of Level
1.

Semantics of Constraints
======================================================================

In the context of a simulation, a Constraint has effect at all times t
>= 0.  Each Constraint's 'math' subelement is first evaluated after
any InitialAssignment definitions in a model at t = 0 and can
conceivably trigger at that point.  (In other words, a simulation
could fail a constraint immediately.)

Constraint structures cannot and should not be used to compute the
dynamical behavior of a model as part of, for example, simulation.
Constraints may be used as input to non-dynamical analysis, for
instance by expressing flux constraints for flux balance analysis.

The results of a simulation of a model containing a constraint are
invalid from any simulation time at and after a point when the
function given by the 'math' subelement returns a value of 'False.'
Invalid simulation results do not make a prediction of the behavior of
the biochemical reaction network represented by the model.  The
precise behavior of simulation tools is left undefined with respect to
constraints.  If invalid results are detected with respect to a given
constraint, the 'message' subelement may optionally be displayed to
the user.  The simulation tool may also halt the simulation or clearly
delimit in output data the simulation time point at which the
simulation results become invalid.

SBML does not impose restrictions on duplicate Constraint definitions
or the order of evaluation of Constraint objects in a model.  It is
possible for a model to define multiple constraints all with the same
mathematical expression.  Since the failure of any constraint
indicates that the model simulation has entered an invalid state, a
system is not required to attempt to detect whether other constraints
in the model have failed once any one constraint has failed.
";


%feature("docstring") ListOfConstraints "
A list of Constraint objects.

The various ListOf___ classes in SBML are merely containers used for
organizing the main components of an SBML model.  In libSBML's
implementation, ListOf___ classes are derived from the intermediate
utility class ListOf, which is not defined by the SBML specifications
but serves as a useful programmatic construct.  ListOf is itself is in
turn derived from SBase, which provides all of the various ListOf___
classes with common features defined by the SBML specification, such
as 'metaid' attributes and annotations.

The relationship between the lists and the rest of an SBML model is
illustrated by the following (for SBML Level 2 Version 4):

  <?xml version=\"1.0\" encoding=\"UTF-8\"?>
  <sbml xmlns=\"http://www.sbml.org/sbml/level3/version1/core\" 
        level=\"3\" version=\"1\">
    <model id=\"My_Model\">
      <listOfFunctionDefinitions>
        <functionDefinition> ... </functionDefinition> 
      </listOfFunctionDefinitions>
      <listOfUnitDefinitions>
        <unitDefinition> ... </unitDefinition> 
      </listOfUnitDefinitions>
      <listOfCompartments>
        <compartment> ... </compartment> 
      </listOfCompartments>
      <listOfSpecies>
        <species> ... </species> 
      </listOfSpecies>
      <listOfParameters>
        <parameter> ... </parameter> 
      </listOfParameters>
      <listOfInitialAssignments>
        <initialAssignment> ... </initialAssignment> 
      </listOfInitialAssignments>
      <listOfRules>
        ... elements of subclasses of Rule ...
      </listOfRules>
      <listOfConstraints>
        <constraint> ... </constraint> 
      </listOfConstraints>
      <listOfReactions>
        <reaction> ... </reaction> 
      </listOfReactions>
      <listOfEvents>
        <event> ... </event> 
      </listOfEvents>
    </model>
  </sbml>

SBML Level 3 Version 1 has essentially the same structure as  Level
2 Version 4, depicted above, but SBML Level 3  Version 2 allows
containers to contain zero or more of the relevant object, instead of
requiring at least one.  As such, libsbml will write out an
otherwise-empty ListOf___ element that has any optional attribute set
(such as 'id' or 'metaid'), that has an optional child (such  as a
'notes' or 'annotation'), or that has attributes or children set from
any SBML Level 3 package, whether or not the ListOf___ has  any other
children.

Readers may wonder about the motivations for using the ListOf___
containers in SBML.  A simpler approach in XML might be to place the
components all directly at the top level of the model definition.  The
choice made in SBML is to group them within XML elements named after
ListOfClassname, in part because it helps organize the components.
More importantly, the fact that the container classes are derived from
SBase means that software tools can add information about the lists
themselves into each list container's 'annotation'.

See also ListOfFunctionDefinitions, ListOfUnitDefinitions,
ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
ListOfSpecies, ListOfParameters, ListOfInitialAssignments,
ListOfRules, ListOfConstraints, ListOfReactions, ListOfEvents.
";


%feature("docstring") Constraint::Constraint "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    Constraint(SBMLNamespaces sbmlns)

Creates a new Constraint using the given SBMLNamespaces object
'sbmlns'.

The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
information.  It is used to communicate the SBML Level, Version, and
(in Level 3) packages used in addition to SBML Level 3 Core.  A common
approach to using libSBML's SBMLNamespaces facilities is to create an
SBMLNamespaces object somewhere in a program once, then hand that
object as needed to object constructors that accept SBMLNamespaces as
arguments.

Parameter 'sbmlns' is an SBMLNamespaces object.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    Constraint(long level, long version)

Creates a new Constraint using the given SBML 'level' and 'version'
values.

Parameter 'level' is a long integer, the SBML Level to assign to this
Constraint.

Parameter 'version' is a long integer, the SBML Version to assign to
this Constraint.

Throws SBMLConstructorException: Thrown if the given 'level' and
'version' combination are invalid or if this object is incompatible
with the given level and version.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but the reverse is not
permitted.)  The restriction is necessary to ensure that an SBML model
has a consistent overall structure.  This requires callers to manage
their objects carefully, but the benefit is increased flexibility in
how models can be created by permitting callers to create objects
bottom-up if desired.  In situations where objects are not yet
attached to parents (e.g., SBMLDocument), knowledge of the intented
SBML Level and Version help libSBML determine such things as whether
it is valid to assign a particular value to an attribute.

______________________________________________________________________
Method variant with the following signature:

    Constraint( Constraint orig)

Copy constructor; creates a copy of this Constraint.

Parameter 'orig' is the object to copy.
";


%feature("docstring") Constraint::accept "
Internal implementation method.
";


%feature("docstring") Constraint::clone "
Creates and returns a deep copy of this Constraint object.

Returns the (deep) copy of this Constraint object.
";


%feature("docstring") Constraint::getMessage "
Get the message, if any, associated with this Constraint

Returns the message for this Constraint, as an XMLNode.
";


%feature("docstring") Constraint::getMessageString "
Get the message string, if any, associated with this Constraint

Returns the message for this Constraint, as a string.
";


%feature("docstring") Constraint::getMath "
Get the mathematical expression of this Constraint

Returns the math for this Constraint, as an ASTNode, or 'None' if the
math is not set.
";


%feature("docstring") Constraint::isSetMessage "
Predicate returning 'True' if a message is defined for this
Constraint.

Returns 'True' if the message of this Constraint is set, 'False'
otherwise.
";


%feature("docstring") Constraint::isSetMath "
Predicate returning 'True' if a mathematical formula is defined for
this Constraint.

Returns 'True' if the 'math' subelement for this Constraint is set,
'False' otherwise.
";


%feature("docstring") Constraint::setMessage "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    setMessage(string message, bool addXHTMLMarkup = false)

Sets the message of this Constraint.

Parameter 'message' is an XML string that is to be used as the content
of the 'message' subelement of this object.

Parameter 'addXHTMLMarkup' is a boolean indicating whether to wrap the
contents of the 'message' argument with XHTML paragraph (<p>) tags.
This is appropriate when the string in 'message' does not already
containg the appropriate XHTML markup.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_OBJECT

Note: Owing to the way that language interfaces are created in
libSBML, this documentation may show methods that define default
values for parameters with text that has the form parameter = value.
This is not to be intepreted as a Python keyword argument; the use of
a parameter name followed by an equals sign followed by a value is
only meant to indicate a default value if the argument is not provided
at all.  It is not a keyword in the Python sense.

______________________________________________________________________
Method variant with the following signature:

    setMessage(XMLNode xhtml)

Sets the message of this Constraint.

The XMLNode tree passed in 'xhtml' is copied.

Parameter 'xhtml' is an XML tree containing XHTML content.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_OBJECT
";


%feature("docstring") Constraint::setMath "
Sets the mathematical expression of this Constraint to a copy of the
AST given as 'math'.

Parameter 'math' is an ASTNode expression to be assigned as the 'math'
subelement of this Constraint.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_INVALID_OBJECT
";


%feature("docstring") Constraint::unsetMessage "
Unsets the 'message' subelement of this Constraint.

Returns integer value indicating success/failure of the function.
The possible values returned by this function are:

* LIBSBML_OPERATION_SUCCESS

* LIBSBML_OPERATION_FAILED
";


%feature("docstring") Constraint::renameSIdRefs "
Replaces all uses of a given 'SIdRef' type attribute value with
another value.

In SBML, object identifiers are of a data type called SId. In SBML
Level 3, an explicit data type called SIdRef was introduced for
attribute values that refer to SId values; in previous Levels of SBML,
this data type did not exist and attributes were simply described to
as 'referring to an identifier', but the effective data type was the
same as SIdRef in Level 3.  These and other methods of libSBML refer
to the type SIdRef for all Levels of SBML, even if the corresponding
SBML specification did not explicitly name the data type.

This method works by looking at all attributes and (if appropriate)
mathematical formulas in MathML content, comparing the referenced
identifiers to the value of 'oldid'.  If any matches are found, the
matching values are replaced with 'newid'.  The method does not
descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") Constraint::renameUnitSIdRefs "
Replaces all uses of a given 'UnitSIdRef' type attribute value with
another value.

In SBML, unit definitions have identifiers of type UnitSId.  In SBML
Level 3, an explicit data type called UnitSIdRef was introduced for
attribute values that refer to UnitSId values; in previous Levels of
SBML, this data type did not exist and attributes were simply
described to as 'referring to a unit identifier', but the effective
data type was the same as UnitSIdRef in Level 3.  These and other
methods of libSBML refer to the type UnitSIdRef for all Levels of
SBML, even if the corresponding SBML specification did not explicitly
name the data type.

This method works by looking at all unit identifier attribute values
(including, if appropriate, inside mathematical formulas), comparing
the referenced unit identifiers to the value of 'oldid'.  If any
matches are found, the matching values are replaced with 'newid'.  The
method does not descend into child elements.

Parameter 'oldid' is the old identifier. Parameter 'newid' is the new
identifier.
";


%feature("docstring") Constraint::replaceSIDWithFunction "
Internal implementation method.
";


%feature("docstring") Constraint::getTypeCode "
Returns the libSBML type code for this SBML object.

LibSBML attaches an identifying code to every kind of SBML object.
These are integer constants known as SBML type codes.  The names of
all the codes begin with the characters SBML_. In the Python language
interface for libSBML, the type codes are defined as static integer
constants in the interface class 'libsbml'.  Note that different Level
3 package plug-ins may use overlapping type codes; to identify the
package to which a given object belongs, call the
SBase.getPackageName()

method on the object.

Returns the SBML type code for this object: SBML_CONSTRAINT (default).

WARNING:

The specific integer values of the possible type codes may be reused
by different libSBML plug-ins for SBML Level 3. packages,  To fully
identify the correct code, it is necessary to invoke both
getTypeCode() and getPackageName().

See also getElementName(), getPackageName().
";


%feature("docstring") Constraint::getElementName "
Returns the XML element name of this object, which for Constraint, is
always ''constraint'.'

Returns the name of this element, i.e., ''constraint'.'
";


%feature("docstring") Constraint::writeElements "
Internal implementation method.
";


%feature("docstring") Constraint::hasRequiredElements "
Predicate returning 'True' if all the required elements for this
Constraint object have been set.

Note: The required elements for a Constraint object are:

* 'math' (through SBML Level 3 Version 1 only; not  required in
Level 3 Version 2+.)

Returns a boolean value indicating whether all the required elements
for this object have been defined.
";


%feature("docstring") Constraint::getInternalId "
Internal implementation method.
";


%feature("docstring") Constraint::setInternalId "
Internal implementation method.
";


%feature("docstring") Constraint::readOtherXML "
Internal implementation method.
";


%feature("docstring") Constraint::addExpectedAttributes "
Internal implementation method.
";


%feature("docstring") Constraint::readAttributes "
Internal implementation method.
";


%feature("docstring") Constraint::readL2Attributes "
Internal implementation method.
";


%feature("docstring") Constraint::readL3Attributes "
Internal implementation method.
";


%feature("docstring") Constraint::writeAttributes "
Internal implementation method.
";


%feature("docstring") ListOfConstraints::ListOfConstraints "
This method has multiple variants; they differ in the arguments  they
accept.  Each variant is described separately below.

______________________________________________________________________
Method variant with the following signature:

    ListOfConstraints(SBMLNamespaces sbmlns)

Creates a new ListOfConstraints object.

The object is constructed such that it is valid for the SBML Level and
Version combination determined by the SBMLNamespaces object in
'sbmlns'.

Parameter 'sbmlns' is an SBMLNamespaces object that is used to
determine the characteristics of the ListOfConstraints object to be
created.

Throws SBMLConstructorException: Thrown if the given 'sbmlns' is
inconsistent or incompatible with this object.

Note: Attempting to add an object to an SBMLDocument having a
different combination of SBML Level, Version and XML namespaces than
the object itself will result in an error at the time a caller
attempts to make the addition.  A parent object must have compatible
Level, Version and XML namespaces.  (Strictly speaking, a parent may
also have more XML namespaces than a child, but th