#
# @file    TestSyncAnnotation.py
# @brief   tests for improved syncAnnotation functions
#
# @author  Akiya Jouraku (Python conversion)
# @author  Sarah Keating
 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestSyncAnnotation.cpp
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml

def wrapString(s):
  return s
  pass


class TestSyncAnnotation(unittest.TestCase):

  global d
  d = None
  global m
  m = None

  def equals(self, *x):
    if len(x) == 2:
      return x[0] == x[1]
    elif len(x) == 1:
      return x[0] == self.OSS.str()


  def setUp(self):
    filename = "../../sbml/annotation/test/test-data/annotationL3_2.xml"
    self.d = libsbml.readSBML(filename)
    self.m = self.d.getModel()
    pass  

  def tearDown(self):
    self.d = None
    pass  

  def test_SyncAnnotation_deleteCVTerms(self):
    c = self.m.getCompartment(1)
    xml = libsbml.RDFAnnotationParser.deleteRDFCVTermAnnotation(c.getAnnotation())
    expected = wrapString("<annotation>\n"
 + 
    "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "    <jd2:header>\n"
 + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "    </jd2:header>\n"
 + 
    "  </jd2:JDesignerLayout>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG>\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "    <rdf:Description>\n"
 + 
    "      <rdf:other/>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    self.assertEqual( True, self.equals(expected,xml.toXMLString()) )
    pass  

  def test_SyncAnnotation_deleteModelOnly(self):
    c = self.m.getCompartment(1)
    xml = libsbml.RDFAnnotationParser.deleteRDFHistoryAnnotation(c.getAnnotation())
    expected = wrapString("<annotation>\n"
 + 
    "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "    <jd2:header>\n"
 + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "    </jd2:header>\n"
 + 
    "  </jd2:JDesignerLayout>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "    <rdf:Description>\n"
 + 
    "      <rdf:other/>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    self.assertEqual( True, self.equals(expected,xml.toXMLString()) )
    pass  

  def test_SyncAnnotation_deleteModelOnly_1(self):
    c = self.m.getCompartment(7)
    xml = libsbml.RDFAnnotationParser.deleteRDFHistoryAnnotation(c.getAnnotation())
    expected = wrapString("<annotation>\n"
 + 
    "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "    <jd2:header>\n"
 + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "    </jd2:header>\n"
 + 
    "  </jd2:JDesignerLayout>\n"
 + 
    "</annotation>")
    self.assertEqual( True, self.equals(expected,xml.toXMLString()) )
    xml = libsbml.RDFAnnotationParser.deleteRDFHistoryAnnotation(None)
    self.assert_( xml == None )
    xml = libsbml.RDFAnnotationParser.deleteRDFHistoryAnnotation(libsbml.XMLNode.convertStringToXMLNode("<notannotatio/>"))
    self.assert_( xml == None )
    pass  

  def test_SyncAnnotation_modifyBoth_1(self):
    c = self.m.getCompartment(0)
    mh = self.m.getModelHistory().clone()
    cv = self.m.getCVTerm(0).clone()
    c.setModelHistory(mh)
    c.addCVTerm(cv)
    c.unsetCVTerms()
    expected = wrapString("<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000002\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected,c.toSBML()) )
    c.unsetModelHistory()
    c.addCVTerm(cv)
    expected1 = wrapString("<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000002\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected1,c.toSBML()) )
    c.setModelHistory(mh)
    c.unsetCVTerms()
    c.addCVTerm(cv)
    expected2 = wrapString("<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000002\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected2,c.toSBML()) )
    pass  

  def test_SyncAnnotation_modifyBoth_2(self):
    c = self.m.getCompartment(0)
    mh = self.m.getModelHistory().clone()
    cv = self.m.getCVTerm(0).clone()
    c.setModelHistory(mh)
    c.unsetModelHistory()
    c.addCVTerm(cv)
    expected = wrapString("<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000002\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected,c.toSBML()) )
    pass  

  def test_SyncAnnotation_modifyBoth_3(self):
    c = self.m.getCompartment(0)
    mh = self.m.getModelHistory().clone()
    cv = self.m.getCVTerm(0).clone()
    c.setModelHistory(mh)
    c.addCVTerm(cv)
    expected = wrapString("<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000002\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected,c.toSBML()) )
    pass  

  def test_SyncAnnotation_modifyBoth_4(self):
    c = self.m.getCompartment(1)
    mh = c.getModelHistory().clone()
    cv = c.getCVTerm(0).clone()
    c.unsetModelHistory()
    c.unsetCVTerms()
    expected = wrapString("<compartment metaid=\"_000003\" id=\"A\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "      <jd2:header>\n"
 + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "      </jd2:header>\n"
 + 
    "    </jd2:JDesignerLayout>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description>\n"
 + 
    "        <rdf:other/>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected,c.toSBML()) )
    c.setModelHistory(mh)
    c.addCVTerm(cv)
    c.unsetCVTerms()
    expected1 = wrapString("<compartment metaid=\"_000003\" id=\"A\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "      <jd2:header>\n"
 + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "      </jd2:header>\n"
 + 
    "    </jd2:JDesignerLayout>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "      <rdf:Description>\n"
 + 
    "        <rdf:other/>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected1,c.toSBML()) )
    c.unsetModelHistory()
    c.unsetCVTerms()
    c.addCVTerm(cv)
    expected2 = wrapString("<compartment metaid=\"_000003\" id=\"A\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "      <jd2:header>\n"
 + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "      </jd2:header>\n"
 + 
    "    </jd2:JDesignerLayout>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "      <rdf:Description>\n"
 + 
    "        <rdf:other/>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected2,c.toSBML()) )
    c.unsetModelHistory()
    c.unsetCVTerms()
    c.addCVTerm(cv)
    c.setModelHistory(mh)
    expected3 = wrapString("<compartment metaid=\"_000003\" id=\"A\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "      <jd2:header>\n"
 + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "      </jd2:header>\n"
 + 
    "    </jd2:JDesignerLayout>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "      <rdf:Description>\n"
 + 
    "        <rdf:other/>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected3,c.toSBML()) )
    pass  

  def test_SyncAnnotation_modifyCVTerms_1(self):
    c = self.m.getCompartment(4)
    cv = c.getCVTerm(0).clone()
    c.unsetCVTerms()
    c.addCVTerm(cv)
    expected = wrapString("<compartment metaid=\"_000012\" id=\"cc\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000012\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected,c.toSBML()) )
    pass  

  def test_SyncAnnotation_modifyCVTerms_2(self):
    self.m.unsetCVTerms()
    expected = wrapString("<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000001\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG>\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    self.assertEqual( True, self.equals(expected,self.m.getAnnotation().toXMLString()) )
    pass  

  def test_SyncAnnotation_modifyCVTerms_3(self):
    cv = self.m.getCVTerm(0).clone()
    self.m.unsetCVTerms()
    self.m.addCVTerm(cv)
    expected = wrapString("<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000001\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG>\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    self.assertEqual( True, self.equals(expected,self.m.getAnnotation().toXMLString()) )
    pass  

  def test_SyncAnnotation_modifyCVTerms_4(self):
    cv = self.m.getCVTerm(0).clone()
    c = self.m.getCompartment(0)
    c.addCVTerm(cv)
    expected = wrapString("<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000002\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected,c.toSBML()) )
    pass  

  def test_SyncAnnotation_modifyCVTerms_5(self):
    c = self.m.getCompartment(6)
    cv = c.getCVTerm(0).clone()
    c.unsetCVTerms()
    c.addCVTerm(cv)
    expected = wrapString("<compartment metaid=\"_000042\" id=\"cc1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000042\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "      <rdf:Description/>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected,c.toSBML()) )
    pass  

  def test_SyncAnnotation_modifyHistory_1(self):
    c = self.m.getCompartment(3)
    mh = c.getModelHistory().clone()
    c.unsetModelHistory()
    c.setModelHistory(mh)
    expected = wrapString("<compartment metaid=\"_000004\" id=\"C\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000004\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected,c.toSBML()) )
    pass  

  def test_SyncAnnotation_modifyHistory_2(self):
    self.m.unsetModelHistory()
    expected = wrapString("<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000001\">\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    self.assertEqual( True, self.equals(expected,self.m.getAnnotation().toXMLString()) )
    pass  

  def test_SyncAnnotation_modifyHistory_3(self):
    mh = self.m.getModelHistory().clone()
    self.m.unsetModelHistory()
    self.m.setModelHistory(mh)
    expected = wrapString("<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000001\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    self.assertEqual( True, self.equals(expected,self.m.getAnnotation().toXMLString()) )
    pass  

  def test_SyncAnnotation_modifyHistory_4(self):
    c = self.m.getCompartment(0)
    mh = self.m.getModelHistory().clone()
    c.setModelHistory(mh)
    expected = wrapString("<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000002\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected,c.toSBML()) )
    pass  

  def test_SyncAnnotation_modifyHistory_5(self):
    c = self.m.getCompartment(5)
    mh = c.getModelHistory().clone()
    c.unsetModelHistory()
    c.setModelHistory(mh)
    expected = wrapString("<compartment metaid=\"_000032\" id=\"C1\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000032\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "      <rdf:other/>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected,c.toSBML()) )
    pass  

  def test_SyncAnnotation_noChanges_1(self):
    c = self.m.getCompartment(1)
    expected = wrapString("<compartment metaid=\"_000003\" id=\"A\" constant=\"true\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n"
 + 
    "      <jd2:header>\n"
 + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n"
 + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n"
 + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n"
 + 
    "      </jd2:header>\n"
 + 
    "    </jd2:JDesignerLayout>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG>\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "      <rdf:Description>\n"
 + 
    "        <rdf:other/>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected,c.toSBML()) )
    pass  

  def test_SyncAnnotation_noChanges_2(self):
    expected = wrapString("<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000001\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG>\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    self.assertEqual( True, self.equals(expected,self.m.getAnnotation().toXMLString()) )
    pass  

  def test_SyncAnnotation_stringChangesMetaid(self):
    c = libsbml.Compartment(3,1)
    c.setMetaId("_000005")
    c.setId("A")
    addedAnn = wrapString("<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    c.setAnnotation(addedAnn)
    expected = wrapString("<compartment metaid=\"_000005\" id=\"A\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000005\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected,c.toSBML()) )
    pass  

  def test_SyncAnnotation_stringChangesMetaid_1(self):
    c = libsbml.Model(2, 3)
    c.setMetaId("_000005")
    c.setId("A")
    addedAnn = wrapString("<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    c.setAnnotation(addedAnn)
    expected = wrapString("<model metaid=\"_000005\" id=\"A\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000005\">\n"
 + 
    "        <dc:creator rdf:parseType=\"Resource\">\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG>\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</model>")
    self.assertEqual( True, self.equals(expected,c.toSBML()) )
    pass  

  def test_SyncAnnotation_stringChangesMetaid_2(self):
    c = libsbml.Compartment(2,3)
    c.setMetaId("_000005")
    c.setId("A")
    addedAnn = wrapString("<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    c.setAnnotation(addedAnn)
    expected = wrapString("<compartment metaid=\"_000005\" id=\"A\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000005\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected,c.toSBML()) )
    pass  

  def test_SyncAnnotation_stringChangesMetaid_3(self):
    c = libsbml.Model(3,1)
    c.setMetaId("_000005")
    c.setId("A")
    addedAnn = wrapString("<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    c.setAnnotation(addedAnn)
    expected = wrapString("<model metaid=\"_000005\" id=\"A\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000005\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</model>")
    self.assertEqual( True, self.equals(expected,c.toSBML()) )
    pass  

  def test_SyncAnnotation_stringHistoryWhenNotValid(self):
    c = libsbml.Compartment(2,3)
    c.setMetaId("_000003")
    c.setId("A")
    addedAnn = wrapString("<annotation>\n"
 + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "    <rdf:Description rdf:about=\"#_000005\">\n"
 + 
    "      <dc:creator>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "            <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "              <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "            </vCard:N>\n"
 + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "            <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "            </vCard:ORG>\n"
 + 
    "          </rdf:li>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </dc:creator>\n"
 + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:created>\n"
 + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "      </dcterms:modified>\n"
 + 
    "      <bqbiol:is>\n"
 + 
    "        <rdf:Bag>\n"
 + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "        </rdf:Bag>\n"
 + 
    "      </bqbiol:is>\n"
 + 
    "    </rdf:Description>\n"
 + 
    "  </rdf:RDF>\n"
 + 
    "</annotation>")
    c.setAnnotation(addedAnn)
    expected = wrapString("<compartment metaid=\"_000003\" id=\"A\">\n"
 + 
    "  <annotation>\n"
 + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
 + 
    "      <rdf:Description rdf:about=\"#_000003\">\n"
 + 
    "        <bqbiol:is>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </bqbiol:is>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "      <rdf:Description rdf:about=\"#_000005\">\n"
 + 
    "        <dc:creator>\n"
 + 
    "          <rdf:Bag>\n"
 + 
    "            <rdf:li rdf:parseType=\"Resource\">\n"
 + 
    "              <vCard:N rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Family>Le Novere</vCard:Family>\n"
 + 
    "                <vCard:Given>Nicolas</vCard:Given>\n"
 + 
    "              </vCard:N>\n"
 + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n"
 + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n"
 + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n"
 + 
    "              </vCard:ORG>\n"
 + 
    "            </rdf:li>\n"
 + 
    "          </rdf:Bag>\n"
 + 
    "        </dc:creator>\n"
 + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:created>\n"
 + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n"
 + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n"
 + 
    "        </dcterms:modified>\n"
 + 
    "      </rdf:Description>\n"
 + 
    "    </rdf:RDF>\n"
 + 
    "  </annotation>\n"
 + 
    "</compartment>")
    self.assertEqual( True, self.equals(expected,c.toSBML()) )
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.makeSuite(TestSyncAnnotation))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
