#include "osl/record/miniBoard.h"
#include <string>

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class MiniBoardTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE( MiniBoardTest );
  CPPUNIT_TEST( testBase64Encode );
  CPPUNIT_TEST_SUITE_END();
 public:
  void testBase64Encode();
};

CPPUNIT_TEST_SUITE_REGISTRATION( MiniBoardTest );

using namespace osl;

void MiniBoardTest::testBase64Encode(){
  const SimpleState state(HIRATE);
  const record::MiniBoard mb(state);
  const std::string ret = mb.toBase64();
  const std::string answer = "RMF0jCdMw3UMR1TFdYxnXMd2DIdkyXREGWRJlIQpYEiUxDlcR5SIiAoYKgkmwmlZUQA=";
  CPPUNIT_ASSERT_EQUAL(answer, ret);
  record::MiniBoard mb2;
  const int result = fromBase64(answer, mb2);
  CPPUNIT_ASSERT_EQUAL(0, result);
  CPPUNIT_ASSERT_EQUAL(mb.getState(), mb2.getState());
  
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:

