/*
 * Copyright (C) 2014 Michal Ratajsky <michal.ratajsky@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the licence, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#include "matemixer-enum-types.h"
#include "matemixer-enums.h"

/*
 * GTypes are not generated by glib-mkenums, see:
 * https://bugzilla.gnome.org/show_bug.cgi?id=621942
 */

GType
mate_mixer_state_get_type (void)
{
    static GType etype = 0;

    if (etype == 0) {
        static const GEnumValue values[] = {
            { MATE_MIXER_STATE_IDLE, "MATE_MIXER_STATE_IDLE", "idle" },
            { MATE_MIXER_STATE_CONNECTING, "MATE_MIXER_STATE_CONNECTING", "connecting" },
            { MATE_MIXER_STATE_READY, "MATE_MIXER_STATE_READY", "ready" },
            { MATE_MIXER_STATE_FAILED, "MATE_MIXER_STATE_FAILED", "failed" },
            { MATE_MIXER_STATE_UNKNOWN, "MATE_MIXER_STATE_UNKNOWN", "unknown" },
            { 0, NULL, NULL }
        };
        etype = g_enum_register_static (
            g_intern_static_string ("MateMixerState"),
            values);
    }
    return etype;
}

GType
mate_mixer_backend_type_get_type (void)
{
    static GType etype = 0;

    if (etype == 0) {
        static const GEnumValue values[] = {
            { MATE_MIXER_BACKEND_UNKNOWN, "MATE_MIXER_BACKEND_UNKNOWN", "unknown" },
            { MATE_MIXER_BACKEND_PULSEAUDIO, "MATE_MIXER_BACKEND_PULSEAUDIO", "pulseaudio" },
            { MATE_MIXER_BACKEND_ALSA, "MATE_MIXER_BACKEND_ALSA", "alsa" },
            { MATE_MIXER_BACKEND_OSS, "MATE_MIXER_BACKEND_OSS", "oss" },
            { MATE_MIXER_BACKEND_NULL, "MATE_MIXER_BACKEND_NULL", "null" },
            { 0, NULL, NULL }
        };
        etype = g_enum_register_static (
            g_intern_static_string ("MateMixerBackendType"),
            values);
    }
    return etype;
}

GType
mate_mixer_backend_flags_get_type (void)
{
    static GType etype = 0;

    if (etype == 0) {
        static const GFlagsValue values[] = {
            { MATE_MIXER_BACKEND_NO_FLAGS, "MATE_MIXER_STREAM_NO_FLAGS", "no-flags" },
            { MATE_MIXER_BACKEND_HAS_APPLICATION_CONTROLS, "MATE_MIXER_BACKEND_HAS_APPLICATION_CONTROLS", "has-application-controls" },
            { MATE_MIXER_BACKEND_HAS_STORED_CONTROLS, "MATE_MIXER_BACKEND_HAS_STORED_CONTROLS", "has-stored-controls" },
            { MATE_MIXER_BACKEND_CAN_SET_DEFAULT_INPUT_STREAM, "MATE_MIXER_BACKEND_CAN_SET_DEFAULT_INPUT_STREAM", "can-set-default-input-stream" },
            { MATE_MIXER_BACKEND_CAN_SET_DEFAULT_OUTPUT_STREAM, "MATE_MIXER_BACKEND_CAN_SET_DEFAULT_OUTPUT_STREAM", "can-set-default-output-stream" },
            { 0, NULL, NULL }
        };
        etype = g_flags_register_static (
            g_intern_static_string ("MateMixerBackendFlags"),
            values);
    }
    return etype;
}

GType
mate_mixer_direction_get_type (void)
{
    static GType etype = 0;

    if (etype == 0) {
        static const GEnumValue values[] = {
            { MATE_MIXER_DIRECTION_UNKNOWN, "MATE_MIXER_DIRECTION_UNKNOWN", "unknown" },
            { MATE_MIXER_DIRECTION_INPUT, "MATE_MIXER_DIRECTION_INPUT", "input" },
            { MATE_MIXER_DIRECTION_OUTPUT, "MATE_MIXER_DIRECTION_OUTPUT", "output" },
            { 0, NULL, NULL }
        };
        etype = g_enum_register_static (
            g_intern_static_string ("MateMixerDirection"),
            values);
    }
    return etype;
}

GType
mate_mixer_stream_control_flags_get_type (void)
{
    static GType etype = 0;

    if (etype == 0) {
        static const GFlagsValue values[] = {
            { MATE_MIXER_STREAM_CONTROL_NO_FLAGS, "MATE_MIXER_STREAM_CONTROL_NO_FLAGS", "no-flags" },
            { MATE_MIXER_STREAM_CONTROL_MUTE_READABLE, "MATE_MIXER_STREAM_CONTROL_MUTE_READABLE", "mute-readable" },
            { MATE_MIXER_STREAM_CONTROL_MUTE_WRITABLE, "MATE_MIXER_STREAM_CONTROL_MUTE_WRITABLE", "mute-writable" },
            { MATE_MIXER_STREAM_CONTROL_VOLUME_READABLE, "MATE_MIXER_STREAM_CONTROL_VOLUME_READABLE", "volume-readable" },
            { MATE_MIXER_STREAM_CONTROL_VOLUME_WRITABLE, "MATE_MIXER_STREAM_CONTROL_VOLUME_WRITABLE", "volume-writable" },
            { MATE_MIXER_STREAM_CONTROL_CAN_BALANCE, "MATE_MIXER_STREAM_CONTROL_CAN_BALANCE", "can-balance" },
            { MATE_MIXER_STREAM_CONTROL_CAN_FADE, "MATE_MIXER_STREAM_CONTROL_CAN_FADE", "can-fade" },
            { MATE_MIXER_STREAM_CONTROL_MOVABLE, "MATE_MIXER_STREAM_CONTROL_MOVABLE", "movable" },
            { MATE_MIXER_STREAM_CONTROL_HAS_DECIBEL, "MATE_MIXER_STREAM_CONTROL_HAS_DECIBEL", "has-decibel" },
            { MATE_MIXER_STREAM_CONTROL_HAS_MONITOR, "MATE_MIXER_STREAM_CONTROL_HAS_MONITOR", "has-monitor" },
            { MATE_MIXER_STREAM_CONTROL_STORED, "MATE_MIXER_STREAM_CONTROL_STORED", "stored" },
            { 0, NULL, NULL }
        };
        etype = g_flags_register_static (
            g_intern_static_string ("MateMixerStreamControlFlags"),
            values);
    }
    return etype;
}

GType
mate_mixer_stream_control_role_get_type (void)
{
    static GType etype = 0;

    if (etype == 0) {
        static const GEnumValue values[] = {
            { MATE_MIXER_STREAM_CONTROL_ROLE_UNKNOWN, "MATE_MIXER_STREAM_CONTROL_ROLE_UNKNOWN", "unknown" },
            { MATE_MIXER_STREAM_CONTROL_ROLE_MASTER, "MATE_MIXER_STREAM_CONTROL_ROLE_MASTER", "master" },
            { MATE_MIXER_STREAM_CONTROL_ROLE_APPLICATION, "MATE_MIXER_STREAM_CONTROL_ROLE_APPLICATION", "application" },
            { MATE_MIXER_STREAM_CONTROL_ROLE_PCM, "MATE_MIXER_STREAM_CONTROL_ROLE_PCM", "pcm" },
            { MATE_MIXER_STREAM_CONTROL_ROLE_SPEAKER, "MATE_MIXER_STREAM_CONTROL_ROLE_SPEAKER", "speaker" },
            { MATE_MIXER_STREAM_CONTROL_ROLE_MICROPHONE, "MATE_MIXER_STREAM_CONTROL_ROLE_MICROPHONE", "microphone" },
            { MATE_MIXER_STREAM_CONTROL_ROLE_PORT, "MATE_MIXER_STREAM_CONTROL_ROLE_PORT", "port" },
            { MATE_MIXER_STREAM_CONTROL_ROLE_BOOST, "MATE_MIXER_STREAM_CONTROL_ROLE_BOOST", "boost" },
            { MATE_MIXER_STREAM_CONTROL_ROLE_BASS, "MATE_MIXER_STREAM_CONTROL_ROLE_BASS", "bass" },
            { MATE_MIXER_STREAM_CONTROL_ROLE_TREBLE, "MATE_MIXER_STREAM_CONTROL_ROLE_TREBLE", "treble" },
            { MATE_MIXER_STREAM_CONTROL_ROLE_CD, "MATE_MIXER_STREAM_CONTROL_ROLE_CD", "cd" },
            { MATE_MIXER_STREAM_CONTROL_ROLE_VIDEO, "MATE_MIXER_STREAM_CONTROL_ROLE_VIDEO", "video" },
            { MATE_MIXER_STREAM_CONTROL_ROLE_MUSIC, "MATE_MIXER_STREAM_CONTROL_ROLE_MUSIC", "music" },
            { 0, NULL, NULL }
        };
        etype = g_enum_register_static (
            g_intern_static_string ("MateMixerStreamControlRole"),
            values);
    }
    return etype;
}

GType
mate_mixer_stream_control_media_role_get_type (void)
{
    static GType etype = 0;

    if (etype == 0) {
        static const GEnumValue values[] = {
            { MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_UNKNOWN, "MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_UNKNOWN", "unknown" },
            { MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_VIDEO, "MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_VIDEO", "video" },
            { MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_MUSIC, "MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_MUSIC", "music" },
            { MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_GAME, "MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_GAME", "game" },
            { MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_EVENT, "MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_EVENT", "event" },
            { MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_PHONE, "MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_PHONE", "phone" },
            { MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_ANIMATION, "MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_ANIMATION", "animation" },
            { MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_PRODUCTION, "MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_PRODUCTION", "production" },
            { MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_A11Y, "MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_A11Y", "a11y" },
            { MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_TEST, "MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_TEST", "test" },
            { MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_ABSTRACT, "MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_ABSTRACT", "abstract" },
            { MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_FILTER, "MATE_MIXER_STREAM_CONTROL_MEDIA_ROLE_FILTER", "filter" },
            { 0, NULL, NULL }
        };
        etype = g_enum_register_static (
            g_intern_static_string ("MateMixerStreamControlMediaRole"),
            values);
    }
    return etype;
}

GType
mate_mixer_device_switch_role_get_type (void)
{
    static GType etype = 0;

    if (etype == 0) {
        static const GEnumValue values[] = {
            { MATE_MIXER_DEVICE_SWITCH_ROLE_UNKNOWN, "MATE_MIXER_DEVICE_SWITCH_ROLE_UNKNOWN", "unknown" },
            { MATE_MIXER_DEVICE_SWITCH_ROLE_PROFILE, "MATE_MIXER_DEVICE_SWITCH_ROLE_PROFILE", "profile" },
            { 0, NULL, NULL }
        };
        etype = g_enum_register_static (
            g_intern_static_string ("MateMixerDeviceSwitchRole"),
            values);
    }
    return etype;
}

GType
mate_mixer_stream_switch_flags_get_type (void)
{
    static GType etype = 0;

    if (etype == 0) {
        static const GFlagsValue values[] = {
            { MATE_MIXER_STREAM_SWITCH_NO_FLAGS, "MATE_MIXER_STREAM_SWITCH_NO_FLAGS", "no-flags" },
            { MATE_MIXER_STREAM_SWITCH_TOGGLE, "MATE_MIXER_STREAM_SWITCH_TOGGLE", "toggle" },
            { 0, NULL, NULL }
        };
        etype = g_flags_register_static (
            g_intern_static_string ("MateMixerStreamSwitchFlags"),
            values);
    }
    return etype;
}

GType
mate_mixer_stream_switch_role_get_type (void)
{
    static GType etype = 0;

    if (etype == 0) {
        static const GEnumValue values[] = {
            { MATE_MIXER_STREAM_SWITCH_ROLE_UNKNOWN, "MATE_MIXER_STREAM_SWITCH_ROLE_UNKNOWN", "unknown" },
            { MATE_MIXER_STREAM_SWITCH_ROLE_PORT, "MATE_MIXER_STREAM_SWITCH_ROLE_PORT", "port" },
            { MATE_MIXER_STREAM_SWITCH_ROLE_BOOST, "MATE_MIXER_STREAM_SWITCH_ROLE_BOOST", "boost" },
            { 0, NULL, NULL }
        };
        etype = g_enum_register_static (
            g_intern_static_string ("MateMixerStreamSwitchRole"),
            values);
    }
    return etype;
}

GType
mate_mixer_channel_position_get_type (void)
{
    static GType etype = 0;

    if (etype == 0) {
        static const GEnumValue values[] = {
            { MATE_MIXER_CHANNEL_UNKNOWN, "MATE_MIXER_CHANNEL_UNKNOWN", "unknown" },
            { MATE_MIXER_CHANNEL_MONO, "MATE_MIXER_CHANNEL_MONO", "mono" },
            { MATE_MIXER_CHANNEL_FRONT_LEFT, "MATE_MIXER_CHANNEL_FRONT_LEFT", "front-left" },
            { MATE_MIXER_CHANNEL_FRONT_RIGHT, "MATE_MIXER_CHANNEL_FRONT_RIGHT", "front-right" },
            { MATE_MIXER_CHANNEL_FRONT_CENTER, "MATE_MIXER_CHANNEL_FRONT_CENTER", "front-center" },
            { MATE_MIXER_CHANNEL_LFE, "MATE_MIXER_CHANNEL_LFE", "lfe" },
            { MATE_MIXER_CHANNEL_BACK_LEFT, "MATE_MIXER_CHANNEL_BACK_LEFT", "back-left" },
            { MATE_MIXER_CHANNEL_BACK_RIGHT, "MATE_MIXER_CHANNEL_BACK_RIGHT", "back-right" },
            { MATE_MIXER_CHANNEL_BACK_CENTER, "MATE_MIXER_STREAM_BACK_CENTER", "back-center" },
            { MATE_MIXER_CHANNEL_FRONT_LEFT_CENTER, "MATE_MIXER_STREAM_FRONT_LEFT_CENTER", "front-left-center" },
            { MATE_MIXER_CHANNEL_FRONT_RIGHT_CENTER, "MATE_MIXER_STREAM_FRONT_RIGHT_CENTER", "front-right-center" },
            { MATE_MIXER_CHANNEL_SIDE_LEFT, "MATE_MIXER_CHANNEL_SIDE_LEFT", "side-left" },
            { MATE_MIXER_CHANNEL_SIDE_RIGHT, "MATE_MIXER_CHANNEL_SIDE_RIGHT", "side-right" },
            { MATE_MIXER_CHANNEL_TOP_FRONT_LEFT, "MATE_MIXER_CHANNEL_TOP_FRONT_LEFT", "top-front-left" },
            { MATE_MIXER_CHANNEL_TOP_FRONT_RIGHT, "MATE_MIXER_CHANNEL_TOP_FRONT_RIGHT", "top-front-right" },
            { MATE_MIXER_CHANNEL_TOP_FRONT_CENTER, "MATE_MIXER_CHANNEL_TOP_FRONT_CENTER", "top-front-center" },
            { MATE_MIXER_CHANNEL_TOP_CENTER, "MATE_MIXER_CHANNEL_TOP_CENTER", "top-center" },
            { MATE_MIXER_CHANNEL_TOP_BACK_LEFT, "MATE_MIXER_CHANNEL_TOP_BACK_LEFT", "top-back-left" },
            { MATE_MIXER_CHANNEL_TOP_BACK_RIGHT, "MATE_MIXER_CHANNEL_TOP_BACK_RIGHT", "top-back-right" },
            { MATE_MIXER_CHANNEL_TOP_BACK_CENTER, "MATE_MIXER_CHANNEL_TOP_BACK_CENTER", "top-back-center" },
            { MATE_MIXER_CHANNEL_MAX, "MATE_MIXER_CHANNEL_MAX", "max" },
            { 0, NULL, NULL }
        };
        etype = g_enum_register_static (
            g_intern_static_string ("MateMixerChannelPosition"),
            values);
    }
    return etype;
}
