/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.metadata.plugins.cache;

/**
 * Simple cache interface.
 *
 * @param <K> exact key type
 * @param <V> value key type
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public interface Cache<K, V>
{
   /**
    * Put value under key.
    *
    * @param key the key
    * @param value the value
    * @return old value if exists
    */
   V put(K key, V value);

   /**
    * Get value under key.
    *
    * @param key the key
    * @return old value if exists
    */
   V get(K key);

   /**
    * Remove value under key.
    *
    * @param key the key
    * @return removed value
    */
   V remove(K key);

   /**
    * Clear node.
    */
   void clear();
}
