/*
 * Qt wrapper for libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: LGPL v2.1 or LGPL v3
 */
#ifndef QINDICATEDECODE_H
#define QINDICATEDECODE_H

namespace QIndicate
{

/**
 * This namespace provides functions to decode the value of serialized properties
 */
namespace Decode
{

QString stringFromValue(const QByteArray&);
int intFromValue(const QByteArray&, int defaultValue=0);
bool boolFromValue(const QByteArray&, bool defaultValue=false);
QImage imageFromValue(const QByteArray&);
QDateTime dateTimeFromValue(const QByteArray&);

} // namespace

} // namespace

#endif /* QINDICATEDECODE_H */
