/// \file BuiltInMathPlugin.h
///
/// \author Roger James
/// \date 13th November 2013
///
/// This file provides the built in math plugin functionality

#ifndef INDI_ALIGNMENTSUBSYSTEM_BUILTINMATHPLUGIN_H
#define INDI_ALIGNMENTSUBSYSTEM_BUILTINMATHPLUGIN_H

#include "BasicMathPlugin.h"

namespace INDI {
namespace AlignmentSubsystem {

/*!
 * \class BuiltInMathPlugin
 * \brief This class implements the default math plugin.
 */
class BuiltInMathPlugin : public BasicMathPlugin
{
private:

    /// \brief Calculate tranformation matrices from the supplied vectors
    /// \param[in] Alpha1 Pointer to the first coordinate in the alpha reference frame
    /// \param[in] Alpha2 Pointer to the second coordinate in the alpha reference frame
    /// \param[in] Alpha3 Pointer to the third coordinate in the alpha reference frame
    /// \param[in] Beta1 Pointer to the first coordinate in the beta reference frame
    /// \param[in] Beta2 Pointer to the second coordinate in the beta reference frame
    /// \param[in] Beta3 Pointer to the third coordinate in the beta reference frame
    /// \param[in] pAlphaToBeta Pointer to a matrix to receive the Alpha to Beta transformation matrix
    /// \param[in] pBetaToAlpha Pointer to a matrix to receive the Beta to Alpha transformation matrix
    void CalculateTransformMatrices(const TelescopeDirectionVector& Alpha1, const TelescopeDirectionVector& Alpha2, const TelescopeDirectionVector& Alpha3,
                            const TelescopeDirectionVector& Beta1, const TelescopeDirectionVector& Beta2, const TelescopeDirectionVector& Beta3,
                            gsl_matrix *pAlphaToBeta, gsl_matrix *pBetaToAlpha);

};

} // namespace AlignmentSubsystem
} // namespace INDI

#endif // INDI_ALIGNMENTSUBSYSTEM_BUILTINMATHPLUGIN_H
