#########################################################################################
# Package        HiPi::Graphics::BitmapFont::MonoExtended11
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Graphics::BitmapFont::MonoExtended11;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Graphics::BitmapFont);

our $VERSION ='0.01';

my $gap_width = 0;
my $char_height = 11;
my $line_spacing = 0;
my $name = 'Mono 11';
my $space_width = 5;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 1, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x00, ##   
            0x00, ##   
            0x80, ##  0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 2, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x30, ##    00 
            0x50, ##   0 0 
            0xF8, ##  00000
            0x50, ##   0 0 
            0xF0, ##  0000 
            0x60, ##   00  
            0xA0, ##  0 0  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x40, ##   0  
            0xE0, ##  000 
            0xC0, ##  00  
            0xC0, ##  00  
            0x70, ##   000
            0x50, ##   0 0
            0xE0, ##  000 
            0x40, ##   0  
            0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000  
            0xA0, ##  0 0  
            0xF0, ##  0000 
            0x78, ##   0000
            0x28, ##    0 0
            0x38, ##    000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00  
            0x40, ##   0   
            0x40, ##   0   
            0xA0, ##  0 0  
            0xA8, ##  0 0 0
            0x90, ##  0  0 
            0x68, ##   00 0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 1, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x80, ##  0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x40, ##   0
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x40, ##   0
            0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 2, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0 
            0x80, ##  0 
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x80, ##  0 
            0x80, ##  0 
            0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x20, ##    0  
            0x70, ##   000 
            0x70, ##   000 
            0x20, ##    0  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x20, ##    0  
            0xF8, ##  00000
            0x20, ##    0  
            0x20, ##    0  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 1, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x80, ##  0
            0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 2, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 1, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x10, ##     0
            0x10, ##     0
            0x20, ##    0 
            0x20, ##    0 
            0x40, ##   0  
            0x40, ##   0  
            0x40, ##   0  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0xB0, ##  0 00
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00 
            0x20, ##    0
            0x20, ##    0
            0x40, ##   0 
            0x40, ##   0 
            0x80, ##  0  
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000 
            0x10, ##     0
            0x10, ##     0
            0x60, ##   00 
            0x10, ##     0
            0x10, ##     0
            0xE0, ##  000 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x20, ##    0 
            0x60, ##   00 
            0xA0, ##  0 0 
            0xA0, ##  0 0 
            0xA0, ##  0 0 
            0xF0, ##  0000
            0x20, ##    0 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00 
            0x80, ##  0  
            0xC0, ##  00 
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0xC0, ##  00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00 
            0x80, ##  0   
            0xE0, ##  000 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0x10, ##     0
            0x20, ##    0 
            0x20, ##    0 
            0x20, ##    0 
            0x40, ##   0  
            0x40, ##   0  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x70, ##   000
            0x10, ##     0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 1, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x00, ##   
            0x00, ##   
            0x80, ##  0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 1, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x00, ##   
            0x00, ##   
            0x00, ##   
            0x80, ##  0
            0x80, ##  0
            0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x10, ##     0
            0x60, ##   00 
            0x80, ##  0   
            0x70, ##   000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0x00, ##      
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x80, ##  0   
            0x60, ##   00 
            0x10, ##     0
            0xE0, ##  000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0x20, ##    0
            0x20, ##    0
            0x40, ##   0 
            0x40, ##   0 
            0x00, ##     
            0x40, ##   0 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000 
            0x48, ##   0  0
            0xB8, ##  0 000
            0xC8, ##  00  0
            0xC8, ##  00  0
            0xB8, ##  0 000
            0x40, ##   0   
            0x70, ##   000 
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x20, ##    0  
            0x60, ##   00  
            0x50, ##   0 0 
            0x50, ##   0 0 
            0x70, ##   000 
            0x90, ##  0  0 
            0x88, ##  0   0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000 
            0x90, ##  0  0
            0x90, ##  0  0
            0xE0, ##  000 
            0x90, ##  0  0
            0x90, ##  0  0
            0xE0, ##  000 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0xC0, ##  00  
            0x80, ##  0   
            0x80, ##  0   
            0x80, ##  0   
            0x80, ##  0   
            0x70, ##   000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0xE0, ##  000 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0x80, ##  0   
            0x80, ##  0   
            0xF0, ##  0000
            0x80, ##  0   
            0x80, ##  0   
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0x80, ##  0   
            0x80, ##  0   
            0xE0, ##  000 
            0x80, ##  0   
            0x80, ##  0   
            0x80, ##  0   
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0x80, ##  0   
            0x80, ##  0   
            0xB0, ##  0 00
            0x90, ##  0  0
            0x90, ##  0  0
            0x70, ##   000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0xF0, ##  0000
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0x10, ##     0
            0x10, ##     0
            0x10, ##     0
            0x10, ##     0
            0x90, ##  0  0
            0x70, ##   000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x90, ##  0  0
            0xA0, ##  0 0 
            0xC0, ##  00  
            0xC0, ##  00  
            0xA0, ##  0 0 
            0x90, ##  0  0
            0x90, ##  0  0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0   
            0x80, ##  0   
            0x80, ##  0   
            0x80, ##  0   
            0x80, ##  0   
            0x80, ##  0   
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x90, ##  0  0
            0xF0, ##  0000
            0xF0, ##  0000
            0xD0, ##  00 0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x90, ##  0  0
            0xD0, ##  00 0
            0xD0, ##  00 0
            0xD0, ##  00 0
            0xB0, ##  0 00
            0xB0, ##  0 00
            0x90, ##  0  0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0xE0, ##  000 
            0x80, ##  0   
            0x80, ##  0   
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x10, ##     0
            0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000  
            0x90, ##  0  0 
            0x90, ##  0  0 
            0xE0, ##  000  
            0x90, ##  0  0 
            0x90, ##  0  0 
            0x90, ##  0  0 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0x80, ##  0   
            0x80, ##  0   
            0x60, ##   00 
            0x10, ##     0
            0x10, ##     0
            0xE0, ##  000 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x90, ##  0  0 
            0x90, ##  0  0 
            0x50, ##   0 0 
            0x50, ##   0 0 
            0x50, ##   0 0 
            0x20, ##    0  
            0x20, ##    0  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x88, ##  0   0
            0x88, ##  0   0
            0xA8, ##  0 0 0
            0xF0, ##  0000 
            0xF0, ##  0000 
            0x50, ##   0 0 
            0x50, ##   0 0 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x90, ##  0  0 
            0x50, ##   0 0 
            0x60, ##   00  
            0x20, ##    0  
            0x60, ##   00  
            0x50, ##   0 0 
            0x88, ##  0   0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x88, ##  0   0
            0x50, ##   0 0 
            0x50, ##   0 0 
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0x10, ##     0
            0x20, ##    0 
            0x40, ##   0  
            0x40, ##   0  
            0x80, ##  0   
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0xC0, ##  00
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0   
            0x40, ##   0  
            0x40, ##   0  
            0x20, ##    0 
            0x20, ##    0 
            0x20, ##    0 
            0x10, ##     0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 2, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0xC0, ##  00
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x20, ##    0  
            0x60, ##   00  
            0x90, ##  0  0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 2, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x80, ##  0 
            0x40, ##   0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000 
            0x10, ##     0
            0xF0, ##  0000
            0x90, ##  0  0
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0   
            0x80, ##  0   
            0xE0, ##  000 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0xE0, ##  000 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0x80, ##  0   
            0x80, ##  0   
            0x80, ##  0   
            0x70, ##   000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x10, ##     0
            0x10, ##     0
            0x70, ##   000
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x70, ##   000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x60, ##   00 
            0x90, ##  0  0
            0xF0, ##  0000
            0x80, ##  0   
            0x70, ##   000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0x40, ##   0  
            0xF0, ##  0000
            0x40, ##   0  
            0x40, ##   0  
            0x40, ##   0  
            0x40, ##   0  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x70, ##   000
            0x10, ##     0
            0x60, ##   00 
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0  
            0x80, ##  0  
            0xE0, ##  000
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x40, ##   0 
            0x00, ##     
            0xC0, ##  00 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 3, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x20, ##    0
            0x00, ##     
            0x60, ##   00
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0xE0, ##  000
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0   
            0x80, ##  0   
            0xA0, ##  0 0 
            0xC0, ##  00  
            0xC0, ##  00  
            0xA0, ##  0 0 
            0x90, ##  0  0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00  
            0x40, ##   0  
            0x40, ##   0  
            0x40, ##   0  
            0x40, ##   0  
            0x40, ##   0  
            0x70, ##   000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0xA8, ##  0 0 0
            0xA8, ##  0 0 0
            0xA8, ##  0 0 0
            0xA8, ##  0 0 0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0xE0, ##  000 
            0x80, ##  0   
            0x80, ##  0   
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x70, ##   000
            0x10, ##     0
            0x10, ##     0
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0x80, ##  0  
            0x80, ##  0  
            0x80, ##  0  
            0x80, ##  0  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0x80, ##  0  
            0x40, ##   0 
            0x20, ##    0
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x40, ##   0  
            0x40, ##   0  
            0xF0, ##  0000
            0x40, ##   0  
            0x40, ##   0  
            0x40, ##   0  
            0x70, ##   000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x90, ##  0  0
            0x50, ##   0 0
            0x50, ##   0 0
            0x60, ##   00 
            0x20, ##    0 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x88, ##  0   0
            0xA8, ##  0 0 0
            0xB0, ##  0 00 
            0xD0, ##  00 0 
            0x50, ##   0 0 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x50, ##   0 0 
            0x60, ##   00  
            0x20, ##    0  
            0x50, ##   0 0 
            0x90, ##  0  0 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x90, ##  0  0 
            0x50, ##   0 0 
            0x50, ##   0 0 
            0x60, ##   00  
            0x20, ##    0  
            0x20, ##    0  
            0x40, ##   0   
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0x20, ##    0 
            0x40, ##   0  
            0x80, ##  0   
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x80, ##  0  
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x60, ##   00
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 1, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x20, ##    0
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0xC0, ##  00 
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '160' => {    # ' '
        'width'    => 0, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
        ], 
    }, 
    '161' => {    # '¡'
        'width'    => 1, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x00, ##   
            0x00, ##   
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '162' => {    # '¢'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x20, ##    0 
            0x20, ##    0 
            0x70, ##   000
            0xA0, ##  0 0 
            0xA0, ##  0 0 
            0xA0, ##  0 0 
            0x70, ##   000
            0x20, ##    0 
            0x00, ##  
        ], 
    }, 
    '163' => {    # '£'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0x40, ##   0  
            0x40, ##   0  
            0xE0, ##  000 
            0x40, ##   0  
            0x40, ##   0  
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '164' => {    # '¤'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xA0, ##  0 0
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '165' => {    # '¥'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x88, ##  0   0
            0x50, ##   0 0 
            0x50, ##   0 0 
            0xD8, ##  00 00
            0xF8, ##  00000
            0x20, ##    0  
            0x20, ##    0  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '166' => {    # '¦'
        'width'    => 1, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x00, ##   
            0x00, ##   
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
        ], 
    }, 
    '167' => {    # '§'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0x80, ##  0  
            0x40, ##   0 
            0xA0, ##  0 0
            0xA0, ##  0 0
            0x40, ##   0 
            0x20, ##    0
            0xE0, ##  000
            0x00, ##  
        ], 
    }, 
    '168' => {    # '¨'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xA0, ##  0 0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '169' => {    # '©'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000 
            0xF8, ##  00000
            0xC8, ##  00  0
            0xC8, ##  00  0
            0xF8, ##  00000
            0x70, ##   000 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '170' => {    # 'ª'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00 
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '171' => {    # '«'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x10, ##     0
            0x60, ##   00 
            0xA0, ##  0 0 
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '172' => {    # '¬'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0x10, ##     0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '173' => {    # '­'
        'width'    => 2, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '174' => {    # '®'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000 
            0xF8, ##  00000
            0xE8, ##  000 0
            0xE8, ##  000 0
            0xD8, ##  00 00
            0x70, ##   000 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '175' => {    # '¯'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xA0, ##  0 0
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '177' => {    # '±'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x20, ##    0  
            0xF8, ##  00000
            0x20, ##    0  
            0x00, ##       
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '178' => {    # '²'
        'width'    => 2, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x40, ##   0
            0x40, ##   0
            0x80, ##  0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '179' => {    # '³'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x40, ##   0
            0xC0, ##  00
            0x40, ##   0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '180' => {    # '´'
        'width'    => 2, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x40, ##   0
            0x80, ##  0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '181' => {    # 'µ'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xA0, ##  0 0 
            0xA0, ##  0 0 
            0xA0, ##  0 0 
            0xA0, ##  0 0 
            0xF0, ##  0000
            0x80, ##  0   
            0x80, ##  0   
        ], 
    }, 
    '182' => {    # '¶'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x60, ##   00
            0x00, ##  
        ], 
    }, 
    '183' => {    # '·'
        'width'    => 1, 
        'xoffset'  => 2, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '184' => {    # '¸'
        'width'    => 2, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x40, ##   0
            0xC0, ##  00
        ], 
    }, 
    '185' => {    # '¹'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00 
            0x40, ##   0 
            0x40, ##   0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '186' => {    # 'º'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xC0, ##  00 
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '187' => {    # '»'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##      
            0xA0, ##  0 0 
            0x50, ##   0 0
            0xA0, ##  0 0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '188' => {    # '¼'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x40, ##   0   
            0x40, ##   0   
            0x40, ##   0   
            0xE0, ##  000  
            0x70, ##   000 
            0x90, ##  0  0 
            0x30, ##    00 
            0x30, ##    00 
            0x10, ##     0 
        ], 
    }, 
    '189' => {    # '½'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x40, ##   0  
            0x40, ##   0  
            0x40, ##   0  
            0xE0, ##  000 
            0x70, ##   000
            0xB0, ##  0 00
            0x10, ##     0
            0x20, ##    0 
            0x30, ##    00
            0x00, ##  
        ], 
    }, 
    '190' => {    # '¾'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00   
            0x40, ##   0   
            0x40, ##   0   
            0xC0, ##  00   
            0x70, ##   000 
            0x90, ##  0  0 
            0x70, ##   000 
            0x70, ##   000 
            0x10, ##     0 
        ], 
    }, 
    '191' => {    # '¿'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x40, ##   0 
            0x00, ##     
            0x40, ##   0 
            0x40, ##   0 
            0x80, ##  0  
            0x80, ##  0  
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '192' => {    # 'À'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x40, ##   0   
            0x20, ##    0  
            0x20, ##    0  
            0x60, ##   00  
            0x50, ##   0 0 
            0x50, ##   0 0 
            0x70, ##   000 
            0x90, ##  0  0 
            0x88, ##  0   0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '193' => {    # 'Á'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##       
            0x20, ##    0  
            0x20, ##    0  
            0x60, ##   00  
            0x50, ##   0 0 
            0x50, ##   0 0 
            0x70, ##   000 
            0x90, ##  0  0 
            0x88, ##  0   0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '194' => {    # 'Â'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x20, ##    0  
            0x60, ##   00  
            0x20, ##    0  
            0x60, ##   00  
            0x50, ##   0 0 
            0x50, ##   0 0 
            0x70, ##   000 
            0x90, ##  0  0 
            0x88, ##  0   0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '195' => {    # 'Ã'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x70, ##   000 
            0x20, ##    0  
            0x60, ##   00  
            0x50, ##   0 0 
            0x50, ##   0 0 
            0x70, ##   000 
            0x90, ##  0  0 
            0x88, ##  0   0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '196' => {    # 'Ä'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x50, ##   0 0 
            0x20, ##    0  
            0x60, ##   00  
            0x50, ##   0 0 
            0x50, ##   0 0 
            0x70, ##   000 
            0x90, ##  0  0 
            0x88, ##  0   0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '197' => {    # 'Å'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x60, ##   00 
            0x60, ##   00 
            0x60, ##   00 
            0x60, ##   00 
            0x60, ##   00 
            0xA0, ##  0 0 
            0xF0, ##  0000
            0x90, ##  0  0
            0x90, ##  0  0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '198' => {    # 'Æ'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0xA0, ##  0 0 
            0xA0, ##  0 0 
            0xB0, ##  0 00
            0xE0, ##  000 
            0xA0, ##  0 0 
            0xB0, ##  0 00
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '199' => {    # 'Ç'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0x80, ##  0   
            0x80, ##  0   
            0x80, ##  0   
            0x80, ##  0   
            0x80, ##  0   
            0x60, ##   00 
            0x00, ##      
            0x20, ##    0 
        ], 
    }, 
    '200' => {    # 'È'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x40, ##   0  
            0x40, ##   0  
            0xF0, ##  0000
            0x80, ##  0   
            0x80, ##  0   
            0xF0, ##  0000
            0x80, ##  0   
            0x80, ##  0   
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '201' => {    # 'É'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x20, ##    0 
            0x40, ##   0  
            0xF0, ##  0000
            0x80, ##  0   
            0x80, ##  0   
            0xF0, ##  0000
            0x80, ##  0   
            0x80, ##  0   
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '202' => {    # 'Ê'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##      
            0x60, ##   00 
            0xF0, ##  0000
            0x80, ##  0   
            0x80, ##  0   
            0xF0, ##  0000
            0x80, ##  0   
            0x80, ##  0   
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '203' => {    # 'Ë'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x60, ##   00 
            0xF0, ##  0000
            0x80, ##  0   
            0x80, ##  0   
            0xF0, ##  0000
            0x80, ##  0   
            0x80, ##  0   
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '204' => {    # 'Ì'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x80, ##  0  
            0x40, ##   0 
            0xE0, ##  000
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '205' => {    # 'Í'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x20, ##    0
            0x40, ##   0 
            0xE0, ##  000
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '206' => {    # 'Î'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x40, ##   0 
            0xA0, ##  0 0
            0xE0, ##  000
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '207' => {    # 'Ï'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0xA0, ##  0 0
            0xE0, ##  000
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '208' => {    # 'Ð'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000 
            0x90, ##  0  0
            0x90, ##  0  0
            0xD0, ##  00 0
            0x90, ##  0  0
            0x90, ##  0  0
            0xE0, ##  000 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '209' => {    # 'Ñ'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x60, ##   00 
            0x90, ##  0  0
            0xD0, ##  00 0
            0xD0, ##  00 0
            0xD0, ##  00 0
            0xB0, ##  0 00
            0xB0, ##  0 00
            0x90, ##  0  0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '210' => {    # 'Ò'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x40, ##   0  
            0x00, ##      
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '211' => {    # 'Ó'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x20, ##    0 
            0x00, ##      
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '212' => {    # 'Ô'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##      
            0x60, ##   00 
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '213' => {    # 'Õ'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x60, ##   00 
            0xA0, ##  0 0 
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '214' => {    # 'Ö'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x60, ##   00 
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '215' => {    # '×'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x20, ##    0
            0xA0, ##  0 0
            0x40, ##   0 
            0xA0, ##  0 0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '216' => {    # 'Ø'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0x90, ##  0  0
            0xB0, ##  0 00
            0xD0, ##  00 0
            0xD0, ##  00 0
            0x90, ##  0  0
            0xE0, ##  000 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '217' => {    # 'Ù'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x40, ##   0  
            0x20, ##    0 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '218' => {    # 'Ú'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x20, ##    0 
            0x40, ##   0  
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '219' => {    # 'Û'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##      
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '220' => {    # 'Ü'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '221' => {    # 'Ý'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x10, ##     0 
            0x20, ##    0  
            0x88, ##  0   0
            0x50, ##   0 0 
            0x50, ##   0 0 
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0x20, ##    0  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '222' => {    # 'Þ'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0   
            0x80, ##  0   
            0xF0, ##  0000
            0x90, ##  0  0
            0x90, ##  0  0
            0xF0, ##  0000
            0x80, ##  0   
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '223' => {    # 'ß'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000 
            0xA0, ##  0 0 
            0xC0, ##  00  
            0xC0, ##  00  
            0xB0, ##  0 00
            0x90, ##  0  0
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '224' => {    # 'à'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x40, ##   0  
            0x20, ##    0 
            0xE0, ##  000 
            0x10, ##     0
            0xF0, ##  0000
            0x90, ##  0  0
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '225' => {    # 'á'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x20, ##    0 
            0x00, ##      
            0xE0, ##  000 
            0x10, ##     0
            0xF0, ##  0000
            0x90, ##  0  0
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '226' => {    # 'â'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00 
            0x00, ##      
            0xE0, ##  000 
            0x10, ##     0
            0xF0, ##  0000
            0x90, ##  0  0
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '227' => {    # 'ã'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00 
            0xA0, ##  0 0 
            0xE0, ##  000 
            0x10, ##     0
            0xF0, ##  0000
            0x90, ##  0  0
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '228' => {    # 'ä'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00 
            0x00, ##      
            0xE0, ##  000 
            0x10, ##     0
            0xF0, ##  0000
            0x90, ##  0  0
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '229' => {    # 'å'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x60, ##   00 
            0x60, ##   00 
            0x60, ##   00 
            0xE0, ##  000 
            0x10, ##     0
            0xF0, ##  0000
            0x90, ##  0  0
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '230' => {    # 'æ'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xD8, ##  00 00
            0x28, ##    0 0
            0xF8, ##  00000
            0xA0, ##  0 0  
            0xD8, ##  00 00
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '231' => {    # 'ç'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0x80, ##  0   
            0x80, ##  0   
            0x80, ##  0   
            0x60, ##   00 
            0x20, ##    0 
            0x60, ##   00 
        ], 
    }, 
    '232' => {    # 'è'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x40, ##   0  
            0x40, ##   0  
            0x20, ##    0 
            0x60, ##   00 
            0x90, ##  0  0
            0xF0, ##  0000
            0x80, ##  0   
            0x70, ##   000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '233' => {    # 'é'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x20, ##    0 
            0x20, ##    0 
            0x00, ##      
            0x60, ##   00 
            0x90, ##  0  0
            0xF0, ##  0000
            0x80, ##  0   
            0x70, ##   000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '234' => {    # 'ê'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##      
            0x60, ##   00 
            0x00, ##      
            0x60, ##   00 
            0x90, ##  0  0
            0xF0, ##  0000
            0x80, ##  0   
            0x70, ##   000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '235' => {    # 'ë'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00 
            0x00, ##      
            0x60, ##   00 
            0x90, ##  0  0
            0xF0, ##  0000
            0x80, ##  0   
            0x70, ##   000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '236' => {    # 'ì'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0  
            0x40, ##   0 
            0xC0, ##  00 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '237' => {    # 'í'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x40, ##   0 
            0x00, ##     
            0xC0, ##  00 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '238' => {    # 'î'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x40, ##   0 
            0xA0, ##  0 0
            0xC0, ##  00 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '239' => {    # 'ï'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xA0, ##  0 0
            0x00, ##     
            0xC0, ##  00 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '240' => {    # 'ð'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00 
            0x20, ##    0 
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '241' => {    # 'ñ'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00 
            0xC0, ##  00 
            0xE0, ##  000
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '242' => {    # 'ò'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x40, ##   0  
            0x40, ##   0  
            0x20, ##    0 
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '243' => {    # 'ó'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x20, ##    0 
            0x20, ##    0 
            0x40, ##   0  
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '244' => {    # 'ô'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##      
            0x60, ##   00 
            0x00, ##      
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '245' => {    # 'õ'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00 
            0x00, ##      
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '246' => {    # 'ö'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x60, ##   00 
            0x00, ##      
            0x60, ##   00 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0x60, ##   00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '247' => {    # '÷'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x20, ##    0  
            0x00, ##       
            0xF8, ##  00000
            0x20, ##    0  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '248' => {    # 'ø'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0x90, ##  0  0
            0xF0, ##  0000
            0x90, ##  0  0
            0xE0, ##  000 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '249' => {    # 'ù'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0  
            0x40, ##   0 
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '250' => {    # 'ú'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x40, ##   0 
            0x40, ##   0 
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '251' => {    # 'û'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x40, ##   0 
            0x00, ##     
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '252' => {    # 'ü'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xC0, ##  00 
            0x00, ##     
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '253' => {    # 'ý'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x20, ##    0  
            0x00, ##       
            0x90, ##  0  0 
            0x50, ##   0 0 
            0x50, ##   0 0 
            0x60, ##   00  
            0x20, ##    0  
            0x20, ##    0  
            0x40, ##   0   
        ], 
    }, 
    '254' => {    # 'þ'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x80, ##  0   
            0x80, ##  0   
            0xE0, ##  000 
            0x90, ##  0  0
            0x90, ##  0  0
            0x90, ##  0  0
            0xE0, ##  000 
            0x80, ##  0   
            0x80, ##  0   
        ], 
    }, 
    '255' => {    # 'ÿ'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x50, ##   0 0 
            0x00, ##       
            0x90, ##  0  0 
            0x50, ##   0 0 
            0x50, ##   0 0 
            0x60, ##   00  
            0x20, ##    0  
            0x20, ##    0  
            0x40, ##   0   
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { },  # A
    '66' => { },  # B
    '67' => { },  # C
    '68' => { },  # D
    '69' => { },  # E
    '70' => { },  # F
    '71' => { },  # G
    '72' => { },  # H
    '73' => { },  # I
    '74' => { },  # J
    '75' => { },  # K
    '76' => { },  # L
    '77' => { },  # M
    '78' => { },  # N
    '79' => { },  # O
    '80' => { },  # P
    '81' => { },  # Q
    '82' => { },  # R
    '83' => { },  # S
    '84' => { },  # T
    '85' => { },  # U
    '86' => { },  # V
    '87' => { },  # W
    '88' => { },  # X
    '89' => { },  # Y
    '90' => { },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { },  # e
    '102' => { },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { },  # v
    '119' => { },  # w
    '120' => { },  # x
    '121' => { },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '160' => { },  #  
    '161' => { },  # ¡
    '162' => { },  # ¢
    '163' => { },  # £
    '164' => { },  # ¤
    '165' => { },  # ¥
    '166' => { },  # ¦
    '167' => { },  # §
    '168' => { },  # ¨
    '169' => { },  # ©
    '170' => { },  # ª
    '171' => { },  # «
    '172' => { },  # ¬
    '173' => { },  # ­
    '174' => { },  # ®
    '175' => { },  # ¯
    '176' => { },  # °
    '177' => { },  # ±
    '178' => { },  # ²
    '179' => { },  # ³
    '180' => { },  # ´
    '181' => { },  # µ
    '182' => { },  # ¶
    '183' => { },  # ·
    '184' => { },  # ¸
    '185' => { },  # ¹
    '186' => { },  # º
    '187' => { },  # »
    '188' => { },  # ¼
    '189' => { },  # ½
    '190' => { },  # ¾
    '191' => { },  # ¿
    '192' => { },  # À
    '193' => { },  # Á
    '194' => { },  # Â
    '195' => { },  # Ã
    '196' => { },  # Ä
    '197' => { },  # Å
    '198' => { },  # Æ
    '199' => { },  # Ç
    '200' => { },  # È
    '201' => { },  # É
    '202' => { },  # Ê
    '203' => { },  # Ë
    '204' => { },  # Ì
    '205' => { },  # Í
    '206' => { },  # Î
    '207' => { },  # Ï
    '208' => { },  # Ð
    '209' => { },  # Ñ
    '210' => { },  # Ò
    '211' => { },  # Ó
    '212' => { },  # Ô
    '213' => { },  # Õ
    '214' => { },  # Ö
    '215' => { },  # ×
    '216' => { },  # Ø
    '217' => { },  # Ù
    '218' => { },  # Ú
    '219' => { },  # Û
    '220' => { },  # Ü
    '221' => { },  # Ý
    '222' => { },  # Þ
    '223' => { },  # ß
    '224' => { },  # à
    '225' => { },  # á
    '226' => { },  # â
    '227' => { },  # ã
    '228' => { },  # ä
    '229' => { },  # å
    '230' => { },  # æ
    '231' => { },  # ç
    '232' => { },  # è
    '233' => { },  # é
    '234' => { },  # ê
    '235' => { },  # ë
    '236' => { },  # ì
    '237' => { },  # í
    '238' => { },  # î
    '239' => { },  # ï
    '240' => { },  # ð
    '241' => { },  # ñ
    '242' => { },  # ò
    '243' => { },  # ó
    '244' => { },  # ô
    '245' => { },  # õ
    '246' => { },  # ö
    '247' => { },  # ÷
    '248' => { },  # ø
    '249' => { },  # ù
    '250' => { },  # ú
    '251' => { },  # û
    '252' => { },  # ü
    '253' => { },  # ý
    '254' => { },  # þ
    '255' => { },  # ÿ
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
