/*
 * @(#)TestClassCreatorUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.junit.v1.parser;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.framework.AssertionFailedError;

import java.io.IOException;
import java.lang.reflect.Method;


/**
 * Tests the TestClassCreator class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     November 4, 2002
 * @version   $Date: 2003/02/10 22:52:24 $
 */
public class TestClassCreatorUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = TestClassCreatorUTest.class;
    
    public TestClassCreatorUTest( String name )
    {
        super( name );
    }

    


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testConstructor1()
    {
        try
        {
            new TestClassCreator( null );
        }
        catch (IllegalArgumentException e)
        {
            // test exception?
        }
    }
    
    
    public void testConstructor2()
    {
        new TestClassCreator( new JUnitOrigCreator() );
    }
    
    
    public void testWarnings1()
    {
        TestClassCreator tcc = new TestClassCreator( new JUnitOrigCreator() );
        
        String s[] = tcc.getWarnings();
        
        assertNotNull( "Returned null warnings array.",
            s );
        assertEquals( "Returned warnings array with elements.",
            0,
            s.length );
    }
    
    
    public void testWarnings2()
    {
        TestClassCreator tcc = new TestClassCreator( new JUnitOrigCreator() );
        
        tcc.warning( "a" );
        String s[] = tcc.getWarnings();
        
        assertNotNull( "Returned null warnings array.",
            s );
        assertEquals( "Returned warnings array with incorrect element count.",
            1,
            s.length );
        assertEquals( "Did not return warnings array with correct entry.",
            "a",
            s[0] );
    }
    
    
    public void testWarnings3()
    {
        TestClassCreator tcc = new TestClassCreator( new JUnitOrigCreator() );
        
        tcc.warning( "a" );
        tcc.warning( "b" );
        String s[] = tcc.getWarnings();
        
        assertNotNull( "Returned null warnings array.",
            s );
        assertEquals( "Returned warnings array with incorrect element count.",
            2,
            s.length );
        assertEquals( "Did not return warnings array with correct entry.",
            "a",
            s[0] );
        assertEquals( "Did not return warnings array with correct entry.",
            "b",
            s[1] );
    }
    
    
    public void testClearWarnings1()
    {
        TestClassCreator tcc = new TestClassCreator( new JUnitOrigCreator() );
        
        tcc.clearWarnings();
        String s[] = tcc.getWarnings();
        
        assertNotNull( "Returned null warnings array.",
            s );
        assertEquals( "Returned warnings array with elements.",
            0,
            s.length );
    }
    
    
    public void testClearWarnings2()
    {
        TestClassCreator tcc = new TestClassCreator( new JUnitOrigCreator() );
        
        tcc.warning( "a" );
        tcc.clearWarnings();
        String s[] = tcc.getWarnings();
        
        assertNotNull( "Returned null warnings array.",
            s );
        assertEquals( "Returned warnings array with elements.",
            0,
            s.length );
    }
    
    
    public void testClearWarnings3()
    {
        TestClassCreator tcc = new TestClassCreator( new JUnitOrigCreator() );
        
        tcc.warning( "a" );
        tcc.warning( "b" );
        tcc.clearWarnings();
        String s[] = tcc.getWarnings();
        
        assertNotNull( "Returned null warnings array.",
            s );
        assertEquals( "Returned warnings array with elements.",
            0,
            s.length );
    }
    
    
    public void testCreateWarningTests1()
    {
        TestClassCreator tcc = new TestClassCreator( new JUnitOrigCreator() );
        
        tcc.warning( "a" );
        tcc.warning( "b" );
        Test t[] = tcc.createWarningTests( new TestClassParser( THIS_CLASS ) );
        
        assertNotNull( "Returned null warning test list.",
            t );
        assertEquals(
            "Returned warnings test list with incorrect element count.",
            2,
            t.length );
        // need to test failures!!!
        
        
        
        // warnings should not have been cleared
        String s[] = tcc.getWarnings();
        
        assertNotNull( "Returned null warnings array.",
            s );
        assertEquals( "Returned warnings array with incorrect element count.",
            2,
            s.length );
        assertEquals( "Did not return warnings array with correct entry.",
            "a",
            s[0] );
        assertEquals( "Did not return warnings array with correct entry.",
            "b",
            s[1] );
    }
    
    
    
/*    
    
    
    public static class TesterNoTestMethods implements Test
    {
        public int countTestCases() { return 0; }
        public void run( junit.framework.TestResult tr ) {}
    }
    
    
    public static class TesterOneTestMethod implements Test
    {
        public int countTestCases() { return 0; }
        public void run( junit.framework.TestResult tr ) {}
        
        public void testMyTest() {}
    }
    
    
    private class StaticClass {}
    public class InnerClass {}
    
    public void testGetTestMethods1()
    {
        TestClassParser tcp = new TestClassParser( String.class );
        Method m[] = tcp.getTestMethods();
        assertNotNull(
            "Must never return null.",
            m );
        assertEquals(
            "String should have no test methods.",
            0,
            m.length );
        assertTrue(
            "Must never return the same array, but rather a copy.",
            m != tcp.getTestMethods() );
    }
    
    public void testGetTestMethods2()
    {
        TestClassParser tcp = new TestClassParser( Runnable.class );
        Method m[] = tcp.getTestMethods();
        assertNotNull(
            "Must never return null.",
            m );
        assertEquals(
            "Runnable should have no test methods.",
            0,
            m.length );
        assertTrue(
            "Must never return the same array, but rather a copy.",
            m != tcp.getTestMethods() );
    }
    
    public void testGetTestMethods3()
    {
        TestClassParser tcp = new TestClassParser( StaticClass.class );
        Method m[] = tcp.getTestMethods();
        assertNotNull(
            "Must never return null.",
            m );
        assertEquals(
            "Runnable should have no test methods.",
            0,
            m.length );
        assertTrue(
            "Must never return the same array, but rather a copy.",
            m != tcp.getTestMethods() );
    }
    
    public void testGetTestMethods4()
    {
        TestClassParser tcp = new TestClassParser( InnerClass.class );
        Method m[] = tcp.getTestMethods();
        assertNotNull(
            "Must never return null.",
            m );
        assertEquals(
            "Runnable should have no test methods.",
            0,
            m.length );
        assertTrue(
            "Must never return the same array, but rather a copy.",
            m != tcp.getTestMethods() );
    }
    
    public void testGetTestMethods5()
    {
        TestClassParser tcp = new TestClassParser( TesterNoTestMethods.class );
        Method m[] = tcp.getTestMethods();
        assertNotNull(
            "Must never return null.",
            m );
        assertEquals(
            "Runnable should have no test methods.",
            0,
            m.length );
        assertTrue(
            "Must never return the same array, but rather a copy.",
            m != tcp.getTestMethods() );
    }
    
    public void testGetTestMethods6()
    {
        TestClassParser tcp = new TestClassParser( TesterOneTestMethod.class );
        Method m[] = tcp.getTestMethods();
        assertNotNull(
            "Must never return null.",
            m );
        assertEquals(
            "Runnable should have one test method.",
            1,
            m.length );
        assertTrue(
            "Must never return the same array, but rather a copy.",
            m != tcp.getTestMethods() );
    }
    
    
    */
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

