with GNATCOLL.Projects; use GNATCOLL.Projects;
with GNATCOLL.VFS;
with GNAT.Strings; use GNAT.Strings;
with Ada.Text_IO;
with GNATCOLL.Traces; use GNATCOLL.Traces;

procedure Main is
   Self : Project_Environment_Access;
   Tree : Project_Tree;
   Attr : constant Attribute_Pkg_List :=
     Build ("Builder", "Global_Compilation_Switches");
begin
--     Parse_Config_File;
   Initialize (Self);
   Tree.Load
     (GNATCOLL.VFS.Create ("autopilot2.gpr"),
      Self);
   if Has_Attribute (Tree.Root_Project, Attr, "Ada") then
      Ada.Text_IO.Put_Line("Has_Attribute is True for nonexistent Index");
   end if;
   if not Has_Attribute (Tree.Root_Project, Attr, "Ololo") then
      Ada.Text_IO.Put_Line("Has_Attribute is False for existing Index");
   end if;
end Main;
