// LIBTYPEDEF.H : some typedefs + other settings here...

// Copyright (C) 1998 Tommi Hassinen.

// This package is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this package; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

/*################################################################################################*/

#ifndef LIBTYPEDEF_H
#define LIBTYPEDEF_H

#include <math.h>

/*################################################################################################*/

// comment this out if you have no GL/gl.h available...

#define HAVE_GL_H	// 2008-07-31 ; also with mingw comment this out???

// added by Robert Williams for Compaq cxx, alpha 11/28/01

#define __USE_STD_IOSTREAM

// the value for M_PI is sometimes needed for Win32 platform...

#ifdef WIN32
#ifndef M_PI
#define M_PI 3.141592654
#endif	// M_PI
#endif	// WIN32

class engine;	// engine.h ; this is for ValueFunction().

#include <iostream>
using namespace std;

/*################################################################################################*/

typedef int i32s;
typedef unsigned int i32u;

typedef double f64;

/*################################################################################################*/

#ifdef HAVE_GL_H

#ifdef WIN32
#include <windows.h>	// need to have this before the GL stuff...
#endif	// WIN32

#include <GL/gl.h>

typedef GLint iGLs;
typedef GLuint iGLu;

typedef GLfloat fGL;
typedef GLfloat * ref_fGL;

#else	// HAVE_GL_H

typedef int iGLs;
typedef unsigned int iGLu;

typedef float fGL;
typedef float * ref_fGL;

#endif	// HAVE_GL_H

/*################################################################################################*/

// these are actually used at the ghemical application side, not here...

typedef fGL ValueFunction(engine *, fGL *, fGL *);
typedef void ColorFunction(fGL, fGL, fGL *);

/*################################################################################################*/

#endif	// LIBTYPEDEF_H

// eof
