/*
 * Codepage definitions for libfsapfs
 *
 * Copyright (C) 2018-2020, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBFSAPFS_CODEPAGE_H )
#define _LIBFSAPFS_CODEPAGE_H

#include <libfsapfs/types.h>

#if defined( __cplusplus )
extern "C" {
#endif

/* The codepage definitions
 */
enum LIBFSAPFS_CODEPAGES
{
	LIBFSAPFS_CODEPAGE_ASCII			= 20127,

	LIBFSAPFS_CODEPAGE_ISO_8859_1			= 28591,
	LIBFSAPFS_CODEPAGE_ISO_8859_2			= 28592,
	LIBFSAPFS_CODEPAGE_ISO_8859_3			= 28593,
	LIBFSAPFS_CODEPAGE_ISO_8859_4			= 28594,
	LIBFSAPFS_CODEPAGE_ISO_8859_5			= 28595,
	LIBFSAPFS_CODEPAGE_ISO_8859_6			= 28596,
	LIBFSAPFS_CODEPAGE_ISO_8859_7			= 28597,
	LIBFSAPFS_CODEPAGE_ISO_8859_8			= 28598,
	LIBFSAPFS_CODEPAGE_ISO_8859_9			= 28599,
	LIBFSAPFS_CODEPAGE_ISO_8859_10			= 28600,
	LIBFSAPFS_CODEPAGE_ISO_8859_11			= 28601,
	LIBFSAPFS_CODEPAGE_ISO_8859_13			= 28603,
	LIBFSAPFS_CODEPAGE_ISO_8859_14			= 28604,
	LIBFSAPFS_CODEPAGE_ISO_8859_15			= 28605,
	LIBFSAPFS_CODEPAGE_ISO_8859_16			= 28606,

	LIBFSAPFS_CODEPAGE_KOI8_R			= 20866,
	LIBFSAPFS_CODEPAGE_KOI8_U			= 21866,

	LIBFSAPFS_CODEPAGE_WINDOWS_874			= 874,
	LIBFSAPFS_CODEPAGE_WINDOWS_932			= 932,
	LIBFSAPFS_CODEPAGE_WINDOWS_936			= 936,
	LIBFSAPFS_CODEPAGE_WINDOWS_949			= 949,
	LIBFSAPFS_CODEPAGE_WINDOWS_950			= 950,
	LIBFSAPFS_CODEPAGE_WINDOWS_1250			= 1250,
	LIBFSAPFS_CODEPAGE_WINDOWS_1251			= 1251,
	LIBFSAPFS_CODEPAGE_WINDOWS_1252			= 1252,
	LIBFSAPFS_CODEPAGE_WINDOWS_1253			= 1253,
	LIBFSAPFS_CODEPAGE_WINDOWS_1254			= 1254,
	LIBFSAPFS_CODEPAGE_WINDOWS_1255			= 1255,
	LIBFSAPFS_CODEPAGE_WINDOWS_1256			= 1256,
	LIBFSAPFS_CODEPAGE_WINDOWS_1257			= 1257,
	LIBFSAPFS_CODEPAGE_WINDOWS_1258			= 1258
};

#define LIBFSAPFS_CODEPAGE_US_ASCII			LIBFSAPFS_CODEPAGE_ASCII

#define LIBFSAPFS_CODEPAGE_ISO_WESTERN_EUROPEAN		LIBFSAPFS_CODEPAGE_ISO_8859_1
#define LIBFSAPFS_CODEPAGE_ISO_CENTRAL_EUROPEAN		LIBFSAPFS_CODEPAGE_ISO_8859_2
#define LIBFSAPFS_CODEPAGE_ISO_SOUTH_EUROPEAN		LIBFSAPFS_CODEPAGE_ISO_8859_3
#define LIBFSAPFS_CODEPAGE_ISO_NORTH_EUROPEAN		LIBFSAPFS_CODEPAGE_ISO_8859_4
#define LIBFSAPFS_CODEPAGE_ISO_CYRILLIC			LIBFSAPFS_CODEPAGE_ISO_8859_5
#define LIBFSAPFS_CODEPAGE_ISO_ARABIC			LIBFSAPFS_CODEPAGE_ISO_8859_6
#define LIBFSAPFS_CODEPAGE_ISO_GREEK			LIBFSAPFS_CODEPAGE_ISO_8859_7
#define LIBFSAPFS_CODEPAGE_ISO_HEBREW			LIBFSAPFS_CODEPAGE_ISO_8859_8
#define LIBFSAPFS_CODEPAGE_ISO_TURKISH			LIBFSAPFS_CODEPAGE_ISO_8859_9
#define LIBFSAPFS_CODEPAGE_ISO_NORDIC			LIBFSAPFS_CODEPAGE_ISO_8859_10
#define LIBFSAPFS_CODEPAGE_ISO_THAI			LIBFSAPFS_CODEPAGE_ISO_8859_11
#define LIBFSAPFS_CODEPAGE_ISO_BALTIC			LIBFSAPFS_CODEPAGE_ISO_8859_13
#define LIBFSAPFS_CODEPAGE_ISO_CELTIC			LIBFSAPFS_CODEPAGE_ISO_8859_14

#define LIBFSAPFS_CODEPAGE_ISO_LATIN_1			LIBFSAPFS_CODEPAGE_ISO_8859_1
#define LIBFSAPFS_CODEPAGE_ISO_LATIN_2			LIBFSAPFS_CODEPAGE_ISO_8859_2
#define LIBFSAPFS_CODEPAGE_ISO_LATIN_3			LIBFSAPFS_CODEPAGE_ISO_8859_3
#define LIBFSAPFS_CODEPAGE_ISO_LATIN_4			LIBFSAPFS_CODEPAGE_ISO_8859_4
#define LIBFSAPFS_CODEPAGE_ISO_LATIN_5			LIBFSAPFS_CODEPAGE_ISO_8859_9
#define LIBFSAPFS_CODEPAGE_ISO_LATIN_6			LIBFSAPFS_CODEPAGE_ISO_8859_10
#define LIBFSAPFS_CODEPAGE_ISO_LATIN_7			LIBFSAPFS_CODEPAGE_ISO_8859_13
#define LIBFSAPFS_CODEPAGE_ISO_LATIN_8			LIBFSAPFS_CODEPAGE_ISO_8859_14
#define LIBFSAPFS_CODEPAGE_ISO_LATIN_9			LIBFSAPFS_CODEPAGE_ISO_8859_15
#define LIBFSAPFS_CODEPAGE_ISO_LATIN_10			LIBFSAPFS_CODEPAGE_ISO_8859_16

#define LIBFSAPFS_CODEPAGE_KOI8_RUSSIAN			LIBFSAPFS_CODEPAGE_KOI8_R
#define LIBFSAPFS_CODEPAGE_KOI8_UKRAINIAN		LIBFSAPFS_CODEPAGE_KOI8_U

#define LIBFSAPFS_CODEPAGE_WINDOWS_THAI			LIBFSAPFS_CODEPAGE_WINDOWS_874
#define LIBFSAPFS_CODEPAGE_WINDOWS_JAPANESE		LIBFSAPFS_CODEPAGE_WINDOWS_932
#define LIBFSAPFS_CODEPAGE_WINDOWS_CHINESE_SIMPLIFIED	LIBFSAPFS_CODEPAGE_WINDOWS_936
#define LIBFSAPFS_CODEPAGE_WINDOWS_KOREAN		LIBFSAPFS_CODEPAGE_WINDOWS_949
#define LIBFSAPFS_CODEPAGE_WINDOWS_CHINESE_TRADITIONAL	LIBFSAPFS_CODEPAGE_WINDOWS_950
#define LIBFSAPFS_CODEPAGE_WINDOWS_CENTRAL_EUROPEAN	LIBFSAPFS_CODEPAGE_WINDOWS_1250
#define LIBFSAPFS_CODEPAGE_WINDOWS_CYRILLIC		LIBFSAPFS_CODEPAGE_WINDOWS_1251
#define LIBFSAPFS_CODEPAGE_WINDOWS_WESTERN_EUROPEAN	LIBFSAPFS_CODEPAGE_WINDOWS_1252
#define LIBFSAPFS_CODEPAGE_WINDOWS_GREEK		LIBFSAPFS_CODEPAGE_WINDOWS_1253
#define LIBFSAPFS_CODEPAGE_WINDOWS_TURKISH		LIBFSAPFS_CODEPAGE_WINDOWS_1254
#define LIBFSAPFS_CODEPAGE_WINDOWS_HEBREW		LIBFSAPFS_CODEPAGE_WINDOWS_1255
#define LIBFSAPFS_CODEPAGE_WINDOWS_ARABIC		LIBFSAPFS_CODEPAGE_WINDOWS_1256
#define LIBFSAPFS_CODEPAGE_WINDOWS_BALTIC		LIBFSAPFS_CODEPAGE_WINDOWS_1257
#define LIBFSAPFS_CODEPAGE_WINDOWS_VIETNAMESE		LIBFSAPFS_CODEPAGE_WINDOWS_1258

#if defined( __cplusplus )
}
#endif

#endif /* !defined( _LIBFSAPFS_CODEPAGE_H ) */

