/* test-vfs-bookmarks-gtk.c generated by valac 0.10.4, the Vala compiler
 * generated from test-vfs-bookmarks-gtk.vala, do not modify */

/*
 * Desktop Agnostic Library: Test for the desktop entry implementations.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/vfs.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))



void print_bookmarks (DesktopAgnosticVFSGtkBookmarks* parser);
gint _vala_main (char** args, int args_length1);
static void _print_bookmarks_desktop_agnostic_vfs_gtk_bookmarks_changed (DesktopAgnosticVFSGtkBookmarks* _sender, gpointer self);



void print_bookmarks (DesktopAgnosticVFSGtkBookmarks* parser) {
	g_return_if_fail (parser != NULL);
	if (desktop_agnostic_vfs_gtk_bookmarks_get_bookmarks (parser) == NULL) {
		g_message ("test-vfs-bookmarks-gtk.vala:31: No bookmarks.");
	} else {
		g_message ("test-vfs-bookmarks-gtk.vala:35: Bookmarks:");
		{
			GSList* b_collection;
			GSList* b_it;
			b_collection = desktop_agnostic_vfs_gtk_bookmarks_get_bookmarks (parser);
			for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
				DesktopAgnosticVFSBookmark* b;
				b = (DesktopAgnosticVFSBookmark*) b_it->data;
				{
					char* path;
					path = desktop_agnostic_vfs_file_get_path (desktop_agnostic_vfs_bookmark_get_file (b));
					if (path == NULL) {
						char* _tmp0_;
						g_message ("test-vfs-bookmarks-gtk.vala:41: * %s (%s)", _tmp0_ = desktop_agnostic_vfs_file_get_uri (desktop_agnostic_vfs_bookmark_get_file (b)), desktop_agnostic_vfs_bookmark_get_alias (b));
						_g_free0 (_tmp0_);
					} else {
						g_message ("test-vfs-bookmarks-gtk.vala:45: * %s (%s)", path, desktop_agnostic_vfs_bookmark_get_alias (b));
					}
					_g_free0 (path);
				}
			}
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _print_bookmarks_desktop_agnostic_vfs_gtk_bookmarks_changed (DesktopAgnosticVFSGtkBookmarks* _sender, gpointer self) {
	print_bookmarks (_sender);
}


gint _vala_main (char** args, int args_length1) {
	gint result = 0;
	DesktopAgnosticVFSImplementation* vfs;
	DesktopAgnosticVFSGtkBookmarks* parser;
	DesktopAgnosticVFSImplementation* _tmp0_;
	DesktopAgnosticVFSImplementation* _tmp1_;
	GMainLoop* ml;
	DesktopAgnosticVFSGtkBookmarks* _tmp4_;
	GError * _inner_error_ = NULL;
	vfs = NULL;
	parser = NULL;
	_tmp0_ = desktop_agnostic_vfs_get_default (&_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		_g_object_unref0 (vfs);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	vfs = (_tmp1_ = _g_object_ref0 (_tmp0_), _g_object_unref0 (vfs), _tmp1_);
	desktop_agnostic_vfs_implementation_init (vfs);
	if (args_length1 < 2) {
		DesktopAgnosticVFSGtkBookmarks* _tmp2_;
		parser = (_tmp2_ = desktop_agnostic_vfs_gtk_bookmarks_new (NULL, TRUE), _g_object_unref0 (parser), _tmp2_);
	} else {
		{
			DesktopAgnosticVFSFile* file;
			DesktopAgnosticVFSGtkBookmarks* _tmp3_;
			file = desktop_agnostic_vfs_file_new_for_path (args[1], &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			parser = (_tmp3_ = desktop_agnostic_vfs_gtk_bookmarks_new (file, TRUE), _g_object_unref0 (parser), _tmp3_);
			_g_object_unref0 (file);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("test-vfs-bookmarks-gtk.vala:73: Error: %s", err->message);
				result = 1;
				_g_error_free0 (err);
				_g_object_unref0 (parser);
				_g_object_unref0 (vfs);
				return result;
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			_g_object_unref0 (vfs);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	print_bookmarks (parser);
	g_signal_connect (parser, "changed", (GCallback) _print_bookmarks_desktop_agnostic_vfs_gtk_bookmarks_changed, NULL);
	ml = g_main_loop_new (NULL, FALSE);
	g_main_loop_run (ml);
	parser = (_tmp4_ = NULL, _g_object_unref0 (parser), _tmp4_);
	desktop_agnostic_vfs_implementation_shutdown (vfs);
	result = 0;
	_g_main_loop_unref0 (ml);
	_g_object_unref0 (parser);
	_g_object_unref0 (vfs);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}




