package Data::Password::zxcvbn::RankedDictionaries;
use strict;
use warnings;
our $VERSION = '1.0.6';

=head1 NAME

Data::Password::zxcvbn::RankedDictionaries - ranked dictionaries for common words

=head1 DESCRIPTION

This is a data file used by L<<
C<Data::Password::zxcvbn::Match::Dictionary> >>, and is generated by
the L<<
C<build-ranked-dictionaries>|https://bitbucket.org/broadbean/p5-data-password-zxcvbn/src/master/maint/build-ranked-dictionaries
>> program when building the distribution.

=cut

our %ranked_dictionaries = (
  english_wikipedia => {
                         "'aliabad"                => 26996,
                         "'best"                   => 9381,
                         "'black"                  => 17310,
                         "'blue"                   => 26339,
                         "'bout"                   => 25881,
                         "'cause"                  => 20289,
                         "'first"                  => 21522,
                         "'free"                   => 23172,
                         "'golden"                 => 24135,
                         "'good"                   => 16773,
                         "'great"                  => 19608,
                         "'green"                  => 23731,
                         "'high"                   => 22985,
                         "'home"                   => 25650,
                         "'king"                   => 22765,
                         "'little"                 => 19663,
                         "'live"                   => 25805,
                         "'love"                   => 23073,
                         "'most"                   => 23244,
                         "'national"               => 23364,
                         "'ndrangheta"             => 27426,
                         "'olya"                   => 13106,
                         "'open"                   => 27099,
                         "'outstanding"            => 29889,
                         "'people"                 => 28368,
                         "'real"                   => 22497,
                         "'right"                  => 29398,
                         "'round"                  => 21361,
                         "'special"                => 25580,
                         "'that"                   => 17910,
                         "'the"                    => 2543,
                         "'there"                  => 21951,
                         "'this"                   => 15133,
                         "'three"                  => 29786,
                         "'well"                   => 24039,
                         "'what"                   => 13839,
                         "'when"                   => 25536,
                         "'white"                  => 19601,
                         "'with"                   => 29618,
                         "'world"                  => 26581,
                         "1,000th"                 => 27351,
                         "1000m"                   => 29078,
                         "100th"                   => 6244,
                         "101st"                   => 10918,
                         "102nd"                   => 18954,
                         "103rd"                   => 18029,
                         "104th"                   => 16735,
                         "105th"                   => 18937,
                         "106th"                   => 18824,
                         "107th"                   => 18536,
                         "1080p"                   => 24359,
                         "108th"                   => 18422,
                         "109th"                   => 18235,
                         "10deg"                   => 28222,
                         "10th"                    => 2118,
                         "110th"                   => 15756,
                         "111th"                   => 16219,
                         "112th"                   => 17378,
                         "113th"                   => 14336,
                         "114th"                   => 21357,
                         "115th"                   => 21600,
                         "116th"                   => 18125,
                         "117th"                   => 21295,
                         "118th"                   => 24152,
                         "119th"                   => 24726,
                         "11th"                    => 2149,
                         "120th"                   => 22064,
                         "121st"                   => 23614,
                         "122nd"                   => 29721,
                         "124th"                   => 25867,
                         "125cc"                   => 21740,
                         "125th"                   => 14066,
                         "126th"                   => 24011,
                         "127th"                   => 25873,
                         "128th"                   => 26675,
                         "129th"                   => 28641,
                         "12th"                    => 1939,
                         "130th"                   => 26500,
                         "131st"                   => 26829,
                         "135th"                   => 25317,
                         "137th"                   => 27844,
                         "138th"                   => 27898,
                         "13th"                    => 2007,
                         "140th"                   => 27388,
                         "141st"                   => 28438,
                         "142nd"                   => 29988,
                         "145th"                   => 29058,
                         "148th"                   => 27251,
                         "149th"                   => 28837,
                         "14th"                    => 2108,
                         "1500m"                   => 21455,
                         "1500s"                   => 26442,
                         "150th"                   => 11620,
                         "1530s"                   => 28032,
                         "153rd"                   => 27130,
                         "1540s"                   => 29603,
                         "155th"                   => 29599,
                         "157th"                   => 26823,
                         "1580s"                   => 28407,
                         "1590s"                   => 28155,
                         "15th"                    => 2032,
                         "1600s"                   => 18170,
                         "160th"                   => 25527,
                         "161st"                   => 27159,
                         "1620s"                   => 24615,
                         "1630s"                   => 20123,
                         "1640s"                   => 21857,
                         "1650s"                   => 22347,
                         "1660s"                   => 22789,
                         "1670s"                   => 25582,
                         "1680s"                   => 24330,
                         "1690s"                   => 25144,
                         "16th"                    => 1793,
                         "1700s"                   => 15143,
                         "1720s"                   => 22073,
                         "1730s"                   => 19857,
                         "173rd"                   => 26801,
                         "1740s"                   => 19576,
                         "1750s"                   => 18387,
                         "175th"                   => 26104,
                         "1760s"                   => 16364,
                         "1770s"                   => 15512,
                         "1780s"                   => 14727,
                         "1790s"                   => 13210,
                         "179th"                   => 29414,
                         "17th"                    => 1701,
                         "1800s"                   => 7128,
                         "180deg"                  => 17817,
                         "180th"                   => 25053,
                         "181st"                   => 28394,
                         "1820s"                   => 8955,
                         "1830s"                   => 6838,
                         "1840s"                   => 6569,
                         "1850s"                   => 5650,
                         "1860s"                   => 5536,
                         "1870s"                   => 5222,
                         "187th"                   => 29676,
                         "1880s"                   => 4444,
                         "1890s"                   => 4757,
                         "18th"                    => 1416,
                         "1900s"                   => 5577,
                         "1910s"                   => 8799,
                         "1920s"                   => 2045,
                         "1930s"                   => 1646,
                         "1940s"                   => 2407,
                         "1950s"                   => 1273,
                         "1960s"                   => 933,
                         "1970s"                   => 855,
                         "1980s"                   => 820,
                         "1990s"                   => 912,
                         "19th"                    => 793,
                         "1up.com"                 => 24886,
                         "2/1st"                   => 27393,
                         "2000s"                   => 2808,
                         "200th"                   => 13482,
                         "2010s"                   => 9067,
                         "20deg"                   => 29926,
                         "20th"                    => 915,
                         "21st"                    => 2498,
                         "22nd"                    => 5180,
                         "23rd"                    => 5236,
                         "24th"                    => 4981,
                         "250cc"                   => 20774,
                         "250th"                   => 26147,
                         "25th"                    => 4068,
                         "26th"                    => 5533,
                         "27th"                    => 5614,
                         "300th"                   => 18680,
                         "30deg"                   => 22234,
                         "30th"                    => 4946,
                         "360deg"                  => 17764,
                         "36ers"                   => 28146,
                         "400th"                   => 21231,
                         "45deg"                   => 18988,
                         "4kids"                   => 25537,
                         "4x100"                   => 9148,
                         "4x100m"                  => 21899,
                         "4x200"                   => 17074,
                         "4x400"                   => 18443,
                         "500cc"                   => 22550,
                         "500th"                   => 19383,
                         "509th"                   => 27402,
                         "50th"                    => 4866,
                         "60deg"                   => 21802,
                         "76ers"                   => 12014,
                         "90deg"                   => 14423,
                         "`abdu'l"                 => 17563,
                         "a.f.c"                   => 12816,
                         "a.k.a"                   => 7158,
                         "a.m."                    => 4280,
                         "aachen"                  => 9686,
                         "aacsb"                   => 28890,
                         "aagpbl"                  => 22986,
                         "aalto"                   => 19458,
                         "aamir"                   => 20281,
                         "aarau"                   => 28053,
                         "aargau"                  => 20689,
                         "aarhus"                  => 10916,
                         "aarti"                   => 26784,
                         "ababa"                   => 12225,
                         "abacetus"                => 20258,
                         "abacha"                  => 27860,
                         "abalone"                 => 23825,
                         "abandoned"               => 1485,
                         "abandonment"             => 7733,
                         "abandons"                => 14244,
                         "abated"                  => 27597,
                         "abatement"               => 24494,
                         "abbas"                   => 6468,
                         "abbasabad"               => 23257,
                         "abbasi"                  => 21067,
                         "abbasid"                 => 11616,
                         "abbasids"                => 23233,
                         "abbess"                  => 12531,
                         "abbeville"               => 16581,
                         "abbeys"                  => 17709,
                         "abbot"                   => 4645,
                         "abbots"                  => 13562,
                         "abbotsford"              => 15874,
                         "abbottabad"              => 21963,
                         "abbreviated"             => 3998,
                         "abbreviation"            => 6990,
                         "abbreviations"           => 12716,
                         "abdel"                   => 10036,
                         "abdicate"                => 17512,
                         "abdicated"               => 13580,
                         "abdication"              => 12311,
                         "abdomen"                 => 6743,
                         "abdomina"                => 18305,
                         "abducts"                 => 29944,
                         "abdulaziz"               => 14444,
                         "abdullahi"               => 25146,
                         "abdur"                   => 17646,
                         "abdus"                   => 24952,
                         "abelard"                 => 29189,
                         "abelian"                 => 11073,
                         "abellio"                 => 22383,
                         "abenaki"                 => 21327,
                         "abercorn"                => 27440,
                         "abercromby"              => 26314,
                         "aberdare"                => 15971,
                         "aberdeenshire"           => 12027,
                         "abergavenny"             => 20674,
                         "aberrations"             => 22633,
                         "aberystwyth"             => 13200,
                         "abeyance"                => 20772,
                         "abhay"                   => 25669,
                         "abidjan"                 => 18406,
                         "abies"                   => 21411,
                         "abilene"                 => 13249,
                         "abilities"               => 2879,
                         "ability"                 => 1022,
                         "abingdon"                => 12288,
                         "abington"                => 19589,
                         "abitibi"                 => 27092,
                         "abitur"                  => 20814,
                         "abkhaz"                  => 18152,
                         "abkhazia"                => 10384,
                         "abkhazian"               => 23929,
                         "ablation"                => 18879,
                         "ablative"                => 28721,
                         "ablaze"                  => 18405,
                         "ablett"                  => 28517,
                         "abnormalities"           => 9623,
                         "abode"                   => 11760,
                         "abolish"                 => 9707,
                         "abolished"               => 3047,
                         "abolishing"              => 13496,
                         "abolishment"             => 24368,
                         "abolition"               => 5313,
                         "abolitionist"            => 9742,
                         "abolitionists"           => 17025,
                         "aboriginal"              => 3525,
                         "aboriginals"             => 19185,
                         "aborigines"              => 10284,
                         "abortions"               => 11212,
                         "abortive"                => 13671,
                         "abounded"                => 28590,
                         "abounds"                 => 28744,
                         "about.com"               => 16763,
                         "above"                   => 484,
                         "abrahamic"               => 21852,
                         "abramoff"                => 19011,
                         "abramovich"              => 28243,
                         "abrasion"                => 20698,
                         "abrasive"                => 13851,
                         "abridged"                => 13377,
                         "abroad"                  => 2240,
                         "abrogated"               => 24548,
                         "abruptly"                => 6977,
                         "abruzzo"                 => 15891,
                         "abscess"                 => 20292,
                         "absence"                 => 2325,
                         "absent"                  => 4029,
                         "absentia"                => 15389,
                         "absolutism"              => 23939,
                         "absolutist"              => 26318,
                         "absorbed"                => 3556,
                         "absorber"                => 21026,
                         "absorbers"               => 19993,
                         "absorbing"               => 8646,
                         "absorbs"                 => 13169,
                         "absorption"              => 5774,
                         "abstained"               => 17039,
                         "abstaining"              => 25185,
                         "abstention"              => 23732,
                         "abstentions"             => 24999,
                         "abstract"                => 3722,
                         "abstracted"              => 11318,
                         "abstracting"             => 12928,
                         "abstraction"             => 8307,
                         "abstractions"            => 19648,
                         "abstracts"               => 12742,
                         "absurdist"               => 27153,
                         "abteilung"               => 26157,
                         "abu'l"                   => 19834,
                         "abubakar"                => 21006,
                         "abuja"                   => 16411,
                         "abundance"               => 5480,
                         "abundances"              => 27430,
                         "abundant"                => 4630,
                         "abuse"                   => 2442,
                         "abusers"                 => 24444,
                         "abuses"                  => 7182,
                         "abutment"                => 26167,
                         "abutments"               => 18989,
                         "abuts"                   => 24242,
                         "abutting"                => 24116,
                         "abwehr"                  => 21033,
                         "abyss"                   => 9747,
                         "abyssinia"               => 19345,
                         "abyssinian"              => 21046,
                         "ac/dc"                   => 12851,
                         "academia"                => 6155,
                         "academic"                => 853,
                         "academica"               => 21526,
                         "academical"              => 16853,
                         "academically"            => 9354,
                         "academician"             => 12521,
                         "academicians"            => 21630,
                         "academics"               => 3979,
                         "academie"                => 7767,
                         "academies"               => 7091,
                         "academy"                 => 475,
                         "acadian"                 => 12773,
                         "acadians"                => 14666,
                         "accademia"               => 11569,
                         "accede"                  => 24393,
                         "acceded"                 => 15760,
                         "accelerate"              => 8294,
                         "accelerated"             => 5771,
                         "accelerates"             => 19014,
                         "accelerating"            => 10798,
                         "acceleration"            => 5902,
                         "accelerator"             => 9676,
                         "accelerators"            => 17775,
                         "accented"                => 15924,
                         "accentuated"             => 20031,
                         "accenture"               => 26429,
                         "acceptability"           => 26390,
                         "acceptance"              => 3812,
                         "accepted"                => 1081,
                         "acceptor"                => 14235,
                         "accepts"                 => 4814,
                         "accessed"                => 4426,
                         "accesses"                => 18121,
                         "accessibility"           => 7873,
                         "accessible"              => 2634,
                         "accessing"               => 10108,
                         "accession"               => 5813,
                         "accessories"             => 5975,
                         "accion"                  => 26436,
                         "accipitridae"            => 27889,
                         "acclaim"                 => 3662,
                         "acclaimed"               => 3332,
                         "acclamation"             => 18439,
                         "accolade"                => 13373,
                         "accolades"               => 6592,
                         "accommodate"             => 3106,
                         "accommodated"            => 9589,
                         "accommodates"            => 13049,
                         "accommodation"           => 4013,
                         "accompanied"             => 1856,
                         "accompanies"             => 9820,
                         "accompaniment"           => 7899,
                         "accompanist"             => 16312,
                         "accompany"               => 5238,
                         "accompanying"            => 4097,
                         "accomplishments"         => 5552,
                         "accordance"              => 3738,
                         "accorded"                => 9663,
                         "according"               => 216,
                         "accordingly"             => 4320,
                         "accordion"               => 9102,
                         "accordionist"            => 27450,
                         "accords"                 => 10880,
                         "account"                 => 1132,
                         "accountability"          => 6205,
                         "accountancy"             => 12771,
                         "accounted"               => 5339,
                         "accounting"              => 3434,
                         "accounts"                => 1991,
                         "accra"                   => 11097,
                         "accreditation"           => 4634,
                         "accredited"              => 3768,
                         "accrediting"             => 14840,
                         "accretion"               => 17561,
                         "accrington"              => 13620,
                         "accrue"                  => 21947,
                         "accrued"                 => 16087,
                         "accumulate"              => 9193,
                         "accumulated"             => 5557,
                         "accumulates"             => 16916,
                         "accumulating"            => 11735,
                         "accumulation"            => 7142,
                         "accumulations"           => 23344,
                         "accumulator"             => 20682,
                         "accuracy"                => 3790,
                         "accurate"                => 3030,
                         "accurately"              => 5308,
                         "accusative"              => 16294,
                         "accused"                 => 1795,
                         "acetaldehyde"            => 29281,
                         "acetic"                  => 15621,
                         "acetone"                 => 20486,
                         "acetyl"                  => 16467,
                         "acetylation"             => 29997,
                         "acetylcholine"           => 15916,
                         "acetylene"               => 21845,
                         "acetyltransferase"       => 28060,
                         "achaea"                  => 17644,
                         "achaean"                 => 27645,
                         "achaemenid"              => 16274,
                         "acharya"                 => 12095,
                         "achievable"              => 17591,
                         "achieve"                 => 1994,
                         "achieved"                => 1257,
                         "achievement"             => 2258,
                         "achievements"            => 3025,
                         "achievers"               => 26963,
                         "achieves"                => 10611,
                         "achieving"               => 3840,
                         "acid"                    => 1778,
                         "acidic"                  => 8353,
                         "acidification"           => 25072,
                         "acidity"                 => 14016,
                         "acids"                   => 4526,
                         "acknowledged"            => 3507,
                         "acknowledgement"         => 13228,
                         "acknowledges"            => 9363,
                         "acknowledging"           => 9318,
                         "acknowledgment"          => 15780,
                         "acland"                  => 18602,
                         "acleris"                 => 26891,
                         "acolytes"                => 24670,
                         "acorn"                   => 10758,
                         "acoustic"                => 2969,
                         "acoustical"              => 19546,
                         "acoustically"            => 23181,
                         "acoustics"               => 11051,
                         "acquiesced"              => 25121,
                         "acquire"                 => 3652,
                         "acquired"                => 911,
                         "acquires"                => 11449,
                         "acquiring"               => 4996,
                         "acquisition"             => 2561,
                         "acquisitions"            => 6355,
                         "acquitted"               => 6462,
                         "acraea"                  => 23128,
                         "acre"                    => 3995,
                         "acreage"                 => 15628,
                         "acres"                   => 2591,
                         "acrimonious"             => 19241,
                         "acrobatic"               => 14321,
                         "acrobatics"              => 20276,
                         "acrocercops"             => 22926,
                         "acrolophus"              => 29800,
                         "acronym"                 => 6374,
                         "acronyms"                => 23424,
                         "acropolis"               => 12873,
                         "across"                  => 419,
                         "acrylic"                 => 12006,
                         "act"                     => 303,
                         "actions"                 => 1382,
                         "activated"               => 3607,
                         "activates"               => 10524,
                         "activating"              => 11481,
                         "activation"              => 4944,
                         "active"                  => 571,
                         "actively"                => 2995,
                         "activision"              => 15259,
                         "activism"                => 5062,
                         "activist"                => 2771,
                         "activists"               => 3515,
                         "activities"              => 623,
                         "activity"                => 1001,
                         "actor"                   => 775,
                         "actors"                  => 1832,
                         "actress"                 => 1094,
                         "actresses"               => 6898,
                         "acts"                    => 1251,
                         "actual"                  => 1603,
                         "actuaries"               => 27137,
                         "actuated"                => 20078,
                         "actuator"                => 20870,
                         "actuators"               => 19481,
                         "acuity"                  => 19796,
                         "acumen"                  => 17482,
                         "acute"                   => 4307,
                         "acutely"                 => 19818,
                         "acyclic"                 => 25342,
                         "adalbert"                => 15347,
                         "adamantly"               => 25914,
                         "adamawa"                 => 28120,
                         "adana"                   => 12961,
                         "adapt"                   => 5930,
                         "adaptability"            => 22869,
                         "adaptable"               => 15340,
                         "adaptation"              => 2248,
                         "adaptations"             => 4798,
                         "adapted"                 => 1978,
                         "adapter"                 => 10796,
                         "adapting"                => 8733,
                         "adaption"                => 12618,
                         "adaptive"                => 6748,
                         "adaptor"                 => 22541,
                         "adapts"                  => 18333,
                         "adare"                   => 27432,
                         "adarsh"                  => 22231,
                         "added"                   => 505,
                         "adder"                   => 19563,
                         "adding"                  => 2016,
                         "addition"                => 377,
                         "additional"              => 658,
                         "additionally"            => 1719,
                         "additions"               => 4721,
                         "additive"                => 9213,
                         "additives"               => 12669,
                         "addressed"               => 3151,
                         "addresses"               => 4241,
                         "addressing"              => 5039,
                         "adds"                    => 4139,
                         "adelphi"                 => 16380,
                         "adenauer"                => 20729,
                         "adenine"                 => 23583,
                         "adenosine"               => 17055,
                         "adept"                   => 10517,
                         "adequacy"                => 22877,
                         "adequate"                => 4319,
                         "adequately"              => 8392,
                         "adhere"                  => 8467,
                         "adhered"                 => 11624,
                         "adherence"               => 9491,
                         "adherent"                => 17334,
                         "adherents"               => 8101,
                         "adheres"                 => 15298,
                         "adhering"                => 14200,
                         "adhesion"                => 10664,
                         "adhesives"               => 20624,
                         "adiabatic"               => 20608,
                         "adige"                   => 27999,
                         "adipose"                 => 19477,
                         "adirondack"              => 12939,
                         "aditi"                   => 26830,
                         "adiyaman"                => 24190,
                         "adjacent"                => 1660,
                         "adjectival"              => 23465,
                         "adjective"               => 8375,
                         "adjectives"              => 9990,
                         "adjoined"                => 22469,
                         "adjoining"               => 5130,
                         "adjoins"                 => 15892,
                         "adjoint"                 => 15904,
                         "adjournment"             => 28566,
                         "adjudged"                => 19029,
                         "adjudicated"             => 25067,
                         "adjudication"            => 20280,
                         "adjudicator"             => 27747,
                         "adjunct"                 => 7305,
                         "adjustable"              => 9086,
                         "adjusted"                => 5044,
                         "adjusts"                 => 21007,
                         "adjutant"                => 7423,
                         "adjuvant"                => 27557,
                         "administered"            => 2884,
                         "administering"           => 9588,
                         "administers"             => 9413,
                         "administracion"          => 21418,
                         "administrated"           => 17825,
                         "administration"          => 676,
                         "administrations"         => 8990,
                         "administrative"          => 782,
                         "administratively"        => 7466,
                         "administrator"           => 3368,
                         "administrators"          => 5377,
                         "admiral"                 => 2034,
                         "admirals"                => 11042,
                         "admiralty"               => 5151,
                         "admission"               => 3465,
                         "admissions"              => 6344,
                         "admits"                  => 5194,
                         "admitted"                => 1841,
                         "admixture"               => 19280,
                         "adnan"                   => 13692,
                         "adobe"                   => 6419,
                         "adolescents"             => 9092,
                         "adolf"                   => 4487,
                         "adolphe"                 => 11938,
                         "adolphus"                => 13375,
                         "adoor"                   => 24807,
                         "adopted"                 => 1068,
                         "adopters"                => 28371,
                         "adopting"                => 5754,
                         "adopts"                  => 10057,
                         "adorn"                   => 16697,
                         "adorned"                 => 8260,
                         "adorning"                => 28487,
                         "adornment"               => 28367,
                         "adorns"                  => 27774,
                         "adrenergic"              => 20145,
                         "adriaan"                 => 22212,
                         "adriaen"                 => 29813,
                         "adrianople"              => 20020,
                         "adriatic"                => 7991,
                         "adsorption"              => 17493,
                         "adult"                   => 1359,
                         "adulterous"              => 24466,
                         "adulthood"               => 7277,
                         "adults"                  => 1984,
                         "advaita"                 => 17480,
                         "advance"                 => 1589,
                         "advanced"                => 1002,
                         "advancement"             => 4749,
                         "advancements"            => 12662,
                         "advances"                => 4133,
                         "advancing"               => 4082,
                         "advani"                  => 29295,
                         "advantageous"            => 10507,
                         "advantages"              => 4173,
                         "adventist"               => 8064,
                         "adventists"              => 16021,
                         "adventurer"              => 10434,
                         "adventurers"             => 12819,
                         "adventures"              => 2749,
                         "adverb"                  => 26378,
                         "adverbs"                 => 20268,
                         "adversarial"             => 22751,
                         "adverse"                 => 5264,
                         "adversely"               => 11647,
                         "advert"                  => 12404,
                         "advertised"              => 6240,
                         "advertisement"           => 5518,
                         "advertisements"          => 4984,
                         "advertiser"              => 9854,
                         "advertisers"             => 10558,
                         "advertising"             => 2013,
                         "adverts"                 => 14203,
                         "advised"                 => 3731,
                         "adviser"                 => 4420,
                         "advisers"                => 8238,
                         "advises"                 => 8567,
                         "advisor"                 => 3188,
                         "advisories"              => 16305,
                         "advisors"                => 6708,
                         "advisory"                => 2484,
                         "advocacy"                => 4144,
                         "advocate"                => 2883,
                         "advocated"               => 4131,
                         "advocates"               => 4509,
                         "advocating"              => 7119,
                         "aechmea"                 => 20850,
                         "aegean"                  => 8769,
                         "aegis"                   => 10875,
                         "aegon"                   => 20411,
                         "aemilius"                => 27727,
                         "aeneas"                  => 15111,
                         "aeneid"                  => 21406,
                         "aeolian"                 => 18932,
                         "aerial"                  => 3315,
                         "aerials"                 => 24520,
                         "aerobatic"               => 15975,
                         "aerobatics"              => 22908,
                         "aerobic"                 => 12782,
                         "aerodrome"               => 7364,
                         "aerodynamic"             => 8984,
                         "aerodynamics"            => 13596,
                         "aeroflot"                => 21513,
                         "aeronautica"             => 19007,
                         "aeronautical"            => 8499,
                         "aeronautics"             => 9094,
                         "aeronautique"            => 24282,
                         "aeroplane"               => 11536,
                         "aeroplanes"              => 19016,
                         "aeros"                   => 20855,
                         "aerosols"                => 24099,
                         "aerospace"               => 4977,
                         "aerospatiale"            => 29458,
                         "aeschylus"               => 21531,
                         "aesop"                   => 17447,
                         "aesthetic"               => 4702,
                         "aesthetically"           => 13724,
                         "aesthetics"              => 7368,
                         "aethelred"               => 20162,
                         "aethelstan"              => 26128,
                         "aether"                  => 19046,
                         "aetna"                   => 28595,
                         "affairs"                 => 1020,
                         "affected"                => 1756,
                         "affecting"               => 4729,
                         "affectionately"          => 10911,
                         "affective"               => 14155,
                         "afferent"                => 24800,
                         "affiliate"               => 2902,
                         "affiliated"              => 2181,
                         "affiliates"              => 5859,
                         "affiliation"             => 4328,
                         "affiliations"            => 7513,
                         "affine"                  => 11478,
                         "affinis"                 => 22221,
                         "affinities"              => 15557,
                         "affinity"                => 6323,
                         "affirmation"             => 14071,
                         "affirmed"                => 7288,
                         "affirming"               => 13575,
                         "affirms"                 => 16935,
                         "affix"                   => 25949,
                         "affixed"                 => 13127,
                         "affixes"                 => 21110,
                         "afflicted"               => 10735,
                         "affluence"               => 22002,
                         "affluent"                => 7581,
                         "affordability"           => 19656,
                         "affordable"              => 5465,
                         "afforded"                => 8676,
                         "affording"               => 21097,
                         "affords"                 => 14678,
                         "afghan"                  => 4400,
                         "afghanistan"             => 2232,
                         "afghans"                 => 13709,
                         "aficionados"             => 22132,
                         "afield"                  => 13367,
                         "afire"                   => 26668,
                         "afonso"                  => 10821,
                         "aforementioned"          => 6188,
                         "aforesaid"               => 22471,
                         "afoul"                   => 24763,
                         "africa"                  => 562,
                         "african"                 => 529,
                         "africana"                => 19044,
                         "africans"                => 6390,
                         "africanus"               => 18983,
                         "afridi"                  => 25319,
                         "afrikaans"               => 9818,
                         "afrikaner"               => 17490,
                         "afrikaners"              => 29592,
                         "afshar"                  => 27631,
                         "aftab"                   => 20519,
                         "after"                   => 30,
                         "aftermarket"             => 16641,
                         "aftermath"               => 2597,
                         "aftershock"              => 27770,
                         "aftershocks"             => 23213,
                         "afterward"               => 4414,
                         "afterwards"              => 1821,
                         "afterword"               => 23480,
                         "afzal"                   => 22447,
                         "against"                 => 101,
                         "agama"                   => 27893,
                         "agaricus"                => 25579,
                         "agassiz"                 => 17745,
                         "agave"                   => 19915,
                         "agder"                   => 16990,
                         "age"                     => 140,
                         "aged"                    => 1524,
                         "ageing"                  => 10613,
                         "agence"                  => 21545,
                         "agencies"                => 2131,
                         "agency"                  => 1039,
                         "agents"                  => 2165,
                         "ages"                    => 1753,
                         "agglomeration"           => 13983,
                         "aggregate"               => 3246,
                         "aggregated"              => 14948,
                         "aggregates"              => 13138,
                         "aggregating"             => 21248,
                         "aggregation"             => 10226,
                         "aggregations"            => 27011,
                         "aggregator"              => 10413,
                         "aggression"              => 6080,
                         "aggressively"            => 9230,
                         "aggressiveness"          => 20505,
                         "aggrieved"               => 25993,
                         "agile"                   => 10599,
                         "agility"                 => 11041,
                         "agincourt"               => 20834,
                         "aging"                   => 4794,
                         "agios"                   => 16399,
                         "agitating"               => 27754,
                         "agitation"               => 9461,
                         "agnostic"                => 10971,
                         "agong"                   => 24106,
                         "agonist"                 => 12162,
                         "agonists"                => 17582,
                         "agonopterix"             => 27967,
                         "agora"                   => 18482,
                         "agrarian"                => 7716,
                         "agreement"               => 985,
                         "agreements"              => 3690,
                         "agrees"                  => 3789,
                         "agribusiness"            => 18916,
                         "agricole"                => 27847,
                         "agricultural"            => 1376,
                         "agriculturally"          => 29117,
                         "agriculture"             => 1526,
                         "agrippa"                 => 16289,
                         "agrippina"               => 23837,
                         "agronomist"              => 29087,
                         "agronomy"                => 23573,
                         "aground"                 => 9446,
                         "aguascalientes"          => 21094,
                         "agulhas"                 => 29337,
                         "agung"                   => 25501,
                         "aharon"                  => 19416,
                         "ahmadabad"               => 17221,
                         "ahmadinejad"             => 14195,
                         "ahmadiyya"               => 15125,
                         "ahmedabad"               => 9377,
                         "ahmednagar"              => 21415,
                         "ahmet"                   => 13016,
                         "ahvaz"                   => 22591,
                         "aichi"                   => 11467,
                         "aicte"                   => 20310,
                         "aided"                   => 4059,
                         "ailerons"                => 14815,
                         "ailing"                  => 11462,
                         "ailments"                => 13099,
                         "ailsa"                   => 25911,
                         "aimed"                   => 2409,
                         "aiming"                  => 6283,
                         "aims"                    => 2864,
                         "aintree"                 => 20895,
                         "air"                     => 207,
                         "airasia"                 => 26755,
                         "airbase"                 => 12247,
                         "aircraft"                => 460,
                         "aircrew"                 => 12495,
                         "aircrews"                => 17814,
                         "airdate"                 => 13275,
                         "airdrie"                 => 16095,
                         "airdrieonians"           => 28870,
                         "aired"                   => 1325,
                         "aires"                   => 3270,
                         "airfield"                => 3231,
                         "airfields"               => 7988,
                         "airflow"                 => 12959,
                         "airfoil"                 => 17232,
                         "airframe"                => 11164,
                         "airframes"               => 19468,
                         "airing"                  => 3518,
                         "airings"                 => 21442,
                         "airlift"                 => 7527,
                         "airline"                 => 2764,
                         "airliner"                => 11429,
                         "airliners"               => 15209,
                         "airlines"                => 2375,
                         "airmen"                  => 9121,
                         "airpark"                 => 27939,
                         "airplay"                 => 5088,
                         "airport"                 => 599,
                         "airports"                => 4370,
                         "airs"                    => 4902,
                         "airship"                 => 9696,
                         "airships"                => 15417,
                         "airshow"                 => 18453,
                         "airspeed"                => 15411,
                         "airstrike"               => 19719,
                         "airstrikes"              => 14507,
                         "airstrips"               => 28638,
                         "airtel"                  => 20752,
                         "airtime"                 => 16615,
                         "airways"                 => 4560,
                         "airworthiness"           => 26421,
                         "airworthy"               => 27877,
                         "aisles"                  => 9943,
                         "aisne"                   => 13301,
                         "ajaccio"                 => 21042,
                         "ajith"                   => 22644,
                         "ajmer"                   => 17234,
                         "akademi"                 => 12047,
                         "akademie"                => 17409,
                         "akali"                   => 23762,
                         "akash"                   => 22006,
                         "akb48"                   => 20677,
                         "akbar"                   => 7260,
                         "akershus"                => 18071,
                         "akhenaten"               => 19516,
                         "akhil"                   => 28177,
                         "akhtar"                  => 13322,
                         "akiba"                   => 29165,
                         "akita"                   => 14089,
                         "akiva"                   => 19430,
                         "akkadian"                => 14469,
                         "akram"                   => 18480,
                         "akron"                   => 7667,
                         "aksaray"                 => 29253,
                         "alagoas"                 => 27962,
                         "alamein"                 => 17279,
                         "alamos"                  => 12349,
                         "aland"                   => 8621,
                         "alanine"                 => 23280,
                         "alans"                   => 27907,
                         "alappuzha"               => 21835,
                         "alasdair"                => 19023,
                         "alaskan"                 => 10123,
                         "alauddin"                => 24911,
                         "alava"                   => 18612,
                         "albacete"                => 19864,
                         "albania"                 => 3767,
                         "albanian"                => 3669,
                         "albanians"               => 9639,
                         "albans"                  => 8734,
                         "albarn"                  => 20562,
                         "albatrosses"             => 26132,
                         "albay"                   => 29502,
                         "albedo"                  => 15071,
                         "albeit"                  => 4602,
                         "albemarle"               => 12743,
                         "alberni"                 => 29209,
                         "albertus"                => 26206,
                         "albertville"             => 23258,
                         "albini"                  => 22495,
                         "albinism"                => 28165,
                         "albinus"                 => 28027,
                         "alborz"                  => 20676,
                         "album"                   => 97,
                         "albumin"                 => 23090,
                         "albums"                  => 873,
                         "albuquerque"             => 7110,
                         "alcalde"                 => 16340,
                         "alcan"                   => 29540,
                         "alchemical"              => 21748,
                         "alchemist"               => 13740,
                         "alchemists"              => 28198,
                         "alcibiades"              => 23316,
                         "alcoa"                   => 18202,
                         "alcoholism"              => 8367,
                         "alcohols"                => 14794,
                         "aldeburgh"               => 22605,
                         "aldehyde"                => 16809,
                         "aldehydes"               => 21854,
                         "alderley"                => 27901,
                         "aldermen"                => 11922,
                         "alderney"                => 20502,
                         "aldershot"               => 10216,
                         "aldgate"                 => 28841,
                         "aldwych"                 => 26316,
                         "alegre"                  => 11882,
                         "alekhine"                => 22281,
                         "aleksandar"              => 12260,
                         "aleksandrovich"          => 17185,
                         "aleksandrow"             => 28099,
                         "alemannic"               => 28958,
                         "alentejo"                => 26173,
                         "aleph"                   => 23981,
                         "aleppo"                  => 8134,
                         "alerts"                  => 11778,
                         "alesi"                   => 20349,
                         "alessandria"             => 18868,
                         "alesund"                 => 21296,
                         "aleut"                   => 24869,
                         "aleutian"                => 13906,
                         "aleutians"               => 28419,
                         "alexandrian"             => 17451,
                         "alexandrine"             => 27554,
                         "alexandrov"              => 25655,
                         "alexandrovich"           => 20580,
                         "alexios"                 => 13771,
                         "alexius"                 => 25775,
                         "alfreton"                => 23712,
                         "algae"                   => 6537,
                         "algal"                   => 17212,
                         "algarve"                 => 15043,
                         "algebra"                 => 3987,
                         "algebraic"               => 6005,
                         "algebraically"           => 23853,
                         "algebras"                => 10055,
                         "algeciras"               => 20434,
                         "algeria"                 => 4179,
                         "algerian"                => 6044,
                         "algiers"                 => 8046,
                         "algol"                   => 16805,
                         "algoma"                  => 19801,
                         "algonquian"              => 15032,
                         "algonquin"               => 13270,
                         "algorithm"               => 3290,
                         "algorithmic"             => 16888,
                         "algorithms"              => 4896,
                         "alhaji"                  => 24638,
                         "aliabad"                 => 13763,
                         "aliasing"                => 23541,
                         "alienation"              => 11134,
                         "aligarh"                 => 15321,
                         "alighieri"               => 26087,
                         "align"                   => 5643,
                         "aligned"                 => 4924,
                         "aligning"                => 16152,
                         "alignment"               => 4168,
                         "alignments"              => 15267,
                         "aligns"                  => 24197,
                         "aliphatic"               => 28974,
                         "alister"                 => 27591,
                         "alitalia"                => 29111,
                         "alito"                   => 23249,
                         "aliyev"                  => 17599,
                         "alkali"                  => 11549,
                         "alkaloid"                => 19410,
                         "alkaloids"               => 15632,
                         "alkene"                  => 23166,
                         "alkenes"                 => 23164,
                         "alkmaar"                 => 20592,
                         "alkyl"                   => 15439,
                         "alkylation"              => 29939,
                         "allahabad"               => 9976,
                         "allama"                  => 24192,
                         "allegany"                => 18060,
                         "allegation"              => 10627,
                         "allegations"             => 3415,
                         "allege"                  => 16301,
                         "alleged"                 => 2197,
                         "allegedly"               => 3212,
                         "alleges"                 => 13576,
                         "allegheny"               => 6774,
                         "allegiance"              => 5641,
                         "alleging"                => 7932,
                         "allegorical"             => 11283,
                         "allegories"              => 24954,
                         "allegory"                => 11420,
                         "allele"                  => 11669,
                         "alleles"                 => 13274,
                         "allendale"               => 25323,
                         "allentown"               => 11278,
                         "allerton"                => 21041,
                         "alleviate"               => 8760,
                         "alleviated"              => 22038,
                         "alleviating"             => 22942,
                         "alleviation"             => 22160,
                         "alleyn"                  => 26824,
                         "allgau"                  => 29271,
                         "allgemeine"              => 17699,
                         "alliance"                => 1336,
                         "alliances"               => 7309,
                         "allied"                  => 1811,
                         "allier"                  => 22480,
                         "allies"                  => 2256,
                         "allium"                  => 16110,
                         "allmusic"                => 3876,
                         "alloa"                   => 18758,
                         "allocate"                => 12703,
                         "allocated"               => 3944,
                         "allocates"               => 25854,
                         "allocating"              => 17215,
                         "allocation"              => 5740,
                         "allocations"             => 15566,
                         "allophones"              => 28466,
                         "allosteric"              => 24474,
                         "allotment"               => 12777,
                         "allotments"              => 15479,
                         "allotted"                => 8565,
                         "allow"                   => 902,
                         "allowable"               => 16430,
                         "allowed"                 => 633,
                         "allowing"                => 1293,
                         "allows"                  => 1173,
                         "alloy"                   => 6249,
                         "alloys"                  => 9124,
                         "allround"                => 20846,
                         "allsvenskan"             => 12051,
                         "allude"                  => 19607,
                         "alluded"                 => 12130,
                         "alludes"                 => 11714,
                         "alluding"                => 14564,
                         "allusion"                => 11096,
                         "allusions"               => 11337,
                         "alluvial"                => 10503,
                         "alluvium"                => 23969,
                         "allying"                 => 24383,
                         "almagro"                 => 19050,
                         "almanac"                 => 11633,
                         "almanack"                => 23684,
                         "almaty"                  => 15040,
                         "almeria"                 => 14148,
                         "almirante"               => 22284,
                         "almohad"                 => 29929,
                         "almshouse"               => 29075,
                         "almshouses"              => 19617,
                         "alnus"                   => 28882,
                         "alnwick"                 => 22109,
                         "aloft"                   => 15518,
                         "alois"                   => 14978,
                         "along"                   => 179,
                         "alongside"               => 1119,
                         "alouettes"               => 12407,
                         "alpes"                   => 10559,
                         "alphabetic"              => 18247,
                         "alphabetical"            => 8544,
                         "alphabetically"          => 11181,
                         "alphabets"               => 14627,
                         "alphanumeric"            => 21744,
                         "alpini"                  => 27348,
                         "alps"                    => 4761,
                         "alsace"                  => 8022,
                         "alsatian"                => 21574,
                         "also"                    => 22,
                         "alstom"                  => 16933,
                         "altai"                   => 14014,
                         "altamont"                => 24313,
                         "altan"                   => 26682,
                         "altarpiece"              => 10472,
                         "altarpieces"             => 20648,
                         "altars"                  => 11242,
                         "altay"                   => 29693,
                         "alter"                   => 4498,
                         "alteration"              => 8761,
                         "alterations"             => 6239,
                         "altered"                 => 3316,
                         "alternate"               => 2568,
                         "alternated"              => 11344,
                         "alternately"             => 8418,
                         "alternates"              => 13062,
                         "alternating"             => 5609,
                         "alternation"             => 17160,
                         "alternative"             => 1206,
                         "alternatively"           => 4706,
                         "alternatives"            => 5588,
                         "although"                => 184,
                         "altimeter"               => 27139,
                         "altitude"                => 2754,
                         "altitudes"               => 7433,
                         "alto"                    => 5192,
                         "altona"                  => 15563,
                         "altoona"                 => 16038,
                         "altos"                   => 16649,
                         "altrincham"              => 15508,
                         "altstadt"                => 29014,
                         "altus"                   => 28340,
                         "alumina"                 => 19977,
                         "aluminium"               => 5108,
                         "aluminum"                => 4920,
                         "alumna"                  => 20106,
                         "alumnae"                 => 19975,
                         "alumni"                  => 2793,
                         "alumnus"                 => 6887,
                         "alveolar"                => 12555,
                         "alwar"                   => 28412,
                         "alzheimer"               => 7791,
                         "am/fm"                   => 29022,
                         "amadou"                  => 24430,
                         "amalfi"                  => 23464,
                         "amalgamate"              => 24457,
                         "amalgamated"             => 6138,
                         "amalgamation"            => 7252,
                         "amalgamations"           => 27805,
                         "amalie"                  => 18120,
                         "amalric"                 => 28239,
                         "amami"                   => 24245,
                         "amanita"                 => 20813,
                         "amarna"                  => 17323,
                         "amass"                   => 20924,
                         "amassed"                 => 7551,
                         "amassing"                => 14262,
                         "amasya"                  => 21492,
                         "amata"                   => 24746,
                         "amateurliga"             => 25474,
                         "amaury"                  => 29598,
                         "amazon.com"              => 10786,
                         "amazonia"                => 27465,
                         "amazonian"               => 17213,
                         "amazons"                 => 15294,
                         "ambala"                  => 25290,
                         "ambassador"              => 2068,
                         "ambassadors"             => 6755,
                         "ambedkar"                => 16764,
                         "amberley"                => 28084,
                         "ambient"                 => 6377,
                         "ambiguities"             => 22529,
                         "ambiguity"               => 8996,
                         "ambiguous"               => 7040,
                         "ambika"                  => 27306,
                         "ambit"                   => 29799,
                         "ambitions"               => 7184,
                         "ambivalent"              => 15836,
                         "ambon"                   => 21070,
                         "amboy"                   => 17107,
                         "ambroise"                => 25591,
                         "ambulatory"              => 17166,
                         "ambushes"                => 17463,
                         "amedeo"                  => 21166,
                         "ameer"                   => 25298,
                         "ameliorate"              => 27670,
                         "amend"                   => 9269,
                         "amended"                 => 4936,
                         "amending"                => 14860,
                         "amendment"               => 2456,
                         "amendments"              => 5639,
                         "amenhotep"               => 20098,
                         "amenities"               => 5819,
                         "amenity"                 => 20681,
                         "american"                => 76,
                         "americana"               => 9292,
                         "americanism"             => 27151,
                         "americans"               => 1360,
                         "americanus"              => 28092,
                         "americas"                => 3802,
                         "americo"                 => 28621,
                         "amerindian"              => 16296,
                         "amerindians"             => 24782,
                         "amersfoort"              => 26237,
                         "amery"                   => 27664,
                         "amesbury"                => 26650,
                         "amhara"                  => 18878,
                         "amharic"                 => 18066,
                         "amherst"                 => 6934,
                         "amicably"                => 19545,
                         "amicus"                  => 16480,
                         "amide"                   => 19989,
                         "amidships"               => 15847,
                         "amidst"                  => 7134,
                         "amiens"                  => 10757,
                         "amigaos"                 => 25471,
                         "amine"                   => 13280,
                         "amines"                  => 18012,
                         "amino"                   => 4851,
                         "amirabad"                => 22505,
                         "amitabh"                 => 16226,
                         "amity"                   => 15970,
                         "amjad"                   => 23698,
                         "amlaib"                  => 28481,
                         "amman"                   => 9048,
                         "ammar"                   => 27980,
                         "ammonia"                 => 8597,
                         "ammonian"                => 25996,
                         "ammonite"                => 23860,
                         "ammonites"               => 25840,
                         "ammonium"                => 11152,
                         "ammunition"              => 3389,
                         "amnesty"                 => 5661,
                         "among"                   => 227,
                         "amongst"                 => 1905,
                         "amorphous"               => 13587,
                         "amory"                   => 21187,
                         "amount"                  => 1010,
                         "amounted"                => 6753,
                         "amounting"               => 10481,
                         "amounts"                 => 2838,
                         "amphetamine"             => 17067,
                         "amphibian"               => 12994,
                         "amphibians"              => 9145,
                         "amphibious"              => 5525,
                         "amphitheater"            => 11275,
                         "amphitheatre"            => 10989,
                         "amphoe"                  => 14876,
                         "amplification"           => 10862,
                         "amplified"               => 10930,
                         "amplifier"               => 7687,
                         "amplifiers"              => 8930,
                         "amplify"                 => 16929,
                         "amplifying"              => 26110,
                         "amplitude"               => 7892,
                         "amplitudes"              => 20869,
                         "amputated"               => 15548,
                         "amputee"                 => 26284,
                         "amravati"                => 27926,
                         "amrit"                   => 27549,
                         "amritsar"                => 13285,
                         "amstrad"                 => 18328,
                         "amtrak"                  => 6327,
                         "amuro"                   => 21790,
                         "amusements"              => 22866,
                         "amygdala"                => 18095,
                         "amyloid"                 => 18155,
                         "amyotrophic"             => 28862,
                         "an"                      => 16,
                         "an/fps"                  => 17424,
                         "anabaptist"              => 25742,
                         "anabaptists"             => 29194,
                         "anachronistic"           => 20253,
                         "anacostia"               => 17475,
                         "anadolu"                 => 28519,
                         "anaerobic"               => 12363,
                         "anaesthesia"             => 21091,
                         "anaheim"                 => 7005,
                         "analgesia"               => 29810,
                         "analgesic"               => 16928,
                         "analog"                  => 3881,
                         "analogies"               => 19995,
                         "analogous"               => 6527,
                         "analogously"             => 29357,
                         "analogs"                 => 19339,
                         "analogue"                => 7116,
                         "analogues"               => 15930,
                         "analyse"                 => 14137,
                         "analysed"                => 10982,
                         "analyses"                => 5938,
                         "analysing"               => 15751,
                         "analysis"                => 1040,
                         "analyst"                 => 5001,
                         "analysts"                => 6434,
                         "analyte"                 => 25027,
                         "analytic"                => 7950,
                         "analytical"              => 6635,
                         "analytically"            => 26098,
                         "analytics"               => 9274,
                         "analyzed"                => 6175,
                         "analyzer"                => 16994,
                         "analyzers"               => 28114,
                         "analyzes"                => 13024,
                         "anambra"                 => 26545,
                         "anamorphic"              => 20910,
                         "anand"                   => 7549,
                         "anant"                   => 26130,
                         "anarchic"                => 25477,
                         "anarchism"               => 10052,
                         "anarchist"               => 6015,
                         "anarchists"              => 9848,
                         "anarcho"                 => 13030,
                         "anare"                   => 28319,
                         "anastasius"              => 23703,
                         "anatolia"                => 7695,
                         "anatolian"               => 12694,
                         "anatoly"                 => 12741,
                         "anatomic"                => 26679,
                         "anatomical"              => 9179,
                         "anatomist"               => 18969,
                         "anatomy"                 => 4909,
                         "anbar"                   => 17584,
                         "ancaster"                => 27144,
                         "ancestor"                => 4737,
                         "ancestors"               => 4121,
                         "ancestral"               => 5414,
                         "ancestries"              => 29097,
                         "ancestry"                => 3825,
                         "anchor"                  => 3232,
                         "anchorage"               => 7386,
                         "anchored"                => 5491,
                         "anchoring"               => 12925,
                         "anchors"                 => 8399,
                         "ancien"                  => 19006,
                         "ancient"                 => 798,
                         "ancients"                => 14566,
                         "ancillary"               => 12293,
                         "and"                     => 3,
                         "and/or"                  => 2265,
                         "andalucia"               => 20812,
                         "andalus"                 => 16835,
                         "andalusia"               => 10081,
                         "andalusian"              => 14166,
                         "andaman"                 => 12660,
                         "andante"                 => 25284,
                         "andean"                  => 10347,
                         "anderlecht"              => 14499,
                         "andersson"               => 10509,
                         "andesite"                => 23136,
                         "andhra"                  => 4816,
                         "andorra"                 => 10422,
                         "andorran"                => 29729,
                         "andreu"                  => 26936,
                         "androgen"                => 18358,
                         "androgynous"             => 21718,
                         "android"                 => 4848,
                         "androids"                => 22144,
                         "andromedae"              => 26420,
                         "andronicus"              => 26514,
                         "andronikos"              => 17256,
                         "anecdotal"               => 14621,
                         "anecdotes"               => 11120,
                         "anemones"                => 25363,
                         "angara"                  => 26887,
                         "angeles"                 => 687,
                         "angelicum"               => 29731,
                         "angelis"                 => 23838,
                         "angelou"                 => 15781,
                         "angered"                 => 7179,
                         "angering"                => 22413,
                         "angevin"                 => 20587,
                         "angiogenesis"            => 20406,
                         "angiography"             => 28103,
                         "angiosperms"             => 27383,
                         "angiotensin"             => 23548,
                         "angkor"                  => 16893,
                         "anglais"                 => 27015,
                         "angled"                  => 10545,
                         "anglers"                 => 14175,
                         "angles"                  => 5023,
                         "anglesey"                => 11825,
                         "anglia"                  => 8056,
                         "anglian"                 => 13647,
                         "anglican"                => 3236,
                         "anglicanism"             => 19414,
                         "anglicans"               => 14941,
                         "anglicised"              => 15503,
                         "anglicized"              => 15560,
                         "anglo"                   => 2524,
                         "anglophone"              => 15205,
                         "angola"                  => 4850,
                         "angolan"                 => 11039,
                         "angouleme"               => 18512,
                         "angra"                   => 19082,
                         "angrily"                 => 9332,
                         "angular"                 => 6202,
                         "anhalt"                  => 8376,
                         "anheuser"                => 19593,
                         "anhui"                   => 11973,
                         "anhydride"               => 23873,
                         "anhydrous"               => 21682,
                         "aniline"                 => 26865,
                         "animals"                 => 1225,
                         "animated"                => 2288,
                         "animating"               => 25041,
                         "animation"               => 2635,
                         "animations"              => 10533,
                         "animator"                => 9197,
                         "animators"               => 12686,
                         "animatronic"             => 25304,
                         "animax"                  => 26385,
                         "animism"                 => 28296,
                         "anion"                   => 13528,
                         "anionic"                 => 28730,
                         "anions"                  => 18862,
                         "anisotropic"             => 24088,
                         "anisotropy"              => 23208,
                         "anjou"                   => 10764,
                         "annales"                 => 16802,
                         "annals"                  => 6768,
                         "annam"                   => 27478,
                         "annan"                   => 11606,
                         "annandale"               => 17342,
                         "annapolis"               => 8077,
                         "annapurna"               => 23201,
                         "annealing"               => 22772,
                         "annecy"                  => 22190,
                         "annenberg"               => 19678,
                         "annesley"                => 23272,
                         "annex"                   => 6528,
                         "annexation"              => 6375,
                         "annexe"                  => 23907,
                         "annexed"                 => 4544,
                         "annexes"                 => 25852,
                         "annexing"                => 19961,
                         "annibale"                => 28431,
                         "annihilated"             => 14177,
                         "annihilation"            => 11731,
                         "anniston"                => 27284,
                         "anniversary"             => 1712,
                         "annotated"               => 11901,
                         "annotation"              => 17454,
                         "annotations"             => 14816,
                         "announced"               => 356,
                         "announcements"           => 8749,
                         "announcer"               => 5586,
                         "announcers"              => 12369,
                         "announces"               => 7437,
                         "announcing"              => 5386,
                         "annual"                  => 636,
                         "annually"                => 2008,
                         "annuals"                 => 18508,
                         "annuities"               => 21877,
                         "annuity"                 => 13644,
                         "annular"                 => 16196,
                         "annulus"                 => 25125,
                         "annum"                   => 9305,
                         "annunciation"            => 13010,
                         "anode"                   => 13055,
                         "anointing"               => 22206,
                         "anomalies"               => 11535,
                         "anomalous"               => 14837,
                         "anorthosis"              => 22429,
                         "another"                 => 176,
                         "anoxic"                  => 29479,
                         "anquetil"                => 29796,
                         "ansaldo"                 => 29804,
                         "ansar"                   => 14984,
                         "ansbach"                 => 19797,
                         "anschluss"               => 19197,
                         "ansett"                  => 23005,
                         "ansgar"                  => 26188,
                         "anstruther"              => 26740,
                         "answerable"              => 24986,
                         "antagonism"              => 16239,
                         "antagonist"              => 6626,
                         "antagonists"             => 10239,
                         "antalya"                 => 13598,
                         "antananarivo"            => 21243,
                         "antarctic"               => 3657,
                         "antarctica"              => 4783,
                         "antebellum"              => 13818,
                         "antecedent"              => 16545,
                         "antecedents"             => 16524,
                         "antena"                  => 26848,
                         "antenna"                 => 4768,
                         "antennae"                => 10302,
                         "antennas"                => 8741,
                         "anterior"                => 5483,
                         "anteriorly"              => 17090,
                         "anthem"                  => 4359,
                         "anthemic"                => 25612,
                         "anthems"                 => 12690,
                         "anthers"                 => 20322,
                         "anthologies"             => 8002,
                         "anthologized"            => 23711,
                         "anthology"               => 3899,
                         "anthracite"              => 17970,
                         "anthropogenic"           => 17130,
                         "anthropological"         => 9766,
                         "anthropologist"          => 7845,
                         "anthropologists"         => 11491,
                         "anthropology"            => 4796,
                         "anthropomorphic"         => 11868,
                         "anti"                    => 702,
                         "antiaircraft"            => 15702,
                         "antibacterial"           => 20647,
                         "antibody"                => 9201,
                         "antic"                   => 23303,
                         "anticancer"              => 28562,
                         "anticipated"             => 4779,
                         "anticipates"             => 21654,
                         "anticline"               => 27531,
                         "antidepressant"          => 18038,
                         "antifungal"              => 25615,
                         "antigen"                 => 9353,
                         "antigens"                => 13445,
                         "antigonish"              => 28657,
                         "antigonus"               => 20455,
                         "antillean"               => 28249,
                         "antilles"                => 8917,
                         "antimatter"              => 20508,
                         "antimicrobial"           => 15176,
                         "antimony"                => 17481,
                         "antioch"                 => 6810,
                         "antiochus"               => 13726,
                         "antioquia"               => 17038,
                         "antioxidant"             => 18011,
                         "antioxidants"            => 24348,
                         "antipater"               => 29041,
                         "antipathy"               => 21498,
                         "antipope"                => 23161,
                         "antipsychotic"           => 24184,
                         "antipsychotics"          => 26799,
                         "antiqua"                 => 29010,
                         "antiquarian"             => 10397,
                         "antiquaries"             => 16666,
                         "antiquary"               => 17477,
                         "antiquities"             => 7808,
                         "antiquity"               => 5621,
                         "antiretroviral"          => 26134,
                         "antisemitic"             => 11465,
                         "antisemitism"            => 9945,
                         "antisense"               => 29427,
                         "antisubmarine"           => 13135,
                         "antitank"                => 24191,
                         "antithesis"              => 19343,
                         "antitrust"               => 10985,
                         "antiviral"               => 19575,
                         "antiwar"                 => 24252,
                         "antofagasta"             => 23477,
                         "antonescu"               => 18023,
                         "antonin"                 => 12455,
                         "antonine"                => 26658,
                         "antoninus"               => 22483,
                         "antonis"                 => 25602,
                         "antrim"                  => 8008,
                         "antti"                   => 23046,
                         "antwerp"                 => 5291,
                         "anuradhapura"            => 18397,
                         "anurag"                  => 28935,
                         "anxiolytic"              => 29670,
                         "anyang"                  => 21818,
                         "anzac"                   => 9501,
                         "anzio"                   => 21786,
                         "aomori"                  => 16470,
                         "aortic"                  => 13618,
                         "aosta"                   => 17326,
                         "aoyama"                  => 21905,
                         "apaches"                 => 16807,
                         "apalachicola"            => 26875,
                         "apartheid"               => 6162,
                         "apartments"              => 3466,
                         "apeldoorn"               => 29749,
                         "apennines"               => 23789,
                         "apertura"                => 11004,
                         "aperture"                => 6945,
                         "apertures"               => 23447,
                         "apex"                    => 5351,
                         "aphasia"                 => 20203,
                         "aphid"                   => 23986,
                         "aphids"                  => 19270,
                         "aphorisms"               => 24849,
                         "aphrodite"               => 13346,
                         "apical"                  => 9934,
                         "apnea"                   => 20873,
                         "apocalyptic"             => 9775,
                         "apocrypha"               => 22590,
                         "apocryphal"              => 14674,
                         "apocynaceae"             => 26556,
                         "apoel"                   => 16006,
                         "apolitical"              => 21020,
                         "apollinaire"             => 26170,
                         "apollonia"               => 26802,
                         "apollonius"              => 21459,
                         "apologetics"             => 22816,
                         "apologised"              => 13655,
                         "apologises"              => 24315,
                         "apologist"               => 26583,
                         "apologists"              => 29841,
                         "apoplexy"                => 27820,
                         "apoptosis"               => 10847,
                         "apoptotic"               => 23193,
                         "apostasy"                => 16804,
                         "apostate"                => 22448,
                         "apostle"                 => 7343,
                         "apostles"                => 6801,
                         "apostolate"              => 24331,
                         "apostolic"               => 4712,
                         "apothecaries"            => 28683,
                         "apotheosis"              => 29891,
                         "appalachia"              => 17927,
                         "appalachian"             => 6742,
                         "appalachians"            => 22145,
                         "apparatus"               => 5551,
                         "apparel"                 => 8850,
                         "apparent"                => 2387,
                         "apparitions"             => 18447,
                         "appeal"                  => 1775,
                         "appealed"                => 4415,
                         "appeals"                 => 3102,
                         "appear"                  => 938,
                         "appearance"              => 688,
                         "appearances"             => 900,
                         "appeared"                => 355,
                         "appearing"               => 1981,
                         "appears"                 => 821,
                         "appeasement"             => 21372,
                         "appellant"               => 18018,
                         "appellate"               => 7638,
                         "appellation"             => 11393,
                         "appendages"              => 14891,
                         "appended"                => 13846,
                         "appendices"              => 24091,
                         "appenzell"               => 26324,
                         "appian"                  => 28372,
                         "applauded"               => 12132,
                         "appliances"              => 8265,
                         "applicability"           => 15905,
                         "applicable"              => 5547,
                         "applicant"               => 8305,
                         "applicants"              => 6052,
                         "application"             => 1258,
                         "applications"            => 1322,
                         "applied"                 => 1078,
                         "applies"                 => 4268,
                         "apply"                   => 2264,
                         "applying"                => 4240,
                         "appoint"                 => 6029,
                         "appointed"               => 409,
                         "appointee"               => 17253,
                         "appointees"              => 15967,
                         "appointing"              => 9022,
                         "appoints"                => 11005,
                         "appomattox"              => 15527,
                         "apportioned"             => 17793,
                         "apportionment"           => 17961,
                         "appraisal"               => 11077,
                         "appraisals"              => 28504,
                         "appreciable"             => 21013,
                         "apprentice"              => 5229,
                         "apprenticed"             => 9517,
                         "apprentices"             => 12526,
                         "apprenticeship"          => 7000,
                         "apprenticeships"         => 22286,
                         "approach"                => 1072,
                         "approachable"            => 25525,
                         "approached"              => 2756,
                         "approaches"              => 2819,
                         "approbation"             => 27910,
                         "appropriated"            => 9421,
                         "appropriately"           => 8530,
                         "appropriateness"         => 23989,
                         "appropriating"           => 27661,
                         "appropriation"           => 9591,
                         "appropriations"          => 7735,
                         "approval"                => 2316,
                         "approvals"               => 18407,
                         "approved"                => 1432,
                         "approving"               => 12374,
                         "approx"                  => 7926,
                         "approximant"             => 29524,
                         "approximate"             => 5632,
                         "approximated"            => 13448,
                         "approximately"           => 514,
                         "approximates"            => 22176,
                         "approximating"           => 22552,
                         "approximation"           => 6759,
                         "approximations"          => 15641,
                         "apses"                   => 29321,
                         "apuestas"                => 24014,
                         "apulia"                  => 13545,
                         "aqaba"                   => 23951,
                         "aquabats"                => 29761,
                         "aquaculture"             => 11249,
                         "aquaria"                 => 21618,
                         "aquarii"                 => 28391,
                         "aquarium"                => 6171,
                         "aquariums"               => 16980,
                         "aquatic"                 => 4626,
                         "aquatics"                => 7095,
                         "aqueduct"                => 7834,
                         "aqueducts"               => 18752,
                         "aqueous"                 => 10220,
                         "aquifer"                 => 12963,
                         "aquifers"                => 19047,
                         "aquileia"                => 20376,
                         "aquinas"                 => 9661,
                         "aquitaine"               => 9672,
                         "arab"                    => 1637,
                         "arabesque"               => 26760,
                         "arabi"                   => 17787,
                         "arabia"                  => 3404,
                         "arabian"                 => 5095,
                         "arabic"                  => 2260,
                         "arabica"                 => 29894,
                         "arabidopsis"             => 26432,
                         "arable"                  => 9991,
                         "arabs"                   => 5016,
                         "arafat"                  => 13729,
                         "aragonese"               => 14082,
                         "arakan"                  => 18866,
                         "aramaic"                 => 9087,
                         "araneta"                 => 23896,
                         "arapaho"                 => 19578,
                         "arapahoe"                => 29694,
                         "aravind"                 => 29969,
                         "arbitrage"               => 20690,
                         "arbitrarily"             => 11710,
                         "arbitrary"               => 5464,
                         "arbitration"             => 6402,
                         "arbitrators"             => 27897,
                         "arbitron"                => 24013,
                         "arbor"                   => 7205,
                         "arborea"                 => 23111,
                         "arboreal"                => 12915,
                         "arboretum"               => 8131,
                         "arbroath"                => 16378,
                         "arbuthnot"               => 19304,
                         "arcade"                  => 3905,
                         "arcades"                 => 11125,
                         "arch"                    => 3125,
                         "archaea"                 => 18965,
                         "archaeological"          => 2527,
                         "archaeologically"        => 29113,
                         "archaeologist"           => 6970,
                         "archaeologists"          => 6594,
                         "archaeology"             => 4260,
                         "archaic"                 => 6981,
                         "archangels"              => 29654,
                         "archbishop"              => 2274,
                         "archbishopric"           => 12144,
                         "archbishops"             => 12282,
                         "archdeacon"              => 7985,
                         "archdeaconry"            => 15838,
                         "archdiocesan"            => 25237,
                         "archdiocese"             => 4488,
                         "archduchess"             => 19034,
                         "archduke"                => 9678,
                         "arched"                  => 7008,
                         "archelaus"               => 29207,
                         "archeological"           => 7174,
                         "archeologist"            => 20287,
                         "archeologists"           => 18928,
                         "archeology"              => 14205,
                         "archeparchy"             => 29857,
                         "archers"                 => 9383,
                         "arches"                  => 5392,
                         "archetypal"              => 15273,
                         "archetype"               => 14527,
                         "archetypes"              => 18600,
                         "archiepiscopal"          => 26389,
                         "archimandrite"           => 26521,
                         "archimedean"             => 27741,
                         "archimedes"              => 15270,
                         "arching"                 => 28312,
                         "archipelago"             => 4843,
                         "architect"               => 1480,
                         "architects"              => 2845,
                         "architectural"           => 2111,
                         "architecturally"         => 12089,
                         "architecture"            => 1047,
                         "architectures"           => 10833,
                         "archiv"                  => 17579,
                         "archival"                => 8150,
                         "archive"                 => 3580,
                         "archived"                => 11497,
                         "archives"                => 3003,
                         "archiving"               => 17450,
                         "archivist"               => 13799,
                         "archivists"              => 28209,
                         "archpriest"              => 29368,
                         "arcot"                   => 22585,
                         "arcseconds"              => 27190,
                         "arctic"                  => 3649,
                         "arctiidae"               => 6922,
                         "arcuate"                 => 29608,
                         "ardabil"                 => 11572,
                         "ardahan"                 => 29124,
                         "ardashir"                => 26712,
                         "ardeche"                 => 23121,
                         "ardeidae"                => 26602,
                         "ardennes"                => 11939,
                         "ardent"                  => 9042,
                         "ardrossan"               => 25234,
                         "arduous"                 => 14250,
                         "are"                     => 18,
                         "area"                    => 98,
                         "areal"                   => 27471,
                         "areas"                   => 357,
                         "arecibo"                 => 21331,
                         "arena"                   => 1650,
                         "arenabowl"               => 24505,
                         "arendal"                 => 25113,
                         "arequipa"                => 20186,
                         "arete"                   => 29985,
                         "areva"                   => 26086,
                         "arezzo"                  => 19235,
                         "argentina"               => 1787,
                         "argentine"               => 2820,
                         "argentinean"             => 27181,
                         "argentines"              => 21373,
                         "argentinian"             => 10809,
                         "argentino"               => 16121,
                         "argentinos"              => 22537,
                         "arges"                   => 24987,
                         "arginine"                => 19188,
                         "argonauts"               => 9989,
                         "argonne"                 => 15605,
                         "argos"                   => 12509,
                         "argosy"                  => 26974,
                         "arguably"                => 5237,
                         "argued"                  => 1689,
                         "argues"                  => 3186,
                         "argumentation"           => 21986,
                         "arguments"               => 3646,
                         "argus"                   => 10500,
                         "argyll"                  => 9275,
                         "aria"                    => 5026,
                         "arianism"                => 27796,
                         "ariege"                  => 25046,
                         "arima"                   => 26195,
                         "arion"                   => 21456,
                         "arise"                   => 4979,
                         "arisen"                  => 10008,
                         "arises"                  => 6567,
                         "arising"                 => 6425,
                         "arista"                  => 12834,
                         "aristide"                => 16793,
                         "aristides"               => 27699,
                         "aristocracy"             => 7721,
                         "aristocrat"              => 11219,
                         "aristocratic"            => 6959,
                         "aristocrats"             => 11702,
                         "aristophanes"            => 20728,
                         "aristotelian"            => 15957,
                         "aristotle"               => 6368,
                         "arithmetic"              => 6919,
                         "arjun"                   => 10040,
                         "arjuna"                  => 12801,
                         "arkansas"                => 2025,
                         "arkhangelsk"             => 15706,
                         "arkwright"               => 21375,
                         "arles"                   => 13997,
                         "arlington"               => 4967,
                         "armadale"                => 25037,
                         "armagh"                  => 8225,
                         "armagnac"                => 27019,
                         "armament"                => 5360,
                         "armaments"               => 11831,
                         "armature"                => 22453,
                         "armband"                 => 24367,
                         "armbar"                  => 25005,
                         "armed"                   => 1264,
                         "armee"                   => 12729,
                         "armenia"                 => 3638,
                         "armenian"                => 2640,
                         "armenians"               => 6718,
                         "armia"                   => 24673,
                         "armidale"                => 20914,
                         "armies"                  => 3080,
                         "armin"                   => 14659,
                         "arminius"                => 29788,
                         "armistice"               => 6523,
                         "armor"                   => 3770,
                         "armored"                 => 4218,
                         "armorial"                => 21417,
                         "armory"                  => 8800,
                         "armoured"                => 3952,
                         "armoury"                 => 18448,
                         "army"                    => 214,
                         "arnaldo"                 => 24306,
                         "arnaz"                   => 25111,
                         "arnulf"                  => 18805,
                         "aromanian"               => 29522,
                         "aromas"                  => 27630,
                         "aromatic"                => 8656,
                         "aroostook"               => 25438,
                         "arose"                   => 3784,
                         "arousal"                 => 13518,
                         "arpad"                   => 20010,
                         "arpanet"                 => 28498,
                         "arran"                   => 14314,
                         "arranged"                => 1938,
                         "arrangement"             => 2511,
                         "arranger"                => 7758,
                         "arrangers"               => 27276,
                         "arranges"                => 9357,
                         "arras"                   => 12500,
                         "array"                   => 3356,
                         "arrayed"                 => 23996,
                         "arrays"                  => 8887,
                         "arrears"                 => 18444,
                         "arrests"                 => 6061,
                         "arrhythmias"             => 27880,
                         "arrival"                 => 1845,
                         "arrivals"                => 9565,
                         "arrived"                 => 920,
                         "arrives"                 => 3063,
                         "arriving"                => 2539,
                         "arrondissement"          => 6676,
                         "arrondissements"         => 20350,
                         "arrowheads"              => 24148,
                         "arsenals"                => 29779,
                         "arsene"                  => 20818,
                         "arsenio"                 => 23352,
                         "arshad"                  => 27635,
                         "art"                     => 253,
                         "artaxerxes"              => 24562,
                         "artefacts"               => 8805,
                         "artemisia"               => 16078,
                         "arterial"                => 8388,
                         "artes"                   => 11326,
                         "artesian"                => 24420,
                         "arthritis"               => 9710,
                         "arthropod"               => 23331,
                         "arthropods"              => 12530,
                         "arthurian"               => 15098,
                         "article"                 => 843,
                         "articled"                => 20053,
                         "articles"                => 1281,
                         "articular"               => 20409,
                         "articulated"             => 7456,
                         "articulates"             => 26294,
                         "articulating"            => 24334,
                         "articulation"            => 10025,
                         "artifacts"               => 3869,
                         "artificial"              => 2893,
                         "artificially"            => 10192,
                         "artigas"                 => 24844,
                         "artillery"               => 1600,
                         "artin"                   => 24178,
                         "artisan"                 => 12061,
                         "artisanal"               => 22420,
                         "artisans"                => 8767,
                         "artist"                  => 597,
                         "artiste"                 => 16415,
                         "artistes"                => 13509,
                         "artistic"                => 1883,
                         "artistically"            => 14351,
                         "artistry"                => 12198,
                         "artists"                 => 644,
                         "artois"                  => 15469,
                         "arts"                    => 448,
                         "artvin"                  => 29730,
                         "artwork"                 => 3171,
                         "artworks"                => 8053,
                         "aruna"                   => 22736,
                         "arunachal"               => 14283,
                         "arundel"                 => 9598,
                         "arundell"                => 22094,
                         "arusha"                  => 22730,
                         "arvid"                   => 23320,
                         "aryeh"                   => 24798,
                         "as"                      => 8,
                         "asahi"                   => 12117,
                         "asami"                   => 28135,
                         "asana"                   => 29995,
                         "asansol"                 => 24734,
                         "asante"                  => 19585,
                         "asaph"                   => 21428,
                         "ascap"                   => 13439,
                         "ascend"                  => 11292,
                         "ascendancy"              => 15650,
                         "ascendant"               => 25719,
                         "ascended"                => 7956,
                         "ascending"               => 8160,
                         "ascends"                 => 15868,
                         "ascenso"                 => 22984,
                         "ascent"                  => 6454,
                         "ascents"                 => 15581,
                         "ascertained"             => 17260,
                         "ascetic"                 => 13149,
                         "asceticism"              => 22013,
                         "ascetics"                => 26941,
                         "aschaffenburg"           => 24822,
                         "ascii"                   => 10813,
                         "ascoli"                  => 18261,
                         "ascomycota"              => 27603,
                         "ascot"                   => 9660,
                         "ascribe"                 => 23435,
                         "ascribed"                => 8794,
                         "ascribes"                => 26119,
                         "asean"                   => 9815,
                         "asesoria"                => 24493,
                         "asexual"                 => 16775,
                         "asghar"                  => 23941,
                         "ashbourne"               => 22558,
                         "ashburnham"              => 27883,
                         "ashburton"               => 18058,
                         "ashbury"                 => 26789,
                         "ashdod"                  => 21199,
                         "ashdown"                 => 19256,
                         "asheville"               => 11307,
                         "ashfield"                => 16651,
                         "ashgabat"                => 29064,
                         "ashikaga"                => 19336,
                         "ashina"                  => 21316,
                         "ashkelon"                => 22614,
                         "ashkenazi"               => 11540,
                         "ashland"                 => 9216,
                         "ashlar"                  => 14022,
                         "ashok"                   => 10390,
                         "ashoka"                  => 13565,
                         "ashore"                  => 6096,
                         "ashot"                   => 27755,
                         "ashraf"                  => 13173,
                         "ashram"                  => 10548,
                         "ashtabula"               => 24803,
                         "ashur"                   => 26456,
                         "asia"                    => 996,
                         "asia/oceania"            => 22826,
                         "asian"                   => 928,
                         "asiatic"                 => 8509,
                         "asistencia"              => 22455,
                         "asker"                   => 20485,
                         "asociacion"              => 15442,
                         "aspartate"               => 26256,
                         "aspect"                  => 2882,
                         "aspects"                 => 1837,
                         "asperger"                => 21826,
                         "aspergillus"             => 19313,
                         "asphalt"                 => 7045,
                         "aspinall"                => 23060,
                         "aspirated"               => 13532,
                         "aspiration"              => 12385,
                         "aspirations"             => 8045,
                         "aspired"                 => 15466,
                         "aspires"                 => 20159,
                         "aspiring"                => 7749,
                         "asquith"                 => 14142,
                         "assad"                   => 9475,
                         "assailants"              => 16428,
                         "assailed"                => 29408,
                         "assam"                   => 5711,
                         "assamese"                => 11800,
                         "assange"                 => 23663,
                         "assassinate"             => 8885,
                         "assassinated"            => 5866,
                         "assassinating"           => 23717,
                         "assassination"           => 3506,
                         "assassinations"          => 13060,
                         "assault"                 => 2251,
                         "assaults"                => 7965,
                         "assay"                   => 11684,
                         "assays"                  => 16704,
                         "assemblage"              => 12022,
                         "assemblages"             => 20022,
                         "assembled"               => 3448,
                         "assembles"               => 20134,
                         "assemblies"              => 6025,
                         "assembling"              => 10722,
                         "assembly"                => 643,
                         "assemblyman"             => 13625,
                         "assemblymen"             => 23578,
                         "assen"                   => 26071,
                         "assent"                  => 9946,
                         "assert"                  => 7388,
                         "asserted"                => 4925,
                         "asserting"               => 9118,
                         "assertion"               => 8181,
                         "assertions"              => 12301,
                         "asserts"                 => 6794,
                         "assess"                  => 5703,
                         "assessed"                => 5319,
                         "assesses"                => 18498,
                         "assessing"               => 8681,
                         "assessment"              => 2687,
                         "assessments"             => 7264,
                         "assessor"                => 14528,
                         "assessors"               => 25745,
                         "asset"                   => 4255,
                         "assets"                  => 2372,
                         "assigned"                => 1059,
                         "assigns"                 => 8537,
                         "assimilate"              => 16111,
                         "assimilated"             => 9595,
                         "assimilating"            => 29019,
                         "assimilation"            => 8830,
                         "assiniboine"             => 20499,
                         "assis"                   => 27518,
                         "assisi"                  => 13158,
                         "assist"                  => 2261,
                         "assistance"              => 1743,
                         "assistant"               => 877,
                         "assistants"              => 6628,
                         "assisted"                => 2402,
                         "assisting"               => 5171,
                         "assistive"               => 26189,
                         "assists"                 => 3053,
                         "assize"                  => 25958,
                         "assizes"                 => 23197,
                         "associacao"              => 17322,
                         "associate"               => 1819,
                         "associated"              => 655,
                         "associates"              => 3295,
                         "association"             => 286,
                         "associations"            => 2935,
                         "associative"             => 12696,
                         "associazione"            => 21870,
                         "assortment"              => 10733,
                         "assumed"                 => 1838,
                         "assumes"                 => 5936,
                         "assumption"              => 4321,
                         "assur"                   => 28542,
                         "assyria"                 => 12434,
                         "assyrian"                => 6854,
                         "assyrians"               => 11968,
                         "asteraceae"              => 16586,
                         "asterisk"                => 13122,
                         "asterism"                => 24170,
                         "astern"                  => 20828,
                         "asteroid"                => 5717,
                         "asteroids"               => 10257,
                         "astley"                  => 13693,
                         "astonishingly"           => 29296,
                         "astor"                   => 9252,
                         "astragalus"              => 21495,
                         "astrakhan"               => 18087,
                         "astride"                 => 20579,
                         "astrocytes"              => 28306,
                         "astrodome"               => 26779,
                         "astrolabe"               => 26437,
                         "astrologer"              => 16712,
                         "astrologers"             => 21842,
                         "astrological"            => 14821,
                         "astrology"               => 9436,
                         "astronautics"            => 21237,
                         "astronomer"              => 6381,
                         "astronomers"             => 8988,
                         "astronomical"            => 4956,
                         "astronomy"               => 4508,
                         "astrophysical"           => 19152,
                         "astrophysicist"          => 22973,
                         "astrophysics"            => 11591,
                         "asturian"                => 18838,
                         "asturias"                => 8742,
                         "asuka"                   => 18391,
                         "asura"                   => 18174,
                         "aswan"                   => 24149,
                         "asylum"                  => 4407,
                         "asylums"                 => 21888,
                         "asymmetric"              => 10061,
                         "asymmetrical"            => 12655,
                         "asymmetry"               => 15861,
                         "asymptomatic"            => 18216,
                         "asymptotic"              => 14953,
                         "asymptotically"          => 23267,
                         "asynchronous"            => 14136,
                         "at"                      => 13,
                         "atacama"                 => 20825,
                         "atalanta"                => 15910,
                         "atari"                   => 6648,
                         "ataturk"                 => 13345,
                         "ataxia"                  => 19543,
                         "atelier"                 => 13071,
                         "ateliers"                => 29327,
                         "ateneo"                  => 11193,
                         "athabasca"               => 17251,
                         "athabaskan"              => 24198,
                         "athanasius"              => 15653,
                         "atheism"                 => 12030,
                         "atheist"                 => 7878,
                         "atheistic"               => 26150,
                         "athenaeum"               => 14168,
                         "athenian"                => 8899,
                         "athenians"               => 13102,
                         "athenry"                 => 29450,
                         "athens"                  => 2548,
                         "atherosclerosis"         => 21902,
                         "athlete"                 => 2924,
                         "athletes"                => 2377,
                         "athletic"                => 1460,
                         "athleticism"             => 23649,
                         "athletics"               => 1482,
                         "athlone"                 => 16825,
                         "athol"                   => 19874,
                         "atholl"                  => 19486,
                         "atlante"                 => 26301,
                         "atlantean"               => 28943,
                         "atlantic"                => 1168,
                         "atlantica"               => 29614,
                         "atlantique"              => 20072,
                         "atlantiques"             => 22000,
                         "atlas"                   => 4614,
                         "atlases"                 => 25419,
                         "atletico"                => 5986,
                         "atman"                   => 20798,
                         "atmosphere"              => 2713,
                         "atmospheres"             => 16943,
                         "atmospheric"             => 4522,
                         "atoll"                   => 7130,
                         "atolls"                  => 18690,
                         "atom"                    => 5082,
                         "atoms"                   => 4672,
                         "atonement"               => 13113,
                         "atop"                    => 5060,
                         "atpase"                  => 19021,
                         "atria"                   => 25077,
                         "atrial"                  => 15963,
                         "atrium"                  => 10050,
                         "atrocities"              => 8302,
                         "atsushi"                 => 23020,
                         "attache"                 => 10332,
                         "attached"                => 1751,
                         "attaches"                => 12250,
                         "attaching"               => 11958,
                         "attachment"              => 5453,
                         "attack"                  => 533,
                         "attacked"                => 1399,
                         "attackers"               => 7586,
                         "attacking"               => 2963,
                         "attacks"                 => 1227,
                         "attain"                  => 6606,
                         "attainable"              => 22249,
                         "attainder"               => 23127,
                         "attained"                => 4402,
                         "attaining"               => 8492,
                         "attainment"              => 11972,
                         "attains"                 => 14561,
                         "attempt"                 => 842,
                         "attempted"               => 1389,
                         "attempting"              => 2690,
                         "attempts"                => 1318,
                         "attenborough"            => 15575,
                         "attend"                  => 1762,
                         "attendance"              => 2702,
                         "attendances"             => 12722,
                         "attended"                => 606,
                         "attendee"                => 27981,
                         "attendees"               => 7190,
                         "attending"               => 2367,
                         "attends"                 => 7928,
                         "attentional"             => 25455,
                         "attenuated"              => 19120,
                         "attenuation"             => 15382,
                         "attestation"             => 23332,
                         "attested"                => 6502,
                         "attesting"               => 25683,
                         "attests"                 => 22343,
                         "attire"                  => 9185,
                         "attitudes"               => 5034,
                         "attlee"                  => 20077,
                         "attock"                  => 26315,
                         "attract"                 => 3734,
                         "attracting"              => 5570,
                         "attraction"              => 3257,
                         "attractions"             => 3760,
                         "attractiveness"          => 16008,
                         "attracts"                => 6014,
                         "attributable"            => 12278,
                         "attribute"               => 6580,
                         "attributed"              => 2332,
                         "attributes"              => 4360,
                         "attributing"             => 15858,
                         "attribution"             => 8299,
                         "attributions"            => 22216,
                         "attrition"               => 12596,
                         "atypical"                => 11530,
                         "auchinleck"              => 29053,
                         "auckland"                => 3184,
                         "auctioned"               => 10419,
                         "auctions"                => 10888,
                         "audacious"               => 18364,
                         "audax"                   => 28228,
                         "auden"                   => 18410,
                         "audible"                 => 11772,
                         "audience"                => 1285,
                         "audiences"               => 3259,
                         "audiencia"               => 18611,
                         "audio"                   => 1906,
                         "audiobook"               => 16317,
                         "audiobooks"              => 21252,
                         "audiovisual"             => 14123,
                         "audit"                   => 5821,
                         "auditing"                => 12673,
                         "auditioned"              => 7489,
                         "auditor"                 => 7438,
                         "auditorium"              => 4367,
                         "auditoriums"             => 25301,
                         "auditors"                => 13841,
                         "auditory"                => 9114,
                         "audits"                  => 14218,
                         "audley"                  => 17661,
                         "audubon"                 => 11596,
                         "augment"                 => 11798,
                         "augmentation"            => 15694,
                         "augmented"               => 6828,
                         "augmenting"              => 22342,
                         "augsburg"                => 8206,
                         "august"                  => 161,
                         "augustan"                => 23667,
                         "augustana"               => 25918,
                         "augustinian"             => 10793,
                         "augustinians"            => 23829,
                         "augustow"                => 26177,
                         "aulus"                   => 25130,
                         "aural"                   => 18727,
                         "aurangabad"              => 16484,
                         "aurangzeb"               => 14059,
                         "aurel"                   => 26473,
                         "aurelian"                => 21571,
                         "aureus"                  => 17335,
                         "aurobindo"               => 20286,
                         "auschwitz"               => 8372,
                         "auspices"                => 6792,
                         "auspicious"              => 13255,
                         "austen"                  => 9316,
                         "austere"                 => 13546,
                         "austerity"               => 12013,
                         "austerlitz"              => 25970,
                         "austral"                 => 18347,
                         "australasia"             => 10440,
                         "australasian"            => 9909,
                         "australia"               => 328,
                         "australian"              => 403,
                         "australians"             => 5361,
                         "australis"               => 12852,
                         "austria"                 => 1555,
                         "austrian"                => 1960,
                         "austrians"               => 8926,
                         "austro"                  => 6012,
                         "austronesian"            => 14202,
                         "authentically"           => 29026,
                         "authenticated"           => 18545,
                         "authentication"          => 9366,
                         "authenticity"            => 7406,
                         "author"                  => 656,
                         "authored"                => 3070,
                         "authoring"               => 12856,
                         "authorisation"           => 15773,
                         "authorise"               => 26654,
                         "authorised"              => 6791,
                         "authorising"             => 22849,
                         "authoritarian"           => 8878,
                         "authoritarianism"        => 22510,
                         "authoritative"           => 8852,
                         "authorities"             => 1284,
                         "authority"               => 860,
                         "authorized"              => 3247,
                         "authorizing"             => 12400,
                         "authors"                 => 1891,
                         "authorship"              => 7870,
                         "autism"                  => 6889,
                         "autistic"                => 13085,
                         "auto"                    => 3029,
                         "autobiographical"        => 6414,
                         "autobiographies"         => 22960,
                         "autobiography"           => 3879,
                         "autobots"                => 10129,
                         "autocephalous"           => 27087,
                         "autochthonous"           => 27282,
                         "autocracy"               => 27609,
                         "autocratic"              => 16210,
                         "autodesk"                => 22005,
                         "autodromo"               => 22163,
                         "autofocus"               => 22621,
                         "autoimmune"              => 12646,
                         "automaker"               => 18518,
                         "automakers"              => 19602,
                         "automata"                => 15634,
                         "automate"                => 18706,
                         "automated"               => 4687,
                         "automatic"               => 2449,
                         "automatically"           => 3361,
                         "automation"              => 6826,
                         "automaton"               => 14261,
                         "automobile"              => 3330,
                         "automobiles"             => 6428,
                         "automorphism"            => 18287,
                         "automorphisms"           => 29602,
                         "automotive"              => 4554,
                         "autonoma"                => 17894,
                         "autonomic"               => 16875,
                         "autonomist"              => 26476,
                         "autonomous"              => 2780,
                         "autonomously"            => 20084,
                         "autonomy"                => 4461,
                         "autoroute"               => 14614,
                         "autos"                   => 25172,
                         "autosomal"               => 12115,
                         "autosport"               => 28962,
                         "autovia"                 => 26052,
                         "auvergne"                => 13886,
                         "auxerre"                 => 17573,
                         "auxiliaries"             => 14170,
                         "auxiliary"               => 3733,
                         "avail"                   => 9942,
                         "availability"            => 3724,
                         "available"               => 397,
                         "avalanches"              => 20228,
                         "avars"                   => 18978,
                         "avatars"                 => 15117,
                         "aveiro"                  => 25331,
                         "avellino"                => 20568,
                         "avengers"                => 5921,
                         "avenida"                 => 12870,
                         "avenue"                  => 976,
                         "avenues"                 => 7391,
                         "average"                 => 351,
                         "averaged"                => 4110,
                         "averages"                => 6811,
                         "averaging"               => 5208,
                         "avesta"                  => 27418,
                         "avestan"                 => 23077,
                         "aveyron"                 => 24398,
                         "avian"                   => 11133,
                         "aviation"                => 1824,
                         "aviators"                => 12517,
                         "avicenna"                => 20919,
                         "avicii"                  => 28428,
                         "avignon"                 => 11174,
                         "avionics"                => 12810,
                         "aviv"                    => 4912,
                         "avoca"                   => 22081,
                         "avocets"                 => 27463,
                         "avoidance"               => 8961,
                         "avoided"                 => 4344,
                         "avoids"                  => 9119,
                         "avonmouth"               => 27879,
                         "avowed"                  => 22274,
                         "avraham"                 => 15915,
                         "avram"                   => 28148,
                         "awadh"                   => 24248,
                         "awaited"                 => 9227,
                         "awakening"               => 7414,
                         "awakens"                 => 11893,
                         "awami"                   => 16056,
                         "award"                   => 255,
                         "awarded"                 => 517,
                         "awardee"                 => 25828,
                         "awardees"                => 23212,
                         "awarding"                => 7285,
                         "awards"                  => 396,
                         "awareness"               => 2630,
                         "awash"                   => 26215,
                         "awlaki"                  => 27800,
                         "axial"                   => 9192,
                         "axillary"                => 20977,
                         "axils"                   => 23190,
                         "axiom"                   => 10042,
                         "axiomatic"               => 22384,
                         "axioms"                  => 10607,
                         "axis"                    => 2821,
                         "axles"                   => 10884,
                         "axonal"                  => 26338,
                         "axons"                   => 15177,
                         "ayacucho"                => 23849,
                         "ayatollah"               => 12283,
                         "ayckbourn"               => 29912,
                         "aydin"                   => 15192,
                         "aykroyd"                 => 23609,
                         "aylesbury"               => 12257,
                         "aylmer"                  => 18093,
                         "ayman"                   => 25208,
                         "aymara"                  => 15220,
                         "ayodhya"                 => 19013,
                         "ayrshire"                => 9604,
                         "ayumi"                   => 19344,
                         "ayurveda"                => 16505,
                         "ayurvedic"               => 17098,
                         "ayutthaya"               => 15454,
                         "ayyavazhi"               => 27881,
                         "ayyubid"                 => 22917,
                         "azadegan"                => 22956,
                         "azarenka"                => 19917,
                         "azaria"                  => 29909,
                         "azerbaijan"              => 2844,
                         "azerbaijani"             => 7344,
                         "azerbaijanis"            => 22998,
                         "azeri"                   => 14833,
                         "azeris"                  => 29617,
                         "azhar"                   => 15134,
                         "aznar"                   => 28025,
                         "azores"                  => 8846,
                         "azuma"                   => 26912,
                         "azusa"                   => 20099,
                         "b'nai"                   => 18852,
                         "b.i.g"                   => 28742,
                         "b.o.b"                   => 24890,
                         "b.tech"                  => 22945,
                         "b/hip"                   => 8169,
                         "b/soul"                  => 28871,
                         "b0d3fb"                  => 23994,
                         "ba'al"                   => 29092,
                         "ba'ath"                  => 14466,
                         "ba'athist"               => 27848,
                         "baba"                    => 5331,
                         "babangida"               => 28534,
                         "babar"                   => 19815,
                         "babbage"                 => 24347,
                         "babbler"                 => 21794,
                         "babol"                   => 23871,
                         "babur"                   => 17327,
                         "babylonia"               => 16709,
                         "babylonian"              => 8662,
                         "babylonians"             => 23102,
                         "bacau"                   => 27892,
                         "baccalaureat"            => 28206,
                         "baccalaureate"           => 8577,
                         "bacharach"               => 18703,
                         "bachata"                 => 26461,
                         "bachchan"                => 13264,
                         "bachelor"                => 1642,
                         "bacillus"                => 17047,
                         "backa"                   => 18375,
                         "backbench"               => 22983,
                         "backbencher"             => 27637,
                         "backcountry"             => 18671,
                         "backdrop"                => 7304,
                         "backdrops"               => 24046,
                         "backed"                  => 2936,
                         "backend"                 => 27219,
                         "backfield"               => 18516,
                         "background"              => 700,
                         "backgrounds"             => 5463,
                         "backhouse"               => 29348,
                         "backing"                 => 3117,
                         "backstory"               => 12723,
                         "backstretch"             => 29685,
                         "backstroke"              => 8198,
                         "backward"                => 6593,
                         "backwaters"              => 26095,
                         "bacolod"                 => 21795,
                         "bacteria"                => 3706,
                         "bacterial"               => 6215,
                         "bacteriology"            => 23133,
                         "bacterium"               => 9987,
                         "bactria"                 => 24793,
                         "bactrian"                => 24127,
                         "badajoz"                 => 16413,
                         "badakhshan"              => 22887,
                         "badami"                  => 28547,
                         "badawi"                  => 25122,
                         "baddeley"                => 29596,
                         "baden"                   => 4445,
                         "badged"                  => 17815,
                         "badging"                 => 29659,
                         "badminton"               => 5837,
                         "badri"                   => 29302,
                         "baekje"                  => 16678,
                         "baerum"                  => 21551,
                         "baffin"                  => 17933,
                         "bafta"                   => 7946,
                         "bagan"                   => 15089,
                         "baghdad"                 => 5048,
                         "baghdadi"                => 22863,
                         "bagmati"                 => 29563,
                         "bagot"                   => 22723,
                         "bagram"                  => 24535,
                         "bagrat"                  => 25557,
                         "bagration"               => 21715,
                         "baguio"                  => 18501,
                         "baha'i"                  => 6654,
                         "baha'is"                 => 9876,
                         "baha'u'llah"             => 14909,
                         "bahadur"                 => 8167,
                         "bahamian"                => 17455,
                         "bahasa"                  => 28572,
                         "bahawalpur"              => 22412,
                         "bahia"                   => 7912,
                         "bahini"                  => 28184,
                         "bahman"                  => 25354,
                         "bahn"                    => 5741,
                         "bahnhof"                 => 23347,
                         "bahrain"                 => 5528,
                         "bahraini"                => 14067,
                         "bahru"                   => 18729,
                         "baikonur"                => 22872,
                         "bailiwick"               => 21527,
                         "bainimarama"             => 23607,
                         "baits"                   => 29121,
                         "bajaj"                   => 22174,
                         "bajnoksag"               => 17202,
                         "bakar"                   => 21071,
                         "bakeries"                => 16093,
                         "bakersfield"             => 9967,
                         "bakhsh"                  => 15578,
                         "bakhtiari"               => 16727,
                         "bakri"                   => 26070,
                         "bakufu"                  => 24965,
                         "bakunin"                 => 24543,
                         "balaclava"               => 28975,
                         "balad"                   => 27138,
                         "balaji"                  => 16177,
                         "balakrishnan"            => 28156,
                         "balan"                   => 19037,
                         "balanced"                => 5028,
                         "balances"                => 11762,
                         "balanchine"              => 17907,
                         "balancing"               => 8287,
                         "balconies"               => 13273,
                         "balearic"                => 14770,
                         "balikpapan"              => 25936,
                         "balinese"                => 14895,
                         "balkan"                  => 6177,
                         "balkans"                 => 6796,
                         "balked"                  => 27795,
                         "balkh"                   => 24157,
                         "ballad"                  => 4322,
                         "ballade"                 => 29978,
                         "ballads"                 => 6536,
                         "ballarat"                => 10151,
                         "ballast"                 => 9582,
                         "ballet"                  => 2583,
                         "ballets"                 => 11064,
                         "ballina"                 => 27918,
                         "balliol"                 => 11834,
                         "ballo"                   => 26030,
                         "ballooning"              => 27208,
                         "ballot"                  => 3696,
                         "balloting"               => 15827,
                         "ballots"                 => 5388,
                         "ballymena"               => 20254,
                         "balmain"                 => 13540,
                         "baloch"                  => 13725,
                         "balochi"                 => 29739,
                         "balochistan"             => 10377,
                         "baloncesto"              => 22057,
                         "balsa"                   => 23434,
                         "balthasar"               => 19396,
                         "balti"                   => 24358,
                         "baltic"                  => 3891,
                         "baltimore"               => 1948,
                         "baltistan"               => 20050,
                         "balto"                   => 25003,
                         "baluchestan"             => 12759,
                         "baluchistan"             => 21137,
                         "balustrade"              => 15576,
                         "balustrades"             => 27710,
                         "bamako"                  => 18796,
                         "bambara"                 => 29665,
                         "bamberg"                 => 13004,
                         "bampton"                 => 28070,
                         "banaras"                 => 23580,
                         "banat"                   => 12880,
                         "banbury"                 => 13494,
                         "banca"                   => 18728,
                         "banco"                   => 9635,
                         "bancorp"                 => 26999,
                         "band"                    => 155,
                         "bandai"                  => 12571,
                         "bandar"                  => 10376,
                         "bandaranaike"            => 24757,
                         "bande"                   => 26822,
                         "banded"                  => 9362,
                         "banding"                 => 15483,
                         "bandini"                 => 25006,
                         "bandits"                 => 7637,
                         "bandleader"              => 11392,
                         "bandmaster"              => 29622,
                         "bandmate"                => 13293,
                         "bandmates"               => 13478,
                         "bando"                   => 29907,
                         "bandon"                  => 23140,
                         "bandra"                  => 20183,
                         "bands"                   => 1342,
                         "bandstand"               => 14182,
                         "bandura"                 => 23828,
                         "bandwidth"               => 6793,
                         "banff"                   => 12240,
                         "banga"                   => 27223,
                         "bangalore"               => 4957,
                         "bangla"                  => 14026,
                         "bangladesh"              => 2529,
                         "bangladeshi"             => 8587,
                         "bangladeshis"            => 27626,
                         "bangor"                  => 7556,
                         "bangui"                  => 25150,
                         "banishment"              => 16237,
                         "banja"                   => 14551,
                         "banjo"                   => 7825,
                         "bank"                    => 498,
                         "banka"                   => 23977,
                         "banked"                  => 15461,
                         "bankers"                 => 8779,
                         "banking"                 => 2797,
                         "banknote"                => 14949,
                         "banknotes"               => 9101,
                         "bankruptcy"              => 3542,
                         "banksia"                 => 9948,
                         "bankstown"               => 14653,
                         "banksy"                  => 29732,
                         "bankura"                 => 27716,
                         "banned"                  => 2684,
                         "banners"                 => 8818,
                         "bannock"                 => 28821,
                         "bannockburn"             => 27093,
                         "banovina"                => 23820,
                         "banque"                  => 15660,
                         "banqueting"              => 27043,
                         "banquets"                => 18557,
                         "banshees"                => 22115,
                         "banska"                  => 16867,
                         "bantamweight"            => 10579,
                         "banten"                  => 27702,
                         "bantu"                   => 10574,
                         "baoding"                 => 29206,
                         "baptised"                => 9310,
                         "baptismal"               => 13311,
                         "baptisms"                => 19573,
                         "baptist"                 => 2464,
                         "baptistery"              => 25297,
                         "baptists"                => 10305,
                         "barack"                  => 4862,
                         "barangay"                => 8076,
                         "barangays"               => 8554,
                         "baranja"                 => 28950,
                         "barat"                   => 22454,
                         "barbadian"               => 19709,
                         "barbarism"               => 26580,
                         "barbarossa"              => 11019,
                         "barbarous"               => 29008,
                         "barbary"                 => 13429,
                         "barbed"                  => 10449,
                         "barberini"               => 19972,
                         "barbet"                  => 27513,
                         "barbettes"               => 29556,
                         "barbican"                => 15438,
                         "barbuda"                 => 13359,
                         "barbus"                  => 19752,
                         "barda"                   => 22774,
                         "bardhaman"               => 24071,
                         "bardic"                  => 27419,
                         "bards"                   => 19618,
                         "bardstown"               => 29769,
                         "bareilly"                => 21505,
                         "barenaked"               => 28678,
                         "barents"                 => 21990,
                         "barges"                  => 9272,
                         "baring"                  => 14882,
                         "barisal"                 => 17177,
                         "barisan"                 => 18786,
                         "barium"                  => 15450,
                         "barnabas"                => 13397,
                         "barnacles"               => 29527,
                         "barnegat"                => 27069,
                         "barnet"                  => 8901,
                         "barneveld"               => 23487,
                         "barnsley"                => 8033,
                         "barnstable"              => 20060,
                         "barnstaple"              => 15846,
                         "barnstormers"            => 27167,
                         "baroda"                  => 14804,
                         "barometric"              => 18210,
                         "baroness"                => 7890,
                         "baronet"                 => 3418,
                         "baronetage"              => 9628,
                         "baronetcies"             => 27277,
                         "baronetcy"               => 7625,
                         "baronets"                => 8422,
                         "baronial"                => 19358,
                         "baronies"                => 18922,
                         "barons"                  => 7248,
                         "barony"                  => 6427,
                         "baroque"                 => 3778,
                         "barque"                  => 17570,
                         "barrack"                 => 19146,
                         "barracks"                => 4000,
                         "barrages"                => 28057,
                         "barranquilla"            => 21129,
                         "barred"                  => 6475,
                         "barrels"                 => 6420,
                         "barrens"                 => 21945,
                         "barrichello"             => 15416,
                         "barrier"                 => 3748,
                         "barriers"                => 5456,
                         "barrio"                  => 8798,
                         "barrister"               => 6956,
                         "barristers"              => 17483,
                         "barrymore"               => 11585,
                         "barthes"                 => 28818,
                         "bartin"                  => 26384,
                         "bartoli"                 => 21700,
                         "barua"                   => 27028,
                         "baruch"                  => 13242,
                         "barwon"                  => 28855,
                         "barzani"                 => 26336,
                         "basal"                   => 5118,
                         "basalt"                  => 9251,
                         "basaltic"                => 16127,
                         "basalts"                 => 24117,
                         "bascule"                 => 26404,
                         "base"                    => 501,
                         "based"                   => 125,
                         "basel"                   => 5391,
                         "baseline"                => 8748,
                         "baseman"                 => 6258,
                         "basemen"                 => 25621,
                         "bases"                   => 2589,
                         "basescu"                 => 23579,
                         "bashar"                  => 17631,
                         "bashkortostan"           => 21972,
                         "basho"                   => 29110,
                         "basic"                   => 1097,
                         "basidia"                 => 28722,
                         "basie"                   => 15252,
                         "basilan"                 => 21065,
                         "basildon"                => 22045,
                         "basilica"                => 4966,
                         "basilicas"               => 29144,
                         "basilicata"              => 25956,
                         "basin"                   => 2082,
                         "basingstoke"             => 14383,
                         "basins"                  => 7654,
                         "basis"                   => 960,
                         "basketball"              => 711,
                         "basque"                  => 4914,
                         "basques"                 => 19685,
                         "basra"                   => 12312,
                         "bassa"                   => 28820,
                         "bassano"                 => 22298,
                         "basse"                   => 15092,
                         "bassist"                 => 3386,
                         "bassists"                => 23243,
                         "bassoons"                => 20783,
                         "basti"                   => 25443,
                         "bastia"                  => 18625,
                         "bastion"                 => 10286,
                         "bastions"                => 15989,
                         "bataan"                  => 14425,
                         "bataille"                => 26269,
                         "bataillon"               => 27695,
                         "batang"                  => 24047,
                         "batangas"                => 16626,
                         "batavia"                 => 9732,
                         "batavian"                => 19743,
                         "batches"                 => 13154,
                         "bathhouse"               => 18596,
                         "bathurst"                => 7769,
                         "batik"                   => 25425,
                         "batley"                  => 20767,
                         "baton"                   => 5762,
                         "batons"                  => 22113,
                         "bats"                    => 3997,
                         "batsman"                 => 4421,
                         "batsmen"                 => 9656,
                         "battalion"               => 1332,
                         "battalions"              => 3749,
                         "batted"                  => 3947,
                         "battenberg"              => 29245,
                         "batters"                 => 7907,
                         "battersea"               => 14012,
                         "battery"                 => 2195,
                         "batticaloa"              => 24034,
                         "batting"                 => 2850,
                         "battle"                  => 339,
                         "battlecruiser"           => 15510,
                         "battlecruisers"          => 15630,
                         "battled"                 => 7616,
                         "battlefield"             => 4229,
                         "battlefields"            => 15686,
                         "battlements"             => 20564,
                         "battleship"              => 5955,
                         "battleships"             => 7186,
                         "battlestar"              => 15338,
                         "batumi"                  => 25796,
                         "bautzen"                 => 27509,
                         "bauxite"                 => 18616,
                         "bavaria"                 => 3923,
                         "bavarian"                => 5422,
                         "bay"                     => 532,
                         "bayan"                   => 13390,
                         "bayburt"                 => 29401,
                         "bayerische"              => 26230,
                         "bayernliga"              => 25059,
                         "bayesian"                => 13472,
                         "bayeux"                  => 21098,
                         "bayezid"                 => 23714,
                         "bayfield"                => 28425,
                         "bayonet"                 => 11889,
                         "bayonets"                => 18402,
                         "bayonne"                 => 12930,
                         "bayou"                   => 9177,
                         "bayreuth"                => 12926,
                         "bayswater"               => 24885,
                         "bazaar"                  => 8136,
                         "bazaars"                 => 29201,
                         "bazar"                   => 10781,
                         "bbwaa"                   => 25806,
                         "be'er"                   => 25446,
                         "beachhead"               => 17314,
                         "beacons"                 => 14295,
                         "beaconsfield"            => 20178,
                         "beaked"                  => 21022,
                         "beams"                   => 6272,
                         "beano"                   => 22957,
                         "bearers"                 => 9629,
                         "bearing"                 => 2915,
                         "bearn"                   => 20984,
                         "bears"                   => 2075,
                         "beaten"                  => 3101,
                         "beatification"           => 15825,
                         "beatified"               => 16082,
                         "beatrix"                 => 14130,
                         "beatz"                   => 24450,
                         "beaufort"                => 8251,
                         "beauharnais"             => 28289,
                         "beautification"          => 20487,
                         "beauvoir"                => 21997,
                         "beaux"                   => 7601,
                         "beaverbrook"             => 26295,
                         "beaverton"               => 22715,
                         "became"                  => 82,
                         "beckenham"               => 23982,
                         "become"                  => 278,
                         "becomes"                 => 1110,
                         "becoming"                => 732,
                         "bedchamber"              => 20691,
                         "bedfordshire"            => 8876,
                         "bedouin"                 => 11257,
                         "bedouins"                => 25009,
                         "bedser"                  => 29585,
                         "beechcraft"              => 18253,
                         "beeching"                => 15715,
                         "beefheart"               => 27700,
                         "beehives"                => 28493,
                         "beekeeping"              => 24239,
                         "been"                    => 37,
                         "beerbohm"                => 29235,
                         "beermen"                 => 21382,
                         "beersheba"               => 15677,
                         "beeston"                 => 18883,
                         "beetles"                 => 5841,
                         "befell"                  => 26200,
                         "before"                  => 89,
                         "befriended"              => 7919,
                         "befriending"             => 22635,
                         "befriends"               => 10453,
                         "began"                   => 144,
                         "beginner"                => 13967,
                         "beginners"               => 12701,
                         "beginning"               => 540,
                         "beginnings"              => 5029,
                         "begins"                  => 1207,
                         "begum"                   => 11498,
                         "begun"                   => 2158,
                         "behalf"                  => 2385,
                         "behavioral"              => 5204,
                         "behaviors"               => 5626,
                         "behaviour"               => 3148,
                         "behavioural"             => 12386,
                         "behaviours"              => 12945,
                         "beheaded"                => 10088,
                         "behest"                  => 9885,
                         "beijing"                 => 2414,
                         "being"                   => 86,
                         "beinn"                   => 24189,
                         "beira"                   => 16607,
                         "beirut"                  => 5807,
                         "beitar"                  => 18987,
                         "beiyang"                 => 29284,
                         "belafonte"               => 22335,
                         "belarus"                 => 4760,
                         "belarusian"              => 6441,
                         "belarusians"             => 25616,
                         "belatedly"               => 22427,
                         "belchatow"               => 23148,
                         "belediyespor"            => 29677,
                         "belem"                   => 19048,
                         "belenenses"              => 28520,
                         "belfast"                 => 3651,
                         "belfort"                 => 17878,
                         "belfry"                  => 12616,
                         "belgaum"                 => 14473,
                         "belge"                   => 26395,
                         "belgian"                 => 2307,
                         "belgians"                => 15002,
                         "belgique"                => 25962,
                         "belgium"                 => 1875,
                         "belgrade"                => 3857,
                         "belgrano"                => 13772,
                         "belichick"               => 26663,
                         "belief"                  => 2326,
                         "beliefs"                 => 3090,
                         "believed"                => 808,
                         "believers"               => 7360,
                         "belisarius"              => 22978,
                         "belizean"                => 22575,
                         "bellarmine"              => 26207,
                         "bellary"                 => 26259,
                         "bellator"                => 11253,
                         "bellefonte"              => 25541,
                         "belleville"              => 11717,
                         "belleza"                 => 18213,
                         "bellflower"              => 29920,
                         "bellingham"              => 13152,
                         "bellinzona"              => 26831,
                         "bellona"                 => 27577,
                         "belonged"                => 2438,
                         "belonging"               => 2585,
                         "belorussian"             => 23223,
                         "below"                   => 582,
                         "belsen"                  => 24570,
                         "beltline"                => 29825,
                         "beltway"                 => 13144,
                         "belvidere"               => 23638,
                         "belvoir"                 => 19019,
                         "bemidji"                 => 25649,
                         "benares"                 => 24708,
                         "benaud"                  => 27220,
                         "benazir"                 => 17968,
                         "bencher"                 => 22237,
                         "benches"                 => 8936,
                         "benchmark"               => 9771,
                         "benchmarking"            => 22279,
                         "benchmarks"              => 16911,
                         "bendigo"                 => 11853,
                         "benedictine"             => 6995,
                         "benedictines"            => 23034,
                         "benediction"             => 24709,
                         "benefactors"             => 14912,
                         "benefice"                => 14971,
                         "benefices"               => 25468,
                         "beneficial"              => 5580,
                         "beneficiaries"           => 10934,
                         "benefited"               => 6869,
                         "benefiting"              => 12411,
                         "benefits"                => 2168,
                         "benefitted"              => 18266,
                         "benefitting"             => 29855,
                         "benelux"                 => 16483,
                         "bengal"                  => 3015,
                         "bengali"                 => 4611,
                         "bengalis"                => 27925,
                         "bengaluru"               => 15540,
                         "benghazi"                => 13603,
                         "bengt"                   => 20616,
                         "benin"                   => 7317,
                         "bentham"                 => 15251,
                         "benthic"                 => 14587,
                         "bentinck"                => 19253,
                         "benue"                   => 25070,
                         "benzene"                 => 13631,
                         "benzodiazepine"          => 20095,
                         "benzodiazepines"         => 15672,
                         "bequeathed"              => 8989,
                         "bequest"                 => 12136,
                         "bequests"                => 23120,
                         "berar"                   => 25532,
                         "berat"                   => 24092,
                         "berates"                 => 24593,
                         "berber"                  => 9160,
                         "berbers"                 => 17273,
                         "berchtesgaden"           => 28929,
                         "berdych"                 => 26942,
                         "berea"                   => 21058,
                         "berengar"                => 23628,
                         "berenger"                => 29109,
                         "berets"                  => 18736,
                         "berezovsky"              => 26435,
                         "bergamo"                 => 12744,
                         "bergson"                 => 25559,
                         "berhad"                  => 18297,
                         "beria"                   => 23312,
                         "bering"                  => 12028,
                         "berio"                   => 28141,
                         "berisha"                 => 26153,
                         "berkeley"                => 2977,
                         "berkhamsted"             => 25791,
                         "berklee"                 => 13826,
                         "berks"                   => 13679,
                         "berkshire"               => 5398,
                         "berle"                   => 22868,
                         "berlioz"                 => 15018,
                         "berlusconi"              => 12222,
                         "bermondsey"              => 21344,
                         "bermudian"               => 20344,
                         "bernadotte"              => 19669,
                         "bernd"                   => 14041,
                         "berne"                   => 13020,
                         "berners"                 => 22809,
                         "bernese"                 => 15327,
                         "bernini"                 => 18043,
                         "bernoulli"               => 15319,
                         "bernt"                   => 29737,
                         "berri"                   => 29446,
                         "bertelsmann"             => 29278,
                         "berth"                   => 6584,
                         "berthe"                  => 29032,
                         "berthed"                 => 18238,
                         "berthier"                => 26558,
                         "berthing"                => 23306,
                         "berths"                  => 11845,
                         "bertolt"                 => 21414,
                         "berwickshire"            => 25495,
                         "berwyn"                  => 26961,
                         "besancon"                => 16541,
                         "besant"                  => 23926,
                         "besar"                   => 16891,
                         "beset"                   => 14683,
                         "besiege"                 => 20250,
                         "besieged"                => 6254,
                         "besiegers"               => 27000,
                         "besieging"               => 15120,
                         "bespoke"                 => 16123,
                         "bessarabia"              => 13673,
                         "bessarabian"             => 28448,
                         "bessel"                  => 22768,
                         "bessemer"                => 18427,
                         "best"                    => 162,
                         "besting"                 => 27835,
                         "bestowed"                => 6384,
                         "bestowing"               => 25117,
                         "bestows"                 => 27030,
                         "bests"                   => 14436,
                         "bestseller"              => 8237,
                         "bestsellers"             => 20754,
                         "bestselling"             => 11192,
                         "beta"                    => 3091,
                         "betel"                   => 22315,
                         "bethesda"                => 10849,
                         "bethlehem"               => 7033,
                         "bethnal"                 => 20593,
                         "bethpage"                => 28142,
                         "betis"                   => 18399,
                         "betjeman"                => 25927,
                         "betrothal"               => 21552,
                         "betrothed"               => 14309,
                         "bettered"                => 19222,
                         "betterment"              => 17376,
                         "betula"                  => 21595,
                         "between"                 => 57,
                         "beverages"               => 7226,
                         "bevin"                   => 27586,
                         "bexar"                   => 18425,
                         "bexley"                  => 17672,
                         "bezalel"                 => 28143,
                         "beziers"                 => 25795,
                         "bezirksliga"             => 22546,
                         "bhadra"                  => 25972,
                         "bhagalpur"               => 28546,
                         "bhagat"                  => 18091,
                         "bhagavad"                => 19768,
                         "bhagavata"               => 21839,
                         "bhagwan"                 => 24126,
                         "bhakti"                  => 14703,
                         "bhamo"                   => 28865,
                         "bhangra"                 => 26054,
                         "bharata"                 => 20769,
                         "bharathi"                => 22441,
                         "bharati"                 => 15444,
                         "bharatiya"               => 10706,
                         "bharatpur"               => 26033,
                         "bharti"                  => 20334,
                         "bhasa"                   => 26303,
                         "bhaskar"                 => 17506,
                         "bhattacharya"            => 16527,
                         "bhavan"                  => 15342,
                         "bhawan"                  => 28578,
                         "bhima"                   => 19121,
                         "bhiwani"                 => 28723,
                         "bhojpuri"                => 21876,
                         "bhopal"                  => 10208,
                         "bhosle"                  => 27735,
                         "bhubaneswar"             => 15188,
                         "bhumibol"                => 24621,
                         "bhushan"                 => 16029,
                         "bhutan"                  => 6415,
                         "bhutanese"               => 16918,
                         "bhutto"                  => 9651,
                         "biafra"                  => 18531,
                         "biala"                   => 13440,
                         "bialystok"               => 9004,
                         "biannual"                => 17890,
                         "biases"                  => 14406,
                         "biathlete"               => 22118,
                         "biathlon"                => 10669,
                         "bible"                   => 2153,
                         "biblical"                => 3499,
                         "bibliographic"           => 17898,
                         "bibliographical"         => 25574,
                         "bibliography"            => 4478,
                         "biblioteca"              => 16890,
                         "bibliotheca"             => 20029,
                         "bibliotheque"            => 14229,
                         "bicameral"               => 15948,
                         "bicarbonate"             => 18738,
                         "bicentenary"             => 25861,
                         "bicester"                => 23535,
                         "bickerton"               => 27584,
                         "bicol"                   => 21665,
                         "bicolor"                 => 18581,
                         "bicycles"                => 7170,
                         "bicycling"               => 17786,
                         "bicyclists"              => 25673,
                         "bidar"                   => 24733,
                         "bidders"                 => 18627,
                         "bideford"                => 21643,
                         "biden"                   => 13263,
                         "bidirectional"           => 19702,
                         "bielefeld"               => 16279,
                         "bielsk"                  => 25711,
                         "bielsko"                 => 21773,
                         "biennale"                => 8921,
                         "biennial"                => 7880,
                         "biennially"              => 28765,
                         "bienville"               => 29436,
                         "bifurcated"              => 28587,
                         "bifurcation"             => 20625,
                         "biggar"                  => 26410,
                         "bight"                   => 14613,
                         "bihar"                   => 5757,
                         "bihari"                  => 18046,
                         "bijapur"                 => 16431,
                         "bijar"                   => 28264,
                         "bijelo"                  => 26426,
                         "bikaner"                 => 20024,
                         "biking"                  => 9630,
                         "bikram"                  => 25636,
                         "bilaspur"                => 23287,
                         "bilateral"               => 6157,
                         "bilayer"                 => 23376,
                         "bilbao"                  => 8755,
                         "biliary"                 => 27524,
                         "bilinear"                => 22687,
                         "bilingual"               => 6347,
                         "bilingualism"            => 20512,
                         "billboard"               => 1330,
                         "bille"                   => 27066,
                         "billed"                  => 5297,
                         "billets"                 => 28760,
                         "billiards"               => 12355,
                         "billion"                 => 1347,
                         "billiton"                => 28673,
                         "bimonthly"               => 15704,
                         "binaries"                => 21024,
                         "binary"                  => 4481,
                         "binders"                 => 29441,
                         "binding"                 => 2991,
                         "bindings"                => 17315,
                         "binds"                   => 7649,
                         "binet"                   => 28235,
                         "bingen"                  => 20044,
                         "binghamton"              => 10511,
                         "bingley"                 => 21145,
                         "binocular"               => 21214,
                         "binomial"                => 11855,
                         "bioavailability"         => 23581,
                         "biochemical"             => 10445,
                         "biochemist"              => 18286,
                         "biochemistry"            => 8129,
                         "biodiesel"               => 15167,
                         "biodiversity"            => 6170,
                         "bioengineering"          => 27081,
                         "biofilm"                 => 29885,
                         "biofuel"                 => 18212,
                         "biofuels"                => 15210,
                         "biogas"                  => 24010,
                         "biogenesis"              => 27806,
                         "biogeographic"           => 28302,
                         "biogeography"            => 25533,
                         "biograph"                => 28350,
                         "biographer"              => 5956,
                         "biographers"             => 14396,
                         "biographical"            => 6189,
                         "biographies"             => 7416,
                         "biography"               => 785,
                         "bioinformatics"          => 13925,
                         "biologist"               => 8197,
                         "biologists"              => 11795,
                         "biology"                 => 2535,
                         "biomarker"               => 26628,
                         "biomarkers"              => 22771,
                         "biomass"                 => 9108,
                         "biome"                   => 22970,
                         "biomechanics"            => 27333,
                         "biomedical"              => 7655,
                         "biophysical"             => 26762,
                         "biophysics"              => 17789,
                         "biopic"                  => 13743,
                         "bioscience"              => 28018,
                         "biosciences"             => 26930,
                         "biosphere"               => 10379,
                         "biosynthesis"            => 11532,
                         "biosynthetic"            => 29743,
                         "biota"                   => 21766,
                         "biotechnology"           => 7461,
                         "biotic"                  => 22130,
                         "biotin"                  => 29664,
                         "bipartite"               => 19590,
                         "bipedal"                 => 21752,
                         "biplane"                 => 9100,
                         "biplanes"                => 22722,
                         "bipolar"                 => 9832,
                         "birding"                 => 20483,
                         "birdlife"                => 14188,
                         "birds"                   => 1461,
                         "birdwatching"            => 24449,
                         "birger"                  => 20117,
                         "birkbeck"                => 20204,
                         "birkenau"                => 24783,
                         "birkenfeld"              => 22254,
                         "birkenhead"              => 11581,
                         "birkin"                  => 26253,
                         "birla"                   => 17174,
                         "birmingham"              => 2041,
                         "birth"                   => 1174,
                         "birthdate"               => 27799,
                         "birthplace"              => 4942,
                         "births"                  => 6653,
                         "biscay"                  => 12258,
                         "bisected"                => 16785,
                         "bisects"                 => 22156,
                         "bisexuality"             => 22829,
                         "bishopric"               => 7263,
                         "bishoprics"              => 21392,
                         "bishops"                 => 3007,
                         "bishopsgate"             => 27778,
                         "bismuth"                 => 18198,
                         "bison"                   => 7817,
                         "bisons"                  => 15871,
                         "bissau"                  => 11619,
                         "bistrica"                => 25974,
                         "bistrita"                => 23763,
                         "biswas"                  => 21872,
                         "bitcoin"                 => 16118,
                         "bithynia"                => 23075,
                         "bitmap"                  => 21338,
                         "bitola"                  => 21136,
                         "bitrate"                 => 29705,
                         "bitterly"                => 11475,
                         "bittern"                 => 25453,
                         "bitterns"                => 24337,
                         "bittorrent"              => 19204,
                         "bitumen"                 => 16818,
                         "bituminous"              => 20666,
                         "bivalve"                 => 16659,
                         "bivalves"                => 21500,
                         "biweekly"                => 20623,
                         "bizerte"                 => 27720,
                         "bizet"                   => 18641,
                         "bjelke"                  => 23539,
                         "bjorn"                   => 8910,
                         "blackadder"              => 18717,
                         "blackbirds"              => 26886,
                         "blackfoot"               => 17164,
                         "blackfriars"             => 16840,
                         "blackhawks"              => 9705,
                         "blackheath"              => 16848,
                         "blackish"                => 8424,
                         "blacklist"               => 16850,
                         "blacklisted"             => 16518,
                         "blackmails"              => 21109,
                         "blackmun"                => 29055,
                         "blackpool"               => 5581,
                         "blackrock"               => 16150,
                         "blacksburg"              => 26775,
                         "blacksmith"              => 7967,
                         "blacksmiths"             => 18395,
                         "blacktown"               => 23900,
                         "blackwall"               => 26178,
                         "bladed"                  => 12942,
                         "blaenau"                 => 28816,
                         "blagoevgrad"             => 22401,
                         "blagojevich"             => 22014,
                         "blamey"                  => 26883,
                         "blantyre"                => 23150,
                         "blasts"                  => 11036,
                         "blavatsky"               => 22037,
                         "blaxploitation"          => 29843,
                         "blazon"                  => 11248,
                         "blended"                 => 8226,
                         "blending"                => 9031,
                         "blends"                  => 10165,
                         "blenny"                  => 19285,
                         "bleriot"                 => 21751,
                         "bletchley"               => 16388,
                         "blige"                   => 15683,
                         "bligh"                   => 14307,
                         "blighted"                => 22201,
                         "blimps"                  => 29765,
                         "blistering"              => 19946,
                         "blizzards"               => 28778,
                         "bloc"                    => 5429,
                         "block"                   => 1122,
                         "blockade"                => 5374,
                         "blockaded"               => 16998,
                         "blockades"               => 28300,
                         "blockading"              => 14005,
                         "blockbuster"             => 8932,
                         "blockers"                => 18104,
                         "blockhouse"              => 17156,
                         "blocks"                  => 2222,
                         "blocs"                   => 22910,
                         "bloemfontein"            => 16512,
                         "blog"                    => 3537,
                         "blogger"                 => 9398,
                         "bloggers"                => 12101,
                         "blogging"                => 14546,
                         "blogs"                   => 7444,
                         "blois"                   => 15307,
                         "blomfield"               => 26685,
                         "bloodiest"               => 22618,
                         "bloodlines"              => 22560,
                         "bloodstock"              => 29256,
                         "bloomberg"               => 8103,
                         "bloomington"             => 9130,
                         "blooms"                  => 13048,
                         "bloomsburg"              => 22456,
                         "bloomsbury"              => 13089,
                         "bloor"                   => 16675,
                         "blotch"                  => 16495,
                         "blotches"                => 18507,
                         "bluebeard"               => 28653,
                         "bluefield"               => 27349,
                         "bluegrass"               => 7606,
                         "bluestone"               => 21594,
                         "bluesy"                  => 24650,
                         "bluetooth"               => 11103,
                         "bluffs"                  => 10537,
                         "bluffton"                => 28594,
                         "bluish"                  => 11804,
                         "blurring"                => 19791,
                         "blyth"                   => 11929,
                         "blyton"                  => 27060,
                         "board"                   => 335,
                         "boarders"                => 13759,
                         "boardings"               => 22801,
                         "boards"                  => 2903,
                         "boars"                   => 21147,
                         "boasted"                 => 8807,
                         "boasting"                => 13867,
                         "boasts"                  => 6840,
                         "boaters"                 => 21259,
                         "boats"                   => 2086,
                         "boatswain"               => 21444,
                         "boavista"                => 24602,
                         "boban"                   => 27237,
                         "bobsledder"              => 20789,
                         "bobsleigh"               => 14754,
                         "bocage"                  => 29610,
                         "boccaccio"               => 22465,
                         "bocelli"                 => 23830,
                         "bodhisattva"             => 17784,
                         "bodied"                  => 7678,
                         "bodies"                  => 1621,
                         "bodil"                   => 29471,
                         "bodleian"                => 18158,
                         "bodmin"                  => 18345,
                         "body"                    => 401,
                         "bodybuilder"             => 18767,
                         "bodybuilding"            => 12650,
                         "bodywork"                => 12552,
                         "boehner"                 => 29519,
                         "boeotia"                 => 25898,
                         "boers"                   => 14825,
                         "bofors"                  => 17006,
                         "bogdanov"                => 27415,
                         "bogdanovich"             => 26415,
                         "bognor"                  => 27503,
                         "bogor"                   => 25833,
                         "bohdan"                  => 23593,
                         "boheme"                  => 16441,
                         "bohemia"                 => 5879,
                         "bohemian"                => 6184,
                         "bohemians"               => 14622,
                         "bohemond"                => 23933,
                         "bohme"                   => 28649,
                         "bohol"                   => 17394,
                         "bohra"                   => 29391,
                         "bohun"                   => 27119,
                         "boilermakers"            => 19588,
                         "boilers"                 => 6987,
                         "boise"                   => 8023,
                         "boisterous"              => 24054,
                         "bojan"                   => 22784,
                         "bolagh"                  => 17941,
                         "bold"                    => 3559,
                         "boldface"                => 20678,
                         "boldklub"                => 23063,
                         "boldly"                  => 15332,
                         "boldness"                => 24217,
                         "boleslav"                => 23780,
                         "boleslaw"                => 10705,
                         "boletus"                 => 24193,
                         "boleyn"                  => 15006,
                         "bolingbroke"             => 23003,
                         "bolivarian"              => 19279,
                         "bolivia"                 => 4292,
                         "bolivian"                => 8406,
                         "bollywood"               => 5426,
                         "bolshevik"               => 7936,
                         "bolsheviks"              => 9064,
                         "bolshevism"              => 22991,
                         "bolshoi"                 => 15652,
                         "bolstered"               => 13747,
                         "boltzmann"               => 16012,
                         "bolzano"                 => 19246,
                         "bombarded"               => 10895,
                         "bombardment"             => 4134,
                         "bombardments"            => 19579,
                         "bombastic"               => 25358,
                         "bombing"                 => 2951,
                         "bombings"                => 6693,
                         "bombs"                   => 3901,
                         "bombus"                  => 29372,
                         "bonaventure"             => 14640,
                         "boneh"                   => 22411,
                         "bonfires"                => 24240,
                         "bonheur"                 => 29652,
                         "boniface"                => 9783,
                         "bonnaroo"                => 27435,
                         "bonne"                   => 19844,
                         "bonnier"                 => 27772,
                         "bonus"                   => 2663,
                         "bonuses"                 => 10130,
                         "booed"                   => 18227,
                         "book"                    => 211,
                         "bookings"                => 16663,
                         "booklet"                 => 7090,
                         "booklist"                => 21678,
                         "bookmaker"               => 24642,
                         "bookmakers"              => 21257,
                         "books"                   => 468,
                         "bookseller"              => 12908,
                         "booksellers"             => 14748,
                         "bookshop"                => 14154,
                         "boolean"                 => 11187,
                         "boomed"                  => 19074,
                         "booms"                   => 17392,
                         "boonton"                 => 29834,
                         "boosted"                 => 9488,
                         "boosting"                => 12956,
                         "booting"                 => 24114,
                         "bootle"                  => 23057,
                         "bootlegging"             => 25817,
                         "bootstrap"               => 22382,
                         "borac"                   => 24928,
                         "boras"                   => 25452,
                         "borax"                   => 24207,
                         "borbon"                  => 28800,
                         "borde"                   => 29180,
                         "border"                  => 845,
                         "bordered"                => 4071,
                         "bordering"               => 6769,
                         "borderland"              => 27318,
                         "borderlands"             => 19282,
                         "boreal"                  => 12854,
                         "borehole"                => 24102,
                         "borgo"                   => 19460,
                         "born"                    => 80,
                         "borne"                   => 5516,
                         "borneo"                  => 6227,
                         "bornholm"                => 21717,
                         "borno"                   => 25647,
                         "boron"                   => 11618,
                         "borough"                 => 1522,
                         "boroughs"                => 6749,
                         "borromeo"                => 17628,
                         "borrower"                => 14407,
                         "borrowers"               => 13910,
                         "borrowings"              => 19739,
                         "borrows"                 => 14237,
                         "boscawen"                => 28339,
                         "boscombe"                => 26834,
                         "bosna"                   => 27273,
                         "bosnia"                  => 3266,
                         "bosniak"                 => 15745,
                         "bosniaks"                => 17943,
                         "bosnian"                 => 5718,
                         "boson"                   => 19255,
                         "bosons"                  => 21819,
                         "bosphorus"               => 20576,
                         "bossier"                 => 16948,
                         "botanic"                 => 9438,
                         "botanical"               => 4682,
                         "botanist"                => 6243,
                         "botanists"               => 15562,
                         "botany"                  => 6379,
                         "botev"                   => 20583,
                         "both"                    => 88,
                         "botha"                   => 15478,
                         "botolph"                 => 28480,
                         "botswana"                => 7021,
                         "bottleneck"              => 15127,
                         "bottlenecks"             => 25294,
                         "bottlenose"              => 24389,
                         "bottling"                => 12946,
                         "botvinnik"               => 28759,
                         "bouches"                 => 28291,
                         "bouchet"                 => 19909,
                         "bougainville"            => 13195,
                         "bouillon"                => 23372,
                         "boulders"                => 10447,
                         "boulevard"               => 2940,
                         "boulevards"              => 17339,
                         "boulez"                  => 21501,
                         "boulogne"                => 10569,
                         "boult"                   => 24631,
                         "boundaries"              => 2401,
                         "boundary"                => 1937,
                         "bounded"                 => 3974,
                         "bounding"                => 20235,
                         "bourbons"                => 24204,
                         "bourchier"               => 22310,
                         "bourgeoisie"             => 12713,
                         "bourges"                 => 17623,
                         "bourgogne"               => 18754,
                         "bournemouth"             => 7658,
                         "bourse"                  => 27675,
                         "boutiques"               => 14981,
                         "bouts"                   => 8239,
                         "bowed"                   => 11832,
                         "bowery"                  => 14433,
                         "bowl"                    => 1392,
                         "bowled"                  => 6371,
                         "bowlers"                 => 9051,
                         "bowls"                   => 6484,
                         "boxset"                  => 22421,
                         "boyaca"                  => 25829,
                         "boyar"                   => 23451,
                         "boyars"                  => 21649,
                         "boyband"                 => 25944,
                         "boycott"                 => 6081,
                         "boycotted"               => 12406,
                         "boycotts"                => 18889,
                         "boyhood"                 => 12862,
                         "boylston"                => 24456,
                         "boys/girls"              => 21606,
                         "bozorg"                  => 23813,
                         "braathens"               => 23492,
                         "brabant"                 => 9657,
                         "brabazon"                => 29426,
                         "braced"                  => 12590,
                         "brachiopods"             => 27013,
                         "bracket"                 => 7508,
                         "bracketed"               => 20195,
                         "brackets"                => 7452,
                         "brackish"                => 12645,
                         "bracknell"               => 20949,
                         "bracts"                  => 16618,
                         "bradenton"               => 20185,
                         "bradman"                 => 11331,
                         "braganca"                => 27573,
                         "braganza"                => 16526,
                         "brahe"                   => 21528,
                         "brahma"                  => 9356,
                         "brahman"                 => 11753,
                         "brahmana"                => 25759,
                         "brahmaputra"             => 17220,
                         "brahmi"                  => 22074,
                         "brahmin"                 => 8723,
                         "brahmins"                => 10218,
                         "brahmo"                  => 22753,
                         "braille"                 => 9456,
                         "brainchild"              => 15068,
                         "brainstem"               => 22027,
                         "braintree"               => 16207,
                         "braking"                 => 8320,
                         "bramall"                 => 22173,
                         "bramley"                 => 21222,
                         "brampton"                => 10974,
                         "branagh"                 => 23987,
                         "branched"                => 7835,
                         "branches"                => 2009,
                         "branching"               => 8095,
                         "brand"                   => 1312,
                         "branded"                 => 4140,
                         "brandeis"                => 11987,
                         "branding"                => 5836,
                         "brandishing"             => 28400,
                         "brands"                  => 3287,
                         "brandywine"              => 15445,
                         "braniff"                 => 20714,
                         "branko"                  => 16645,
                         "brankovic"               => 24894,
                         "brantford"               => 16235,
                         "braque"                  => 23927,
                         "brasenose"               => 20091,
                         "brasileira"              => 23895,
                         "brasileiro"              => 12347,
                         "brasiliensis"            => 26769,
                         "brasov"                  => 15727,
                         "brassey"                 => 29315,
                         "bratianu"                => 29251,
                         "bratislava"              => 8071,
                         "brattleboro"             => 26492,
                         "braunfels"               => 27353,
                         "braunschweig"            => 12242,
                         "bravery"                 => 5783,
                         "brazilian"               => 1941,
                         "brazilians"              => 13168,
                         "brazo"                   => 29250,
                         "brazos"                  => 17045,
                         "brazzaville"             => 16707,
                         "breaches"                => 12154,
                         "breaching"               => 14869,
                         "breadth"                 => 9321,
                         "breakage"                => 21799,
                         "breakaway"               => 8420,
                         "breakbeat"               => 27944,
                         "breakout"                => 8536,
                         "breakthrough"            => 4463,
                         "breakwater"              => 14829,
                         "bream"                   => 18292,
                         "breastfeeding"           => 15519,
                         "breaststroke"            => 8078,
                         "breccia"                 => 27155,
                         "brechin"                 => 18083,
                         "brecker"                 => 26947,
                         "breckinridge"            => 14611,
                         "brecon"                  => 14676,
                         "bred"                    => 5170,
                         "breda"                   => 11345,
                         "breech"                  => 11108,
                         "breeches"                => 19457,
                         "breed"                   => 3219,
                         "breeder"                 => 10655,
                         "breeders"                => 7195,
                         "breeding"                => 2660,
                         "breeds"                  => 5430,
                         "brega"                   => 26401,
                         "breguet"                 => 21245,
                         "breisgau"                => 22466,
                         "bremerhaven"             => 19771,
                         "bremerton"               => 17715,
                         "brentano"                => 27160,
                         "brentford"               => 8450,
                         "brentwood"               => 11447,
                         "brera"                   => 23995,
                         "breslau"                 => 10572,
                         "bresson"                 => 27566,
                         "brethren"                => 7171,
                         "bretton"                 => 19512,
                         "breuning"                => 13365,
                         "breve"                   => 29051,
                         "brevet"                  => 10925,
                         "breviary"                => 27378,
                         "brevis"                  => 19825,
                         "brevity"                 => 19041,
                         "breweries"               => 9437,
                         "brewers"                 => 6816,
                         "brewery"                 => 4183,
                         "brewing"                 => 6144,
                         "brezhnev"                => 15350,
                         "briain"                  => 27406,
                         "briarcliff"              => 23351,
                         "brick"                   => 2036,
                         "bricklayer"              => 24997,
                         "brickwork"               => 14491,
                         "brickworks"              => 20001,
                         "brickyard"               => 20188,
                         "bridge"                  => 512,
                         "bridged"                 => 16674,
                         "bridgehead"              => 12905,
                         "bridgend"                => 16334,
                         "bridgeport"              => 8937,
                         "bridgestone"             => 20200,
                         "bridgeton"               => 27804,
                         "bridgetown"              => 20921,
                         "bridging"                => 10907,
                         "bridgnorth"              => 24144,
                         "bridgwater"              => 16984,
                         "bridle"                  => 17365,
                         "bridlington"             => 23549,
                         "bridport"                => 23038,
                         "brief"                   => 1680,
                         "briefly"                 => 1653,
                         "brienne"                 => 23528,
                         "brigade"                 => 1248,
                         "brigades"                => 5156,
                         "brigadier"               => 3817,
                         "brigands"                => 26683,
                         "brigantine"              => 25221,
                         "brightly"                => 9490,
                         "brightness"              => 8935,
                         "brigs"                   => 26552,
                         "brine"                   => 13160,
                         "brinsley"                => 29965,
                         "brisbane"                => 2659,
                         "bristles"                => 16451,
                         "britain"                 => 832,
                         "britannia"               => 8357,
                         "britannica"              => 11197,
                         "british"                 => 164,
                         "briton"                  => 15151,
                         "britons"                 => 11207,
                         "britpop"                 => 22748,
                         "brixton"                 => 13235,
                         "broad"                   => 1738,
                         "broadband"               => 6494,
                         "broadcast"               => 814,
                         "broadcaster"             => 4358,
                         "broadcasters"            => 6069,
                         "broadcasting"            => 1361,
                         "broadcasts"              => 2841,
                         "broadened"               => 11266,
                         "broadening"              => 15074,
                         "broader"                 => 4510,
                         "broadest"                => 17595,
                         "broadleaf"               => 19521,
                         "broadly"                 => 5346,
                         "broadmoor"               => 23892,
                         "broadsheet"              => 17453,
                         "broadside"               => 12634,
                         "broadsides"              => 22943,
                         "broadview"               => 27690,
                         "broadway"                => 1932,
                         "brocade"                 => 25451,
                         "broch"                   => 22460,
                         "brockton"                => 21256,
                         "brockville"              => 23932,
                         "broglie"                 => 23674,
                         "brokerage"               => 10933,
                         "brokered"                => 14639,
                         "brome"                   => 21745,
                         "bromeliad"               => 25637,
                         "bromide"                 => 14641,
                         "bromine"                 => 19301,
                         "brompton"                => 15348,
                         "bromsgrove"              => 21809,
                         "bromwich"                => 8505,
                         "bronfman"                => 26003,
                         "bronislaw"               => 24625,
                         "bronx"                   => 5262,
                         "bronze"                  => 1341,
                         "bronzes"                 => 14319,
                         "broodmare"               => 15689,
                         "broods"                  => 22001,
                         "brookfield"              => 13032,
                         "brookhaven"              => 18088,
                         "brookings"               => 15059,
                         "brooklands"              => 17877,
                         "brookville"              => 26902,
                         "brookwood"               => 22067,
                         "bros."                   => 4300,
                         "brothels"                => 13237,
                         "brotherhood"             => 5092,
                         "brotherhoods"            => 29811,
                         "brothers"                => 841,
                         "broward"                 => 13788,
                         "browed"                  => 27632,
                         "brownian"                => 21824,
                         "brownish"                => 7067,
                         "brownsville"             => 11268,
                         "browser"                 => 5829,
                         "browsers"                => 10938,
                         "bruford"                 => 26365,
                         "bruges"                  => 11765,
                         "brugge"                  => 15608,
                         "bruhl"                   => 27581,
                         "brumbies"                => 25400,
                         "brunei"                  => 7148,
                         "brunel"                  => 13034,
                         "brunswick"               => 2992,
                         "brussels"                => 3573,
                         "brutalist"               => 28042,
                         "bruxelles"               => 19138,
                         "bryansk"                 => 21860,
                         "brythonic"               => 25703,
                         "brzeg"                   => 28389,
                         "bskyb"                   => 22468,
                         "buble"                   => 23095,
                         "bubonic"                 => 22063,
                         "buccal"                  => 26491,
                         "buccaneer"               => 19057,
                         "buccaneers"              => 7146,
                         "buccleuch"               => 27464,
                         "bucculatrix"             => 24940,
                         "bucharest"               => 5235,
                         "buchenwald"              => 19418,
                         "buckethead"              => 22832,
                         "buckinghamshire"         => 7213,
                         "buckminster"             => 29798,
                         "bucuresti"               => 12106,
                         "buddhas"                 => 18430,
                         "buddhism"                => 3862,
                         "buddhist"                => 2714,
                         "buddhists"               => 9904,
                         "budding"                 => 11551,
                         "buddleja"                => 18343,
                         "budejovice"              => 19754,
                         "budget"                  => 1495,
                         "budgetary"               => 12318,
                         "budgeted"                => 16304,
                         "budgeting"               => 17340,
                         "budgets"                 => 8557,
                         "budokan"                 => 23310,
                         "buducnost"               => 25054,
                         "buenos"                  => 3277,
                         "buffaloes"               => 13675,
                         "buffered"                => 29106,
                         "buffering"               => 24203,
                         "buffers"                 => 15708,
                         "buganda"                 => 21283,
                         "bugis"                   => 29012,
                         "bugle"                   => 11960,
                         "buhari"                  => 29249,
                         "build"                   => 1011,
                         "builders"                => 5920,
                         "building"                => 191,
                         "buildings"               => 569,
                         "builds"                  => 6220,
                         "buildup"                 => 10444,
                         "built"                   => 175,
                         "bukhara"                 => 17304,
                         "bukhari"                 => 18486,
                         "bukidnon"                => 28090,
                         "bukit"                   => 10425,
                         "bukovina"                => 18148,
                         "bulacan"                 => 16456,
                         "bulawayo"                => 18169,
                         "bulbophyllum"            => 7668,
                         "bulbous"                 => 17390,
                         "bulbul"                  => 20356,
                         "bulgaria"                => 2810,
                         "bulgarian"               => 2852,
                         "bulgarians"              => 10166,
                         "bulgars"                 => 22544,
                         "bulge"                   => 10944,
                         "bulges"                  => 28614,
                         "bulk"                    => 3617,
                         "bulkeley"                => 24748,
                         "bulkhead"                => 16913,
                         "bulkheads"               => 20437,
                         "bulletins"               => 10956,
                         "bullfighting"            => 21973,
                         "bullpen"                 => 11675,
                         "bullying"                => 6762,
                         "bulwark"                 => 19772,
                         "bulwer"                  => 26168,
                         "bunbury"                 => 16473,
                         "bundaberg"               => 21002,
                         "bundesautobahn"          => 27867,
                         "bundesbahn"              => 24628,
                         "bundesliga"              => 5099,
                         "bundesstrasse"           => 17295,
                         "bundestag"               => 13218,
                         "bundeswehr"              => 14849,
                         "bundled"                 => 10375,
                         "bundles"                 => 9920,
                         "bungalows"               => 16097,
                         "bunkers"                 => 11063,
                         "bunko"                   => 29090,
                         "bunuel"                  => 21844,
                         "buoyancy"                => 12955,
                         "buoyant"                 => 18344,
                         "buoyed"                  => 23957,
                         "buoys"                   => 18821,
                         "burdensome"              => 29698,
                         "burdwan"                 => 25270,
                         "bureau"                  => 1345,
                         "bureaucracy"             => 8954,
                         "bureaucratic"            => 10262,
                         "bureaus"                 => 13751,
                         "buren"                   => 9758,
                         "burgas"                  => 16743,
                         "burgenland"              => 23516,
                         "burgeoning"              => 10404,
                         "burgesses"               => 17208,
                         "burgh"                   => 9355,
                         "burghers"                => 19542,
                         "burghley"                => 22890,
                         "burghs"                  => 15227,
                         "burgundian"              => 14944,
                         "burgundians"             => 26855,
                         "burgundy"                => 6849,
                         "burial"                  => 3115,
                         "burials"                 => 7564,
                         "buried"                  => 1210,
                         "burkina"                 => 7409,
                         "burkinabe"               => 26050,
                         "burlesque"               => 10288,
                         "burlington"              => 5597,
                         "burmese"                 => 5479,
                         "burnaby"                 => 14698,
                         "burne"                   => 21730,
                         "burnet"                  => 13560,
                         "burnie"                  => 19078,
                         "burra"                   => 25104,
                         "burrard"                 => 27202,
                         "burrowing"               => 15104,
                         "bursa"                   => 14765,
                         "bursaries"               => 25975,
                         "bursary"                 => 22371,
                         "burslem"                 => 21332,
                         "bursts"                  => 9405,
                         "burundi"                 => 9401,
                         "burwood"                 => 22127,
                         "busan"                   => 10190,
                         "buses"                   => 2465,
                         "bushehr"                 => 17474,
                         "bushels"                 => 24812,
                         "bushfire"                => 22669,
                         "bushfires"               => 20025,
                         "bushland"                => 20093,
                         "busiest"                 => 6872,
                         "business"                => 269,
                         "businesses"              => 1664,
                         "businessman"             => 2504,
                         "businessmen"             => 6309,
                         "businesspeople"          => 25262,
                         "businessperson"          => 21325,
                         "businessweek"            => 17951,
                         "busing"                  => 24267,
                         "buskerud"                => 24669,
                         "busko"                   => 28965,
                         "busoni"                  => 22434,
                         "bustling"                => 15876,
                         "busway"                  => 18523,
                         "butte"                   => 8508,
                         "buttes"                  => 24370,
                         "buttress"                => 17969,
                         "buttresses"              => 12595,
                         "butyl"                   => 26665,
                         "buuren"                  => 29948,
                         "buyout"                  => 10919,
                         "buzau"                   => 27287,
                         "buzzcocks"               => 23443,
                         "by"                      => 11,
                         "bycatch"                 => 26845,
                         "bydgoszcz"               => 10998,
                         "byelection"              => 29369,
                         "bygone"                  => 25698,
                         "bylaw"                   => 26866,
                         "bypass"                  => 4194,
                         "bypassed"                => 9581,
                         "bypasses"                => 14115,
                         "bypassing"               => 10807,
                         "byproduct"               => 16270,
                         "byproducts"              => 22059,
                         "byrds"                   => 13297,
                         "bystrica"                => 17062,
                         "bytes"                   => 9429,
                         "bytom"                   => 27592,
                         "bytow"                   => 22582,
                         "byung"                   => 24565,
                         "byway"                   => 13632,
                         "byzantine"               => 2905,
                         "byzantines"              => 9367,
                         "byzantium"               => 11090,
                         "caballeros"              => 25590,
                         "cabaret"                 => 7104,
                         "cabildo"                 => 22841,
                         "cabinet"                 => 1692,
                         "cabins"                  => 7843,
                         "cable"                   => 1770,
                         "cables"                  => 5750,
                         "cablevision"             => 19248,
                         "cabling"                 => 22119,
                         "cabrillo"                => 26797,
                         "cabriolet"               => 22345,
                         "cacak"                   => 27552,
                         "cacao"                   => 18579,
                         "cache"                   => 6620,
                         "caches"                  => 16072,
                         "caching"                 => 21052,
                         "cacti"                   => 18366,
                         "cadastral"               => 17974,
                         "cadbury"                 => 13147,
                         "caddo"                   => 15798,
                         "cadell"                  => 28677,
                         "cadet"                   => 4639,
                         "cadets"                  => 5343,
                         "cadfael"                 => 26262,
                         "cadre"                   => 10458,
                         "cadres"                  => 13887,
                         "caernarfon"              => 20695,
                         "caerphilly"              => 22503,
                         "caesarea"                => 14478,
                         "caesarean"               => 25349,
                         "caesars"                 => 15424,
                         "caesium"                 => 18326,
                         "caetano"                 => 17119,
                         "cafe"                    => 3134,
                         "cafes"                   => 8151,
                         "cafeterias"              => 29192,
                         "caffe"                   => 23804,
                         "cagayan"                 => 13916,
                         "cagliari"                => 12324,
                         "caguas"                  => 28613,
                         "cahiers"                 => 26710,
                         "caicos"                  => 16544,
                         "caird"                   => 27712,
                         "cairn"                   => 11769,
                         "cairo"                   => 4146,
                         "caisson"                 => 27719,
                         "caithness"               => 15226,
                         "caius"                   => 16690,
                         "cajon"                   => 21607,
                         "calabar"                 => 23169,
                         "calabria"                => 9528,
                         "calabrian"               => 29263,
                         "calais"                  => 7851,
                         "calamities"              => 24964,
                         "calatrava"               => 23857,
                         "calaveras"               => 25099,
                         "calcareous"              => 13674,
                         "calcite"                 => 17393,
                         "calcium"                 => 4899,
                         "calculate"               => 6709,
                         "calculated"              => 3798,
                         "calculates"              => 16680,
                         "calculation"             => 6089,
                         "calculations"            => 6196,
                         "calculators"             => 15142,
                         "calculus"                => 6879,
                         "calcutta"                => 4974,
                         "caldas"                  => 17348,
                         "caledon"                 => 22485,
                         "caledonia"               => 7073,
                         "caledonian"              => 8690,
                         "calendar"                => 2517,
                         "calendars"               => 11566,
                         "calibers"                => 21827,
                         "calibration"             => 11506,
                         "calibre"                 => 10276,
                         "calicut"                 => 13854,
                         "calif."                  => 23319,
                         "california"              => 321,
                         "californian"             => 11763,
                         "californians"            => 23983,
                         "californica"             => 22858,
                         "calinescu"               => 24421,
                         "calipers"                => 27163,
                         "caliph"                  => 7587,
                         "caliphate"               => 9081,
                         "caliphs"                 => 20238,
                         "callao"                  => 17749,
                         "called"                  => 116,
                         "calligrapher"            => 21960,
                         "calligraphic"            => 26877,
                         "calligraphy"             => 10770,
                         "calliostoma"             => 21685,
                         "callsign"                => 10742,
                         "callus"                  => 22737,
                         "caloptilia"              => 23207,
                         "caloric"                 => 25321,
                         "caltech"                 => 13741,
                         "calthorpe"               => 28987,
                         "caltrans"                => 26100,
                         "calum"                   => 26248,
                         "calumet"                 => 13442,
                         "calvados"                => 17242,
                         "calvinism"               => 17302,
                         "calvinist"               => 11741,
                         "calvinistic"             => 25848,
                         "calvinists"              => 22060,
                         "calyx"                   => 17663,
                         "camanachd"               => 29979,
                         "camarines"               => 21102,
                         "camas"                   => 25563,
                         "camberley"               => 22799,
                         "camberwell"              => 14990,
                         "cambodia"                => 4648,
                         "cambodian"               => 8124,
                         "cambodians"              => 28180,
                         "camborne"                => 29262,
                         "cambrai"                 => 14523,
                         "cambrian"                => 9217,
                         "cambridge"               => 1507,
                         "cambridgeshire"          => 8111,
                         "cameo"                   => 4873,
                         "cameos"                  => 12436,
                         "cameramen"               => 29489,
                         "camerata"                => 25462,
                         "cameroon"                => 5096,
                         "cameroonian"             => 14693,
                         "camillus"                => 26012,
                         "cammell"                 => 24079,
                         "camogie"                 => 11421,
                         "camorra"                 => 24172,
                         "camouflage"              => 8551,
                         "camouflaged"             => 18154,
                         "camp"                    => 788,
                         "campaign"                => 500,
                         "campaigned"              => 5636,
                         "campaigner"              => 12046,
                         "campaigners"             => 17364,
                         "campaigning"             => 6348,
                         "campaigns"               => 2486,
                         "campania"                => 12457,
                         "campanian"               => 23256,
                         "campanile"               => 23445,
                         "campbells"               => 27295,
                         "campbelltown"            => 20771,
                         "campeche"                => 17880,
                         "campeonato"              => 7401,
                         "camperdown"              => 24006,
                         "campground"              => 10361,
                         "campgrounds"             => 17106,
                         "camphor"                 => 23904,
                         "campinas"                => 22263,
                         "camps"                   => 2648,
                         "campsites"               => 13793,
                         "campus"                  => 819,
                         "campuses"                => 4343,
                         "campy"                   => 26541,
                         "camshaft"                => 14716,
                         "camshafts"               => 26918,
                         "camus"                   => 16800,
                         "canaan"                  => 11050,
                         "canaanite"               => 19429,
                         "canadair"                => 29649,
                         "canadensis"              => 20883,
                         "canadian"                => 467,
                         "canadians"               => 5715,
                         "canadiens"               => 7060,
                         "canal"                   => 1429,
                         "canal+"                  => 20424,
                         "canals"                  => 6043,
                         "canandaigua"             => 24519,
                         "canara"                  => 23353,
                         "canaria"                 => 19442,
                         "canarian"                => 25846,
                         "canaveral"               => 15852,
                         "canberra"                => 4907,
                         "cancellara"              => 28161,
                         "cancellation"            => 5513,
                         "cancelled"               => 2806,
                         "cancerous"               => 18041,
                         "cancers"                 => 8776,
                         "cancion"                 => 25991,
                         "candidacy"               => 6212,
                         "candidate"               => 1051,
                         "candidates"              => 1548,
                         "candidature"             => 19847,
                         "candido"                 => 16718,
                         "caney"                   => 29764,
                         "canis"                   => 14365,
                         "canisius"                => 24649,
                         "canna"                   => 29442,
                         "cannabinoid"             => 25472,
                         "cannes"                  => 5382,
                         "cannibalism"             => 13937,
                         "cannibalistic"           => 29818,
                         "cannock"                 => 25307,
                         "cannonball"              => 13057,
                         "cannonballs"             => 29835,
                         "cannons"                 => 6544,
                         "canoe"                   => 5553,
                         "canoeing"                => 9525,
                         "canoeist"                => 16691,
                         "canoer"                  => 11485,
                         "canoes"                  => 10653,
                         "canola"                  => 29910,
                         "canonical"               => 6245,
                         "canonically"             => 25827,
                         "canonization"            => 16039,
                         "canonized"               => 13981,
                         "canons"                  => 7528,
                         "canopies"                => 17733,
                         "canopy"                  => 6464,
                         "canso"                   => 27715,
                         "cantabria"               => 16326,
                         "cantabrian"              => 24220,
                         "cantal"                  => 28787,
                         "cantata"                 => 9798,
                         "cantatas"                => 15119,
                         "canteen"                 => 11796,
                         "canterbury"              => 3562,
                         "cantilever"              => 11657,
                         "cantilevered"            => 22278,
                         "canton"                  => 2892,
                         "cantonal"                => 12957,
                         "cantonese"               => 7915,
                         "cantonment"              => 11783,
                         "cantons"                 => 9334,
                         "cantus"                  => 25605,
                         "canute"                  => 21164,
                         "canvas"                  => 5373,
                         "canvases"                => 13444,
                         "canwest"                 => 23630,
                         "canyon"                  => 3050,
                         "canyons"                 => 11513,
                         "capabilities"            => 3430,
                         "capability"              => 3764,
                         "capablanca"              => 26129,
                         "capacitance"             => 13271,
                         "capacities"              => 7172,
                         "capacitive"              => 22123,
                         "capacitor"               => 10951,
                         "capacitors"              => 11451,
                         "capacity"                => 998,
                         "cape"                    => 1442,
                         "capensis"                => 25186,
                         "capes"                   => 17369,
                         "capillary"               => 13911,
                         "capistrano"              => 23519,
                         "capita"                  => 2423,
                         "capitaine"               => 29134,
                         "capital"                 => 474,
                         "capitalisation"          => 26849,
                         "capitalise"              => 21597,
                         "capitalised"             => 29099,
                         "capitalism"              => 6006,
                         "capitalist"              => 6895,
                         "capitalists"             => 14662,
                         "capitalization"          => 13592,
                         "capitalized"             => 12740,
                         "capitalizing"            => 22260,
                         "capitol"                 => 3524,
                         "capitoline"              => 28707,
                         "capitulated"             => 15997,
                         "capitulation"            => 11457,
                         "cappadocia"              => 17204,
                         "capped"                  => 5077,
                         "cappella"                => 8703,
                         "capping"                 => 16861,
                         "caproni"                 => 24196,
                         "caps"                    => 3616,
                         "capsid"                  => 26727,
                         "capsized"                => 14660,
                         "capstone"                => 20345,
                         "capsule"                 => 6800,
                         "captaincy"               => 9171,
                         "captained"               => 5370,
                         "captaining"              => 14843,
                         "captains"                => 5933,
                         "caption"                 => 13350,
                         "captions"                => 18619,
                         "captives"                => 8349,
                         "captivity"               => 5777,
                         "captor"                  => 29860,
                         "captors"                 => 13312,
                         "capture"                 => 1728,
                         "captured"                => 1083,
                         "captures"                => 7207,
                         "capturing"               => 4369,
                         "capua"                   => 16221,
                         "capuchin"                => 15467,
                         "carabidae"               => 13802,
                         "carabinieri"             => 26022,
                         "carabus"                 => 28565,
                         "caracalla"               => 24923,
                         "caragiale"               => 21303,
                         "carapace"                => 15309,
                         "caravans"                => 15499,
                         "carbide"                 => 13230,
                         "carbines"                => 21625,
                         "carbohydrate"            => 13224,
                         "carbohydrates"           => 13182,
                         "carbon"                  => 2044,
                         "carbonate"               => 8580,
                         "carbonated"              => 19583,
                         "carbonates"              => 24717,
                         "carbondale"              => 17834,
                         "carbonic"                => 26735,
                         "carboniferous"           => 11353,
                         "carbons"                 => 24526,
                         "carbonyl"                => 14074,
                         "carboxyl"                => 29680,
                         "carboxylic"              => 17578,
                         "carburetors"             => 23051,
                         "carburettor"             => 24317,
                         "carburettors"            => 29558,
                         "carcasses"               => 17133,
                         "carcassonne"             => 22426,
                         "carcetti"                => 29443,
                         "carcinogen"              => 24867,
                         "carcinogenic"            => 19594,
                         "carcinoma"               => 11356,
                         "carcinomas"              => 28757,
                         "cardamom"                => 22873,
                         "cardiff"                 => 3519,
                         "cardinalate"             => 23373,
                         "cardinality"             => 19592,
                         "cardinals"               => 3181,
                         "carding"                 => 27826,
                         "cardiomyopathy"          => 22350,
                         "cardiothoracic"          => 28894,
                         "cardiovascular"          => 7979,
                         "career"                  => 119,
                         "careers"                 => 3799,
                         "caregivers"              => 15300,
                         "carell"                  => 20946,
                         "carers"                  => 22248,
                         "caretaker"               => 6906,
                         "caretakers"              => 20181,
                         "carex"                   => 18502,
                         "cargo"                   => 2342,
                         "cargoes"                 => 16403,
                         "carib"                   => 23391,
                         "caribbean"               => 2360,
                         "cariboo"                 => 18747,
                         "caricature"              => 12594,
                         "caricatures"             => 14350,
                         "caricaturist"            => 28508,
                         "caricom"                 => 23523,
                         "caries"                  => 28775,
                         "carillon"                => 15757,
                         "carinae"                 => 14810,
                         "carinthia"               => 12737,
                         "carinthian"              => 26507,
                         "carlist"                 => 14634,
                         "carlists"                => 29417,
                         "carlsson"                => 18849,
                         "carmarthen"              => 14428,
                         "carmarthenshire"         => 15435,
                         "carmelite"               => 14541,
                         "carmelites"              => 20537,
                         "carnarvon"               => 19108,
                         "carnatic"                => 10580,
                         "carnation"               => 17526,
                         "carnaval"                => 19729,
                         "carne"                   => 18535,
                         "carnegie"                => 3965,
                         "carneiro"                => 28598,
                         "carniola"                => 9668,
                         "carnivals"               => 18705,
                         "carnivores"              => 16598,
                         "carnivorous"             => 10993,
                         "carnot"                  => 20433,
                         "carolinas"               => 13405,
                         "carolingian"             => 12105,
                         "carolla"                 => 28605,
                         "carotene"                => 26266,
                         "carpark"                 => 23494,
                         "carpathian"              => 12802,
                         "carpathians"             => 16487,
                         "carpets"                 => 10141,
                         "carpi"                   => 21559,
                         "carre"                   => 16133,
                         "carrefour"               => 22749,
                         "carriages"               => 6692,
                         "carriageway"             => 9789,
                         "carrickfergus"           => 22860,
                         "carried"                 => 837,
                         "carriers"                => 3875,
                         "carries"                 => 2736,
                         "carrollton"              => 15470,
                         "carronades"              => 28439,
                         "cars"                    => 1034,
                         "carstairs"               => 27992,
                         "cartan"                  => 22214,
                         "cartels"                 => 16907,
                         "carteret"                => 19217,
                         "cartesian"               => 11204,
                         "carthaginian"            => 13654,
                         "carthaginians"           => 17780,
                         "carthusian"              => 25159,
                         "cartilage"               => 11321,
                         "cartilaginous"           => 25739,
                         "cartographer"            => 15682,
                         "cartographers"           => 18372,
                         "cartographic"            => 22577,
                         "cartography"             => 16661,
                         "cartooning"              => 21829,
                         "cartoonish"              => 29871,
                         "cartoonist"              => 6845,
                         "cartoonists"             => 13378,
                         "cartridge"               => 5278,
                         "cartridges"              => 7744,
                         "carts"                   => 10777,
                         "carved"                  => 3421,
                         "carvings"                => 8438,
                         "casal"                   => 26560,
                         "casals"                  => 23096,
                         "cascades"                => 10466,
                         "cascadia"                => 29780,
                         "cascading"               => 18976,
                         "casco"                   => 19272,
                         "casein"                  => 28316,
                         "casemate"                => 23290,
                         "casemates"               => 17110,
                         "casement"                => 17965,
                         "cases"                   => 773,
                         "cashel"                  => 16149,
                         "casimir"                 => 9132,
                         "casks"                   => 23092,
                         "caspase"                 => 24074,
                         "caspian"                 => 9018,
                         "cassation"               => 22775,
                         "cassava"                 => 12138,
                         "cassavetes"              => 26576,
                         "cassette"                => 5752,
                         "cassettes"               => 13272,
                         "cassia"                  => 20750,
                         "cassini"                 => 15489,
                         "cassino"                 => 17407,
                         "cast"                    => 834,
                         "castaways"               => 23953,
                         "caste"                   => 5126,
                         "castel"                  => 13358,
                         "castellan"               => 20468,
                         "castelo"                 => 16689,
                         "castes"                  => 8619,
                         "castiel"                 => 27783,
                         "castile"                 => 5403,
                         "castilian"               => 11319,
                         "casting"                 => 3501,
                         "castings"                => 15842,
                         "castle"                  => 715,
                         "castleford"              => 12553,
                         "castlemaine"             => 22521,
                         "castlereagh"             => 21904,
                         "castles"                 => 5601,
                         "castleton"               => 19202,
                         "castletown"              => 22665,
                         "castra"                  => 23470,
                         "castration"              => 21122,
                         "castrum"                 => 23068,
                         "casts"                   => 8711,
                         "casualties"              => 2861,
                         "casualty"                => 7160,
                         "cataclysm"               => 28159,
                         "catalans"                => 18072,
                         "catalog"                 => 4713,
                         "cataloged"               => 24372,
                         "catalogue"               => 4410,
                         "catalogued"              => 14563,
                         "catalonia"               => 6118,
                         "catalunya"               => 12874,
                         "catalyses"               => 15610,
                         "catalysis"               => 15158,
                         "catalyst"                => 6082,
                         "catalysts"               => 12171,
                         "catalytic"               => 8674,
                         "catalyze"                => 19377,
                         "catalyzed"               => 13837,
                         "catalyzes"               => 9964,
                         "catamaran"               => 20472,
                         "catamarca"               => 25330,
                         "catapulted"              => 19999,
                         "catapults"               => 24665,
                         "cataract"                => 15982,
                         "catastrophes"            => 26647,
                         "catastrophic"            => 8512,
                         "catawba"                 => 16742,
                         "catchers"                => 16276,
                         "catchment"               => 7232,
                         "catchphrase"             => 12572,
                         "catchphrases"            => 25188,
                         "catechism"               => 12114,
                         "categoria"               => 27873,
                         "categorical"             => 15585,
                         "categories"              => 2238,
                         "categorised"             => 14729,
                         "categorization"          => 14966,
                         "categorize"              => 17889,
                         "categorized"             => 6790,
                         "categorizes"             => 29013,
                         "categorizing"            => 29283,
                         "category"                => 1337,
                         "catena"                  => 29888,
                         "catenary"                => 22318,
                         "catenin"                 => 27878,
                         "caterpillar"             => 10369,
                         "caterpillars"            => 12674,
                         "caters"                  => 10039,
                         "catesby"                 => 28217,
                         "cathal"                  => 19408,
                         "catharina"               => 19491,
                         "catharines"              => 15484,
                         "cathedral"               => 1478,
                         "cathedrals"              => 10214,
                         "cathode"                 => 10787,
                         "catholic"                => 598,
                         "catholicism"             => 5260,
                         "catholicos"              => 16330,
                         "catholics"               => 3624,
                         "catholique"              => 23114,
                         "cation"                  => 13990,
                         "cationic"                => 27443,
                         "cations"                 => 16846,
                         "catocala"                => 25310,
                         "catolica"                => 16947,
                         "catshark"                => 23388,
                         "catskill"                => 15277,
                         "cattaraugus"             => 25999,
                         "catterick"               => 29070,
                         "cattle"                  => 2444,
                         "cauca"                   => 19329,
                         "caucasians"              => 25353,
                         "caucasus"                => 5940,
                         "cauchy"                  => 13963,
                         "caucus"                  => 5903,
                         "caucuses"                => 15939,
                         "caudal"                  => 11066,
                         "causa"                   => 13701,
                         "causal"                  => 9290,
                         "causality"               => 15899,
                         "causation"               => 16090,
                         "causative"               => 15848,
                         "caused"                  => 738,
                         "causes"                  => 1577,
                         "causeway"                => 7868,
                         "causing"                 => 1663,
                         "cautioned"               => 15534,
                         "cautions"                => 17500,
                         "cauvery"                 => 29244,
                         "cavaliers"               => 8925,
                         "cavalli"                 => 23685,
                         "cavalry"                 => 1927,
                         "cavalrymen"              => 19158,
                         "cavan"                   => 11827,
                         "cavendish"               => 8605,
                         "cavernous"               => 27177,
                         "caverns"                 => 12971,
                         "caversham"               => 25619,
                         "caves"                   => 4350,
                         "cavitation"              => 28927,
                         "cavite"                  => 12012,
                         "cavities"                => 12053,
                         "cavity"                  => 6067,
                         "cavour"                  => 25890,
                         "caxias"                  => 25460,
                         "caxton"                  => 23324,
                         "cayley"                  => 17527,
                         "cbeebies"                => 29634,
                         "cd+dvd"                  => 28097,
                         "cd/dvd"                  => 18576,
                         "ceara"                   => 17688,
                         "ceased"                  => 2436,
                         "ceasefire"               => 8317,
                         "ceasing"                 => 14858,
                         "ceausescu"               => 15902,
                         "cebuano"                 => 22652,
                         "cedar"                   => 4249,
                         "ceded"                   => 6695,
                         "ceding"                  => 20759,
                         "ceiba"                   => 28462,
                         "ceilings"                => 8950,
                         "celebes"                 => 27956,
                         "celebi"                  => 25682,
                         "celebrant"               => 28434,
                         "celebrated"              => 1980,
                         "celebrates"              => 7481,
                         "celebrations"            => 4128,
                         "celebrities"             => 4355,
                         "celebrity"               => 3284,
                         "celestial"               => 6697,
                         "celje"                   => 18389,
                         "cellars"                 => 12747,
                         "celle"                   => 16554,
                         "cellist"                 => 10268,
                         "cello"                   => 6225,
                         "cellos"                  => 24513,
                         "cells"                   => 1260,
                         "cellular"                => 4570,
                         "celluloid"               => 21096,
                         "cellulose"               => 11413,
                         "celsius"                 => 10438,
                         "celta"                   => 20440,
                         "celts"                   => 13521,
                         "cemented"                => 10194,
                         "cementing"               => 19984,
                         "cements"                 => 25420,
                         "cemeteries"              => 6090,
                         "cemetery"                => 1252,
                         "cenel"                   => 21073,
                         "cenotaph"                => 17778,
                         "cenozoic"                => 19052,
                         "censored"                => 9540,
                         "censoring"               => 26106,
                         "censors"                 => 12317,
                         "censorship"              => 5195,
                         "census"                  => 368,
                         "censuses"                => 11202,
                         "cent"                    => 3394,
                         "centaurs"                => 25646,
                         "centaurus"               => 26713,
                         "centenary"               => 6408,
                         "centennial"              => 5507,
                         "center"                  => 238,
                         "centered"                => 3178,
                         "centering"               => 13956,
                         "centerline"              => 19262,
                         "centerpiece"             => 10846,
                         "centers"                 => 1928,
                         "centerville"             => 17650,
                         "centimeters"             => 6140,
                         "centimetre"              => 29330,
                         "centimetres"             => 12068,
                         "centipede"               => 22944,
                         "central"                 => 218,
                         "centrale"                => 16962,
                         "centralia"               => 22684,
                         "centralised"             => 14399,
                         "centrality"              => 20175,
                         "centralization"          => 19446,
                         "centralized"             => 7471,
                         "centrally"               => 8286,
                         "centre"                  => 411,
                         "centred"                 => 5667,
                         "centrepiece"             => 18337,
                         "centres"                 => 2945,
                         "centreville"             => 23118,
                         "centric"                 => 10651,
                         "centrifugal"             => 12757,
                         "centrifuge"              => 22676,
                         "centrist"                => 12793,
                         "centro"                  => 7229,
                         "centrum"                 => 18267,
                         "centuries"               => 1404,
                         "centurions"              => 19226,
                         "century"                 => 154,
                         "cephalopod"              => 25001,
                         "cephalopods"             => 17125,
                         "cerambycidae"            => 5569,
                         "ceramic"                 => 5776,
                         "ceramics"                => 6385,
                         "cercle"                  => 12882,
                         "cereals"                 => 11461,
                         "cerebellar"              => 19603,
                         "cerebral"                => 6839,
                         "cerebrospinal"           => 22999,
                         "ceredigion"              => 17569,
                         "ceremonial"              => 4637,
                         "ceremonially"            => 23802,
                         "ceremonies"              => 3813,
                         "ceres"                   => 13252,
                         "cerevisiae"              => 21912,
                         "cerium"                  => 29833,
                         "cerrado"                 => 27077,
                         "cerro"                   => 8497,
                         "certain"                 => 727,
                         "certificate"             => 2994,
                         "certificates"            => 6438,
                         "certification"           => 3635,
                         "certifications"          => 10564,
                         "certified"               => 2396,
                         "certifies"               => 27472,
                         "certify"                 => 16155,
                         "certifying"              => 13691,
                         "certiorari"              => 17622,
                         "cervical"                => 9512,
                         "cesaro"                  => 27636,
                         "ceska"                   => 28530,
                         "ceske"                   => 17952,
                         "cesky"                   => 29879,
                         "cessation"               => 9857,
                         "cession"                 => 15594,
                         "cetaceans"               => 19766,
                         "cetinje"                 => 23689,
                         "ceuta"                   => 18004,
                         "ceylon"                  => 5894,
                         "ceylonese"               => 27086,
                         "cezanne"                 => 16555,
                         "ch'uan"                  => 24662,
                         "chabad"                  => 13822,
                         "chabahar"                => 29793,
                         "chaco"                   => 13409,
                         "chadian"                 => 17238,
                         "chafee"                  => 29399,
                         "chagall"                 => 22043,
                         "chagatai"                => 25128,
                         "chagos"                  => 25986,
                         "chagrin"                 => 14184,
                         "chahar"                  => 15783,
                         "chaharmahal"             => 19149,
                         "chaim"                   => 11588,
                         "chain"                   => 1553,
                         "chaining"                => 24464,
                         "chains"                  => 4035,
                         "chainz"                  => 29823,
                         "chaired"                 => 4279,
                         "chairing"                => 18851,
                         "chairlift"               => 22120,
                         "chairman"                => 790,
                         "chairmanship"            => 10236,
                         "chairmen"                => 11700,
                         "chairperson"             => 7363,
                         "chairwoman"              => 14075,
                         "chaitanya"               => 19286,
                         "chakraborty"             => 16412,
                         "chakri"                  => 28911,
                         "chalcedon"               => 19274,
                         "chalcolithic"            => 28624,
                         "chaldean"                => 15931,
                         "chalice"                 => 14734,
                         "challenge"               => 1295,
                         "challenged"              => 3100,
                         "challenger"              => 4531,
                         "challengers"             => 10616,
                         "challenges"              => 2746,
                         "challenging"             => 4080,
                         "chalon"                  => 24690,
                         "chalons"                 => 29692,
                         "chalukya"                => 19212,
                         "chalukyas"               => 21578,
                         "chama"                   => 29525,
                         "chamber"                 => 1559,
                         "chambered"               => 11612,
                         "chambersburg"            => 23799,
                         "chambery"                => 28676,
                         "chambre"                 => 20369,
                         "chameleon"               => 12300,
                         "chameleons"              => 29901,
                         "chamfered"               => 27810,
                         "champaign"               => 9455,
                         "championed"              => 9013,
                         "championing"             => 18714,
                         "championnat"             => 13865,
                         "champions"               => 1125,
                         "championship"            => 290,
                         "championships"           => 570,
                         "champlain"               => 10366,
                         "chancel"                 => 5638,
                         "chancellery"             => 16613,
                         "chancellor"              => 2528,
                         "chancellors"             => 13732,
                         "chancellorship"          => 27676,
                         "chancellorsville"        => 20232,
                         "chancery"                => 9926,
                         "chand"                   => 11368,
                         "chandan"                 => 21511,
                         "chandi"                  => 28652,
                         "chandigarh"              => 12157,
                         "chandni"                 => 29986,
                         "chandos"                 => 19209,
                         "chandragupta"            => 23379,
                         "chandran"                => 24437,
                         "chandrasekhar"           => 22422,
                         "chang'an"                => 9814,
                         "changchun"               => 17833,
                         "changeable"              => 25680,
                         "changeling"              => 27590,
                         "changeover"              => 21236,
                         "changers"                => 26862,
                         "changes"                 => 705,
                         "changeup"                => 25630,
                         "changi"                  => 17820,
                         "changsha"                => 15522,
                         "chania"                  => 25141,
                         "channel"                 => 581,
                         "channelled"              => 27536,
                         "channels"                => 2187,
                         "chanson"                 => 17182,
                         "chansons"                => 20479,
                         "chanted"                 => 14039,
                         "chanter"                 => 26305,
                         "chantilly"               => 17035,
                         "chantry"                 => 19677,
                         "chants"                  => 10713,
                         "chaotic"                 => 8058,
                         "chaparral"               => 13680,
                         "chapbook"                => 28981,
                         "chapel"                  => 1501,
                         "chapelle"                => 12556,
                         "chapels"                 => 7852,
                         "chaplain"                => 5177,
                         "chaplaincy"              => 21016,
                         "chaplains"               => 11836,
                         "chapter"                 => 1627,
                         "chapters"                => 3067,
                         "chapultepec"             => 25223,
                         "character"               => 418,
                         "characterisation"        => 15644,
                         "characterise"            => 24226,
                         "characterised"           => 5901,
                         "characteristic"          => 2693,
                         "characteristically"      => 13233,
                         "characteristics"         => 2017,
                         "characterization"        => 7745,
                         "characterizations"       => 20130,
                         "characterize"            => 9626,
                         "characterized"           => 2358,
                         "characterizes"           => 12597,
                         "characterizing"          => 15790,
                         "characters"              => 659,
                         "charadriiformesfamily"   => 14711,
                         "charan"                  => 15659,
                         "charaxes"                => 23697,
                         "charcoal"                => 8106,
                         "charcot"                 => 20599,
                         "charente"                => 14110,
                         "charentes"               => 24296,
                         "charged"                 => 1798,
                         "charing"                 => 14032,
                         "chariots"                => 14088,
                         "charismatic"             => 8293,
                         "charitable"              => 3847,
                         "charities"               => 5257,
                         "charlemagne"             => 8641,
                         "charleroi"               => 14954,
                         "charleston"              => 3978,
                         "charlestown"             => 13174,
                         "charleville"             => 24112,
                         "charlevoix"              => 24386,
                         "charlottenburg"          => 22373,
                         "charlottesville"         => 12392,
                         "charlottetown"           => 14710,
                         "chart"                   => 739,
                         "charted"                 => 4217,
                         "charter"                 => 1861,
                         "chartered"               => 4348,
                         "charterhouse"            => 14269,
                         "chartering"              => 29009,
                         "charteris"               => 22129,
                         "charters"                => 8043,
                         "charting"                => 5980,
                         "chartist"                => 28337,
                         "chartres"                => 15084,
                         "charts"                  => 1702,
                         "chasers"                 => 17363,
                         "chasseurs"               => 19988,
                         "chassis"                 => 4187,
                         "chastised"               => 26497,
                         "chateau"                 => 4291,
                         "chateaux"                => 25393,
                         "chatelet"                => 22134,
                         "chater"                  => 28764,
                         "chatillon"               => 21195,
                         "chatsworth"              => 16409,
                         "chattahoochee"           => 17854,
                         "chattanooga"             => 7849,
                         "chatterjee"              => 12797,
                         "chattopadhyay"           => 27612,
                         "chaudhary"               => 17638,
                         "chaumont"                => 26038,
                         "chautauqua"              => 14900,
                         "chauvel"                 => 26016,
                         "chaux"                   => 28861,
                         "chavo"                   => 22934,
                         "cheaply"                 => 14575,
                         "chebyshev"               => 28208,
                         "chechen"                 => 9708,
                         "chechens"                => 21315,
                         "chechnya"                => 12579,
                         "checkerboard"            => 27002,
                         "checkpoints"             => 13054,
                         "checksum"                => 25596,
                         "chedi"                   => 29868,
                         "cheeked"                 => 25755,
                         "cheerfully"              => 27725,
                         "cheeses"                 => 14327,
                         "cheetahs"                => 16790,
                         "cheil"                   => 17575,
                         "cheka"                   => 28484,
                         "chekhov"                 => 13578,
                         "chelan"                  => 27241,
                         "chelm"                   => 18313,
                         "chelmno"                 => 25266,
                         "chelmsford"              => 11208,
                         "cheltenham"              => 6470,
                         "chelyabinsk"             => 17517,
                         "chemical"                => 1514,
                         "chemically"              => 10323,
                         "chemicals"               => 4538,
                         "chemin"                  => 17259,
                         "chemins"                 => 23174,
                         "chemistry"               => 2284,
                         "chemists"                => 12557,
                         "chemnitz"                => 18130,
                         "chemotherapy"            => 9117,
                         "chemung"                 => 27731,
                         "chenango"                => 25283,
                         "chenar"                  => 22424,
                         "chengde"                 => 24811,
                         "chengdu"                 => 10283,
                         "chennai"                 => 4372,
                         "chepstow"                => 22171,
                         "chequered"               => 24085,
                         "chera"                   => 23135,
                         "cherbourg"               => 13430,
                         "chernigov"               => 29777,
                         "chernihiv"               => 26372,
                         "chernivtsi"              => 26490,
                         "chernobyl"               => 13769,
                         "cherokees"               => 23576,
                         "chert"                   => 21807,
                         "chertsey"                => 22334,
                         "cherwell"                => 25092,
                         "chesapeake"              => 6858,
                         "chesham"                 => 20819,
                         "cheshmeh"                => 11570,
                         "chess"                   => 2598,
                         "chesterfield"            => 7561,
                         "chetnik"                 => 18709,
                         "chetniks"                => 17414,
                         "chettiar"                => 29681,
                         "chetwynd"                => 26620,
                         "chevrons"                => 23307,
                         "chhatrapati"             => 27890,
                         "chhattisgarh"            => 13044,
                         "chiapas"                 => 11170,
                         "chiaroscuro"             => 28414,
                         "chiba"                   => 9780,
                         "chicagoland"             => 27032,
                         "chicane"                 => 19699,
                         "chichester"              => 8047,
                         "chickamauga"             => 16622,
                         "chickasaw"               => 13614,
                         "chicopee"                => 29482,
                         "chicoutimi"              => 29808,
                         "chidambaram"             => 19305,
                         "chief"                   => 407,
                         "chiefdom"                => 22270,
                         "chiefdoms"               => 26924,
                         "chiefly"                 => 5354,
                         "chieftain"               => 9619,
                         "chieftains"              => 11649,
                         "chievo"                  => 19798,
                         "chihuahua"               => 9941,
                         "chikara"                 => 17719,
                         "chilcotin"               => 29255,
                         "childcare"               => 15153,
                         "childe"                  => 24528,
                         "childhood"               => 1971,
                         "childless"               => 9059,
                         "children"                => 201,
                         "chile"                   => 2336,
                         "chilean"                 => 4091,
                         "chileans"                => 22543,
                         "chillicothe"             => 20761,
                         "chilliwack"              => 21389,
                         "chiloe"                  => 24579,
                         "chiltern"                => 14861,
                         "chimneys"                => 10175,
                         "chimpanzees"             => 13486,
                         "china"                   => 453,
                         "chine"                   => 26123,
                         "chinensis"               => 25289,
                         "chinese"                 => 516,
                         "chionodes"               => 28076,
                         "chios"                   => 19247,
                         "chipmunks"               => 17558,
                         "chippenham"              => 19928,
                         "chippewa"                => 11358,
                         "chipset"                 => 16307,
                         "chipsets"                => 22150,
                         "chirac"                  => 16488,
                         "chiral"                  => 12988,
                         "chiranjeevi"             => 26811,
                         "chiropractic"            => 13986,
                         "chishti"                 => 25823,
                         "chisinau"                => 13256,
                         "chiswick"                => 16744,
                         "chita"                   => 21762,
                         "chitral"                 => 22504,
                         "chittagong"              => 10254,
                         "chittoor"                => 28176,
                         "chivalric"               => 22940,
                         "chiyoda"                 => 27380,
                         "chloride"                => 6358,
                         "chlorides"               => 27076,
                         "chlorinated"             => 27039,
                         "chlorine"                => 9955,
                         "chlorophyll"             => 17464,
                         "chloroplast"             => 23432,
                         "chloroplasts"            => 21966,
                         "choctaw"                 => 10468,
                         "choir"                   => 2469,
                         "choirmaster"             => 22670,
                         "choirs"                  => 8182,
                         "choiseul"                => 26900,
                         "chojnice"                => 24819,
                         "chola"                   => 8914,
                         "cholas"                  => 18048,
                         "cholera"                 => 8759,
                         "choline"                 => 25983,
                         "cholmondeley"            => 24366,
                         "chongqing"               => 10322,
                         "chopra"                  => 10118,
                         "choral"                  => 5314,
                         "chorale"                 => 10267,
                         "chord"                   => 5179,
                         "chords"                  => 7074,
                         "choreographed"           => 8081,
                         "choreographer"           => 6962,
                         "choreographers"          => 15879,
                         "choreographic"           => 24454,
                         "choreography"            => 7149,
                         "chorister"               => 25548,
                         "choristers"              => 21883,
                         "chorley"                 => 15565,
                         "chorlton"                => 27634,
                         "chorus"                  => 3031,
                         "choruses"                => 12133,
                         "chosen"                  => 1224,
                         "choshu"                  => 27268,
                         "chota"                   => 26863,
                         "chowk"                   => 17050,
                         "christchurch"            => 5764,
                         "christendom"             => 18350,
                         "christened"              => 9633,
                         "christgau"               => 14451,
                         "christiania"             => 15730,
                         "christianity"            => 2546,
                         "christianization"        => 19926,
                         "christianized"           => 26063,
                         "christians"              => 2708,
                         "christology"             => 26108,
                         "christoph"               => 8686,
                         "christus"                => 27373,
                         "chroma"                  => 20963,
                         "chromatic"               => 10222,
                         "chromatin"               => 16865,
                         "chromatography"          => 13866,
                         "chromosomal"             => 15001,
                         "chromosome"              => 6086,
                         "chromosomes"             => 8874,
                         "chronicle"               => 3429,
                         "chronicled"              => 11260,
                         "chronicler"              => 10551,
                         "chroniclers"             => 16642,
                         "chronicles"              => 4656,
                         "chronicling"             => 15102,
                         "chronicon"               => 22219,
                         "chronological"           => 7051,
                         "chronologically"         => 12664,
                         "chronology"              => 7610,
                         "chrysalis"               => 16669,
                         "chrysanthemum"           => 23740,
                         "chrysostom"              => 20247,
                         "chukchi"                 => 23640,
                         "chukotka"                => 29820,
                         "chulalongkorn"           => 20042,
                         "church"                  => 147,
                         "churches"                => 1403,
                         "churchmen"               => 24839,
                         "churchyard"              => 6946,
                         "chuvash"                 => 21882,
                         "ciaran"                  => 17088,
                         "cibernetico"             => 23083,
                         "cicada"                  => 26732,
                         "cichlids"                => 25142,
                         "ciconiiformesfamily"     => 27985,
                         "cidade"                  => 24392,
                         "ciechanow"               => 24915,
                         "cielo"                   => 18167,
                         "ciencias"                => 25244,
                         "cieszyn"                 => 14915,
                         "cilia"                   => 15197,
                         "ciliary"                 => 29803,
                         "cilicia"                 => 13940,
                         "cilla"                   => 23298,
                         "cimarron"                => 18141,
                         "cincinnati"              => 2616,
                         "cinema"                  => 1985,
                         "cinemas"                 => 6724,
                         "cinemascope"             => 23571,
                         "cinematheque"            => 28068,
                         "cinematic"               => 7632,
                         "cinematographer"         => 7463,
                         "cinematographers"        => 19922,
                         "cinematographic"         => 29712,
                         "cinematography"          => 7019,
                         "cineplex"                => 25654,
                         "cinerama"                => 28883,
                         "cinerea"                 => 27734,
                         "cingulate"               => 27582,
                         "ciphers"                 => 17939,
                         "ciphertext"              => 21546,
                         "circa"                   => 4745,
                         "circadian"               => 15427,
                         "circassian"              => 18839,
                         "circassians"             => 22932,
                         "circe"                   => 19453,
                         "circle"                  => 1740,
                         "circuit"                 => 1425,
                         "circuitous"              => 27345,
                         "circuitry"               => 12586,
                         "circuits"                => 4854,
                         "circular"                => 3069,
                         "circulated"              => 6248,
                         "circulates"              => 25049,
                         "circulating"             => 8060,
                         "circulation"             => 3065,
                         "circumflex"              => 29935,
                         "circumnavigation"        => 17199,
                         "circumpolar"             => 26878,
                         "circumscribed"           => 17822,
                         "circumscription"         => 26290,
                         "circumvent"              => 14048,
                         "circumvented"            => 26559,
                         "circuses"                => 20274,
                         "cirencester"             => 19434,
                         "cisse"                   => 28072,
                         "cistercian"              => 11024,
                         "cistercians"             => 26018,
                         "cistern"                 => 18069,
                         "cisterns"                => 21410,
                         "citation"                => 4048,
                         "citations"               => 6866,
                         "cited"                   => 2098,
                         "cites"                   => 5778,
                         "cities"                  => 760,
                         "citigroup"               => 17398,
                         "citing"                  => 3166,
                         "citizen"                 => 2470,
                         "citizenry"               => 18005,
                         "citizens"                => 1272,
                         "citizenship"             => 3214,
                         "citrate"                 => 21922,
                         "citric"                  => 22396,
                         "citta"                   => 15403,
                         "city"                    => 54,
                         "cityscape"               => 17765,
                         "citytv"                  => 24818,
                         "ciudad"                  => 7651,
                         "civet"                   => 25207,
                         "civic"                   => 2897,
                         "civil"                   => 463,
                         "civilian"                => 2241,
                         "civilians"               => 3378,
                         "civilisation"            => 12075,
                         "civilisations"           => 25997,
                         "civilizations"           => 8688,
                         "civita"                  => 28261,
                         "civitas"                 => 21381,
                         "clackamas"               => 22680,
                         "clacton"                 => 29802,
                         "cladding"                => 15579,
                         "clade"                   => 7640,
                         "clades"                  => 17684,
                         "cladistic"               => 21550,
                         "cladogram"               => 16836,
                         "claes"                   => 20371,
                         "claim"                   => 1282,
                         "claimant"                => 10727,
                         "claimants"               => 11824,
                         "claimed"                 => 802,
                         "claiming"                => 2315,
                         "claims"                  => 1149,
                         "clairvaux"               => 26729,
                         "clan"                    => 2279,
                         "clandestine"             => 8724,
                         "clandestinely"           => 23568,
                         "clann"                   => 20882,
                         "clans"                   => 5887,
                         "clapboard"               => 17421,
                         "clapham"                 => 12422,
                         "claremont"               => 8222,
                         "clarendon"               => 11267,
                         "clarified"               => 8780,
                         "clarifies"               => 23374,
                         "clarin"                  => 28332,
                         "clarinetist"             => 16828,
                         "clarinets"               => 17183,
                         "clarksburg"              => 25381,
                         "clarksville"             => 15951,
                         "clash"                   => 4985,
                         "clashed"                 => 8192,
                         "clashes"                 => 6198,
                         "clasico"                 => 26261,
                         "clasps"                  => 22196,
                         "class"                   => 284,
                         "classed"                 => 8683,
                         "classes"                 => 1140,
                         "classical"               => 1201,
                         "classically"             => 11556,
                         "classicism"              => 15529,
                         "classicist"              => 18547,
                         "classification"          => 1917,
                         "classifications"         => 8128,
                         "classified"              => 2006,
                         "classifier"              => 19878,
                         "classifiers"             => 24009,
                         "classifies"              => 13278,
                         "classify"                => 9144,
                         "classifying"             => 12890,
                         "classmate"               => 9106,
                         "classroom"               => 3972,
                         "classrooms"              => 4371,
                         "claudius"                => 8719,
                         "clause"                  => 3913,
                         "clauses"                 => 7955,
                         "clausura"                => 11904,
                         "clays"                   => 15420,
                         "cleanly"                 => 21913,
                         "clearances"              => 15724,
                         "clearest"                => 25415,
                         "clearfield"              => 19833,
                         "clearinghouse"           => 23002,
                         "clearings"               => 21841,
                         "clearwater"              => 10193,
                         "cleave"                  => 18275,
                         "cleaved"                 => 19944,
                         "cleburne"                => 23534,
                         "cleese"                  => 19948,
                         "cleethorpes"             => 29301,
                         "cleeve"                  => 29380,
                         "cleft"                   => 13153,
                         "clemenceau"              => 23469,
                         "cleon"                   => 28934,
                         "clerestory"              => 17239,
                         "clergy"                  => 3941,
                         "clergyman"               => 7582,
                         "clergymen"               => 14801,
                         "clerical"                => 7929,
                         "clerics"                 => 10157,
                         "clerked"                 => 24792,
                         "clerkenwell"             => 25404,
                         "clermont"                => 9769,
                         "clevedon"                => 28597,
                         "cleves"                  => 17096,
                         "cliched"                 => 23363,
                         "cliches"                 => 14760,
                         "cliffs"                  => 5357,
                         "cliftonville"            => 29029,
                         "clijsters"               => 21810,
                         "climactic"               => 14958,
                         "climate"                 => 1166,
                         "climates"                => 8135,
                         "climatic"                => 8765,
                         "climatology"             => 27869,
                         "climbers"                => 9566,
                         "climbs"                  => 7566,
                         "clinch"                  => 9790,
                         "clinched"                => 8622,
                         "clinching"               => 14808,
                         "clinical"                => 2116,
                         "clinician"               => 17741,
                         "clinicians"              => 14152,
                         "clinics"                 => 6298,
                         "clinker"                 => 25048,
                         "clique"                  => 11466,
                         "cliques"                 => 24069,
                         "clitheroe"               => 23052,
                         "clive"                   => 6158,
                         "clivina"                 => 21613,
                         "cloaks"                  => 28522,
                         "clockmaker"              => 29354,
                         "clockwise"               => 7784,
                         "cloister"                => 11028,
                         "cloisters"               => 19976,
                         "clonal"                  => 26135,
                         "clones"                  => 8907,
                         "clonmel"                 => 25623,
                         "clontarf"                => 23028,
                         "closed"                  => 683,
                         "closely"                 => 1571,
                         "clostridium"             => 23844,
                         "closure"                 => 2801,
                         "closures"                => 11214,
                         "cloth"                   => 4442,
                         "clothing"                => 2480,
                         "cloverdale"              => 29063,
                         "cloverleaf"              => 14995,
                         "cloyne"                  => 29177,
                         "club"                    => 131,
                         "clube"                   => 7440,
                         "clubs"                   => 971,
                         "clumps"                  => 16253,
                         "cluny"                   => 17116,
                         "cluster"                 => 3637,
                         "clustered"               => 11009,
                         "clustering"              => 12964,
                         "clusters"                => 4717,
                         "clwyd"                   => 22261,
                         "clydebank"               => 19320,
                         "coach"                   => 466,
                         "coached"                 => 2869,
                         "coachella"               => 16051,
                         "coaches"                 => 2501,
                         "coaching"                => 2097,
                         "coadjutor"               => 15705,
                         "coagulation"             => 18661,
                         "coahuila"                => 13984,
                         "coal"                    => 1575,
                         "coalesce"                => 23769,
                         "coalesced"               => 22599,
                         "coalfield"               => 14508,
                         "coalfields"              => 22104,
                         "coaling"                 => 27763,
                         "coalition"               => 1914,
                         "coalitions"              => 13181,
                         "coarse"                  => 8491,
                         "coarser"                 => 24989,
                         "coast"                   => 507,
                         "coastal"                 => 1759,
                         "coastline"               => 5492,
                         "coastlines"              => 18812,
                         "coasts"                  => 6844,
                         "coatbridge"              => 23773,
                         "coated"                  => 7150,
                         "coating"                 => 7496,
                         "coatings"                => 11454,
                         "coauthor"                => 26285,
                         "coauthored"              => 19309,
                         "coaxial"                 => 15225,
                         "cobbled"                 => 21930,
                         "cobbles"                 => 29952,
                         "cobblestone"             => 20491,
                         "cobden"                  => 22705,
                         "cobham"                  => 14159,
                         "cobol"                   => 26407,
                         "cobourg"                 => 28645,
                         "coburg"                  => 10431,
                         "cochabamba"              => 19360,
                         "cochin"                  => 9617,
                         "cochlea"                 => 28990,
                         "cochlear"                => 20862,
                         "cockatoo"                => 19244,
                         "cockerell"               => 22556,
                         "cocking"                 => 27023,
                         "cockpit"                 => 5890,
                         "cockpits"                => 21368,
                         "cocos"                   => 18537,
                         "code"                    => 887,
                         "codec"                   => 15832,
                         "codecs"                  => 21306,
                         "codeine"                 => 22795,
                         "codename"                => 12575,
                         "codenamed"               => 11621,
                         "codes"                   => 3317,
                         "codeshare"               => 26913,
                         "codex"                   => 5618,
                         "codice_1"                => 9061,
                         "codice_10"               => 28827,
                         "codice_2"                => 12576,
                         "codice_3"                => 15497,
                         "codice_4"                => 17144,
                         "codice_5"                => 19876,
                         "codice_6"                => 21724,
                         "codice_7"                => 23661,
                         "codice_8"                => 25196,
                         "codice_9"                => 27098,
                         "codices"                 => 19361,
                         "codification"            => 18684,
                         "codified"                => 10112,
                         "coding"                  => 6201,
                         "codon"                   => 20390,
                         "codrington"              => 25209,
                         "coeducational"           => 9677,
                         "coefficient"             => 6666,
                         "coefficients"            => 7199,
                         "coenzyme"                => 22208,
                         "coercive"                => 15617,
                         "coetzee"                 => 22739,
                         "coeur"                   => 12118,
                         "coexisted"               => 28071,
                         "coexistence"             => 15802,
                         "cofactor"                => 18514,
                         "cofounded"               => 23053,
                         "cofounder"               => 21349,
                         "cognate"                 => 12077,
                         "cognates"                => 23099,
                         "cognition"               => 9195,
                         "cognitive"               => 3772,
                         "cognomen"                => 25540,
                         "cohabitation"            => 22257,
                         "coherence"               => 12259,
                         "coherent"                => 7905,
                         "cohesion"                => 11130,
                         "cohesive"                => 11512,
                         "cohomology"              => 13460,
                         "cohort"                  => 10843,
                         "cohorts"                 => 16956,
                         "coiled"                  => 13950,
                         "coils"                   => 11107,
                         "coimbatore"              => 10947,
                         "coimbra"                 => 11550,
                         "coin"                    => 3809,
                         "coinage"                 => 8232,
                         "coincide"                => 6758,
                         "coincided"               => 6451,
                         "coincident"              => 24068,
                         "coincidentally"          => 8822,
                         "coincides"               => 11044,
                         "coinciding"              => 10131,
                         "coined"                  => 4449,
                         "coining"                 => 16385,
                         "coins"                   => 2888,
                         "coking"                  => 27029,
                         "col."                    => 5167,
                         "colborne"                => 26344,
                         "colchester"              => 6699,
                         "coldest"                 => 12241,
                         "coldfield"               => 22282,
                         "coldstream"              => 18789,
                         "coldwater"               => 17664,
                         "colegio"                 => 10104,
                         "coleophora"              => 10353,
                         "coleophoridae"           => 18724,
                         "coleoptera"              => 27296,
                         "coleraine"               => 16996,
                         "coleridge"               => 10357,
                         "colima"                  => 19496,
                         "coliseum"                => 6814,
                         "collaborate"             => 7275,
                         "collaborated"            => 2978,
                         "collaborates"            => 12069,
                         "collaborating"           => 6960,
                         "collaboration"           => 1885,
                         "collaborationist"        => 24179,
                         "collaborations"          => 5454,
                         "collaborative"           => 4588,
                         "collaboratively"         => 18582,
                         "collaborator"            => 6696,
                         "collaborators"           => 7192,
                         "collagen"                => 12230,
                         "collages"                => 18271,
                         "collapse"                => 2868,
                         "collapses"               => 9590,
                         "collapsible"             => 25423,
                         "collated"                => 17233,
                         "colle"                   => 20985,
                         "colleagues"              => 3197,
                         "collectable"             => 27051,
                         "collected"               => 1688,
                         "collectible"             => 12085,
                         "collectibles"            => 17989,
                         "collecting"              => 3572,
                         "collection"              => 602,
                         "collections"             => 1955,
                         "collective"              => 2602,
                         "collectively"            => 4728,
                         "collectives"             => 21454,
                         "collectivization"        => 22372,
                         "collector"               => 3759,
                         "collectors"              => 4905,
                         "collects"                => 7605,
                         "college"                 => 137,
                         "colleges"                => 1926,
                         "collegiate"              => 3006,
                         "collegiately"            => 17886,
                         "collegio"                => 26630,
                         "collegium"               => 14969,
                         "collided"                => 7986,
                         "collider"                => 20023,
                         "colliding"               => 15777,
                         "collieries"              => 13947,
                         "colliers"                => 24833,
                         "colliery"                => 6777,
                         "collingwood"             => 7202,
                         "collision"               => 4669,
                         "collisions"              => 9255,
                         "colloidal"               => 26299,
                         "colloquial"              => 10044,
                         "colloquially"            => 7785,
                         "colloquium"              => 26204,
                         "colmar"                  => 22322,
                         "colne"                   => 18295,
                         "cologne"                 => 4577,
                         "colombian"               => 4835,
                         "colombians"              => 26835,
                         "colonels"                => 10292,
                         "colonia"                 => 10636,
                         "colonial"                => 1565,
                         "colonialism"             => 10174,
                         "colonials"               => 17777,
                         "colonies"                => 2798,
                         "colonisation"            => 13555,
                         "colonised"               => 20897,
                         "colonist"                => 18424,
                         "colonists"               => 5501,
                         "colonization"            => 6388,
                         "colonize"                => 16185,
                         "colonized"               => 12428,
                         "colonizers"              => 22675,
                         "colonizing"              => 23716,
                         "colony"                  => 1755,
                         "colophon"                => 25429,
                         "color"                   => 1025,
                         "coloration"              => 9012,
                         "coloratura"              => 26928,
                         "colorectal"              => 18184,
                         "colored"                 => 3187,
                         "colorless"               => 14475,
                         "colour"                  => 2047,
                         "colouration"             => 15690,
                         "coloured"                => 4272,
                         "colourful"               => 8282,
                         "colouring"               => 14223,
                         "colourless"              => 21753,
                         "colours"                 => 3245,
                         "colquhoun"               => 23898,
                         "colspan=12"              => 19081,
                         "colspan=3|total"         => 10988,
                         "colspan=3|turnout"       => 21333,
                         "colspan=9"               => 10400,
                         "colspan=9|"              => 13384,
                         "colt"                    => 5166,
                         "colts"                   => 5043,
                         "columba"                 => 13404,
                         "columbia"                => 978,
                         "columbian"               => 8245,
                         "columbine"               => 17441,
                         "columella"               => 16997,
                         "column"                  => 2054,
                         "columnar"                => 21805,
                         "columnist"               => 4775,
                         "columns"                 => 2792,
                         "colwyn"                  => 24902,
                         "comarca"                 => 12350,
                         "combat"                  => 1216,
                         "combatant"               => 10072,
                         "combatants"              => 9204,
                         "combating"               => 11607,
                         "combats"                 => 23625,
                         "combe"                   => 14091,
                         "combination"             => 1682,
                         "combinations"            => 5405,
                         "combinatorial"           => 13935,
                         "combinatorics"           => 19154,
                         "combine"                 => 4184,
                         "combined"                => 1066,
                         "combines"                => 4730,
                         "combining"               => 4031,
                         "combos"                  => 20720,
                         "combustion"              => 5826,
                         "comdr"                   => 18841,
                         "comeback"                => 4495,
                         "comedian"                => 3900,
                         "comedians"               => 8240,
                         "comedic"                 => 7342,
                         "comedie"                 => 18655,
                         "comedienne"              => 22128,
                         "comedies"                => 7329,
                         "comedy"                  => 1030,
                         "comercio"                => 29791,
                         "comic"                   => 1436,
                         "comical"                 => 11590,
                         "comically"               => 21946,
                         "comics"                  => 1638,
                         "comilla"                 => 25792,
                         "comintern"               => 12776,
                         "comique"                 => 15070,
                         "comitatus"               => 29968,
                         "comite"                  => 17318,
                         "comix"                   => 21287,
                         "command"                 => 607,
                         "commandant"              => 5874,
                         "commanded"               => 2314,
                         "commander"               => 856,
                         "commanders"              => 3986,
                         "commandery"              => 14472,
                         "commanding"              => 2939,
                         "commandos"               => 8672,
                         "commands"                => 4423,
                         "commedia"                => 20032,
                         "commemorate"             => 4765,
                         "commemorated"            => 6543,
                         "commemorates"            => 8298,
                         "commemorating"           => 7215,
                         "commemoration"           => 7547,
                         "commemorations"          => 16408,
                         "commemorative"           => 6351,
                         "commenced"               => 2887,
                         "commencement"            => 7295,
                         "commences"               => 15095,
                         "commencing"              => 8550,
                         "commendation"            => 9080,
                         "commendations"           => 21983,
                         "commended"               => 8264,
                         "commending"              => 26060,
                         "commends"                => 28163,
                         "commentaries"            => 7191,
                         "commentary"              => 3110,
                         "commentated"             => 24606,
                         "commentating"            => 25821,
                         "commentator"             => 4511,
                         "commentators"            => 5451,
                         "commented"               => 2536,
                         "commenting"              => 5646,
                         "comments"                => 2968,
                         "commerce"                => 2064,
                         "commercial"              => 613,
                         "commercialization"       => 13306,
                         "commercialize"           => 25189,
                         "commercialized"          => 16452,
                         "commercially"            => 3723,
                         "commercials"             => 4244,
                         "commissar"               => 13716,
                         "commissariat"            => 17819,
                         "commissars"              => 23219,
                         "commissary"              => 15146,
                         "commission"              => 609,
                         "commissioned"            => 1353,
                         "commissioner"            => 1949,
                         "commissioners"           => 4206,
                         "commissioning"           => 6979,
                         "commissions"             => 4512,
                         "commitments"             => 6393,
                         "commits"                 => 9534,
                         "committee"               => 436,
                         "committeeman"            => 26320,
                         "committees"              => 3177,
                         "commodities"             => 7468,
                         "commodity"               => 6901,
                         "commodore"               => 4654,
                         "commodores"              => 14095,
                         "common"                  => 342,
                         "commonalities"           => 27476,
                         "commonality"             => 21261,
                         "commoners"               => 12920,
                         "commonly"                => 944,
                         "commonplace"             => 9370,
                         "commons"                 => 2461,
                         "commonwealth"            => 1686,
                         "communal"                => 5440,
                         "communally"              => 29378,
                         "communaute"              => 20124,
                         "commune"                 => 1552,
                         "communes"                => 5655,
                         "communicable"            => 25000,
                         "communicated"            => 9487,
                         "communicates"            => 14133,
                         "communication"           => 1516,
                         "communications"          => 1384,
                         "communicative"           => 17136,
                         "communicators"           => 27540,
                         "communion"               => 5746,
                         "communis"                => 27851,
                         "communism"               => 5333,
                         "communist"               => 1266,
                         "communists"              => 4416,
                         "communities"             => 1024,
                         "community"               => 226,
                         "commutation"             => 20387,
                         "commutative"             => 12018,
                         "commutator"              => 25465,
                         "commuted"                => 8100,
                         "commuter"                => 4941,
                         "commuters"               => 9482,
                         "commutes"                => 24823,
                         "commuting"               => 12359,
                         "comoros"                 => 13522,
                         "comox"                   => 29326,
                         "compact"                 => 3297,
                         "compacted"               => 19951,
                         "compaction"              => 24425,
                         "compactness"             => 27025,
                         "compagnie"               => 12480,
                         "compania"                => 19356,
                         "companies"               => 621,
                         "companion"               => 3210,
                         "companions"              => 5625,
                         "company"                 => 113,
                         "comparable"              => 4257,
                         "comparably"              => 28949,
                         "comparative"             => 4698,
                         "comparatively"           => 6833,
                         "compared"                => 1109,
                         "compares"                => 7801,
                         "comparison"              => 2653,
                         "comparisons"             => 6233,
                         "compasses"               => 26192,
                         "compatibility"           => 7120,
                         "compatible"              => 4226,
                         "compatriot"              => 11681,
                         "compatriots"             => 15776,
                         "compendium"              => 11002,
                         "compensate"              => 7007,
                         "compensates"             => 28150,
                         "compensation"            => 3346,
                         "compensatory"            => 17452,
                         "compete"                 => 1675,
                         "competed"                => 929,
                         "competence"              => 7960,
                         "competences"             => 23658,
                         "competencies"            => 15477,
                         "competency"              => 13190,
                         "competes"                => 4895,
                         "competing"               => 2141,
                         "competition"             => 481,
                         "competitions"            => 1945,
                         "competitive"             => 2196,
                         "competitively"           => 15720,
                         "competitiveness"         => 10028,
                         "competitor"              => 4457,
                         "competitors"             => 3423,
                         "compilation"             => 2096,
                         "compilations"            => 7109,
                         "compile"                 => 9799,
                         "compiled"                => 3054,
                         "compiler"                => 7384,
                         "compilers"               => 13209,
                         "compiles"                => 18471,
                         "compiling"               => 7614,
                         "complainant"             => 26162,
                         "complained"              => 4750,
                         "complaints"              => 3981,
                         "complement"              => 4953,
                         "complementary"           => 7154,
                         "complemented"            => 10045,
                         "complementing"           => 19068,
                         "complements"             => 14201,
                         "complete"                => 667,
                         "completed"               => 473,
                         "completeness"            => 14999,
                         "completes"               => 9998,
                         "completing"              => 2606,
                         "completion"              => 2070,
                         "completions"             => 15457,
                         "complex"                 => 704,
                         "complexes"               => 5421,
                         "complexities"            => 14257,
                         "complexity"              => 4076,
                         "compliance"              => 4650,
                         "compliant"               => 8685,
                         "complicity"              => 14460,
                         "complied"                => 11154,
                         "complies"                => 17403,
                         "complutense"             => 27688,
                         "comply"                  => 5435,
                         "complying"               => 17541,
                         "component"               => 2235,
                         "components"              => 1892,
                         "compose"                 => 6674,
                         "composed"                => 824,
                         "composer"                => 1422,
                         "composers"               => 3309,
                         "composes"                => 16501,
                         "composing"               => 5906,
                         "composite"               => 4451,
                         "composites"              => 13433,
                         "compositing"             => 26241,
                         "composition"             => 1551,
                         "compositional"           => 11320,
                         "compositions"            => 2928,
                         "compostela"              => 15014,
                         "composting"              => 20402,
                         "compound"                => 2765,
                         "compounded"              => 11218,
                         "compounding"             => 16533,
                         "compounds"               => 3406,
                         "comprehensible"          => 25457,
                         "comprehensive"           => 2454,
                         "comprehensively"         => 17593,
                         "compressed"              => 6308,
                         "compresses"              => 29499,
                         "compressing"             => 23561,
                         "compression"             => 4838,
                         "compressive"             => 21409,
                         "compressor"              => 10161,
                         "compressors"             => 17336,
                         "comprise"                => 5140,
                         "comprised"               => 4083,
                         "comprises"               => 2772,
                         "comprising"              => 3308,
                         "comptroller"             => 9803,
                         "compulsory"              => 5193,
                         "compuserve"              => 28236,
                         "computable"              => 19911,
                         "computation"             => 7622,
                         "computational"           => 5506,
                         "computationally"         => 18642,
                         "computations"            => 15128,
                         "computed"                => 7696,
                         "computerised"            => 24663,
                         "computerized"            => 11087,
                         "computers"               => 2650,
                         "computes"                => 21532,
                         "computing"               => 3402,
                         "comte"                   => 7255,
                         "comune"                  => 6516,
                         "comuni"                  => 29495,
                         "comyn"                   => 21637,
                         "conakry"                 => 26994,
                         "conall"                  => 29233,
                         "concacaf"                => 7970,
                         "concatenation"           => 28603,
                         "concave"                 => 8999,
                         "conceals"                => 24234,
                         "conceded"                => 7014,
                         "concedes"                => 24294,
                         "conceding"               => 10648,
                         "conceicao"               => 22547,
                         "conceit"                 => 24718,
                         "conceived"               => 3610,
                         "concentrated"            => 3202,
                         "concentrates"            => 11054,
                         "concentration"           => 2376,
                         "concentrations"          => 4954,
                         "concentric"              => 11376,
                         "concept"                 => 1013,
                         "conceptions"             => 13682,
                         "concepts"                => 2832,
                         "conceptual"              => 6048,
                         "conceptualization"       => 25707,
                         "conceptualized"          => 17173,
                         "conceptually"            => 14783,
                         "concerning"              => 2460,
                         "concerns"                => 1968,
                         "concert"                 => 1113,
                         "concerted"               => 12784,
                         "concertgebouw"           => 23655,
                         "concerti"                => 26625,
                         "concertina"              => 29877,
                         "concertmaster"           => 21011,
                         "concerto"                => 4805,
                         "concertos"               => 10966,
                         "concerts"                => 2085,
                         "concession"              => 6481,
                         "concessions"             => 7041,
                         "conciliation"            => 17143,
                         "conciliatory"            => 19841,
                         "concise"                 => 12352,
                         "conclave"                => 10513,
                         "conclude"                => 6341,
                         "concluded"               => 1815,
                         "concludes"               => 5251,
                         "concluding"              => 6127,
                         "conclusion"              => 2571,
                         "concomitant"             => 20393,
                         "concordance"             => 23215,
                         "concordat"               => 17588,
                         "concordia"               => 8511,
                         "concours"                => 20715,
                         "concourse"               => 9721,
                         "concourses"              => 28386,
                         "concubine"               => 12091,
                         "concubines"              => 17301,
                         "concurred"               => 14625,
                         "concurrence"             => 18228,
                         "concurrency"             => 8042,
                         "concurrent"              => 5852,
                         "concurrently"            => 6223,
                         "concurring"              => 18931,
                         "condemnation"            => 9166,
                         "condemned"               => 3775,
                         "condemns"                => 18113,
                         "condensate"              => 20152,
                         "condensation"            => 11201,
                         "condense"                => 24689,
                         "condensed"               => 9060,
                         "condenser"               => 17405,
                         "condensing"              => 21638,
                         "condita"                 => 20845,
                         "conditional"             => 6733,
                         "conditionally"           => 25855,
                         "conditioned"             => 8228,
                         "conditions"              => 884,
                         "condoleezza"             => 23564,
                         "condominium"             => 11329,
                         "condominiums"            => 12651,
                         "condorcet"               => 24064,
                         "condors"                 => 25197,
                         "conducive"               => 13199,
                         "conduct"                 => 2065,
                         "conductance"             => 19764,
                         "conducted"               => 1060,
                         "conducting"              => 3323,
                         "conduction"              => 11285,
                         "conductive"              => 12540,
                         "conductivity"            => 10356,
                         "conductor"               => 3071,
                         "conductors"              => 7604,
                         "conducts"                => 6219,
                         "conduits"                => 24950,
                         "conestoga"               => 22856,
                         "confection"              => 29037,
                         "confectionery"           => 14092,
                         "confederacion"           => 28029,
                         "confederacy"             => 6317,
                         "confederate"             => 2612,
                         "confederates"            => 7881,
                         "confederation"           => 3841,
                         "confederations"          => 13321,
                         "conference"              => 511,
                         "conferences"             => 3066,
                         "conferencing"            => 17257,
                         "conferred"               => 5514,
                         "conferring"              => 17011,
                         "confers"                 => 16209,
                         "confesses"               => 7763,
                         "confessions"             => 8164,
                         "confessor"               => 12223,
                         "confidently"             => 18607,
                         "configurable"            => 23801,
                         "configuration"           => 3304,
                         "configurations"          => 7434,
                         "configure"               => 19853,
                         "configured"              => 8707,
                         "confined"                => 4752,
                         "confinement"             => 8063,
                         "confirmed"               => 1356,
                         "confiscated"             => 6353,
                         "confiscation"            => 13331,
                         "conflagration"           => 26280,
                         "conflated"               => 23315,
                         "conflict"                => 1314,
                         "conflicting"             => 7209,
                         "conflicts"               => 3320,
                         "confluence"              => 4995,
                         "conform"                 => 8037,
                         "conformal"               => 16605,
                         "conformance"             => 24924,
                         "conformation"            => 12275,
                         "conformational"          => 17916,
                         "conformed"               => 19283,
                         "conforming"              => 14656,
                         "conformist"              => 21118,
                         "conformity"              => 10826,
                         "conforms"                => 19063,
                         "confounding"             => 26938,
                         "confraternity"           => 20573,
                         "confrontation"           => 5395,
                         "confrontations"          => 12499,
                         "confronts"               => 6114,
                         "confucian"               => 10272,
                         "confucianism"            => 13710,
                         "confucius"               => 12440,
                         "confusingly"             => 18853,
                         "confusion"               => 3372,
                         "congenital"              => 9220,
                         "congested"               => 13125,
                         "congestion"              => 6841,
                         "congestive"              => 19484,
                         "congke"                  => 27498,
                         "conglomerate"            => 7948,
                         "conglomerates"           => 17429,
                         "congo"                   => 3244,
                         "congolese"               => 10163,
                         "congratulatory"          => 27614,
                         "congregants"             => 25052,
                         "congregate"              => 17668,
                         "congregated"             => 27954,
                         "congregation"            => 2624,
                         "congregational"          => 6971,
                         "congregationalist"       => 20302,
                         "congregations"           => 5532,
                         "congress"                => 731,
                         "congresses"              => 7369,
                         "congressional"           => 2614,
                         "congreve"                => 25660,
                         "congruence"              => 20558,
                         "congruent"               => 17431,
                         "conic"                   => 17161,
                         "conical"                 => 8223,
                         "conidae"                 => 19644,
                         "conidia"                 => 27863,
                         "conifer"                 => 14207,
                         "coniferous"              => 12623,
                         "conifers"                => 15398,
                         "coniston"                => 25992,
                         "conjecture"              => 7503,
                         "conjectured"             => 14323,
                         "conjectures"             => 18506,
                         "conjugate"               => 11104,
                         "conjugated"              => 16050,
                         "conjugation"             => 13156,
                         "conjunction"             => 3280,
                         "conjunctions"            => 25428,
                         "conjunto"                => 28307,
                         "conmebol"                => 17600,
                         "connacht"                => 8964,
                         "connaught"               => 12799,
                         "connected"               => 1211,
                         "connecticut"             => 1876,
                         "connecting"              => 2475,
                         "connections"             => 2437,
                         "connective"              => 13593,
                         "connectivity"            => 7161,
                         "connector"               => 6667,
                         "connectors"              => 10217,
                         "connects"                => 3013,
                         "connemara"               => 25506,
                         "connexion"               => 20362,
                         "connoisseurs"            => 26870,
                         "connotation"             => 14809,
                         "connotations"            => 11974,
                         "conor"                   => 12420,
                         "conquered"               => 3948,
                         "conqueror"               => 9044,
                         "conquerors"              => 17216,
                         "conquest"                => 3145,
                         "conquests"               => 10016,
                         "conquistador"            => 19777,
                         "conquistadors"           => 19257,
                         "conscript"               => 25201,
                         "conscripted"             => 13400,
                         "conscription"            => 8435,
                         "conscripts"              => 15082,
                         "consecrate"              => 26661,
                         "consecrated"             => 4500,
                         "consecration"            => 7963,
                         "consecrators"            => 16134,
                         "consecutive"             => 1614,
                         "consecutively"           => 11806,
                         "conseil"                 => 13088,
                         "consejo"                 => 14661,
                         "consensus"               => 3815,
                         "consent"                 => 3674,
                         "consents"                => 25254,
                         "consequence"             => 3416,
                         "consequent"              => 10238,
                         "consequential"           => 23302,
                         "consequently"            => 2947,
                         "conservancy"             => 9261,
                         "conservation"            => 1698,
                         "conservationist"         => 16587,
                         "conservationists"        => 19259,
                         "conservatism"            => 10835,
                         "conservative"            => 1223,
                         "conservatively"          => 28039,
                         "conservatives"           => 4022,
                         "conservatoire"           => 9667,
                         "conservator"             => 20621,
                         "conservatories"          => 23050,
                         "conservatorio"           => 28460,
                         "conservatorium"          => 18802,
                         "conservators"            => 26333,
                         "conservatory"            => 4145,
                         "conserved"               => 7043,
                         "conserving"              => 16389,
                         "considerable"            => 1924,
                         "considerably"            => 3489,
                         "considerations"          => 5882,
                         "considered"              => 340,
                         "considers"               => 3835,
                         "consigned"               => 20776,
                         "consignment"             => 22693,
                         "consist"                 => 2881,
                         "consisted"               => 1434,
                         "consistency"             => 6557,
                         "consistent"              => 2853,
                         "consistently"            => 3711,
                         "consisting"              => 1613,
                         "consistory"              => 14757,
                         "consists"                => 813,
                         "console"                 => 4203,
                         "consoles"                => 7583,
                         "consolidate"             => 8290,
                         "consolidated"            => 3777,
                         "consolidating"           => 11720,
                         "consolidation"           => 5873,
                         "consonant"               => 6747,
                         "consonants"              => 6683,
                         "consort"                 => 5325,
                         "consortia"               => 26659,
                         "consortium"              => 4312,
                         "consorts"                => 16018,
                         "conspecific"             => 22397,
                         "conspicuous"             => 7418,
                         "conspicuously"           => 18800,
                         "conspirators"            => 9891,
                         "constables"              => 11790,
                         "constabulary"            => 9247,
                         "constancy"               => 28475,
                         "constant"                => 1871,
                         "constanta"               => 17476,
                         "constantia"              => 27814,
                         "constantin"              => 9748,
                         "constantinople"          => 4009,
                         "constantius"             => 16440,
                         "constants"               => 9445,
                         "constellation"           => 5409,
                         "consternation"           => 18984,
                         "constituencies"          => 4438,
                         "constituency"            => 1455,
                         "constituent"             => 4518,
                         "constituents"            => 8010,
                         "constitute"              => 4123,
                         "constituted"             => 4395,
                         "constitutes"             => 6342,
                         "constituting"            => 10562,
                         "constitution"            => 1188,
                         "constitutional"          => 2066,
                         "constitutionality"       => 12522,
                         "constitutionally"        => 12511,
                         "constitutions"           => 10489,
                         "constitutive"            => 18249,
                         "constrain"               => 22750,
                         "constrained"             => 9335,
                         "constraint"              => 8729,
                         "constraints"             => 5219,
                         "constricted"             => 23271,
                         "constriction"            => 21881,
                         "construct"               => 3282,
                         "constructed"             => 892,
                         "constructing"            => 5585,
                         "construction"            => 393,
                         "constructions"           => 7394,
                         "constructivism"          => 21383,
                         "constructivist"          => 20381,
                         "constructor"             => 13588,
                         "constructors"            => 12164,
                         "constructs"              => 9610,
                         "consul"                  => 4738,
                         "consular"                => 10748,
                         "consulates"              => 14430,
                         "consuls"                 => 13643,
                         "consulship"              => 14651,
                         "consultancy"             => 7982,
                         "consultant"              => 3267,
                         "consultants"             => 7567,
                         "consultation"            => 5916,
                         "consultations"           => 11903,
                         "consultative"            => 9580,
                         "consulted"               => 6721,
                         "consulting"              => 3751,
                         "consume"                 => 7100,
                         "consumerism"             => 18284,
                         "consumers"               => 3642,
                         "consuming"               => 6924,
                         "consumption"             => 2906,
                         "contactless"             => 26651,
                         "contador"                => 17823,
                         "contagion"               => 22704,
                         "contain"                 => 1685,
                         "contained"               => 1469,
                         "container"               => 4965,
                         "containers"              => 6600,
                         "containing"              => 1387,
                         "contains"                => 671,
                         "contaminant"             => 23452,
                         "contaminants"            => 12431,
                         "contamination"           => 6673,
                         "contemplated"            => 12252,
                         "contemplates"            => 21592,
                         "contemplation"           => 13619,
                         "contemplative"           => 15488,
                         "contemporain"            => 28102,
                         "contemporaneous"         => 12447,
                         "contemporaries"          => 5651,
                         "contemporary"            => 935,
                         "contemptuous"            => 28940,
                         "contend"                 => 9655,
                         "contended"               => 9442,
                         "contender"               => 6925,
                         "contenders"              => 8614,
                         "contending"              => 15803,
                         "contends"                => 12060,
                         "content"                 => 1118,
                         "contention"              => 6630,
                         "contentious"             => 9319,
                         "contents"                => 3645,
                         "contest"                 => 1462,
                         "contestant"              => 4434,
                         "contestants"             => 3744,
                         "contested"               => 2364,
                         "contests"                => 5345,
                         "context"                 => 1893,
                         "contexts"                => 6264,
                         "contextual"              => 13646,
                         "contiguous"              => 8196,
                         "continent"               => 3621,
                         "continental"             => 2216,
                         "continents"              => 6292,
                         "contingent"              => 5692,
                         "contingents"             => 15821,
                         "continual"               => 9567,
                         "continually"             => 5515,
                         "continuation"            => 4766,
                         "continuations"           => 29501,
                         "continue"                => 965,
                         "continued"               => 337,
                         "continues"               => 1082,
                         "continuing"              => 1911,
                         "continuity"              => 4735,
                         "continuo"                => 16025,
                         "continuous"              => 2357,
                         "continuously"            => 3842,
                         "continuum"               => 8208,
                         "contours"                => 14144,
                         "contrabass"              => 27850,
                         "contraception"           => 13197,
                         "contraceptive"           => 16726,
                         "contract"                => 637,
                         "contracted"              => 3956,
                         "contracting"             => 7739,
                         "contractor"              => 5227,
                         "contractors"             => 6053,
                         "contracts"               => 2912,
                         "contractual"             => 9068,
                         "contractually"           => 25179,
                         "contradicted"            => 12035,
                         "contradiction"           => 9698,
                         "contradictions"          => 12601,
                         "contradictory"           => 9476,
                         "contradicts"             => 16013,
                         "contraindicated"         => 27865,
                         "contraindications"       => 24961,
                         "contralto"               => 20986,
                         "contrapuntal"            => 25578,
                         "contras"                 => 23551,
                         "contrast"                => 1786,
                         "contrasted"              => 7752,
                         "contrasting"             => 7802,
                         "contrasts"               => 7799,
                         "contravention"           => 23834,
                         "contre"                  => 21697,
                         "contribute"              => 3199,
                         "contributed"             => 1476,
                         "contributes"             => 5800,
                         "contributing"            => 2732,
                         "contribution"            => 2271,
                         "contributions"           => 1831,
                         "contributor"             => 4366,
                         "contributors"            => 5537,
                         "contributory"            => 21312,
                         "contrived"               => 15816,
                         "control"                 => 332,
                         "controllable"            => 18867,
                         "controlled"              => 1415,
                         "controller"              => 4339,
                         "controllers"             => 7374,
                         "controls"                => 2870,
                         "controversial"           => 2033,
                         "controversially"         => 10584,
                         "controversies"           => 5622,
                         "controversy"             => 1631,
                         "conurbation"             => 17066,
                         "conus"                   => 11135,
                         "convair"                 => 16803,
                         "convalescence"           => 27135,
                         "convalescent"            => 21660,
                         "convection"              => 7589,
                         "convective"              => 15513,
                         "convened"                => 6728,
                         "convener"                => 22717,
                         "conveniences"            => 26183,
                         "convening"               => 19271,
                         "convenor"                => 23159,
                         "convent"                 => 4231,
                         "convention"              => 1240,
                         "conventional"            => 2420,
                         "conventionally"          => 11291,
                         "conventions"             => 4185,
                         "convents"                => 16264,
                         "converge"                => 9368,
                         "converged"               => 15475,
                         "convergence"             => 6664,
                         "convergent"              => 12224,
                         "converges"               => 14343,
                         "converging"              => 15701,
                         "conversely"              => 6476,
                         "conversion"              => 2410,
                         "conversions"             => 8533,
                         "convert"                 => 3705,
                         "converted"               => 1443,
                         "converter"               => 9384,
                         "converters"              => 14714,
                         "converting"              => 5728,
                         "converts"                => 6773,
                         "convex"                  => 6560,
                         "convey"                  => 6865,
                         "conveyance"              => 18836,
                         "conveyed"                => 8205,
                         "conveying"               => 13151,
                         "conveys"                 => 13276,
                         "convicts"                => 8738,
                         "convinces"               => 6643,
                         "convincingly"            => 14706,
                         "convocation"             => 12435,
                         "convolution"             => 18855,
                         "convoy"                  => 3254,
                         "convoys"                 => 7392,
                         "conwy"                   => 17061,
                         "conyngham"               => 25165,
                         "cooch"                   => 24273,
                         "cookery"                 => 14215,
                         "cookware"                => 29266,
                         "coolant"                 => 13703,
                         "cooled"                  => 5912,
                         "cooling"                 => 4425,
                         "cooperated"              => 10336,
                         "cooperates"              => 17544,
                         "cooperation"             => 2308,
                         "cooperative"             => 3872,
                         "cooperatively"           => 21433,
                         "cooperatives"            => 10259,
                         "cooperstown"             => 19923,
                         "coordinate"              => 4833,
                         "coordinated"             => 5205,
                         "coordinates"             => 3846,
                         "coordinating"            => 7131,
                         "coordination"            => 4704,
                         "coordinator"             => 4109,
                         "coordinators"            => 17108,
                         "coorg"                   => 26136,
                         "coosa"                   => 29846,
                         "coote"                   => 19941,
                         "copa"                    => 4271,
                         "copacabana"              => 24365,
                         "copan"                   => 26614,
                         "copelatus"               => 17503,
                         "copenhagen"              => 3488,
                         "copepods"                => 23466,
                         "copies"                  => 1370,
                         "copious"                 => 16054,
                         "coppi"                   => 29669,
                         "copra"                   => 25648,
                         "copse"                   => 28502,
                         "coptic"                  => 8796,
                         "copts"                   => 26790,
                         "copula"                  => 23305,
                         "copulation"              => 18861,
                         "copying"                 => 8677,
                         "copyist"                 => 27297,
                         "copyright"               => 3419,
                         "copyrighted"             => 11850,
                         "copyrights"              => 14131,
                         "copywriter"              => 23764,
                         "coquille"                => 28580,
                         "coquitlam"               => 19214,
                         "coraciiformesfamily"     => 26796,
                         "corals"                  => 12009,
                         "corba"                   => 29510,
                         "corbels"                 => 28916,
                         "corbet"                  => 15945,
                         "corbusier"               => 16612,
                         "cordillera"              => 11047,
                         "core"                    => 1378,
                         "corelli"                 => 25884,
                         "cores"                   => 8795,
                         "corfu"                   => 12439,
                         "corinth"                 => 9637,
                         "corinthian"              => 10526,
                         "corinthians"             => 10591,
                         "coriolis"                => 23843,
                         "cork"                    => 3040,
                         "cormorant"               => 17581,
                         "cormorants"              => 18119,
                         "corneal"                 => 15397,
                         "corneille"               => 25599,
                         "cornelis"                => 11745,
                         "cornerback"              => 9503,
                         "cornerstone"             => 7671,
                         "cornerstones"            => 27738,
                         "cornhill"                => 25704,
                         "cornhuskers"             => 13760,
                         "cornice"                 => 9962,
                         "cornices"                => 20684,
                         "cornwall"                => 3599,
                         "corollary"               => 18409,
                         "coromandel"              => 20396,
                         "coronal"                 => 21506,
                         "coronation"              => 4605,
                         "corot"                   => 25977,
                         "corp."                   => 6615,
                         "corpora"                 => 29452,
                         "corporate"               => 1863,
                         "corporation"             => 896,
                         "corporations"            => 3963,
                         "corps"                   => 890,
                         "corpus"                  => 5017,
                         "correctional"            => 6954,
                         "corrections"             => 7545,
                         "corrective"              => 12474,
                         "correctness"             => 14079,
                         "corrects"                => 24360,
                         "corregidor"              => 20154,
                         "corregimiento"           => 28558,
                         "correlate"               => 13031,
                         "correlated"              => 8244,
                         "correlates"              => 14328,
                         "correlation"             => 5992,
                         "correlations"            => 13474,
                         "correspond"              => 5898,
                         "corresponded"            => 8962,
                         "correspondence"          => 3999,
                         "correspondences"         => 19178,
                         "correspondent"           => 4087,
                         "correspondents"          => 11148,
                         "corresponding"           => 2619,
                         "correspondingly"         => 15276,
                         "corresponds"             => 5175,
                         "correze"                 => 27662,
                         "corridor"                => 3655,
                         "corridors"               => 8585,
                         "corrientes"              => 20330,
                         "corroborated"            => 16532,
                         "corrosion"               => 8184,
                         "corrugated"              => 11384,
                         "corruption"              => 2747,
                         "corsairs"                => 21289,
                         "corsican"                => 15977,
                         "corte"                   => 18329,
                         "cortex"                  => 6077,
                         "cortical"                => 11595,
                         "corticosteroids"         => 24588,
                         "cortisol"                => 18923,
                         "cortona"                 => 28327,
                         "coruna"                  => 14277,
                         "corus"                   => 19537,
                         "corvallis"               => 18915,
                         "corvettes"               => 12933,
                         "corvinus"                => 20902,
                         "corydon"                 => 28596,
                         "cosimo"                  => 14705,
                         "cosine"                  => 19826,
                         "cosmas"                  => 24601,
                         "cosmodrome"              => 20741,
                         "cosmological"            => 13436,
                         "cosmology"               => 9811,
                         "cosmonaut"               => 17186,
                         "cosmonauts"              => 21916,
                         "cosmopolitan"            => 8583,
                         "cosmopterigidae"         => 15896,
                         "cosmopterix"             => 28711,
                         "cosplay"                 => 24379,
                         "cossack"                 => 10115,
                         "cossacks"                => 9568,
                         "cossidae"                => 18255,
                         "cost"                    => 767,
                         "costal"                  => 10493,
                         "costliest"               => 28901,
                         "costly"                  => 6088,
                         "costs"                   => 1620,
                         "costumed"                => 15026,
                         "cotabato"                => 20317,
                         "coterminous"             => 26297,
                         "cotes"                   => 16465,
                         "cotonou"                 => 28851,
                         "cotswold"                => 18354,
                         "cottages"                => 6885,
                         "cottbus"                 => 20473,
                         "cottonwood"              => 13503,
                         "coulee"                  => 21254,
                         "coulomb"                 => 18460,
                         "coulthard"               => 14127,
                         "council"                 => 247,
                         "councillor"              => 4507,
                         "councillors"             => 4748,
                         "councilors"              => 14258,
                         "councils"                => 3743,
                         "counsellors"             => 22632,
                         "counsels"                => 21478,
                         "countable"               => 16528,
                         "counted"                 => 4008,
                         "counter"                 => 2127,
                         "counteract"              => 12706,
                         "counterattack"           => 9178,
                         "counterattacked"         => 22061,
                         "counterattacks"          => 18559,
                         "counterbalance"          => 21281,
                         "counterclockwise"        => 20773,
                         "counterculture"          => 15662,
                         "countered"               => 9551,
                         "countering"              => 16169,
                         "counterinsurgency"       => 21693,
                         "countermeasure"          => 26642,
                         "countermeasures"         => 13638,
                         "counteroffensive"        => 20427,
                         "counterpart"             => 4903,
                         "counterparts"            => 5131,
                         "counterpoint"            => 11463,
                         "counters"                => 9694,
                         "counterterrorism"        => 19869,
                         "counterweight"           => 20911,
                         "countess"                => 4839,
                         "counties"                => 1674,
                         "countries"               => 479,
                         "country"                 => 219,
                         "countryside"             => 4170,
                         "countrywide"             => 20575,
                         "county"                  => 105,
                         "countywide"              => 14752,
                         "coup"                    => 2872,
                         "coupe"                   => 5668,
                         "coupes"                  => 18569,
                         "coupled"                 => 4066,
                         "coupler"                 => 21370,
                         "couplers"                => 23386,
                         "couples"                 => 1801,
                         "couplet"                 => 18007,
                         "couplets"                => 19193,
                         "coupling"                => 7001,
                         "couplings"               => 20709,
                         "coups"                   => 17080,
                         "courant"                 => 16365,
                         "courbet"                 => 22405,
                         "courland"                => 17751,
                         "cours"                   => 19933,
                         "coursed"                 => 28700,
                         "courses"                 => 1484,
                         "coursework"              => 12704,
                         "court"                   => 244,
                         "courtauld"               => 25220,
                         "courtenay"               => 11209,
                         "courtesan"               => 19811,
                         "courthouses"             => 19767,
                         "courtier"                => 12907,
                         "courtiers"               => 14744,
                         "courtland"               => 29686,
                         "courtly"                 => 16903,
                         "courts"                  => 1630,
                         "courtyard"               => 5348,
                         "courtyards"              => 15520,
                         "coutinho"                => 24521,
                         "covalent"                => 15051,
                         "covalently"              => 24424,
                         "covariance"              => 16079,
                         "covariant"               => 19135,
                         "cove"                    => 4393,
                         "covenant"                => 6214,
                         "covenanters"             => 22949,
                         "covenants"               => 15809,
                         "covent"                  => 9163,
                         "cover"                   => 725,
                         "coverage"                => 1923,
                         "covered"                 => 866,
                         "covering"                => 1947,
                         "coverings"               => 20027,
                         "covers"                  => 1289,
                         "coverts"                 => 19519,
                         "coves"                   => 26396,
                         "coveted"                 => 9053,
                         "cowdenbeath"             => 21897,
                         "cowes"                   => 19401,
                         "cowichan"                => 28381,
                         "cowper"                  => 15402,
                         "cowries"                 => 26312,
                         "cowry"                   => 28044,
                         "coxae"                   => 17412,
                         "coxed"                   => 18730,
                         "coxeter"                 => 16323,
                         "coxless"                 => 20172,
                         "coxswain"                => 20781,
                         "cpusa"                   => 24465,
                         "crackdown"               => 11239,
                         "cracow"                  => 19386,
                         "cradock"                 => 24723,
                         "crafted"                 => 7580,
                         "crafting"                => 14302,
                         "crafts"                  => 5106,
                         "craftsman"               => 9346,
                         "craftsmen"               => 8582,
                         "crags"                   => 17804,
                         "craigie"                 => 22230,
                         "craigslist"              => 26979,
                         "craiova"                 => 18484,
                         "crambidae"               => 6338,
                         "cranbrook"               => 16591,
                         "cranial"                 => 12284,
                         "crankcase"               => 22366,
                         "crankshaft"              => 12992,
                         "crassus"                 => 17386,
                         "crataegus"               => 25770,
                         "crater"                  => 3565,
                         "craters"                 => 7842,
                         "creamery"                => 18603,
                         "create"                  => 742,
                         "created"                 => 293,
                         "creates"                 => 3099,
                         "creating"                => 1323,
                         "creation"                => 1096,
                         "creationism"             => 16574,
                         "creationist"             => 22808,
                         "creationists"            => 28732,
                         "creativity"              => 5629,
                         "creator"                 => 3203,
                         "creators"                => 6174,
                         "credential"              => 18806,
                         "creditable"              => 25450,
                         "credited"                => 1808,
                         "crediting"               => 20719,
                         "creditor"                => 13519,
                         "creditors"               => 7811,
                         "credits"                 => 2046,
                         "creek"                   => 829,
                         "creeks"                  => 8477,
                         "crematoria"              => 29485,
                         "cremona"                 => 14006,
                         "creole"                  => 7486,
                         "creoles"                 => 19586,
                         "crest"                   => 4180,
                         "crested"                 => 10275,
                         "creston"                 => 27280,
                         "crests"                  => 13561,
                         "crestwood"               => 24409,
                         "cretaceous"              => 6279,
                         "cretan"                  => 14055,
                         "crete"                   => 6703,
                         "creuse"                  => 26681,
                         "crevices"                => 16481,
                         "crew"                    => 1006,
                         "crewe"                   => 7861,
                         "crewed"                  => 18006,
                         "crewmembers"             => 20146,
                         "crewmen"                 => 12024,
                         "cricketer"               => 2930,
                         "cricketers"              => 9819,
                         "cricketing"              => 16170,
                         "crimea"                  => 7613,
                         "crimean"                 => 7054,
                         "criminality"             => 20822,
                         "criminalized"            => 29640,
                         "criminology"             => 13061,
                         "criollo"                 => 28684,
                         "criollos"                => 29196,
                         "crises"                  => 8607,
                         "crisis"                  => 1643,
                         "crispa"                  => 25921,
                         "cristoforo"              => 29462,
                         "criteria"                => 3123,
                         "criterion"               => 6634,
                         "criterium"               => 19788,
                         "critic"                  => 2022,
                         "critical"                => 894,
                         "criticality"             => 27128,
                         "critically"              => 3904,
                         "criticised"              => 3697,
                         "criticises"              => 21821,
                         "criticising"             => 13108,
                         "criticism"               => 1713,
                         "criticisms"              => 5732,
                         "criticized"              => 2035,
                         "criticizes"              => 11851,
                         "criticizing"             => 7597,
                         "critics"                 => 1150,
                         "critique"                => 6038,
                         "critiqued"               => 18047,
                         "critiques"               => 11355,
                         "croat"                   => 13415,
                         "croatia"                 => 2759,
                         "croatian"                => 2781,
                         "croats"                  => 8657,
                         "crocodiles"              => 11583,
                         "crocodilians"            => 25491,
                         "crohn"                   => 21738,
                         "croix"                   => 7404,
                         "cromarty"                => 26734,
                         "cromwellian"             => 28383,
                         "cronenberg"              => 25167,
                         "cronulla"                => 14176,
                         "crookes"                 => 29204,
                         "crop"                    => 3892,
                         "cropland"                => 29388,
                         "cropping"                => 18392,
                         "crops"                   => 2942,
                         "crore"                   => 10822,
                         "crores"                  => 15369,
                         "crossbar"                => 16559,
                         "crosse"                  => 13536,
                         "crosses"                 => 2757,
                         "crossing"                => 1746,
                         "crossings"               => 6986,
                         "crossover"               => 5899,
                         "crossovers"              => 17914,
                         "crossrail"               => 23774,
                         "crossroad"               => 24969,
                         "crossroads"              => 6405,
                         "crosstown"               => 16138,
                         "croton"                  => 17169,
                         "crowdfunding"            => 16549,
                         "crowds"                  => 5415,
                         "crowdsourcing"           => 24735,
                         "crown"                   => 1298,
                         "crowne"                  => 29864,
                         "crowned"                 => 3684,
                         "crowns"                  => 8538,
                         "croydon"                 => 7328,
                         "crucial"                 => 3755,
                         "crucially"               => 20721,
                         "cruciate"                => 15046,
                         "crucible"                => 14358,
                         "crucifixion"             => 10270,
                         "cruciform"               => 15731,
                         "crucis"                  => 29290,
                         "crude"                   => 5635,
                         "cruised"                 => 12893,
                         "cruisers"                => 6028,
                         "cruiserweight"           => 15258,
                         "cruises"                 => 7774,
                         "crumlin"                 => 26232,
                         "crusade"                 => 5904,
                         "crusaders"               => 6595,
                         "crusades"                => 11559,
                         "crusading"               => 26031,
                         "crustacean"              => 22157,
                         "crustaceans"             => 10198,
                         "crustal"                 => 21427,
                         "cruyff"                  => 28848,
                         "cruzeiro"                => 16791,
                         "crvena"                  => 26480,
                         "cryogenic"               => 16761,
                         "cryptanalysis"           => 24377,
                         "cryptographic"           => 13131,
                         "cryptography"            => 11873,
                         "crystalline"             => 9006,
                         "crystallization"         => 17861,
                         "crystallized"            => 20582,
                         "crystallographic"        => 24159,
                         "crystallography"         => 16444,
                         "crystals"                => 6007,
                         "csiro"                   => 20142,
                         "ctesiphon"               => 23321,
                         "cuando"                  => 27904,
                         "cuatro"                  => 20663,
                         "cuauhtemoc"              => 22359,
                         "cuba"                    => 2508,
                         "cuban"                   => 3335,
                         "cubic"                   => 5270,
                         "cubism"                  => 15147,
                         "cubist"                  => 17358,
                         "cubitt"                  => 25519,
                         "cuckoos"                 => 19398,
                         "cuddalore"               => 23086,
                         "cuernavaca"              => 25021,
                         "cuisine"                 => 4152,
                         "cuisines"                => 14268,
                         "culled"                  => 18930,
                         "culling"                 => 23269,
                         "culloden"                => 22259,
                         "culminate"               => 18659,
                         "culminated"              => 5706,
                         "culminates"              => 13923,
                         "culminating"             => 5747,
                         "culmination"             => 10048,
                         "culpeper"                => 20101,
                         "culprits"                => 22008,
                         "cult"                    => 3044,
                         "cultivar"                => 10345,
                         "cultivars"               => 9131,
                         "cultivate"               => 9905,
                         "cultivated"              => 4663,
                         "cultivation"             => 3990,
                         "cultivators"             => 19726,
                         "cults"                   => 11637,
                         "cultura"                 => 15789,
                         "cultural"                => 703,
                         "culturally"              => 6958,
                         "culture"                 => 547,
                         "cultured"                => 11525,
                         "cultures"                => 2916,
                         "culvert"                 => 20110,
                         "culverts"                => 26185,
                         "cuman"                   => 29033,
                         "cumann"                  => 23179,
                         "cumans"                  => 22760,
                         "cumberland"              => 4191,
                         "cumbernauld"             => 27900,
                         "cumbersome"              => 15726,
                         "cumbia"                  => 20226,
                         "cumbria"                 => 8273,
                         "cumulative"              => 7773,
                         "cunard"                  => 14356,
                         "cundinamarca"            => 29781,
                         "cuneiform"               => 14448,
                         "cunxu"                   => 21018,
                         "cup"                     => 267,
                         "cupen"                   => 28985,
                         "cupertino"               => 28074,
                         "cupola"                  => 10860,
                         "curacao"                 => 11534,
                         "curacies"                => 27326,
                         "curacy"                  => 17756,
                         "curate"                  => 9058,
                         "curated"                 => 7783,
                         "curative"                => 20753,
                         "curator"                 => 5390,
                         "curatorial"              => 19646,
                         "curators"                => 14387,
                         "curbing"                 => 27650,
                         "curia"                   => 12339,
                         "curiae"                  => 24262,
                         "curiosities"             => 19846,
                         "curiously"               => 13819,
                         "curler"                  => 17300,
                         "curling"                 => 5698,
                         "curragh"                 => 19332,
                         "currencies"              => 10756,
                         "currency"                => 3327,
                         "current"                 => 369,
                         "currently"               => 318,
                         "currents"                => 5713,
                         "curricula"               => 10615,
                         "curricular"              => 8712,
                         "curriculum"              => 2716,
                         "cursive"                 => 17488,
                         "cursor"                  => 16561,
                         "curtail"                 => 18351,
                         "curtailed"               => 11615,
                         "curvature"               => 8316,
                         "curve"                   => 3456,
                         "curved"                  => 4676,
                         "curves"                  => 4911,
                         "curvilinear"             => 22375,
                         "curving"                 => 11014,
                         "curzon"                  => 12938,
                         "cusco"                   => 17210,
                         "cusps"                   => 21491,
                         "custodians"              => 24676,
                         "customarily"             => 16355,
                         "customary"               => 6222,
                         "customers"               => 2148,
                         "customised"              => 24307,
                         "customizable"            => 17461,
                         "customization"           => 15260,
                         "customize"               => 16024,
                         "customized"              => 9157,
                         "customs"                 => 2976,
                         "custos"                  => 24284,
                         "cutaneous"               => 14112,
                         "cutoff"                  => 12569,
                         "cutscenes"               => 21943,
                         "cuttack"                 => 18336,
                         "cuttings"                => 13281,
                         "cuttlefish"              => 24998,
                         "cutty"                   => 26707,
                         "cuvier"                  => 21774,
                         "cuyahoga"                => 16167,
                         "cuzco"                   => 23604,
                         "cyanobacteria"           => 19065,
                         "cyathea"                 => 29487,
                         "cybele"                  => 27213,
                         "cybermen"                => 19535,
                         "cybernetic"              => 17875,
                         "cybernetics"             => 17872,
                         "cyberpunk"               => 19508,
                         "cybersecurity"           => 25083,
                         "cybertron"               => 13091,
                         "cyborgs"                 => 27666,
                         "cyclades"                => 28108,
                         "cyclase"                 => 27642,
                         "cycle"                   => 1651,
                         "cycled"                  => 22770,
                         "cycles"                  => 4824,
                         "cyclic"                  => 7806,
                         "cyclical"                => 16896,
                         "cyclin"                  => 18927,
                         "cycling"                 => 3354,
                         "cyclist"                 => 4938,
                         "cycliste"                => 27054,
                         "cyclists"                => 6737,
                         "cyclo"                   => 18749,
                         "cyclonic"                => 19660,
                         "cygni"                   => 29742,
                         "cylinder"                => 2920,
                         "cylinders"               => 6752,
                         "cylindrical"             => 6669,
                         "cymbals"                 => 12995,
                         "cymru"                   => 11933,
                         "cynon"                   => 29153,
                         "cyprinid"                => 29115,
                         "cyprinidae"              => 27188,
                         "cypriot"                 => 7028,
                         "cypriots"                => 14788,
                         "cyprus"                  => 3403,
                         "cyrenaica"               => 20460,
                         "cyrene"                  => 25139,
                         "cyrillic"                => 6500,
                         "cysteine"                => 15064,
                         "cystic"                  => 15288,
                         "cysts"                   => 15712,
                         "cytochrome"              => 13381,
                         "cytokine"                => 19072,
                         "cytokines"               => 16421,
                         "cytoplasm"               => 12788,
                         "cytoplasmic"             => 14024,
                         "cytosine"                => 28270,
                         "cytoskeleton"            => 23506,
                         "cytosol"                 => 23348,
                         "cytosolic"               => 26371,
                         "cytotoxic"               => 20488,
                         "czech"                   => 1788,
                         "czechoslovak"            => 7291,
                         "czechoslovakia"          => 4525,
                         "czechs"                  => 13823,
                         "czeslaw"                 => 25787,
                         "czestochowa"             => 16740,
                         "d'affaires"              => 17456,
                         "d'amato"                 => 22592,
                         "d'amico"                 => 26758,
                         "d'amore"                 => 18369,
                         "d'annunzio"              => 29746,
                         "d'arc"                   => 26001,
                         "d'armor"                 => 29964,
                         "d'art"                   => 13790,
                         "d'arte"                  => 27059,
                         "d'automne"               => 28668,
                         "d'auvergne"              => 27317,
                         "d'azur"                  => 18875,
                         "d'estaing"               => 23720,
                         "d'este"                  => 17187,
                         "d'etat"                  => 6629,
                         "d'etudes"                => 18693,
                         "d'histoire"              => 21356,
                         "d'hondt"                 => 20198,
                         "d'honneur"               => 11015,
                         "d'italia"                => 10013,
                         "d'ivoire"                => 9153,
                         "d'orleans"               => 16232,
                         "d'oro"                   => 21687,
                         "d'orsay"                 => 25097,
                         "d'oyly"                  => 14777,
                         "d'souza"                 => 19935,
                         "d'une"                   => 29836,
                         "d.c."                    => 2395,
                         "d.c.."                   => 12445,
                         "dabrowa"                 => 17031,
                         "dabrowka"                => 27477,
                         "dacian"                  => 14872,
                         "dacians"                 => 25758,
                         "dacre"                   => 20165,
                         "daegu"                   => 13677,
                         "daejeon"                 => 21925,
                         "dafydd"                  => 18051,
                         "dagbladet"               => 23788,
                         "dagenham"                => 12986,
                         "dahomey"                 => 18441,
                         "daigo"                   => 22100,
                         "daihatsu"                => 24436,
                         "daiichi"                 => 26310,
                         "daily"                   => 875,
                         "daimler"                 => 9500,
                         "daimyo"                  => 11412,
                         "dairies"                 => 22228,
                         "dairy"                   => 4259,
                         "daizong"                 => 28643,
                         "dakar"                   => 10015,
                         "dakshina"                => 23375,
                         "dalarna"                 => 28387,
                         "dalek"                   => 13704,
                         "daleks"                  => 11055,
                         "dalhousie"               => 12078,
                         "dalian"                  => 12334,
                         "dalit"                   => 15356,
                         "dalits"                  => 21051,
                         "dalkeith"                => 29338,
                         "dallara"                 => 25080,
                         "dallas/fort"             => 27161,
                         "dalles"                  => 23706,
                         "dalmatia"                => 10158,
                         "dalmatian"               => 14699,
                         "daltrey"                 => 21163,
                         "damage"                  => 1155,
                         "damaged"                 => 1854,
                         "damages"                 => 4465,
                         "damascus"                => 5607,
                         "dame"                    => 3124,
                         "dammed"                  => 14736,
                         "damming"                 => 19278,
                         "damodar"                 => 20578,
                         "dampers"                 => 21933,
                         "damping"                 => 14911,
                         "dams"                    => 5697,
                         "damselfly"               => 25116,
                         "danby"                   => 21525,
                         "danceable"               => 29122,
                         "dancefloor"              => 23747,
                         "dancehall"               => 14635,
                         "dancers"                 => 4027,
                         "dances"                  => 4246,
                         "dandenong"               => 16347,
                         "danish"                  => 1803,
                         "dannebrog"               => 29454,
                         "danse"                   => 17966,
                         "dansk"                   => 25690,
                         "danske"                  => 25809,
                         "danube"                  => 5694,
                         "danubian"                => 21982,
                         "danville"                => 10510,
                         "danza"                   => 22152,
                         "daoist"                  => 22262,
                         "daraa"                   => 28945,
                         "darbar"                  => 27103,
                         "darbhanga"               => 25296,
                         "dardanelles"             => 15451,
                         "daredevils"              => 27480,
                         "darfur"                  => 11486,
                         "dargah"                  => 20104,
                         "darjeeling"              => 13742,
                         "darke"                   => 27126,
                         "darkening"               => 23675,
                         "darker"                  => 4921,
                         "darkly"                  => 17368,
                         "darko"                   => 19513,
                         "darkseid"                => 19427,
                         "darlington"              => 6891,
                         "darmstadt"               => 9645,
                         "darna"                   => 27841,
                         "darpa"                   => 16115,
                         "darreh"                  => 9687,
                         "darshan"                 => 17298,
                         "darters"                 => 24917,
                         "dartford"                => 14476,
                         "dartmoor"                => 16901,
                         "dartmouth"               => 5943,
                         "darts"                   => 6949,
                         "darul"                   => 18521,
                         "darwen"                  => 19789,
                         "darya"                   => 17981,
                         "dashes"                  => 19787,
                         "dasht"                   => 12107,
                         "dassault"                => 16552,
                         "data"                    => 528,
                         "database"                => 2733,
                         "databases"               => 6367,
                         "dataset"                 => 16991,
                         "datasets"                => 18468,
                         "dated"                   => 2099,
                         "dates"                   => 1584,
                         "dative"                  => 18322,
                         "datong"                  => 28196,
                         "datuk"                   => 16595,
                         "datum"                   => 18414,
                         "daugava"                 => 22166,
                         "daugavpils"              => 27420,
                         "daughters"               => 1929,
                         "dauntless"               => 22902,
                         "davao"                   => 11444,
                         "daventry"                => 23794,
                         "daviess"                 => 27852,
                         "davos"                   => 16061,
                         "dawla"                   => 15449,
                         "day"                     => 126,
                         "dayak"                   => 26069,
                         "dayal"                   => 21620,
                         "days"                    => 323,
                         "daytime"                 => 4453,
                         "deaconess"               => 28876,
                         "deactivation"            => 19861,
                         "deadliest"               => 11586,
                         "deadlocked"              => 24350,
                         "deadpan"                 => 26953,
                         "deafness"                => 16085,
                         "dealerships"             => 14723,
                         "deanery"                 => 9971,
                         "death"                   => 196,
                         "deathmatch"              => 23329,
                         "deaths"                  => 2346,
                         "deathstroke"             => 29513,
                         "deauville"               => 21089,
                         "debarge"                 => 28405,
                         "debate"                  => 1886,
                         "debated"                 => 6100,
                         "debater"                 => 29305,
                         "debates"                 => 4972,
                         "debian"                  => 16099,
                         "debit"                   => 13383,
                         "debre"                   => 27647,
                         "debrecen"                => 18098,
                         "debris"                  => 5053,
                         "debtor"                  => 12654,
                         "debtors"                 => 16681,
                         "debug"                   => 24391,
                         "debugging"               => 17678,
                         "debunked"                => 29675,
                         "debussy"                 => 13112,
                         "debut"                   => 412,
                         "debutant"                => 15831,
                         "debuted"                 => 1848,
                         "debuting"                => 7977,
                         "debuts"                  => 9254,
                         "debye"                   => 28485,
                         "decadal"                 => 27048,
                         "decade"                  => 1645,
                         "decades"                 => 1550,
                         "decal"                   => 28872,
                         "decals"                  => 23610,
                         "decarboxylase"           => 27293,
                         "decathlon"               => 12805,
                         "decay"                   => 4934,
                         "decayed"                 => 14333,
                         "decays"                  => 16664,
                         "decca"                   => 8720,
                         "deccan"                  => 10441,
                         "deceased"                => 3983,
                         "deceleration"            => 22566,
                         "december"                => 174,
                         "decentralised"           => 29361,
                         "decentralization"        => 16011,
                         "decentralized"           => 12341,
                         "decepticon"              => 13801,
                         "decepticons"             => 11708,
                         "decided"                 => 558,
                         "decider"                 => 9845,
                         "decides"                 => 2452,
                         "deciduous"               => 7803,
                         "decile"                  => 28924,
                         "decimated"               => 12202,
                         "decimation"              => 29306,
                         "decisive"                => 4733,
                         "decisively"              => 10797,
                         "decius"                  => 27535,
                         "deckers"                 => 21053,
                         "decking"                 => 25405,
                         "decks"                   => 7634,
                         "declaration"             => 2848,
                         "declarations"            => 11261,
                         "declarative"             => 19086,
                         "declaratory"             => 29850,
                         "declared"                => 1101,
                         "declarer"                => 28321,
                         "declares"                => 7058,
                         "declaring"               => 5041,
                         "declassified"            => 16970,
                         "declension"              => 17893,
                         "declination"             => 21865,
                         "decline"                 => 2019,
                         "declined"                => 2093,
                         "declines"                => 8678,
                         "declining"               => 4937,
                         "decoders"                => 28892,
                         "decoding"                => 12711,
                         "decolonization"          => 25065,
                         "decommissioned"          => 4872,
                         "decommissioning"         => 9288,
                         "decomposes"              => 21120,
                         "decomposition"           => 7558,
                         "decompression"           => 12919,
                         "decor"                   => 11445,
                         "decorated"               => 2783,
                         "decoration"              => 4230,
                         "decorations"             => 4928,
                         "decorative"              => 4383,
                         "decrease"                => 3492,
                         "decreased"               => 3792,
                         "decreases"               => 6314,
                         "decreasing"              => 6018,
                         "decree"                  => 3695,
                         "decreed"                 => 9695,
                         "decrees"                 => 9395,
                         "decried"                 => 18677,
                         "decrypt"                 => 27238,
                         "dedekind"                => 25057,
                         "dedicated"               => 1005,
                         "dedicates"               => 21082,
                         "dedicating"              => 16256,
                         "dedication"              => 4539,
                         "dedications"             => 23137,
                         "deduced"                 => 11977,
                         "deduces"                 => 20966,
                         "deducted"                => 13847,
                         "deeded"                  => 16706,
                         "deemed"                  => 3019,
                         "deeming"                 => 19183,
                         "deepa"                   => 25584,
                         "deepen"                  => 16966,
                         "deepened"                => 14296,
                         "deepening"               => 14715,
                         "deepwater"               => 13485,
                         "deer"                    => 3382,
                         "deerfield"               => 13755,
                         "defamation"              => 9014,
                         "defamatory"              => 21847,
                         "defaulted"               => 18890,
                         "defaults"                => 22459,
                         "defeat"                  => 1085,
                         "defeated"                => 648,
                         "defeating"               => 2050,
                         "defeats"                 => 5284,
                         "defecation"              => 28875,
                         "defect"                  => 7588,
                         "defected"                => 8801,
                         "defecting"               => 24093,
                         "defection"               => 12487,
                         "defections"              => 21950,
                         "defectors"               => 18669,
                         "defects"                 => 6597,
                         "defence"                 => 1374,
                         "defenceman"              => 9159,
                         "defencemen"              => 27225,
                         "defences"                => 6011,
                         "defendants"              => 5862,
                         "defended"                => 2855,
                         "defenders"               => 4411,
                         "defends"                 => 10943,
                         "defense"                 => 870,
                         "defensed"                => 26792,
                         "defenseman"              => 13447,
                         "defensemen"              => 28005,
                         "defenses"                => 5460,
                         "defensible"              => 20378,
                         "defensive"               => 1804,
                         "defensively"             => 17605,
                         "defensor"                => 27301,
                         "deferred"                => 10278,
                         "defiance"                => 8642,
                         "deficiencies"            => 10182,
                         "deficiency"              => 6722,
                         "deficient"               => 10107,
                         "deficit"                 => 5244,
                         "deficits"                => 10105,
                         "definable"               => 26693,
                         "define"                  => 3353,
                         "defined"                 => 1156,
                         "defines"                 => 4063,
                         "defining"                => 4573,
                         "definition"              => 1763,
                         "definitions"             => 4754,
                         "definitive"              => 5680,
                         "definitively"            => 12175,
                         "deflation"               => 22085,
                         "deflected"               => 13543,
                         "deflection"              => 13641,
                         "deflections"             => 25396,
                         "deforestation"           => 9574,
                         "deform"                  => 29439,
                         "deformation"             => 9425,
                         "deformations"            => 25507,
                         "deformities"             => 21388,
                         "defunct"                 => 3943,
                         "degc"                    => 3671,
                         "degeneracy"              => 27191,
                         "degenerated"             => 16765,
                         "degeneration"            => 12515,
                         "degeneres"               => 16508,
                         "degli"                   => 13118,
                         "degradation"             => 5958,
                         "degraded"                => 8510,
                         "degrades"                => 22711,
                         "degree"                  => 518,
                         "degrees"                 => 1656,
                         "dehestan"                => 11837,
                         "dehradun"                => 17538,
                         "dehydrogenase"           => 9740,
                         "deified"                 => 23460,
                         "deild"                   => 28536,
                         "deism"                   => 28355,
                         "deities"                 => 5702,
                         "deity"                   => 4646,
                         "dejan"                   => 16923,
                         "dejected"                => 27186,
                         "dekalb"                  => 12668,
                         "delamere"                => 27947,
                         "delaunay"                => 22172,
                         "delaware"                => 2748,
                         "delayed"                 => 3039,
                         "delays"                  => 5163,
                         "delegate"                => 4236,
                         "delegated"               => 10354,
                         "delegates"               => 3660,
                         "delegation"              => 3827,
                         "delegations"             => 10666,
                         "deleted"                 => 6610,
                         "deleterious"             => 19017,
                         "deleting"                => 20109,
                         "deletion"                => 10877,
                         "deletions"               => 22381,
                         "deleuze"                 => 24232,
                         "delft"                   => 12653,
                         "delgada"                 => 26193,
                         "delhi"                   => 2317,
                         "deliberated"             => 28182,
                         "deliberation"            => 13435,
                         "deliberations"           => 14766,
                         "deliberative"            => 22708,
                         "delimitation"            => 13668,
                         "delimited"               => 19192,
                         "delineate"               => 27578,
                         "delineated"              => 14946,
                         "delineation"             => 24492,
                         "delinquency"             => 15814,
                         "delisted"                => 14793,
                         "delius"                  => 23282,
                         "delivered"               => 1849,
                         "delivers"                => 6521,
                         "dell'arte"               => 24674,
                         "delle"                   => 10298,
                         "dello"                   => 19932,
                         "deloitte"                => 16610,
                         "delos"                   => 21636,
                         "delved"                  => 27042,
                         "delves"                  => 22408,
                         "demand"                  => 1661,
                         "demanded"                => 3255,
                         "demands"                 => 2814,
                         "demarcated"              => 21593,
                         "demarcation"             => 14488,
                         "dementieva"              => 26976,
                         "demerara"                => 26002,
                         "demersal"                => 25882,
                         "demesne"                 => 19987,
                         "demetrios"               => 25153,
                         "demilitarized"           => 21583,
                         "demise"                  => 4780,
                         "demobilisation"          => 23648,
                         "demobilised"             => 26575,
                         "demobilization"          => 18909,
                         "demobilized"             => 15688,
                         "democracies"             => 14282,
                         "democracy"               => 2391,
                         "democrat"                => 2592,
                         "democratic"              => 756,
                         "democratically"          => 13225,
                         "democratique"            => 29709,
                         "democratization"         => 17473,
                         "democrats"               => 2686,
                         "demographic"             => 5368,
                         "demographics"            => 1683,
                         "demography"              => 8994,
                         "demolish"                => 10929,
                         "demolished"              => 2400,
                         "demolishing"             => 16023,
                         "demolition"              => 4361,
                         "demonstrate"             => 3918,
                         "demonstrated"            => 2604,
                         "demonstrates"            => 6187,
                         "demonstrating"           => 5856,
                         "demonstration"           => 3836,
                         "demonstrations"          => 4651,
                         "demonstrative"           => 20864,
                         "demonstrator"            => 14772,
                         "demonstrators"           => 8979,
                         "demoralized"             => 22349,
                         "demos"                   => 6448,
                         "demosthenes"             => 20905,
                         "demoted"                 => 8756,
                         "demotic"                 => 26730,
                         "demotion"                => 18634,
                         "dempo"                   => 29003,
                         "denbigh"                 => 19755,
                         "denbighshire"            => 18123,
                         "dench"                   => 22844,
                         "dendrites"               => 23395,
                         "dendritic"               => 15922,
                         "dengeki"                 => 21548,
                         "dengue"                  => 21811,
                         "denied"                  => 2206,
                         "denizens"                => 23806,
                         "denmark"                 => 1834,
                         "denominated"             => 17129,
                         "denomination"            => 5833,
                         "denominational"          => 9688,
                         "denominations"           => 5657,
                         "denote"                  => 6509,
                         "denoted"                 => 6558,
                         "denotes"                 => 5969,
                         "denoting"                => 10178,
                         "denouement"              => 29917,
                         "denounce"                => 15322,
                         "denounced"               => 6154,
                         "denounces"               => 24943,
                         "denouncing"              => 12364,
                         "dense"                   => 3894,
                         "densely"                 => 6806,
                         "denser"                  => 15250,
                         "densest"                 => 28746,
                         "densities"               => 10093,
                         "density"                 => 951,
                         "dentate"                 => 14077,
                         "denticles"               => 28049,
                         "dentistry"               => 9037,
                         "dentition"               => 19432,
                         "denunciation"            => 20686,
                         "denys"                   => 13809,
                         "denzil"                  => 29960,
                         "depart"                  => 7447,
                         "departed"                => 2665,
                         "departement"             => 9352,
                         "departements"            => 26573,
                         "departing"               => 5959,
                         "department"              => 294,
                         "departmental"            => 9289,
                         "departments"             => 2413,
                         "departs"                 => 9808,
                         "departure"               => 2225,
                         "departures"              => 10010,
                         "dependence"              => 6417,
                         "dependencies"            => 9606,
                         "dependency"              => 8195,
                         "dependent"               => 2658,
                         "dependents"              => 16251,
                         "depending"               => 1836,
                         "depict"                  => 6047,
                         "depicted"                => 2824,
                         "depicting"               => 3945,
                         "depiction"               => 5602,
                         "depictions"              => 6706,
                         "depicts"                 => 4051,
                         "depleted"                => 8126,
                         "depleting"               => 25034,
                         "depletion"               => 10909,
                         "deplored"                => 23791,
                         "deploy"                  => 7459,
                         "deployable"              => 22416,
                         "deployed"                => 2443,
                         "deploying"               => 10264,
                         "deployment"              => 3680,
                         "deployments"             => 9424,
                         "deploys"                 => 23937,
                         "depolarization"          => 23416,
                         "depopulated"             => 15976,
                         "depopulation"            => 22982,
                         "deportation"             => 7924,
                         "deportations"            => 15391,
                         "deported"                => 6328,
                         "deportees"               => 25194,
                         "deportes"                => 13917,
                         "deportiva"               => 20614,
                         "deportivo"               => 8039,
                         "deposed"                 => 6211,
                         "deposited"               => 5567,
                         "depositing"              => 19242,
                         "depositors"              => 23453,
                         "deposits"                => 3495,
                         "depot"                   => 2990,
                         "depots"                  => 9684,
                         "deprecated"              => 20364,
                         "depreciation"            => 17357,
                         "depredations"            => 27785,
                         "depression"              => 1983,
                         "depressions"             => 12234,
                         "deprivation"             => 10117,
                         "deptford"                => 14505,
                         "depth"                   => 2031,
                         "deputation"              => 21277,
                         "deputies"                => 4467,
                         "deputy"                  => 1198,
                         "derailment"              => 17509,
                         "derbies"                 => 24426,
                         "derby"                   => 2426,
                         "derbyshire"              => 5037,
                         "derecho"                 => 24781,
                         "deregulated"             => 28831,
                         "deregulation"            => 12850,
                         "dereham"                 => 27367,
                         "derelict"                => 9910,
                         "derided"                 => 16205,
                         "derivation"              => 8158,
                         "derivations"             => 20726,
                         "derivative"              => 4725,
                         "derivatives"             => 5727,
                         "derive"                  => 6281,
                         "derived"                 => 1398,
                         "derives"                 => 4004,
                         "deriving"                => 10926,
                         "derleth"                 => 29512,
                         "dermal"                  => 18183,
                         "dermatitis"              => 17052,
                         "dermatology"             => 17324,
                         "dermot"                  => 14892,
                         "derrida"                 => 16445,
                         "derulo"                  => 26971,
                         "derwent"                 => 12269,
                         "deryni"                  => 29606,
                         "desalination"            => 16944,
                         "desam"                   => 28284,
                         "descartes"               => 12328,
                         "descend"                 => 8159,
                         "descendant"              => 4482,
                         "descendants"             => 2794,
                         "descended"               => 4186,
                         "descendent"              => 16238,
                         "descendents"             => 12846,
                         "descending"              => 6383,
                         "descends"                => 8085,
                         "descent"                 => 2355,
                         "descentralizado"         => 25722,
                         "descents"                => 28753,
                         "deschutes"               => 27372,
                         "described"               => 350,
                         "describes"               => 1640,
                         "describing"              => 2745,
                         "description"             => 1038,
                         "descriptions"            => 4810,
                         "descriptive"             => 7805,
                         "descriptor"              => 19527,
                         "descriptors"             => 22896,
                         "desegregation"           => 14093,
                         "deseret"                 => 17391,
                         "deserters"               => 16482,
                         "desertification"         => 22020,
                         "deserts"                 => 9570,
                         "deshmukh"                => 22865,
                         "deshpande"               => 27363,
                         "desiccation"             => 28179,
                         "design"                  => 324,
                         "designate"               => 8052,
                         "designated"              => 1106,
                         "designates"              => 14643,
                         "designating"             => 12778,
                         "designation"             => 2721,
                         "designations"            => 7840,
                         "designator"              => 21627,
                         "designed"                => 435,
                         "designers"               => 3919,
                         "designing"               => 4562,
                         "designs"                 => 1705,
                         "desirability"            => 22688,
                         "desirable"               => 6166,
                         "desired"                 => 3530,
                         "desiring"                => 15236,
                         "desirous"                => 29856,
                         "desktops"                => 22370,
                         "despatch"                => 20370,
                         "despatched"              => 17746,
                         "despatches"              => 13165,
                         "despenser"               => 29139,
                         "despite"                 => 434,
                         "despot"                  => 17274,
                         "despotate"               => 28569,
                         "despotic"                => 27643,
                         "despotism"               => 28735,
                         "dessau"                  => 15505,
                         "destabilizing"           => 29199,
                         "destination"             => 2970,
                         "destinations"            => 4161,
                         "destino"                 => 26469,
                         "destitute"               => 12833,
                         "destroyed"               => 1042,
                         "destroyer"               => 3453,
                         "destroyers"              => 4826,
                         "destruction"             => 2175,
                         "detachable"              => 15699,
                         "detached"                => 5089,
                         "detachment"              => 4580,
                         "detachments"             => 9773,
                         "detailed"                => 2257,
                         "detailing"               => 6534,
                         "detained"                => 5471,
                         "detainee"                => 16897,
                         "detainees"               => 8635,
                         "detect"                  => 4610,
                         "detectable"              => 14243,
                         "detected"                => 4379,
                         "detecting"               => 9174,
                         "detection"               => 3926,
                         "detects"                 => 14326,
                         "deter"                   => 10732,
                         "detergents"              => 22539,
                         "deteriorated"            => 6998,
                         "deteriorates"            => 27671,
                         "deteriorating"           => 9371,
                         "deterioration"           => 8745,
                         "determinant"             => 11993,
                         "determinants"            => 16497,
                         "determination"           => 4165,
                         "determinations"          => 21081,
                         "determine"               => 1842,
                         "determined"              => 1435,
                         "determines"              => 5851,
                         "determining"             => 4375,
                         "determinism"             => 15943,
                         "deterministic"           => 12151,
                         "deterred"                => 20560,
                         "deterrence"              => 16404,
                         "detested"                => 24872,
                         "dethroned"               => 20671,
                         "detmold"                 => 28992,
                         "detonated"               => 10410,
                         "detoxification"          => 27292,
                         "detractors"              => 13954,
                         "detrimental"             => 9706,
                         "detritus"                => 18943,
                         "deuterium"               => 18084,
                         "deuteronomy"             => 18248,
                         "deutsche"                => 4568,
                         "deutschen"               => 16976,
                         "deutscher"               => 12464,
                         "deutsches"               => 15349,
                         "deutz"                   => 28600,
                         "devaluation"             => 18403,
                         "devalued"                => 26376,
                         "devanagari"              => 16033,
                         "devarajan"               => 27497,
                         "devas"                   => 19893,
                         "develop"                 => 1202,
                         "developed"               => 373,
                         "developer"               => 3452,
                         "developers"              => 3395,
                         "developing"              => 1424,
                         "development"             => 224,
                         "developmental"           => 5061,
                         "developmentally"         => 24591,
                         "developments"            => 2734,
                         "develops"                => 4105,
                         "deventer"                => 25625,
                         "devi"                    => 5653,
                         "deviance"                => 27955,
                         "deviates"                => 21507,
                         "deviating"               => 28204,
                         "deviation"               => 8162,
                         "deviations"              => 12362,
                         "device"                  => 1622,
                         "devices"                 => 1806,
                         "devised"                 => 5329,
                         "devises"                 => 24675,
                         "devizes"                 => 20494,
                         "devoid"                  => 10344,
                         "devolution"              => 14172,
                         "devolved"                => 12333,
                         "devonian"                => 10488,
                         "devonport"               => 12152,
                         "devonshire"              => 10802,
                         "devoted"                 => 2499,
                         "devotee"                 => 12375,
                         "devotees"                => 7332,
                         "devotes"                 => 17054,
                         "devotional"              => 9697,
                         "devotions"               => 19996,
                         "devout"                  => 8871,
                         "dewsbury"                => 16246,
                         "dexterity"               => 18701,
                         "dezful"                  => 29689,
                         "dezong"                  => 17179,
                         "dhabi"                   => 8297,
                         "dhaka"                   => 6337,
                         "dhamma"                  => 23278,
                         "dhanbad"                 => 29264,
                         "dhanush"                 => 28937,
                         "dharmendra"              => 29052,
                         "dharwad"                 => 20737,
                         "dhawan"                  => 24571,
                         "dhivehi"                 => 25780,
                         "dhoni"                   => 27369,
                         "dhruva"                  => 28004,
                         "diabetes"                => 5230,
                         "diacritic"               => 23026,
                         "diacritics"              => 18561,
                         "diadem"                  => 25508,
                         "diaghilev"               => 24533,
                         "diagnosed"               => 4113,
                         "diagnoses"               => 15401,
                         "diagnostic"              => 5830,
                         "diagnostics"             => 13599,
                         "diagonal"                => 7350,
                         "diagonally"              => 13807,
                         "diagonals"               => 23538,
                         "diagram"                 => 5845,
                         "diagrams"                => 8886,
                         "dialect"                 => 3156,
                         "dialectal"               => 20615,
                         "dialectic"               => 18000,
                         "dialectical"             => 17037,
                         "dialects"                => 4061,
                         "dialogue"                => 2981,
                         "dialogues"               => 8814,
                         "diameter"                => 2371,
                         "diameters"               => 14230,
                         "diamondback"             => 29486,
                         "diamondbacks"            => 10957,
                         "diaries"                 => 7052,
                         "diario"                  => 16381,
                         "diarist"                 => 21894,
                         "diarmait"                => 27846,
                         "diarmuid"                => 27764,
                         "diarrhoea"               => 27838,
                         "diaspora"                => 6426,
                         "diatoms"                 => 25493,
                         "diatonic"                => 16416,
                         "dibrugarh"               => 27593,
                         "dichomeris"              => 16433,
                         "dichotomy"               => 15392,
                         "dictated"                => 8785,
                         "dictator"                => 7548,
                         "dictatorial"             => 16499,
                         "dictatorship"            => 6631,
                         "diction"                 => 18017,
                         "dictionaries"            => 9830,
                         "dictionary"              => 3634,
                         "dictionnaire"            => 26860,
                         "dictum"                  => 27354,
                         "didactic"                => 15626,
                         "didcot"                  => 27757,
                         "diddley"                 => 20688,
                         "diderot"                 => 19639,
                         "didsbury"                => 28515,
                         "died"                    => 210,
                         "dielectric"              => 11816,
                         "diels"                   => 26766,
                         "diemen"                  => 17380,
                         "dieppe"                  => 14485,
                         "diesels"                 => 17465,
                         "dietary"                 => 7882,
                         "diets"                   => 10921,
                         "differ"                  => 3824,
                         "differed"                => 6735,
                         "differences"             => 1818,
                         "different"               => 237,
                         "differentiable"          => 15108,
                         "differential"            => 4052,
                         "differentials"           => 21149,
                         "differentiate"           => 7228,
                         "differentiated"          => 8146,
                         "differentiates"          => 17921,
                         "differentiating"         => 15422,
                         "differentiation"         => 7036,
                         "differing"               => 5876,
                         "differs"                 => 4337,
                         "difficulties"            => 2728,
                         "difficulty"              => 2896,
                         "diffraction"             => 10424,
                         "diffuse"                 => 9800,
                         "diffused"                => 19658,
                         "diffuser"                => 28283,
                         "diffusion"               => 6662,
                         "digestive"               => 10402,
                         "diggings"                => 28172,
                         "digipak"                 => 24719,
                         "digit"                   => 5502,
                         "digitally"               => 6573,
                         "digitisation"            => 26512,
                         "digitised"               => 24271,
                         "digitization"            => 24121,
                         "digitized"               => 14533,
                         "digits"                  => 6183,
                         "dignitaries"             => 9400,
                         "digraph"                 => 25735,
                         "digraphs"                => 26539,
                         "dihedral"                => 18229,
                         "dijkstra"                => 28113,
                         "dijon"                   => 13247,
                         "dilapidated"             => 11352,
                         "dilemmas"                => 18755,
                         "diliman"                 => 22847,
                         "dilip"                   => 17957,
                         "dilute"                  => 14904,
                         "diluted"                 => 13985,
                         "dilution"                => 15655,
                         "dimensional"             => 3073,
                         "dimensionality"          => 26914,
                         "dimensionless"           => 19571,
                         "dimensions"              => 3483,
                         "dimer"                   => 18720,
                         "dimers"                  => 28591,
                         "dimethyl"                => 23587,
                         "diminished"              => 6099,
                         "diminishes"              => 21787,
                         "diminishing"             => 11128,
                         "diminutive"              => 10149,
                         "dimitar"                 => 19566,
                         "dimitrie"                => 26702,
                         "dimitrios"               => 19564,
                         "dimitrov"                => 17524,
                         "dimorphic"               => 20454,
                         "dimorphism"              => 15053,
                         "dinajpur"                => 28954,
                         "dinar"                   => 18848,
                         "dinars"                  => 27412,
                         "dinas"                   => 27455,
                         "dindigul"                => 29821,
                         "dingoes"                 => 26525,
                         "dinos"                   => 27942,
                         "diocesan"                => 6817,
                         "diocese"                 => 1784,
                         "dioceses"                => 7981,
                         "diocletian"              => 13892,
                         "diode"                   => 12194,
                         "diodes"                  => 15333,
                         "diodorus"                => 18672,
                         "dioecious"               => 22786,
                         "diogo"                   => 16783,
                         "diomedes"                => 28333,
                         "dionysius"               => 12016,
                         "dioramas"                => 29875,
                         "diouf"                   => 29407,
                         "dioxide"                 => 5073,
                         "dioxin"                  => 29708,
                         "diphosphate"             => 17499,
                         "diphthong"               => 24408,
                         "diphthongs"              => 16925,
                         "diplo"                   => 26409,
                         "diploid"                 => 16520,
                         "diploma"                 => 3666,
                         "diplomacy"               => 6386,
                         "diplomas"                => 11156,
                         "diplomat"                => 4210,
                         "diplomatic"              => 2627,
                         "diplomatically"          => 29363,
                         "diplomats"               => 7961,
                         "dipole"                  => 11810,
                         "diptera"                 => 22410,
                         "dirac"                   => 12751,
                         "direct"                  => 848,
                         "direct3d"                => 29770,
                         "directed"                => 493,
                         "directing"               => 3663,
                         "direction"               => 1035,
                         "directional"             => 7326,
                         "directive"               => 6032,
                         "directives"              => 11786,
                         "directly"                => 906,
                         "director"                => 291,
                         "directorate"             => 5871,
                         "directorates"            => 22779,
                         "directorial"             => 7698,
                         "directories"             => 12815,
                         "directors"               => 1655,
                         "directorship"            => 13630,
                         "directory"               => 5350,
                         "directs"                 => 8191,
                         "directv"                 => 13308,
                         "directx"                 => 21275,
                         "dirge"                   => 27523,
                         "dirichlet"               => 17041,
                         "disabilities"            => 5102,
                         "disability"              => 4692,
                         "disabled"                => 3701,
                         "disables"                => 28153,
                         "disabling"               => 15642,
                         "disadvantage"            => 7514,
                         "disadvantaged"           => 9057,
                         "disadvantages"           => 8252,
                         "disaffected"             => 18101,
                         "disagreed"               => 7294,
                         "disagreements"           => 7794,
                         "disallowed"              => 14431,
                         "disambiguation"          => 1488,
                         "disapproval"             => 10358,
                         "disapproved"             => 11812,
                         "disarmament"             => 9918,
                         "disassembled"            => 15864,
                         "disassembly"             => 28532,
                         "disasters"               => 6670,
                         "disband"                 => 11953,
                         "disbanded"               => 2934,
                         "disbanding"              => 10333,
                         "disbandment"             => 13094,
                         "disbursed"               => 29379,
                         "disc"                    => 1954,
                         "discal"                  => 11313,
                         "discard"                 => 14040,
                         "discarded"               => 7020,
                         "discarding"              => 18946,
                         "discards"                => 25459,
                         "discern"                 => 15506,
                         "discerned"               => 20448,
                         "discernible"             => 15687,
                         "discharge"               => 4338,
                         "discharged"              => 5406,
                         "discharges"              => 11183,
                         "disciple"                => 6532,
                         "disciples"               => 6095,
                         "disciplinarian"          => 26528,
                         "disciplinary"            => 6395,
                         "discipline"              => 3306,
                         "disciplines"             => 4213,
                         "disclaimer"              => 18628,
                         "disclose"                => 9519,
                         "disclosed"               => 7670,
                         "discloses"               => 27147,
                         "disclosing"              => 18191,
                         "disclosures"             => 16521,
                         "discography"             => 3256,
                         "disconnection"           => 27843,
                         "discontent"              => 9478,
                         "discontented"            => 25667,
                         "discontinuation"         => 14342,
                         "discontinued"            => 3138,
                         "discontinuing"           => 24053,
                         "discontinuities"         => 28293,
                         "discontinuity"           => 18809,
                         "discontinuous"           => 15956,
                         "discounted"              => 10330,
                         "discounts"               => 12813,
                         "discourages"             => 23559,
                         "discourse"               => 5788,
                         "discourses"              => 11986,
                         "discovered"              => 905,
                         "discoverer"              => 12710,
                         "discoverers"             => 26214,
                         "discoveries"             => 5719,
                         "discovering"             => 5675,
                         "discovers"               => 3220,
                         "discovery"               => 1715,
                         "discredited"             => 12884,
                         "discrete"                => 5734,
                         "discretionary"           => 14525,
                         "discriminant"            => 25849,
                         "discriminate"            => 13669,
                         "discriminated"           => 14239,
                         "discrimination"          => 3276,
                         "discriminatory"          => 10391,
                         "discs"                   => 5608,
                         "discursive"              => 26692,
                         "discusses"               => 5804,
                         "discussions"             => 3727,
                         "discworld"               => 20459,
                         "disease"                 => 1184,
                         "diseases"                => 2725,
                         "disembark"               => 21831,
                         "disembarked"             => 14317,
                         "disembarking"            => 24679,
                         "disembodied"             => 22726,
                         "disenchanted"            => 18265,
                         "disenfranchised"         => 19240,
                         "disengagement"           => 20325,
                         "disestablished"          => 17736,
                         "disestablishment"        => 24081,
                         "disguising"              => 22346,
                         "disheartened"            => 27551,
                         "disinfection"            => 25761,
                         "disintegration"          => 12469,
                         "disjoint"                => 16450,
                         "disjointed"              => 22301,
                         "disjunct"                => 24185,
                         "disk"                    => 3545,
                         "disliked"                => 7519,
                         "dislocation"             => 16870,
                         "dislocations"            => 24701,
                         "dismantled"              => 6167,
                         "dismantling"             => 12315,
                         "dismay"                  => 10041,
                         "dismayed"                => 15047,
                         "dismembered"             => 19786,
                         "dismissal"               => 5733,
                         "dismissals"              => 20716,
                         "dismissed"               => 2639,
                         "dismisses"               => 13202,
                         "dismounted"              => 14632,
                         "disobedience"            => 11166,
                         "disorder"                => 3135,
                         "disordered"              => 18649,
                         "disorders"               => 3849,
                         "disparaged"              => 29862,
                         "disparate"               => 10965,
                         "disparities"             => 14875,
                         "disparity"               => 11524,
                         "dispatched"              => 5450,
                         "dispatches"              => 10885,
                         "dispatching"             => 17973,
                         "dispel"                  => 21305,
                         "dispensary"              => 14442,
                         "dispensation"            => 15371,
                         "dispensed"               => 15359,
                         "dispersal"               => 9002,
                         "disperse"                => 10021,
                         "dispersed"               => 5772,
                         "dispersing"              => 19832,
                         "dispersion"              => 9555,
                         "displaced"               => 4696,
                         "displacement"            => 4968,
                         "displacements"           => 20670,
                         "displaces"               => 28526,
                         "displacing"              => 14027,
                         "display"                 => 1466,
                         "displayed"               => 2455,
                         "displaying"              => 6022,
                         "displays"                => 3068,
                         "disposals"               => 18725,
                         "disposed"                => 8277,
                         "dispositions"            => 19165,
                         "dispossessed"            => 19062,
                         "disproportionate"        => 13025,
                         "disproportionately"      => 14850,
                         "disproved"               => 20957,
                         "disputation"             => 28178,
                         "dispute"                 => 2417,
                         "disputed"                => 3935,
                         "disputes"                => 4006,
                         "disqualification"        => 9419,
                         "disqualified"            => 6938,
                         "disregarded"             => 14049,
                         "disregarding"            => 18686,
                         "disrepair"               => 9056,
                         "disrepute"               => 29520,
                         "disrupted"               => 7347,
                         "disruption"              => 7380,
                         "disruptions"             => 15947,
                         "disruptive"              => 12467,
                         "dissatisfaction"         => 9330,
                         "dissatisfied"            => 8784,
                         "disseminate"             => 13848,
                         "disseminated"            => 12836,
                         "disseminating"           => 16852,
                         "dissemination"           => 9262,
                         "dissension"              => 20398,
                         "dissent"                 => 7829,
                         "dissented"               => 18699,
                         "dissenters"              => 14414,
                         "dissenting"              => 10484,
                         "dissertation"            => 5760,
                         "dissertations"           => 18831,
                         "dissident"               => 9681,
                         "dissidents"              => 11244,
                         "dissipated"              => 8820,
                         "dissipating"             => 15573,
                         "dissipation"             => 15217,
                         "dissociated"             => 29422,
                         "dissociation"            => 14312,
                         "dissolution"             => 4171,
                         "dissolved"               => 3032,
                         "dissolves"               => 16158,
                         "dissolving"              => 12796,
                         "dissonance"              => 16695,
                         "dissonant"               => 22367,
                         "dissuaded"               => 23085,
                         "distal"                  => 9729,
                         "distance"                => 963,
                         "distanced"               => 12837,
                         "distances"               => 4324,
                         "distant"                 => 3476,
                         "distantly"               => 14616,
                         "distillation"            => 11363,
                         "distilled"               => 12003,
                         "distilleries"            => 19842,
                         "distillers"              => 20740,
                         "distillery"              => 8447,
                         "distilling"              => 20336,
                         "distinct"                => 1776,
                         "distinction"             => 2516,
                         "distinctions"            => 7904,
                         "distinctive"             => 2654,
                         "distinctively"           => 14259,
                         "distinctiveness"         => 25171,
                         "distinguish"             => 3758,
                         "distinguishable"         => 12322,
                         "distinguished"           => 1595,
                         "distinguishes"           => 8564,
                         "distinguishing"          => 6788,
                         "distorted"               => 8080,
                         "distorting"              => 22695,
                         "distortion"              => 7377,
                         "distortions"             => 15314,
                         "distribute"              => 5693,
                         "distributed"             => 1647,
                         "distributes"             => 9631,
                         "distributing"            => 6933,
                         "distribution"            => 883,
                         "distributions"           => 6821,
                         "distributive"            => 18712,
                         "distributor"             => 6105,
                         "distributors"            => 7518,
                         "district"                => 104,
                         "districts"               => 1126,
                         "distrito"                => 18371,
                         "distrusted"              => 22226,
                         "disturbances"            => 8257,
                         "disulfide"               => 15494,
                         "disuse"                  => 12732,
                         "disused"                 => 8684,
                         "ditches"                 => 10495,
                         "ditko"                   => 28476,
                         "ditton"                  => 24344,
                         "diurnal"                 => 12563,
                         "divan"                   => 22203,
                         "divas"                   => 13022,
                         "dived"                   => 17521,
                         "diverge"                 => 15622,
                         "diverged"                => 12188,
                         "divergence"              => 9760,
                         "divergent"               => 10485,
                         "diverges"                => 18722,
                         "diverging"               => 18042,
                         "diverse"                 => 2433,
                         "diversification"         => 12119,
                         "diversified"             => 7897,
                         "diversifying"            => 24732,
                         "diversity"               => 3149,
                         "diverted"                => 6882,
                         "diverts"                 => 26648,
                         "divested"                => 16814,
                         "divestment"              => 25079,
                         "divide"                  => 4254,
                         "divided"                 => 959,
                         "dividend"                => 11640,
                         "dividends"               => 11842,
                         "divides"                 => 6903,
                         "dividing"                => 5834,
                         "divination"              => 14851,
                         "divinely"                => 21867,
                         "diving"                  => 3609,
                         "divinities"              => 28642,
                         "divinity"                => 6156,
                         "divisao"                 => 21503,
                         "divisible"               => 16955,
                         "divisie"                 => 16654,
                         "division"                => 220,
                         "divisional"              => 5273,
                         "divisione"               => 13883,
                         "divisions"               => 1652,
                         "divisive"                => 15405,
                         "divisor"                 => 17567,
                         "divisors"                => 21999,
                         "divizia"                 => 20962,
                         "divya"                   => 16387,
                         "diwali"                  => 17742,
                         "diwan"                   => 15036,
                         "dixieland"               => 20055,
                         "dixit"                   => 20489,
                         "diyarbakir"              => 21348,
                         "djibouti"                => 10848,
                         "djing"                   => 22776,
                         "djokovic"                => 12335,
                         "djurgarden"              => 23935,
                         "djurgardens"             => 21440,
                         "dmytro"                  => 23768,
                         "dnieper"                 => 15324,
                         "dniester"                => 22273,
                         "dnipro"                  => 22210,
                         "dnipropetrovsk"          => 16086,
                         "dobra"                   => 27995,
                         "dobro"                   => 25490,
                         "dobruja"                 => 24205,
                         "doc"                     => 20,
                         "docent"                  => 21777,
                         "docked"                  => 10017,
                         "docklands"               => 14435,
                         "dockyard"                => 8718,
                         "dockyards"               => 23476,
                         "doctoral"                => 4204,
                         "doctorate"               => 3334,
                         "doctorates"              => 11729,
                         "doctrinal"               => 11605,
                         "doctrine"                => 3018,
                         "doctrines"               => 7761,
                         "docudrama"               => 23409,
                         "document"                => 2132,
                         "documenta"               => 27157,
                         "documentaries"           => 5371,
                         "documentary"             => 1397,
                         "documentation"           => 4675,
                         "documented"              => 3048,
                         "documenting"             => 8017,
                         "documents"               => 1800,
                         "dodecahedron"            => 24551,
                         "dodecanese"              => 29411,
                         "dogmas"                  => 28716,
                         "dogmatic"                => 15335,
                         "dolichoderus"            => 28644,
                         "dolmen"                  => 23600,
                         "dolmens"                 => 29840,
                         "dolna"                   => 28133,
                         "dolne"                   => 27575,
                         "dolni"                   => 28051,
                         "dolny"                   => 29258,
                         "dolomites"               => 27214,
                         "domain"                  => 1936,
                         "domaine"                 => 22052,
                         "domains"                 => 4608,
                         "dome"                    => 3337,
                         "domed"                   => 10649,
                         "domes"                   => 9278,
                         "domesday"                => 7176,
                         "domestic"                => 1433,
                         "domestically"            => 8851,
                         "domesticated"            => 10146,
                         "domestication"           => 17013,
                         "domhnall"                => 27047,
                         "domiciled"               => 29370,
                         "dominance"               => 5024,
                         "dominant"                => 2518,
                         "dominate"                => 5726,
                         "dominated"               => 2174,
                         "dominates"               => 9336,
                         "dominating"              => 7734,
                         "domination"              => 6350,
                         "domingos"                => 24404,
                         "dominican"               => 3566,
                         "dominicana"              => 29625,
                         "dominicans"              => 13833,
                         "dominions"               => 11989,
                         "domitian"                => 18769,
                         "domnall"                 => 22269,
                         "domus"                   => 21540,
                         "donated"                 => 2305,
                         "donates"                 => 18394,
                         "donations"               => 3973,
                         "donau"                   => 24066,
                         "donbass"                 => 18308,
                         "doncaster"               => 6477,
                         "donegal"                 => 8170,
                         "donetsk"                 => 8918,
                         "dongguan"                => 26750,
                         "donington"               => 16782,
                         "donitz"                  => 24531,
                         "donizetti"               => 15179,
                         "donja"                   => 23270,
                         "donji"                   => 19206,
                         "donne"                   => 16107,
                         "donned"                  => 17657,
                         "donning"                 => 20941,
                         "donors"                  => 6286,
                         "doordarshan"             => 18469,
                         "dopamine"                => 10089,
                         "dopaminergic"            => 27172,
                         "doping"                  => 8013,
                         "doppler"                 => 10754,
                         "dorchester"              => 9045,
                         "dorde"                   => 24442,
                         "dordevic"                => 26450,
                         "dordogne"                => 17247,
                         "dordrecht"               => 18437,
                         "doric"                   => 10990,
                         "dorid"                   => 24608,
                         "dorje"                   => 19136,
                         "dorking"                 => 22321,
                         "dormancy"                => 22703,
                         "dormant"                 => 8466,
                         "dormer"                  => 15588,
                         "dormers"                 => 17754,
                         "dormition"               => 28489,
                         "dormitories"             => 10854,
                         "dormitory"               => 7978,
                         "doron"                   => 27964,
                         "dorsal"                  => 4601,
                         "dorsally"                => 19346,
                         "dorset"                  => 5362,
                         "dorsum"                  => 13009,
                         "doses"                   => 7725,
                         "dosing"                  => 23338,
                         "dostoevsky"              => 29955,
                         "dothan"                  => 25040,
                         "douai"                   => 17766,
                         "douala"                  => 21068,
                         "double"                  => 833,
                         "doubleheader"            => 17740,
                         "doubles"                 => 2219,
                         "doubling"                => 7499,
                         "doubs"                   => 19762,
                         "doubtless"               => 19079,
                         "douro"                   => 19229,
                         "dowager"                 => 7635,
                         "dowlatabad"              => 26807,
                         "downbeat"                => 23325,
                         "downe"                   => 28696,
                         "downed"                  => 9342,
                         "downfall"                => 7854,
                         "downfield"               => 29332,
                         "downforce"               => 26721,
                         "downgrade"               => 27882,
                         "downgraded"              => 10977,
                         "download"                => 3347,
                         "downloadable"            => 8671,
                         "downloads"               => 7470,
                         "downplayed"              => 19629,
                         "downsized"               => 22148,
                         "downstream"              => 4769,
                         "downton"                 => 20466,
                         "downtown"                => 1539,
                         "downturn"                => 10710,
                         "downward"                => 7375,
                         "downwards"               => 11409,
                         "downwind"                => 22977,
                         "dowry"                   => 9882,
                         "dr."                     => 740,
                         "draconian"               => 24212,
                         "draft"                   => 1161,
                         "drafted"                 => 2386,
                         "drafting"                => 7321,
                         "drafts"                  => 9692,
                         "draftsman"               => 16014,
                         "dragonflies"             => 21171,
                         "dragonlance"             => 23524,
                         "dragoons"                => 9535,
                         "drainage"                => 4100,
                         "drainages"               => 25269,
                         "drained"                 => 6257,
                         "draining"                => 9206,
                         "drains"                  => 6860,
                         "drama"                   => 949,
                         "dramas"                  => 5631,
                         "dramatic"                => 2425,
                         "dramatically"            => 4615,
                         "dramatised"              => 23412,
                         "dramatist"               => 10716,
                         "dramatists"              => 19000,
                         "dramatization"           => 24558,
                         "dramatized"              => 17720,
                         "dramedy"                 => 29234,
                         "drammen"                 => 18312,
                         "drapery"                 => 19775,
                         "drastically"             => 7522,
                         "draught"                 => 9462,
                         "draughts"                => 24175,
                         "draughtsman"             => 16258,
                         "draupadi"                => 26468,
                         "drava"                   => 17172,
                         "dravid"                  => 25025,
                         "dravida"                 => 15564,
                         "dravidian"               => 14386,
                         "draw"                    => 1275,
                         "drawdown"                => 25756,
                         "drawing"                 => 2090,
                         "drawings"                => 3531,
                         "drawn"                   => 1668,
                         "draws"                   => 3810,
                         "dreadnought"             => 13931,
                         "dreadnoughts"            => 20045,
                         "dreamland"               => 22101,
                         "dreamwave"               => 24187,
                         "dreamworks"              => 12253,
                         "dredd"                   => 12691,
                         "drenthe"                 => 20640,
                         "drepanidae"              => 28656,
                         "dresdner"                => 29024,
                         "dressings"               => 15624,
                         "dreux"                   => 28322,
                         "dreyfus"                 => 11142,
                         "driest"                  => 15487,
                         "drifters"                => 20419,
                         "drilled"                 => 9577,
                         "drillers"                => 25803,
                         "drilling"                => 5878,
                         "drina"                   => 23671,
                         "driven"                  => 1958,
                         "drivers"                 => 2370,
                         "drivetime"               => 28819,
                         "drivetrain"              => 21666,
                         "drogheda"                => 14663,
                         "droit"                   => 20245,
                         "drome"                   => 21234,
                         "drone"                   => 8616,
                         "drooping"                => 25217,
                         "droplet"                 => 21461,
                         "droplets"                => 13814,
                         "drosera"                 => 23776,
                         "drosophila"              => 12904,
                         "drought"                 => 5379,
                         "droughts"                => 14362,
                         "druce"                   => 23482,
                         "drum"                    => 2699,
                         "drumming"                => 9089,
                         "drums"                   => 2252,
                         "drusus"                  => 29333,
                         "druze"                   => 11948,
                         "dryandra"                => 23737,
                         "drydock"                 => 14933,
                         "dryness"                 => 25834,
                         "dual"                    => 2311,
                         "dualism"                 => 18264,
                         "dualistic"               => 29523,
                         "duality"                 => 11332,
                         "dubai"                   => 4238,
                         "dubbed"                  => 3230,
                         "dubbing"                 => 10945,
                         "dubbo"                   => 25632,
                         "dubliners"               => 25195,
                         "dubrovnik"               => 11964,
                         "dubstep"                 => 16696,
                         "ducal"                   => 10575,
                         "ducats"                  => 23797,
                         "duchies"                 => 15219,
                         "duchovny"                => 20256,
                         "duchy"                   => 3681,
                         "ductile"                 => 25359,
                         "due"                     => 183,
                         "duel"                    => 5790,
                         "duels"                   => 16321,
                         "duet"                    => 4691,
                         "duets"                   => 9992,
                         "dufferin"                => 16400,
                         "dugdale"                 => 22302,
                         "dugouts"                 => 25422,
                         "duisburg"                => 12981,
                         "dukakis"                 => 20701,
                         "dukedom"                 => 16275,
                         "dukla"                   => 20383,
                         "dulcimer"                => 26347,
                         "duller"                  => 20259,
                         "dulwich"                 => 13357,
                         "dumbarton"               => 10865,
                         "dumfries"                => 10730,
                         "dumitru"                 => 24195,
                         "dunams"                  => 16329,
                         "dunbartonshire"          => 22836,
                         "dunblane"                => 25255,
                         "dundalk"                 => 13253,
                         "dunder"                  => 26577,
                         "dunedin"                 => 7661,
                         "dunes"                   => 6740,
                         "dunfermline"             => 11398,
                         "dungannon"               => 20637,
                         "dungeness"               => 29074,
                         "dungeons"                => 6217,
                         "dunhuang"                => 26495,
                         "dunkeld"                 => 22640,
                         "dunkerque"               => 29505,
                         "dunkirk"                 => 10127,
                         "dunstable"               => 19903,
                         "dunster"                 => 27288,
                         "dunwich"                 => 25175,
                         "duodenum"                => 27361,
                         "duomo"                   => 23273,
                         "duopoly"                 => 21645,
                         "dupage"                  => 23429,
                         "duplicated"              => 11860,
                         "duplicates"              => 18378,
                         "duplicating"             => 27595,
                         "duplication"             => 11464,
                         "dupri"                   => 24411,
                         "duquesne"                => 11265,
                         "durability"              => 10128,
                         "durable"                 => 8523,
                         "durad"                   => 29982,
                         "duration"                => 3405,
                         "durations"               => 20807,
                         "durban"                  => 8368,
                         "durbar"                  => 19399,
                         "durer"                   => 17192,
                         "durga"                   => 9840,
                         "durgapur"                => 23550,
                         "during"                  => 41,
                         "durkheim"                => 20308,
                         "durrani"                 => 17145,
                         "durres"                  => 19438,
                         "duryodhana"              => 25245,
                         "dusan"                   => 12277,
                         "dushanbe"                => 24283,
                         "dusky"                   => 14337,
                         "dusseldorf"              => 7011,
                         "dutch"                   => 863,
                         "duties"                  => 1792,
                         "duvalier"                => 25274,
                         "duxbury"                 => 25987,
                         "dvina"                   => 25772,
                         "dwarf"                   => 5091,
                         "dwarfed"                 => 27336,
                         "dwarfism"                => 26549,
                         "dwarfs"                  => 11196,
                         "dwarka"                  => 26218,
                         "dwarves"                 => 12505,
                         "dwellers"                => 9496,
                         "dwelling"                => 5059,
                         "dwellings"               => 5886,
                         "dwelt"                   => 19018,
                         "dwindle"                 => 28088,
                         "dwindled"                => 11934,
                         "dwindling"               => 12453,
                         "dyfed"                   => 29530,
                         "dynamic"                 => 3083,
                         "dynamical"               => 11709,
                         "dynamically"             => 12232,
                         "dynamics"                => 4034,
                         "dynamism"                => 22479,
                         "dynamos"                 => 21009,
                         "dynastic"                => 9801,
                         "dynasties"               => 7497,
                         "dynasty"                 => 1490,
                         "dyschirius"              => 26313,
                         "dysentery"               => 15999,
                         "dysfunction"             => 9746,
                         "dysplasia"               => 17841,
                         "dystopian"               => 16912,
                         "dystrophy"               => 17124,
                         "dzogchen"                => 28349,
                         "dzong"                   => 28557,
                         "dzungar"                 => 28665,
                         "e.g."                    => 3036,
                         "e9e9e9"                  => 12145,
                         "each"                    => 124,
                         "eagerness"               => 23677,
                         "ealing"                  => 11558,
                         "eamon"                   => 14847,
                         "eamonn"                  => 17309,
                         "eared"                   => 12316,
                         "earldom"                 => 9420,
                         "earlier"                 => 642,
                         "earliest"                => 1704,
                         "early"                   => 95,
                         "earmarked"               => 13558,
                         "earned"                  => 836,
                         "earner"                  => 25038,
                         "earners"                 => 19003,
                         "earnestly"               => 26439,
                         "earning"                 => 2520,
                         "earnings"                => 5997,
                         "earns"                   => 10478,
                         "earth"                   => 722,
                         "earthbound"              => 29727,
                         "earthen"                 => 11928,
                         "earthenware"             => 18945,
                         "earthquake"              => 2778,
                         "earthquakes"             => 6123,
                         "earths"                  => 14970,
                         "earthwork"               => 17636,
                         "earthworks"              => 11522,
                         "earthworm"               => 28573,
                         "earthworms"              => 22309,
                         "eased"                   => 13215,
                         "easement"                => 19391,
                         "easements"               => 28037,
                         "easily"                  => 1583,
                         "east"                    => 138,
                         "east/west"               => 29467,
                         "eastbound"               => 8374,
                         "eastbourne"              => 11411,
                         "eastenders"              => 8276,
                         "eastern"                 => 387,
                         "easternmost"             => 10637,
                         "eastgate"                => 26114,
                         "eastlake"                => 23336,
                         "eastleigh"               => 17902,
                         "eastward"                => 6051,
                         "eastwards"               => 9453,
                         "eateries"                => 21299,
                         "eatery"                  => 29936,
                         "ebbsfleet"               => 25124,
                         "ebenezer"                => 11189,
                         "ebook"                   => 19128,
                         "ebooks"                  => 24132,
                         "ebrahim"                 => 19099,
                         "eccellenza"              => 21324,
                         "eccentricity"            => 13687,
                         "ecclesia"                => 21684,
                         "ecclesiae"               => 28785,
                         "ecclesiastic"            => 21050,
                         "ecclesiastical"          => 4126,
                         "ecclestone"              => 25062,
                         "echelons"                => 19955,
                         "echinoderms"             => 29116,
                         "echoed"                  => 9665,
                         "echoes"                  => 8637,
                         "echoing"                 => 13462,
                         "echolocation"            => 25339,
                         "ecija"                   => 20907,
                         "eclectic"                => 7155,
                         "eclecticism"             => 26416,
                         "eclipsed"                => 11703,
                         "eclipses"                => 14346,
                         "eclipsing"               => 20880,
                         "ecliptic"                => 19237,
                         "ecole"                   => 5299,
                         "ecoles"                  => 23514,
                         "ecological"              => 4422,
                         "ecologically"            => 15645,
                         "ecologist"               => 17442,
                         "ecologists"              => 22918,
                         "ecology"                 => 3762,
                         "ecommerce"               => 24512,
                         "econometric"             => 25414,
                         "econometrics"            => 22141,
                         "economic"                => 577,
                         "economical"              => 7167,
                         "economically"            => 5254,
                         "economics"               => 1782,
                         "economies"               => 6410,
                         "economist"               => 4436,
                         "economists"              => 7336,
                         "economy"                 => 1018,
                         "ecoregion"               => 11483,
                         "ecoregions"              => 18735,
                         "ecosystem"               => 6194,
                         "ecosystems"              => 7234,
                         "ecotourism"              => 17159,
                         "ecowas"                  => 25989,
                         "ecozone"                 => 16717,
                         "ecuador"                 => 3794,
                         "ecuadorian"              => 9608,
                         "ecumenical"              => 7820,
                         "ecumenism"               => 25528,
                         "edessa"                  => 17070,
                         "edgbaston"               => 17549,
                         "edge"                    => 1305,
                         "edged"                   => 6926,
                         "edges"                   => 3795,
                         "edgewater"               => 19891,
                         "edging"                  => 15386,
                         "edgware"                 => 20217,
                         "edible"                  => 7543,
                         "edict"                   => 8250,
                         "edicts"                  => 16468,
                         "edifice"                 => 11293,
                         "edifices"                => 22701,
                         "edina"                   => 22341,
                         "edinburgh"               => 2071,
                         "edirne"                  => 21365,
                         "edited"                  => 1959,
                         "editing"                 => 3647,
                         "edition"                 => 696,
                         "editions"                => 2323,
                         "editor"                  => 861,
                         "editorial"               => 2997,
                         "editorials"              => 11140,
                         "editors"                 => 3736,
                         "editorship"              => 12935,
                         "edits"                   => 11495,
                         "edmonton"                => 3611,
                         "edouard"                 => 8425,
                         "edrich"                  => 27530,
                         "edsel"                   => 21343,
                         "educacion"               => 28138,
                         "educate"                 => 6103,
                         "educated"                => 1444,
                         "educates"                => 14776,
                         "educating"               => 8482,
                         "education"               => 217,
                         "educational"             => 1164,
                         "educationalist"          => 23785,
                         "educationist"            => 19900,
                         "educations"              => 25606,
                         "educator"                => 4552,
                         "educators"               => 6651,
                         "edwardes"                => 23781,
                         "edwardian"               => 12211,
                         "edwardsville"            => 25470,
                         "eelam"                   => 18859,
                         "eerste"                  => 14124,
                         "eesti"                   => 23444,
                         "efendi"                  => 22800,
                         "effect"                  => 784,
                         "effected"                => 10370,
                         "effective"               => 1324,
                         "effectively"             => 2110,
                         "effectiveness"           => 4305,
                         "effector"                => 22200,
                         "effects"                 => 953,
                         "effendi"                 => 18239,
                         "efficacious"             => 28065,
                         "efficacy"                => 7114,
                         "efficiencies"            => 16377,
                         "efficiency"              => 2830,
                         "efficient"               => 2898,
                         "efficiently"             => 6974,
                         "effigies"                => 20859,
                         "effigy"                  => 12472,
                         "effingham"               => 20171,
                         "effluent"                => 18570,
                         "effort"                  => 1218,
                         "effortlessly"            => 19606,
                         "efforts"                 => 1012,
                         "egalitarian"             => 14394,
                         "egalitarianism"          => 28806,
                         "eglin"                   => 18294,
                         "eglinton"                => 13410,
                         "eglise"                  => 19431,
                         "egmond"                  => 29667,
                         "egmont"                  => 18273,
                         "egoism"                  => 29806,
                         "egremont"                => 25382,
                         "egress"                  => 28497,
                         "egret"                   => 24840,
                         "egrets"                  => 18272,
                         "egypt"                   => 1599,
                         "egyptian"                => 2249,
                         "egyptians"               => 7898,
                         "egyptologist"            => 20886,
                         "egyptologists"           => 23202,
                         "egyptology"              => 24002,
                         "ehime"                   => 21763,
                         "eidos"                   => 28052,
                         "eifel"                   => 20609,
                         "eigenvalue"              => 17513,
                         "eigenvalues"             => 13882,
                         "eigenvectors"            => 24585,
                         "eight"                   => 470,
                         "eighteens"               => 12756,
                         "eighteenth"              => 4929,
                         "eighth"                  => 1916,
                         "eilat"                   => 21938,
                         "eilean"                  => 21695,
                         "eilema"                  => 27686,
                         "einar"                   => 14275,
                         "eindhoven"               => 10497,
                         "einer"                   => 26756,
                         "eintracht"               => 14063,
                         "eireann"                 => 8606,
                         "eisenach"                => 17936,
                         "eisenbahn"               => 23419,
                         "eisenhower"              => 5931,
                         "eishockey"               => 21101,
                         "eisteddfod"              => 17892,
                         "ejecta"                  => 21979,
                         "ejected"                 => 8020,
                         "ejecting"                => 28459,
                         "ejection"                => 12825,
                         "ejector"                 => 27884,
                         "ejercito"                => 27453,
                         "ekiti"                   => 21088,
                         "ekstraklasa"             => 19723,
                         "elaborate"               => 3867,
                         "elaborated"              => 8726,
                         "elaborately"             => 14116,
                         "elaborates"              => 21168,
                         "elaborating"             => 23354,
                         "elaboration"             => 15384,
                         "elachista"               => 15010,
                         "elachistidae"            => 24261,
                         "elamite"                 => 29254,
                         "elapsed"                 => 15531,
                         "elastic"                 => 8446,
                         "elasticity"              => 13856,
                         "elbasan"                 => 28658,
                         "elblag"                  => 20763,
                         "elche"                   => 24506,
                         "elderly"                 => 4064,
                         "eldest"                  => 2559,
                         "eleazar"                 => 18793,
                         "elect"                   => 4195,
                         "elected"                 => 360,
                         "electing"                => 9806,
                         "election"                => 273,
                         "elections"               => 831,
                         "elective"                => 9542,
                         "electives"               => 15604,
                         "elector"                 => 7247,
                         "electoral"               => 1694,
                         "electorate"              => 4471,
                         "electorates"             => 11271,
                         "electors"                => 7296,
                         "electrical"              => 2083,
                         "electrically"            => 9263,
                         "electricity"             => 2321,
                         "electrics"               => 24208,
                         "electrification"         => 7737,
                         "electrified"             => 6741,
                         "electrifying"            => 24459,
                         "electroacoustic"         => 22891,
                         "electrochemical"         => 15738,
                         "electrocution"           => 26496,
                         "electrode"               => 9001,
                         "electrodes"              => 9847,
                         "electrodynamics"         => 22488,
                         "electrolysis"            => 19469,
                         "electrolyte"             => 12931,
                         "electrolytic"            => 19315,
                         "electromagnetic"         => 6107,
                         "electromagnetism"        => 20777,
                         "electromechanical"       => 18996,
                         "electronic"              => 1441,
                         "electronica"             => 10051,
                         "electronically"          => 9561,
                         "electronics"             => 3094,
                         "electrons"               => 5148,
                         "electrophilic"           => 26532,
                         "electrophoresis"         => 19843,
                         "electropop"              => 17983,
                         "electrostatic"           => 11962,
                         "elects"                  => 8640,
                         "elegans"                 => 12449,
                         "elegantly"               => 20717,
                         "elegiac"                 => 25593,
                         "elegies"                 => 26418,
                         "elegy"                   => 15385,
                         "elemental"               => 9468,
                         "elementary"              => 1723,
                         "elements"                => 910,
                         "elevated"                => 2894,
                         "elevating"               => 16506,
                         "elevation"               => 2115,
                         "elevations"              => 6359,
                         "eleventh"                => 4247,
                         "elfin"                   => 27115,
                         "elfman"                  => 24815,
                         "elfsborg"                => 25633,
                         "elgar"                   => 12179,
                         "eliade"                  => 22962,
                         "elicit"                  => 14669,
                         "elicited"                => 16003,
                         "eliciting"               => 27255,
                         "eliezer"                 => 15049,
                         "eligibility"             => 5802,
                         "eligible"                => 2610,
                         "elihu"                   => 23626,
                         "eliminated"              => 2198,
                         "eliminates"              => 11281,
                         "eliminating"             => 5576,
                         "elimination"             => 3534,
                         "eliminations"            => 19936,
                         "eliminator"              => 21563,
                         "eliot"                   => 6716,
                         "elisabetta"              => 28048,
                         "elite"                   => 2512,
                         "elites"                  => 9723,
                         "elitserien"              => 14334,
                         "eliya"                   => 26922,
                         "eliyahu"                 => 22365,
                         "elizabethan"             => 9744,
                         "elizabethtown"           => 18960,
                         "elkhart"                 => 18949,
                         "elkhorn"                 => 20295,
                         "ellerslie"               => 28993,
                         "ellesmere"               => 14402,
                         "ellice"                  => 24641,
                         "ellipse"                 => 16083,
                         "ellipsis"                => 28183,
                         "ellipsoid"               => 16745,
                         "elliptic"                => 9693,
                         "elliptical"              => 9116,
                         "elmhurst"                => 20539,
                         "elmwood"                 => 15800,
                         "elocution"               => 28521,
                         "elongate"                => 13033,
                         "elongated"               => 6831,
                         "elongation"              => 17637,
                         "eloquence"               => 16639,
                         "elphaba"                 => 25007,
                         "elphinstone"             => 18452,
                         "elsevier"                => 17891,
                         "elsewhere"               => 2405,
                         "elstree"                 => 21310,
                         "eltham"                  => 19337,
                         "elucidate"               => 24891,
                         "elucidated"              => 21761,
                         "elven"                   => 17395,
                         "elwes"                   => 24900,
                         "elysees"                 => 18850,
                         "elysian"                 => 29149,
                         "elytra"                  => 24496,
                         "emacs"                   => 23485,
                         "email"                   => 4694,
                         "emails"                  => 10132,
                         "emamzadeh"               => 21931,
                         "emanated"                => 29336,
                         "emanating"               => 15559,
                         "emancipation"            => 7729,
                         "embankment"              => 8566,
                         "embankments"             => 17200,
                         "embarcadero"             => 26631,
                         "embargo"                 => 10188,
                         "embarkation"             => 20011,
                         "embarked"                => 3911,
                         "embarking"               => 11297,
                         "embarks"                 => 19281,
                         "embassies"               => 9474,
                         "embassy"                 => 3010,
                         "embattled"               => 18818,
                         "embed"                   => 22516,
                         "embedded"                => 4408,
                         "embedding"               => 12503,
                         "embellished"             => 13438,
                         "embellishment"           => 27162,
                         "embellishments"          => 22312,
                         "emblazoned"              => 18568,
                         "emblem"                  => 5895,
                         "emblematic"              => 15984,
                         "emblems"                 => 12962,
                         "embodied"                => 8781,
                         "embodies"                => 14011,
                         "embody"                  => 15679,
                         "embodying"               => 22530,
                         "emboldened"              => 25107,
                         "embossed"                => 16789,
                         "embraced"                => 6479,
                         "embraces"                => 11749,
                         "embraer"                 => 17648,
                         "embroidered"             => 11162,
                         "embroidery"              => 10837,
                         "embroiled"               => 10903,
                         "embryo"                  => 9483,
                         "embryology"              => 24113,
                         "embryonic"               => 9777,
                         "emcee"                   => 18026,
                         "emden"                   => 16847,
                         "emerge"                  => 5128,
                         "emerged"                 => 2272,
                         "emergence"               => 4855,
                         "emergent"                => 12045,
                         "emerges"                 => 7278,
                         "emerging"                => 3045,
                         "emeritus"                => 4858,
                         "emigrant"                => 14294,
                         "emigrants"               => 9821,
                         "emigrate"                => 11343,
                         "emigrated"               => 3831,
                         "emigrating"              => 14498,
                         "emigration"              => 6482,
                         "emigre"                  => 14680,
                         "emigres"                 => 18893,
                         "eminent"                 => 5178,
                         "eminescu"                => 27300,
                         "emirate"                 => 11696,
                         "emirates"                => 5341,
                         "emirati"                 => 25098,
                         "emirs"                   => 26363,
                         "emissaries"              => 16519,
                         "emission"                => 5540,
                         "emissions"               => 4094,
                         "emits"                   => 14348,
                         "emitted"                 => 8810,
                         "emitter"                 => 16703,
                         "emitters"                => 27227,
                         "emitting"                => 11543,
                         "emlyn"                   => 26427,
                         "emmanuelle"              => 21746,
                         "emmeline"                => 25754,
                         "emmerdale"               => 13800,
                         "emmet"                   => 15786,
                         "emmylou"                 => 22264,
                         "emotive"                 => 19254,
                         "emperor"                 => 872,
                         "emperors"                => 6566,
                         "emphasis"                => 2675,
                         "emphasise"               => 15587,
                         "emphasised"              => 10303,
                         "emphasises"              => 17676,
                         "emphasising"             => 17712,
                         "emphasize"               => 6640,
                         "emphasized"              => 4923,
                         "emphasizes"              => 6961,
                         "emphasizing"             => 8083,
                         "empirical"               => 6131,
                         "empirically"             => 16454,
                         "empiricism"              => 22518,
                         "emplaced"                => 25539,
                         "emplacement"             => 20866,
                         "emplacements"            => 17265,
                         "employ"                  => 4578,
                         "employed"                => 1327,
                         "employees"               => 1558,
                         "employer"                => 4336,
                         "employers"               => 4318,
                         "employing"               => 5401,
                         "employment"              => 1975,
                         "employs"                 => 4429,
                         "empoli"                  => 25720,
                         "emporia"                 => 18118,
                         "empower"                 => 11502,
                         "empowered"               => 9141,
                         "empowering"              => 12803,
                         "empowerment"             => 8327,
                         "empowers"                => 22161,
                         "empresa"                 => 24257,
                         "empress"                 => 3691,
                         "empted"                  => 28847,
                         "empties"                 => 10595,
                         "emulate"                 => 10034,
                         "emulated"                => 13928,
                         "emulates"                => 28017,
                         "emulation"               => 12917,
                         "emulator"                => 15577,
                         "emulators"               => 24932,
                         "emulsion"                => 17466,
                         "enable"                  => 3374,
                         "enabled"                 => 3176,
                         "enables"                 => 4517,
                         "enabling"                => 4281,
                         "enact"                   => 10229,
                         "enacted"                 => 4119,
                         "enacting"                => 13651,
                         "enactment"               => 8306,
                         "enactments"              => 20606,
                         "enamel"                  => 9966,
                         "enantiomer"              => 29554,
                         "encamped"                => 17225,
                         "encampment"              => 11961,
                         "encampments"             => 25228,
                         "encapsulated"            => 16471,
                         "encapsulation"           => 22990,
                         "encased"                 => 14583,
                         "encephalopathy"          => 21781,
                         "encircle"                => 18185,
                         "encircled"               => 10942,
                         "encirclement"            => 14292,
                         "encircles"               => 23867,
                         "encircling"              => 15801,
                         "enclave"                 => 9558,
                         "enclaves"                => 14347,
                         "enclosed"                => 4294,
                         "encloses"                => 19673,
                         "enclosing"               => 12518,
                         "enclosure"               => 6661,
                         "enclosures"              => 12330,
                         "encode"                  => 11822,
                         "encoded"                 => 4275,
                         "encoder"                 => 19156,
                         "encodes"                 => 10824,
                         "encoding"                => 6366,
                         "encodings"               => 24103,
                         "encomienda"              => 28214,
                         "encompass"               => 8532,
                         "encompassed"             => 8454,
                         "encompasses"             => 4781,
                         "encompassing"            => 6873,
                         "encores"                 => 22796,
                         "encounter"               => 3328,
                         "encountered"             => 3283,
                         "encountering"            => 10476,
                         "encounters"              => 4273,
                         "encourage"               => 3221,
                         "encouraged"              => 2239,
                         "encourages"              => 5677,
                         "encroached"              => 23192,
                         "encroaching"             => 18911,
                         "encroachment"            => 13502,
                         "encroachments"           => 28724,
                         "encrypt"                 => 26962,
                         "encryption"              => 7844,
                         "encyclical"              => 14686,
                         "encyclopaedia"           => 9625,
                         "encyclopedia"            => 4949,
                         "encyclopedic"            => 17839,
                         "end"                     => 142,
                         "endangered"              => 3628,
                         "endeared"                => 26355,
                         "endeavored"              => 22242,
                         "endeavors"               => 9187,
                         "endeavour"               => 9155,
                         "endeavoured"             => 19184,
                         "endeavours"              => 14053,
                         "ended"                   => 649,
                         "endemic"                 => 2344,
                         "endemol"                 => 24980,
                         "enderby"                 => 23883,
                         "ending"                  => 1385,
                         "endocrine"               => 14667,
                         "endocrinology"           => 20412,
                         "endocytosis"             => 26551,
                         "endogenous"              => 13299,
                         "endometrial"             => 26548,
                         "endoplasmic"             => 21092,
                         "endorsed"                => 4215,
                         "endorsement"             => 7070,
                         "endorsements"            => 11276,
                         "endorses"                => 20795,
                         "endorsing"               => 13884,
                         "endoscopic"              => 24241,
                         "endoscopy"               => 27145,
                         "endothelial"             => 13499,
                         "endow"                   => 24914,
                         "endowed"                 => 6967,
                         "endowment"               => 5448,
                         "endowments"              => 14461,
                         "endpoint"                => 15769,
                         "endpoints"               => 17082,
                         "endurance"               => 5654,
                         "endured"                 => 7762,
                         "endures"                 => 22813,
                         "enduring"                => 6241,
                         "enemy"                   => 1328,
                         "energetic"               => 6766,
                         "energetically"           => 19722,
                         "energies"                => 7306,
                         "energon"                 => 23656,
                         "energy"                  => 573,
                         "enfeoffed"               => 24848,
                         "enforce"                 => 5924,
                         "enforceable"             => 18718,
                         "enforced"                => 5889,
                         "enforcement"             => 2474,
                         "enforcers"               => 18774,
                         "enforces"                => 19920,
                         "enforcing"               => 9096,
                         "engagements"             => 6765,
                         "engages"                 => 8107,
                         "engaging"                => 4647,
                         "engendered"              => 19896,
                         "engine"                  => 663,
                         "engined"                 => 7023,
                         "engineered"              => 5511,
                         "engineering"             => 787,
                         "engineers"               => 2192,
                         "engines"                 => 1549,
                         "england"                 => 275,
                         "englewood"               => 14471,
                         "english"                 => 221,
                         "englishmen"              => 15601,
                         "engraved"                => 6391,
                         "engraver"                => 8782,
                         "engravers"               => 19997,
                         "engraving"               => 8115,
                         "engravings"              => 9431,
                         "engulfed"                => 13869,
                         "enhance"                 => 4129,
                         "enhanced"                => 3567,
                         "enhancement"             => 7789,
                         "enhancements"            => 10804,
                         "enhances"                => 11663,
                         "enhancing"               => 7210,
                         "enigmatic"               => 12271,
                         "eniwetok"                => 13554,
                         "enjoined"                => 26233,
                         "enlai"                   => 24104,
                         "enlarge"                 => 13564,
                         "enlarged"                => 4316,
                         "enlargement"             => 10726,
                         "enlarging"               => 16974,
                         "enlightenment"           => 6098,
                         "enlil"                   => 27044,
                         "enlisted"                => 3261,
                         "enlisting"               => 13220,
                         "enlistment"              => 13198,
                         "enlists"                 => 14939,
                         "enmity"                  => 13832,
                         "ennio"                   => 21822,
                         "enniskillen"             => 20340,
                         "ennobled"                => 17982,
                         "enplanements"            => 23908,
                         "enquiry"                 => 10295,
                         "enraged"                 => 7973,
                         "enrich"                  => 13510,
                         "enriched"                => 8387,
                         "enrichment"              => 8699,
                         "enroll"                  => 8465,
                         "enrolled"                => 2805,
                         "enrolling"               => 11678,
                         "enrollment"              => 3338,
                         "enrollments"             => 23522,
                         "enrolls"                 => 15464,
                         "enrolment"               => 12734,
                         "enron"                   => 15716,
                         "enschede"                => 23274,
                         "ensemble"                => 2750,
                         "ensembles"               => 6964,
                         "enshrined"               => 10949,
                         "ensign"                  => 7225,
                         "enslaved"                => 9011,
                         "enslavement"             => 18546,
                         "ensued"                  => 6822,
                         "ensues"                  => 11460,
                         "ensuing"                 => 4771,
                         "ensure"                  => 1962,
                         "ensured"                 => 6057,
                         "ensures"                 => 7367,
                         "ensuring"                => 4910,
                         "entablature"             => 17759,
                         "entailed"                => 12583,
                         "entangled"               => 13105,
                         "entanglement"            => 17691,
                         "entebbe"                 => 29465,
                         "entente"                 => 13852,
                         "entered"                 => 694,
                         "entering"                => 1986,
                         "enters"                  => 2775,
                         "entertainer"             => 7741,
                         "entertainers"            => 10624,
                         "entertainment"           => 1019,
                         "entertainments"          => 14278,
                         "entertains"              => 27344,
                         "enthalpy"                => 20801,
                         "enthroned"               => 14477,
                         "enthronement"            => 27811,
                         "enthusiast"              => 9396,
                         "enthusiastically"        => 11732,
                         "enthusiasts"             => 6588,
                         "entirely"                => 1568,
                         "entirety"                => 5983,
                         "entities"                => 3957,
                         "entitled"                => 1234,
                         "entitlement"             => 14968,
                         "entitlements"            => 23644,
                         "entity"                  => 3307,
                         "entombed"                => 18497,
                         "entomological"           => 19862,
                         "entomologist"            => 12356,
                         "entomology"              => 14464,
                         "entrance"                => 1572,
                         "entrances"               => 7004,
                         "entrant"                 => 13657,
                         "entrants"                => 6530,
                         "entre"                   => 13246,
                         "entrenched"              => 10244,
                         "entrenchments"           => 27674,
                         "entrepreneur"            => 3937,
                         "entrepreneurial"         => 9770,
                         "entrepreneurs"           => 6228,
                         "entrepreneurship"        => 7417,
                         "entries"                 => 3779,
                         "entrusted"               => 6545,
                         "entry"                   => 1343,
                         "entryway"                => 29279,
                         "enugu"                   => 19528,
                         "enumerated"              => 13696,
                         "enumeration"             => 18166,
                         "enveloped"               => 15711,
                         "enveloping"              => 26341,
                         "enver"                   => 18702,
                         "environment"             => 1033,
                         "environmental"           => 1199,
                         "environmentalism"        => 17155,
                         "environmentalist"        => 12998,
                         "environmentalists"       => 14649,
                         "environmentally"         => 8062,
                         "environments"            => 3613,
                         "environs"                => 12476,
                         "envisaged"               => 10140,
                         "envisioned"              => 7204,
                         "envisions"               => 23512,
                         "envoy"                   => 7258,
                         "envoys"                  => 12070,
                         "enzymatic"               => 16044,
                         "enzyme"                  => 2846,
                         "enzymes"                 => 5720,
                         "enzymology"              => 12527,
                         "eocene"                  => 10834,
                         "eotvos"                  => 27568,
                         "eparchy"                 => 14862,
                         "ephemera"                => 24304,
                         "ephemeral"               => 14363,
                         "ephesus"                 => 14694,
                         "ephraim"                 => 11456,
                         "epic"                    => 3272,
                         "epicenter"               => 15542,
                         "epicentre"               => 29733,
                         "epics"                   => 12621,
                         "epidemic"                => 6033,
                         "epidemics"               => 12554,
                         "epidemiological"         => 17435,
                         "epidemiology"            => 9110,
                         "epidermal"               => 19839,
                         "epidermis"               => 17428,
                         "epigenetic"              => 16780,
                         "epigram"                 => 27949,
                         "epigrams"                => 24289,
                         "epigraph"                => 28098,
                         "epigraphic"              => 29882,
                         "epilepsy"                => 9647,
                         "epilogue"                => 10795,
                         "epiphanius"              => 29179,
                         "epiphytic"               => 27346,
                         "epirus"                  => 11374,
                         "episcopacy"              => 19117,
                         "episcopal"               => 3051,
                         "episcopalian"            => 18055,
                         "episcopate"              => 12182,
                         "episode"                 => 440,
                         "episodes"                => 1008,
                         "episodic"                => 11666,
                         "epistemic"               => 24078,
                         "epistemological"         => 19026,
                         "epistemology"            => 13508,
                         "epistle"                 => 11171,
                         "epistles"                => 12688,
                         "epistolary"              => 28343,
                         "epitaph"                 => 10979,
                         "epithelial"              => 11553,
                         "epithelium"              => 14452,
                         "epithet"                 => 7092,
                         "epithets"                => 21172,
                         "epitomized"              => 26089,
                         "epoch"                   => 8271,
                         "epochs"                  => 21784,
                         "eponym"                  => 22289,
                         "eponymous"               => 5344,
                         "epoque"                  => 29713,
                         "epsom"                   => 8643,
                         "epworth"                 => 26062,
                         "equal"                   => 1576,
                         "equaled"                 => 17781,
                         "equaling"                => 25340,
                         "equalised"               => 16570,
                         "equaliser"               => 13038,
                         "equalising"              => 25816,
                         "equality"                => 3694,
                         "equalization"            => 17209,
                         "equalize"                => 28531,
                         "equalized"               => 24228,
                         "equalled"                => 13780,
                         "equalling"               => 19912,
                         "equally"                 => 3342,
                         "equated"                 => 13523,
                         "equates"                 => 17572,
                         "equating"                => 19132,
                         "equation"                => 2807,
                         "equations"               => 3907,
                         "equator"                 => 8561,
                         "equatorial"              => 7300,
                         "equestrian"              => 6318,
                         "equidistant"             => 20510,
                         "equilateral"             => 21292,
                         "equilibria"              => 23624,
                         "equilibrium"             => 5136,
                         "equine"                  => 12885,
                         "equip"                   => 10521,
                         "equipment"               => 987,
                         "equipments"              => 22415,
                         "equipped"                => 1931,
                         "equipping"               => 15123,
                         "equitable"               => 9829,
                         "equities"                => 19252,
                         "equity"                  => 3544,
                         "equivalence"             => 8615,
                         "equivalent"              => 1797,
                         "equivalently"            => 12229,
                         "equivalents"             => 10197,
                         "equus"                   => 23726,
                         "era"                     => 743,
                         "eradicate"               => 12433,
                         "eradicated"              => 16936,
                         "eradicating"             => 26141,
                         "eradication"             => 12141,
                         "erastus"                 => 28268,
                         "erbil"                   => 27012,
                         "erdogan"                 => 14197,
                         "erdos"                   => 18530,
                         "erebidae"                => 13736,
                         "erect"                   => 6365,
                         "erected"                 => 2349,
                         "erectile"                => 21182,
                         "erecting"                => 14354,
                         "erectus"                 => 21509,
                         "eredivisie"              => 10774,
                         "eretz"                   => 24301,
                         "erfurt"                  => 13617,
                         "ergative"                => 26598,
                         "ergonomic"               => 26498,
                         "ergonomics"              => 22275,
                         "erhard"                  => 17559,
                         "erie"                    => 4532,
                         "erigeron"                => 22692,
                         "eriksson"                => 13262,
                         "erinsborough"            => 21336,
                         "eritrea"                 => 8581,
                         "eritrean"                => 14169,
                         "erlangen"                => 17685,
                         "erlewine"                => 13018,
                         "ernakulam"               => 14964,
                         "erode"                   => 13492,
                         "eroded"                  => 7949,
                         "erosion"                 => 5038,
                         "eroticism"               => 23897,
                         "erroll"                  => 28024,
                         "erroneous"               => 11378,
                         "erroneously"             => 9244,
                         "error"                   => 2707,
                         "errors"                  => 3773,
                         "erste"                   => 26216,
                         "erstwhile"               => 10049,
                         "erudite"                 => 19781,
                         "erudition"               => 24893,
                         "erupted"                 => 6642,
                         "erupting"                => 23055,
                         "eruption"                => 6297,
                         "eruptions"               => 9032,
                         "eruptive"                => 23642,
                         "erupts"                  => 20328,
                         "erythrocytes"            => 26412,
                         "erzhu"                   => 24438,
                         "erzurum"                 => 20456,
                         "escadrille"              => 21470,
                         "escalated"               => 9768,
                         "escalates"               => 28779,
                         "escalation"              => 13524,
                         "escalators"              => 16469,
                         "escapees"                => 18813,
                         "escapement"              => 22607,
                         "escapes"                 => 5036,
                         "escapist"                => 26503,
                         "escarpment"              => 9884,
                         "eschatology"             => 24321,
                         "escherichia"             => 19866,
                         "eschewed"                => 21268,
                         "eschewing"               => 27082,
                         "escondido"               => 21590,
                         "escorial"                => 27018,
                         "escorted"                => 5971,
                         "escorting"               => 8825,
                         "escuela"                 => 12608,
                         "escutcheon"              => 24697,
                         "esher"                   => 23870,
                         "eskisehir"               => 25903,
                         "eslamabad"               => 17958,
                         "esoteric"                => 9822,
                         "espanola"                => 12795,
                         "espanyol"                => 18370,
                         "especial"                => 22023,
                         "esperance"               => 16670,
                         "esperanto"               => 9872,
                         "espionage"               => 7410,
                         "espirito"                => 17553,
                         "esplanade"               => 13180,
                         "espn"                    => 4069,
                         "espn.com"                => 22958,
                         "espn2"                   => 20251,
                         "espoo"                   => 20547,
                         "esporte"                 => 15640,
                         "espouse"                 => 29849,
                         "espoused"                => 12972,
                         "espousing"               => 28253,
                         "esque"                   => 13175,
                         "esquimalt"               => 22642,
                         "essayist"                => 10282,
                         "essays"                  => 3650,
                         "essen"                   => 10334,
                         "essential"               => 2340,
                         "essentially"             => 2566,
                         "essex"                   => 3011,
                         "essonne"                 => 28464,
                         "establish"               => 1598,
                         "established"             => 254,
                         "establishes"             => 7520,
                         "establishing"            => 2427,
                         "establishment"           => 1437,
                         "establishments"          => 5977,
                         "estadio"                 => 6687,
                         "estado"                  => 13428,
                         "estate"                  => 924,
                         "estates"                 => 2967,
                         "esteghlal"               => 20096,
                         "esterhazy"               => 19444,
                         "estero"                  => 18346,
                         "estimate"                => 3636,
                         "estimated"               => 1128,
                         "estimates"               => 3396,
                         "estimating"              => 11609,
                         "estimation"              => 8826,
                         "estimations"             => 26660,
                         "estimator"               => 14797,
                         "estimators"              => 26278,
                         "estonia"                 => 3683,
                         "estonian"                => 4649,
                         "estonians"               => 20141,
                         "estoril"                 => 18252,
                         "estradiol"               => 24576,
                         "estrellas"               => 22790,
                         "estuaries"               => 12699,
                         "estuarine"               => 17379,
                         "estuary"                 => 6109,
                         "estudiantes"             => 15901,
                         "estudios"                => 24312,
                         "esztergom"               => 22446,
                         "etc."                    => 4884,
                         "etc.."                   => 21159,
                         "etcher"                  => 29595,
                         "etching"                 => 12281,
                         "etchings"                => 13955,
                         "ethanol"                 => 7439,
                         "ethereal"                => 15784,
                         "ethers"                  => 28131,
                         "ethical"                 => 4684,
                         "ethiopia"                => 3961,
                         "ethiopian"               => 5228,
                         "ethiopians"              => 19522,
                         "ethmia"                  => 22215,
                         "ethnic"                  => 1623,
                         "ethnically"              => 8692,
                         "ethnicities"             => 13542,
                         "ethnicity"               => 6168,
                         "ethniki"                 => 17283,
                         "ethnikos"                => 26563,
                         "ethno"                   => 17551,
                         "ethnographer"            => 22820,
                         "ethnographic"            => 10329,
                         "ethnography"             => 13627,
                         "ethnological"            => 22966,
                         "ethnologist"             => 24007,
                         "ethnologue"              => 22294,
                         "ethnology"               => 16283,
                         "ethnomusicology"         => 26475,
                         "ethos"                   => 10251,
                         "ethylene"                => 13248,
                         "etihad"                  => 24644,
                         "etiology"                => 18197,
                         "etobicoke"               => 17673,
                         "etruria"                 => 22562,
                         "etruscan"                => 11503,
                         "etruscans"               => 20989,
                         "etude"                   => 23529,
                         "etudes"                  => 12536,
                         "etymological"            => 17236,
                         "etymologically"          => 21834,
                         "etymologies"             => 22170,
                         "etymology"               => 3581,
                         "euboea"                  => 24901,
                         "eucalypt"                => 28064,
                         "eucalyptus"              => 9495,
                         "eucharist"               => 10693,
                         "eucharistic"             => 16187,
                         "euclidean"               => 8174,
                         "eudonia"                 => 27229,
                         "eugenics"                => 13750,
                         "eukaryotes"              => 14069,
                         "eukaryotic"              => 12215,
                         "eulima"                  => 29636,
                         "eunuchs"                 => 15157,
                         "euphemia"                => 22344,
                         "euphonium"               => 28011,
                         "euphorbia"               => 18089,
                         "euphorbiaceae"           => 24475,
                         "euphrates"               => 12614,
                         "eupithecia"              => 10371,
                         "eurasia"                 => 10544,
                         "eurasian"                => 8031,
                         "euripides"               => 18139,
                         "euro"                    => 3471,
                         "eurobasket"              => 11403,
                         "eurocopter"              => 25644,
                         "eurocup"                 => 14976,
                         "eurodance"               => 22735,
                         "eurogamer"               => 20751,
                         "euroleague"              => 9996,
                         "euromaidan"              => 27722,
                         "euronext"                => 28496,
                         "europaea"                => 29725,
                         "europe"                  => 429,
                         "europe/africa"           => 18647,
                         "european"                => 317,
                         "europeans"               => 4690,
                         "euros"                   => 7279,
                         "eurosceptic"             => 29568,
                         "eurosport"               => 25118,
                         "eurostar"                => 21681,
                         "eurovision"              => 3931,
                         "eurozone"                => 15085,
                         "eurydice"                => 23109,
                         "eurythmics"              => 27660,
                         "eusebian"                => 23719,
                         "eusebius"                => 12667,
                         "eustace"                 => 12775,
                         "euston"                  => 15126,
                         "euthanasia"              => 11906,
                         "euthanized"              => 27072,
                         "evacuated"               => 4828,
                         "evacuation"              => 5103,
                         "evacuations"             => 18739,
                         "evacuees"                => 18283,
                         "evade"                   => 10086,
                         "evaded"                  => 15186,
                         "evaluate"                => 5999,
                         "evaluated"               => 5861,
                         "evaluates"               => 13966,
                         "evaluating"              => 8377,
                         "evaluation"              => 3352,
                         "evaluations"             => 9975,
                         "evangelical"             => 3939,
                         "evangelicals"            => 16427,
                         "evangelism"              => 14288,
                         "evangelist"              => 8329,
                         "evangelistic"            => 18973,
                         "evangelists"             => 15199,
                         "evangelization"          => 18054,
                         "evanston"                => 12599,
                         "evansville"              => 10953,
                         "evaporates"              => 26701,
                         "evaporation"             => 10823,
                         "evenings"                => 6731,
                         "evenly"                  => 8089,
                         "event"                   => 382,
                         "eventing"                => 16899,
                         "events"                  => 385,
                         "eventual"                => 3268,
                         "eventually"              => 408,
                         "everard"                 => 19792,
                         "evergreen"               => 6134,
                         "everyman"                => 17362,
                         "evesham"                 => 17837,
                         "eviction"                => 8732,
                         "evictions"               => 22882,
                         "evidenced"               => 7323,
                         "evidences"               => 16217,
                         "evident"                 => 4132,
                         "evocation"               => 24836,
                         "evocative"               => 14010,
                         "evoke"                   => 11286,
                         "evoked"                  => 12582,
                         "evokes"                  => 14086,
                         "evoking"                 => 16731,
                         "evolution"               => 2186,
                         "evolutionarily"          => 23928,
                         "evolutionary"            => 4537,
                         "evolutions"              => 23646,
                         "evolve"                  => 7102,
                         "evolved"                 => 2588,
                         "evolves"                 => 14371,
                         "evolving"                => 7138,
                         "evora"                   => 21797,
                         "evreux"                  => 29214,
                         "exacerbated"             => 10009,
                         "exacted"                 => 25448,
                         "exaggerated"             => 7740,
                         "exaltation"              => 25265,
                         "examination"             => 2689,
                         "examinations"            => 5147,
                         "examined"                => 3921,
                         "examiners"               => 14567,
                         "examines"                => 7690,
                         "example"                 => 362,
                         "examples"                => 1241,
                         "exams"                   => 5114,
                         "exarch"                  => 27837,
                         "exarchate"               => 21150,
                         "excavate"                => 19734,
                         "excavated"               => 5442,
                         "excavating"              => 18608,
                         "excavation"              => 5952,
                         "excavations"             => 4867,
                         "excavator"               => 27421,
                         "excavators"              => 23105,
                         "exceed"                  => 4841,
                         "exceeded"                => 5280,
                         "exceeding"               => 6288,
                         "exceeds"                 => 7748,
                         "excel"                   => 8697,
                         "excelled"                => 7390,
                         "excellence"              => 2952,
                         "excelling"               => 22207,
                         "excelsior"               => 11869,
                         "excepting"               => 15719,
                         "exception"               => 2147,
                         "exceptional"             => 4490,
                         "exceptionally"           => 6514,
                         "exceptions"              => 4060,
                         "excerpt"                 => 11086,
                         "excerpts"                => 9084,
                         "excess"                  => 3593,
                         "excesses"                => 13861,
                         "excessive"               => 4347,
                         "excessively"             => 11956,
                         "exchange"                => 1032,
                         "exchanged"               => 5658,
                         "exchanger"               => 17930,
                         "exchangers"              => 24058,
                         "exchanges"               => 5642,
                         "exchequer"               => 9256,
                         "excise"                  => 11433,
                         "excised"                 => 21078,
                         "excision"                => 19854,
                         "excitation"              => 12641,
                         "excitatory"              => 21341,
                         "exclaim"                 => 20221,
                         "exclaimed"               => 16186,
                         "exclaiming"              => 26991,
                         "exclaims"                => 24462,
                         "exclave"                 => 17918,
                         "exclude"                 => 7962,
                         "excluded"                => 4458,
                         "excludes"                => 11361,
                         "excluding"               => 5008,
                         "exclusion"               => 6289,
                         "exclusionary"            => 28933,
                         "exclusive"               => 2554,
                         "exclusively"             => 2458,
                         "exclusivity"             => 17438,
                         "excommunicated"          => 12321,
                         "excommunication"         => 13909,
                         "excreted"                => 18256,
                         "excretion"               => 19004,
                         "excursion"               => 9849,
                         "excursions"              => 10309,
                         "executable"              => 13776,
                         "executed"                => 2166,
                         "executes"                => 15254,
                         "executing"               => 8262,
                         "execution"               => 2696,
                         "executioners"            => 27433,
                         "executions"              => 7612,
                         "executive"               => 681,
                         "executives"              => 4474,
                         "executors"               => 19700,
                         "exegesis"                => 15752,
                         "exemplar"                => 20597,
                         "exemplars"               => 28864,
                         "exemplified"             => 9026,
                         "exemplifies"             => 16042,
                         "exemplify"               => 20061,
                         "exempt"                  => 6495,
                         "exempted"                => 10778,
                         "exemption"               => 6698,
                         "exemptions"              => 11614,
                         "exercised"               => 6290,
                         "exercises"               => 3888,
                         "exerted"                 => 9864,
                         "exertions"               => 29787,
                         "exerts"                  => 19635,
                         "exeter"                  => 4636,
                         "exhaust"                 => 5846,
                         "exhaustive"              => 11123,
                         "exhibit"                 => 2988,
                         "exhibited"               => 2876,
                         "exhibiting"              => 8086,
                         "exhibition"              => 1438,
                         "exhibitions"             => 2700,
                         "exhibitor"               => 24921,
                         "exhibitors"              => 14887,
                         "exhibits"                => 3561,
                         "exhortation"             => 28755,
                         "exhorted"                => 28717,
                         "exhumed"                 => 14530,
                         "exile"                   => 2812,
                         "exiled"                  => 5150,
                         "exiles"                  => 9083,
                         "exist"                   => 1481,
                         "existed"                 => 2043,
                         "existence"               => 1367,
                         "existent"                => 9265,
                         "existentialism"          => 20857,
                         "existing"                => 1197,
                         "exists"                  => 2133,
                         "exited"                  => 9776,
                         "exiting"                 => 9285,
                         "exmoor"                  => 23154,
                         "exmouth"                 => 19907,
                         "exogenous"               => 19417,
                         "exons"                   => 20780,
                         "exoplanet"               => 26998,
                         "exoplanets"              => 28429,
                         "exoskeleton"             => 20394,
                         "exothermic"              => 29105,
                         "expand"                  => 2662,
                         "expandable"              => 22627,
                         "expanded"                => 1159,
                         "expanding"               => 3285,
                         "expands"                 => 8546,
                         "expanse"                 => 14062,
                         "expanses"                => 23526,
                         "expansion"               => 1329,
                         "expansionism"            => 28271,
                         "expansionist"            => 21555,
                         "expansions"              => 9223,
                         "expansive"               => 9782,
                         "expatriate"              => 10343,
                         "expatriates"             => 11782,
                         "expectancy"              => 10245,
                         "expectation"             => 7227,
                         "expected"                => 1163,
                         "expedition"              => 1635,
                         "expeditionary"           => 5505,
                         "expeditions"             => 5078,
                         "expelled"                => 3477,
                         "expend"                  => 26203,
                         "expended"                => 14105,
                         "expenditure"             => 7217,
                         "expenditures"            => 7779,
                         "experience"              => 803,
                         "experienced"             => 1870,
                         "experiences"             => 2135,
                         "experiential"            => 14094,
                         "experiment"              => 2743,
                         "experimental"            => 2092,
                         "experimentally"          => 11079,
                         "experimentation"         => 7554,
                         "experimented"            => 7318,
                         "experimenter"            => 19974,
                         "experimenters"           => 25341,
                         "experiments"             => 2726,
                         "expertise"               => 4207,
                         "expertly"                => 25183,
                         "experts"                 => 3004,
                         "expired"                 => 5144,
                         "expiring"                => 19452,
                         "expiry"                  => 17525,
                         "explained"               => 2102,
                         "explicit"                => 4792,
                         "explicitly"              => 4190,
                         "exploitation"            => 5206,
                         "exploitative"            => 21524,
                         "exploited"               => 6571,
                         "exploits"                => 7139,
                         "exploration"             => 3206,
                         "explorations"            => 10691,
                         "explored"                => 4015,
                         "explorers"               => 6875,
                         "explores"                => 5663,
                         "exploring"               => 4836,
                         "explosive"               => 4524,
                         "exponent"                => 9553,
                         "exponential"             => 8816,
                         "exponentially"           => 12970,
                         "exponents"               => 13495,
                         "export"                  => 3258,
                         "exportation"             => 24882,
                         "exported"                => 5387,
                         "exporter"                => 11060,
                         "exporters"               => 17387,
                         "exporting"               => 10007,
                         "exports"                 => 4871,
                         "expos"                   => 10598,
                         "exposed"                 => 2432,
                         "exposes"                 => 11399,
                         "exposition"              => 4890,
                         "expositions"             => 16827,
                         "exposure"                => 2574,
                         "exposures"               => 12015,
                         "expounded"               => 18033,
                         "expressed"               => 1592,
                         "expresses"               => 5974,
                         "expressing"              => 5317,
                         "expression"              => 1956,
                         "expressionism"           => 12203,
                         "expressionist"           => 12380,
                         "expressions"             => 5094,
                         "expressive"              => 8576,
                         "expressly"               => 10317,
                         "expressway"              => 4090,
                         "expressways"             => 15793,
                         "expropriated"            => 19191,
                         "expropriation"           => 19823,
                         "expulsion"               => 6319,
                         "expulsions"              => 20875,
                         "extant"                  => 4658,
                         "extend"                  => 2779,
                         "extended"                => 930,
                         "extender"                => 28288,
                         "extending"               => 3128,
                         "extends"                 => 3142,
                         "extensible"              => 19145,
                         "extension"               => 1617,
                         "extensional"             => 29628,
                         "extensions"              => 4918,
                         "extensive"               => 1326,
                         "extensively"             => 2558,
                         "extensor"                => 25764,
                         "extent"                  => 2231,
                         "exterior"                => 3384,
                         "exteriors"               => 18558,
                         "extermination"           => 10065,
                         "external"                => 1402,
                         "externally"              => 8942,
                         "extinct"                 => 2913,
                         "extinction"              => 5298,
                         "extinctions"             => 22253,
                         "extinguished"            => 11529,
                         "extinguishing"           => 23237,
                         "extirpated"              => 20515,
                         "extolled"                => 29566,
                         "extracellular"           => 10398,
                         "extract"                 => 5784,
                         "extracted"               => 6206,
                         "extracting"              => 11969,
                         "extraction"              => 5334,
                         "extractor"               => 25213,
                         "extracts"                => 8991,
                         "extrajudicial"           => 19506,
                         "extraliga"               => 13628,
                         "extraneous"              => 25662,
                         "extrapolated"            => 28100,
                         "extrapolation"           => 26987,
                         "extrasolar"              => 18082,
                         "extraterritorial"        => 29962,
                         "extratropical"           => 11146,
                         "extravagance"            => 22053,
                         "extremadura"             => 16535,
                         "extremes"                => 10005,
                         "extremism"               => 13920,
                         "extremist"               => 11334,
                         "extremity"               => 11139,
                         "extrinsic"               => 20802,
                         "extruded"                => 22361,
                         "extrusion"               => 21140,
                         "exuberance"              => 25357,
                         "exuberant"               => 18001,
                         "exxonmobil"              => 21012,
                         "eyalet"                  => 20397,
                         "eyewall"                 => 24990,
                         "eyewear"                 => 23738,
                         "f.c.."                   => 10838,
                         "fabaceae"                => 14008,
                         "fabius"                  => 19113,
                         "fable"                   => 11191,
                         "fables"                  => 10817,
                         "fabrica"                 => 28015,
                         "fabricated"              => 8385,
                         "fabrication"             => 8877,
                         "fabricius"               => 23224,
                         "fabrics"                 => 8894,
                         "facade"                  => 3411,
                         "facades"                 => 10030,
                         "facebook"                => 3746,
                         "faced"                   => 1499,
                         "facelift"                => 12514,
                         "facelifted"              => 25916,
                         "facet"                   => 14773,
                         "faceted"                 => 17093,
                         "facets"                  => 10326,
                         "fachhochschule"          => 12366,
                         "facie"                   => 25085,
                         "facies"                  => 19855,
                         "facilitate"              => 3882,
                         "facilitated"             => 6775,
                         "facilitates"             => 8983,
                         "facilitating"            => 8645,
                         "facilitation"            => 16968,
                         "facilitator"             => 18857,
                         "facilitators"            => 28474,
                         "facilities"              => 874,
                         "facility"                => 1151,
                         "facing"                  => 2180,
                         "facings"                 => 27222,
                         "facsimile"               => 15400,
                         "factbook"                => 23024,
                         "faction"                 => 3800,
                         "factional"               => 17373,
                         "factionalism"            => 28805,
                         "factions"                => 5075,
                         "facto"                   => 4849,
                         "factor"                  => 1619,
                         "factorial"               => 21633,
                         "factories"               => 3861,
                         "factorization"           => 16964,
                         "factors"                 => 1777,
                         "factory"                 => 1381,
                         "factual"                 => 8752,
                         "facultative"             => 28399,
                         "faculties"               => 6128,
                         "faculty"                 => 1274,
                         "facundo"                 => 26678,
                         "faeces"                  => 28390,
                         "faience"                 => 25847,
                         "failed"                  => 806,
                         "failing"                 => 3038,
                         "fails"                   => 4493,
                         "failure"                 => 1523,
                         "failures"                => 5591,
                         "faintly"                 => 20301,
                         "faints"                  => 21446,
                         "faired"                  => 29950,
                         "fairfax"                 => 6444,
                         "fairground"              => 19918,
                         "fairgrounds"             => 12236,
                         "fairhaven"               => 24913,
                         "fairing"                 => 18240,
                         "fairlie"                 => 22817,
                         "fairmount"               => 16046,
                         "fairport"                => 19479,
                         "fairs"                   => 7079,
                         "fairtrade"               => 19109,
                         "faisalabad"              => 16900,
                         "faithfull"               => 24336,
                         "faiths"                  => 10125,
                         "faizabad"                => 28511,
                         "fakhr"                   => 27779,
                         "fakir"                   => 27501,
                         "falaise"                 => 23175,
                         "falange"                 => 29650,
                         "falcao"                  => 28921,
                         "falconiformesfamily"     => 27773,
                         "falconry"                => 29886,
                         "falkirk"                 => 10388,
                         "falkland"                => 8048,
                         "falklands"               => 11308,
                         "falla"                   => 24618,
                         "fallacy"                 => 14113,
                         "falls"                   => 1214,
                         "fallujah"                => 19234,
                         "falmouth"                => 10152,
                         "falsehood"               => 23999,
                         "falsely"                 => 8258,
                         "falsetto"                => 16722,
                         "falsification"           => 25218,
                         "falsifying"              => 28453,
                         "faltering"               => 25946,
                         "falun"                   => 13254,
                         "famagusta"               => 19779,
                         "famas"                   => 26993,
                         "fame"                    => 1209,
                         "famed"                   => 5217,
                         "famer"                   => 11626,
                         "famers"                  => 19084,
                         "famicom"                 => 14349,
                         "familial"                => 10864,
                         "familiarity"             => 11348,
                         "families"                => 421,
                         "family"                  => 94,
                         "famine"                  => 5745,
                         "famines"                 => 20867,
                         "famitsu"                 => 19965,
                         "famous"                  => 592,
                         "famously"                => 5981,
                         "fanbase"                 => 14547,
                         "fandom"                  => 15363,
                         "fanfare"                 => 11692,
                         "fangio"                  => 23183,
                         "fangoria"                => 29817,
                         "fanned"                  => 26191,
                         "fans"                    => 1203,
                         "fanshawe"                => 22506,
                         "fantail"                 => 23001,
                         "fantastical"             => 19693,
                         "fanzine"                 => 14434,
                         "fanzines"                => 23048,
                         "faraday"                 => 13104,
                         "farben"                  => 28709,
                         "farces"                  => 28826,
                         "farcical"                => 24870,
                         "fared"                   => 10418,
                         "fareham"                 => 24051,
                         "fares"                   => 8414,
                         "fargo"                   => 8156,
                         "farid"                   => 17198,
                         "farm"                    => 983,
                         "farmed"                  => 9418,
                         "farmers"                 => 2144,
                         "farmhouse"               => 7345,
                         "farmhouses"              => 19879,
                         "farming"                 => 2540,
                         "farmingdale"             => 29159,
                         "farmington"              => 11438,
                         "farmland"                => 5759,
                         "farmlands"               => 18324,
                         "farms"                   => 2960,
                         "farmstead"               => 11995,
                         "farmsteads"              => 26967,
                         "farmville"               => 28295,
                         "farnborough"             => 14140,
                         "farnese"                 => 15602,
                         "faroe"                   => 9951,
                         "faroese"                 => 11920,
                         "farringdon"              => 28205,
                         "fascia"                  => 10186,
                         "fascism"                 => 7850,
                         "fascist"                 => 5160,
                         "fascists"                => 12888,
                         "fashion"                 => 1537,
                         "fashionable"             => 7475,
                         "fassbinder"              => 29216,
                         "fastener"                => 28232,
                         "fasteners"               => 23093,
                         "fastest"                 => 3096,
                         "fasting"                 => 10752,
                         "fatah"                   => 12849,
                         "fatalities"              => 7027,
                         "fatality"                => 12432,
                         "fatally"                 => 9019,
                         "fated"                   => 9712,
                         "fateh"                   => 16448,
                         "fatehpur"                => 28737,
                         "fatherland"              => 13391,
                         "fatigue"                 => 7538,
                         "fatih"                   => 21712,
                         "fatimid"                 => 17097,
                         "fatimids"                => 27853,
                         "fatwa"                   => 17046,
                         "faubourg"                => 25287,
                         "faulted"                 => 20158,
                         "faulting"                => 19621,
                         "fauna"                   => 4541,
                         "faunal"                  => 18173,
                         "faure"                   => 13919,
                         "faversham"               => 23266,
                         "favorable"               => 4085,
                         "favorably"               => 9095,
                         "favored"                 => 4497,
                         "favoring"                => 11423,
                         "favour"                  => 2676,
                         "favourable"              => 6539,
                         "favourably"              => 13637,
                         "favoured"                => 5825,
                         "favouring"               => 15320,
                         "favourites"              => 8904,
                         "fayette"                 => 9433,
                         "fayetteville"            => 10285,
                         "fazal"                   => 24346,
                         "fealty"                  => 22268,
                         "feared"                  => 4555,
                         "fearful"                 => 9952,
                         "fearing"                 => 6164,
                         "fearsome"                => 16475,
                         "feasibility"             => 8004,
                         "feasible"                => 8059,
                         "feast"                   => 4001,
                         "feasts"                  => 12126,
                         "feat"                    => 4939,
                         "featherweight"           => 9333,
                         "feats"                   => 11405,
                         "feature"                 => 689,
                         "featured"                => 461,
                         "featureless"             => 27389,
                         "features"                => 420,
                         "featurette"              => 22893,
                         "featuring"               => 1049,
                         "february"                => 197,
                         "fecal"                   => 16710,
                         "fecundity"               => 29166,
                         "federacion"              => 18788,
                         "federal"                 => 462,
                         "federale"                => 28269,
                         "federalism"              => 15316,
                         "federalist"              => 9093,
                         "federalists"             => 15282,
                         "federalized"             => 25225,
                         "federally"               => 6931,
                         "federals"                => 20233,
                         "federated"               => 9560,
                         "federation"              => 1339,
                         "federations"             => 10232,
                         "federative"              => 23639,
                         "federer"                 => 9406,
                         "feedback"                => 4504,
                         "feeders"                 => 15058,
                         "feedstock"               => 21280,
                         "fees"                    => 3426,
                         "feigned"                 => 22710,
                         "feint"                   => 28685,
                         "felis"                   => 28589,
                         "felixstowe"              => 20410,
                         "felled"                  => 16992,
                         "fellow"                  => 858,
                         "fellowship"              => 3079,
                         "fellowships"             => 8463,
                         "feltham"                 => 28688,
                         "female"                  => 522,
                         "females"                 => 781,
                         "femina"                  => 21132,
                         "femininity"              => 17703,
                         "feminism"                => 7424,
                         "feminist"                => 4103,
                         "feminists"               => 10428,
                         "fenced"                  => 12808,
                         "fencers"                 => 18028,
                         "fencing"                 => 5485,
                         "fenders"                 => 16141,
                         "fengtian"                => 29967,
                         "fengxiang"               => 28823,
                         "fenian"                  => 20635,
                         "feodor"                  => 27108,
                         "feral"                   => 9324,
                         "ferdinando"              => 14986,
                         "ferenc"                  => 12220,
                         "ferencvaros"             => 24715,
                         "fergana"                 => 29805,
                         "fermanagh"               => 14083,
                         "fermentation"            => 9137,
                         "fermented"               => 12034,
                         "fermenting"              => 27403,
                         "fermi"                   => 12084,
                         "fermions"                => 21485,
                         "ferns"                   => 9720,
                         "ferocity"                => 20453,
                         "feroz"                   => 29674,
                         "ferran"                  => 29175,
                         "ferrand"                 => 19190,
                         "ferrers"                 => 17010,
                         "ferric"                  => 26725,
                         "ferried"                 => 17520,
                         "ferries"                 => 6598,
                         "ferrite"                 => 28976,
                         "ferrocarril"             => 26544,
                         "ferrol"                  => 23831,
                         "ferromagnetic"           => 25841,
                         "ferrous"                 => 16979,
                         "ferruccio"               => 25509,
                         "ferruginous"             => 23067,
                         "ferry"                   => 2384,
                         "ferrying"                => 18662,
                         "fertile"                 => 5324,
                         "fertilisation"           => 20707,
                         "fertiliser"              => 24384,
                         "fertilization"           => 11661,
                         "fertilized"              => 18067,
                         "fertilizers"             => 13167,
                         "fervent"                 => 14846,
                         "fervently"               => 28577,
                         "fervour"                 => 28592,
                         "festival"                => 431,
                         "festivals"               => 2285,
                         "festivity"               => 26653,
                         "festschrift"             => 26980,
                         "fetishism"               => 26873,
                         "feud"                    => 4705,
                         "feudal"                  => 5633,
                         "feudalism"               => 16422,
                         "feuded"                  => 15041,
                         "feuding"                 => 13361,
                         "feuds"                   => 12589,
                         "fewer"                   => 3072,
                         "fewest"                  => 12121,
                         "ffestiniog"              => 23478,
                         "ffffff"                  => 16799,
                         "fianna"                  => 9646,
                         "fiber"                   => 4413,
                         "fiberglass"              => 10779,
                         "fibers"                  => 5925,
                         "fibre"                   => 7319,
                         "fibreglass"              => 18998,
                         "fibres"                  => 11382,
                         "fibrillation"            => 21926,
                         "fibroblasts"             => 23153,
                         "fibrosis"                => 13203,
                         "fibrous"                 => 12460,
                         "fibula"                  => 20642,
                         "fiction"                 => 1192,
                         "fictional"               => 1992,
                         "fictionalised"           => 22458,
                         "fictionalized"           => 11789,
                         "fictions"                => 23942,
                         "fictitious"              => 8133,
                         "fiddlers"                => 26633,
                         "fidesz"                  => 26342,
                         "fiduciary"               => 17297,
                         "fiefs"                   => 17826,
                         "field"                   => 281,
                         "fielded"                 => 7181,
                         "fielders"                => 21885,
                         "fieldhouse"              => 17692,
                         "fieldwork"               => 13517,
                         "fiennes"                 => 17235,
                         "fierce"                  => 4869,
                         "fiercely"                => 10204,
                         "fiestas"                 => 27483,
                         "fifa"                    => 2282,
                         "fifteenth"               => 6084,
                         "fifth"                   => 827,
                         "fifths"                  => 12268,
                         "fighters"                => 2584,
                         "figueres"                => 28854,
                         "figurative"              => 9745,
                         "figures"                 => 1267,
                         "figurine"                => 18657,
                         "figurines"               => 11157,
                         "fiji"                    => 4189,
                         "fijian"                  => 10293,
                         "fijians"                 => 22540,
                         "filament"                => 12814,
                         "filamentous"             => 21027,
                         "filaments"               => 12336,
                         "filed"                   => 2214,
                         "filename"                => 24037,
                         "filesystem"              => 18209,
                         "filho"                   => 19785,
                         "filings"                 => 18504,
                         "filipina"                => 18980,
                         "filipino"                => 3761,
                         "filipinos"               => 9447,
                         "filipovic"               => 27118,
                         "fille"                   => 20770,
                         "fillies"                 => 13907,
                         "filly"                   => 8900,
                         "film"                    => 78,
                         "filmation"               => 27888,
                         "filmed"                  => 2052,
                         "filmfare"                => 9917,
                         "filming"                 => 2446,
                         "filmmaker"               => 4533,
                         "filmmakers"              => 5857,
                         "filmmaking"              => 8012,
                         "filmography"             => 7536,
                         "films"                   => 515,
                         "filmworks"               => 25913,
                         "filtered"                => 10556,
                         "filtering"               => 8682,
                         "filters"                 => 6460,
                         "filton"                  => 29152,
                         "filtration"              => 11151,
                         "final"                   => 188,
                         "finale"                  => 3512,
                         "finalised"               => 15052,
                         "finalist"                => 4557,
                         "finalists"               => 4947,
                         "finalized"               => 8254,
                         "finals"                  => 1183,
                         "finance"                 => 1732,
                         "financed"                => 4806,
                         "finances"                => 5766,
                         "financial"               => 668,
                         "financially"             => 5030,
                         "financier"               => 10372,
                         "financiers"              => 17507,
                         "financing"               => 4288,
                         "finches"                 => 17794,
                         "findings"                => 3364,
                         "fined"                   => 6145,
                         "finely"                  => 8911,
                         "fines"                   => 7666,
                         "fingal"                  => 20293,
                         "fingerboard"             => 23013,
                         "finial"                  => 26803,
                         "finials"                 => 27489,
                         "finished"                => 486,
                         "finisher"                => 12123,
                         "finishers"               => 9621,
                         "finishes"                => 4736,
                         "finishing"               => 1604,
                         "finistere"               => 24165,
                         "finisterre"              => 27624,
                         "finite"                  => 3823,
                         "finitely"                => 14526,
                         "finland"                 => 2074,
                         "finlandia"               => 29020,
                         "finned"                  => 12052,
                         "finnic"                  => 26874,
                         "finnish"                 => 2280,
                         "finnmark"                => 17290,
                         "finno"                   => 29294,
                         "finns"                   => 11740,
                         "finsbury"                => 17690,
                         "fionn"                   => 26970,
                         "fiorentina"              => 13477,
                         "firearm"                 => 8481,
                         "firearms"                => 4913,
                         "firebirds"               => 22752,
                         "firebox"                 => 17954,
                         "firebrand"               => 26843,
                         "firefighters"            => 8038,
                         "firefighting"            => 13226,
                         "fireside"                => 29148,
                         "firewalls"               => 26586,
                         "firings"                 => 23765,
                         "firm"                    => 1037,
                         "firmly"                  => 5644,
                         "firmness"                => 27428,
                         "firms"                   => 3359,
                         "firmware"                => 10831,
                         "first"                   => 26,
                         "first-past-the-post"     => 19780,
                         "firstly"                 => 6129,
                         "firsts"                  => 14270,
                         "firuzabad"               => 21919,
                         "fiscal"                  => 3807,
                         "fiscally"                => 27744,
                         "fisheries"               => 4990,
                         "fishermen"               => 5965,
                         "fishery"                 => 7706,
                         "fisichella"              => 22183,
                         "fissile"                 => 22227,
                         "fission"                 => 8757,
                         "fissure"                 => 17670,
                         "fissures"                => 21048,
                         "fistula"                 => 24077,
                         "fitchburg"               => 18974,
                         "fitted"                  => 2493,
                         "fittingly"               => 27855,
                         "fittings"                => 9826,
                         "fittipaldi"              => 20037,
                         "fitzalan"                => 21378,
                         "fitzherbert"             => 28585,
                         "fitzroy"                 => 7660,
                         "fitzwilliam"             => 13318,
                         "fiume"                   => 19536,
                         "five"                    => 181,
                         "fixture"                 => 5500,
                         "fixtures"                => 6165,
                         "fjord"                   => 8891,
                         "fjordane"                => 20861,
                         "fjords"                  => 21288,
                         "flacco"                  => 28417,
                         "flag"                    => 1569,
                         "flagella"                => 25432,
                         "flagrant"                => 26744,
                         "flags"                   => 4446,
                         "flagship"                => 3577,
                         "flagstaff"               => 14391,
                         "flamboyant"              => 12062,
                         "flamenco"                => 10946,
                         "flamethrower"            => 25880,
                         "flamingos"               => 18257,
                         "flanges"                 => 26820,
                         "flank"                   => 4565,
                         "flanked"                 => 6853,
                         "flanking"                => 9576,
                         "flanks"                  => 8593,
                         "flaps"                   => 10504,
                         "flashback"               => 8113,
                         "flashbacks"              => 9833,
                         "flashpoint"              => 20224,
                         "flat"                    => 1625,
                         "flatiron"                => 29224,
                         "flatly"                  => 22125,
                         "flats"                   => 5367,
                         "flattened"               => 7751,
                         "flattening"              => 22727,
                         "flatts"                  => 27184,
                         "flautist"                => 19066,
                         "flava"                   => 23437,
                         "flavius"                 => 17350,
                         "flavoring"               => 22175,
                         "flavour"                 => 9259,
                         "flavoured"               => 16702,
                         "flavours"                => 15366,
                         "fleche"                  => 23206,
                         "fled"                    => 2487,
                         "fledging"                => 25238,
                         "fledgling"               => 8771,
                         "flee"                    => 4250,
                         "fleeing"                 => 5961,
                         "flees"                   => 8412,
                         "fleet"                   => 981,
                         "fleets"                  => 8395,
                         "flemington"              => 21610,
                         "flemish"                 => 5427,
                         "flensburg"               => 18147,
                         "fleshed"                 => 24406,
                         "fleshy"                  => 11776,
                         "fleur"                   => 13139,
                         "fleurs"                  => 24174,
                         "flexed"                  => 29494,
                         "flexibility"             => 6002,
                         "flexion"                 => 21726,
                         "flexor"                  => 22107,
                         "flickr"                  => 26345,
                         "flight"                  => 868,
                         "flightless"              => 19831,
                         "flights"                 => 2553,
                         "flinders"                => 10148,
                         "flintlock"               => 28360,
                         "flintoff"                => 28424,
                         "flintshire"              => 18575,
                         "floated"                 => 10237,
                         "floatplane"              => 25075,
                         "flocked"                 => 17389,
                         "flocks"                  => 11071,
                         "flooded"                 => 5083,
                         "flooding"                => 3505,
                         "floodlights"             => 16824,
                         "floodlit"                => 18584,
                         "floodplain"              => 12697,
                         "floodplains"             => 20800,
                         "floods"                  => 5152,
                         "floodwaters"             => 22655,
                         "floorball"               => 19600,
                         "flooring"                => 11876,
                         "floors"                  => 3454,
                         "floral"                  => 7945,
                         "florentine"              => 10978,
                         "florets"                 => 12465,
                         "florins"                 => 24269,
                         "flotilla"                => 6108,
                         "flotillas"               => 28769,
                         "flour"                   => 5393,
                         "flourish"                => 9805,
                         "flourished"              => 6091,
                         "flourishes"              => 18970,
                         "flourishing"             => 9464,
                         "flow"                    => 1529,
                         "flowed"                  => 9530,
                         "flowered"                => 15830,
                         "flowering"               => 3969,
                         "flowing"                 => 3960,
                         "flown"                   => 4067,
                         "flows"                   => 1989,
                         "fluctuate"               => 21940,
                         "fluctuated"              => 17241,
                         "fluctuates"              => 27305,
                         "fluctuating"             => 16280,
                         "fluctuation"             => 20034,
                         "fluctuations"            => 9422,
                         "fluency"                 => 14799,
                         "fluent"                  => 6952,
                         "fluently"                => 15558,
                         "fluid"                   => 3250,
                         "fluidity"                => 23094,
                         "flume"                   => 20329,
                         "fluminense"              => 18757,
                         "fluorescence"            => 11662,
                         "fluorescent"             => 9386,
                         "fluoridation"            => 29814,
                         "fluoride"                => 10657,
                         "fluorine"                => 15502,
                         "flushing"                => 10064,
                         "flute"                   => 5084,
                         "fluted"                  => 16638,
                         "flutes"                  => 11828,
                         "flutist"                 => 24329,
                         "fluvial"                 => 19626,
                         "fluxes"                  => 24907,
                         "fluxus"                  => 22082,
                         "flyby"                   => 21709,
                         "flycatcher"              => 13547,
                         "flycatchers"             => 18639,
                         "flyover"                 => 14925,
                         "flyweight"               => 10394,
                         "foaled"                  => 12895,
                         "foals"                   => 15407,
                         "focal"                   => 5616,
                         "focke"                   => 19324,
                         "focus"                   => 1029,
                         "focused"                 => 1509,
                         "focuses"                 => 2581,
                         "focusing"                => 3172,
                         "focussed"                => 11751,
                         "foggia"                  => 21576,
                         "foils"                   => 22149,
                         "folate"                  => 24323,
                         "folded"                  => 4297,
                         "folds"                   => 8858,
                         "foliage"                 => 8144,
                         "folio"                   => 10409,
                         "folios"                  => 21377,
                         "folk"                    => 1597,
                         "folkestone"              => 15521,
                         "folklore"                => 4592,
                         "folkloric"               => 17999,
                         "folklorist"              => 16960,
                         "folktale"                => 27079,
                         "folktales"               => 20947,
                         "folkways"                => 25793,
                         "follicular"              => 25256,
                         "follies"                 => 13121,
                         "followed"                => 443,
                         "follower"                => 7911,
                         "followers"               => 3141,
                         "following"               => 111,
                         "follows"                 => 1014,
                         "fondation"               => 21944,
                         "fondazione"              => 29938,
                         "fondo"                   => 28672,
                         "fonds"                   => 20944,
                         "font"                    => 5779,
                         "fontainebleau"           => 15474,
                         "fonts"                   => 9291,
                         "foods"                   => 3291,
                         "foodservice"             => 24376,
                         "foodstuffs"              => 14888,
                         "footage"                 => 3127,
                         "footballer"              => 969,
                         "footballers"             => 8355,
                         "footballing"             => 13843,
                         "footbridge"              => 11230,
                         "footed"                  => 10320,
                         "foothills"               => 6660,
                         "footnotes"               => 12900,
                         "footpath"                => 10820,
                         "footpaths"               => 13929,
                         "footprint"               => 8552,
                         "footscray"               => 12811,
                         "footy"                   => 20236,
                         "for"                     => 7,
                         "forage"                  => 9924,
                         "forages"                 => 28402,
                         "foraging"                => 9180,
                         "foramen"                 => 17299,
                         "foray"                   => 11106,
                         "forays"                  => 17810,
                         "forbade"                 => 9253,
                         "forbidding"              => 12196,
                         "force"                   => 292,
                         "forced"                  => 741,
                         "forcefully"              => 12657,
                         "forces"                  => 376,
                         "forcible"                => 17337,
                         "forcibly"                => 7812,
                         "forcing"                 => 3182,
                         "fords"                   => 18935,
                         "forebears"               => 25694,
                         "forecast"                => 7042,
                         "forecasters"             => 27516,
                         "forecasting"             => 10546,
                         "forecastle"              => 19904,
                         "forecasts"               => 9573,
                         "foreclosure"             => 13258,
                         "forecourt"               => 18361,
                         "forefront"               => 8274,
                         "foregoing"               => 23330,
                         "foreground"              => 11861,
                         "foreign"                 => 595,
                         "foreigners"              => 5870,
                         "foreland"                => 23423,
                         "forelimbs"               => 19338,
                         "foremost"                => 5753,
                         "forerunner"              => 7720,
                         "forerunners"             => 18263,
                         "foreshadowed"            => 19515,
                         "foreshadowing"           => 20735,
                         "foreshore"               => 18400,
                         "forestall"               => 22732,
                         "forested"                => 5065,
                         "foresters"               => 15894,
                         "forestry"                => 4746,
                         "forests"                 => 1820,
                         "forewing"                => 10703,
                         "forewings"               => 4751,
                         "foreword"                => 9593,
                         "forfar"                  => 17874,
                         "forfeited"               => 11323,
                         "forfeiture"              => 16184,
                         "forgeries"               => 16812,
                         "forges"                  => 17594,
                         "forli"                   => 20794,
                         "form"                    => 235,
                         "forma"                   => 22979,
                         "formal"                  => 1671,
                         "formalised"              => 17621,
                         "formalism"               => 13806,
                         "formalize"               => 26419,
                         "formalized"              => 10783,
                         "formally"                => 1997,
                         "format"                  => 970,
                         "formation"               => 946,
                         "formations"              => 4679,
                         "formative"               => 9209,
                         "formats"                 => 3742,
                         "formatted"               => 10462,
                         "formatting"              => 17329,
                         "formed"                  => 366,
                         "former"                  => 163,
                         "formerly"                => 937,
                         "formers"                 => 28078,
                         "formidable"              => 7240,
                         "forming"                 => 1942,
                         "formosa"                 => 10961,
                         "forms"                   => 774,
                         "formula_1"               => 4070,
                         "formula_10"              => 8092,
                         "formula_11"              => 8272,
                         "formula_12"              => 8612,
                         "formula_13"              => 8958,
                         "formula_14"              => 9270,
                         "formula_15"              => 9513,
                         "formula_16"              => 9699,
                         "formula_17"              => 9858,
                         "formula_18"              => 10120,
                         "formula_19"              => 10557,
                         "formula_2"               => 4744,
                         "formula_20"              => 10850,
                         "formula_21"              => 11168,
                         "formula_22"              => 11391,
                         "formula_23"              => 11593,
                         "formula_24"              => 11925,
                         "formula_25"              => 12306,
                         "formula_26"              => 12760,
                         "formula_27"              => 12927,
                         "formula_28"              => 13223,
                         "formula_29"              => 13512,
                         "formula_3"               => 5389,
                         "formula_30"              => 14018,
                         "formula_31"              => 14311,
                         "formula_32"              => 14483,
                         "formula_33"              => 14787,
                         "formula_34"              => 15286,
                         "formula_35"              => 15495,
                         "formula_36"              => 15535,
                         "formula_37"              => 16242,
                         "formula_38"              => 16668,
                         "formula_39"              => 16617,
                         "formula_4"               => 5832,
                         "formula_40"              => 16611,
                         "formula_41"              => 17677,
                         "formula_42"              => 17842,
                         "formula_43"              => 18524,
                         "formula_44"              => 19097,
                         "formula_45"              => 18840,
                         "formula_46"              => 19387,
                         "formula_47"              => 20017,
                         "formula_48"              => 20492,
                         "formula_49"              => 20111,
                         "formula_5"               => 6316,
                         "formula_50"              => 20654,
                         "formula_51"              => 20975,
                         "formula_52"              => 21749,
                         "formula_53"              => 22239,
                         "formula_54"              => 22766,
                         "formula_55"              => 23341,
                         "formula_56"              => 23380,
                         "formula_57"              => 23054,
                         "formula_58"              => 24028,
                         "formula_59"              => 24603,
                         "formula_6"               => 6668,
                         "formula_60"              => 24577,
                         "formula_61"              => 25961,
                         "formula_62"              => 25055,
                         "formula_63"              => 26205,
                         "formula_64"              => 26061,
                         "formula_65"              => 27057,
                         "formula_66"              => 28364,
                         "formula_7"               => 7048,
                         "formula_8"               => 7500,
                         "formula_9"               => 7694,
                         "formulae"                => 12951,
                         "formulaic"               => 19096,
                         "formulas"                => 8285,
                         "formulate"               => 11888,
                         "formulated"              => 6736,
                         "formulating"             => 14791,
                         "formulation"             => 6579,
                         "formulations"            => 12111,
                         "forrestal"               => 23141,
                         "fort"                    => 718,
                         "fortaleza"               => 19758,
                         "fortescue"               => 16290,
                         "fortification"           => 7764,
                         "fortifications"          => 5047,
                         "fortified"               => 4802,
                         "fortify"                 => 19175,
                         "fortifying"              => 29607,
                         "fortnight"               => 11799,
                         "fortnightly"             => 16402,
                         "fortran"                 => 14725,
                         "fortress"                => 2948,
                         "fortresses"              => 9511,
                         "forts"                   => 5305,
                         "fortunes"                => 6284,
                         "forum"                   => 2345,
                         "forums"                  => 6890,
                         "forwards"                => 7557,
                         "forza"                   => 15168,
                         "fossa"                   => 16269,
                         "fossiliferous"           => 29364,
                         "fossils"                 => 4028,
                         "fostered"                => 10363,
                         "fostering"               => 10035,
                         "fotbollforbund"          => 28615,
                         "fouad"                   => 25531,
                         "fought"                  => 1335,
                         "fouling"                 => 17864,
                         "fouls"                   => 17643,
                         "found"                   => 139,
                         "foundation"              => 615,
                         "foundational"            => 12708,
                         "foundations"             => 3603,
                         "founded"                 => 295,
                         "founder"                 => 1007,
                         "foundered"               => 16941,
                         "founders"                => 2931,
                         "founding"                => 1316,
                         "foundling"               => 23021,
                         "foundress"               => 26844,
                         "foundries"               => 19371,
                         "foundry"                 => 6899,
                         "fountains"               => 8542,
                         "four"                    => 115,
                         "four-and-a-half"         => 24559,
                         "fourfold"                => 27466,
                         "fourier"                 => 8570,
                         "foursquare"              => 23947,
                         "fourteenth"              => 5527,
                         "fourth"                  => 495,
                         "fourths"                 => 15228,
                         "fowey"                   => 25089,
                         "foxes"                   => 8827,
                         "foxtel"                  => 18544,
                         "foyle"                   => 16873,
                         "fracking"                => 27148,
                         "fraction"                => 5381,
                         "fractional"              => 11165,
                         "fractionation"           => 29114,
                         "fractions"               => 11243,
                         "fractures"               => 10047,
                         "fracturing"              => 13999,
                         "fragility"               => 20541,
                         "fragment"                => 6304,
                         "fragmentary"             => 11528,
                         "fragmentation"           => 9207,
                         "fragmented"              => 9597,
                         "fragments"               => 4072,
                         "fragrant"                => 14114,
                         "frame"                   => 1812,
                         "frames"                  => 4286,
                         "framework"               => 2578,
                         "frameworks"              => 10718,
                         "framingham"              => 18894,
                         "francais"                => 9241,
                         "francaise"               => 7804,
                         "france"                  => 316,
                         "franche"                 => 13408,
                         "franchise"               => 1996,
                         "franchised"              => 19076,
                         "franchisee"              => 25917,
                         "franchisees"             => 24169,
                         "franchises"              => 7163,
                         "franchising"             => 20504,
                         "franchitti"              => 29079,
                         "franciscan"              => 6677,
                         "franciscans"             => 12542,
                         "franciszek"              => 19636,
                         "francoist"               => 23240,
                         "franconia"               => 13804,
                         "franconian"              => 16059,
                         "francophone"             => 9883,
                         "francophonie"            => 23066,
                         "francorchamps"           => 27541,
                         "franjo"                  => 22051,
                         "frankford"               => 18645,
                         "frankfort"               => 13566,
                         "frankfurt"               => 3793,
                         "frankfurter"             => 15696,
                         "frankish"                => 8339,
                         "frankivsk"               => 25190,
                         "frankland"               => 25461,
                         "frankston"               => 17072,
                         "frans"                   => 10518,
                         "frantisek"               => 13877,
                         "franziska"               => 23985,
                         "frass"                   => 23760,
                         "fraternal"               => 10582,
                         "fraternities"            => 11094,
                         "fraudulent"              => 9085,
                         "fraudulently"            => 22569,
                         "fraunhofer"              => 25051,
                         "frazione"                => 18404,
                         "frazioni"                => 20929,
                         "fredericksburg"          => 11514,
                         "fredericton"             => 14908,
                         "fredrik"                 => 10235,
                         "fredrikstad"             => 18390,
                         "free"                    => 338,
                         "freebsd"                 => 17227,
                         "freedmen"                => 12537,
                         "freedoms"                => 7964,
                         "freeform"                => 26847,
                         "freehold"                => 12213,
                         "freeholder"              => 28828,
                         "freeholders"             => 20476,
                         "freelance"               => 5670,
                         "freelancers"             => 27812,
                         "freely"                  => 4382,
                         "freemason"               => 14612,
                         "freemasonry"             => 11909,
                         "freemasons"              => 13889,
                         "freemen"                 => 18830,
                         "freestanding"            => 19155,
                         "freestyle"               => 3111,
                         "freetown"                => 12155,
                         "freeview"                => 18165,
                         "freeware"                => 16485,
                         "frege"                   => 24275,
                         "freiburg"                => 8520,
                         "freie"                   => 22981,
                         "freight"                 => 2907,
                         "freighter"               => 10001,
                         "freighters"              => 18520,
                         "freiherr"                => 14697,
                         "freikorps"               => 24788,
                         "freising"                => 25173,
                         "freleng"                 => 26049,
                         "frelimo"                 => 29035,
                         "fremantle"               => 7044,
                         "french"                  => 225,
                         "frenchman"               => 9682,
                         "frenetic"                => 23742,
                         "frente"                  => 22532,
                         "frentzen"                => 26584,
                         "frenzied"                => 25696,
                         "frequencies"             => 4579,
                         "frequency"               => 1908,
                         "frequent"                => 2262,
                         "frequented"              => 8775,
                         "frequenting"             => 28908,
                         "frequently"              => 1246,
                         "freres"                  => 18479,
                         "fresco"                  => 9448,
                         "frescoed"                => 24847,
                         "frescoes"                => 8200,
                         "frescos"                 => 16714,
                         "freshwater"              => 4148,
                         "fresnel"                 => 15782,
                         "frets"                   => 19905,
                         "friars"                  => 8176,
                         "friary"                  => 13821,
                         "fribourg"                => 14522,
                         "fricative"               => 16236,
                         "fricatives"              => 22968,
                         "friction"                => 5985,
                         "frictional"              => 26164,
                         "friedkin"                => 25011,
                         "friedrich"               => 3319,
                         "friedrichshafen"         => 25601,
                         "friendlies"              => 11811,
                         "friendliness"            => 23921,
                         "friesland"               => 13132,
                         "frieze"                  => 10688,
                         "friezes"                 => 24363,
                         "frigate"                 => 5349,
                         "frigates"                => 7677,
                         "fringe"                  => 5209,
                         "fringed"                 => 18053,
                         "fringes"                 => 10654,
                         "frisia"                  => 17835,
                         "frisian"                 => 11330,
                         "frisians"                => 24929,
                         "frits"                   => 29496,
                         "friuli"                  => 13520,
                         "frobenius"               => 20999,
                         "frolunda"                => 28023,
                         "from"                    => 14,
                         "frome"                   => 16109,
                         "fronds"                  => 18105,
                         "frontage"                => 11300,
                         "frontal"                 => 6847,
                         "fronted"                 => 8194,
                         "frontenac"               => 16686,
                         "frontieres"              => 28035,
                         "frontiers"               => 10124,
                         "frontispiece"            => 26543,
                         "frontline"               => 10620,
                         "frontman"                => 7147,
                         "frontrunner"             => 19902,
                         "fronts"                  => 7757,
                         "froome"                  => 28410,
                         "frosinone"               => 27854,
                         "frosts"                  => 24292,
                         "fructose"                => 15465,
                         "fruiting"                => 16084,
                         "fruition"                => 10540,
                         "fruits"                  => 3977,
                         "frusciante"              => 23173,
                         "frustrate"               => 27423,
                         "fuego"                   => 13538,
                         "fuel"                    => 1440,
                         "fueled"                  => 7299,
                         "fueling"                 => 14599,
                         "fuelled"                 => 13120,
                         "fuels"                   => 6951,
                         "fuerza"                  => 21422,
                         "fujian"                  => 9547,
                         "fujimori"                => 20791,
                         "fukuoka"                 => 9394,
                         "fukushima"               => 9812,
                         "fukuyama"                => 27009,
                         "fulani"                  => 19205,
                         "fulda"                   => 15169,
                         "fulfil"                  => 11655,
                         "fulfilment"              => 20202,
                         "full"                    => 312,
                         "fullness"                => 22437,
                         "fully"                   => 1249,
                         "fumble"                  => 7061,
                         "fumbled"                 => 14145,
                         "fumbles"                 => 12065,
                         "funafuti"                => 27021,
                         "funchal"                 => 27828,
                         "function"                => 881,
                         "functional"              => 2917,
                         "functionalism"           => 23889,
                         "functionalist"           => 28982,
                         "functionalities"         => 26773,
                         "functionality"           => 5246,
                         "functionally"            => 12110,
                         "functionaries"           => 21804,
                         "functionary"             => 25859,
                         "functioned"              => 7373,
                         "functioning"             => 4677,
                         "functions"               => 1388,
                         "functor"                 => 15099,
                         "functors"                => 24473,
                         "fund"                    => 1313,
                         "fundacion"               => 17583,
                         "fundamental"             => 2717,
                         "fundamentalism"          => 18045,
                         "fundamentalist"          => 12005,
                         "fundamentalists"         => 21479,
                         "fundamentally"           => 8468,
                         "funded"                  => 2169,
                         "funders"                 => 24423,
                         "funding"                 => 1294,
                         "fundraisers"             => 16439,
                         "fundraising"             => 5366,
                         "funds"                   => 1456,
                         "fundy"                   => 20634,
                         "funen"                   => 23757,
                         "funerary"                => 11947,
                         "fungal"                  => 9196,
                         "fungi"                   => 5226,
                         "fungicides"              => 29534,
                         "funicular"               => 15615,
                         "funimation"              => 16637,
                         "funkadelic"              => 24233,
                         "funnel"                  => 8919,
                         "funnels"                 => 17201,
                         "furlongs"                => 10012,
                         "furnaces"                => 10451,
                         "furnished"               => 7931,
                         "furnishing"              => 16959,
                         "furnishings"             => 9039,
                         "furrows"                 => 24741,
                         "furstenberg"             => 19684,
                         "furth"                   => 17069,
                         "further"                 => 326,
                         "furtherance"             => 26554,
                         "furthered"               => 13403,
                         "furthering"              => 13374,
                         "furthermore"             => 2388,
                         "fuscous"                 => 8178,
                         "fused"                   => 7534,
                         "fuselage"                => 4876,
                         "fushimi"                 => 27705,
                         "fusiliers"               => 11541,
                         "fusing"                  => 15618,
                         "futebol"                 => 11919,
                         "futsal"                  => 7782,
                         "futuna"                  => 25033,
                         "futurism"                => 20917,
                         "futurist"                => 16643,
                         "futuristic"              => 9764,
                         "futurity"                => 27226,
                         "fuzhou"                  => 15920,
                         "fylde"                   => 22095,
                         "fyodor"                  => 13376,
                         "g/cm3"                   => 28216,
                         "g/mol"                   => 27891,
                         "gabaa"                   => 27606,
                         "gabala"                  => 24479,
                         "gabba"                   => 25893,
                         "gabled"                  => 10652,
                         "gables"                  => 9572,
                         "gabon"                   => 8204,
                         "gabonese"                => 23692,
                         "gaborone"                => 24029,
                         "gabrovo"                 => 26035,
                         "gaddafi"                 => 8549,
                         "gaelic"                  => 3803,
                         "gaels"                   => 15946,
                         "gaeltacht"               => 22536,
                         "gaiden"                  => 24685,
                         "gaiety"                  => 17626,
                         "gaiman"                  => 16267,
                         "gain"                    => 1639,
                         "gained"                  => 1065,
                         "gainesville"             => 9499,
                         "gaining"                 => 3049,
                         "gains"                   => 4314,
                         "gainsborough"            => 12604,
                         "gainsbourg"              => 22952,
                         "gaius"                   => 9753,
                         "gakkai"                  => 28994,
                         "gakuen"                  => 23552,
                         "gakuin"                  => 27274,
                         "galactose"               => 23687,
                         "galapagos"               => 12342,
                         "galatians"               => 28714,
                         "galaxies"                => 7643,
                         "galba"                   => 28510,
                         "galeazzo"                => 24842,
                         "galeria"                 => 19101,
                         "galerie"                 => 10920,
                         "galesburg"               => 26795,
                         "galician"                => 8959,
                         "galilean"                => 24214,
                         "galilee"                 => 10306,
                         "galilei"                 => 23116,
                         "galium"                  => 29564,
                         "gallantry"               => 7935,
                         "gallaudet"               => 24678,
                         "gallen"                  => 12050,
                         "galleon"                 => 19463,
                         "galleons"                => 26445,
                         "galleria"                => 13186,
                         "galleries"               => 4227,
                         "gallery"                 => 1354,
                         "galleys"                 => 13424,
                         "gallia"                  => 20535,
                         "galliano"                => 29941,
                         "gallic"                  => 13712,
                         "gallifrey"               => 25905,
                         "gallipoli"               => 10062,
                         "gallium"                 => 16942,
                         "galois"                  => 15918,
                         "galton"                  => 19782,
                         "galvanic"                => 28256,
                         "galvatron"               => 20655,
                         "galveston"               => 8478,
                         "galway"                  => 5052,
                         "gamal"                   => 17869,
                         "gambia"                  => 9752,
                         "gambian"                 => 23011,
                         "gambier"                 => 16366,
                         "gambrinus"               => 27246,
                         "game"                    => 121,
                         "gamelan"                 => 18161,
                         "gameplay"                => 3305,
                         "gamepro"                 => 19385,
                         "gamerankings"            => 15284,
                         "games"                   => 195,
                         "gamespot"                => 11733,
                         "gamespy"                 => 22724,
                         "gamesradar"              => 19634,
                         "gametes"                 => 20860,
                         "gaming"                  => 3774,
                         "gamla"                   => 27758,
                         "ganassi"                 => 24945,
                         "ganda"                   => 28469,
                         "gandaki"                 => 29142,
                         "gandhara"                => 21769,
                         "gandharva"               => 29789,
                         "gandhi"                  => 4387,
                         "gandhian"                => 24909,
                         "gandhinagar"             => 29895,
                         "ganesan"                 => 17211,
                         "ganga"                   => 10180,
                         "ganges"                  => 10071,
                         "ganglia"                 => 15972,
                         "ganglion"                => 16417,
                         "gangnam"                 => 24209,
                         "ganguly"                 => 17516,
                         "gangwon"                 => 23408,
                         "gannet"                  => 28581,
                         "gannets"                 => 29277,
                         "gannett"                 => 15862,
                         "gansu"                   => 11849,
                         "gantry"                  => 22223,
                         "gaozong"                 => 17734,
                         "gaozu"                   => 19991,
                         "garages"                 => 13765,
                         "garda"                   => 11671,
                         "gardai"                  => 24495,
                         "garde"                   => 5488,
                         "gardens"                 => 1904,
                         "garhwal"                 => 19956,
                         "garibaldi"               => 10442,
                         "garifuna"                => 29987,
                         "garlands"                => 22718,
                         "garment"                 => 7989,
                         "garments"                => 8974,
                         "garmisch"                => 21229,
                         "garnered"                => 4548,
                         "garnering"               => 10845,
                         "garonne"                 => 12397,
                         "garrisoned"              => 12786,
                         "garrisons"               => 10711,
                         "garros"                  => 21577,
                         "garwolin"                => 27315,
                         "gascony"                 => 19388,
                         "gascoyne"                => 22091,
                         "gaseous"                 => 12827,
                         "gases"                   => 5545,
                         "gasification"            => 24249,
                         "gaspe"                   => 23874,
                         "gastric"                 => 12140,
                         "gastroenterology"        => 25814,
                         "gastrointestinal"        => 9985,
                         "gastronomy"              => 20679,
                         "gastropod"               => 3407,
                         "gastropoda"              => 28601,
                         "gastropods"              => 15906,
                         "gasworks"                => 27114,
                         "gated"                   => 11159,
                         "gatefold"                => 24397,
                         "gateshead"               => 10080,
                         "gathered"                => 2979,
                         "gatherer"                => 18698,
                         "gatherers"               => 15441,
                         "gathering"               => 3301,
                         "gatherings"              => 7509,
                         "gatineau"                => 15913,
                         "gating"                  => 28342,
                         "gatos"                   => 22907,
                         "gatwick"                 => 13838,
                         "gauche"                  => 25261,
                         "gauchos"                 => 29663,
                         "gaudens"                 => 25688,
                         "gaudi"                   => 21798,
                         "gauge"                   => 2664,
                         "gauges"                  => 12764,
                         "gauguin"                 => 17104,
                         "gauleiter"               => 28867,
                         "gauliga"                 => 24852,
                         "gaulish"                 => 19623,
                         "gaulle"                  => 9443,
                         "gauls"                   => 16259,
                         "gaultier"                => 25640,
                         "gaumont"                 => 23217,
                         "gauri"                   => 20237,
                         "gauss"                   => 12567,
                         "gaussian"                => 10761,
                         "gautama"                 => 16748,
                         "gauteng"                 => 13853,
                         "gautham"                 => 28129,
                         "gawain"                  => 18617,
                         "gawler"                  => 20438,
                         "gayatri"                 => 21207,
                         "gaza"                    => 4793,
                         "gazette"                 => 5123,
                         "gazetted"                => 11380,
                         "gazetteer"               => 15883,
                         "gazprom"                 => 17659,
                         "gbagbo"                  => 28910,
                         "gbit/s"                  => 19380,
                         "gcses"                   => 18538,
                         "gdansk"                  => 7354,
                         "gdanski"                 => 22987,
                         "gdynia"                  => 17963,
                         "ge'ez"                   => 29362,
                         "gearbox"                 => 7728,
                         "gearboxes"               => 23952,
                         "geared"                  => 8025,
                         "gears"                   => 8235,
                         "gediminas"               => 28622,
                         "geelong"                 => 6665,
                         "geert"                   => 25895,
                         "geeta"                   => 20039,
                         "geffen"                  => 12383,
                         "gehry"                   => 23360,
                         "gelatinous"              => 23253,
                         "gelder"                  => 27125,
                         "gelderland"              => 19075,
                         "gelding"                 => 19005,
                         "geldof"                  => 21891,
                         "gelechiidae"             => 9679,
                         "gelsenkirchen"           => 26617,
                         "gemara"                  => 19763,
                         "gemayel"                 => 28166,
                         "gemstones"               => 19740,
                         "gen."                    => 4545,
                         "gendarmerie"             => 11688,
                         "gendarmes"               => 21215,
                         "gender"                  => 2011,
                         "gendered"                => 20234,
                         "genders"                 => 12390,
                         "genealogical"            => 8303,
                         "genealogies"             => 16981,
                         "genealogist"             => 25924,
                         "genealogists"            => 29481,
                         "genealogy"               => 8709,
                         "geneon"                  => 28554,
                         "genera"                  => 3791,
                         "general"                 => 136,
                         "generale"                => 12979,
                         "generalised"             => 21764,
                         "generalissimo"           => 28774,
                         "generalist"              => 26818,
                         "generalitat"             => 24845,
                         "generality"              => 20557,
                         "generalization"          => 9816,
                         "generalizations"         => 14487,
                         "generalize"              => 20436,
                         "generalized"             => 6433,
                         "generalizes"             => 22929,
                         "generalleutnant"         => 24906,
                         "generally"               => 574,
                         "generalmajor"            => 25566,
                         "generals"                => 4127,
                         "generate"                => 3400,
                         "generated"               => 2295,
                         "generates"               => 6656,
                         "generating"              => 4040,
                         "generation"              => 1127,
                         "generational"            => 15700,
                         "generations"             => 3037,
                         "generative"              => 16392,
                         "generators"              => 6073,
                         "generically"             => 19599,
                         "generis"                 => 29702,
                         "genes"                   => 3493,
                         "genesee"                 => 11911,
                         "genetic"                 => 2646,
                         "geneticist"              => 17568,
                         "genetics"                => 5364,
                         "genital"                 => 10867,
                         "genitalia"               => 14090,
                         "genitive"                => 12792,
                         "genji"                   => 20605,
                         "gennady"                 => 21424,
                         "genocidal"               => 21862,
                         "genocide"                => 5068,
                         "genoese"                 => 11907,
                         "genome"                  => 4959,
                         "genomes"                 => 11336,
                         "genomic"                 => 11574,
                         "genomics"                => 13079,
                         "genotype"                => 16515,
                         "genotypes"               => 24942,
                         "genre"                   => 2163,
                         "genres"                  => 3819,
                         "genteel"                 => 28147,
                         "gentiles"                => 19689,
                         "gentrification"          => 16713,
                         "genus"                   => 764,
                         "geochemistry"            => 25212,
                         "geodesic"                => 16582,
                         "geodesics"               => 29096,
                         "geodesy"                 => 26565,
                         "geodetic"                => 16041,
                         "geoff"                   => 6139,
                         "geoffroy"                => 23589,
                         "geographer"              => 11092,
                         "geographers"             => 16823,
                         "geographic"              => 3152,
                         "geographical"            => 3375,
                         "geographically"          => 6781,
                         "geography"               => 1077,
                         "geologic"                => 6770,
                         "geological"              => 3709,
                         "geologically"            => 14901,
                         "geologist"               => 7827,
                         "geologists"              => 11639,
                         "geology"                 => 4005,
                         "geomagnetic"             => 23495,
                         "geometric"               => 5363,
                         "geometrical"             => 11910,
                         "geometrically"           => 20180,
                         "geometridae"             => 7576,
                         "geometries"              => 16414,
                         "geometry"                => 3850,
                         "geomorphology"           => 26644,
                         "geophysical"             => 11600,
                         "geophysics"              => 16174,
                         "geopolitical"            => 15675,
                         "geopolitics"             => 26527,
                         "georges"                 => 4386,
                         "georgetown"              => 4743,
                         "georgian"                => 3286,
                         "georgians"               => 13422,
                         "georgiev"                => 27711,
                         "georgios"                => 13314,
                         "geosciences"             => 29287,
                         "geospatial"              => 19470,
                         "geostationary"           => 19749,
                         "geotechnical"            => 25387,
                         "geothermal"              => 10274,
                         "geraint"                 => 22235,
                         "gerais"                  => 9664,
                         "geraldton"               => 18415,
                         "german"                  => 242,
                         "germaniawerft"           => 24083,
                         "germanic"                => 4969,
                         "germanicus"              => 26227,
                         "germanium"               => 19554,
                         "germans"                 => 2301,
                         "germantown"              => 12824,
                         "germanus"                => 28528,
                         "germany"                 => 395,
                         "germinal"                => 24026,
                         "germinate"               => 18398,
                         "germination"             => 15234,
                         "gerontology"             => 27094,
                         "geschichte"              => 17830,
                         "gesellschaft"            => 10676,
                         "gesta"                   => 18384,
                         "gestalt"                 => 17802,
                         "gestation"               => 11943,
                         "gestational"             => 24831,
                         "getafe"                  => 20829,
                         "gettysburg"              => 7675,
                         "gewog"                   => 20443,
                         "geysers"                 => 28310,
                         "ghalib"                  => 24022,
                         "ghana"                   => 3536,
                         "ghanaian"                => 9622,
                         "ghani"                   => 20257,
                         "gharana"                 => 18522,
                         "gharb"                   => 24827,
                         "gharbi"                  => 12285,
                         "ghats"                   => 11761,
                         "ghazal"                  => 16676,
                         "ghazali"                 => 24799,
                         "ghazals"                 => 29724,
                         "ghazi"                   => 13784,
                         "ghaziabad"               => 25410,
                         "ghazni"                  => 18638,
                         "ghent"                   => 8613,
                         "gheorghe"                => 12424,
                         "gheorghiu"               => 23592,
                         "gholam"                  => 28160,
                         "ghosh"                   => 11317,
                         "ghostface"               => 23058,
                         "ghraib"                  => 25322,
                         "ghulam"                  => 10231,
                         "giambattista"            => 27309,
                         "gianfranco"              => 21722,
                         "giannis"                 => 24834,
                         "gibraltar"               => 4290,
                         "gielgud"                 => 18383,
                         "giessen"                 => 16500,
                         "giffard"                 => 19532,
                         "gigabit"                 => 20248,
                         "gigantea"                => 27271,
                         "gigas"                   => 26139,
                         "giggs"                   => 22913,
                         "gijon"                   => 16628,
                         "gilad"                   => 26109,
                         "gilan"                   => 9851,
                         "gilani"                  => 26353,
                         "gilded"                  => 10154,
                         "gilding"                 => 27212,
                         "gilgit"                  => 16874,
                         "gimel"                   => 25752,
                         "gimnasia"                => 22601,
                         "ginebra"                 => 19083,
                         "ginzburg"                => 24162,
                         "giorgos"                 => 18321,
                         "gippsland"               => 13011,
                         "gipsy"                   => 19095,
                         "gipuzkoa"                => 22759,
                         "girardeau"               => 22323,
                         "girder"                  => 14556,
                         "girders"                 => 17193,
                         "girolamo"                => 14164,
                         "girona"                  => 14462,
                         "gironde"                 => 16621,
                         "gisborne"                => 16560,
                         "giscard"                 => 29972,
                         "github"                  => 29093,
                         "given"                   => 259,
                         "givenchy"                => 25278,
                         "glaad"                   => 22114,
                         "glabra"                  => 26890,
                         "glabrous"                => 19697,
                         "glace"                   => 27750,
                         "glacial"                 => 6236,
                         "glaciated"               => 25620,
                         "glaciation"              => 13265,
                         "glacier"                 => 3062,
                         "glaciers"                => 6999,
                         "gladiators"              => 10768,
                         "glamorgan"               => 7599,
                         "gland"                   => 8573,
                         "glandular"               => 15351,
                         "glans"                   => 29429,
                         "glarus"                  => 21490,
                         "glasgow"                 => 2300,
                         "glassworks"              => 29127,
                         "glastonbury"             => 10075,
                         "glauca"                  => 29497,
                         "glaxosmithkline"         => 24554,
                         "glazes"                  => 24973,
                         "glazing"                 => 16189,
                         "gleaned"                 => 20782,
                         "glebe"                   => 14458,
                         "gleizes"                 => 21342,
                         "glenbrook"               => 29646,
                         "glencairn"               => 26081,
                         "glenelg"                 => 16434,
                         "glenorchy"               => 29240,
                         "glens"                   => 17127,
                         "glentoran"               => 22324,
                         "glenview"                => 29717,
                         "glial"                   => 22026,
                         "glide"                   => 11310,
                         "gliders"                 => 10063,
                         "gliding"                 => 9520,
                         "gliese"                  => 22843,
                         "gliwice"                 => 28745,
                         "global"                  => 936,
                         "globalisation"           => 19873,
                         "globalization"           => 8391,
                         "globally"                => 5918,
                         "globe"                   => 2722,
                         "globemaster"             => 29774,
                         "globo"                   => 13489,
                         "globose"                 => 26531,
                         "globular"                => 14393,
                         "glockenspiel"            => 29036,
                         "glogow"                  => 24468,
                         "glories"                 => 24018,
                         "glorification"           => 24542,
                         "glorify"                 => 24750,
                         "glorifying"              => 27701,
                         "glossary"                => 13455,
                         "glosses"                 => 25199,
                         "glossop"                 => 19127,
                         "glossy"                  => 9738,
                         "glottal"                 => 19153,
                         "gloucester"              => 4823,
                         "gloucestershire"         => 5466,
                         "glucose"                 => 6457,
                         "glutamate"               => 12102,
                         "glutamine"               => 26428,
                         "glutathione"             => 20570,
                         "gluten"                  => 16229,
                         "glutinous"               => 28404,
                         "glycerol"                => 19238,
                         "glycine"                 => 16864,
                         "glycogen"                => 18475,
                         "glycol"                  => 16540,
                         "glycolysis"              => 24371,
                         "glycoprotein"            => 18117,
                         "glycoproteins"           => 26965,
                         "glycoside"               => 23403,
                         "glycosylation"           => 29335,
                         "glyndebourne"            => 21616,
                         "glyndwr"                 => 22553,
                         "glyph"                   => 17753,
                         "glyphipterix"            => 22435,
                         "glyphosate"              => 29949,
                         "glyphs"                  => 16778,
                         "gmail"                   => 22058,
                         "gmina"                   => 1745,
                         "gminas"                  => 9670,
                         "gnaeus"                  => 22193,
                         "gneisenau"               => 29905,
                         "gneiss"                  => 20365,
                         "gniezno"                 => 17007,
                         "gnostic"                 => 15504,
                         "gnosticism"              => 23098,
                         "gnu/linux"               => 28626,
                         "goal"                    => 605,
                         "goalkeeper"              => 3417,
                         "goalkeepers"             => 15144,
                         "goalkeeping"             => 15107,
                         "goalless"                => 13698,
                         "goals"                   => 728,
                         "goalscorer"              => 9611,
                         "goalscorers"             => 14397,
                         "goalscoring"             => 16885,
                         "goaltender"              => 7504,
                         "goaltenders"             => 13868,
                         "goaltending"             => 20948,
                         "gobind"                  => 17783,
                         "godalming"               => 27040,
                         "godavari"                => 12720,
                         "goddesses"               => 10928,
                         "godel"                   => 16200,
                         "godolphin"               => 18856,
                         "godot"                   => 28446,
                         "godunov"                 => 25114,
                         "gogol"                   => 17040,
                         "goguryeo"                => 12769,
                         "goiania"                 => 24658,
                         "goias"                   => 14033,
                         "golan"                   => 12718,
                         "golconda"                => 29358,
                         "gold"                    => 487,
                         "golders"                 => 25763,
                         "goldfield"               => 28388,
                         "goldfields"              => 13096,
                         "goldfrapp"               => 28815,
                         "golds"                   => 12544,
                         "goldsmiths"              => 15195,
                         "goldust"                 => 28495,
                         "goldwater"               => 12671,
                         "goldwyn"                 => 10751,
                         "golem"                   => 18594,
                         "golestan"                => 14922,
                         "golgi"                   => 19808,
                         "gollancz"                => 27071,
                         "gonbad"                  => 26673,
                         "goncalo"                 => 27598,
                         "gondwana"                => 16988,
                         "gongs"                   => 26640,
                         "gongsun"                 => 29437,
                         "gonville"                => 26351,
                         "gonzaga"                 => 9600,
                         "goodrem"                 => 26641,
                         "goods"                   => 1710,
                         "goole"                   => 22011,
                         "gopal"                   => 11979,
                         "gopala"                  => 28537,
                         "gopalakrishnan"          => 28083,
                         "gorakhpur"               => 23108,
                         "goran"                   => 10349,
                         "gorbachev"               => 11121,
                         "gorda"                   => 20105,
                         "gorge"                   => 5695,
                         "gorges"                  => 11439,
                         "gorica"                  => 18357,
                         "goring"                  => 10014,
                         "gorizia"                 => 17994,
                         "gorkha"                  => 18678,
                         "gorlitz"                 => 24549,
                         "gorna"                   => 24097,
                         "gorne"                   => 29412,
                         "gornik"                  => 27121,
                         "gornja"                  => 22192,
                         "gornji"                  => 16816,
                         "gorse"                   => 25267,
                         "goryeo"                  => 14189,
                         "gorzow"                  => 20745,
                         "gosford"                 => 19518,
                         "gosforth"                => 25597,
                         "goslar"                  => 27709,
                         "gospel"                  => 2777,
                         "gospels"                 => 7833,
                         "gosport"                 => 18660,
                         "gosta"                   => 25030,
                         "goswami"                 => 19838,
                         "gotaland"                => 16920,
                         "goteborg"                => 13500,
                         "gotha"                   => 11685,
                         "gothenburg"              => 8074,
                         "goths"                   => 12855,
                         "gotland"                 => 15311,
                         "gotra"                   => 20002,
                         "gotthard"                => 18939,
                         "gottingen"               => 8687,
                         "gottlob"                 => 23672,
                         "gottorp"                 => 27111,
                         "gouda"                   => 25611,
                         "goulburn"                => 14156,
                         "gounod"                  => 21517,
                         "gouverneur"              => 29574,
                         "govern"                  => 7352,
                         "governance"              => 3340,
                         "governed"                => 3365,
                         "governing"               => 2885,
                         "government"              => 122,
                         "governmental"            => 3570,
                         "governments"             => 2184,
                         "governor"                => 553,
                         "governorate"             => 5290,
                         "governorates"            => 17230,
                         "governors"               => 3541,
                         "governorship"            => 8866,
                         "governs"                 => 11697,
                         "govind"                  => 19735,
                         "gowda"                   => 23629,
                         "gowrie"                  => 27185,
                         "graaf"                   => 23805,
                         "graaff"                  => 27515,
                         "graced"                  => 15985,
                         "gracilis"                => 17284,
                         "gracillariidae"          => 15387,
                         "gradation"               => 28067,
                         "grade"                   => 979,
                         "graded"                  => 7532,
                         "grades"                  => 2404,
                         "gradient"                => 6295,
                         "gradients"               => 12534,
                         "gradual"                 => 5915,
                         "gradually"               => 2154,
                         "graduate"                => 1263,
                         "graduated"               => 919,
                         "graduates"               => 3551,
                         "graduating"              => 2250,
                         "graduation"              => 2596,
                         "graeme"                  => 8153,
                         "graffiti"                => 6824,
                         "grafting"                => 19497,
                         "grahame"                 => 18014,
                         "grahamstown"             => 21614,
                         "grain"                   => 3349,
                         "grained"                 => 12842,
                         "grains"                  => 6624,
                         "grama"                   => 23115,
                         "grameen"                 => 27360,
                         "gramercy"                => 27041,
                         "grammar"                 => 2611,
                         "grammarian"              => 21886,
                         "grammarians"             => 28470,
                         "grammars"                => 14297,
                         "grammatical"             => 7896,
                         "grammatically"           => 22325,
                         "grammophon"              => 28413,
                         "grammy"                  => 3058,
                         "grammys"                 => 21062,
                         "gramophone"              => 12787,
                         "grampian"                => 23247,
                         "granaries"               => 29416,
                         "granary"                 => 16880,
                         "granby"                  => 16839,
                         "grand"                   => 508,
                         "grande"                  => 3345,
                         "grandes"                 => 15042,
                         "grandfathered"           => 24305,
                         "grandis"                 => 20805,
                         "grandmaster"             => 9304,
                         "grandmasters"            => 28086,
                         "grandnephew"             => 26867,
                         "grands"                  => 13443,
                         "grandsons"               => 12486,
                         "grandstand"              => 10983,
                         "grandstands"             => 24904,
                         "grandview"               => 20757,
                         "grange"                  => 6373,
                         "granite"                 => 3893,
                         "granites"                => 27253,
                         "granitic"                => 23472,
                         "granted"                 => 1204,
                         "grantee"                 => 24714,
                         "granth"                  => 19354,
                         "granting"                => 5413,
                         "grants"                  => 2921,
                         "granular"                => 14664,
                         "granule"                 => 28939,
                         "granules"                => 15851,
                         "graph"                   => 3625,
                         "graphene"                => 17693,
                         "graphic"                 => 3105,
                         "graphical"               => 6878,
                         "graphically"             => 15613,
                         "graphics"                => 2966,
                         "graphite"                => 10765,
                         "graphs"                  => 6871,
                         "grappling"               => 14193,
                         "grass"                   => 2787,
                         "grasse"                  => 20346,
                         "grassed"                 => 29125,
                         "grasses"                 => 8116,
                         "grassland"               => 6864,
                         "grasslands"              => 8663,
                         "grassroots"              => 7704,
                         "graubunden"              => 18143,
                         "gravel"                  => 5396,
                         "gravelly"                => 20374,
                         "gravels"                 => 28451,
                         "gravesend"               => 14524,
                         "gravestone"              => 16507,
                         "gravestones"             => 19813,
                         "gravitated"              => 27787,
                         "gravitation"             => 17123,
                         "gravitational"           => 7035,
                         "gravity"                 => 3678,
                         "grayish"                 => 15525,
                         "grayling"                => 20080,
                         "graze"                   => 17152,
                         "grazer"                  => 29123,
                         "grazing"                 => 6263,
                         "greater"                 => 811,
                         "greatest"                => 1350,
                         "greatly"                 => 2114,
                         "grebes"                  => 23147,
                         "grecian"                 => 25733,
                         "greece"                  => 1681,
                         "greek"                   => 698,
                         "greeks"                  => 4685,
                         "greenback"               => 26567,
                         "greenbelt"               => 18226,
                         "greenbrier"              => 17347,
                         "greendale"               => 27083,
                         "greenhouse"              => 6275,
                         "greenhouses"             => 15929,
                         "greenish"                => 9375,
                         "greenland"               => 5799,
                         "greenlandic"             => 22619,
                         "greenock"                => 11966,
                         "greenpeace"              => 12000,
                         "greensand"               => 27560,
                         "greensboro"              => 9465,
                         "greensburg"              => 18573,
                         "greenstone"              => 21184,
                         "greenville"              => 7122,
                         "greenwich"               => 5212,
                         "greeted"                 => 7555,
                         "gregarious"              => 16627,
                         "gregorian"               => 8324,
                         "greifswald"              => 17879,
                         "grenada"                 => 9586,
                         "grenades"                => 8312,
                         "grenadier"               => 11017,
                         "grenadiers"              => 15741,
                         "grenadines"              => 16075,
                         "grenfell"                => 15541,
                         "grenoble"                => 10883,
                         "grenville"               => 12387,
                         "gresley"                 => 24598,
                         "grete"                   => 28513,
                         "gretna"                  => 17530,
                         "greville"                => 17857,
                         "grevillea"               => 19130,
                         "grew"                    => 990,
                         "grey"                    => 1711,
                         "greyfriars"              => 22898,
                         "greyhawk"                => 14375,
                         "greyhound"               => 8598,
                         "greyhounds"              => 18251,
                         "greyish"                 => 9146,
                         "greys"                   => 17003,
                         "grid"                    => 3158,
                         "gridiron"                => 13903,
                         "grids"                   => 13317,
                         "grieg"                   => 18040,
                         "grierson"                => 18731,
                         "grievances"              => 10844,
                         "grigor"                  => 26774,
                         "grigore"                 => 25032,
                         "grigori"                 => 25214,
                         "grigory"                 => 17695,
                         "grille"                  => 9015,
                         "grilles"                 => 26084,
                         "grimsby"                 => 8011,
                         "grindcore"               => 24738,
                         "gripped"                 => 23177,
                         "gristmill"               => 19233,
                         "grizzlies"               => 10950,
                         "grocers"                 => 20594,
                         "grodno"                  => 19292,
                         "grodzisk"                => 23621,
                         "groening"                => 19671,
                         "grohl"                   => 17805,
                         "grojec"                  => 23089,
                         "groningen"               => 9689,
                         "groot"                   => 17396,
                         "grooved"                 => 19504,
                         "grooves"                 => 9498,
                         "gropius"                 => 24525,
                         "grosjean"                => 23349,
                         "grossed"                 => 6835,
                         "grosser"                 => 14192,
                         "grosseto"                => 21954,
                         "grossing"                => 6519,
                         "grothendieck"            => 23546,
                         "groton"                  => 14881,
                         "ground"                  => 499,
                         "groundbreaking"          => 7837,
                         "groundnut"               => 28244,
                         "grounds"                 => 1666,
                         "groundwater"             => 7853,
                         "group"                   => 109,
                         "groupe"                  => 13347,
                         "grouped"                 => 5174,
                         "grouping"                => 6760,
                         "groupings"               => 10348,
                         "groups"                  => 459,
                         "grower"                  => 19958,
                         "growers"                 => 9191,
                         "growing"                 => 1048,
                         "grows"                   => 2786,
                         "growth"                  => 909,
                         "growths"                 => 24310,
                         "groza"                   => 26666,
                         "grozny"                  => 17931,
                         "grudgingly"              => 27243,
                         "gruffudd"                => 20543,
                         "gruffydd"                => 20692,
                         "gruiformesfamily"        => 27771,
                         "grumman"                 => 10870,
                         "grupo"                   => 9890,
                         "gruppe"                  => 17361,
                         "gruppo"                  => 23210,
                         "grzegorz"                => 23474,
                         "guadalajara"             => 7917,
                         "guadalcanal"             => 9237,
                         "guadeloupe"              => 10964,
                         "guam"                    => 5554,
                         "guanajuato"              => 15330,
                         "guangdong"               => 7419,
                         "guangxi"                 => 11608,
                         "guangzhou"               => 6711,
                         "guanine"                 => 22417,
                         "guano"                   => 17577,
                         "guantanamo"              => 7242,
                         "guarani"                 => 13805,
                         "guarantor"               => 28636,
                         "guaranty"                => 24706,
                         "guarda"                  => 27937,
                         "guardia"                 => 14359,
                         "guardians"               => 7066,
                         "guardsman"               => 27434,
                         "guardsmen"               => 15796,
                         "guatemala"               => 4331,
                         "guatemalan"              => 9702,
                         "guayaquil"               => 15106,
                         "gubernatorial"           => 5604,
                         "guelders"                => 26251,
                         "guelph"                  => 10433,
                         "guerilla"                => 13481,
                         "guernica"                => 29272,
                         "guerre"                  => 10408,
                         "guerrilla"               => 5375,
                         "guerrillas"              => 8611,
                         "guested"                 => 19056,
                         "guetta"                  => 17845,
                         "guggenheim"              => 7702,
                         "guiana"                  => 8737,
                         "guidance"                => 3168,
                         "guide"                   => 1805,
                         "guidebooks"              => 26118,
                         "guided"                  => 3510,
                         "guideline"               => 14832,
                         "guidelines"              => 4073,
                         "guides"                  => 4727,
                         "guiding"                 => 6293,
                         "guild"                   => 3440,
                         "guilders"                => 18556,
                         "guildford"               => 8379,
                         "guildhall"               => 12303,
                         "guilds"                  => 10717,
                         "guillaume"               => 8005,
                         "guimaraes"               => 16073,
                         "guinea"                  => 2457,
                         "guinean"                 => 14759,
                         "guineas"                 => 8105,
                         "guise"                   => 7975,
                         "guises"                  => 26988,
                         "guitarist"               => 1915,
                         "guitarists"              => 8701,
                         "guizhou"                 => 13777,
                         "gujarat"                 => 5232,
                         "gujarati"                => 10092,
                         "gujranwala"              => 24655,
                         "gujrat"                  => 21393,
                         "gulab"                   => 28276,
                         "gulbarga"                => 28336,
                         "gulch"                   => 13766,
                         "gulden"                  => 21533,
                         "gules"                   => 9345,
                         "gulf"                    => 1860,
                         "gulfport"                => 22686,
                         "gulfstream"              => 18620,
                         "gullies"                 => 19852,
                         "gulshan"                 => 26228,
                         "gulzar"                  => 25768,
                         "gunboat"                 => 10133,
                         "gunboats"                => 11145,
                         "gunfight"                => 14602,
                         "gunma"                   => 18542,
                         "gunmen"                  => 9973,
                         "gunnery"                 => 9082,
                         "gunpowder"               => 7939,
                         "guns"                    => 1470,
                         "gunships"                => 26027,
                         "guntur"                  => 15372,
                         "gunung"                  => 23343,
                         "gurdjieff"               => 23143,
                         "gurdwara"                => 16410,
                         "gurgaon"                 => 17176,
                         "gurion"                  => 13337,
                         "gurkha"                  => 15870,
                         "gurkhas"                 => 25147,
                         "gurps"                   => 20799,
                         "guru"                    => 4342,
                         "gurudwara"               => 23922,
                         "gurung"                  => 27506,
                         "gurus"                   => 15595,
                         "gustaf"                  => 11179,
                         "gustafsson"              => 21910,
                         "gustave"                 => 10221,
                         "gustavus"                => 13574,
                         "gusts"                   => 12755,
                         "gusty"                   => 27984,
                         "gutenberg"               => 16191,
                         "guttenberg"              => 25157,
                         "guwahati"                => 13234,
                         "guyana"                  => 6739,
                         "guyanese"                => 17706,
                         "guyed"                   => 27090,
                         "gwalior"                 => 13407,
                         "gwangju"                 => 17331,
                         "gwent"                   => 16655,
                         "gwinnett"                => 17808,
                         "gwynedd"                 => 10183,
                         "gwynne"                  => 19807,
                         "gyatso"                  => 21890,
                         "gyeonggi"                => 20600,
                         "gyeongju"                => 25140,
                         "gyeongsang"              => 27377,
                         "gygax"                   => 17771,
                         "gyllenhaal"              => 26611,
                         "gymkhana"                => 24698,
                         "gymnasium"               => 4074,
                         "gymnasiums"              => 20212,
                         "gymnastics"              => 4777,
                         "gymnasts"                => 14600,
                         "gymnopilus"              => 22484,
                         "gympie"                  => 21200,
                         "gynaecology"             => 24141,
                         "gynecology"              => 18635,
                         "gyorgy"                  => 13944,
                         "gypsum"                  => 12894,
                         "gyrus"                   => 18888,
                         "gyula"                   => 16721,
                         "h.m.s"                   => 24061,
                         "haakon"                  => 13975,
                         "haaretz"                 => 20147,
                         "haarlem"                 => 9960,
                         "haasan"                  => 17608,
                         "habeas"                  => 11339,
                         "habermas"                => 21112,
                         "habilitation"            => 15066,
                         "habitable"               => 13176,
                         "habitat"                 => 1648,
                         "habitation"              => 10246,
                         "habitats"                => 3497,
                         "habitually"              => 20182,
                         "habsburg"                => 5908,
                         "habsburgs"               => 13349,
                         "hachette"                => 26589,
                         "hacienda"                => 11309,
                         "haciendas"               => 27334,
                         "hackensack"              => 15767,
                         "had"                     => 25,
                         "hadamard"                => 26805,
                         "hadassah"                => 22862,
                         "haddington"              => 22611,
                         "hadid"                   => 29615,
                         "hadith"                  => 9239,
                         "hadiths"                 => 29200,
                         "hadron"                  => 25210,
                         "haeckel"                 => 28426,
                         "haemorrhage"             => 23683,
                         "hafez"                   => 19503,
                         "hafiz"                   => 15182,
                         "haganah"                 => 16370,
                         "hagerstown"              => 16379,
                         "hagia"                   => 22803,
                         "hagiography"             => 21942,
                         "haida"                   => 16845,
                         "haidar"                  => 28630,
                         "haifa"                   => 7443,
                         "hailed"                  => 6101,
                         "haileybury"              => 25494,
                         "hailing"                 => 12233,
                         "hails"                   => 11656,
                         "hainan"                  => 12113,
                         "hainaut"                 => 17790,
                         "hairdressing"            => 28588,
                         "hairpin"                 => 15633,
                         "haiti"                   => 4521,
                         "haitian"                 => 7407,
                         "haitians"                => 21441,
                         "haiyan"                  => 29904,
                         "hajji"                   => 12529,
                         "hajjiabad"               => 17967,
                         "hakka"                   => 14903,
                         "hakoah"                  => 29975,
                         "hakodate"                => 26828,
                         "hakon"                   => 19148,
                         "halakha"                 => 22266,
                         "halakhic"                => 25749,
                         "halal"                   => 19367,
                         "halberstadt"             => 21672,
                         "haldane"                 => 13844,
                         "halden"                  => 28524,
                         "haldimand"               => 27008,
                         "halen"                   => 12783,
                         "halesowen"               => 24491,
                         "halevi"                  => 29312,
                         "halevy"                  => 28225,
                         "half"                    => 345,
                         "halfback"                => 9151,
                         "halfdan"                 => 25570,
                         "halfpenny"               => 27717,
                         "halfpipe"                => 28292,
                         "halftime"                => 6917,
                         "halide"                  => 18819,
                         "halides"                 => 19499,
                         "halil"                   => 25318,
                         "halim"                   => 18940,
                         "halland"                 => 27417,
                         "hallmarks"               => 18182,
                         "halls"                   => 3908,
                         "hallstatt"               => 27257,
                         "hallucinogenic"          => 21758,
                         "halogaland"              => 29490,
                         "halt"                    => 4584,
                         "halted"                  => 5678,
                         "halting"                 => 13991,
                         "halts"                   => 18311,
                         "halved"                  => 17018,
                         "halves"                  => 8821,
                         "halych"                  => 26474,
                         "hamadan"                 => 13372,
                         "hamamatsu"               => 28167,
                         "hamas"                   => 7069,
                         "hamasaki"                => 17009,
                         "hambledon"               => 29586,
                         "hambro"                  => 29851,
                         "hamdi"                   => 28073,
                         "hameed"                  => 25324,
                         "hamid"                   => 8618,
                         "hamilcar"                => 29248,
                         "hamiltonian"             => 10973,
                         "hamlets"                 => 6874,
                         "hammam"                  => 24700,
                         "hammersmith"             => 9315,
                         "hammerstein"             => 12702,
                         "hammocks"                => 24527,
                         "hampden"                 => 10230,
                         "hampered"                => 7602,
                         "hampering"               => 28050,
                         "hampshire"               => 2201,
                         "hampstead"               => 9616,
                         "hamstring"               => 13133,
                         "hamza"                   => 15015,
                         "hanafi"                  => 21884,
                         "hanau"                   => 14542,
                         "hanbury"                 => 22513,
                         "handan"                  => 27978,
                         "handballer"              => 23766,
                         "handbook"                => 6659,
                         "handbooks"               => 23450,
                         "handcrafted"             => 26780,
                         "handcrafts"              => 29594,
                         "handedness"              => 26208,
                         "handel"                  => 7859,
                         "hander"                  => 16558,
                         "handheld"                => 9562,
                         "handicap"                => 5773,
                         "handicaps"               => 23291,
                         "handicraft"              => 18178,
                         "handicrafts"             => 14417,
                         "handlers"                => 14654,
                         "handover"                => 14779,
                         "handpicked"              => 27409,
                         "handset"                 => 17446,
                         "handsets"                => 21258,
                         "handsworth"              => 23823,
                         "handwritten"             => 12707,
                         "hangar"                  => 7839,
                         "hangars"                 => 11654,
                         "hanged"                  => 6638,
                         "hangings"                => 22476,
                         "hangul"                  => 12125,
                         "hangzhou"                => 11542,
                         "hanja"                   => 11295,
                         "hannity"                 => 22481,
                         "hanno"                   => 25164,
                         "hanns"                   => 21976,
                         "hanoi"                   => 8384,
                         "hanover"                 => 5159,
                         "hanoverian"              => 16337,
                         "hansa"                   => 14138,
                         "hanseatic"               => 14456,
                         "hanshin"                 => 21178,
                         "hanssen"                 => 25702,
                         "hansson"                 => 22162,
                         "hants"                   => 21727,
                         "hantuchova"              => 26065,
                         "hanyu"                   => 29405,
                         "hanzhong"                => 29488,
                         "haphazard"               => 23556,
                         "haplogroup"              => 10658,
                         "haplogroups"             => 23783,
                         "haploid"                 => 20824,
                         "haplotype"               => 22572,
                         "haplotypes"              => 28374,
                         "hapoel"                  => 8517,
                         "haram"                   => 15881,
                         "harappan"                => 27824,
                         "harare"                  => 13781,
                         "harbhajan"               => 24452,
                         "harbinger"               => 19325,
                         "harbor"                  => 2139,
                         "harbored"                => 22494,
                         "harborough"              => 25398,
                         "harbors"                 => 11554,
                         "harbour"                 => 2468,
                         "harbours"                => 12149,
                         "harburg"                 => 29046,
                         "harcourt"                => 9225,
                         "hardback"                => 17649,
                         "hardcover"               => 9685,
                         "hardening"               => 16310,
                         "hardiness"               => 19979,
                         "hardinge"                => 26763,
                         "hardness"                => 10859,
                         "hardships"               => 9940,
                         "hardtop"                 => 15980,
                         "hardware"                => 2694,
                         "hardwicke"               => 19294,
                         "hardwoods"               => 21105,
                         "haredi"                  => 16575,
                         "harel"                   => 27769,
                         "hares"                   => 16756,
                         "haridwar"                => 22409,
                         "haringey"                => 24230,
                         "hariri"                  => 18737,
                         "harith"                  => 28915,
                         "harlequin"               => 13326,
                         "harlequins"              => 17432,
                         "harlingen"               => 24892,
                         "harmful"                 => 6492,
                         "harmonia"                => 23508,
                         "harmonic"                => 6827,
                         "harmonica"               => 8630,
                         "harmonics"               => 14329,
                         "harmonies"               => 9440,
                         "harmonious"              => 12821,
                         "harmonium"               => 18846,
                         "harmonix"                => 25558,
                         "harmonization"           => 25332,
                         "harmonize"               => 23499,
                         "harmonized"              => 22049,
                         "harnesses"               => 21437,
                         "harnessing"              => 23335,
                         "harpalinae"              => 28257,
                         "harpalus"                => 19020,
                         "harpercollins"           => 15374,
                         "harpers"                 => 15839,
                         "harpist"                 => 21657,
                         "harpsichord"             => 11342,
                         "harpsichordist"          => 29023,
                         "harriers"                => 12174,
                         "harrisburg"              => 8065,
                         "harrisonburg"            => 26161,
                         "harrods"                 => 25143,
                         "harrogate"               => 12124,
                         "harrow"                  => 8284,
                         "harsher"                 => 16856,
                         "harshest"                => 26931,
                         "harshness"               => 24407,
                         "hartlepool"              => 10066,
                         "harun"                   => 18490,
                         "haruna"                  => 28701,
                         "harvard"                 => 1878,
                         "harvested"               => 7823,
                         "harvester"               => 15419,
                         "harvesters"              => 28393,
                         "harvesting"              => 7502,
                         "harvests"                => 15768,
                         "harwich"                 => 14247,
                         "haryana"                 => 8224,
                         "has"                     => 24,
                         "hasan"                   => 5996,
                         "hasanabad"               => 16537,
                         "hasbro"                  => 12726,
                         "hashanah"                => 29349,
                         "hashemi"                 => 27272,
                         "hashemite"               => 28494,
                         "hashim"                  => 15960,
                         "hashing"                 => 26220,
                         "hashtag"                 => 21421,
                         "hasidic"                 => 11252,
                         "hasidim"                 => 21702,
                         "hasidism"                => 27990,
                         "hasina"                  => 29128,
                         "haskovo"                 => 27558,
                         "hasselbeck"              => 29059,
                         "hasselt"                 => 28104,
                         "hastened"                => 16766,
                         "hastily"                 => 10083,
                         "hatchback"               => 12738,
                         "hatchery"                => 16216,
                         "hatchlings"              => 22140,
                         "hatshepsut"              => 28682,
                         "hatta"                   => 22404,
                         "hattiesburg"             => 24776,
                         "hatun"                   => 26311,
                         "haugesund"               => 22555,
                         "haulage"                 => 17990,
                         "hauptbahnhof"            => 13550,
                         "hauptmann"               => 16019,
                         "hausa"                   => 16163,
                         "hausdorff"               => 17761,
                         "haussmann"               => 28681,
                         "haute"                   => 5883,
                         "hautes"                  => 13068,
                         "hauts"                   => 24694,
                         "havant"                  => 23436,
                         "haveli"                  => 22499,
                         "havelock"                => 16732,
                         "haven"                   => 3475,
                         "haverford"               => 18790,
                         "haverfordwest"           => 29376,
                         "haverhill"               => 19008,
                         "havering"                => 25227,
                         "havilland"               => 8977,
                         "havre"                   => 9717,
                         "hawai'i"                 => 17838,
                         "hawai`i"                 => 27903,
                         "hawaiians"               => 17863,
                         "hawick"                  => 29550,
                         "hawke"                   => 8432,
                         "hawkesbury"              => 16633,
                         "hayat"                   => 17443,
                         "hayato"                  => 29353,
                         "haydn"                   => 8502,
                         "haydock"                 => 24586,
                         "haymarket"               => 12587,
                         "hazara"                  => 15964,
                         "hazardous"               => 6650,
                         "hazards"                 => 7482,
                         "hazleton"                => 24000,
                         "hazrat"                  => 12429,
                         "he"                      => 12,
                         "he/she"                  => 10435,
                         "header"                  => 7124,
                         "headingley"              => 14303,
                         "headings"                => 17027,
                         "headlamps"               => 17609,
                         "headland"                => 11184,
                         "headlands"               => 22307,
                         "headlined"               => 8340,
                         "headliner"               => 16199,
                         "headliners"              => 16921,
                         "headlining"              => 8963,
                         "headmaster"              => 6150,
                         "headmasters"             => 19609,
                         "headphone"               => 25483,
                         "headquarter"             => 19299,
                         "headquartered"           => 3098,
                         "headquarters"            => 1067,
                         "headship"                => 22474,
                         "headstock"               => 26322,
                         "headstones"              => 21462,
                         "headteacher"             => 16055,
                         "headwater"               => 23405,
                         "headwaters"              => 8487,
                         "health"                  => 404,
                         "healthcare"              => 3532,
                         "hearings"                => 6561,
                         "heartbreakers"           => 27526,
                         "hearths"                 => 24927,
                         "heartland"               => 9047,
                         "heated"                  => 4739,
                         "heaters"                 => 15150,
                         "heathfield"              => 28406,
                         "heathland"               => 17919,
                         "heating"                 => 4130,
                         "heats"                   => 5665,
                         "heatseekers"             => 14590,
                         "heavier"                 => 5005,
                         "heaviest"                => 8839,
                         "heavily"                 => 1491,
                         "heavy"                   => 815,
                         "heavyweight"             => 3265,
                         "heavyweights"            => 23691,
                         "hebdo"                   => 28593,
                         "hebei"                   => 9713,
                         "hebrew"                  => 2557,
                         "hebrides"                => 11459,
                         "hectare"                 => 8345,
                         "hectares"                => 4553,
                         "hedgehogs"               => 21988,
                         "hedmark"                 => 25909,
                         "hedong"                  => 23235,
                         "hedonistic"              => 28444,
                         "heeded"                  => 28219,
                         "heerenveen"              => 18792,
                         "hefei"                   => 28616,
                         "hegel"                   => 11998,
                         "hegemonic"               => 24873,
                         "hegemony"                => 10724,
                         "heian"                   => 15090,
                         "heidegger"               => 13269,
                         "heidelberg"              => 6506,
                         "heidfeld"                => 23365,
                         "height"                  => 1503,
                         "heights"                 => 2593,
                         "heikki"                  => 23385,
                         "heilbronn"               => 19160,
                         "heilongjiang"            => 16751,
                         "heinkel"                 => 14818,
                         "heir"                    => 3120,
                         "heiress"                 => 7483,
                         "heirs"                   => 5816,
                         "heisenberg"              => 15331,
                         "heisman"                 => 10674,
                         "hejaz"                   => 21151,
                         "held"                    => 167,
                         "helder"                  => 21143,
                         "helens"                  => 7681,
                         "helgi"                   => 27585,
                         "helical"                 => 13497,
                         "helices"                 => 17263,
                         "helicopters"             => 4585,
                         "helier"                  => 24830,
                         "heligoland"              => 23493,
                         "helio"                   => 20885,
                         "heliocentric"            => 27408,
                         "heliopolis"              => 22867,
                         "heliport"                => 14884,
                         "helix"                   => 8728,
                         "hellenic"                => 7930,
                         "hellenistic"             => 8982,
                         "hellinsia"               => 27875,
                         "hells"                   => 16173,
                         "helmand"                 => 16868,
                         "helmed"                  => 19186,
                         "helmholtz"               => 17956,
                         "helmsman"                => 24725,
                         "helpline"                => 23980,
                         "helsing"                 => 24131,
                         "helsingborg"             => 21069,
                         "helsinki"                => 4591,
                         "helvetic"                => 26542,
                         "hematite"                => 25897,
                         "hematology"              => 28538,
                         "hematopoietic"           => 24773,
                         "hemel"                   => 19267,
                         "hemings"                 => 23294,
                         "hemisphere"              => 5014,
                         "hemispheres"             => 16776,
                         "hemispheric"             => 29071,
                         "hemispherical"           => 22048,
                         "hemorrhagic"             => 23863,
                         "henan"                   => 9003,
                         "hence"                   => 2049,
                         "henceforth"              => 10935,
                         "henchmen"                => 11520,
                         "hendrik"                 => 10491,
                         "henin"                   => 20509,
                         "henna"                   => 25390,
                         "hennepin"                => 16969,
                         "henri"                   => 3702,
                         "henrico"                 => 24502,
                         "henricus"                => 27073,
                         "henryk"                  => 13982,
                         "hepatic"                 => 15742,
                         "heptathlon"              => 18061,
                         "her"                     => 35,
                         "heracles"                => 13250,
                         "heraclius"               => 15184,
                         "heraklion"               => 24832,
                         "herald"                  => 3523,
                         "heralded"                => 11533,
                         "heraldic"                => 8956,
                         "heraldry"                => 10243,
                         "heralds"                 => 18646,
                         "herat"                   => 15257,
                         "herault"                 => 21680,
                         "herbaceous"              => 11350,
                         "herbarium"               => 13101,
                         "herbicide"               => 21125,
                         "herbicides"              => 18695,
                         "herbivore"               => 23596,
                         "herbivores"              => 16435,
                         "herbivorous"             => 16104,
                         "herders"                 => 20964,
                         "herding"                 => 13388,
                         "herds"                   => 9726,
                         "hereditary"              => 5266,
                         "heredity"                => 20762,
                         "herefordshire"           => 10640,
                         "herero"                  => 26615,
                         "heresies"                => 24439,
                         "heresy"                  => 9549,
                         "heretical"               => 14778,
                         "heretics"                => 14758,
                         "herge"                   => 14942,
                         "heriot"                  => 21648,
                         "heritable"               => 23637,
                         "heritage"                => 1182,
                         "herkimer"                => 21673,
                         "hermanos"                => 24049,
                         "hermeneutics"            => 21754,
                         "hermetic"                => 20173,
                         "hermitage"               => 8689,
                         "hermitian"               => 21106,
                         "hermits"                 => 18614,
                         "hernando"                => 14544,
                         "herne"                   => 15714,
                         "herodotus"               => 10699,
                         "heroes"                  => 2811,
                         "heroically"              => 29345,
                         "heroine"                 => 7241,
                         "heroines"                => 15035,
                         "heroism"                 => 9612,
                         "herpetologist"           => 27938,
                         "hertford"                => 12177,
                         "hertfordshire"           => 6559,
                         "hertogenbosch"           => 24120,
                         "herts"                   => 29211,
                         "herzegovina"             => 3955,
                         "herzl"                   => 21239,
                         "herzliya"                => 25456,
                         "hesar"                   => 23744,
                         "heseltine"               => 27935,
                         "hesiod"                  => 21376,
                         "hesketh"                 => 20368,
                         "hesperiidae"             => 16682,
                         "hessen"                  => 18186,
                         "heterodox"               => 26221,
                         "heterogeneity"           => 21211,
                         "heterogeneous"           => 11237,
                         "heterozygous"            => 23511,
                         "hetman"                  => 15242,
                         "heung"                   => 26057,
                         "heuristic"               => 15048,
                         "heuristics"              => 23049,
                         "hexadecimal"             => 22462,
                         "hexagonal"               => 10037,
                         "hexham"                  => 18065,
                         "heydar"                  => 24419,
                         "heyday"                  => 9235,
                         "heydrich"                => 19732,
                         "hezbollah"               => 8480,
                         "hezekiah"                => 20731,
                         "hialeah"                 => 23560,
                         "hiatus"                  => 4840,
                         "hibernate"               => 25192,
                         "hibernation"             => 16319,
                         "hibernian"               => 11417,
                         "hideo"                   => 20373,
                         "hideout"                 => 11081,
                         "hideyoshi"               => 14404,
                         "hierarchical"            => 8382,
                         "hierarchies"             => 15732,
                         "hierarchy"               => 4711,
                         "hieroglyph"              => 22833,
                         "hieroglyphic"            => 21363,
                         "hieronymus"              => 18919,
                         "high"                    => 91,
                         "higher"                  => 561,
                         "highest"                 => 639,
                         "highgate"                => 14242,
                         "highlanders"             => 8556,
                         "highlands"               => 4176,
                         "highlight"               => 4574,
                         "highlighted"             => 4470,
                         "highlighting"            => 7792,
                         "highlights"              => 4023,
                         "highly"                  => 891,
                         "highs"                   => 8895,
                         "highschool"              => 21686,
                         "highway"                 => 622,
                         "highwayman"              => 26515,
                         "highways"                => 3243,
                         "hijab"                   => 21133,
                         "hijackers"               => 15590,
                         "hijacking"               => 14028,
                         "hijra"                   => 28625,
                         "hikers"                  => 10906,
                         "hilal"                   => 16375,
                         "hildesheim"              => 16479,
                         "hillcrest"               => 15723,
                         "hillel"                  => 16700,
                         "hillfort"                => 24123,
                         "hillingdon"              => 21994,
                         "hills"                   => 1311,
                         "hillsboro"               => 12558,
                         "hillsborough"            => 9167,
                         "hillsdale"               => 18505,
                         "hillsides"               => 16001,
                         "hillsong"                => 23012,
                         "hilly"                   => 7738,
                         "hilversum"               => 26067,
                         "him/her"                 => 22922,
                         "himachal"                => 11032,
                         "himalaya"                => 15077,
                         "himalayan"               => 9280,
                         "himalayas"               => 8972,
                         "himmler"                 => 10805,
                         "himself"                 => 375,
                         "hindemith"               => 22559,
                         "hindenburg"              => 12501,
                         "hinder"                  => 11224,
                         "hindered"                => 9871,
                         "hindering"               => 20114,
                         "hindi"                   => 3496,
                         "hindley"                 => 21095,
                         "hindmarsh"               => 22185,
                         "hindrance"               => 17586,
                         "hindu"                   => 2481,
                         "hinduism"                => 6456,
                         "hindus"                  => 6369,
                         "hindustan"               => 12325,
                         "hindustani"              => 12672,
                         "hindwing"                => 13941,
                         "hindwings"               => 6060,
                         "hinged"                  => 12112,
                         "hingham"                 => 21655,
                         "hinsdale"                => 25709,
                         "hinted"                  => 9175,
                         "hinterland"              => 12267,
                         "hipparchus"              => 29236,
                         "hipped"                  => 11792,
                         "hipper"                  => 20815,
                         "hippocampal"             => 22457,
                         "hippocampus"             => 13623,
                         "hippocrates"             => 20399,
                         "hippodrome"              => 16352,
                         "hippolyta"               => 26856,
                         "hippolyte"               => 16826,
                         "hippolytus"              => 23818,
                         "hiragana"                => 22651,
                         "hiroshima"               => 7726,
                         "his"                     => 15,
                         "his/her"                 => 8137,
                         "hisar"                   => 21608,
                         "hisham"                  => 19934,
                         "hispania"                => 14100,
                         "hispanic"                => 1967,
                         "hispanicized"            => 15353,
                         "hispanics"               => 12135,
                         "hispaniola"              => 14782,
                         "hispano"                 => 14854,
                         "histidine"               => 23162,
                         "histoire"                => 15105,
                         "histological"            => 25923,
                         "histology"               => 20890,
                         "histone"                 => 14558,
                         "historia"                => 8333,
                         "historian"               => 1684,
                         "historians"              => 2542,
                         "historic"                => 509,
                         "historical"              => 666,
                         "historically"            => 2254,
                         "historicity"             => 19757,
                         "histories"               => 5768,
                         "historiography"          => 10201,
                         "historique"              => 18882,
                         "history"                 => 96,
                         "hitchin"                 => 20189,
                         "hitfix"                  => 28231,
                         "hitherto"                => 10070,
                         "hitless"                 => 29635,
                         "hits"                    => 1446,
                         "hitter"                  => 6277,
                         "hitters"                 => 11821,
                         "hittite"                 => 13039,
                         "hittites"                => 23489,
                         "hiv/aids"                => 7478,
                         "hjalmar"                 => 20536,
                         "hmong"                   => 10570,
                         "hoards"                  => 28763,
                         "hoare"                   => 15695,
                         "hobbyist"                => 25969,
                         "hobbyists"               => 17571,
                         "hochschule"              => 11967,
                         "hockeyallsvenskan"       => 28370,
                         "hodgkin"                 => 15455,
                         "hoffenheim"              => 28972,
                         "hofstadter"              => 28836,
                         "hofstra"                 => 17321,
                         "hogarth"                 => 14338,
                         "hohenlohe"               => 19595,
                         "hohenstaufen"            => 20739,
                         "hohenzollern"            => 12807,
                         "hoisted"                 => 13649,
                         "hokkaido"                => 7290,
                         "hokkien"                 => 15993,
                         "holbein"                 => 23851,
                         "holborn"                 => 16171,
                         "holby"                   => 14871,
                         "hold'em"                 => 21601,
                         "holders"                 => 4852,
                         "holdings"                => 3399,
                         "holds"                   => 1283,
                         "holistic"                => 10185,
                         "holkar"                  => 21915,
                         "hollande"                => 23670,
                         "hollandia"               => 21952,
                         "hollies"                 => 20833,
                         "hollows"                 => 18288,
                         "hollyoaks"               => 11874,
                         "hollywood"               => 1731,
                         "holme"                   => 15811,
                         "holmenkollen"            => 24378,
                         "holocaust"               => 4198,
                         "holocene"                => 15113,
                         "holographic"             => 15603,
                         "holomorphic"             => 17105,
                         "holon"                   => 26209,
                         "holotype"                => 10380,
                         "holyhead"                => 20477,
                         "holyoke"                 => 13417,
                         "holyrood"                => 17991,
                         "holywell"                => 23357,
                         "homage"                  => 5481,
                         "home"                    => 145,
                         "homebuilt"               => 25148,
                         "homegrown"               => 18136,
                         "homeland"                => 4014,
                         "homelands"               => 16673,
                         "homelessness"            => 12264,
                         "homeopathy"              => 20665,
                         "homeostasis"             => 18408,
                         "homeowner"               => 13205,
                         "homeowners"              => 10650,
                         "homeport"                => 20644,
                         "homeported"              => 28860,
                         "homeric"                 => 18773,
                         "homes"                   => 1519,
                         "homeschooled"            => 23812,
                         "homestead"               => 5438,
                         "homesteaders"            => 27479,
                         "homesteads"              => 18208,
                         "hometown"                => 3446,
                         "homeward"                => 21565,
                         "homilies"                => 23618,
                         "hominid"                 => 26059,
                         "hommes"                  => 28272,
                         "homoerotic"              => 28095,
                         "homogeneity"             => 21286,
                         "homogeneous"             => 8138,
                         "homogenous"              => 23138,
                         "homolog"                 => 21201,
                         "homologation"            => 27117,
                         "homologous"              => 12754,
                         "homology"                => 10976,
                         "homomorphism"            => 16058,
                         "homomorphisms"           => 28866,
                         "homonymous"              => 25522,
                         "homophobia"              => 14273,
                         "homophobic"              => 15799,
                         "homosexuality"           => 5574,
                         "homotopy"                => 14374,
                         "homozygous"              => 19604,
                         "honduran"                => 10494,
                         "honduras"                => 5233,
                         "honeycomb"               => 11638,
                         "honeycombs"              => 28433,
                         "honeyeater"              => 21431,
                         "honiara"                 => 26788,
                         "honorary"                => 2037,
                         "honoree"                 => 18418,
                         "honorees"                => 19867,
                         "honorific"               => 11844,
                         "honoris"                 => 14935,
                         "honorius"                => 17033,
                         "honors"                  => 2136,
                         "honour"                  => 2129,
                         "honourable"              => 7427,
                         "honoured"                => 5731,
                         "honouring"               => 16040,
                         "honours"                 => 2221,
                         "honshu"                  => 12868,
                         "honved"                  => 26761,
                         "hooghly"                 => 20417,
                         "hooliganism"             => 27198,
                         "hoorn"                   => 27439,
                         "hopefuls"                => 23259,
                         "hopital"                 => 26258,
                         "hoppus"                  => 25162,
                         "hordaland"               => 17168,
                         "horde"                   => 9868,
                         "horizontal"              => 3605,
                         "horizontally"            => 8519,
                         "horizonte"               => 15856,
                         "hormozgan"               => 12728,
                         "hormuz"                  => 29138,
                         "hornbill"                => 20207,
                         "hornblower"              => 20734,
                         "hornby"                  => 14511,
                         "hornchurch"              => 23199,
                         "horned"                  => 9458,
                         "horni"                   => 28297,
                         "hornsey"                 => 24202,
                         "horror"                  => 2533,
                         "horsemanship"            => 26459,
                         "horsepower"              => 8426,
                         "horseshoe"               => 7996,
                         "horseshoes"              => 28101,
                         "horsham"                 => 13086,
                         "horthy"                  => 20135,
                         "horticultural"           => 8715,
                         "horticulture"            => 9988,
                         "horticulturist"          => 29476,
                         "hortons"                 => 24905,
                         "hoseyn"                  => 19624,
                         "hoseynabad"              => 12481,
                         "hoshi"                   => 28430,
                         "hoshino"                 => 28452,
                         "hosiery"                 => 24530,
                         "hosni"                   => 21755,
                         "hosokawa"                => 25883,
                         "hospice"                 => 9950,
                         "hospitalised"            => 17264,
                         "hospitalization"         => 15665,
                         "hospitalized"            => 8529,
                         "hospitaller"             => 20878,
                         "hospitallers"            => 25365,
                         "hospitals"               => 2886,
                         "hossein"                 => 14501,
                         "host"                    => 917,
                         "hosted"                  => 1144,
                         "hostel"                  => 7938,
                         "hostels"                 => 12210,
                         "hostilities"             => 5945,
                         "hosting"                 => 3462,
                         "hosts"                   => 1934,
                         "hotelier"                => 24925,
                         "hotels"                  => 3228,
                         "hotham"                  => 20704,
                         "hotly"                   => 14306,
                         "houbraken"               => 23690,
                         "houma"                   => 24794,
                         "hounslow"                => 17163,
                         "hourly"                  => 7403,
                         "housatonic"              => 23157,
                         "house"                   => 123,
                         "housed"                  => 2541,
                         "houseguests"             => 13782,
                         "household"               => 1050,
                         "householder"             => 2128,
                         "householders"            => 28654,
                         "households"              => 765,
                         "housemate"               => 13217,
                         "housemates"              => 9658,
                         "houses"                  => 791,
                         "housewives"              => 11016,
                         "housing"                 => 840,
                         "houten"                  => 23633,
                         "houthi"                  => 28294,
                         "houthis"                 => 29839,
                         "hovered"                 => 27629,
                         "howards"                 => 24274,
                         "however"                 => 92,
                         "howitzer"                => 12031,
                         "howitzers"               => 13109,
                         "howmeh"                  => 16946,
                         "howrah"                  => 12021,
                         "howth"                   => 25853,
                         "hoxha"                   => 20316,
                         "hoxton"                  => 26325,
                         "hoyas"                   => 18663,
                         "hoysala"                 => 22647,
                         "hradec"                  => 18090,
                         "hristo"                  => 26187,
                         "hsien"                   => 21582,
                         "hsinchu"                 => 25830,
                         "html5"                   => 19104,
                         "http"                    => 2212,
                         "https"                   => 21,
                         "huawei"                  => 24712,
                         "hubei"                   => 11040,
                         "hubli"                   => 26010,
                         "hucknall"                => 27359,
                         "huddersfield"            => 6453,
                         "huelva"                  => 18992,
                         "huesca"                  => 19638,
                         "huffington"              => 9173,
                         "hugely"                  => 9470,
                         "hughie"                  => 24276,
                         "huguenot"                => 12562,
                         "huguenots"               => 14929,
                         "hulled"                  => 14482,
                         "hulls"                   => 11788,
                         "human"                   => 392,
                         "humane"                  => 8449,
                         "humanism"                => 11926,
                         "humanist"                => 8132,
                         "humanistic"              => 12613,
                         "humanists"               => 20174,
                         "humanitarian"            => 4115,
                         "humanities"              => 4435,
                         "humankind"               => 13756,
                         "humanoid"                => 10026,
                         "humanoids"               => 21443,
                         "humans"                  => 1591,
                         "humayun"                 => 16248,
                         "humber"                  => 9636,
                         "humberside"              => 22763,
                         "humboldt"                => 6965,
                         "humerus"                 => 18762,
                         "humid"                   => 5287,
                         "humidity"                => 7049,
                         "hummingbird"             => 13817,
                         "hummingbirds"            => 18997,
                         "humorist"                => 17086,
                         "humorous"                => 5322,
                         "humorously"              => 16741,
                         "hunan"                   => 9459,
                         "hundreds"                => 2030,
                         "hundredths"              => 28844,
                         "hungama"                 => 28770,
                         "hungarian"               => 1830,
                         "hungarians"              => 7922,
                         "hungary"                 => 1901,
                         "hunslet"                 => 18303,
                         "hunsruck"                => 20043,
                         "hunterdon"               => 20490,
                         "hunters"                 => 4894,
                         "huntingdon"              => 10645,
                         "huntingdonshire"         => 18331,
                         "huntly"                  => 17708,
                         "huntsville"              => 9128,
                         "hunza"                   => 29812,
                         "huracan"                 => 20933,
                         "hurdler"                 => 19712,
                         "hurdles"                 => 6361,
                         "hurler"                  => 11867,
                         "hurlers"                 => 27199,
                         "hurling"                 => 4222,
                         "huron"                   => 7591,
                         "hurricane"               => 2138,
                         "hurricanes"              => 5840,
                         "hurriedly"               => 18421,
                         "hurries"                 => 25364,
                         "husayn"                  => 12965,
                         "husbandry"               => 11797,
                         "huseyin"                 => 25725,
                         "hussars"                 => 10753,
                         "hussein"                 => 5892,
                         "husserl"                 => 21238,
                         "hussite"                 => 22948,
                         "huxley"                  => 10701,
                         "huygens"                 => 18219,
                         "hyacinthe"               => 20939,
                         "hyaline"                 => 19311,
                         "hyannis"                 => 29222,
                         "hybrid"                  => 3227,
                         "hybridization"           => 13706,
                         "hybrids"                 => 7699,
                         "hyderabad"               => 4829,
                         "hydra"                   => 10605,
                         "hydration"               => 19953,
                         "hydraulic"               => 5253,
                         "hydraulically"           => 21965,
                         "hydrazine"               => 26252,
                         "hydride"                 => 15124,
                         "hydrocarbon"             => 11742,
                         "hydrocarbons"            => 11302,
                         "hydrodynamic"            => 21004,
                         "hydroelectric"           => 6075,
                         "hydroelectricity"        => 19814,
                         "hydrogen"                => 3344,
                         "hydrogenation"           => 20928,
                         "hydrographic"            => 13813,
                         "hydrography"             => 26861,
                         "hydrolases"              => 23761,
                         "hydrological"            => 19916,
                         "hydrology"               => 13656,
                         "hydrolysis"              => 12148,
                         "hydrolyzed"              => 28556,
                         "hydrophilic"             => 21765,
                         "hydrophobic"             => 12163,
                         "hydropower"              => 12774,
                         "hydrostatic"             => 18977,
                         "hydrothermal"            => 16580,
                         "hydroxide"               => 11231,
                         "hydroxy"                 => 23221,
                         "hydroxyl"                => 13899,
                         "hydroxylase"             => 21534,
                         "hyeon"                   => 29870,
                         "hyksos"                  => 29246,
                         "hylidae"                 => 24611,
                         "hymenoptera"             => 25538,
                         "hymn"                    => 5723,
                         "hymnal"                  => 16601,
                         "hymns"                   => 6510,
                         "hyogo"                   => 14747,
                         "hyperactivity"           => 22498,
                         "hyperbaric"              => 28758,
                         "hyperbola"               => 29690,
                         "hyperbolic"              => 9930,
                         "hypergeometric"          => 28661,
                         "hyperinflation"          => 23084,
                         "hypermarket"             => 28122,
                         "hyperplane"              => 29158,
                         "hyperplasia"             => 24265,
                         "hypersensitivity"        => 22848,
                         "hypersonic"              => 26263,
                         "hypertension"            => 10606,
                         "hypertext"               => 21240,
                         "hypertrophy"             => 23620,
                         "hyphae"                  => 15249,
                         "hyphenated"              => 29516,
                         "hyposmocoma"             => 22229,
                         "hypotension"             => 25123,
                         "hypothalamus"            => 18994,
                         "hypotheses"              => 9203,
                         "hypothesis"              => 3643,
                         "hypothesized"            => 9922,
                         "hypoxia"                 => 17094,
                         "hypoxic"                 => 29503,
                         "hysteresis"              => 26036,
                         "hythe"                   => 19276,
                         "hyung"                   => 24298,
                         "hywel"                   => 22994,
                         "i.e."                    => 3275,
                         "ibadan"                  => 15354,
                         "ibaraki"                 => 18759,
                         "iberia"                  => 9763,
                         "iberian"                 => 7222,
                         "ibero"                   => 21271,
                         "ibises"                  => 22490,
                         "ibiza"                   => 12809,
                         "ibrox"                   => 21948,
                         "ibsen"                   => 13142,
                         "icann"                   => 19107,
                         "icbms"                   => 26767,
                         "icebreaker"              => 15329,
                         "icebreakers"             => 23734,
                         "iceland"                 => 3766,
                         "icelanders"              => 27239,
                         "icelandic"               => 5187,
                         "icon"                    => 4785,
                         "iconic"                  => 5199,
                         "iconoclasm"              => 25119,
                         "iconoclastic"            => 26121,
                         "iconographic"            => 25440,
                         "iconography"             => 10162,
                         "iconostasis"             => 26978,
                         "icons"                   => 6511,
                         "icosahedral"             => 25253,
                         "icosahedron"             => 28326,
                         "idaho"                   => 3486,
                         "ideal"                   => 2785,
                         "idealised"               => 28221,
                         "idealism"                => 12415,
                         "idealized"               => 13095,
                         "ideally"                 => 9435,
                         "ideals"                  => 5411,
                         "ident"                   => 24930,
                         "identical"               => 2579,
                         "identically"             => 15100,
                         "identifiable"            => 9327,
                         "identification"          => 3121,
                         "identifications"         => 21993,
                         "identified"              => 1212,
                         "identifier"              => 9212,
                         "identifiers"             => 16172,
                         "identifies"              => 5261,
                         "identify"                => 2403,
                         "identifying"             => 4513,
                         "identities"              => 6072,
                         "identity"                => 1453,
                         "idents"                  => 21575,
                         "ideological"             => 6172,
                         "ideologically"           => 17383,
                         "ideologies"              => 10683,
                         "ideology"                => 4485,
                         "idiomatic"               => 23814,
                         "idioms"                  => 17496,
                         "idiopathic"              => 19812,
                         "idiosyncratic"           => 14219,
                         "idlib"                   => 22398,
                         "idmanyurdu"              => 26814,
                         "idol"                    => 3633,
                         "idolator"                => 21879,
                         "idolatry"                => 19058,
                         "idols"                   => 8221,
                         "idris"                   => 13092,
                         "ieyasu"                  => 15344,
                         "iftikhar"                => 29387,
                         "igcse"                   => 26904,
                         "ignace"                  => 20940,
                         "ignacy"                  => 21980,
                         "ignaz"                   => 19736,
                         "ignazio"                 => 28242,
                         "igneous"                 => 12519,
                         "ignited"                 => 10191,
                         "ignites"                 => 28664,
                         "igniting"                => 19716,
                         "igreja"                  => 27285,
                         "iheartmedia"             => 20269,
                         "ilaiyaraaja"             => 21430,
                         "iliac"                   => 27919,
                         "iliad"                   => 13571,
                         "ilija"                   => 26960,
                         "ilium"                   => 29120,
                         "ilkeston"                => 26246,
                         "ilkley"                  => 28796,
                         "illawarra"               => 11687,
                         "illegality"              => 29232,
                         "illegitimate"            => 6461,
                         "illicit"                 => 9390,
                         "illinois"                => 1023,
                         "illiteracy"              => 17157,
                         "illness"                 => 2599,
                         "illnesses"               => 8535,
                         "illuminated"             => 7571,
                         "illuminates"             => 23759,
                         "illumination"            => 9009,
                         "illuminations"           => 23619,
                         "illusionist"             => 27462,
                         "illusory"                => 19407,
                         "illustrate"              => 6578,
                         "illustrated"             => 2641,
                         "illustrates"             => 8079,
                         "illustrating"            => 9104,
                         "illustration"            => 5615,
                         "illustrations"           => 4289,
                         "illustrative"            => 17175,
                         "illustrator"             => 5543,
                         "illustrators"            => 13304,
                         "illyria"                 => 21279,
                         "illyrian"                => 13287,
                         "illyrians"               => 23617,
                         "ilocos"                  => 17651,
                         "iloilo"                  => 12169,
                         "ilves"                   => 27759,
                         "ilyich"                  => 25248,
                         "ilyushin"                => 20196,
                         "image"                   => 1130,
                         "imaged"                  => 20971,
                         "imagery"                 => 4820,
                         "images"                  => 1714,
                         "imaging"                 => 4409,
                         "imago"                   => 29351,
                         "imamate"                 => 28265,
                         "imams"                   => 14763,
                         "imbalances"              => 21783,
                         "imbued"                  => 16926,
                         "imereti"                 => 23509,
                         "imitated"                => 11982,
                         "imitates"                => 24216,
                         "imitations"              => 16821,
                         "imitative"               => 27830,
                         "imitators"               => 23286,
                         "immaculate"              => 7787,
                         "immanuel"                => 12906,
                         "immediacy"               => 20041,
                         "immediate"               => 2246,
                         "immediately"             => 926,
                         "immemorial"              => 24401,
                         "immense"                 => 6120,
                         "immensely"               => 9716,
                         "immersed"                => 10145,
                         "immersion"               => 9055,
                         "immersive"               => 17312,
                         "immigrant"               => 4124,
                         "immigrants"              => 2431,
                         "immigrate"               => 20786,
                         "immigrated"              => 5963,
                         "immigrating"             => 20520,
                         "immigration"             => 2603,
                         "imminent"                => 7068,
                         "immobilized"             => 22740,
                         "immolation"              => 26394,
                         "immorality"              => 18472,
                         "immortalised"            => 27737,
                         "immortalized"            => 17462,
                         "immortals"               => 15291,
                         "immovable"               => 25044,
                         "immunities"              => 24168,
                         "immunization"            => 17385,
                         "immunodeficiency"        => 22792,
                         "immunoglobulin"          => 20115,
                         "immunological"           => 22403,
                         "immunology"              => 13453,
                         "imola"                   => 21467,
                         "impact"                  => 1124,
                         "impacted"                => 7359,
                         "impacting"               => 14889,
                         "impacts"                 => 5281,
                         "impair"                  => 19753,
                         "impaired"                => 6782,
                         "impairment"              => 8945,
                         "impairments"             => 15574,
                         "impaling"                => 28478,
                         "imparted"                => 17779,
                         "impartiality"            => 19249,
                         "imparting"               => 19809,
                         "imparts"                 => 21689,
                         "impassable"              => 16140,
                         "impeachment"             => 9671,
                         "impedance"               => 9135,
                         "impede"                  => 15414,
                         "impeded"                 => 16350,
                         "impending"               => 7815,
                         "imperfect"               => 10808,
                         "imperial"                => 1239,
                         "imperialism"             => 9307,
                         "imperialist"             => 12898,
                         "imperialists"            => 28830,
                         "imperials"               => 25589,
                         "imperio"                 => 29455,
                         "impermeable"             => 25631,
                         "impetus"                 => 8948,
                         "imphal"                  => 20312,
                         "implacable"              => 28708,
                         "implantation"            => 16374,
                         "implement"               => 3753,
                         "implementation"          => 2430,
                         "implementations"         => 7476,
                         "implemented"             => 2491,
                         "implementing"            => 5380,
                         "implements"              => 7910,
                         "implicated"              => 7034,
                         "implications"            => 5188,
                         "implicit"                => 8227,
                         "implicitly"              => 11232,
                         "implied"                 => 5293,
                         "implies"                 => 4452,
                         "implored"                => 29445,
                         "import"                  => 4703,
                         "importance"              => 1515,
                         "importation"             => 11324,
                         "imported"                => 3863,
                         "importers"               => 17908,
                         "importing"               => 9963,
                         "imports"                 => 6031,
                         "imposed"                 => 3461,
                         "imposes"                 => 14574,
                         "imposing"                => 6851,
                         "impoundment"             => 25347,
                         "impoverished"            => 8461,
                         "imprecise"               => 22861,
                         "impresario"              => 14817,
                         "impressionism"           => 14206,
                         "impressionist"           => 11110,
                         "impressionistic"         => 23251,
                         "imprint"                 => 5853,
                         "imprinting"              => 29483,
                         "imprints"                => 17063,
                         "imprisoned"              => 3088,
                         "imprisoning"             => 25408,
                         "imprisonment"            => 3582,
                         "improper"                => 8600,
                         "improperly"              => 12185,
                         "improve"                 => 1628,
                         "improved"                => 1602,
                         "improvement"             => 2613,
                         "improvements"            => 2762,
                         "improves"                => 8442,
                         "improving"               => 3269,
                         "improvisation"           => 8402,
                         "improvisational"         => 12733,
                         "improvisations"          => 18290,
                         "improvised"              => 7056,
                         "impurities"              => 13320,
                         "impurity"                => 19795,
                         "imran"                   => 13466,
                         "imtiaz"                  => 23340,
                         "in"                      => 4,
                         "inability"               => 5337,
                         "inaccessible"            => 9643,
                         "inaccuracy"              => 24503,
                         "inaccurate"              => 8503,
                         "inaccurately"            => 24461,
                         "inacio"                  => 27173,
                         "inaction"                => 19239,
                         "inactivated"             => 6535,
                         "inactivation"            => 11422,
                         "inactive"                => 6149,
                         "inactivity"              => 14726,
                         "inadequate"              => 5590,
                         "inadequately"            => 25535,
                         "inadvertent"             => 24150,
                         "inari"                   => 26088,
                         "inaugural"               => 2638,
                         "inaugurate"              => 28254,
                         "inaugurated"             => 3910,
                         "inauguration"            => 6133,
                         "inboard"                 => 21396,
                         "inc."                    => 1554,
                         "inc.."                   => 13733,
                         "incandescent"            => 14927,
                         "incapacity"              => 23623,
                         "incarnation"             => 5410,
                         "incarnations"            => 10113,
                         "incentives"              => 7281,
                         "inception"               => 3934,
                         "incertae"                => 18318,
                         "incheon"                 => 12637,
                         "inches"                  => 3017,
                         "inchon"                  => 23854,
                         "incidence"               => 6409,
                         "incidences"              => 24416,
                         "incident"                => 1547,
                         "incidental"              => 10205,
                         "incidents"               => 3472,
                         "incineration"            => 26444,
                         "incipient"               => 23016,
                         "incised"                 => 16004,
                         "incisions"               => 27461,
                         "incisive"                => 22178,
                         "incite"                  => 16260,
                         "incited"                 => 17261,
                         "incitement"              => 18552,
                         "inciting"                => 13927,
                         "inclination"             => 9644,
                         "inclinations"            => 20426,
                         "incline"                 => 11377,
                         "inclines"                => 25938,
                         "include"                 => 190,
                         "included"                => 223,
                         "includes"                => 452,
                         "including"               => 87,
                         "inclusion"               => 3693,
                         "inclusions"              => 16139,
                         "inclusive"               => 6928,
                         "income"                  => 564,
                         "incomes"                 => 9295,
                         "incompatibility"         => 19181,
                         "incompatible"            => 8595,
                         "incomplete"              => 4516,
                         "incompleteness"          => 29390,
                         "incompressible"          => 28115,
                         "inconsistencies"         => 12876,
                         "inconsistency"           => 14769,
                         "inconsistent"            => 7089,
                         "incontinence"            => 22070,
                         "incorporate"             => 4530,
                         "incorporated"            => 1394,
                         "incorporates"            => 4680,
                         "incorporating"           => 4742,
                         "incorporation"           => 5656,
                         "incorrect"               => 5993,
                         "incorrectly"             => 6820,
                         "increase"                => 816,
                         "increased"               => 720,
                         "increases"               => 2476,
                         "increasing"              => 1395,
                         "increasingly"            => 1982,
                         "increment"               => 17351,
                         "incremental"             => 12116,
                         "incrementally"           => 25152,
                         "increments"              => 15580,
                         "incubate"                => 27193,
                         "incubated"               => 20089,
                         "incubation"              => 12131,
                         "incumbencies"            => 28674,
                         "incumbency"              => 29080,
                         "incumbent"               => 2851,
                         "incumbents"              => 12181,
                         "incurred"                => 7647,
                         "incurring"               => 19167,
                         "incursion"               => 13626,
                         "incursions"              => 11470,
                         "indebtedness"            => 21028,
                         "indecency"               => 23501,
                         "indefatigable"           => 21339,
                         "indefinite"              => 8762,
                         "indelible"               => 21934,
                         "indemnity"               => 15428,
                         "indented"                => 20980,
                         "indentured"              => 13348,
                         "independence"            => 1074,
                         "independencia"           => 22654,
                         "independent"             => 472,
                         "independently"           => 3093,
                         "independents"            => 7914,
                         "independiente"           => 13939,
                         "index"                   => 2063,
                         "indexed"                 => 8141,
                         "indexes"                 => 12493,
                         "indexing"                => 9281,
                         "india"                   => 322,
                         "indian"                  => 423,
                         "indianapolis"            => 3380,
                         "indianola"               => 25473,
                         "indias"                  => 25665,
                         "indic"                   => 23713,
                         "indicate"                => 2329,
                         "indicated"               => 2113,
                         "indicates"               => 2618,
                         "indicating"              => 3325,
                         "indications"             => 8247,
                         "indicative"              => 8476,
                         "indicator"               => 6300,
                         "indicators"              => 7030,
                         "indices"                 => 9035,
                         "indicted"                => 7325,
                         "indie"                   => 3745,
                         "indies"                  => 3164,
                         "indigenous"              => 2080,
                         "indigent"                => 19419,
                         "indios"                  => 24705,
                         "indirect"                => 5420,
                         "indirectly"              => 6250,
                         "indiscriminate"          => 17320,
                         "indiscriminately"        => 19947,
                         "indistinct"              => 14013,
                         "indistinguishable"       => 12237,
                         "indium"                  => 19994,
                         "individual"              => 632,
                         "individualism"           => 14761,
                         "individualist"           => 15996,
                         "individualistic"         => 20702,
                         "individualized"          => 14035,
                         "individually"            => 5220,
                         "individuals"             => 751,
                         "indivisible"             => 25136,
                         "indo"                    => 3909,
                         "indochina"               => 8986,
                         "indoctrination"          => 22209,
                         "indole"                  => 23730,
                         "indomitable"             => 22780,
                         "indonesia"               => 2061,
                         "indonesian"              => 3371,
                         "indonesians"             => 16796,
                         "indoor"                  => 2356,
                         "indore"                  => 12430,
                         "indra"                   => 10819,
                         "indre"                   => 16142,
                         "induce"                  => 7111,
                         "induced"                 => 3966,
                         "induces"                 => 10686,
                         "inducing"                => 10467,
                         "inductance"              => 20548,
                         "inducted"                => 2900,
                         "inductee"                => 12625,
                         "inductees"               => 13143,
                         "induction"               => 5503,
                         "inductive"               => 13527,
                         "inductor"                => 25273,
                         "indulgences"             => 24067,
                         "indus"                   => 8696,
                         "industrial"              => 939,
                         "industrialisation"       => 15873,
                         "industrialised"          => 20839,
                         "industrialist"           => 7644,
                         "industrialists"          => 13590,
                         "industrialization"       => 9739,
                         "industrialized"          => 11519,
                         "industrially"            => 19015,
                         "industries"              => 1858,
                         "industry"                => 492,
                         "ineffective"             => 7238,
                         "ineffectiveness"         => 28211,
                         "inefficiencies"          => 27261,
                         "inefficiency"            => 18492,
                         "inefficient"             => 10505,
                         "inelastic"               => 28608,
                         "ineligible"              => 8024,
                         "inequalities"            => 12161,
                         "inequality"              => 5978,
                         "inert"                   => 11766,
                         "inertia"                 => 11563,
                         "inertial"                => 11012,
                         "inescapable"             => 29320,
                         "inexpensive"             => 7711,
                         "inexplicably"            => 17881,
                         "inextricably"            => 24255,
                         "infallibility"           => 25229,
                         "infamous"                => 5292,
                         "infamously"              => 27192,
                         "infancy"                 => 8149,
                         "infant"                  => 4212,
                         "infanta"                 => 16367,
                         "infanterie"              => 23599,
                         "infanticide"             => 19598,
                         "infantry"                => 1046,
                         "infantryman"             => 21732,
                         "infantrymen"             => 18551,
                         "infants"                 => 6213,
                         "infections"              => 5521,
                         "infectious"              => 6574,
                         "infective"               => 28223,
                         "infer"                   => 14598,
                         "inference"               => 9477,
                         "inferences"              => 18780,
                         "inferior"                => 5198,
                         "inferred"                => 10373,
                         "infertility"             => 15806,
                         "infestations"            => 23414,
                         "infidels"                => 24981,
                         "infield"                 => 13501,
                         "infielder"               => 12468,
                         "infighting"              => 16175,
                         "infill"                  => 18891,
                         "infiltrated"             => 12302,
                         "infiltrates"             => 22936,
                         "infiltrating"            => 19495,
                         "infiltration"            => 10415,
                         "infinite"                => 4166,
                         "infinitely"              => 10984,
                         "infinitesimal"           => 17065,
                         "infinitive"              => 16725,
                         "infirm"                  => 23491,
                         "inflammation"            => 7705,
                         "inflammatory"            => 7153,
                         "inflation"               => 4817,
                         "inflationary"            => 23872,
                         "inflected"               => 16357,
                         "inflection"              => 17059,
                         "inflectional"            => 27929,
                         "inflections"             => 29569,
                         "inflicted"               => 6955,
                         "inflicting"              => 12843,
                         "inflorescence"           => 8829,
                         "inflorescences"          => 13659,
                         "inflow"                  => 14689,
                         "inflows"                 => 26317,
                         "influence"               => 826,
                         "influenced"              => 1418,
                         "influences"              => 2381,
                         "influencing"             => 8773,
                         "influential"             => 1973,
                         "influenza"               => 8070,
                         "influx"                  => 6310,
                         "infocom"                 => 29873,
                         "infomercials"            => 23490,
                         "informal"                => 4196,
                         "informally"              => 7198,
                         "informatics"             => 10560,
                         "information"             => 378,
                         "informational"           => 13013,
                         "informers"               => 25026,
                         "informing"               => 8147,
                         "informs"                 => 5674,
                         "infosys"                 => 29832,
                         "infotainment"            => 28913,
                         "infractions"             => 19741,
                         "infrared"                => 5929,
                         "infrastructural"         => 20277,
                         "infrastructure"          => 1950,
                         "infrastructures"         => 14802,
                         "infrequent"              => 13279,
                         "infrequently"            => 12996,
                         "infringed"               => 17083,
                         "infringement"            => 6969,
                         "infringements"           => 27248,
                         "infringing"              => 16261,
                         "infuriated"              => 12763,
                         "infused"                 => 11728,
                         "infusion"                => 12921,
                         "ingestion"               => 12677,
                         "inglewood"               => 15262,
                         "ingmar"                  => 24501,
                         "ingolstadt"              => 16530,
                         "ingots"                  => 24949,
                         "ingrained"               => 25945,
                         "ingredients"             => 4788,
                         "inguinal"                => 28998,
                         "ingush"                  => 23808,
                         "ingushetia"              => 29627,
                         "inhabit"                 => 7308,
                         "inhabitant"              => 14272,
                         "inhabitants"             => 1479,
                         "inhabited"               => 3333,
                         "inhabiting"              => 11613,
                         "inhabits"                => 9899,
                         "inherent"                => 5911,
                         "inherently"              => 8908,
                         "inherited"               => 2823,
                         "inheriting"              => 14377,
                         "inhibit"                 => 8855,
                         "inhibited"               => 12023,
                         "inhibiting"              => 12178,
                         "inhibition"              => 8094,
                         "inhibitor"               => 8280,
                         "inhibitors"              => 8539,
                         "inhibitory"              => 12739,
                         "inhibits"                => 10644,
                         "inhospitable"            => 21436,
                         "inhumans"                => 25947,
                         "initial"                 => 973,
                         "initialization"          => 24302,
                         "initialized"             => 28610,
                         "initially"               => 640,
                         "initiate"                => 6886,
                         "initiated"               => 2466,
                         "initiates"               => 12310,
                         "initiating"              => 8938,
                         "initiation"              => 6680,
                         "initiative"              => 2038,
                         "initiatives"             => 3717,
                         "initiator"               => 15009,
                         "initiators"              => 24160,
                         "initio"                  => 29830,
                         "injective"               => 21529,
                         "injectors"               => 26406,
                         "injects"                 => 22899,
                         "injunctions"             => 19582,
                         "injured"                 => 1839,
                         "injures"                 => 20667,
                         "injuries"                => 2287,
                         "injuring"                => 8211,
                         "injurious"               => 27366,
                         "injury"                  => 1355,
                         "injustices"              => 17071,
                         "inked"                   => 16437,
                         "inker"                   => 25851,
                         "inking"                  => 23819,
                         "inland"                  => 3376,
                         "inlays"                  => 25361,
                         "inlet"                   => 5468,
                         "inlets"                  => 17940,
                         "inline"                  => 8029,
                         "inmates"                 => 4908,
                         "innate"                  => 9827,
                         "inner"                   => 1828,
                         "innervated"              => 29621,
                         "innervation"             => 25134,
                         "inning"                  => 4700,
                         "innings"                 => 2125,
                         "innovate"                => 22533,
                         "innovated"               => 27312,
                         "innovation"              => 2989,
                         "innovations"             => 5183,
                         "innovative"              => 3251,
                         "innovator"               => 12490,
                         "innovators"              => 15212,
                         "innsbruck"               => 9767,
                         "innumerable"             => 14183,
                         "inoculation"             => 21957,
                         "inoperable"              => 21307,
                         "inorganic"               => 9238,
                         "inositol"                => 23741,
                         "inowroclaw"              => 27751,
                         "inpatient"               => 15266,
                         "input"                   => 2815,
                         "input/output"            => 22804,
                         "inputs"                  => 6963,
                         "inquest"                 => 11099,
                         "inquired"                => 19548,
                         "inquirer"                => 12666,
                         "inquires"                => 29790,
                         "inquiry"                 => 3632,
                         "inscribed"               => 5384,
                         "inscription"             => 3509,
                         "inscriptions"            => 4715,
                         "insecticide"             => 19042,
                         "insecticides"            => 20566,
                         "insectivores"            => 21547,
                         "insectivorous"           => 16872,
                         "insects"                 => 3513,
                         "insee"                   => 29311,
                         "inserted"                => 5100,
                         "inserting"               => 11628,
                         "inserts"                 => 11791,
                         "inset"                   => 23184,
                         "inshore"                 => 14308,
                         "insiders"                => 16070,
                         "insignia"                => 5709,
                         "insistence"              => 7893,
                         "insofar"                 => 14384,
                         "insoluble"               => 15061,
                         "insolvency"              => 12745,
                         "insolvent"               => 15808,
                         "inspected"               => 9579,
                         "inspecting"              => 15301,
                         "inspection"              => 4253,
                         "inspections"             => 9634,
                         "inspectorate"            => 16562,
                         "inspectors"              => 9480,
                         "inspiration"             => 2667,
                         "inspirations"            => 12610,
                         "inspired"                => 1220,
                         "instability"             => 6617,
                         "instagram"               => 15517,
                         "installation"            => 2965,
                         "installations"           => 4919,
                         "installed"               => 1659,
                         "installer"               => 20266,
                         "installing"              => 8114,
                         "installment"             => 7080,
                         "installments"            => 11366,
                         "installs"                => 22666,
                         "instalment"              => 20942,
                         "instalments"             => 24874,
                         "instance"                => 1921,
                         "instances"               => 4264,
                         "instantaneous"           => 13754,
                         "instar"                  => 20143,
                         "instars"                 => 26594,
                         "instated"                => 19523,
                         "instead"                 => 476,
                         "instigated"              => 10233,
                         "instigating"             => 23968,
                         "instigation"             => 14232,
                         "instilling"              => 26949,
                         "institut"                => 7032,
                         "institute"               => 441,
                         "instituted"              => 5025,
                         "institutes"              => 4262,
                         "instituting"             => 18964,
                         "institution"             => 1465,
                         "institutional"           => 4354,
                         "institutionalized"       => 9023,
                         "institutions"            => 1308,
                         "instituto"               => 8457,
                         "instructed"              => 4822,
                         "instruction"             => 2738,
                         "instructional"           => 7710,
                         "instructor"              => 3583,
                         "instructors"             => 6943,
                         "instructs"               => 12273,
                         "instrument"              => 2183,
                         "instrumental"            => 2171,
                         "instrumentalist"         => 9510,
                         "instrumentalists"        => 17813,
                         "instrumentals"           => 14225,
                         "instrumentation"         => 5881,
                         "instruments"             => 1816,
                         "insufficiency"           => 19858,
                         "insufficient"            => 5070,
                         "insufficiently"          => 18062,
                         "insular"                 => 11419,
                         "insulated"               => 12647,
                         "insulating"              => 16198,
                         "insulation"              => 8916,
                         "insulator"               => 19929,
                         "insulators"              => 23342,
                         "insurer"                 => 15854,
                         "insurers"                => 14241,
                         "insurgency"              => 7712,
                         "insurgent"               => 10228,
                         "insurgents"              => 6932,
                         "insurrection"            => 9033,
                         "intact"                  => 4261,
                         "intake"                  => 5378,
                         "intakes"                 => 18483,
                         "intangible"              => 13323,
                         "integer"                 => 5923,
                         "integers"                => 7867,
                         "integrable"              => 19456,
                         "integral"                => 3370,
                         "integrals"               => 15013,
                         "integrate"               => 6116,
                         "integrated"              => 2018,
                         "integrates"              => 10811,
                         "integrating"             => 7664,
                         "integration"             => 2880,
                         "integrative"             => 15857,
                         "integrator"              => 24142,
                         "intellectual"            => 2681,
                         "intellectuals"           => 6050,
                         "intelligence"            => 1349,
                         "intelligencer"           => 20408,
                         "intelligentsia"          => 15216,
                         "intelligibility"         => 24730,
                         "intelligible"            => 14165,
                         "intelsat"                => 23030,
                         "intendant"               => 21025,
                         "intended"                => 993,
                         "intending"               => 7224,
                         "intends"                 => 6881,
                         "intensification"         => 13957,
                         "intensified"             => 6538,
                         "intensifies"             => 29991,
                         "intensify"               => 13608,
                         "intensifying"            => 17694,
                         "intensities"             => 19318,
                         "intensity"               => 3517,
                         "intensive"               => 4155,
                         "intensively"             => 14633,
                         "intent"                  => 3539,
                         "inter"                   => 2230,
                         "interact"                => 4391,
                         "interacted"              => 14532,
                         "interacting"             => 7778,
                         "interaction"             => 2908,
                         "interactions"            => 3412,
                         "interactive"             => 3208,
                         "interactivity"           => 21337,
                         "interacts"               => 10678,
                         "interagency"             => 20132,
                         "interbank"               => 28479,
                         "intercalated"            => 26982,
                         "intercepted"             => 6117,
                         "interception"            => 5910,
                         "interceptions"           => 6336,
                         "interceptor"             => 9088,
                         "interceptors"            => 19093,
                         "intercepts"              => 20133,
                         "intercession"            => 14989,
                         "interchange"             => 3027,
                         "interchangeable"         => 10287,
                         "interchangeably"         => 11892,
                         "interchanged"            => 29508,
                         "interchanges"            => 9843,
                         "intercity"               => 7887,
                         "intercollegiate"         => 6862,
                         "interconnect"            => 16834,
                         "interconnected"          => 9906,
                         "interconnecting"         => 26538,
                         "interconnection"         => 17030,
                         "intercontinental"        => 6678,
                         "intercultural"           => 14812,
                         "intercut"                => 23934,
                         "interdenominational"     => 28902,
                         "interdependence"         => 19472,
                         "interdependent"          => 20863,
                         "interdict"               => 21278,
                         "interdiction"            => 15636,
                         "interdisciplinary"       => 6689,
                         "interes"                 => 29593,
                         "interest"                => 575,
                         "interestingly"           => 9162,
                         "interests"               => 1636,
                         "interface"               => 2795,
                         "interfaces"              => 6780,
                         "interfaith"              => 11944,
                         "interferometer"          => 19027,
                         "interferometry"          => 24341,
                         "intergovernmental"       => 11322,
                         "intergroup"              => 28482,
                         "interim"                 => 3508,
                         "interior"                => 1390,
                         "interiors"               => 7267,
                         "interlaced"              => 20496,
                         "interlaken"              => 24518,
                         "interleague"             => 24032,
                         "interleukin"             => 18435,
                         "interlingua"             => 26705,
                         "interlinked"             => 27189,
                         "interlock"               => 29872,
                         "interlocking"            => 12401,
                         "interludes"              => 17457,
                         "intermarriage"           => 16363,
                         "intermarried"            => 20201,
                         "intermedia"              => 19172,
                         "intermediaries"          => 17024,
                         "intermediary"            => 11112,
                         "intermediate"            => 2720,
                         "intermediates"           => 15671,
                         "interment"               => 13343,
                         "interments"              => 26570,
                         "intermingled"            => 29448,
                         "intermittent"            => 8009,
                         "intermittently"          => 10475,
                         "intermixed"              => 25249,
                         "intermodal"              => 14820,
                         "intermolecular"          => 27743,
                         "internacional"           => 10060,
                         "internal"                => 1377,
                         "internalized"            => 26741,
                         "internally"              => 6253,
                         "international"           => 132,
                         "internationale"          => 8019,
                         "internationalism"        => 26453,
                         "internationalist"        => 18995,
                         "internationalization"    => 22246,
                         "internationally"         => 2422,
                         "internationals"          => 7909,
                         "internazionale"          => 12470,
                         "internazionali"          => 25530,
                         "interned"                => 8496,
                         "internees"               => 18953,
                         "internment"              => 9133,
                         "internships"             => 13972,
                         "interoperability"        => 11080,
                         "interoperable"           => 25671,
                         "interpersonal"           => 10516,
                         "interplanetary"          => 15629,
                         "interplay"               => 11706,
                         "interpolated"            => 22600,
                         "interpolation"           => 12889,
                         "interpretation"          => 2502,
                         "interpretations"         => 5263,
                         "interpretative"          => 28299,
                         "interpreted"             => 3528,
                         "interpreter"             => 7084,
                         "interpreters"            => 12187,
                         "interpreting"            => 8909,
                         "interpretive"            => 11223,
                         "interprets"              => 12286,
                         "interprovincial"         => 25466,
                         "interracial"             => 14209,
                         "interred"                => 4595,
                         "interregnum"             => 17344,
                         "interrelated"            => 17865,
                         "interrogative"           => 24646,
                         "interrogator"            => 27206,
                         "interrogators"           => 23441,
                         "interrupts"              => 12724,
                         "interscholastic"         => 10954,
                         "interscope"              => 13029,
                         "intersect"               => 9103,
                         "intersected"             => 16349,
                         "intersecting"            => 8638,
                         "intersection"            => 2266,
                         "intersections"           => 8578,
                         "intersects"              => 5751,
                         "intersex"                => 16376,
                         "interspersed"            => 8927,
                         "interstate"              => 2439,
                         "interstates"             => 20585,
                         "interstellar"            => 10097,
                         "interstitial"            => 16212,
                         "intertidal"              => 16080,
                         "intertoto"               => 18021,
                         "interuniversity"         => 27965,
                         "interurban"              => 13949,
                         "interval"                => 4784,
                         "intervals"               => 5218,
                         "intervene"               => 7362,
                         "intervened"              => 7937,
                         "intervenes"              => 14789,
                         "intervening"             => 9229,
                         "intervention"            => 3167,
                         "interventional"          => 23880,
                         "interventionist"         => 26853,
                         "interventions"           => 6947,
                         "interview"               => 1287,
                         "interviewed"             => 3714,
                         "interviewees"            => 24509,
                         "interviewer"             => 11287,
                         "interviewers"            => 27928,
                         "interviews"              => 2647,
                         "interwar"                => 10068,
                         "interwoven"              => 16453,
                         "intestinal"              => 10095,
                         "intifada"                => 16218,
                         "intimidation"            => 10240,
                         "into"                    => 43,
                         "intolerance"             => 11884,
                         "intonation"              => 15038,
                         "intoxicated"             => 12857,
                         "intra"                   => 9170,
                         "intracellular"           => 10746,
                         "intracoastal"            => 26958,
                         "intracranial"            => 20742,
                         "intractable"             => 23960,
                         "intramolecular"          => 25500,
                         "intramural"              => 14668,
                         "intramuros"              => 28849,
                         "intransitive"            => 21642,
                         "intrastate"              => 26540,
                         "intravenous"             => 12661,
                         "intrepidity"             => 27831,
                         "intricate"               => 7997,
                         "intricately"             => 18885,
                         "intrigues"               => 15039,
                         "intrinsic"               => 8087,
                         "intrinsically"           => 16336,
                         "introduced"              => 548,
                         "introduces"              => 5189,
                         "introducing"             => 3845,
                         "introduction"            => 1498,
                         "introductory"            => 8455,
                         "intron"                  => 27545,
                         "introns"                 => 26210,
                         "introspection"           => 20136,
                         "introspective"           => 15978,
                         "introverted"             => 23036,
                         "intrusions"              => 17828,
                         "intuitively"             => 16919,
                         "inuktitut"               => 27790,
                         "inundated"               => 13136,
                         "inundation"              => 23622,
                         "invaded"                 => 4016,
                         "invaders"                => 6473,
                         "invades"                 => 22379,
                         "invalidated"             => 17932,
                         "invalided"               => 26466,
                         "invariably"              => 9416,
                         "invariance"              => 18355,
                         "invariant"               => 7906,
                         "invariants"              => 17032,
                         "invasion"                => 1513,
                         "invasions"               => 7603,
                         "invasive"                => 6221,
                         "invention"               => 3914,
                         "inventions"              => 7301,
                         "inventive"               => 11679,
                         "inventiveness"           => 27070,
                         "inventor"                => 4633,
                         "inventories"             => 16504,
                         "inventors"               => 11531,
                         "invents"                 => 24633,
                         "invercargill"            => 18420,
                         "inverness"               => 7848,
                         "inverse"                 => 6583,
                         "inversely"               => 17492,
                         "inversion"               => 9210,
                         "inversions"              => 22041,
                         "invert"                  => 29352,
                         "invertebrate"            => 15087,
                         "invertebrates"           => 8088,
                         "inverted"                => 7464,
                         "inverter"                => 20884,
                         "invertible"              => 18245,
                         "inverting"               => 24960,
                         "invested"                => 4224,
                         "investigate"             => 3366,
                         "investigated"            => 3967,
                         "investigates"            => 9531,
                         "investigations"          => 3484,
                         "investigative"           => 5864,
                         "investigators"           => 5724,
                         "investing"               => 7196,
                         "investiture"             => 15265,
                         "investment"              => 1564,
                         "investments"             => 3763,
                         "investor"                => 5259,
                         "investors"               => 3279,
                         "invests"                 => 15656,
                         "invicta"                 => 19055,
                         "invitational"            => 7633,
                         "invites"                 => 6657,
                         "invocation"              => 14531,
                         "invoked"                 => 8704,
                         "invokes"                 => 19002,
                         "involuntarily"           => 22376,
                         "involution"              => 27256,
                         "involved"                => 488,
                         "involvement"             => 2081,
                         "involves"                => 2428,
                         "involving"               => 1887,
                         "inward"                  => 10342,
                         "inwardly"                => 24632,
                         "inwards"                 => 16747,
                         "inwood"                  => 27991,
                         "ioannina"                => 19378,
                         "ioannis"                 => 16486,
                         "iodide"                  => 15211,
                         "iodine"                  => 10301,
                         "iommi"                   => 26927,
                         "ionia"                   => 21615,
                         "ionian"                  => 11877,
                         "ionic"                   => 8288,
                         "ionization"              => 12314,
                         "ionized"                 => 17903,
                         "ionizing"                => 17681,
                         "ionosphere"              => 20978,
                         "ionospheric"             => 29480,
                         "ions"                    => 5522,
                         "iorga"                   => 20656,
                         "iosif"                   => 25613,
                         "iowa"                    => 1736,
                         "iphigenia"               => 27649,
                         "iqbal"                   => 10280,
                         "iquique"                 => 27638,
                         "iraklis"                 => 20040,
                         "iran"                    => 954,
                         "irani"                   => 18920,
                         "iranian"                 => 2567,
                         "iranians"                => 11695,
                         "iraq"                    => 1726,
                         "iraqi"                   => 3107,
                         "iraqis"                  => 12649,
                         "ireland"                 => 555,
                         "irenaeus"                => 20516,
                         "irfan"                   => 22608,
                         "irgun"                   => 17228,
                         "iridescent"              => 18081,
                         "irises"                  => 22015,
                         "irish"                   => 734,
                         "irishmen"                => 18832,
                         "irkutsk"                 => 15991,
                         "iron"                    => 995,
                         "ironclads"               => 22951,
                         "ironi"                   => 26245,
                         "ironically"              => 5791,
                         "ironstone"               => 20534,
                         "ironwood"                => 25286,
                         "ironwork"                => 25375,
                         "ironworks"               => 11340,
                         "iroquoian"               => 29897,
                         "iroquois"                => 7876,
                         "irradiated"              => 22116,
                         "irradiation"             => 16179,
                         "irrawaddy"               => 19717,
                         "irreconcilable"          => 21472,
                         "irreducible"             => 12700,
                         "irregular"               => 4589,
                         "irregularities"          => 9441,
                         "irregularly"             => 11228,
                         "irregulars"              => 20300,
                         "irrespective"            => 11126,
                         "irreverent"              => 17979,
                         "irrigated"               => 11777,
                         "irrigation"              => 4356,
                         "irritant"                => 25839,
                         "irritation"              => 12781,
                         "irrorated"               => 21564,
                         "irtysh"                  => 28909,
                         "irvington"               => 22811,
                         "irwell"                  => 24504,
                         "is"                      => 6,
                         "isaak"                   => 20500,
                         "isambard"                => 29423,
                         "isbn"                    => 4108,
                         "ischemia"                => 20724,
                         "ischemic"                => 19443,
                         "isenburg"                => 24996,
                         "isere"                   => 18016,
                         "isfahan"                 => 8456,
                         "ishaq"                   => 17713,
                         "isidore"                 => 13582,
                         "ising"                   => 28695,
                         "iskandar"                => 20066,
                         "iskcon"                  => 22032,
                         "islam"                   => 2297,
                         "islamabad"               => 9142,
                         "islami"                  => 14945,
                         "islamia"                 => 23384,
                         "islamic"                 => 1699,
                         "islamism"                => 28169,
                         "islamist"                => 8873,
                         "islamists"               => 16105,
                         "island"                  => 248,
                         "islanders"               => 5953,
                         "islands"                 => 708,
                         "islay"                   => 19679,
                         "isle"                    => 3225,
                         "isles"                   => 5009,
                         "islet"                   => 11029,
                         "islets"                  => 11912,
                         "isleworth"               => 29150,
                         "islington"               => 10159,
                         "islip"                   => 20007,
                         "isma'il"                 => 26783,
                         "ismaili"                 => 18679,
                         "ismailis"                => 27158,
                         "iso/iec"                 => 12523,
                         "isoform"                 => 21035,
                         "isoforms"                => 14390,
                         "isolated"                => 2622,
                         "isolates"                => 16950,
                         "isolating"               => 14174,
                         "isolation"               => 4767,
                         "isolationist"            => 27200,
                         "isomer"                  => 16211,
                         "isomerase"               => 26449,
                         "isomers"                 => 16132,
                         "isometric"               => 17852,
                         "isometry"                => 28465,
                         "isomorphic"              => 11507,
                         "isomorphism"             => 12504,
                         "isotope"                 => 9311,
                         "isotopes"                => 8971,
                         "isotopic"                => 17630,
                         "isotropic"               => 17824,
                         "israeli"                 => 1677,
                         "israelis"                => 8939,
                         "israelite"               => 14151,
                         "israelites"              => 9754,
                         "issuance"                => 10972,
                         "issue"                   => 695,
                         "issued"                  => 921,
                         "issuer"                  => 19091,
                         "issuers"                 => 22356,
                         "issues"                  => 657,
                         "issuing"                 => 5603,
                         "istana"                  => 28266,
                         "isthmian"                => 13082,
                         "isthmus"                 => 10077,
                         "istituto"                => 20125,
                         "istria"                  => 15238,
                         "istvan"                  => 11890,
                         "isuzu"                   => 15849,
                         "italian"                 => 559,
                         "italiana"                => 11775,
                         "italianate"              => 9205,
                         "italians"                => 5968,
                         "italic"                  => 13535,
                         "italics"                 => 9341,
                         "italo"                   => 12064,
                         "italy"                   => 686,
                         "itasca"                  => 25441,
                         "items"                   => 1709,
                         "iterated"                => 22928,
                         "iteration"               => 9613,
                         "iterations"              => 14248,
                         "iterative"               => 14938,
                         "ithaca"                  => 9559,
                         "itinerant"               => 12578,
                         "its"                     => 29,
                         "itself"                  => 580,
                         "ittihad"                 => 19010,
                         "itunes"                  => 4099,
                         "iturbide"                => 23912,
                         "iulia"                   => 25418,
                         "iupac"                   => 20529,
                         "ivano"                   => 20973,
                         "ivanovic"                => 16568,
                         "ivanovich"               => 13463,
                         "ivanovo"                 => 25014,
                         "iveco"                   => 28468,
                         "ivica"                   => 25609,
                         "ivorian"                 => 16390,
                         "iwate"                   => 18488,
                         "iyengar"                 => 20641,
                         "izmir"                   => 10660,
                         "izumo"                   => 28697,
                         "ja'far"                  => 21219,
                         "jabal"                   => 15841,
                         "jabalpur"                => 18131,
                         "jacksonian"              => 21371,
                         "jacksonville"            => 4571,
                         "jacobean"                => 15774,
                         "jacobian"                => 27528,
                         "jacobin"                 => 23119,
                         "jacobins"                => 28213,
                         "jacobite"                => 9028,
                         "jacobites"               => 19558,
                         "jacopo"                  => 16122,
                         "jadid"                   => 22824,
                         "jaffna"                  => 11136,
                         "jagan"                   => 28471,
                         "jagannath"               => 15190,
                         "jagdgeschwader"          => 22584,
                         "jagiellon"               => 29140,
                         "jagiellonian"            => 20167,
                         "jahan"                   => 12568,
                         "jahangir"                => 14910,
                         "jailed"                  => 7330,
                         "jaina"                   => 28463,
                         "jainism"                 => 13075,
                         "jains"                   => 17205,
                         "jaipur"                  => 9450,
                         "jakob"                   => 7995,
                         "jakub"                   => 16224,
                         "jalal"                   => 14167,
                         "jalalabad"               => 21544,
                         "jalan"                   => 9875,
                         "jalandhar"               => 18401,
                         "jalgaon"                 => 29511,
                         "jalil"                   => 19750,
                         "jalisco"                 => 10395,
                         "jalpaiguri"              => 27067,
                         "jamaat"                  => 17089,
                         "jamaican"                => 6396,
                         "jamaicans"               => 29656,
                         "jamboree"                => 12838,
                         "jamestown"               => 8758,
                         "jamia"                   => 19490,
                         "jamil"                   => 18633,
                         "jammu"                   => 7768,
                         "jamshedpur"              => 27721,
                         "jamtland"                => 23531,
                         "jamuna"                  => 26102,
                         "janacek"                 => 20294,
                         "janaki"                  => 22573,
                         "janakpur"                => 26356,
                         "janata"                  => 9008,
                         "janeiro"                 => 4635,
                         "janesville"              => 24687,
                         "janez"                   => 22570,
                         "janissaries"             => 24594,
                         "janko"                   => 22042,
                         "jankovic"                => 15593,
                         "janos"                   => 12158,
                         "janow"                   => 26451,
                         "january"                 => 158,
                         "japan"                   => 458,
                         "japanese"                => 445,
                         "japonica"                => 17255,
                         "jardim"                  => 27510,
                         "jaroslav"                => 14979,
                         "jaroslaw"                => 20332,
                         "jarrah"                  => 19714,
                         "jarre"                   => 23597,
                         "jarrow"                  => 22825,
                         "jasta"                   => 19703,
                         "jatin"                   => 26906,
                         "jatra"                   => 29167,
                         "jaume"                   => 25442,
                         "javan"                   => 22625,
                         "javanese"                => 8879,
                         "javascript"              => 10565,
                         "javed"                   => 15882,
                         "jawahar"                 => 23009,
                         "jawaharlal"              => 12173,
                         "jayanti"                 => 26438,
                         "jayaram"                 => 28210,
                         "jazeera"                 => 10176,
                         "jazira"                  => 29339,
                         "jazz"                    => 1108,
                         "jcpenney"                => 20893,
                         "jebel"                   => 18860,
                         "jeddah"                  => 14286,
                         "jedrzejow"               => 28258,
                         "jeeva"                   => 28442,
                         "jeevan"                  => 25447,
                         "jeezy"                   => 24031,
                         "jeffersonian"            => 29371,
                         "jeffersonville"          => 26452,
                         "jehan"                   => 21160,
                         "jekyll"                  => 13878,
                         "jellicoe"                => 24557,
                         "jenin"                   => 22146,
                         "jeolla"                  => 29299,
                         "jeong"                   => 12794,
                         "jermyn"                  => 27906,
                         "jersey"                  => 918,
                         "jerseys"                 => 9188,
                         "jerusalem"               => 2294,
                         "jerzy"                   => 10866,
                         "jessore"                 => 28741,
                         "jesuit"                  => 4807,
                         "jesuits"                 => 6921,
                         "jetties"                 => 28304,
                         "jettisoned"              => 23709,
                         "jetty"                   => 12212,
                         "jeunesse"                => 23455,
                         "jeweller"                => 20858,
                         "jewellers"               => 26907,
                         "jewellery"               => 7524,
                         "jewish"                  => 805,
                         "jewry"                   => 14150,
                         "jews"                    => 1493,
                         "jhansi"                  => 19664,
                         "jharkhand"               => 11023,
                         "jhelum"                  => 17950,
                         "jiangsu"                 => 9248,
                         "jiangxi"                 => 12195,
                         "jiedushi"                => 27659,
                         "jigme"                   => 24086,
                         "jihad"                   => 8371,
                         "jihadist"                => 23367,
                         "jihlava"                 => 20746,
                         "jilin"                   => 15555,
                         "jinan"                   => 19077,
                         "jindal"                  => 17844,
                         "jinja"                   => 22072,
                         "jinnah"                  => 13161,
                         "jinping"                 => 29714,
                         "jintao"                  => 26711,
                         "jirga"                   => 27156,
                         "jiroft"                  => 23832,
                         "jitsu"                   => 12081,
                         "joachim"                 => 6784,
                         "joannes"                 => 27502,
                         "joaquim"                 => 15230,
                         "jobim"                   => 29342,
                         "jodhpur"                 => 14713,
                         "joffre"                  => 21193,
                         "joffrey"                 => 25714,
                         "jogaila"                 => 26006,
                         "johan"                   => 5145,
                         "johannesburg"            => 6076,
                         "johar"                   => 24953,
                         "johnsons"                => 26112,
                         "johnstown"               => 11879,
                         "johor"                   => 9016,
                         "joined"                  => 314,
                         "joinery"                 => 23973,
                         "joining"                 => 1644,
                         "joins"                   => 3571,
                         "joint"                   => 1092,
                         "jointly"                 => 3884,
                         "joinville"               => 23700,
                         "joked"                   => 12749,
                         "jokingly"                => 12088,
                         "jolgeh"                  => 22864,
                         "jomon"                   => 28817,
                         "jonesboro"               => 17660,
                         "jonkoping"               => 24244,
                         "jonsson"                 => 14322,
                         "jonubi"                  => 12573,
                         "jools"                   => 22423,
                         "joost"                   => 22442,
                         "jordanian"               => 8857,
                         "jordi"                   => 16144,
                         "jorgen"                  => 12351,
                         "jorhat"                  => 28085,
                         "joris"                   => 22912,
                         "jorma"                   => 28810,
                         "joseon"                  => 9901,
                         "josephus"                => 12040,
                         "josias"                  => 28555,
                         "josip"                   => 12682,
                         "joule"                   => 22971,
                         "journal"                 => 886,
                         "journalism"              => 2704,
                         "journalist"              => 1574,
                         "journalistic"            => 9587,
                         "journalists"             => 3144,
                         "journals"                => 3223,
                         "journey"                 => 1888,
                         "journeyed"               => 14688,
                         "journeying"              => 27952,
                         "journeyman"              => 14603,
                         "journeys"                => 7012,
                         "jousting"                => 28918,
                         "jovanovic"               => 16915,
                         "jovial"                  => 28361,
                         "jovian"                  => 27242,
                         "jozef"                   => 8241,
                         "jozsef"                  => 15063,
                         "jpmorgan"                => 21111,
                         "jrotc"                   => 23682,
                         "jubal"                   => 29509,
                         "jubilant"                => 29580,
                         "judah"                   => 7793,
                         "judaic"                  => 22641,
                         "judaism"                 => 4419,
                         "judea"                   => 15381,
                         "judean"                  => 22031,
                         "judeo"                   => 17280,
                         "judged"                  => 5164,
                         "judgements"              => 17846,
                         "judges"                  => 2200,
                         "judgeship"               => 23859,
                         "judicature"              => 25592,
                         "judicial"                => 2688,
                         "judiciary"               => 5265,
                         "judicious"               => 26368,
                         "judoka"                  => 12261,
                         "jujutsu"                 => 26056,
                         "jujuy"                   => 24771,
                         "jukka"                   => 27356,
                         "julich"                  => 19981,
                         "july"                    => 156,
                         "jumpers"                 => 14562,
                         "junagadh"                => 25050,
                         "junction"                => 1582,
                         "junctions"               => 8680,
                         "june"                    => 149,
                         "jungian"                 => 26893,
                         "juniata"                 => 19203,
                         "junin"                   => 25094,
                         "junior/senior"           => 29943,
                         "juniors"                 => 6093,
                         "juniperus"               => 24446,
                         "junius"                  => 16091,
                         "junkers"                 => 11839,
                         "junta"                   => 7338,
                         "juraj"                   => 23993,
                         "jurchen"                 => 18942,
                         "jurchens"                => 28500,
                         "jurgen"                  => 9331,
                         "juridical"               => 18363,
                         "juried"                  => 26892,
                         "juris"                   => 9797,
                         "jurisdiction"            => 2500,
                         "jurisdictional"          => 14780,
                         "jurisdictions"           => 5742,
                         "jurisprudence"           => 8337,
                         "jurist"                  => 8055,
                         "jurists"                 => 14401,
                         "jurong"                  => 18676,
                         "juryo"                   => 24476,
                         "jussi"                   => 24118,
                         "justices"                => 6568,
                         "justicia"                => 28704,
                         "justiciar"               => 29118,
                         "justification"           => 7178,
                         "justifications"          => 22035,
                         "justinian"               => 10853,
                         "justly"                  => 20836,
                         "justo"                   => 18481,
                         "jutland"                 => 10307,
                         "jutting"                 => 27381,
                         "juvenal"                 => 24188,
                         "juveniles"               => 8436,
                         "juventud"                => 18162,
                         "juxtaposed"              => 17980,
                         "juxtaposition"           => 17635,
                         "jyoti"                   => 18794,
                         "jyvaskyla"               => 24777,
                         "k'iche"                  => 26933,
                         "kabaddi"                 => 21641,
                         "kabbalah"                => 13739,
                         "kabbalistic"             => 22671,
                         "kabhi"                   => 26402,
                         "kabila"                  => 24012,
                         "kabir"                   => 12090,
                         "kabud"                   => 27442,
                         "kabul"                   => 6939,
                         "kachin"                  => 17590,
                         "kadir"                   => 29227,
                         "kadokawa"                => 20853,
                         "kaduna"                  => 19778,
                         "kagame"                  => 28679,
                         "kagoshima"               => 13803,
                         "kagyu"                   => 21775,
                         "kahane"                  => 27542,
                         "kahlo"                   => 26921,
                         "kahne"                   => 18884,
                         "kaifeng"                 => 18353,
                         "kailash"                 => 19342,
                         "kaine"                   => 19774,
                         "kaiserliche"             => 28267,
                         "kaiserslautern"          => 13745,
                         "kakheti"                 => 20272,
                         "kakinada"                => 29453,
                         "kalahari"                => 21895,
                         "kalakaua"                => 26638,
                         "kalam"                   => 15292,
                         "kalamazoo"               => 10675,
                         "kalan"                   => 16359,
                         "kalat"                   => 20931,
                         "kalateh"                 => 13968,
                         "kalevala"                => 27924,
                         "kalgoorlie"              => 19036,
                         "kalimantan"              => 14905,
                         "kalinga"                 => 15130,
                         "kaliningrad"             => 12619,
                         "kalisz"                  => 16318,
                         "kalki"                   => 28576,
                         "kalmar"                  => 14827,
                         "kalyan"                  => 13977,
                         "kamakura"                => 12960,
                         "kamboja"                 => 29772,
                         "kambojas"                => 26815,
                         "kamchatka"               => 16049,
                         "kamen"                   => 8740,
                         "kamien"                  => 23909,
                         "kamloops"                => 16063,
                         "kampala"                 => 11801,
                         "kampong"                 => 17430,
                         "kampuchea"               => 22222,
                         "kampung"                 => 16583,
                         "kamui"                   => 29409,
                         "kanaan"                  => 22433,
                         "kanagawa"                => 12153,
                         "kanal"                   => 18694,
                         "kanata"                  => 25813,
                         "kanawha"                 => 15112,
                         "kanazawa"                => 21425,
                         "kanchipuram"             => 23180,
                         "kanda"                   => 17562,
                         "kandahar"                => 11617,
                         "kandinsky"               => 23634,
                         "kandyan"                 => 29015,
                         "kangaroos"               => 11493,
                         "kangra"                  => 25271,
                         "kangxi"                  => 16784,
                         "kanji"                   => 10486,
                         "kankakee"                => 20065,
                         "kannada"                 => 5069,
                         "kannur"                  => 15707,
                         "kanon"                   => 26800,
                         "kanpur"                  => 11734,
                         "kansai"                  => 15138,
                         "kantakouzenos"           => 26025,
                         "kantian"                 => 26612,
                         "kanto"                   => 14325,
                         "kanya"                   => 29699,
                         "kanyakumari"             => 17911,
                         "kanye"                   => 10980,
                         "kaohsiung"               => 12839,
                         "kaori"                   => 23710,
                         "kaoru"                   => 18854,
                         "kapellmeister"           => 24279,
                         "kapil"                   => 24090,
                         "kapitanleutnant"         => 25678,
                         "kapoor"                  => 7239,
                         "karabakh"                => 9728,
                         "karadzic"                => 22602,
                         "karaite"                 => 29541,
                         "karakoram"               => 24737,
                         "karbala"                 => 18914,
                         "kardashian"              => 25869,
                         "kardzhali"               => 24486,
                         "karel"                   => 9842,
                         "karelia"                 => 15136,
                         "karelian"                => 17876,
                         "kargil"                  => 20372,
                         "karimabad"               => 29526,
                         "karimnagar"              => 27651,
                         "karlheinz"               => 22696,
                         "karlovac"                => 26508,
                         "karlovy"                 => 21451,
                         "karlsruhe"               => 9675,
                         "karmapa"                 => 25515,
                         "karna"                   => 19362,
                         "karnak"                  => 25058,
                         "karnataka"               => 4122,
                         "karoly"                  => 20544,
                         "karoo"                   => 18073,
                         "kartik"                  => 24435,
                         "kartli"                  => 17296,
                         "karts"                   => 23333,
                         "kartuzy"                 => 22390,
                         "karunanidhi"             => 28751,
                         "karur"                   => 28853,
                         "karzai"                  => 13767,
                         "kasai"                   => 20304,
                         "kasaragod"               => 27187,
                         "kasem"                   => 28041,
                         "kashgar"                 => 18643,
                         "kashi"                   => 18496,
                         "kashima"                 => 22754,
                         "kashmiri"                => 12750,
                         "kashubian"               => 26383,
                         "kashyap"                 => 22609,
                         "kasim"                   => 27413,
                         "kaskaskia"               => 26903,
                         "kassel"                  => 9787,
                         "kastamonu"               => 27945,
                         "katakana"                => 21241,
                         "katanga"                 => 16749,
                         "katarzyna"               => 25345,
                         "katha"                   => 15925,
                         "kathak"                  => 27398,
                         "kathakali"               => 24607,
                         "kathmandu"               => 9417,
                         "katipunan"               => 22743,
                         "katowice"                => 11701,
                         "katsina"                 => 29011,
                         "katyn"                   => 27550,
                         "kauai"                   => 13515,
                         "kaunas"                  => 10581,
                         "kauri"                   => 28973,
                         "kavala"                  => 26669,
                         "kaveri"                  => 19698,
                         "kavya"                   => 29317,
                         "kayfabe"                 => 27792,
                         "kayseri"                 => 26367,
                         "kazakh"                  => 9895,
                         "kazakhs"                 => 24613,
                         "kazakhstan"              => 4535,
                         "kazakhstani"             => 21235,
                         "kazan"                   => 7742,
                         "kazhagam"                => 15843,
                         "kazim"                   => 28503,
                         "kazimierz"               => 12139,
                         "kazuki"                  => 25951,
                         "kbit/s"                  => 15895,
                         "kearny"                  => 14427,
                         "kebir"                   => 24778,
                         "keble"                   => 22624,
                         "kedah"                   => 13918,
                         "keelung"                 => 24657,
                         "keeneland"               => 28948,
                         "keenly"                  => 19475,
                         "keighley"                => 16478,
                         "keiji"                   => 24612,
                         "keisei"                  => 28941,
                         "keisuke"                 => 28238,
                         "keita"                   => 16436,
                         "kelantan"                => 14844,
                         "kelis"                   => 28111,
                         "kelowna"                 => 16687,
                         "kemal"                   => 12186,
                         "kempe"                   => 19836,
                         "kenai"                   => 24073,
                         "kendriya"                => 28033,
                         "kenilworth"              => 15492,
                         "kennebec"                => 20306,
                         "kennels"                 => 28583,
                         "kennesaw"                => 20804,
                         "kenora"                  => 21599,
                         "kenrick"                 => 23394,
                         "kensal"                  => 23652,
                         "kenseth"                 => 16339,
                         "kensington"              => 6488,
                         "kenta"                   => 25788,
                         "kentish"                 => 15908,
                         "kentucky"                => 1585,
                         "kenyan"                  => 6996,
                         "kenyans"                 => 29307,
                         "kenzo"                   => 26530,
                         "keokuk"                  => 24946,
                         "kerala"                  => 3055,
                         "keratin"                 => 22603,
                         "kerch"                   => 25679,
                         "kerman"                  => 6727,
                         "kermanshah"              => 9423,
                         "kernels"                 => 15537,
                         "kerrang"                 => 14630,
                         "keselowski"              => 17416,
                         "kesteven"                => 23220,
                         "keswick"                 => 17700,
                         "ketchikan"               => 28885,
                         "ketone"                  => 17048,
                         "ketones"                 => 20706,
                         "ketrzyn"                 => 27330,
                         "kettering"               => 11013,
                         "keyboardist"             => 7083,
                         "keyboards"               => 4726,
                         "keying"                  => 25878,
                         "keynes"                  => 7760,
                         "keynesian"               => 16736,
                         "keynote"                 => 8838,
                         "keyong"                  => 17696,
                         "keystones"               => 28040,
                         "keyword"                 => 14418,
                         "keywords"                => 16002,
                         "khabarovsk"              => 19654,
                         "khadr"                   => 25439,
                         "khagan"                  => 25716,
                         "khaganate"               => 26398,
                         "khaimah"                 => 29293,
                         "khaki"                   => 15703,
                         "khaldun"                 => 29993,
                         "khali"                   => 24356,
                         "khalidi"                 => 29719,
                         "khalifa"                 => 9507,
                         "khamenei"                => 22963,
                         "khana"                   => 29288,
                         "khanate"                 => 10882,
                         "khaneh"                  => 23787,
                         "khanh"                   => 14264,
                         "khani"                   => 20738,
                         "khans"                   => 20892,
                         "khanty"                  => 26639,
                         "khanum"                  => 26234,
                         "kharagpur"               => 21816,
                         "kharkiv"                 => 10662,
                         "kharkov"                 => 16811,
                         "khartoum"                => 12588,
                         "khash"                   => 29773,
                         "khasi"                   => 26513,
                         "khatami"                 => 22238,
                         "khatib"                  => 26966,
                         "khattab"                 => 28279,
                         "khattak"                 => 27291,
                         "khatun"                  => 24810,
                         "khawaja"                 => 23438,
                         "khayyam"                 => 25567,
                         "khazar"                  => 17075,
                         "khazars"                 => 23572,
                         "khedive"                 => 26819,
                         "kheil"                   => 18180,
                         "kherson"                 => 26764,
                         "kheyrabad"               => 28378,
                         "khilji"                  => 26972,
                         "khitan"                  => 15367,
                         "khlong"                  => 27950,
                         "khmelnytsky"             => 23868,
                         "khmer"                   => 6930,
                         "khoja"                   => 27448,
                         "khomeini"                => 13229,
                         "khorasan"                => 6191,
                         "khorramabad"             => 20018,
                         "khosrau"                 => 23631,
                         "khosrow"                 => 25348,
                         "khrushchev"              => 10407,
                         "khufu"                   => 27740,
                         "khulna"                  => 20567,
                         "khurasan"                => 25388,
                         "khurd"                   => 24572,
                         "khuzestan"               => 8326,
                         "khvajeh"                 => 27801,
                         "khwaja"                  => 18675,
                         "khyber"                  => 9150,
                         "kibaki"                  => 25434,
                         "kibbutz"                 => 9935,
                         "kibbutzim"               => 29647,
                         "kickapoo"                => 22615,
                         "kickboxer"               => 19622,
                         "kickboxing"              => 11668,
                         "kickers"                 => 13948,
                         "kickoff"                 => 7864,
                         "kickoffs"                => 22840,
                         "kickstarter"             => 11262,
                         "kidderminster"           => 14178,
                         "kiedis"                  => 25036,
                         "kielce"                  => 10594,
                         "kierkegaard"             => 13714,
                         "kieron"                  => 28401,
                         "kiev"                    => 4619,
                         "kievan"                  => 15678,
                         "kigali"                  => 21488,
                         "kikuchi"                 => 20450,
                         "kikuyu"                  => 23779,
                         "kilda"                   => 7954,
                         "kildare"                 => 8203,
                         "kilimanjaro"             => 18144,
                         "kilkenny"                => 5770,
                         "killarney"               => 17128,
                         "killings"                => 6079,
                         "kilmarnock"              => 10289,
                         "kilmore"                 => 21978,
                         "kilns"                   => 14245,
                         "kilogram"                => 13871,
                         "kilograms"               => 9415,
                         "kilometer"               => 7766,
                         "kilometers"              => 3056,
                         "kilometre"               => 7361,
                         "kilometres"              => 3222,
                         "kilowatt"                => 16092,
                         "kilowatts"               => 20498,
                         "kilwinning"              => 27410,
                         "kinabalu"                => 19612,
                         "kinase"                  => 7430,
                         "kinases"                 => 15698,
                         "kincardine"              => 24016,
                         "kindergarten"            => 4334,
                         "kindergartens"           => 18682,
                         "kinect"                  => 22814,
                         "kinematic"               => 24319,
                         "kinematics"              => 27885,
                         "kinesiology"             => 28380,
                         "kinetic"                 => 7151,
                         "kinetics"                => 14855,
                         "kingdom"                 => 477,
                         "kingdoms"                => 4380,
                         "kingfishers"             => 18804,
                         "kings"                   => 1750,
                         "kingship"                => 11509,
                         "kingsmill"               => 29355,
                         "kingsport"               => 23807,
                         "kingstown"               => 22009,
                         "kingsville"              => 27948,
                         "kingsway"                => 18221,
                         "kingswood"               => 18211,
                         "kinnock"                 => 29060,
                         "kinsale"                 => 25260,
                         "kinshasa"                => 14696,
                         "kinship"                 => 9855,
                         "kinsmen"                 => 19973,
                         "kinston"                 => 25004,
                         "kintetsu"                => 19505,
                         "kintyre"                 => 27490,
                         "kiosks"                  => 15436,
                         "kiowa"                   => 14290,
                         "kirchberg"               => 29758,
                         "kirche"                  => 24125,
                         "kiribati"                => 13684,
                         "kirilenko"               => 27644,
                         "kirin"                   => 23521,
                         "kirkby"                  => 15274,
                         "kirkcaldy"               => 21586,
                         "kirke"                   => 21080,
                         "kirkuk"                  => 20021,
                         "kirkus"                  => 15840,
                         "kirov"                   => 14842,
                         "kirtland"                => 16215,
                         "kiryat"                  => 15268,
                         "kisan"                   => 24286,
                         "kishan"                  => 24375,
                         "kissimmee"               => 24568,
                         "kisumu"                  => 27106,
                         "kitab"                   => 18234,
                         "kitano"                  => 28838,
                         "kitchener"               => 9211,
                         "kites"                   => 12545,
                         "kitsap"                  => 24108,
                         "kitsch"                  => 22277,
                         "kitzbuhel"               => 27258,
                         "kiwis"                   => 15859,
                         "kiyoshi"                 => 22880,
                         "kjell"                   => 18454,
                         "klagenfurt"              => 20694,
                         "klaipeda"                => 18548,
                         "klamath"                 => 12475,
                         "klang"                   => 13648,
                         "klasse"                  => 21970,
                         "klerk"                   => 29396,
                         "klezmer"                 => 21743,
                         "klitschko"               => 23299,
                         "klodzko"                 => 28799,
                         "km/h"                    => 3922,
                         "km/hr"                   => 24982,
                         "knesset"                 => 8506,
                         "knighted"                => 6531,
                         "knighthood"              => 11084,
                         "knightley"               => 22886,
                         "knightsbridge"           => 23949,
                         "knockout"                => 4182,
                         "knockouts"               => 17005,
                         "knowle"                  => 26821,
                         "knowledge"               => 1055,
                         "knowledgeable"           => 12020,
                         "known"                   => 66,
                         "knowsley"                => 20823,
                         "knoxville"               => 6672,
                         "kobani"                  => 28969,
                         "koblenz"                 => 14153,
                         "kochi"                   => 9199,
                         "kodagu"                  => 26603,
                         "kodansha"                => 16746,
                         "kohat"                   => 29587,
                         "kohgiluyeh"              => 12853,
                         "kohima"                  => 29963,
                         "kohlberg"                => 26009,
                         "kohneh"                  => 28187,
                         "koine"                   => 23962,
                         "koirala"                 => 24343,
                         "kokoda"                  => 27407,
                         "kolhapur"                => 18196,
                         "kolkata"                 => 5186,
                         "kollam"                  => 12307,
                         "kolmogorov"              => 23679,
                         "kolonia"                 => 10098,
                         "komnenos"                => 16443,
                         "komsomol"                => 24173,
                         "konami"                  => 12372,
                         "kong"                    => 1178,
                         "kongo"                   => 14120,
                         "kongsberg"               => 21539,
                         "kongsvinger"             => 28058,
                         "konig"                   => 15453,
                         "konigsberg"              => 10106,
                         "konin"                   => 18317,
                         "koninklijke"             => 26674,
                         "konkan"                  => 19221,
                         "konkani"                 => 12913,
                         "konnan"                  => 24569,
                         "konskie"                 => 29946,
                         "konstantinos"            => 17923,
                         "konstanz"                => 25556,
                         "kontinental"             => 15256,
                         "konya"                   => 19888,
                         "kooning"                 => 26364,
                         "kootenay"                => 14582,
                         "koper"                   => 19502,
                         "koppen"                  => 6836,
                         "korce"                   => 21345,
                         "korda"                   => 19359,
                         "korea"                   => 1270,
                         "korean"                  => 1371,
                         "koreans"                 => 7886,
                         "korfball"                => 28396,
                         "korps"                   => 20574,
                         "korra"                   => 26951,
                         "korsakov"                => 16225,
                         "kortrijk"                => 24171,
                         "koscierzyna"             => 27281,
                         "kosciuszko"              => 16076,
                         "koshi"                   => 25864,
                         "kosice"                  => 12980,
                         "kosovar"                 => 25785,
                         "kosovo"                  => 4054,
                         "kossuth"                 => 20493,
                         "kosta"                   => 26992,
                         "kostroma"                => 21063,
                         "koszalin"                => 22915,
                         "kotaro"                  => 28157,
                         "kothen"                  => 27627,
                         "kotor"                   => 19930,
                         "kottayam"                => 13300,
                         "kovalainen"              => 25016,
                         "kovil"                   => 23729,
                         "kowloon"                 => 10680,
                         "kozhikode"               => 15050,
                         "kraftwerk"               => 20297,
                         "kragujevac"              => 20953,
                         "krajina"                 => 18135,
                         "krajowa"                 => 27027,
                         "krakow"                  => 5210,
                         "kralove"                 => 20935,
                         "kramnik"                 => 26510,
                         "krasinski"               => 25516,
                         "krasnoyarsk"             => 17184,
                         "krautrock"               => 28533,
                         "krefeld"                 => 24837,
                         "kreis"                   => 12844,
                         "kreuzberg"               => 27620,
                         "kreuznach"               => 21598,
                         "kriegsmarine"            => 11568,
                         "kripke"                  => 23040,
                         "krishnamurthy"           => 29151,
                         "krishnamurti"            => 28571,
                         "kristallnacht"           => 26463,
                         "kristiania"              => 16636,
                         "kristiansand"            => 15755,
                         "kristiansund"            => 29107,
                         "kristofferson"           => 22678,
                         "krona"                   => 26557,
                         "kronecker"               => 28713,
                         "kronstadt"               => 20879,
                         "kropotkin"               => 27993,
                         "krosno"                  => 22491,
                         "kryptonian"              => 25753,
                         "krzysztof"               => 13426,
                         "kshatriya"               => 19889,
                         "kuala"                   => 5917,
                         "kuban"                   => 15770,
                         "kubica"                  => 24154,
                         "kublai"                  => 16902,
                         "kuching"                 => 18085,
                         "kucinich"                => 26728,
                         "kulkarni"                => 21991,
                         "kultur"                  => 28189,
                         "kumamoto"                => 15523,
                         "kumanovo"                => 24481,
                         "kumaon"                  => 23421,
                         "kumara"                  => 21152,
                         "kumasi"                  => 18761,
                         "kumbakonam"              => 21992,
                         "kunal"                   => 24076,
                         "kunming"                 => 15567,
                         "kunste"                  => 23893,
                         "kunsthalle"              => 22205,
                         "kuomintang"              => 10593,
                         "kuopio"                  => 29792,
                         "kurdish"                 => 5824,
                         "kurdistan"               => 7572,
                         "kurds"                   => 10110,
                         "kuril"                   => 23186,
                         "kurnool"                 => 26361,
                         "kuroda"                  => 22088,
                         "kursk"                   => 14750,
                         "kurukshetra"             => 21138,
                         "kurzweil"                => 23827,
                         "kushan"                  => 24859,
                         "kutaisi"                 => 29878,
                         "kutno"                   => 20660,
                         "kutuzov"                 => 29188,
                         "kuwait"                  => 4856,
                         "kuwaiti"                 => 12042,
                         "kuyavian"                => 9127,
                         "kuznetsov"               => 17730,
                         "kuznetsova"              => 21518,
                         "kvitova"                 => 27959,
                         "kwajalein"               => 17346,
                         "kwame"                   => 17165,
                         "kwazulu"                 => 11983,
                         "kweli"                   => 28715,
                         "kyoto"                   => 5765,
                         "kyrgyz"                  => 12993,
                         "kyrgyzstan"              => 8032,
                         "kyrie"                   => 26506,
                         "kyushu"                  => 9523,
                         "l'air"                   => 27519,
                         "l'aquila"                => 21793,
                         "l'arc"                   => 18314,
                         "l'art"                   => 21820,
                         "l'ecole"                 => 20961,
                         "l'enfant"                => 20452,
                         "l'histoire"              => 26319,
                         "l'homme"                 => 19919,
                         "l'isle"                  => 24772,
                         "l'oeil"                  => 26032,
                         "l'ordre"                 => 25950,
                         "l'oreal"                 => 22507,
                         "laane"                   => 19642,
                         "laban"                   => 17986,
                         "label"                   => 854,
                         "labeled"                 => 4776,
                         "labeling"                => 9329,
                         "labelled"                => 6423,
                         "labelling"               => 14937,
                         "labels"                  => 3659,
                         "labem"                   => 20618,
                         "labial"                  => 18899,
                         "labor"                   => 1226,
                         "laboratories"            => 4193,
                         "laboratory"              => 1987,
                         "laborer"                 => 15024,
                         "laborers"                => 8066,
                         "laborious"               => 21675,
                         "labors"                  => 20335,
                         "labour"                  => 1200,
                         "labourer"                => 13875,
                         "labourers"               => 8231,
                         "labours"                 => 18764,
                         "labs"                    => 5161,
                         "labuan"                  => 22056,
                         "labyrinth"               => 10550,
                         "lacan"                   => 20209,
                         "lachaise"                => 26911,
                         "lachine"                 => 28328,
                         "lachlan"                 => 14880,
                         "lack"                    => 1009,
                         "lackawanna"              => 12287,
                         "lacked"                  => 4270,
                         "lacking"                 => 4376,
                         "lackluster"              => 16188,
                         "lacks"                   => 5155,
                         "laconia"                 => 20213,
                         "lactarius"               => 25934,
                         "lactation"               => 23383,
                         "lactobacillus"           => 28563,
                         "lacunae"                 => 26083,
                         "ladakh"                  => 15334,
                         "ladders"                 => 13146,
                         "laden"                   => 6135,
                         "ladin"                   => 28868,
                         "ladino"                  => 29629,
                         "ladislaus"               => 15255,
                         "ladislav"                => 22272,
                         "ladysmith"               => 21216,
                         "lafitte"                 => 27713,
                         "lagging"                 => 16005,
                         "lagoa"                   => 25820,
                         "lagoon"                  => 5744,
                         "lagoons"                 => 12402,
                         "lagos"                   => 6471,
                         "lagrangian"              => 14361,
                         "lahiri"                  => 23858,
                         "lahore"                  => 5295,
                         "laid"                    => 1573,
                         "laissez"                 => 18199,
                         "laity"                   => 13681,
                         "lajos"                   => 17795,
                         "lake"                    => 372,
                         "lakes"                   => 2010,
                         "lakeshore"               => 12841,
                         "lakeville"               => 25458,
                         "lakhs"                   => 17606,
                         "lakshman"                => 24333,
                         "lakshmana"               => 26156,
                         "lambton"                 => 16538,
                         "lamellar"                => 29544,
                         "lamentation"             => 29313,
                         "lamentations"            => 29270,
                         "lamented"                => 13370,
                         "lamenting"               => 19760,
                         "laments"                 => 15037,
                         "lamia"                   => 21588,
                         "lamiinae"                => 19892,
                         "lamina"                  => 17855,
                         "laminar"                 => 20187,
                         "laminate"                => 25939,
                         "lammermoor"              => 27561,
                         "lampeter"                => 25708,
                         "lampooned"               => 26304,
                         "lamprey"                 => 24581,
                         "lamps"                   => 6270,
                         "lanao"                   => 21837,
                         "lanark"                  => 15028,
                         "lanarkshire"             => 11604,
                         "lancashire"              => 3229,
                         "lancastrian"             => 21632,
                         "lanceolate"              => 15243,
                         "lancet"                  => 12033,
                         "lanchester"              => 23847,
                         "lancing"                 => 29145,
                         "land"                    => 246,
                         "landed"                  => 2576,
                         "landesliga"              => 15812,
                         "landfall"                => 6832,
                         "landfill"                => 9249,
                         "landfills"               => 19633,
                         "landform"                => 25293,
                         "landforms"               => 19877,
                         "landgrave"               => 16685,
                         "landholders"             => 23916,
                         "landholdings"            => 22211,
                         "landing"                 => 1737,
                         "landings"                => 5648,
                         "landkreis"               => 26307,
                         "landless"                => 18015,
                         "landline"                => 20004,
                         "landlocked"              => 16491,
                         "landlords"               => 9781,
                         "landmark"                => 2856,
                         "landmarks"               => 4587,
                         "landmass"                => 20533,
                         "landmine"                => 24780,
                         "landowner"               => 7106,
                         "landowners"              => 6729,
                         "landowning"              => 26876,
                         "landrieu"                => 28305,
                         "lands"                   => 1508,
                         "landscape"               => 2137,
                         "landscaped"              => 11290,
                         "landscapes"              => 4762,
                         "landscaping"             => 9869,
                         "landshut"                => 20467,
                         "landskrona"              => 29146,
                         "landslide"               => 7046,
                         "landslides"              => 11991,
                         "landtag"                 => 17122,
                         "landward"                => 26293,
                         "lanes"                   => 4032,
                         "langa"                   => 25109,
                         "langlands"               => 28260,
                         "langmuir"                => 29546,
                         "language"                => 319,
                         "languages"               => 962,
                         "langue"                  => 22473,
                         "languedoc"               => 14650,
                         "languished"              => 21920,
                         "lanka"                   => 2392,
                         "lankan"                  => 5571,
                         "lankans"                 => 29213,
                         "lansdowne"               => 12678,
                         "lansky"                  => 23277,
                         "lanus"                   => 27124,
                         "lanzhou"                 => 22901,
                         "laoghaire"               => 21293,
                         "laois"                   => 13720,
                         "laos"                    => 5673,
                         "laotian"                 => 15352,
                         "laparoscopic"            => 27454,
                         "lapis"                   => 24895,
                         "laplace"                 => 13148,
                         "laplacian"               => 26446,
                         "lapland"                 => 17325,
                         "lapped"                  => 27982,
                         "laps"                    => 4534,
                         "laptops"                 => 12280,
                         "large"                   => 189,
                         "largely"                 => 1062,
                         "largemouth"              => 19725,
                         "larger"                  => 750,
                         "largest"                 => 422,
                         "largs"                   => 28651,
                         "larks"                   => 21906,
                         "larnaca"                 => 19180,
                         "larne"                   => 20601,
                         "larouche"                => 17303,
                         "larva"                   => 9725,
                         "larvae"                  => 3146,
                         "larval"                  => 10549,
                         "larvik"                  => 23563,
                         "laryngeal"               => 22568,
                         "lascelles"               => 24813,
                         "laserdisc"               => 16547,
                         "lashkar"                 => 21706,
                         "laski"                   => 27762,
                         "lasted"                  => 2130,
                         "lasting"                 => 3527,
                         "lastly"                  => 8397,
                         "latakia"                 => 24629,
                         "late"                    => 234,
                         "latency"                 => 11698,
                         "latent"                  => 10308,
                         "later"                   => 58,
                         "lateral"                 => 4220,
                         "laterally"               => 11407,
                         "lateran"                 => 15194,
                         "laterite"                => 22855,
                         "lathes"                  => 28859,
                         "latif"                   => 16320,
                         "latifah"                 => 23575,
                         "latin"                   => 916,
                         "latinized"               => 19559,
                         "latins"                  => 22022,
                         "latitude"                => 4943,
                         "latitudes"               => 10912,
                         "latium"                  => 23842,
                         "latrobe"                 => 14002,
                         "latter"                  => 839,
                         "latterly"                => 12976,
                         "lattice"                 => 6203,
                         "lattices"                => 17859,
                         "latur"                   => 28193,
                         "latvia"                  => 4556,
                         "latvian"                 => 5437,
                         "latvians"                => 25954,
                         "lauda"                   => 17197,
                         "laude"                   => 7322,
                         "lauded"                  => 8912,
                         "lauenburg"               => 19088,
                         "launceston"              => 10677,
                         "launch"                  => 1421,
                         "launched"                => 691,
                         "launcher"                => 8856,
                         "launchers"               => 10249,
                         "launches"                => 6848,
                         "launching"               => 4477,
                         "lauper"                  => 17760,
                         "laureate"                => 7162,
                         "laureates"               => 13891,
                         "laurens"                 => 15299,
                         "laurentian"              => 19510,
                         "laurier"                 => 13245,
                         "lausanne"                => 8242,
                         "lautrec"                 => 29542,
                         "lava"                    => 5526,
                         "laval"                   => 8987,
                         "lavas"                   => 21924,
                         "lavish"                  => 8632,
                         "lavishly"                => 17905,
                         "lavoisier"               => 28574,
                         "lavra"                   => 26244,
                         "law"                     => 206,
                         "lawlessness"             => 22189,
                         "lawmaker"                => 25352,
                         "lawmakers"               => 11881,
                         "lawrenceville"           => 19539,
                         "laws"                    => 1186,
                         "laxmi"                   => 19297,
                         "layer"                   => 2434,
                         "layered"                 => 8421,
                         "layering"                => 17401,
                         "layers"                  => 3546,
                         "laymen"                  => 16394,
                         "layoff"                  => 27961,
                         "layoffs"                 => 17998,
                         "layout"                  => 3092,
                         "layouts"                 => 11865,
                         "lazier"                  => 26034,
                         "lazio"                   => 9409,
                         "leaching"                => 20584,
                         "lead"                    => 389,
                         "leaded"                  => 21849,
                         "leader"                  => 584,
                         "leaderboard"             => 23393,
                         "leaders"                 => 984,
                         "leadership"              => 972,
                         "leading"                 => 457,
                         "leadoff"                 => 23707,
                         "leads"                   => 1747,
                         "leadville"               => 25200,
                         "leaf"                    => 2605,
                         "leaflet"                 => 16117,
                         "leaflets"                => 8880,
                         "league"                  => 120,
                         "leaguer"                 => 19179,
                         "leaguers"                => 21785,
                         "leagues"                 => 2626,
                         "leakage"                 => 11172,
                         "leakey"                  => 23963,
                         "leamington"              => 14484,
                         "leanings"                => 14957,
                         "leaped"                  => 26181,
                         "learners"                => 8639,
                         "learning"                => 1114,
                         "learns"                  => 3631,
                         "learnt"                  => 7646,
                         "leased"                  => 4237,
                         "leasehold"               => 27658,
                         "leases"                  => 9493,
                         "leasing"                 => 8823,
                         "leatherhead"             => 23636,
                         "leathery"                => 18250,
                         "leaved"                  => 13389,
                         "leavenworth"             => 12477,
                         "leavers"                 => 29783,
                         "leaves"                  => 1016,
                         "lebanese"                => 4368,
                         "lebanon"                 => 2833,
                         "leben"                   => 17776,
                         "lebesgue"                => 20048,
                         "lecce"                   => 16252,
                         "lecco"                   => 27204,
                         "leche"                   => 26613,
                         "lectern"                 => 26126,
                         "lectionary"              => 13998,
                         "lectured"                => 6894,
                         "lecturer"                => 3381,
                         "lecturers"               => 12248,
                         "lectures"                => 3204,
                         "lectureship"             => 18776,
                         "leczyca"                 => 23702,
                         "led"                     => 240,
                         "ledges"                  => 18494,
                         "leeds"                   => 2609,
                         "leela"                   => 12581,
                         "leesburg"                => 19530,
                         "leeuwarden"              => 23681,
                         "leeward"                 => 12950,
                         "left"                    => 187,
                         "leftist"                 => 7865,
                         "leftists"                => 19236,
                         "legacies"                => 16472,
                         "legal"                   => 692,
                         "legalised"               => 27794,
                         "legality"                => 9837,
                         "legalization"            => 14060,
                         "legalized"               => 13019,
                         "legate"                  => 13183,
                         "legation"                => 14236,
                         "legazpi"                 => 26260,
                         "legco"                   => 28354,
                         "legendary"               => 3020,
                         "legends"                 => 3672,
                         "legia"                   => 25069,
                         "legible"                 => 26880,
                         "legio"                   => 20260,
                         "legionaries"             => 25598,
                         "legionary"               => 21856,
                         "legionnaire"             => 29472,
                         "legionnaires"            => 17645,
                         "legions"                 => 8660,
                         "legislated"              => 17917,
                         "legislation"             => 1829,
                         "legislative"             => 1310,
                         "legislator"              => 8601,
                         "legislators"             => 7713,
                         "legislature"             => 1913,
                         "legislatures"            => 8504,
                         "legitimacy"              => 7686,
                         "legitimately"            => 16593,
                         "legitimized"             => 28107,
                         "legnica"                 => 20652,
                         "legume"                  => 13577,
                         "legumes"                 => 19134,
                         "lehigh"                  => 7952,
                         "leiber"                  => 20263,
                         "leibniz"                 => 12097,
                         "leicester"               => 3976,
                         "leicestershire"          => 6587,
                         "leichhardt"              => 20748,
                         "leiden"                  => 7942,
                         "leiningen"               => 28384,
                         "leinster"                => 5729,
                         "leipzig"                 => 4741,
                         "leiria"                  => 24354,
                         "leisure"                 => 4443,
                         "leitrim"                 => 16758,
                         "lelouch"                 => 25757,
                         "lemberg"                 => 24349,
                         "lemma"                   => 11375,
                         "lemmy"                   => 25066,
                         "lemnos"                  => 26869,
                         "lemur"                   => 12943,
                         "lemurs"                  => 13855,
                         "lenape"                  => 13362,
                         "lender"                  => 12291,
                         "lenders"                 => 11601,
                         "lending"                 => 6710,
                         "lendl"                   => 27678,
                         "lends"                   => 11240,
                         "length"                  => 651,
                         "lengthen"                => 23751,
                         "lengthened"              => 11098,
                         "lengthening"             => 16007,
                         "lengths"                 => 4096,
                         "lengthwise"              => 28199,
                         "lengthy"                 => 4620,
                         "lengua"                  => 29775,
                         "lenin"                   => 6756,
                         "leningrad"               => 5838,
                         "leninism"                => 19451,
                         "leninist"                => 11677,
                         "lens"                    => 3729,
                         "lenses"                  => 5948,
                         "lenten"                  => 27786,
                         "lenticular"              => 23976,
                         "leominster"              => 22959,
                         "leonards"                => 19232,
                         "leonean"                 => 22677,
                         "leonese"                 => 23586,
                         "leonhard"                => 18122,
                         "leopards"                => 11381,
                         "lepanto"                 => 27534,
                         "lepidoptera"             => 13531,
                         "lepidus"                 => 25978,
                         "lermontov"               => 28054,
                         "lesions"                 => 7875,
                         "lesnar"                  => 16647,
                         "lesotho"                 => 10687,
                         "less"                    => 425,
                         "lessen"                  => 14211,
                         "lessened"                => 16032,
                         "lessening"               => 23796,
                         "lesser"                  => 2873,
                         "lessing"                 => 19390,
                         "leste"                   => 18189,
                         "leszek"                  => 21186,
                         "leszno"                  => 27499,
                         "lethality"               => 28001,
                         "lethargy"                => 29230,
                         "lethbridge"              => 12360,
                         "lettered"                => 12725,
                         "lettering"               => 9938,
                         "letterkenny"             => 24524,
                         "letters"                 => 1215,
                         "lettres"                 => 13178,
                         "leucine"                 => 22169,
                         "leukaemia"               => 23228,
                         "leukocytes"              => 29579,
                         "leumit"                  => 22594,
                         "leutnant"                => 18078,
                         "leuven"                  => 11078,
                         "levant"                  => 9040,
                         "levante"                 => 18648,
                         "levantine"               => 22822,
                         "levee"                   => 12772,
                         "levees"                  => 17445,
                         "level"                   => 289,
                         "leveling"                => 15377,
                         "levelled"                => 14352,
                         "levelling"               => 22288,
                         "levels"                  => 908,
                         "leveraged"               => 14111,
                         "leveraging"              => 19727,
                         "leverkusen"              => 15056,
                         "levers"                  => 16233,
                         "leveson"                 => 18218,
                         "levied"                  => 10490,
                         "levies"                  => 16599,
                         "leviticus"               => 19541,
                         "levski"                  => 13922,
                         "levying"                 => 29042,
                         "lewes"                   => 10571,
                         "lewinsky"                => 29243,
                         "lewisburg"               => 21523,
                         "lewisham"                => 14709,
                         "lewiston"                => 13124,
                         "lewisville"              => 29620,
                         "lexical"                 => 9894,
                         "lexicographer"           => 24752,
                         "lexington"               => 5307,
                         "leyla"                   => 23160,
                         "leyland"                 => 9545,
                         "leyte"                   => 8409,
                         "leyton"                  => 11414,
                         "lgbt"                    => 4424,
                         "lgbtq"                   => 22311,
                         "liabilities"             => 11213,
                         "liability"               => 5201,
                         "liangshan"               => 21249,
                         "liaodong"                => 28194,
                         "liaoning"                => 11693,
                         "libel"                   => 8249,
                         "liber"                   => 11645,
                         "libera"                  => 25981,
                         "liberal"                 => 1093,
                         "liberalisation"          => 21350,
                         "liberalism"              => 8521,
                         "liberalization"          => 14615,
                         "liberally"               => 21458,
                         "liberals"                => 4529,
                         "liberated"               => 7121,
                         "liberation"              => 2723,
                         "liberator"               => 12160,
                         "liberators"              => 18873,
                         "liberec"                 => 19467,
                         "liberia"                 => 6321,
                         "liberian"                => 11815,
                         "libertadores"            => 9813,
                         "libertarian"             => 6675,
                         "libertarianism"          => 23728,
                         "libertarians"            => 19640,
                         "liberties"               => 6452,
                         "libertine"               => 28077,
                         "libor"                   => 25980,
                         "librarians"              => 11443,
                         "librarianship"           => 22884,
                         "libraries"               => 2974,
                         "library"                 => 628,
                         "libre"                   => 7781,
                         "libretti"                => 29056,
                         "librettist"              => 16362,
                         "libretto"                => 7197,
                         "libreville"              => 28516,
                         "libri"                   => 23082,
                         "libro"                   => 22297,
                         "libya"                   => 4582,
                         "libyan"                  => 6436,
                         "libyans"                 => 24434,
                         "licence"                 => 4174,
                         "licenced"                => 19355,
                         "licences"                => 10814,
                         "licensed"                => 2283,
                         "licensee"                => 12199,
                         "licensees"               => 18319,
                         "licenses"                => 5584,
                         "licensing"               => 4564,
                         "licensure"               => 18864,
                         "licentiate"              => 15545,
                         "liceo"                   => 19913,
                         "lichen"                  => 12379,
                         "lichens"                 => 14007,
                         "lichfield"               => 10941,
                         "licinius"                => 20414,
                         "lidar"                   => 24340,
                         "liechtenstein"           => 8862,
                         "lieder"                  => 16657,
                         "liege"                   => 7284,
                         "liepaja"                 => 22099,
                         "lies"                    => 823,
                         "lietuvos"                => 27953,
                         "lieut"                   => 20723,
                         "lieutenant"              => 1088,
                         "lieutenants"             => 11233,
                         "life"                    => 108,
                         "lifeboat"                => 7775,
                         "lifeboats"               => 13069,
                         "lifecycle"               => 14330,
                         "lifelong"                => 4774,
                         "lifes"                   => 16384,
                         "lifespan"                => 8828,
                         "lifestyle"               => 3521,
                         "liffey"                  => 23107,
                         "liga"                    => 3075,
                         "ligament"                => 8188,
                         "ligaments"               => 14004,
                         "ligand"                  => 8834,
                         "ligands"                 => 9881,
                         "ligase"                  => 18667,
                         "ligation"                => 24394,
                         "ligatures"               => 28240,
                         "liger"                   => 25732,
                         "light"                   => 416,
                         "lighted"                 => 12008,
                         "lightest"                => 17662,
                         "lighthouse"              => 3597,
                         "lighthouses"             => 12080,
                         "lighting"                => 3114,
                         "lightship"               => 22673,
                         "lightweight"             => 4803,
                         "ligier"                  => 25724,
                         "ligne"                   => 24742,
                         "lignin"                  => 26695,
                         "lignite"                 => 19449,
                         "ligue"                   => 6702,
                         "liguria"                 => 16361,
                         "ligurian"                => 21034,
                         "liiga"                   => 13344,
                         "likeable"                => 21861,
                         "likelihood"              => 6363,
                         "likely"                  => 986,
                         "likened"                 => 9344,
                         "likening"                => 26634,
                         "likewise"                => 3916,
                         "likud"                   => 15729,
                         "lille"                   => 8210,
                         "lillehammer"             => 15434,
                         "lillestrom"              => 21579,
                         "lillooet"                => 20651,
                         "liman"                   => 25767,
                         "limassol"                => 15159,
                         "limbic"                  => 26703,
                         "limbs"                   => 6830,
                         "limburg"                 => 10523,
                         "limerick"                => 5558,
                         "limestone"               => 3435,
                         "limestones"              => 19998,
                         "limit"                   => 1922,
                         "limitation"              => 7730,
                         "limitations"             => 4329,
                         "limited"                 => 588,
                         "limiting"                => 5282,
                         "limits"                  => 2292,
                         "limousin"                => 18426,
                         "limpet"                  => 22024,
                         "limpets"                 => 18225,
                         "lincolnshire"            => 5688,
                         "lindau"                  => 23300,
                         "lindbergh"               => 12358,
                         "lindenwood"              => 27580,
                         "lindisfarne"             => 18509,
                         "lindwall"                => 18149,
                         "line"                    => 148,
                         "lineages"                => 9640,
                         "lineal"                  => 20830,
                         "linear"                  => 2394,
                         "linearity"               => 21629,
                         "linearly"                => 13166,
                         "linebacker"              => 5769,
                         "linebackers"             => 15315,
                         "linemen"                 => 17809,
                         "liner"                   => 4606,
                         "liners"                  => 10619,
                         "lines"                   => 679,
                         "linesman"                => 26224,
                         "lineup"                  => 3455,
                         "lineups"                 => 17214,
                         "linfield"                => 17679,
                         "linga"                   => 18968,
                         "lingam"                  => 20239,
                         "lingayen"                => 19290,
                         "lingered"                => 21274,
                         "lingua"                  => 12636,
                         "lingual"                 => 15572,
                         "linguist"                => 8142,
                         "linguistic"              => 4169,
                         "linguistically"          => 16028,
                         "linguistics"             => 5672,
                         "linguists"               => 9878,
                         "linings"                 => 24855,
                         "linkage"                 => 10223,
                         "linkages"                => 14395,
                         "linked"                  => 1889,
                         "linkedin"                => 22812,
                         "linking"                 => 4046,
                         "linkoping"               => 19507,
                         "links"                   => 1458,
                         "linlithgow"              => 21221,
                         "linnaeus"                => 11119,
                         "linnean"                 => 19908,
                         "linotype"                => 28991,
                         "linseed"                 => 29365,
                         "lintel"                  => 19850,
                         "lintels"                 => 21131,
                         "linux"                   => 4120,
                         "lions"                   => 2555,
                         "lionsgate"               => 18206,
                         "lipid"                   => 9727,
                         "lipids"                  => 14061,
                         "lipno"                   => 29191,
                         "lipoprotein"             => 27050,
                         "lippe"                   => 14109,
                         "lippi"                   => 23673,
                         "lippmann"                => 29726,
                         "liquefaction"            => 27767,
                         "liquefied"               => 18756,
                         "liquidated"              => 12768,
                         "liquidation"             => 9309,
                         "liquidator"              => 26138,
                         "liquidity"               => 12129,
                         "liquids"                 => 9276,
                         "liquors"                 => 28418,
                         "lisbon"                  => 4417,
                         "lisburn"                 => 20149,
                         "lisieux"                 => 29136,
                         "liskeard"                => 27254,
                         "lismore"                 => 17529,
                         "list"                    => 231,
                         "listed"                  => 596,
                         "listeners"               => 4797,
                         "listing"                 => 2053,
                         "listings"                => 4659,
                         "lists"                   => 2145,
                         "liszt"                   => 8644,
                         "liter"                   => 8500,
                         "literacy"                => 2847,
                         "literal"                 => 6834,
                         "literary"                => 1268,
                         "literate"                => 9524,
                         "literati"                => 24115,
                         "literature"              => 922,
                         "literatures"             => 19483,
                         "litex"                   => 29829,
                         "lithgow"                 => 18782,
                         "lithic"                  => 22620,
                         "lithograph"              => 27132,
                         "lithographer"            => 27368,
                         "lithographic"            => 25343,
                         "lithographs"             => 18605,
                         "lithography"             => 14305,
                         "lithosphere"             => 21918,
                         "lithuania"               => 3485,
                         "lithuanian"              => 3735,
                         "lithuanians"             => 13639,
                         "litigants"               => 24920,
                         "litigation"              => 5338,
                         "litovsk"                 => 25676,
                         "litre"                   => 6106,
                         "litres"                  => 10803,
                         "litters"                 => 20176,
                         "littoral"                => 11496,
                         "liturgical"              => 6554,
                         "liturgics"               => 25280,
                         "liturgies"               => 22213,
                         "liturgy"                 => 6940,
                         "litvinenko"              => 28912,
                         "lived"                   => 610,
                         "livelihoods"             => 16243,
                         "liveries"                => 21535,
                         "livery"                  => 6411,
                         "livestock"               => 4089,
                         "living"                  => 344,
                         "livonia"                 => 13606,
                         "livonian"                => 15709,
                         "livorno"                 => 13567,
                         "livre"                   => 17427,
                         "livres"                  => 18863,
                         "lizards"                 => 8423,
                         "ljubljana"               => 7487,
                         "llandaff"                => 19895,
                         "llandudno"               => 23906,
                         "llanelli"                => 14489,
                         "llangollen"              => 26929,
                         "llano"                   => 16798,
                         "lleida"                  => 16608,
                         "llewelyn"                => 23346,
                         "llobregat"               => 29444,
                         "lluis"                   => 24985,
                         "llywelyn"                => 14756,
                         "loaders"                 => 21871,
                         "loading"                 => 4494,
                         "loan"                    => 1695,
                         "loaned"                  => 4864,
                         "loans"                   => 3853,
                         "loanwords"               => 13863,
                         "loaves"                  => 14240,
                         "lobbied"                 => 8559,
                         "lobbies"                 => 18577,
                         "lobbying"                => 6518,
                         "lobbyist"                => 13098,
                         "lobbyists"               => 16768,
                         "lobed"                   => 13111,
                         "lobes"                   => 8513,
                         "lobos"                   => 12620,
                         "local"                   => 170,
                         "locale"                  => 12684,
                         "locales"                 => 12902,
                         "localised"               => 15962,
                         "localities"              => 5050,
                         "locality"                => 3490,
                         "localization"            => 9817,
                         "localize"                => 26504,
                         "localized"               => 7700,
                         "locally"                 => 2322,
                         "locals"                  => 3953,
                         "locarno"                 => 16656,
                         "located"                 => 134,
                         "locates"                 => 15185,
                         "location"                => 611,
                         "locations"               => 1423,
                         "locative"                => 23297,
                         "loch"                    => 5490,
                         "lochaber"                => 27216,
                         "lockerbie"               => 24626,
                         "lockheed"                => 6589,
                         "lockport"                => 19162,
                         "lockyer"                 => 18243,
                         "locomotion"              => 13612,
                         "locomotive"              => 2727,
                         "locomotives"             => 2415,
                         "locos"                   => 15620,
                         "locus"                   => 8485,
                         "lodge"                   => 2739,
                         "lodger"                  => 24213,
                         "lodges"                  => 8631,
                         "lodging"                 => 9509,
                         "lodgings"                => 15062,
                         "lodz"                    => 5054,
                         "loess"                   => 22142,
                         "loewe"                   => 25488,
                         "lofoten"                 => 29947,
                         "lofty"                   => 12508,
                         "logano"                  => 21121,
                         "logarithm"               => 15215,
                         "logarithmic"             => 16146,
                         "logarithms"              => 26718,
                         "loggers"                 => 20659,
                         "loggia"                  => 18743,
                         "logging"                 => 5696,
                         "logic"                   => 3097,
                         "logics"                  => 21771,
                         "logie"                   => 14845,
                         "login"                   => 18589,
                         "logistical"              => 9387,
                         "logistics"               => 4853,
                         "logo"                    => 2705,
                         "logos"                   => 8102,
                         "lohan"                   => 16895,
                         "lohengrin"               => 26213,
                         "loire"                   => 7018,
                         "loiret"                  => 27682,
                         "lollapalooza"            => 22121,
                         "lombards"                => 15912,
                         "lombardy"                => 8443,
                         "lombok"                  => 22364,
                         "lomza"                   => 22187,
                         "londonderry"             => 10585,
                         "londoners"               => 22729,
                         "longchamp"               => 17077,
                         "longest"                 => 2159,
                         "longevity"               => 8947,
                         "longford"                => 11430,
                         "longinus"                => 28164,
                         "longitude"               => 6247,
                         "longitudes"              => 27836,
                         "longitudinal"            => 7254,
                         "longitudinally"          => 19225,
                         "longlisted"              => 29639,
                         "longstanding"            => 10181,
                         "longtime"                => 3854,
                         "longueuil"               => 21770,
                         "longus"                  => 27543,
                         "lookalike"               => 29478,
                         "loomed"                  => 25778,
                         "looms"                   => 14579,
                         "loong"                   => 28891,
                         "loop"                    => 2538,
                         "looping"                 => 15498,
                         "loops"                   => 6487,
                         "loosely"                 => 4720,
                         "looted"                  => 9306,
                         "looters"                 => 24163,
                         "looting"                 => 9762,
                         "lorain"                  => 20603,
                         "lord"                    => 660,
                         "lorde"                   => 22508,
                         "lords"                   => 2889,
                         "lordship"                => 7984,
                         "lordships"               => 21573,
                         "lorestan"                => 10667,
                         "lorient"                 => 15200,
                         "lorries"                 => 17203,
                         "los"                     => 568,
                         "loss"                    => 737,
                         "losses"                  => 1859,
                         "lossless"                => 20653,
                         "lossy"                   => 28278,
                         "lothair"                 => 18618,
                         "lothian"                 => 10224,
                         "lotteries"               => 18993,
                         "loudness"                => 21859,
                         "loudoun"                 => 13002,
                         "loudspeaker"             => 14974,
                         "loudspeakers"            => 16241,
                         "loughborough"            => 11390,
                         "loughton"                => 25624,
                         "louisbourg"              => 19400,
                         "louisiana"               => 1690,
                         "louisville"              => 4049,
                         "lounges"                 => 15140,
                         "louth"                   => 12510,
                         "louvain"                 => 16596,
                         "louvre"                  => 9399,
                         "lovat"                   => 22976,
                         "lovech"                  => 23275,
                         "lovecraft"               => 10382,
                         "low"                     => 450,
                         "lower"                   => 502,
                         "lowercase"               => 17411,
                         "lowered"                 => 5524,
                         "lowering"                => 7600,
                         "lowest"                  => 2532,
                         "lowestoft"               => 16164,
                         "lowicz"                  => 28373,
                         "lowland"                 => 4980,
                         "lowlands"                => 8489,
                         "loxton"                  => 25794,
                         "loyalist"                => 7479,
                         "loyalists"               => 8569,
                         "lozenge"                 => 26346,
                         "ltd."                    => 3596,
                         "luanda"                  => 15568,
                         "luang"                   => 14554,
                         "lubavitch"               => 27486,
                         "lubbock"                 => 10520,
                         "lubeck"                  => 10913,
                         "lubelski"                => 20446,
                         "lublin"                  => 5599,
                         "lubomirski"              => 29880,
                         "lubricating"             => 27960,
                         "lubrication"             => 15986,
                         "lubusz"                  => 12593,
                         "lucan"                   => 17960,
                         "lucasarts"               => 23431,
                         "lucasfilm"               => 22805,
                         "lucchese"                => 20673,
                         "lucerne"                 => 11161,
                         "lucha"                   => 9214,
                         "lucknow"                 => 8179,
                         "lucrative"               => 7405,
                         "lucrezia"                => 21175,
                         "lucullus"                => 28856,
                         "ludendorff"              => 24238,
                         "ludhiana"                => 18417,
                         "ludovico"                => 16240,
                         "ludvig"                  => 18134,
                         "ludwigsburg"             => 24806,
                         "ludwigshafen"            => 25325,
                         "ludwik"                  => 25700,
                         "lufthansa"               => 15649,
                         "luftwaffe"               => 5960,
                         "luger"                   => 12565,
                         "luhansk"                 => 17987,
                         "lukashenko"              => 25282,
                         "lukow"                   => 27308,
                         "lulea"                   => 21508,
                         "lully"                   => 25979,
                         "lumberjacks"             => 21180,
                         "lumbini"                 => 25379,
                         "lumen"                   => 15318,
                         "lumia"                   => 21335,
                         "lumiere"                 => 17717,
                         "luminance"               => 21469,
                         "luminaries"              => 14204,
                         "luminescence"            => 29025,
                         "luminosity"              => 11959,
                         "luminous"                => 11075,
                         "lumpur"                  => 6604,
                         "lumumba"                 => 23112,
                         "lunar"                   => 4065,
                         "luneburg"                => 12082,
                         "lunenburg"               => 17792,
                         "lunga"                   => 26270,
                         "luoyang"                 => 11373,
                         "lupin"                   => 15734,
                         "lures"                   => 16249,
                         "lurgan"                  => 26688,
                         "lusaka"                  => 17762,
                         "lusatia"                 => 21040,
                         "lusatian"                => 28229,
                         "lushan"                  => 28175,
                         "lusignan"                => 22463,
                         "lusitania"               => 19534,
                         "lustre"                  => 22449,
                         "lutheran"                => 3569,
                         "lutheranism"             => 17307,
                         "lutherans"               => 13078,
                         "luthier"                 => 23475,
                         "luthor"                  => 12265,
                         "luton"                   => 6905,
                         "lutsk"                   => 27916,
                         "lutyens"                 => 21569,
                         "lutzow"                  => 24545,
                         "luxembourg"              => 3932,
                         "luxembourgian"           => 27416,
                         "luxembourgish"           => 18413,
                         "luxemburg"               => 17748,
                         "luxurious"               => 8946,
                         "luxury"                  => 3843,
                         "luzerne"                 => 17947,
                         "luzon"                   => 7480,
                         "lyase"                   => 16951,
                         "lycaenidae"              => 12656,
                         "lycee"                   => 10253,
                         "lyceum"                  => 10234,
                         "lycia"                   => 26172,
                         "lycoming"                => 13076,
                         "lydian"                  => 26804,
                         "lyell"                   => 16600,
                         "lymington"               => 25587,
                         "lymphatic"               => 18279,
                         "lymphocyte"              => 25985,
                         "lymphocytes"             => 15287,
                         "lymphoid"                => 27915,
                         "lympne"                  => 29916,
                         "lynchburg"               => 13951,
                         "lynching"                => 14454,
                         "lyndhurst"               => 22332,
                         "lyonnais"                => 20923,
                         "lyric"                   => 5330,
                         "lyrical"                 => 5627,
                         "lyrically"               => 9836,
                         "lyricism"                => 18086,
                         "lyricist"                => 7788,
                         "lyricists"               => 22834,
                         "lyrics"                  => 1400,
                         "lysine"                  => 15887,
                         "lysis"                   => 26836,
                         "lytham"                  => 28620,
                         "lyttelton"               => 13310,
                         "m*a*s*h"                 => 20927,
                         "m.b.a."                  => 21623,
                         "m.f.a"                   => 23542,
                         "m.i.a"                   => 21604,
                         "m.phil"                  => 26272,
                         "ma'mun"                  => 26040,
                         "maasai"                  => 20967,
                         "maastricht"              => 11539,
                         "maastrichtian"           => 27776,
                         "maatschappij"            => 26786,
                         "macao"                   => 18827,
                         "macapagal"               => 16733,
                         "macaque"                 => 20549,
                         "macaques"                => 23168,
                         "macau"                   => 6204,
                         "macaw"                   => 22691,
                         "maccabees"               => 23793,
                         "maccabi"                 => 8437,
                         "maccabiah"               => 21806,
                         "macclesfield"            => 11062,
                         "maccoll"                 => 25684,
                         "macdill"                 => 26917,
                         "macedon"                 => 13157,
                         "macedonia"               => 4011,
                         "macedonian"              => 4935,
                         "macedonians"             => 14076,
                         "machi"                   => 24380,
                         "machined"                => 19695,
                         "machinegun"              => 23948,
                         "machinery"               => 3890,
                         "machines"                => 2351,
                         "machinima"               => 23498,
                         "machining"               => 15110,
                         "machinist"               => 17710,
                         "maciej"                  => 20126,
                         "mackaye"                 => 29861,
                         "mackinac"                => 14608,
                         "mackintosh"              => 12243,
                         "macleay"                 => 26997,
                         "macomb"                  => 16967,
                         "macquarie"               => 8444,
                         "macro"                   => 9078,
                         "macroeconomic"           => 16193,
                         "macroeconomics"          => 21128,
                         "macromedia"              => 29824,
                         "macromolecules"          => 26073,
                         "macrophages"             => 15045,
                         "macroscopic"             => 16151,
                         "macular"                 => 24795,
                         "maculata"                => 23632,
                         "madagascar"              => 4398,
                         "madama"                  => 23071,
                         "madan"                   => 14424,
                         "made"                    => 65,
                         "madea"                   => 28125,
                         "madhav"                  => 24639,
                         "madhava"                 => 24395,
                         "madhavan"                => 19033,
                         "madhya"                  => 7140,
                         "madinah"                 => 29756,
                         "madoff"                  => 15596,
                         "madras"                  => 4782,
                         "madrasa"                 => 18803,
                         "madrasah"                => 23913,
                         "madrigals"               => 18637,
                         "madura"                  => 25306,
                         "madurai"                 => 9861,
                         "maegashira"              => 28917,
                         "maeve"                   => 28246,
                         "mafic"                   => 27390,
                         "mafiosi"                 => 28869,
                         "magadha"                 => 26425,
                         "magalhaes"               => 24801,
                         "magazine"                => 456,
                         "magazines"               => 2418,
                         "magdeburg"               => 9886,
                         "magellanic"              => 24879,
                         "maggiore"                => 14792,
                         "maghreb"                 => 15936,
                         "maginot"                 => 22154,
                         "magistrate"              => 5496,
                         "magistrates"             => 7648,
                         "maglev"                  => 25736,
                         "magma"                   => 10135,
                         "magmatic"                => 29028,
                         "magna"                   => 6972,
                         "magnate"                 => 9072,
                         "magnates"                => 14412,
                         "magne"                   => 27689,
                         "magnesia"                => 27594,
                         "magnesium"               => 8281,
                         "magnetic"                => 2800,
                         "magnetite"               => 21716,
                         "magnetization"           => 18332,
                         "magnetosphere"           => 23467,
                         "magnificat"              => 22788,
                         "magnification"           => 16820,
                         "magnitude"               => 3822,
                         "magnitudes"              => 17528,
                         "magny"                   => 29514,
                         "magog"                   => 26072,
                         "magsaysay"               => 20972,
                         "maguindanao"             => 25275,
                         "magus"                   => 22092,
                         "magyars"                 => 21294,
                         "mahabharata"             => 10150,
                         "mahadev"                 => 19352,
                         "mahadeva"                => 24838,
                         "mahadevan"               => 23664,
                         "mahalleh"                => 13437,
                         "maharaj"                 => 10626,
                         "maharaja"                => 7747,
                         "maharana"                => 27813,
                         "maharani"                => 22742,
                         "maharashtra"             => 4543,
                         "maharishi"               => 14919,
                         "maharshi"                => 28606,
                         "mahathir"                => 21038,
                         "mahatma"                 => 10255,
                         "mahavidyalaya"           => 27165,
                         "mahavira"                => 29366,
                         "mahayana"                => 12207,
                         "mahdi"                   => 11523,
                         "mahendra"                => 14413,
                         "mahila"                  => 29609,
                         "mahinda"                 => 22906,
                         "mahindra"                => 15530,
                         "mahjong"                 => 23879,
                         "mahmud"                  => 8407,
                         "mahmudabad"              => 21426,
                         "mahoning"                => 23606,
                         "maidan"                  => 16932,
                         "maidenhead"              => 17222,
                         "maidens"                 => 15019,
                         "maidstone"               => 10868,
                         "maimonides"              => 13498,
                         "main"                    => 198,
                         "maine"                   => 2267,
                         "mainframes"              => 26423,
                         "mainichi"                => 25510,
                         "mainland"                => 2729,
                         "mainline"                => 6883,
                         "mainly"                  => 792,
                         "mainstage"               => 28703,
                         "mainstay"                => 9887,
                         "mainstays"               => 23736,
                         "mainstream"              => 2447,
                         "maintain"                => 1735,
                         "maintained"              => 1521,
                         "maintaining"             => 3008,
                         "maintains"               => 3005,
                         "maintenance"             => 2015,
                         "mainz"                   => 7159,
                         "maior"                   => 26516,
                         "maisonneuve"             => 29141,
                         "maisons"                 => 26194,
                         "maithili"                => 26932,
                         "maitreya"                => 23544,
                         "maize"                   => 7355,
                         "majapahit"               => 19706,
                         "majid"                   => 14118,
                         "majlis"                  => 14806,
                         "major"                   => 177,
                         "majorca"                 => 14119,
                         "majored"                 => 9641,
                         "majoring"                => 11404,
                         "majoris"                 => 27425,
                         "majorities"              => 14955,
                         "majority"                => 699,
                         "majumdar"                => 24110,
                         "majuro"                  => 23103,
                         "makai"                   => 25378,
                         "makassar"                => 20672,
                         "makati"                  => 14857,
                         "maker"                   => 3591,
                         "makerere"                => 21949,
                         "makers"                  => 3938,
                         "makeshift"               => 10121,
                         "makeup"                  => 1907,
                         "makhachkala"             => 26590,
                         "makkah"                  => 27379,
                         "makow"                   => 29934,
                         "maktoum"                 => 20160,
                         "makuuchi"                => 28795,
                         "malabar"                 => 8675,
                         "malacca"                 => 9070,
                         "malagasy"                => 12134,
                         "malai"                   => 27874,
                         "malang"                  => 28408,
                         "malankara"               => 15547,
                         "malappuram"              => 21622,
                         "malaria"                 => 6681,
                         "malarial"                => 29657,
                         "malate"                  => 29061,
                         "malawi"                  => 6445,
                         "malawian"                => 22387,
                         "malay"                   => 4801,
                         "malaya"                  => 7265,
                         "malayalam"               => 4673,
                         "malayan"                 => 11272,
                         "malays"                  => 12872,
                         "malaysia"                => 2024,
                         "malaysian"               => 4304,
                         "malaysians"              => 25181,
                         "malden"                  => 14985,
                         "maldives"                => 8430,
                         "maldivian"               => 18904,
                         "maldon"                  => 20563,
                         "male"                    => 776,
                         "maleficent"              => 27249,
                         "males"                   => 778,
                         "malformation"            => 25998,
                         "malformations"           => 22340,
                         "mali"                    => 5687,
                         "malian"                  => 14644,
                         "malignancies"            => 29322,
                         "malignancy"              => 27447,
                         "maliki"                  => 18056,
                         "malini"                  => 24640,
                         "malla"                   => 18003,
                         "malleable"               => 22802,
                         "mallee"                  => 18740,
                         "malls"                   => 8152,
                         "malmesbury"              => 19436,
                         "malmo"                   => 7669,
                         "malnutrition"            => 11970,
                         "malolos"                 => 25586,
                         "malory"                  => 27331,
                         "malta"                   => 3668,
                         "maltese"                 => 6700,
                         "malthus"                 => 28069,
                         "malton"                  => 19625,
                         "maltreatment"            => 29043,
                         "maluku"                  => 19022,
                         "malus"                   => 23238,
                         "malvern"                 => 9382,
                         "malwa"                   => 18588,
                         "malware"                 => 13568,
                         "mamba"                   => 23899,
                         "mamet"                   => 23227,
                         "mamluk"                  => 13794,
                         "mamluks"                 => 17053,
                         "mammal"                  => 8148,
                         "mammalian"               => 8652,
                         "mammals"                 => 3936,
                         "mammary"                 => 23039,
                         "mammootty"               => 20627,
                         "mammoths"                => 25657,
                         "mamoru"                  => 22604,
                         "managed"                 => 878,
                         "management"              => 490,
                         "manager"                 => 653,
                         "managerial"              => 6808,
                         "managers"                => 3504,
                         "manages"                 => 3165,
                         "managing"                => 2334,
                         "manama"                  => 23917,
                         "manas"                   => 21117,
                         "manassas"                => 16244,
                         "manasseh"                => 27231,
                         "manaus"                  => 24288,
                         "manawatu"                => 16760,
                         "manche"                  => 17925,
                         "manchu"                  => 8706,
                         "manchukuo"               => 16372,
                         "manchuria"               => 9873,
                         "manchurian"              => 19611,
                         "manchus"                 => 20725,
                         "mandal"                  => 7902,
                         "mandala"                 => 16089,
                         "mandalay"                => 12985,
                         "mandals"                 => 29706,
                         "mandan"                  => 25774,
                         "mandate"                 => 3858,
                         "mandated"                => 6104,
                         "mandates"                => 8860,
                         "mandating"               => 20299,
                         "mandatory"               => 3896,
                         "mande"                   => 25336,
                         "mandela"                 => 9349,
                         "mandible"                => 10969,
                         "mandibles"               => 12221,
                         "mandibular"              => 19366,
                         "mandir"                  => 8609,
                         "mandurah"                => 29838,
                         "manet"                   => 19403,
                         "maneuverability"         => 17985,
                         "maneuverable"            => 25789,
                         "maneuvers"               => 8383,
                         "manga"                   => 2834,
                         "mangal"                  => 24382,
                         "mangalore"               => 11538,
                         "manganese"               => 10304,
                         "mangeshkar"              => 22112,
                         "mangrove"                => 9609,
                         "mangroves"               => 13764,
                         "manhattan"               => 2459,
                         "manheim"                 => 29583,
                         "manhunter"               => 22567,
                         "manifestation"           => 8541,
                         "manifestations"          => 9709,
                         "manifested"              => 9268,
                         "manifesto"               => 6068,
                         "manifestos"              => 29915,
                         "manifests"               => 13023,
                         "manifold"                => 6546,
                         "manifolds"               => 10861,
                         "manila"                  => 3303,
                         "manipal"                 => 29930,
                         "manipur"                 => 11186,
                         "manipuri"                => 25627,
                         "manistee"                => 29913,
                         "manitoba"                => 3367,
                         "manitowoc"               => 21843,
                         "manju"                   => 26021,
                         "mankato"                 => 20107,
                         "mankiewicz"              => 24643,
                         "manlius"                 => 27294,
                         "manmade"                 => 24919,
                         "manmohan"                => 18035,
                         "mannar"                  => 24264,
                         "manned"                  => 5504,
                         "manner"                  => 2012,
                         "mannerheim"              => 25818,
                         "mannerism"               => 25984,
                         "mannerisms"              => 16646,
                         "mannerist"               => 20157,
                         "manningham"              => 27120,
                         "mannose"                 => 29202,
                         "manoa"                   => 21624,
                         "manoel"                  => 23903,
                         "manoeuvre"               => 13970,
                         "manoeuvres"              => 15261,
                         "manohar"                 => 19822,
                         "manoj"                   => 16719,
                         "manor"                   => 2330,
                         "manorama"                => 27064,
                         "manorial"                => 18933,
                         "manors"                  => 11065,
                         "mans"                    => 5617,
                         "mansa"                   => 23149,
                         "mansard"                 => 18393,
                         "mansfeld"                => 26879,
                         "mansions"                => 9279,
                         "mantegna"                => 26794,
                         "mantras"                 => 20030,
                         "mantua"                  => 11177,
                         "manually"                => 7412,
                         "manufactory"             => 22523,
                         "manufacture"             => 3343,
                         "manufactured"            => 2473,
                         "manufacturer"            => 2513,
                         "manufacturers"           => 2799,
                         "manufactures"            => 7212,
                         "manufacturing"           => 1742,
                         "manukau"                 => 21198,
                         "manuscript"              => 2822,
                         "manuscripts"             => 3644,
                         "many"                    => 68,
                         "manzanillo"              => 25959,
                         "manzoni"                 => 29822,
                         "maoist"                  => 13288,
                         "maoists"                 => 28646,
                         "maori"                   => 4346,
                         "maozhen"                 => 27319,
                         "mapped"                  => 6190,
                         "mapping"                 => 4472,
                         "mappings"                => 21262,
                         "maps"                    => 2550,
                         "mapuche"                 => 17656,
                         "maputo"                  => 19776,
                         "maquis"                  => 21465,
                         "maracaibo"               => 19668,
                         "marae"                   => 28852,
                         "marais"                  => 16382,
                         "maramures"               => 28416,
                         "maranhao"                => 18892,
                         "maratha"                 => 9427,
                         "marathas"                => 13761,
                         "marathi"                 => 6621,
                         "marathons"               => 16131,
                         "marauders"               => 16009,
                         "marauding"               => 25246,
                         "marbled"                 => 19616,
                         "marblehead"              => 21651,
                         "marburg"                 => 12461,
                         "marca"                   => 28660,
                         "marcellinus"             => 28315,
                         "march"                   => 141,
                         "marche"                  => 11333,
                         "marched"                 => 4483,
                         "marcher"                 => 25430,
                         "marchers"                => 19680,
                         "marches"                 => 7521,
                         "marching"                => 4341,
                         "marchioness"             => 21015,
                         "mardan"                  => 27601,
                         "mardin"                  => 22414,
                         "mare"                    => 4657,
                         "marechal"                => 19245,
                         "marella"                 => 28964,
                         "marfa"                   => 28144,
                         "marga"                   => 24206,
                         "margaretha"              => 27941,
                         "margarine"               => 24134,
                         "margin"                  => 2564,
                         "marginal"                => 5449,
                         "marginalised"            => 22634,
                         "marginalization"         => 23750,
                         "marginalized"            => 11781,
                         "marginata"               => 28691,
                         "margins"                 => 6251,
                         "margrave"                => 10399,
                         "margraves"               => 29983,
                         "margraviate"             => 23461,
                         "margrethe"               => 24256,
                         "marianas"                => 13446,
                         "maribor"                 => 12208,
                         "maricopa"                => 17102,
                         "mariinsky"               => 22823,
                         "marikina"                => 22296,
                         "marinette"               => 28445,
                         "marionette"              => 22835,
                         "marischal"               => 28505,
                         "marist"                  => 12602,
                         "maritima"                => 23536,
                         "maritime"                => 2632,
                         "maritimes"               => 15337,
                         "maritimo"                => 25634,
                         "markazi"                 => 13621,
                         "marked"                  => 1292,
                         "markedly"                => 9340,
                         "markers"                 => 5849,
                         "market"                  => 494,
                         "marketed"                => 3962,
                         "marketer"                => 21667,
                         "marketers"               => 16808,
                         "marketing"               => 1768,
                         "marketplace"             => 6442,
                         "marketplaces"            => 27862,
                         "markets"                 => 1857,
                         "marking"                 => 3906,
                         "markings"                => 5336,
                         "markov"                  => 12231,
                         "marksman"                => 18379,
                         "marksmen"                => 24759,
                         "markt"                   => 25689,
                         "markup"                  => 13406,
                         "marlborough"             => 7657,
                         "marmara"                 => 17460,
                         "marne"                   => 8246,
                         "maronite"                => 14426,
                         "maronites"               => 28619,
                         "maroons"                 => 11518,
                         "marque"                  => 12299,
                         "marquee"                 => 12087,
                         "marquesas"               => 24418,
                         "marquess"                => 6552,
                         "marrakech"               => 18905,
                         "marrakesh"               => 20993,
                         "marred"                  => 10073,
                         "married"                 => 297,
                         "mars"                    => 2955,
                         "marsalis"                => 18150,
                         "marshal"                 => 3516,
                         "marshalling"             => 16231,
                         "marshalls"               => 19032,
                         "marshes"                 => 6370,
                         "marshfield"              => 20631,
                         "marshland"               => 16594,
                         "marshlands"              => 27197,
                         "marshy"                  => 12983,
                         "marsupial"               => 22598,
                         "marsupials"              => 22177,
                         "martial"                 => 2580,
                         "martinique"              => 10046,
                         "martinsburg"             => 22232,
                         "martinsville"            => 15646,
                         "martinus"                => 26850,
                         "martius"                 => 27394,
                         "martyrdom"               => 9892,
                         "martyred"                => 13816,
                         "martyrology"             => 24766,
                         "martyrs"                 => 7072,
                         "maruti"                  => 22854,
                         "marvell"                 => 28420,
                         "marvels"                 => 19163,
                         "marxian"                 => 26986,
                         "marxism"                 => 8864,
                         "marxist"                 => 5323,
                         "marxists"                => 17510,
                         "maryborough"             => 18606,
                         "maryhill"                => 27931,
                         "maryland"                => 1492,
                         "marylebone"              => 9556,
                         "marymount"               => 16419,
                         "marysville"              => 17036,
                         "maryville"               => 24254,
                         "masaaki"                 => 29431,
                         "masada"                  => 25723,
                         "masala"                  => 19269,
                         "masao"                   => 29171,
                         "masaryk"                 => 23861,
                         "masashi"                 => 28956,
                         "masato"                  => 21090,
                         "masayuki"                => 29289,
                         "mascarene"               => 25554,
                         "mascot"                  => 4323,
                         "mascots"                 => 13905,
                         "masculine"               => 5735,
                         "masculinity"             => 13898,
                         "mashhad"                 => 15030,
                         "mashonaland"             => 25485,
                         "mashup"                  => 23406,
                         "masjid"                  => 9186,
                         "masonic"                 => 7257,
                         "masonry"                 => 6809,
                         "masood"                  => 17866,
                         "masoretic"               => 26068,
                         "masovia"                 => 24231,
                         "masovian"                => 5954,
                         "masque"                  => 14490,
                         "mass"                    => 945,
                         "massachusetts"           => 1105,
                         "massacre"                => 3143,
                         "massacred"               => 10898,
                         "massacres"               => 9109,
                         "massed"                  => 14835,
                         "massena"                 => 17245,
                         "massenet"                => 21413,
                         "masses"                  => 4404,
                         "massif"                  => 8351,
                         "massillon"               => 20758,
                         "massing"                 => 19744,
                         "massively"               => 11396,
                         "massoud"                 => 19747,
                         "masted"                  => 18913,
                         "masterchef"              => 19761,
                         "masterclasses"           => 24721,
                         "mastered"                => 7358,
                         "mastering"               => 10156,
                         "masterly"                => 28201,
                         "masterpieces"            => 11424,
                         "masterplan"              => 22588,
                         "masterton"               => 22402,
                         "masterworks"             => 21858,
                         "mastery"                 => 9158,
                         "masthead"                => 20331,
                         "mastodon"                => 21435,
                         "masts"                   => 9788,
                         "masud"                   => 26709,
                   