let host = "linux"
let version = "2.1.3"
let git_commit = "b6d8db9b"
let git_snapshot = false
let conf = Utils.conf
let var_script = ref "default"
let substs = ref
    [
      "<script>", (fun () -> !var_script);
      "<pid>", (fun () -> string_of_int (Unix.getpid ()));
      "<home>", (fun () -> try Sys.getenv "HOME" with Not_found -> "<home>");
    ]
let add_subst r s = substs := (r, fun () -> s) :: !substs
let subst_vars s =
  List.fold_left
    (fun v (r, s) -> Str.global_replace (Str.regexp r) (s ()) v)
     s !substs
let big_endian = false
let findlib_path = ["/tmp/liquidsoap-full/ocaml-mm/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-duppy/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-dtools/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-mem_usage/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-lo/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-lastfm/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-xmlplaylist/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-dssi/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-frei0r/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-samplerate/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-soundtouch/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-ladspa/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-flac/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-faad/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-fdkaac/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-opus/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-theora/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-speex/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-vorbis/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-ogg/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-shine/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-lame/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-taglib/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-mad/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-ffmpeg/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-srt/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-bjack/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-pulseaudio/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-alsa/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-portaudio/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-ao/_build/install/default/lib";"/tmp/liquidsoap-full/ocaml-cry/_build/install/default/lib";"/home/opam/.opam/4.14.0/lib"]
let dynlink = true
let () =
  Lifecycle.before_init (fun () ->
    Dyntools.load_dynlinks ())
let () =
  Ssl_threads.init ();
  Ssl.init ()
let magic_cookie = Magic.create ~flags:[Magic.Mime; Magic.Symlink] []
let file_mime = Some (Magic.file magic_cookie)
let camomile_dir = "/usr/share/liquidsoap/camomile"
module CamomileCharEncoding = CamomileLibrary.CharEncoding.Configure(struct
  let datadir = Filename.concat camomile_dir "database"
  let localedir = Filename.concat camomile_dir "locales"
  let charmapdir = Filename.concat camomile_dir "charmaps"
  let unimapdir = Filename.concat camomile_dir "mappings"
end)

exception Unknown_encoding of string

let enc_of_name s =
  try CamomileCharEncoding.of_name s with
    | Not_found -> raise (Unknown_encoding s)

let conf_tag =
  Dtools.Conf.void ~p:(conf#plug "tag") "Settings related to metadata tags"
let conf_encoding =
  (* The ["foo";"bla"] may be stripped by configure here.. We avoided it by chance because
   * the configure script takes conf_tag#plug as the beginning of a comment.
   * Don't forget this when modifying this inclusion later... *)
  Dtools.Conf.list ~p:(conf_tag#plug "encodings") ~d:["UTF-8";"ISO-8859-1"]
    "List of encodings to try for automatic encoding detection"

let custom_encoding = ref None

let get_encoding () =
  match !custom_encoding with
    | Some e -> e
    | None ->
        let encs = conf_encoding#get in
        let e = CamomileCharEncoding.automatic "LIQ-TAGS" (List.map enc_of_name encs) CamomileCharEncoding.utf8 in
          custom_encoding := Some e ;
          e

let camolog = Log.make ["camomile"]

exception Input_encoding of string
exception Output_encoding of string

let recode_tag ?in_enc ?out_enc s =
  try
    let in_enc =
      try
       match in_enc with
         | Some e -> enc_of_name e
         | None -> get_encoding ()
      with Unknown_encoding s ->
             raise (Input_encoding s)
    in
    let out_enc =
      try
       match out_enc with
         | Some e -> enc_of_name e
         | None -> CamomileCharEncoding.utf8
      with Unknown_encoding s ->
             raise (Output_encoding s)
    in
      try CamomileCharEncoding.recode_string ~in_enc ~out_enc s with e ->
        let in_enc =
          if in_enc == get_encoding () then
            Printf.sprintf "auto(%s)" (String.concat "," conf_encoding#get)
          else
            CamomileCharEncoding.name_of in_enc
        in
        camolog#important "Failed to convert %S from %s to %s (%s)!"
          s in_enc (CamomileCharEncoding.name_of out_enc) (Printexc.to_string e) ;
        s
  with
    | Unknown_encoding e ->
          camolog#important "Failed to convert %S: unknown encoding %s"
              s e ; s
    | Input_encoding e ->
          camolog#important "Failed to convert %S: unknown input encoding %s"
              s e ; s
    | Output_encoding e ->
          camolog#important "Failed to convert %S: unknown output encoding %s"
              s e ; s
    | e ->
          camolog#important "Failed to convert %S: unknown error %s"
              s (Printexc.to_string e) ; s

let env_has key = try ignore (Sys.getenv key) ; true with Not_found -> false

let recode_tag =
  if env_has "LIQ_DISABLE_CAMOMILE" then
    fun ?in_enc:_ ?out_enc:_ s -> s
  else
    recode_tag
let file_watcher = ref File_watcher_mtime.watch
let requests_max_id = 50
let requests_table_size = 50
let default_font = "/usr/share/fonts/truetype/dejavu/DejaVuSans.ttf"
let libs_versions = " bytes=[distributed with OCaml 4.02 or above] posix-time2=2.0.0 pcre=7.5.0 sedlex=3.0 menhirLib=20220210 curl=0.9.2 uri=4.2.0 memtrace=v0.2.2 mem_usage=0.0.4 dtools=0.4.4 duppy=0.9.3 cry=0.6.8 mm=0.8.2 xmlplaylist=0.1.5 lastfm=0.3.3 ogg=0.7.3 ogg.decoder=0.7.3 vorbis=0.8.1 vorbis.decoder=0.8.1 opus=0.2.3 opus.decoder=0.2.3 speex=0.4.1 speex.decoder=0.4.1 mad=0.5.2 flac=0.3.1 flac.ogg=0.3.1 flac.decoder=0.3.1 dynlink=[distributed with Ocaml] lame=0.3.6 shine=0.2.3 frei0r=0.1.2 fdkaac=0.3.2 theora=0.4.0 theora.decoder=0.4.0 ffmpeg=1.1.6 bjack=0.1.6 alsa=0.3.0 ao=0.2.4 samplerate=0.1.6 taglib=0.3.10 ssl=0.5.9 magic=0.7.3 camomile=1.0.2 faad=0.5.2 soundtouch=0.1.9 portaudio=0.2.3 pulseaudio=0.1.5 ladspa=0.2.2 dssi=0.1.5 tsdl=v0.9.9 tsdl-ttf=0.3.2 tsdl-image=0.3.2 camlimages=4.2.6 camlimages.freetype=5.0.4 cohttp-lwt-unix=5.0.0 prometheus-app=1.2 srt.constants=0.2.2 srt.types=0.2.2 srt.stubs=0.2.2 srt.stubs.locked=0.2.2 srt=0.2.2 lo=0.2.0 gd=1.0a5"
let rundir = "/var/run/liquidsoap"
let logdir = "/var/log/liquidsoap"
let liq_libs_dir = "/usr/share/liquidsoap/2.1.3/libs"
let bin_dir = "/usr/share/liquidsoap/2.1.3/bin"
let () = add_subst "<sysrundir>" "/var/run/liquidsoap"
let () = add_subst "<syslogdir>" "/var/log/liquidsoap"
let restart = ref false
let display_types = ref false
let exe_ext = ""
let vendor =                   Printf.sprintf "Liquidsoap/%s (%s; OCaml %s)"                      version Sys.os_type Sys.ocaml_version
let () = Printexc.record_backtrace true
let path =           let s = try Sys.getenv "PATH" with Not_found -> "" in           bin_dir :: (Str.split (Str.regexp_string ":") s)
