<?php
/**
 * This class set the default menu in knowledgeroot
 *
 * @package Knowledgeroot
 * @author Frank Habermann
 * @version $Id: class-default-menu.php 679 2009-04-02 22:24:00Z lordlamer $
 */
class default_menu {

	var $CLASS;
	var $defaultmenu = array();

	/**
	 * init/start class
	 */
	function start(&$CLASS) {
		$this->CLASS =& $CLASS;
		$this->set_default_menu();
		$this->load_default_menu();
	}

	/**
	 *
	 */
	function load_default_menu() {
		$this->CLASS['kr_extension']->menu = array_merge_recursive($this->CLASS['kr_extension']->menu, $this->defaultmenu);
	}

	/**
	 *
	 */
	function set_default_menu() {
		// BEGIN TOP MENU
		// login
		$this->defaultmenu['top']['login']['name'] = T_('login');
		$this->defaultmenu['top']['login']['link'] = "index.php?action=login";
		$this->defaultmenu['top']['login']['tooltip'] = "login";
		$this->defaultmenu['top']['login']['logout'] = "1";
		$this->defaultmenu['top']['login']['priority'] = "10";

		// logout
		$this->defaultmenu['top']['logout']['name'] = T_('logout');
		$this->defaultmenu['top']['logout']['link'] = "index.php?action=logout";
		$this->defaultmenu['top']['logout']['tooltip'] = "logout";
		$this->defaultmenu['top']['logout']['login'] = "1";
		$this->defaultmenu['top']['logout']['priority'] = "90";

		// roots
		$this->defaultmenu['top']['roots']['name'] = T_('roots');
		$this->defaultmenu['top']['roots']['link'] = "index.php?action=createroot";
		$this->defaultmenu['top']['roots']['tooltip'] = "create root";
		$this->defaultmenu['top']['roots']['login'] = "1";
		$this->defaultmenu['top']['roots']['priority'] = "10";
		$this->defaultmenu['top']['roots']['admin'] = "1";

		// user
		$this->defaultmenu['top']['user']['name'] = T_('user');
		$this->defaultmenu['top']['user']['link'] = "index.php?action=users";
		$this->defaultmenu['top']['user']['tooltip'] = "create users";
		$this->defaultmenu['top']['user']['login'] = "1";
		$this->defaultmenu['top']['user']['priority'] = "20";
		$this->defaultmenu['top']['user']['admin'] = "1";

		// options
		$this->defaultmenu['top']['options']['name'] = T_('options');
		$this->defaultmenu['top']['options']['link'] = "index.php?action=options";
		$this->defaultmenu['top']['options']['tooltip'] = "edit options";
		$this->defaultmenu['top']['options']['login'] = "1";
		$this->defaultmenu['top']['options']['priority'] = "30";
		// END TOP MENU

		// BEGIN TREE NAVI
		// hide button
		$this->defaultmenu['tree']['hide']['name'] = T_('hide menu');
		$this->defaultmenu['tree']['hide']['image'] = "images/left.gif";
		$this->defaultmenu['tree']['hide']['imagewidth'] = "22";
		$this->defaultmenu['tree']['hide']['link'] = "javascript:;";
		$this->defaultmenu['tree']['hide']['atagparams'] = "onclick=\"HideTree();\"";
		$this->defaultmenu['tree']['hide']['wrap'] = "<td>|</td>";
		$this->defaultmenu['tree']['hide']['priority'] = "10";

		// expand all
		$this->defaultmenu['tree']['expand']['name'] = T_('expand menu');
		$this->defaultmenu['tree']['expand']['image'] = "images/plus.gif";
		$this->defaultmenu['tree']['expand']['imagewidth'] = "22";
		$this->defaultmenu['tree']['expand']['link'] = "javascript:;";
		$this->defaultmenu['tree']['expand']['atagparams'] = "onclick=\"TreeExpand(".'{$ID}'.");\"";
		$this->defaultmenu['tree']['expand']['wrap'] = "<td>|</td>";
		$this->defaultmenu['tree']['expand']['priority'] = "20";

		// reload all
		$this->defaultmenu['tree']['reload']['name'] = T_('reload menu');
		$this->defaultmenu['tree']['reload']['image'] = "images/reload.gif";
		$this->defaultmenu['tree']['reload']['imagewidth'] = "22";
		$this->defaultmenu['tree']['reload']['link'] = "javascript:;";
		$this->defaultmenu['tree']['reload']['atagparams'] = "onclick=\"TreeReload(".'{$ID}'.");\"";
		$this->defaultmenu['tree']['reload']['wrap'] = "<td>|</td>";
		$this->defaultmenu['tree']['reload']['priority'] = "30";

		// collapse all
		$this->defaultmenu['tree']['collapse']['name'] = T_('collapse menu');
		$this->defaultmenu['tree']['collapse']['image'] = "images/minus.gif";
		$this->defaultmenu['tree']['collapse']['imagewidth'] = "22";
		$this->defaultmenu['tree']['collapse']['link'] = "javascript:;";
		$this->defaultmenu['tree']['collapse']['atagparams'] = "onclick=\"TreeCollapse(".'{$ID}'.");\"";
		$this->defaultmenu['tree']['collapse']['wrap'] = "<td>|</td>";
		$this->defaultmenu['tree']['collapse']['priority'] = "40";

		// checking treestyle and slide
		if($this->CLASS['vars']['menu']['type'] == "static") {
			$fixedstyle = "style=\"display:none;\"";
			$slidestyle = "style=\"display:block;\"";
		} else {
			$fixedstyle = "style=\"display:block;\"";
			$slidestyle = "style=\"display:none;\"";
		}

		// tree fixed
		$this->defaultmenu['tree']['fixed']['name'] = T_('show menu');
		$this->defaultmenu['tree']['fixed']['image'] = "images/fixed.gif";
		$this->defaultmenu['tree']['fixed']['imagewidth'] = "22";
		$this->defaultmenu['tree']['fixed']['link'] = "javascript:;";
		$this->defaultmenu['tree']['fixed']['atagparams'] = "onclick=\"TreeFixed();\"";
		$this->defaultmenu['tree']['fixed']['wrap'] = "<td><div id=\"treefixed\" ".$fixedstyle.">|</div>";
		$this->defaultmenu['tree']['fixed']['priority'] = "40";

		// tree slide
		$this->defaultmenu['tree']['slide']['name'] = T_('close menu');
		$this->defaultmenu['tree']['slide']['image'] = "images/close.gif";
		$this->defaultmenu['tree']['slide']['imagewidth'] = "22";
		$this->defaultmenu['tree']['slide']['link'] = "javascript:;";
		$this->defaultmenu['tree']['slide']['atagparams'] = "onclick=\"TreeSlide();\"";
		$this->defaultmenu['tree']['slide']['wrap'] = "<div id=\"treeslide\" ".$slidestyle.">|</div></td>";
		$this->defaultmenu['tree']['slide']['priority'] = "41";

		// END TREE NAVI

		// BEGIN PAGE NAVI
		// new page
		$this->defaultmenu['page']['newpage']['name'] = T_('add new page');
		$this->defaultmenu['page']['newpage']['link'] = 'index.php?id={$PAGEID}&amp;action=newpage';
		$this->defaultmenu['page']['newpage']['pagerights'] = "2";
		$this->defaultmenu['page']['newpage']['priority'] = "10";

		// edit page
		$this->defaultmenu['page']['editpage']['name'] = T_('edit page');
		$this->defaultmenu['page']['editpage']['link'] = 'index.php?id={$PAGEID}&amp;action=editpage';
		$this->defaultmenu['page']['editpage']['pagerights'] = "2";
		$this->defaultmenu['page']['editpage']['priority'] = "20";

		// move page
		$this->defaultmenu['page']['movepage']['name'] = T_('move page');
		$this->defaultmenu['page']['movepage']['link'] = "#";
		$this->defaultmenu['page']['movepage']['atagparams'] = "onclick=\"window.document.forms.move.move.value='move'; window.open('move.php?type=page','Knowledgeroot','width=310,height=400,menubar=yes,resizable=yes,scrollbars=yes');\"";
		$this->defaultmenu['page']['movepage']['pagerights'] = "2";
		$this->defaultmenu['page']['movepage']['priority'] = "30";

		// delete page
		$this->defaultmenu['page']['deletepage']['name'] = T_('delete page');
		$this->defaultmenu['page']['deletepage']['link'] = "javascript:;";
		$this->defaultmenu['page']['deletepage']['atagparams'] = "onclick=\"if(confirm('" . T_('Do you really want to delete this page?') . "')) { location.href='index.php?delpage={\$PAGEID}'; } else { return false; }\"";
		$this->defaultmenu['page']['deletepage']['pagerights'] = "2";
		$this->defaultmenu['page']['deletepage']['priority'] = "40";

		// create new content
		$this->defaultmenu['page']['createcontent']['name'] = T_('add new content');
		$this->defaultmenu['page']['createcontent']['link'] = 'index.php?id={$PAGEID}&amp;action=newcontent';
		$this->defaultmenu['page']['createcontent']['pagerights'] = "2";
		$this->defaultmenu['page']['createcontent']['priority'] = "50";

		// END PAGE NAVI

		// BEGIN CONTENT NAVI
		// edit content
		$this->defaultmenu['content']['editcontent']['name'] = T_('edit content');
		$this->defaultmenu['content']['editcontent']['link'] = 'index.php?id={$PAGEID}&amp;eid=';
		$this->defaultmenu['content']['editcontent']['addid'] = "1";
		$this->defaultmenu['content']['editcontent']['contentrights'] = "2";
		$this->defaultmenu['content']['editcontent']['priority'] = "10";
		$this->defaultmenu['content']['editcontent']['contenttype'] = "text";

		// delete content
		$this->defaultmenu['content']['deletecontent']['name'] = T_('delete content');
		$this->defaultmenu['content']['deletecontent']['link'] = 'javascript:;';
		$this->defaultmenu['content']['deletecontent']['atagparams'] = "onclick=\"if(confirm('" . T_('Do you really want to delete?') . "')) { location.href='index.php?id={\$PAGEID}&amp;delid={\$ID}'; } else { return false; }\"";
		$this->defaultmenu['content']['deletecontent']['contentrights'] = "2";
		$this->defaultmenu['content']['deletecontent']['priority'] = "20";
		$this->defaultmenu['content']['deletecontent']['contenttype'] = "text";

		// move content
		$this->defaultmenu['content']['movecontent']['name'] = T_('move content');
		$this->defaultmenu['content']['movecontent']['link'] = "#";
		$this->defaultmenu['content']['movecontent']['atagparams'] = "onclick=\"window.document.forms.move.contentid.value='".'{$ID}'."'; window.document.forms.move.move.value='cmove'; window.open('move.php','Knowledgeroot','width=310,height=400,menubar=yes,resizable=yes,scrollbars=yes');\"";
		$this->defaultmenu['content']['movecontent']['contentrights'] = "2";
		$this->defaultmenu['content']['movecontent']['pagerights'] = "2";
		$this->defaultmenu['content']['movecontent']['priority'] = "30";
		$this->defaultmenu['content']['movecontent']['contenttype'] = "text";

		// content history
		/*
		$this->defaultmenu['content']['contenthistory']['name'] = $this->CLASS['language']->get['contenthistory'];
		$this->defaultmenu['content']['contenthistory']['link'] = "index.php?action=contenthistory&historyof=";
		$this->defaultmenu['content']['contenthistory']['addid'] = "1";
		$this->defaultmenu['content']['contenthistory']['priority'] = "35";
		$this->defaultmenu['content']['contenthistory']['contenttype'] = "text";
		*/

		// add file
		$this->defaultmenu['content']['addfile']['name'] = T_('add file');
		$this->defaultmenu['content']['addfile']['link'] = "#";
		$this->defaultmenu['content']['addfile']['addid'] = "1";
		$this->defaultmenu['content']['addfile']['atagparams'] = "onclick=\"return ShowById('fileform_".'{$ID}'."');\"";
		$this->defaultmenu['content']['addfile']['contentrights'] = "2";
		$this->defaultmenu['content']['addfile']['priority'] = "40";
		$this->defaultmenu['content']['addfile']['contenttype'] = "text";

		// END CONTENT NAVI

		// BEGIN CONTENT_LINE NAVI
		$this->defaultmenu['contentline']['top']['name'] = T_('Top');
		$this->defaultmenu['contentline']['top']['link'] = "#top";
		$this->defaultmenu['contentline']['top']['tooltip'] = T_('Goto Top');
		$this->defaultmenu['contentline']['top']['priority'] = "20";

		$this->defaultmenu['contentline']['move']['name'] = T_('move');
		$this->defaultmenu['contentline']['move']['link'] = "javascript:;";
		$this->defaultmenu['contentline']['move']['image'] = "images/drag.gif";
		$this->defaultmenu['contentline']['move']['atagparams'] = "id=\"contentdragicon_{\$ID}\"";
		$this->defaultmenu['contentline']['move']['wrap'] = "|<a id=\"contentdragid_{\$ID}\" href=\"#\"></a><script type=\"text/javascript\" language=\"javascript\">\nvar navig_agt=navigator.userAgent.toLowerCase();\nvar navig_ie=((navig_agt.indexOf(\"msie\")!=-1) && (navig_agt.indexOf(\"opera\")==-1));\nvar navig_ie8=(navig_ie && (navig_agt.indexOf(\"msie 8.\")!=-1));\nif((navigator.appName.toLowerCase() != \"opera\" && !document.all) || navig_ie8) {";
		$this->defaultmenu['contentline']['move']['wrap'] .= "new Draggable('contentdragid_{\$ID}', {handle: 'contentdragicon_{\$ID}', revert:true, ghosting: false, zindex: 900, starteffect:function() { if(\$('contenttitleid_{\$ID}').innerHTML != \"\") { Dragbox.show(\$('contenttitleid_{\$ID}').innerHTML); } else { Dragbox.show('".T_('content')."'); } }, endeffect:function() { Dragbox.hide(); } });";
		$this->defaultmenu['contentline']['move']['wrap'] .= "} </script>";
		$this->defaultmenu['contentline']['move']['tooltip'] = T_('move content');
		$this->defaultmenu['contentline']['move']['priority'] = "10";
		// END CONTENT_LINE NAVI

		// BEGIN TREEBOTTOM MENU
		$this->defaultmenu['treebottom']['config']['wrap'] = "<ul id=\"treebottom\">|</ul>";
		$this->defaultmenu['treebottom']['config']['admin'] = "1";

		// save default tree layout
		if(isset($this->CLASS['vars']['menu']['defaultlayout']) && $this->CLASS['vars']['menu']['defaultlayout'] == "1") {
			$this->defaultmenu['treebottom']['defaulttree']['name'] = T_('save as default tree');
			$this->defaultmenu['treebottom']['defaulttree']['link'] = 'index.php?action=savedefaulttree';
			$this->defaultmenu['treebottom']['defaulttree']['wrap'] = "<li>&raquo;&nbsp;|</li>";
			$this->defaultmenu['treebottom']['defaulttree']['priority'] = "20";
			$this->defaultmenu['treebottom']['defaulttree']['admin'] = "1";
		}

		if(isset($this->CLASS['vars']['menu']['showsourceforgelogo']) && $this->CLASS['vars']['menu']['showsourceforgelogo'] == "1") {
			$this->defaultmenu['treebottom']['sourceforge']['name'] = T_('Sourceforge');
			$this->defaultmenu['treebottom']['sourceforge']['link'] = 'http://sourceforge.net';
			$this->defaultmenu['treebottom']['sourceforge']['wrap'] = "<li style=\"text-align: center;\">|</li>";
			$this->defaultmenu['treebottom']['sourceforge']['image'] = "http://sflogo.sourceforge.net/sflogo.php?group_id=157374&amp;type=1";
			$this->defaultmenu['treebottom']['sourceforge']['priority'] = "90";
		}

		// END TREEBOTTOM MENU

		// BEGIN TREE CONTEXT MENU
		// configure menu
		$this->defaultmenu['pagecontext']['config']['wrap'] = "<table id=\"pagecontext\" class=\"contextmenu\" cellpadding=\"0\" cellspacing=\"0\">|</table>";

		// new page
		$this->defaultmenu['pagecontext']['newpage']['name'] = T_('add new page');
		$this->defaultmenu['pagecontext']['newpage']['link'] = 'index.php?id={$PAGEID}&action=newpage';
		$this->defaultmenu['pagecontext']['newpage']['pagerights'] = "2";
		$this->defaultmenu['pagecontext']['newpage']['priority'] = "10";
		$this->defaultmenu['pagecontext']['newpage']['wrap'] = "<tr class=\"contextmenu-item-row\"><td class=\"contextmenu-item\">|</td><td class=\"contextmenu-item-img\"><img src=\"images/pages.gif\" /></td></tr>";

		// edit page
		$this->defaultmenu['pagecontext']['editpage']['name'] = T_('edit page');
		$this->defaultmenu['pagecontext']['editpage']['link'] = 'index.php?id={$PAGEID}&action=editpage';
		$this->defaultmenu['pagecontext']['editpage']['pagerights'] = "2";
		$this->defaultmenu['pagecontext']['editpage']['priority'] = "20";
		$this->defaultmenu['pagecontext']['editpage']['wrap'] = "<tr class=\"contextmenu-item-row\"><td class=\"contextmenu-item\">|</td><td class=\"contextmenu-item-img\"><img src=\"images/pages.gif\" /></td></tr>";

		// move page
		$this->defaultmenu['pagecontext']['movepage']['name'] = T_('move page');
		$this->defaultmenu['pagecontext']['movepage']['link'] = "#";
		$this->defaultmenu['pagecontext']['movepage']['atagparams'] = "onclick=\"window.document.forms.move.move.value='move'; window.open('move.php?type=page','Knowledgeroot','width=310,height=400,menubar=yes,resizable=yes,scrollbars=yes');\"";
		$this->defaultmenu['pagecontext']['movepage']['pagerights'] = "2";
		$this->defaultmenu['pagecontext']['movepage']['priority'] = "30";
		$this->defaultmenu['pagecontext']['movepage']['wrap'] = "<tr class=\"contextmenu-item-row\"><td class=\"contextmenu-item\">|</td><td class=\"contextmenu-item-img\"><img src=\"images/pages.gif\" /></td></tr>";

		// delete page
		$this->defaultmenu['pagecontext']['deletepage']['name'] = T_('delete page');
		$this->defaultmenu['pagecontext']['deletepage']['link'] = "javascript:;";
		$this->defaultmenu['pagecontext']['deletepage']['atagparams'] = "onclick=\"if(confirm('" . T_('Do you really want to delete this page?') . "')) { location.href='index.php?delpage={\$PAGEID}'; } else { return false; }\"";
		$this->defaultmenu['pagecontext']['deletepage']['pagerights'] = "2";
		$this->defaultmenu['pagecontext']['deletepage']['priority'] = "40";
		$this->defaultmenu['pagecontext']['deletepage']['wrap'] = "<tr class=\"contextmenu-item-row\"><td class=\"contextmenu-item\">|</td><td class=\"contextmenu-item-img\"><img src=\"images/pages.gif\" /></td></tr>";

		// add empty line
		$this->defaultmenu['pagecontext']['line']['name'] = "";
		$this->defaultmenu['pagecontext']['line']['link'] = '';
		$this->defaultmenu['pagecontext']['line']['pagerights'] = "2";
		$this->defaultmenu['pagecontext']['line']['priority'] = "45";
		$this->defaultmenu['pagecontext']['line']['wrap'] = "<tr class=\"contextmenu-line-row\"><td colspan=\"2\"><img src=\"images/clear.gif\" width=\"1\" height=\"1\" />|</td></tr>";

		// create new content
		$this->defaultmenu['pagecontext']['createcontent']['name'] = T_('add new content');
		$this->defaultmenu['pagecontext']['createcontent']['link'] = 'index.php?id={$PAGEID}&amp;action=newcontent';
		$this->defaultmenu['pagecontext']['createcontent']['pagerights'] = "2";
		$this->defaultmenu['pagecontext']['createcontent']['priority'] = "50";
		$this->defaultmenu['pagecontext']['createcontent']['wrap'] = "<tr class=\"contextmenu-item-row\"><td class=\"contextmenu-item\">|</td><td class=\"contextmenu-item-img\"><img src=\"images/pages.gif\" /></td></tr>";
		// END TREE CONTEXT MENU

		// BEGIN CONTENT CONTEXT MENU
		// configure menu
		$this->defaultmenu['contentcontext']['config']['wrap'] = "<table id=\"pagecontext\" class=\"contextmenu\" cellpadding=\"0\" cellspacing=\"0\">|</table>";

		// create new content
		$this->defaultmenu['contentcontext']['createcontent']['name'] = T_('add new content');
		$this->defaultmenu['contentcontext']['createcontent']['link'] = 'index.php?id={$PAGEID}&amp;action=newcontent';
		$this->defaultmenu['contentcontext']['createcontent']['pagerights'] = "2";
		$this->defaultmenu['contentcontext']['createcontent']['priority'] = "10";
		$this->defaultmenu['contentcontext']['createcontent']['wrap'] = "<tr class=\"contextmenu-item-row\"><td class=\"contextmenu-item\">|</td><td class=\"contextmenu-item-img\"><img src=\"images/pages.gif\" /></td></tr>";
		
		// edit content
		$this->defaultmenu['contentcontext']['editcontent']['name'] = T_('edit content');
		$this->defaultmenu['contentcontext']['editcontent']['link'] = 'index.php?id={$PAGEID}&amp;eid=';
		$this->defaultmenu['contentcontext']['editcontent']['addid'] = "1";
		$this->defaultmenu['contentcontext']['editcontent']['contentrights'] = "2";
		$this->defaultmenu['contentcontext']['editcontent']['priority'] = "20";
		$this->defaultmenu['contentcontext']['editcontent']['contenttype'] = "text";
		$this->defaultmenu['contentcontext']['editcontent']['wrap'] = "<tr class=\"contextmenu-item-row\"><td class=\"contextmenu-item\">|</td><td class=\"contextmenu-item-img\"><img src=\"images/pages.gif\" /></td></tr>";

		// delete content
		$this->defaultmenu['contentcontext']['deletecontent']['name'] = T_('delete content');
		$this->defaultmenu['contentcontext']['deletecontent']['link'] = 'javascript:;';
		$this->defaultmenu['contentcontext']['deletecontent']['atagparams'] = "onclick=\"if(confirm('" . T_('Do you really want to delete?') . "')) { location.href='index.php?id={\$PAGEID}&amp;delid={\$ID}'; } else { return false; }\"";
		$this->defaultmenu['contentcontext']['deletecontent']['contentrights'] = "2";
		$this->defaultmenu['contentcontext']['deletecontent']['priority'] = "30";
		$this->defaultmenu['contentcontext']['deletecontent']['contenttype'] = "text";
		$this->defaultmenu['contentcontext']['deletecontent']['wrap'] = "<tr class=\"contextmenu-item-row\"><td class=\"contextmenu-item\">|</td><td class=\"contextmenu-item-img\"><img src=\"images/pages.gif\" /></td></tr>";

		// move content
		$this->defaultmenu['contentcontext']['movecontent']['name'] = T_('move content');
		$this->defaultmenu['contentcontext']['movecontent']['link'] = "#";
		$this->defaultmenu['contentcontext']['movecontent']['atagparams'] = "onclick=\"window.document.forms.move.contentid.value='".'{$ID}'."'; window.document.forms.move.move.value='cmove'; window.open('move.php','Knowledgeroot','width=310,height=400,menubar=yes,resizable=no');\"";
		$this->defaultmenu['contentcontext']['movecontent']['contentrights'] = "2";
		$this->defaultmenu['contentcontext']['movecontent']['pagerights'] = "2";
		$this->defaultmenu['contentcontext']['movecontent']['priority'] = "40";
		$this->defaultmenu['contentcontext']['movecontent']['contenttype'] = "text";
		$this->defaultmenu['contentcontext']['movecontent']['wrap'] = "<tr class=\"contextmenu-item-row\"><td class=\"contextmenu-item\">|</td><td class=\"contextmenu-item-img\"><img src=\"images/pages.gif\" /></td></tr>";

		// add file
		$this->defaultmenu['contentcontext']['addfile']['name'] = T_('add file');
		$this->defaultmenu['contentcontext']['addfile']['link'] = "#";
		$this->defaultmenu['contentcontext']['addfile']['addid'] = "1";
		$this->defaultmenu['contentcontext']['addfile']['atagparams'] = "onclick=\"return ShowById('fileform_".'{$ID}'."');\"";
		$this->defaultmenu['contentcontext']['addfile']['contentrights'] = "2";
		$this->defaultmenu['contentcontext']['addfile']['priority'] = "40";
		$this->defaultmenu['contentcontext']['addfile']['contenttype'] = "text";
		$this->defaultmenu['contentcontext']['addfile']['wrap'] = "<tr class=\"contextmenu-item-row\"><td class=\"contextmenu-item\">|</td><td class=\"contextmenu-item-img\"><img src=\"images/pages.gif\" /></td></tr>";

		// END CONTENT CONTEXT MENU
	}
}

?>
