
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMovie.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMovie>
#include <QChildEvent>
#include <QColor>
#include <QEvent>
#include <QIODevice>
#include <QImage>
#include <QMetaMethod>
#include <QObject>
#include <QPixmap>
#include <QRect>
#include <QSize>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMovie

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMovie::staticMetaObject);
}


// QColor QMovie::backgroundColor()


static void _init_f_backgroundColor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QColor > ();
}

static void _call_f_backgroundColor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QColor > ((QColor)((QMovie *)cls)->backgroundColor ());
}


// QMovie::CacheMode QMovie::cacheMode()


static void _init_f_cacheMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMovie::CacheMode>::target_type > ();
}

static void _call_f_cacheMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMovie::CacheMode>::target_type > ((qt_gsi::Converter<QMovie::CacheMode>::target_type)qt_gsi::CppToQtAdaptor<QMovie::CacheMode>(((QMovie *)cls)->cacheMode ()));
}


// int QMovie::currentFrameNumber()


static void _init_f_currentFrameNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentFrameNumber_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMovie *)cls)->currentFrameNumber ());
}


// QImage QMovie::currentImage()


static void _init_f_currentImage_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QImage > ();
}

static void _call_f_currentImage_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QImage > ((QImage)((QMovie *)cls)->currentImage ());
}


// QPixmap QMovie::currentPixmap()


static void _init_f_currentPixmap_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPixmap > ();
}

static void _call_f_currentPixmap_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPixmap > ((QPixmap)((QMovie *)cls)->currentPixmap ());
}


// QIODevice *QMovie::device()


static void _init_f_device_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_device_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIODevice * > ((QIODevice *)((QMovie *)cls)->device ());
}


// QString QMovie::fileName()


static void _init_f_fileName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fileName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QMovie *)cls)->fileName ());
}


// QByteArray QMovie::format()


static void _init_f_format_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_format_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QMovie *)cls)->format ());
}


// int QMovie::frameCount()


static void _init_f_frameCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_frameCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMovie *)cls)->frameCount ());
}


// QRect QMovie::frameRect()


static void _init_f_frameRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_frameRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QMovie *)cls)->frameRect ());
}


// bool QMovie::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMovie *)cls)->isValid ());
}


// bool QMovie::jumpToFrame(int frameNumber)


static void _init_f_jumpToFrame_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frameNumber");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_jumpToFrame_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QMovie *)cls)->jumpToFrame (arg1));
}


// bool QMovie::jumpToNextFrame()


static void _init_f_jumpToNextFrame_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_jumpToNextFrame_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMovie *)cls)->jumpToNextFrame ());
}


// QImageReader::ImageReaderError QMovie::lastError()


static void _init_f_lastError_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QImageReader::ImageReaderError>::target_type > ();
}

static void _call_f_lastError_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QImageReader::ImageReaderError>::target_type > ((qt_gsi::Converter<QImageReader::ImageReaderError>::target_type)qt_gsi::CppToQtAdaptor<QImageReader::ImageReaderError>(((QMovie *)cls)->lastError ()));
}


// QString QMovie::lastErrorString()


static void _init_f_lastErrorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_lastErrorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QMovie *)cls)->lastErrorString ());
}


// int QMovie::loopCount()


static void _init_f_loopCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_loopCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMovie *)cls)->loopCount ());
}


// int QMovie::nextFrameDelay()


static void _init_f_nextFrameDelay_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_nextFrameDelay_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMovie *)cls)->nextFrameDelay ());
}


// QSize QMovie::scaledSize()


static void _init_f_scaledSize_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_scaledSize_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QMovie *)cls)->scaledSize ());
}


// void QMovie::setBackgroundColor(const QColor &color)


static void _init_f_setBackgroundColor_1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("color");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackgroundColor_1905 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = gsi::arg_reader<const QColor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMovie *)cls)->setBackgroundColor (arg1);
}


// void QMovie::setCacheMode(QMovie::CacheMode mode)


static void _init_f_setCacheMode_2002 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QMovie::CacheMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCacheMode_2002 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMovie::CacheMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMovie::CacheMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMovie *)cls)->setCacheMode (qt_gsi::QtToCppAdaptor<QMovie::CacheMode>(arg1).cref());
}


// void QMovie::setDevice(QIODevice *device)


static void _init_f_setDevice_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDevice_1447 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMovie *)cls)->setDevice (arg1);
}


// void QMovie::setFileName(const QString &fileName)


static void _init_f_setFileName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFileName_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMovie *)cls)->setFileName (arg1);
}


// void QMovie::setFormat(const QByteArray &format)


static void _init_f_setFormat_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFormat_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMovie *)cls)->setFormat (arg1);
}


// void QMovie::setPaused(bool paused)


static void _init_f_setPaused_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("paused");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPaused_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMovie *)cls)->setPaused (arg1);
}


// void QMovie::setScaledSize(const QSize &size)


static void _init_f_setScaledSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScaledSize_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMovie *)cls)->setScaledSize (arg1);
}


// void QMovie::setSpeed(int percentSpeed)


static void _init_f_setSpeed_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("percentSpeed");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSpeed_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMovie *)cls)->setSpeed (arg1);
}


// int QMovie::speed()


static void _init_f_speed_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_speed_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMovie *)cls)->speed ());
}


// void QMovie::start()


static void _init_f_start_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_start_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMovie *)cls)->start ();
}


// QMovie::MovieState QMovie::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMovie::MovieState>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMovie::MovieState>::target_type > ((qt_gsi::Converter<QMovie::MovieState>::target_type)qt_gsi::CppToQtAdaptor<QMovie::MovieState>(((QMovie *)cls)->state ()));
}


// void QMovie::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMovie *)cls)->stop ();
}


// static QList<QByteArray> QMovie::supportedFormats()


static void _init_f_supportedFormats_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<QByteArray> > ();
}

static void _call_f_supportedFormats_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QByteArray> > ((QList<QByteArray>)QMovie::supportedFormats ());
}


// static QString QMovie::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMovie::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QMovie () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":backgroundColor", "@brief Method QColor QMovie::backgroundColor()\n", true, &_init_f_backgroundColor_c0, &_call_f_backgroundColor_c0);
  methods += new qt_gsi::GenericMethod (":cacheMode", "@brief Method QMovie::CacheMode QMovie::cacheMode()\n", true, &_init_f_cacheMode_c0, &_call_f_cacheMode_c0);
  methods += new qt_gsi::GenericMethod ("currentFrameNumber", "@brief Method int QMovie::currentFrameNumber()\n", true, &_init_f_currentFrameNumber_c0, &_call_f_currentFrameNumber_c0);
  methods += new qt_gsi::GenericMethod ("currentImage", "@brief Method QImage QMovie::currentImage()\n", true, &_init_f_currentImage_c0, &_call_f_currentImage_c0);
  methods += new qt_gsi::GenericMethod ("currentPixmap", "@brief Method QPixmap QMovie::currentPixmap()\n", true, &_init_f_currentPixmap_c0, &_call_f_currentPixmap_c0);
  methods += new qt_gsi::GenericMethod (":device", "@brief Method QIODevice *QMovie::device()\n", true, &_init_f_device_c0, &_call_f_device_c0);
  methods += new qt_gsi::GenericMethod (":fileName", "@brief Method QString QMovie::fileName()\n", true, &_init_f_fileName_c0, &_call_f_fileName_c0);
  methods += new qt_gsi::GenericMethod (":format", "@brief Method QByteArray QMovie::format()\n", true, &_init_f_format_c0, &_call_f_format_c0);
  methods += new qt_gsi::GenericMethod ("frameCount", "@brief Method int QMovie::frameCount()\n", true, &_init_f_frameCount_c0, &_call_f_frameCount_c0);
  methods += new qt_gsi::GenericMethod ("frameRect", "@brief Method QRect QMovie::frameRect()\n", true, &_init_f_frameRect_c0, &_call_f_frameRect_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QMovie::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("jumpToFrame", "@brief Method bool QMovie::jumpToFrame(int frameNumber)\n", false, &_init_f_jumpToFrame_767, &_call_f_jumpToFrame_767);
  methods += new qt_gsi::GenericMethod ("jumpToNextFrame", "@brief Method bool QMovie::jumpToNextFrame()\n", false, &_init_f_jumpToNextFrame_0, &_call_f_jumpToNextFrame_0);
  methods += new qt_gsi::GenericMethod ("lastError", "@brief Method QImageReader::ImageReaderError QMovie::lastError()\n", true, &_init_f_lastError_c0, &_call_f_lastError_c0);
  methods += new qt_gsi::GenericMethod ("lastErrorString", "@brief Method QString QMovie::lastErrorString()\n", true, &_init_f_lastErrorString_c0, &_call_f_lastErrorString_c0);
  methods += new qt_gsi::GenericMethod ("loopCount", "@brief Method int QMovie::loopCount()\n", true, &_init_f_loopCount_c0, &_call_f_loopCount_c0);
  methods += new qt_gsi::GenericMethod ("nextFrameDelay", "@brief Method int QMovie::nextFrameDelay()\n", true, &_init_f_nextFrameDelay_c0, &_call_f_nextFrameDelay_c0);
  methods += new qt_gsi::GenericMethod (":scaledSize", "@brief Method QSize QMovie::scaledSize()\n", false, &_init_f_scaledSize_0, &_call_f_scaledSize_0);
  methods += new qt_gsi::GenericMethod ("setBackgroundColor|backgroundColor=", "@brief Method void QMovie::setBackgroundColor(const QColor &color)\n", false, &_init_f_setBackgroundColor_1905, &_call_f_setBackgroundColor_1905);
  methods += new qt_gsi::GenericMethod ("setCacheMode|cacheMode=", "@brief Method void QMovie::setCacheMode(QMovie::CacheMode mode)\n", false, &_init_f_setCacheMode_2002, &_call_f_setCacheMode_2002);
  methods += new qt_gsi::GenericMethod ("setDevice|device=", "@brief Method void QMovie::setDevice(QIODevice *device)\n", false, &_init_f_setDevice_1447, &_call_f_setDevice_1447);
  methods += new qt_gsi::GenericMethod ("setFileName|fileName=", "@brief Method void QMovie::setFileName(const QString &fileName)\n", false, &_init_f_setFileName_2025, &_call_f_setFileName_2025);
  methods += new qt_gsi::GenericMethod ("setFormat|format=", "@brief Method void QMovie::setFormat(const QByteArray &format)\n", false, &_init_f_setFormat_2309, &_call_f_setFormat_2309);
  methods += new qt_gsi::GenericMethod ("setPaused", "@brief Method void QMovie::setPaused(bool paused)\n", false, &_init_f_setPaused_864, &_call_f_setPaused_864);
  methods += new qt_gsi::GenericMethod ("setScaledSize|scaledSize=", "@brief Method void QMovie::setScaledSize(const QSize &size)\n", false, &_init_f_setScaledSize_1805, &_call_f_setScaledSize_1805);
  methods += new qt_gsi::GenericMethod ("setSpeed|speed=", "@brief Method void QMovie::setSpeed(int percentSpeed)\n", false, &_init_f_setSpeed_767, &_call_f_setSpeed_767);
  methods += new qt_gsi::GenericMethod (":speed", "@brief Method int QMovie::speed()\n", true, &_init_f_speed_c0, &_call_f_speed_c0);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QMovie::start()\n", false, &_init_f_start_0, &_call_f_start_0);
  methods += new qt_gsi::GenericMethod ("state", "@brief Method QMovie::MovieState QMovie::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QMovie::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QMovie::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QImageReader::ImageReaderError>::target_type & > ("error(QImageReader::ImageReaderError)", "error", gsi::arg("error"), "@brief Signal declaration for QMovie::error(QImageReader::ImageReaderError error)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("finished()", "finished", "@brief Signal declaration for QMovie::finished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("frameChanged(int)", "frameChanged", gsi::arg("frameNumber"), "@brief Signal declaration for QMovie::frameChanged(int frameNumber)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QMovie::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QSize & > ("resized(const QSize &)", "resized", gsi::arg("size"), "@brief Signal declaration for QMovie::resized(const QSize &size)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("started()", "started", "@brief Signal declaration for QMovie::started()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QMovie::MovieState>::target_type & > ("stateChanged(QMovie::MovieState)", "stateChanged", gsi::arg("state"), "@brief Signal declaration for QMovie::stateChanged(QMovie::MovieState state)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QRect & > ("updated(const QRect &)", "updated", gsi::arg("rect"), "@brief Signal declaration for QMovie::updated(const QRect &rect)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("supportedFormats", "@brief Static method QList<QByteArray> QMovie::supportedFormats()\nThis method is static and can be called without an instance.", &_init_f_supportedFormats_0, &_call_f_supportedFormats_0);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMovie::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QMovie> decl_QMovie (qtdecl_QObject (), "QtGui", "QMovie_Native",
  methods_QMovie (),
  "@hide\n@alias QMovie");

GSI_QTGUI_PUBLIC gsi::Class<QMovie> &qtdecl_QMovie () { return decl_QMovie; }

}


class QMovie_Adaptor : public QMovie, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMovie_Adaptor();

  //  [adaptor ctor] QMovie::QMovie(QObject *parent)
  QMovie_Adaptor() : QMovie()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMovie::QMovie(QObject *parent)
  QMovie_Adaptor(QObject *parent) : QMovie(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMovie::QMovie(QIODevice *device, const QByteArray &format, QObject *parent)
  QMovie_Adaptor(QIODevice *device) : QMovie(device)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMovie::QMovie(QIODevice *device, const QByteArray &format, QObject *parent)
  QMovie_Adaptor(QIODevice *device, const QByteArray &format) : QMovie(device, format)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMovie::QMovie(QIODevice *device, const QByteArray &format, QObject *parent)
  QMovie_Adaptor(QIODevice *device, const QByteArray &format, QObject *parent) : QMovie(device, format, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMovie::QMovie(const QString &fileName, const QByteArray &format, QObject *parent)
  QMovie_Adaptor(const QString &fileName) : QMovie(fileName)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMovie::QMovie(const QString &fileName, const QByteArray &format, QObject *parent)
  QMovie_Adaptor(const QString &fileName, const QByteArray &format) : QMovie(fileName, format)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMovie::QMovie(const QString &fileName, const QByteArray &format, QObject *parent)
  QMovie_Adaptor(const QString &fileName, const QByteArray &format, QObject *parent) : QMovie(fileName, format, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QMovie::isSignalConnected(const QMetaMethod &signal)
  bool fp_QMovie_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QMovie::isSignalConnected(signal);
  }

  //  [expose] int QMovie::receivers(const char *signal)
  int fp_QMovie_receivers_c1731 (const char *signal) const {
    return QMovie::receivers(signal);
  }

  //  [expose] QObject *QMovie::sender()
  QObject * fp_QMovie_sender_c0 () const {
    return QMovie::sender();
  }

  //  [expose] int QMovie::senderSignalIndex()
  int fp_QMovie_senderSignalIndex_c0 () const {
    return QMovie::senderSignalIndex();
  }

  //  [emitter impl] void QMovie::destroyed(QObject *)
  void emitter_QMovie_destroyed_1302(QObject *arg1)
  {
    emit QMovie::destroyed(arg1);
  }

  //  [emitter impl] void QMovie::error(QImageReader::ImageReaderError error)
  void emitter_QMovie_error_3311(QImageReader::ImageReaderError _error)
  {
    emit QMovie::error(_error);
  }

  //  [adaptor impl] bool QMovie::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QMovie::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMovie_Adaptor, bool, QEvent *>(&QMovie_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QMovie::event(_event);
    }
  }

  //  [adaptor impl] bool QMovie::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QMovie::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMovie_Adaptor, bool, QObject *, QEvent *>(&QMovie_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QMovie::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QMovie::finished()
  void emitter_QMovie_finished_0()
  {
    emit QMovie::finished();
  }

  //  [emitter impl] void QMovie::frameChanged(int frameNumber)
  void emitter_QMovie_frameChanged_767(int frameNumber)
  {
    emit QMovie::frameChanged(frameNumber);
  }

  //  [emitter impl] void QMovie::objectNameChanged(const QString &objectName)
  void emitter_QMovie_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QMovie::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QMovie::resized(const QSize &size)
  void emitter_QMovie_resized_1805(const QSize &size)
  {
    emit QMovie::resized(size);
  }

  //  [emitter impl] void QMovie::started()
  void emitter_QMovie_started_0()
  {
    emit QMovie::started();
  }

  //  [emitter impl] void QMovie::stateChanged(QMovie::MovieState state)
  void emitter_QMovie_stateChanged_2170(QMovie::MovieState state)
  {
    emit QMovie::stateChanged(state);
  }

  //  [emitter impl] void QMovie::updated(const QRect &rect)
  void emitter_QMovie_updated_1792(const QRect &rect)
  {
    emit QMovie::updated(rect);
  }

  //  [adaptor impl] void QMovie::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QMovie::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMovie_Adaptor, QChildEvent *>(&QMovie_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QMovie::childEvent(event);
    }
  }

  //  [adaptor impl] void QMovie::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QMovie::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMovie_Adaptor, QEvent *>(&QMovie_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QMovie::customEvent(event);
    }
  }

  //  [adaptor impl] void QMovie::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QMovie::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QMovie_Adaptor, const QMetaMethod &>(&QMovie_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QMovie::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMovie::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QMovie::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMovie_Adaptor, QTimerEvent *>(&QMovie_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QMovie::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QMovie_Adaptor::~QMovie_Adaptor() { }

//  Constructor QMovie::QMovie(QObject *parent) (adaptor class)

static void _init_ctor_QMovie_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QMovie_Adaptor> ();
}

static void _call_ctor_QMovie_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QMovie_Adaptor *> (new QMovie_Adaptor (arg1));
}


//  Constructor QMovie::QMovie(QIODevice *device, const QByteArray &format, QObject *parent) (adaptor class)

static void _init_ctor_QMovie_Adaptor_4842 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return_new<QMovie_Adaptor> ();
}

static void _call_ctor_QMovie_Adaptor_4842 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  const QByteArray &arg2 = args ? gsi::arg_reader<const QByteArray & >() (args, heap) : gsi::arg_maker<const QByteArray & >() (QByteArray(), heap);
  QObject *arg3 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QMovie_Adaptor *> (new QMovie_Adaptor (arg1, arg2, arg3));
}


//  Constructor QMovie::QMovie(const QString &fileName, const QByteArray &format, QObject *parent) (adaptor class)

static void _init_ctor_QMovie_Adaptor_5420 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return_new<QMovie_Adaptor> ();
}

static void _call_ctor_QMovie_Adaptor_5420 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QByteArray &arg2 = args ? gsi::arg_reader<const QByteArray & >() (args, heap) : gsi::arg_maker<const QByteArray & >() (QByteArray(), heap);
  QObject *arg3 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QMovie_Adaptor *> (new QMovie_Adaptor (arg1, arg2, arg3));
}


// void QMovie::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMovie_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMovie_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QMovie::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMovie_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMovie_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QMovie::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QMovie_Adaptor *)cls)->emitter_QMovie_destroyed_1302 (arg1);
}


// void QMovie::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMovie_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QMovie_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// emitter void QMovie::error(QImageReader::ImageReaderError error)

static void _init_emitter_error_3311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<const qt_gsi::Converter<QImageReader::ImageReaderError>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_error_3311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImageReader::ImageReaderError>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QImageReader::ImageReaderError>::target_type & >() (args, heap);
  ((QMovie_Adaptor *)cls)->emitter_QMovie_error_3311 (arg1);
}


// bool QMovie::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMovie_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMovie_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMovie::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMovie_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMovie_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QMovie::finished()

static void _init_emitter_finished_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_finished_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMovie_Adaptor *)cls)->emitter_QMovie_finished_0 ();
}


// emitter void QMovie::frameChanged(int frameNumber)

static void _init_emitter_frameChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frameNumber");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_frameChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QMovie_Adaptor *)cls)->emitter_QMovie_frameChanged_767 (arg1);
}


// exposed bool QMovie::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QMovie_Adaptor *)cls)->fp_QMovie_isSignalConnected_c2394 (arg1));
}


// emitter void QMovie::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMovie_Adaptor *)cls)->emitter_QMovie_objectNameChanged_4567 (arg1);
}


// exposed int QMovie::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMovie_Adaptor *)cls)->fp_QMovie_receivers_c1731 (arg1));
}


// emitter void QMovie::resized(const QSize &size)

static void _init_emitter_resized_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_resized_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  ((QMovie_Adaptor *)cls)->emitter_QMovie_resized_1805 (arg1);
}


// exposed QObject *QMovie::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMovie_Adaptor *)cls)->fp_QMovie_sender_c0 ());
}


// exposed int QMovie::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMovie_Adaptor *)cls)->fp_QMovie_senderSignalIndex_c0 ());
}


// emitter void QMovie::started()

static void _init_emitter_started_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_started_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMovie_Adaptor *)cls)->emitter_QMovie_started_0 ();
}


// emitter void QMovie::stateChanged(QMovie::MovieState state)

static void _init_emitter_stateChanged_2170 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<QMovie::MovieState>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_stateChanged_2170 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMovie::MovieState>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMovie::MovieState>::target_type & >() (args, heap);
  ((QMovie_Adaptor *)cls)->emitter_QMovie_stateChanged_2170 (arg1);
}


// void QMovie::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMovie_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMovie_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QMovie::updated(const QRect &rect)

static void _init_emitter_updated_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_updated_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  ((QMovie_Adaptor *)cls)->emitter_QMovie_updated_1792 (arg1);
}


namespace gsi
{

gsi::Class<QMovie> &qtdecl_QMovie ();

static gsi::Methods methods_QMovie_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMovie::QMovie(QObject *parent)\nThis method creates an object of class QMovie.", &_init_ctor_QMovie_Adaptor_1302, &_call_ctor_QMovie_Adaptor_1302);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMovie::QMovie(QIODevice *device, const QByteArray &format, QObject *parent)\nThis method creates an object of class QMovie.", &_init_ctor_QMovie_Adaptor_4842, &_call_ctor_QMovie_Adaptor_4842);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMovie::QMovie(const QString &fileName, const QByteArray &format, QObject *parent)\nThis method creates an object of class QMovie.", &_init_ctor_QMovie_Adaptor_5420, &_call_ctor_QMovie_Adaptor_5420);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMovie::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMovie::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QMovie::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMovie::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("emit_error", "@brief Emitter for signal void QMovie::error(QImageReader::ImageReaderError error)\nCall this method to emit this signal.", false, &_init_emitter_error_3311, &_call_emitter_error_3311);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QMovie::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QMovie::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QMovie::finished()\nCall this method to emit this signal.", false, &_init_emitter_finished_0, &_call_emitter_finished_0);
  methods += new qt_gsi::GenericMethod ("emit_frameChanged", "@brief Emitter for signal void QMovie::frameChanged(int frameNumber)\nCall this method to emit this signal.", false, &_init_emitter_frameChanged_767, &_call_emitter_frameChanged_767);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QMovie::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QMovie::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMovie::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("emit_resized", "@brief Emitter for signal void QMovie::resized(const QSize &size)\nCall this method to emit this signal.", false, &_init_emitter_resized_1805, &_call_emitter_resized_1805);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMovie::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QMovie::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("emit_started", "@brief Emitter for signal void QMovie::started()\nCall this method to emit this signal.", false, &_init_emitter_started_0, &_call_emitter_started_0);
  methods += new qt_gsi::GenericMethod ("emit_stateChanged", "@brief Emitter for signal void QMovie::stateChanged(QMovie::MovieState state)\nCall this method to emit this signal.", false, &_init_emitter_stateChanged_2170, &_call_emitter_stateChanged_2170);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMovie::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_updated", "@brief Emitter for signal void QMovie::updated(const QRect &rect)\nCall this method to emit this signal.", false, &_init_emitter_updated_1792, &_call_emitter_updated_1792);
  return methods;
}

gsi::Class<QMovie_Adaptor> decl_QMovie_Adaptor (qtdecl_QMovie (), "QtGui", "QMovie",
  methods_QMovie_Adaptor (),
  "@qt\n@brief Binding of QMovie");

}


//  Implementation of the enum wrapper class for QMovie::CacheMode
namespace qt_gsi
{

static gsi::Enum<QMovie::CacheMode> decl_QMovie_CacheMode_Enum ("QtGui", "QMovie_CacheMode",
    gsi::enum_const ("CacheNone", QMovie::CacheNone, "@brief Enum constant QMovie::CacheNone") +
    gsi::enum_const ("CacheAll", QMovie::CacheAll, "@brief Enum constant QMovie::CacheAll"),
  "@qt\n@brief This class represents the QMovie::CacheMode enum");

static gsi::QFlagsClass<QMovie::CacheMode > decl_QMovie_CacheMode_Enums ("QtGui", "QMovie_QFlags_CacheMode",
  "@qt\n@brief This class represents the QFlags<QMovie::CacheMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMovie> inject_QMovie_CacheMode_Enum_in_parent (decl_QMovie_CacheMode_Enum.defs ());
static gsi::ClassExt<QMovie> decl_QMovie_CacheMode_Enum_as_child (decl_QMovie_CacheMode_Enum, "CacheMode");
static gsi::ClassExt<QMovie> decl_QMovie_CacheMode_Enums_as_child (decl_QMovie_CacheMode_Enums, "QFlags_CacheMode");

}


//  Implementation of the enum wrapper class for QMovie::MovieState
namespace qt_gsi
{

static gsi::Enum<QMovie::MovieState> decl_QMovie_MovieState_Enum ("QtGui", "QMovie_MovieState",
    gsi::enum_const ("NotRunning", QMovie::NotRunning, "@brief Enum constant QMovie::NotRunning") +
    gsi::enum_const ("Paused", QMovie::Paused, "@brief Enum constant QMovie::Paused") +
    gsi::enum_const ("Running", QMovie::Running, "@brief Enum constant QMovie::Running"),
  "@qt\n@brief This class represents the QMovie::MovieState enum");

static gsi::QFlagsClass<QMovie::MovieState > decl_QMovie_MovieState_Enums ("QtGui", "QMovie_QFlags_MovieState",
  "@qt\n@brief This class represents the QFlags<QMovie::MovieState> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMovie> inject_QMovie_MovieState_Enum_in_parent (decl_QMovie_MovieState_Enum.defs ());
static gsi::ClassExt<QMovie> decl_QMovie_MovieState_Enum_as_child (decl_QMovie_MovieState_Enum, "MovieState");
static gsi::ClassExt<QMovie> decl_QMovie_MovieState_Enums_as_child (decl_QMovie_MovieState_Enums, "QFlags_MovieState");

}

