
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQFtp.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QFtp>
#include <QChildEvent>
#include <QEvent>
#include <QIODevice>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include <QUrlInfo>
#include "gsiQt.h"
#include "gsiQtNetworkCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QFtp

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QFtp::staticMetaObject);
}


// void QFtp::abort()


static void _init_f_abort_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_abort_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFtp *)cls)->abort ();
}


// qint64 QFtp::bytesAvailable()


static void _init_f_bytesAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QFtp *)cls)->bytesAvailable ());
}


// int QFtp::cd(const QString &dir)


static void _init_f_cd_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_cd_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<int > ((int)((QFtp *)cls)->cd (arg1));
}


// void QFtp::clearPendingCommands()


static void _init_f_clearPendingCommands_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearPendingCommands_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFtp *)cls)->clearPendingCommands ();
}


// int QFtp::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFtp *)cls)->close ());
}


// int QFtp::connectToHost(const QString &host, quint16 port)


static void _init_f_connectToHost_3017 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("host");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port", true, "21");
  decl->add_arg<quint16 > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_connectToHost_3017 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  quint16 arg2 = args ? gsi::arg_reader<quint16 >() (args, heap) : gsi::arg_maker<quint16 >() (21, heap);
  ret.write<int > ((int)((QFtp *)cls)->connectToHost (arg1, arg2));
}


// QFtp::Command QFtp::currentCommand()


static void _init_f_currentCommand_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFtp::Command>::target_type > ();
}

static void _call_f_currentCommand_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFtp::Command>::target_type > ((qt_gsi::Converter<QFtp::Command>::target_type)qt_gsi::CppToQtAdaptor<QFtp::Command>(((QFtp *)cls)->currentCommand ()));
}


// QIODevice *QFtp::currentDevice()


static void _init_f_currentDevice_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_currentDevice_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIODevice * > ((QIODevice *)((QFtp *)cls)->currentDevice ());
}


// int QFtp::currentId()


static void _init_f_currentId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFtp *)cls)->currentId ());
}


// QFtp::Error QFtp::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFtp::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFtp::Error>::target_type > ((qt_gsi::Converter<QFtp::Error>::target_type)qt_gsi::CppToQtAdaptor<QFtp::Error>(((QFtp *)cls)->error ()));
}


// QString QFtp::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QFtp *)cls)->errorString ());
}


// int QFtp::get(const QString &file, QIODevice *dev, QFtp::TransferType type)


static void _init_f_get_5442 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("file");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dev", true, "0");
  decl->add_arg<QIODevice * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("type", true, "QFtp::Binary");
  decl->add_arg<const qt_gsi::Converter<QFtp::TransferType>::target_type & > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_get_5442 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QIODevice *arg2 = args ? gsi::arg_reader<QIODevice * >() (args, heap) : gsi::arg_maker<QIODevice * >() (0, heap);
  const qt_gsi::Converter<QFtp::TransferType>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QFtp::TransferType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QFtp::TransferType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QFtp::TransferType>(heap, QFtp::Binary), heap);
  ret.write<int > ((int)((QFtp *)cls)->get (arg1, arg2, qt_gsi::QtToCppAdaptor<QFtp::TransferType>(arg3).cref()));
}


// bool QFtp::hasPendingCommands()


static void _init_f_hasPendingCommands_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasPendingCommands_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFtp *)cls)->hasPendingCommands ());
}


// int QFtp::list(const QString &dir)


static void _init_f_list_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_list_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<int > ((int)((QFtp *)cls)->list (arg1));
}


// int QFtp::login(const QString &user, const QString &password)


static void _init_f_login_3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("user", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("password", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_login_3942 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<int > ((int)((QFtp *)cls)->login (arg1, arg2));
}


// int QFtp::mkdir(const QString &dir)


static void _init_f_mkdir_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_mkdir_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<int > ((int)((QFtp *)cls)->mkdir (arg1));
}


// int QFtp::put(const QByteArray &data, const QString &file, QFtp::TransferType type)


static void _init_f_put_6304 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("file");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("type", true, "QFtp::Binary");
  decl->add_arg<const qt_gsi::Converter<QFtp::TransferType>::target_type & > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_put_6304 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QFtp::TransferType>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QFtp::TransferType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QFtp::TransferType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QFtp::TransferType>(heap, QFtp::Binary), heap);
  ret.write<int > ((int)((QFtp *)cls)->put (arg1, arg2, qt_gsi::QtToCppAdaptor<QFtp::TransferType>(arg3).cref()));
}


// int QFtp::put(QIODevice *dev, const QString &file, QFtp::TransferType type)


static void _init_f_put_5442 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dev");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("file");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("type", true, "QFtp::Binary");
  decl->add_arg<const qt_gsi::Converter<QFtp::TransferType>::target_type & > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_put_5442 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QFtp::TransferType>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QFtp::TransferType>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QFtp::TransferType>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QFtp::TransferType>(heap, QFtp::Binary), heap);
  ret.write<int > ((int)((QFtp *)cls)->put (arg1, arg2, qt_gsi::QtToCppAdaptor<QFtp::TransferType>(arg3).cref()));
}


// int QFtp::rawCommand(const QString &command)


static void _init_f_rawCommand_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("command");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rawCommand_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<int > ((int)((QFtp *)cls)->rawCommand (arg1));
}


// QByteArray QFtp::readAll()


static void _init_f_readAll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_readAll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QFtp *)cls)->readAll ());
}


// int QFtp::remove(const QString &file)


static void _init_f_remove_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("file");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_remove_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<int > ((int)((QFtp *)cls)->remove (arg1));
}


// int QFtp::rename(const QString &oldname, const QString &newname)


static void _init_f_rename_3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("oldname");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("newname");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_rename_3942 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<int > ((int)((QFtp *)cls)->rename (arg1, arg2));
}


// int QFtp::rmdir(const QString &dir)


static void _init_f_rmdir_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rmdir_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<int > ((int)((QFtp *)cls)->rmdir (arg1));
}


// int QFtp::setProxy(const QString &host, quint16 port)


static void _init_f_setProxy_3017 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("host");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port");
  decl->add_arg<quint16 > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_setProxy_3017 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  quint16 arg2 = gsi::arg_reader<quint16 >() (args, heap);
  ret.write<int > ((int)((QFtp *)cls)->setProxy (arg1, arg2));
}


// int QFtp::setTransferMode(QFtp::TransferMode mode)


static void _init_f_setTransferMode_2157 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QFtp::TransferMode>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_setTransferMode_2157 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFtp::TransferMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFtp::TransferMode>::target_type & >() (args, heap);
  ret.write<int > ((int)((QFtp *)cls)->setTransferMode (qt_gsi::QtToCppAdaptor<QFtp::TransferMode>(arg1).cref()));
}


// QFtp::State QFtp::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFtp::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFtp::State>::target_type > ((qt_gsi::Converter<QFtp::State>::target_type)qt_gsi::CppToQtAdaptor<QFtp::State>(((QFtp *)cls)->state ()));
}


// static QString QFtp::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QFtp::tr (arg1, arg2));
}


// static QString QFtp::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QFtp::tr (arg1, arg2, arg3));
}


// static QString QFtp::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QFtp::trUtf8 (arg1, arg2));
}


// static QString QFtp::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QFtp::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QFtp () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("abort", "@brief Method void QFtp::abort()\n", false, &_init_f_abort_0, &_call_f_abort_0);
  methods += new qt_gsi::GenericMethod ("bytesAvailable", "@brief Method qint64 QFtp::bytesAvailable()\n", true, &_init_f_bytesAvailable_c0, &_call_f_bytesAvailable_c0);
  methods += new qt_gsi::GenericMethod ("cd", "@brief Method int QFtp::cd(const QString &dir)\n", false, &_init_f_cd_2025, &_call_f_cd_2025);
  methods += new qt_gsi::GenericMethod ("clearPendingCommands", "@brief Method void QFtp::clearPendingCommands()\n", false, &_init_f_clearPendingCommands_0, &_call_f_clearPendingCommands_0);
  methods += new qt_gsi::GenericMethod ("close", "@brief Method int QFtp::close()\n", false, &_init_f_close_0, &_call_f_close_0);
  methods += new qt_gsi::GenericMethod ("connectToHost", "@brief Method int QFtp::connectToHost(const QString &host, quint16 port)\n", false, &_init_f_connectToHost_3017, &_call_f_connectToHost_3017);
  methods += new qt_gsi::GenericMethod ("currentCommand", "@brief Method QFtp::Command QFtp::currentCommand()\n", true, &_init_f_currentCommand_c0, &_call_f_currentCommand_c0);
  methods += new qt_gsi::GenericMethod ("currentDevice", "@brief Method QIODevice *QFtp::currentDevice()\n", true, &_init_f_currentDevice_c0, &_call_f_currentDevice_c0);
  methods += new qt_gsi::GenericMethod ("currentId", "@brief Method int QFtp::currentId()\n", true, &_init_f_currentId_c0, &_call_f_currentId_c0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QFtp::Error QFtp::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QFtp::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("get", "@brief Method int QFtp::get(const QString &file, QIODevice *dev, QFtp::TransferType type)\n", false, &_init_f_get_5442, &_call_f_get_5442);
  methods += new qt_gsi::GenericMethod ("hasPendingCommands", "@brief Method bool QFtp::hasPendingCommands()\n", true, &_init_f_hasPendingCommands_c0, &_call_f_hasPendingCommands_c0);
  methods += new qt_gsi::GenericMethod ("list", "@brief Method int QFtp::list(const QString &dir)\n", false, &_init_f_list_2025, &_call_f_list_2025);
  methods += new qt_gsi::GenericMethod ("login", "@brief Method int QFtp::login(const QString &user, const QString &password)\n", false, &_init_f_login_3942, &_call_f_login_3942);
  methods += new qt_gsi::GenericMethod ("mkdir", "@brief Method int QFtp::mkdir(const QString &dir)\n", false, &_init_f_mkdir_2025, &_call_f_mkdir_2025);
  methods += new qt_gsi::GenericMethod ("put", "@brief Method int QFtp::put(const QByteArray &data, const QString &file, QFtp::TransferType type)\n", false, &_init_f_put_6304, &_call_f_put_6304);
  methods += new qt_gsi::GenericMethod ("put", "@brief Method int QFtp::put(QIODevice *dev, const QString &file, QFtp::TransferType type)\n", false, &_init_f_put_5442, &_call_f_put_5442);
  methods += new qt_gsi::GenericMethod ("rawCommand", "@brief Method int QFtp::rawCommand(const QString &command)\n", false, &_init_f_rawCommand_2025, &_call_f_rawCommand_2025);
  methods += new qt_gsi::GenericMethod ("readAll", "@brief Method QByteArray QFtp::readAll()\n", false, &_init_f_readAll_0, &_call_f_readAll_0);
  methods += new qt_gsi::GenericMethod ("remove", "@brief Method int QFtp::remove(const QString &file)\n", false, &_init_f_remove_2025, &_call_f_remove_2025);
  methods += new qt_gsi::GenericMethod ("rename", "@brief Method int QFtp::rename(const QString &oldname, const QString &newname)\n", false, &_init_f_rename_3942, &_call_f_rename_3942);
  methods += new qt_gsi::GenericMethod ("rmdir", "@brief Method int QFtp::rmdir(const QString &dir)\n", false, &_init_f_rmdir_2025, &_call_f_rmdir_2025);
  methods += new qt_gsi::GenericMethod ("setProxy", "@brief Method int QFtp::setProxy(const QString &host, quint16 port)\n", false, &_init_f_setProxy_3017, &_call_f_setProxy_3017);
  methods += new qt_gsi::GenericMethod ("setTransferMode", "@brief Method int QFtp::setTransferMode(QFtp::TransferMode mode)\n", false, &_init_f_setTransferMode_2157, &_call_f_setTransferMode_2157);
  methods += new qt_gsi::GenericMethod ("state", "@brief Method QFtp::State QFtp::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += gsi::qt_signal<int, bool > ("commandFinished(int, bool)", "commandFinished", gsi::arg("arg1"), gsi::arg("arg2"), "@brief Signal declaration for QFtp::commandFinished(int, bool)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("commandStarted(int)", "commandStarted", gsi::arg("arg1"), "@brief Signal declaration for QFtp::commandStarted(int)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64, qint64 > ("dataTransferProgress(qint64, qint64)", "dataTransferProgress", gsi::arg("arg1"), gsi::arg("arg2"), "@brief Signal declaration for QFtp::dataTransferProgress(qint64, qint64)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QFtp::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("done(bool)", "done", gsi::arg("arg1"), "@brief Signal declaration for QFtp::done(bool)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QUrlInfo & > ("listInfo(const QUrlInfo &)", "listInfo", gsi::arg("arg1"), "@brief Signal declaration for QFtp::listInfo(const QUrlInfo &)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, const QString & > ("rawCommandReply(int, const QString &)", "rawCommandReply", gsi::arg("arg1"), gsi::arg("arg2"), "@brief Signal declaration for QFtp::rawCommandReply(int, const QString &)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("readyRead()", "readyRead", "@brief Signal declaration for QFtp::readyRead()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("stateChanged(int)", "stateChanged", gsi::arg("arg1"), "@brief Signal declaration for QFtp::stateChanged(int)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFtp::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFtp::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QFtp::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QFtp::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QFtp> decl_QFtp (qtdecl_QObject (), "QtNetwork", "QFtp_Native",
  methods_QFtp (),
  "@hide\n@alias QFtp");

GSI_QTNETWORK_PUBLIC gsi::Class<QFtp> &qtdecl_QFtp () { return decl_QFtp; }

}


class QFtp_Adaptor : public QFtp, public qt_gsi::QtObjectBase
{
public:

  virtual ~QFtp_Adaptor();

  //  [adaptor ctor] QFtp::QFtp(QObject *parent)
  QFtp_Adaptor() : QFtp()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFtp::QFtp(QObject *parent)
  QFtp_Adaptor(QObject *parent) : QFtp(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] int QFtp::receivers(const char *signal)
  int fp_QFtp_receivers_c1731 (const char *signal) const {
    return QFtp::receivers(signal);
  }

  //  [expose] QObject *QFtp::sender()
  QObject * fp_QFtp_sender_c0 () const {
    return QFtp::sender();
  }

  //  [adaptor impl] bool QFtp::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QFtp::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QFtp_Adaptor, bool, QEvent *>(&QFtp_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QFtp::event(arg1);
    }
  }

  //  [adaptor impl] bool QFtp::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QFtp::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QFtp_Adaptor, bool, QObject *, QEvent *>(&QFtp_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QFtp::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QFtp::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QFtp::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QFtp_Adaptor, QChildEvent *>(&QFtp_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QFtp::childEvent(arg1);
    }
  }

  //  [emitter impl] void QFtp::commandFinished(int, bool)
  void emitter_QFtp_commandFinished_1523(int arg1, bool arg2)
  {
    emit QFtp::commandFinished(arg1, arg2);
  }

  //  [emitter impl] void QFtp::commandStarted(int)
  void emitter_QFtp_commandStarted_767(int arg1)
  {
    emit QFtp::commandStarted(arg1);
  }

  //  [adaptor impl] void QFtp::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QFtp::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QFtp_Adaptor, QEvent *>(&QFtp_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QFtp::customEvent(arg1);
    }
  }

  //  [emitter impl] void QFtp::dataTransferProgress(qint64, qint64)
  void emitter_QFtp_dataTransferProgress_1864(qint64 arg1, qint64 arg2)
  {
    emit QFtp::dataTransferProgress(arg1, arg2);
  }

  //  [emitter impl] void QFtp::destroyed(QObject *)
  void emitter_QFtp_destroyed_1302(QObject *arg1)
  {
    emit QFtp::destroyed(arg1);
  }

  //  [adaptor impl] void QFtp::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QFtp::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QFtp_Adaptor, const char *>(&QFtp_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QFtp::disconnectNotify(signal);
    }
  }

  //  [emitter impl] void QFtp::done(bool)
  void emitter_QFtp_done_864(bool arg1)
  {
    emit QFtp::done(arg1);
  }

  //  [emitter impl] void QFtp::listInfo(const QUrlInfo &)
  void emitter_QFtp_listInfo_2097(const QUrlInfo &arg1)
  {
    emit QFtp::listInfo(arg1);
  }

  //  [emitter impl] void QFtp::rawCommandReply(int, const QString &)
  void emitter_QFtp_rawCommandReply_2684(int arg1, const QString &arg2)
  {
    emit QFtp::rawCommandReply(arg1, arg2);
  }

  //  [emitter impl] void QFtp::readyRead()
  void emitter_QFtp_readyRead_0()
  {
    emit QFtp::readyRead();
  }

  //  [emitter impl] void QFtp::stateChanged(int)
  void emitter_QFtp_stateChanged_767(int arg1)
  {
    emit QFtp::stateChanged(arg1);
  }

  //  [adaptor impl] void QFtp::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QFtp::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QFtp_Adaptor, QTimerEvent *>(&QFtp_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QFtp::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QFtp_Adaptor::~QFtp_Adaptor() { }

//  Constructor QFtp::QFtp(QObject *parent) (adaptor class)

static void _init_ctor_QFtp_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QFtp_Adaptor> ();
}

static void _call_ctor_QFtp_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QFtp_Adaptor *> (new QFtp_Adaptor (arg1));
}


// void QFtp::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFtp_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QFtp_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QFtp::commandFinished(int, bool)

static void _init_emitter_commandFinished_1523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_commandFinished_1523 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  bool arg2 = gsi::arg_reader<bool >() (args, heap);
  ((QFtp_Adaptor *)cls)->emitter_QFtp_commandFinished_1523 (arg1, arg2);
}


// emitter void QFtp::commandStarted(int)

static void _init_emitter_commandStarted_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_commandStarted_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QFtp_Adaptor *)cls)->emitter_QFtp_commandStarted_767 (arg1);
}


// void QFtp::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFtp_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFtp_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QFtp::dataTransferProgress(qint64, qint64)

static void _init_emitter_dataTransferProgress_1864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<qint64 > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<qint64 > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_dataTransferProgress_1864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  qint64 arg2 = gsi::arg_reader<qint64 >() (args, heap);
  ((QFtp_Adaptor *)cls)->emitter_QFtp_dataTransferProgress_1864 (arg1, arg2);
}


// emitter void QFtp::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QFtp_Adaptor *)cls)->emitter_QFtp_destroyed_1302 (arg1);
}


// void QFtp::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFtp_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QFtp_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// emitter void QFtp::done(bool)

static void _init_emitter_done_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_done_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QFtp_Adaptor *)cls)->emitter_QFtp_done_864 (arg1);
}


// bool QFtp::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QFtp_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFtp_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QFtp::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QFtp_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QFtp_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QFtp::listInfo(const QUrlInfo &)

static void _init_emitter_listInfo_2097 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QUrlInfo & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_listInfo_2097 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrlInfo &arg1 = gsi::arg_reader<const QUrlInfo & >() (args, heap);
  ((QFtp_Adaptor *)cls)->emitter_QFtp_listInfo_2097 (arg1);
}


// emitter void QFtp::rawCommandReply(int, const QString &)

static void _init_emitter_rawCommandReply_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_rawCommandReply_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ((QFtp_Adaptor *)cls)->emitter_QFtp_rawCommandReply_2684 (arg1, arg2);
}


// emitter void QFtp::readyRead()

static void _init_emitter_readyRead_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_readyRead_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QFtp_Adaptor *)cls)->emitter_QFtp_readyRead_0 ();
}


// exposed int QFtp::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QFtp_Adaptor *)cls)->fp_QFtp_receivers_c1731 (arg1));
}


// exposed QObject *QFtp::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QFtp_Adaptor *)cls)->fp_QFtp_sender_c0 ());
}


// emitter void QFtp::stateChanged(int)

static void _init_emitter_stateChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_stateChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QFtp_Adaptor *)cls)->emitter_QFtp_stateChanged_767 (arg1);
}


// void QFtp::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFtp_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QFtp_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QFtp> &qtdecl_QFtp ();

static gsi::Methods methods_QFtp_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFtp::QFtp(QObject *parent)\nThis method creates an object of class QFtp.", &_init_ctor_QFtp_Adaptor_1302, &_call_ctor_QFtp_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QFtp::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_commandFinished", "@brief Emitter for signal void QFtp::commandFinished(int, bool)\nCall this method to emit this signal.", false, &_init_emitter_commandFinished_1523, &_call_emitter_commandFinished_1523);
  methods += new qt_gsi::GenericMethod ("emit_commandStarted", "@brief Emitter for signal void QFtp::commandStarted(int)\nCall this method to emit this signal.", false, &_init_emitter_commandStarted_767, &_call_emitter_commandStarted_767);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QFtp::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_dataTransferProgress", "@brief Emitter for signal void QFtp::dataTransferProgress(qint64, qint64)\nCall this method to emit this signal.", false, &_init_emitter_dataTransferProgress_1864, &_call_emitter_dataTransferProgress_1864);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QFtp::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QFtp::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("emit_done", "@brief Emitter for signal void QFtp::done(bool)\nCall this method to emit this signal.", false, &_init_emitter_done_864, &_call_emitter_done_864);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QFtp::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QFtp::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_listInfo", "@brief Emitter for signal void QFtp::listInfo(const QUrlInfo &)\nCall this method to emit this signal.", false, &_init_emitter_listInfo_2097, &_call_emitter_listInfo_2097);
  methods += new qt_gsi::GenericMethod ("emit_rawCommandReply", "@brief Emitter for signal void QFtp::rawCommandReply(int, const QString &)\nCall this method to emit this signal.", false, &_init_emitter_rawCommandReply_2684, &_call_emitter_rawCommandReply_2684);
  methods += new qt_gsi::GenericMethod ("emit_readyRead", "@brief Emitter for signal void QFtp::readyRead()\nCall this method to emit this signal.", false, &_init_emitter_readyRead_0, &_call_emitter_readyRead_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QFtp::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QFtp::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("emit_stateChanged", "@brief Emitter for signal void QFtp::stateChanged(int)\nCall this method to emit this signal.", false, &_init_emitter_stateChanged_767, &_call_emitter_stateChanged_767);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QFtp::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QFtp_Adaptor> decl_QFtp_Adaptor (qtdecl_QFtp (), "QtNetwork", "QFtp",
  methods_QFtp_Adaptor (),
  "@qt\n@brief Binding of QFtp");

}


//  Implementation of the enum wrapper class for QFtp::Command
namespace qt_gsi
{

static gsi::Enum<QFtp::Command> decl_QFtp_Command_Enum ("QtNetwork", "QFtp_Command",
    gsi::enum_const ("None", QFtp::None, "@brief Enum constant QFtp::None") +
    gsi::enum_const ("SetTransferMode", QFtp::SetTransferMode, "@brief Enum constant QFtp::SetTransferMode") +
    gsi::enum_const ("SetProxy", QFtp::SetProxy, "@brief Enum constant QFtp::SetProxy") +
    gsi::enum_const ("ConnectToHost", QFtp::ConnectToHost, "@brief Enum constant QFtp::ConnectToHost") +
    gsi::enum_const ("Login", QFtp::Login, "@brief Enum constant QFtp::Login") +
    gsi::enum_const ("Close", QFtp::Close, "@brief Enum constant QFtp::Close") +
    gsi::enum_const ("List", QFtp::List, "@brief Enum constant QFtp::List") +
    gsi::enum_const ("Cd", QFtp::Cd, "@brief Enum constant QFtp::Cd") +
    gsi::enum_const ("Get", QFtp::Get, "@brief Enum constant QFtp::Get") +
    gsi::enum_const ("Put", QFtp::Put, "@brief Enum constant QFtp::Put") +
    gsi::enum_const ("Remove", QFtp::Remove, "@brief Enum constant QFtp::Remove") +
    gsi::enum_const ("Mkdir", QFtp::Mkdir, "@brief Enum constant QFtp::Mkdir") +
    gsi::enum_const ("Rmdir", QFtp::Rmdir, "@brief Enum constant QFtp::Rmdir") +
    gsi::enum_const ("Rename", QFtp::Rename, "@brief Enum constant QFtp::Rename") +
    gsi::enum_const ("RawCommand", QFtp::RawCommand, "@brief Enum constant QFtp::RawCommand"),
  "@qt\n@brief This class represents the QFtp::Command enum");

static gsi::QFlagsClass<QFtp::Command > decl_QFtp_Command_Enums ("QtNetwork", "QFtp_QFlags_Command",
  "@qt\n@brief This class represents the QFlags<QFtp::Command> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFtp> inject_QFtp_Command_Enum_in_parent (decl_QFtp_Command_Enum.defs ());
static gsi::ClassExt<QFtp> decl_QFtp_Command_Enum_as_child (decl_QFtp_Command_Enum, "Command");
static gsi::ClassExt<QFtp> decl_QFtp_Command_Enums_as_child (decl_QFtp_Command_Enums, "QFlags_Command");

}


//  Implementation of the enum wrapper class for QFtp::Error
namespace qt_gsi
{

static gsi::Enum<QFtp::Error> decl_QFtp_Error_Enum ("QtNetwork", "QFtp_Error",
    gsi::enum_const ("NoError", QFtp::NoError, "@brief Enum constant QFtp::NoError") +
    gsi::enum_const ("UnknownError", QFtp::UnknownError, "@brief Enum constant QFtp::UnknownError") +
    gsi::enum_const ("HostNotFound", QFtp::HostNotFound, "@brief Enum constant QFtp::HostNotFound") +
    gsi::enum_const ("ConnectionRefused", QFtp::ConnectionRefused, "@brief Enum constant QFtp::ConnectionRefused") +
    gsi::enum_const ("NotConnected", QFtp::NotConnected, "@brief Enum constant QFtp::NotConnected"),
  "@qt\n@brief This class represents the QFtp::Error enum");

static gsi::QFlagsClass<QFtp::Error > decl_QFtp_Error_Enums ("QtNetwork", "QFtp_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QFtp::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFtp> inject_QFtp_Error_Enum_in_parent (decl_QFtp_Error_Enum.defs ());
static gsi::ClassExt<QFtp> decl_QFtp_Error_Enum_as_child (decl_QFtp_Error_Enum, "Error");
static gsi::ClassExt<QFtp> decl_QFtp_Error_Enums_as_child (decl_QFtp_Error_Enums, "QFlags_Error");

}


//  Implementation of the enum wrapper class for QFtp::State
namespace qt_gsi
{

static gsi::Enum<QFtp::State> decl_QFtp_State_Enum ("QtNetwork", "QFtp_State",
    gsi::enum_const ("Unconnected", QFtp::Unconnected, "@brief Enum constant QFtp::Unconnected") +
    gsi::enum_const ("HostLookup", QFtp::HostLookup, "@brief Enum constant QFtp::HostLookup") +
    gsi::enum_const ("Connecting", QFtp::Connecting, "@brief Enum constant QFtp::Connecting") +
    gsi::enum_const ("Connected", QFtp::Connected, "@brief Enum constant QFtp::Connected") +
    gsi::enum_const ("LoggedIn", QFtp::LoggedIn, "@brief Enum constant QFtp::LoggedIn") +
    gsi::enum_const ("Closing", QFtp::Closing, "@brief Enum constant QFtp::Closing"),
  "@qt\n@brief This class represents the QFtp::State enum");

static gsi::QFlagsClass<QFtp::State > decl_QFtp_State_Enums ("QtNetwork", "QFtp_QFlags_State",
  "@qt\n@brief This class represents the QFlags<QFtp::State> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFtp> inject_QFtp_State_Enum_in_parent (decl_QFtp_State_Enum.defs ());
static gsi::ClassExt<QFtp> decl_QFtp_State_Enum_as_child (decl_QFtp_State_Enum, "State");
static gsi::ClassExt<QFtp> decl_QFtp_State_Enums_as_child (decl_QFtp_State_Enums, "QFlags_State");

}


//  Implementation of the enum wrapper class for QFtp::TransferMode
namespace qt_gsi
{

static gsi::Enum<QFtp::TransferMode> decl_QFtp_TransferMode_Enum ("QtNetwork", "QFtp_TransferMode",
    gsi::enum_const ("Active", QFtp::Active, "@brief Enum constant QFtp::Active") +
    gsi::enum_const ("Passive", QFtp::Passive, "@brief Enum constant QFtp::Passive"),
  "@qt\n@brief This class represents the QFtp::TransferMode enum");

static gsi::QFlagsClass<QFtp::TransferMode > decl_QFtp_TransferMode_Enums ("QtNetwork", "QFtp_QFlags_TransferMode",
  "@qt\n@brief This class represents the QFlags<QFtp::TransferMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFtp> inject_QFtp_TransferMode_Enum_in_parent (decl_QFtp_TransferMode_Enum.defs ());
static gsi::ClassExt<QFtp> decl_QFtp_TransferMode_Enum_as_child (decl_QFtp_TransferMode_Enum, "TransferMode");
static gsi::ClassExt<QFtp> decl_QFtp_TransferMode_Enums_as_child (decl_QFtp_TransferMode_Enums, "QFlags_TransferMode");

}


//  Implementation of the enum wrapper class for QFtp::TransferType
namespace qt_gsi
{

static gsi::Enum<QFtp::TransferType> decl_QFtp_TransferType_Enum ("QtNetwork", "QFtp_TransferType",
    gsi::enum_const ("Binary", QFtp::Binary, "@brief Enum constant QFtp::Binary") +
    gsi::enum_const ("Ascii", QFtp::Ascii, "@brief Enum constant QFtp::Ascii"),
  "@qt\n@brief This class represents the QFtp::TransferType enum");

static gsi::QFlagsClass<QFtp::TransferType > decl_QFtp_TransferType_Enums ("QtNetwork", "QFtp_QFlags_TransferType",
  "@qt\n@brief This class represents the QFlags<QFtp::TransferType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFtp> inject_QFtp_TransferType_Enum_in_parent (decl_QFtp_TransferType_Enum.defs ());
static gsi::ClassExt<QFtp> decl_QFtp_TransferType_Enum_as_child (decl_QFtp_TransferType_Enum, "TransferType");
static gsi::ClassExt<QFtp> decl_QFtp_TransferType_Enums_as_child (decl_QFtp_TransferType_Enums, "QFlags_TransferType");

}

