
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGuiApplication.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QGuiApplication>
#include <QScreen>
#include <QSessionManager>
#include <QClipboard>
#include <QWindow>
#include <QStyleHints>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include "gsiDeclQtGuiTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGuiApplication

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGuiApplication::staticMetaObject);
}


// double QGuiApplication::devicePixelRatio()


static void _init_f_devicePixelRatio_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_devicePixelRatio_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGuiApplication *)cls)->devicePixelRatio ());
}


// bool QGuiApplication::isSavingSession()


static void _init_f_isSavingSession_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSavingSession_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGuiApplication *)cls)->isSavingSession ());
}


// bool QGuiApplication::isSessionRestored()


static void _init_f_isSessionRestored_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSessionRestored_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGuiApplication *)cls)->isSessionRestored ());
}


// bool QGuiApplication::notify(QObject *, QEvent *)


static void _init_f_notify_2411 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_notify_2411 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  QEvent *arg2 = gsi::arg_reader<QEvent * >() (args, heap);
  ret.write<bool > ((bool)((QGuiApplication *)cls)->notify (arg1, arg2));
}


// QString QGuiApplication::sessionId()


static void _init_f_sessionId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_sessionId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QGuiApplication *)cls)->sessionId ());
}


// QString QGuiApplication::sessionKey()


static void _init_f_sessionKey_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_sessionKey_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QGuiApplication *)cls)->sessionKey ());
}


// static QList<QWindow *> QGuiApplication::allWindows()


static void _init_f_allWindows_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<QWindow *> > ();
}

static void _call_f_allWindows_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QWindow *> > ((QList<QWindow *>)QGuiApplication::allWindows ());
}


// static QString QGuiApplication::applicationDisplayName()


static void _init_f_applicationDisplayName_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_applicationDisplayName_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)QGuiApplication::applicationDisplayName ());
}


// static Qt::ApplicationState QGuiApplication::applicationState()


static void _init_f_applicationState_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::ApplicationState>::target_type > ();
}

static void _call_f_applicationState_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::ApplicationState>::target_type > ((qt_gsi::Converter<Qt::ApplicationState>::target_type)qt_gsi::CppToQtAdaptor<Qt::ApplicationState>(QGuiApplication::applicationState ()));
}


// static void QGuiApplication::changeOverrideCursor(const QCursor &)


static void _init_f_changeOverrideCursor_2032 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_changeOverrideCursor_2032 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCursor &arg1 = gsi::arg_reader<const QCursor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QGuiApplication::changeOverrideCursor (arg1);
}


// static QClipboard *QGuiApplication::clipboard()


static void _init_f_clipboard_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QClipboard * > ();
}

static void _call_f_clipboard_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QClipboard * > ((QClipboard *)QGuiApplication::clipboard ());
}


// static bool QGuiApplication::desktopSettingsAware()


static void _init_f_desktopSettingsAware_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_desktopSettingsAware_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)QGuiApplication::desktopSettingsAware ());
}


// static int QGuiApplication::exec()


static void _init_f_exec_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_exec_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)QGuiApplication::exec ());
}


// static QObject *QGuiApplication::focusObject()


static void _init_f_focusObject_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_f_focusObject_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)QGuiApplication::focusObject ());
}


// static QWindow *QGuiApplication::focusWindow()


static void _init_f_focusWindow_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWindow * > ();
}

static void _call_f_focusWindow_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWindow * > ((QWindow *)QGuiApplication::focusWindow ());
}


// static QFont QGuiApplication::font()


static void _init_f_font_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFont > ((QFont)QGuiApplication::font ());
}


// static QInputMethod *QGuiApplication::inputMethod()


static void _init_f_inputMethod_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QInputMethod * > ();
}

static void _call_f_inputMethod_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QInputMethod * > ((QInputMethod *)QGuiApplication::inputMethod ());
}


// static bool QGuiApplication::isLeftToRight()


static void _init_f_isLeftToRight_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isLeftToRight_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)QGuiApplication::isLeftToRight ());
}


// static bool QGuiApplication::isRightToLeft()


static void _init_f_isRightToLeft_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRightToLeft_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)QGuiApplication::isRightToLeft ());
}


// static QFlags<Qt::KeyboardModifier> QGuiApplication::keyboardModifiers()


static void _init_f_keyboardModifiers_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QFlags<Qt::KeyboardModifier> > ();
}

static void _call_f_keyboardModifiers_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::KeyboardModifier> > ((QFlags<Qt::KeyboardModifier>)QGuiApplication::keyboardModifiers ());
}


// static Qt::LayoutDirection QGuiApplication::layoutDirection()


static void _init_f_layoutDirection_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ();
}

static void _call_f_layoutDirection_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ((qt_gsi::Converter<Qt::LayoutDirection>::target_type)qt_gsi::CppToQtAdaptor<Qt::LayoutDirection>(QGuiApplication::layoutDirection ()));
}


// static QWindow *QGuiApplication::modalWindow()


static void _init_f_modalWindow_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWindow * > ();
}

static void _call_f_modalWindow_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWindow * > ((QWindow *)QGuiApplication::modalWindow ());
}


// static QFlags<Qt::MouseButton> QGuiApplication::mouseButtons()


static void _init_f_mouseButtons_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QFlags<Qt::MouseButton> > ();
}

static void _call_f_mouseButtons_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::MouseButton> > ((QFlags<Qt::MouseButton>)QGuiApplication::mouseButtons ());
}


// static QCursor *QGuiApplication::overrideCursor()


static void _init_f_overrideCursor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QCursor * > ();
}

static void _call_f_overrideCursor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCursor * > ((QCursor *)QGuiApplication::overrideCursor ());
}


// static QPalette QGuiApplication::palette()


static void _init_f_palette_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_f_palette_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPalette > ((QPalette)QGuiApplication::palette ());
}


// static QString QGuiApplication::platformName()


static void _init_f_platformName_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_platformName_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)QGuiApplication::platformName ());
}


// static QScreen *QGuiApplication::primaryScreen()


static void _init_f_primaryScreen_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QScreen * > ();
}

static void _call_f_primaryScreen_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QScreen * > ((QScreen *)QGuiApplication::primaryScreen ());
}


// static QFlags<Qt::KeyboardModifier> QGuiApplication::queryKeyboardModifiers()


static void _init_f_queryKeyboardModifiers_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QFlags<Qt::KeyboardModifier> > ();
}

static void _call_f_queryKeyboardModifiers_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::KeyboardModifier> > ((QFlags<Qt::KeyboardModifier>)QGuiApplication::queryKeyboardModifiers ());
}


// static bool QGuiApplication::quitOnLastWindowClosed()


static void _init_f_quitOnLastWindowClosed_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_quitOnLastWindowClosed_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)QGuiApplication::quitOnLastWindowClosed ());
}


// static void QGuiApplication::restoreOverrideCursor()


static void _init_f_restoreOverrideCursor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_restoreOverrideCursor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QGuiApplication::restoreOverrideCursor ();
}


// static QList<QScreen *> QGuiApplication::screens()


static void _init_f_screens_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<QScreen *> > ();
}

static void _call_f_screens_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QScreen *> > ((QList<QScreen *>)QGuiApplication::screens ());
}


// static void QGuiApplication::setApplicationDisplayName(const QString &name)


static void _init_f_setApplicationDisplayName_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setApplicationDisplayName_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QGuiApplication::setApplicationDisplayName (arg1);
}


// static void QGuiApplication::setDesktopSettingsAware(bool on)


static void _init_f_setDesktopSettingsAware_864 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("on");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDesktopSettingsAware_864 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QGuiApplication::setDesktopSettingsAware (arg1);
}


// static void QGuiApplication::setFont(const QFont &)


static void _init_f_setFont_1801 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFont_1801 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QGuiApplication::setFont (arg1);
}


// static void QGuiApplication::setLayoutDirection(Qt::LayoutDirection direction)


static void _init_f_setLayoutDirection_2316 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLayoutDirection_2316 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QGuiApplication::setLayoutDirection (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref());
}


// static void QGuiApplication::setOverrideCursor(const QCursor &)


static void _init_f_setOverrideCursor_2032 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOverrideCursor_2032 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCursor &arg1 = gsi::arg_reader<const QCursor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QGuiApplication::setOverrideCursor (arg1);
}


// static void QGuiApplication::setPalette(const QPalette &pal)


static void _init_f_setPalette_2113 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pal");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPalette_2113 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = gsi::arg_reader<const QPalette & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QGuiApplication::setPalette (arg1);
}


// static void QGuiApplication::setQuitOnLastWindowClosed(bool quit)


static void _init_f_setQuitOnLastWindowClosed_864 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("quit");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setQuitOnLastWindowClosed_864 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QGuiApplication::setQuitOnLastWindowClosed (arg1);
}


// static void QGuiApplication::setWindowIcon(const QIcon &icon)


static void _init_f_setWindowIcon_1787 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowIcon_1787 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QGuiApplication::setWindowIcon (arg1);
}


// static QStyleHints *QGuiApplication::styleHints()


static void _init_f_styleHints_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QStyleHints * > ();
}

static void _call_f_styleHints_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStyleHints * > ((QStyleHints *)QGuiApplication::styleHints ());
}


// static void QGuiApplication::sync()


static void _init_f_sync_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_sync_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QGuiApplication::sync ();
}


// static QWindow *QGuiApplication::topLevelAt(const QPoint &pos)


static void _init_f_topLevelAt_1916 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QWindow * > ();
}

static void _call_f_topLevelAt_1916 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QWindow * > ((QWindow *)QGuiApplication::topLevelAt (arg1));
}


// static QList<QWindow *> QGuiApplication::topLevelWindows()


static void _init_f_topLevelWindows_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<QWindow *> > ();
}

static void _call_f_topLevelWindows_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QWindow *> > ((QList<QWindow *>)QGuiApplication::topLevelWindows ());
}


// static QString QGuiApplication::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGuiApplication::tr (arg1, arg2, arg3));
}


// static QString QGuiApplication::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGuiApplication::trUtf8 (arg1, arg2, arg3));
}


// static QIcon QGuiApplication::windowIcon()


static void _init_f_windowIcon_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QIcon > ();
}

static void _call_f_windowIcon_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIcon > ((QIcon)QGuiApplication::windowIcon ());
}


namespace gsi
{

static gsi::Methods methods_QGuiApplication () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("devicePixelRatio", "@brief Method double QGuiApplication::devicePixelRatio()\n", true, &_init_f_devicePixelRatio_c0, &_call_f_devicePixelRatio_c0);
  methods += new qt_gsi::GenericMethod ("isSavingSession?", "@brief Method bool QGuiApplication::isSavingSession()\n", true, &_init_f_isSavingSession_c0, &_call_f_isSavingSession_c0);
  methods += new qt_gsi::GenericMethod ("isSessionRestored?", "@brief Method bool QGuiApplication::isSessionRestored()\n", true, &_init_f_isSessionRestored_c0, &_call_f_isSessionRestored_c0);
  methods += new qt_gsi::GenericMethod ("notify", "@brief Method bool QGuiApplication::notify(QObject *, QEvent *)\nThis is a reimplementation of QCoreApplication::notify", false, &_init_f_notify_2411, &_call_f_notify_2411);
  methods += new qt_gsi::GenericMethod ("sessionId", "@brief Method QString QGuiApplication::sessionId()\n", true, &_init_f_sessionId_c0, &_call_f_sessionId_c0);
  methods += new qt_gsi::GenericMethod ("sessionKey", "@brief Method QString QGuiApplication::sessionKey()\n", true, &_init_f_sessionKey_c0, &_call_f_sessionKey_c0);
  methods += gsi::qt_signal ("applicationNameChanged()", "applicationNameChanged", "@brief Signal declaration for QGuiApplication::applicationNameChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::ApplicationState>::target_type & > ("applicationStateChanged(Qt::ApplicationState)", "applicationStateChanged", gsi::arg("state"), "@brief Signal declaration for QGuiApplication::applicationStateChanged(Qt::ApplicationState state)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("applicationVersionChanged()", "applicationVersionChanged", "@brief Signal declaration for QGuiApplication::applicationVersionChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QSessionManager & > ("commitDataRequest(QSessionManager &)", "commitDataRequest", gsi::arg("sessionManager"), "@brief Signal declaration for QGuiApplication::commitDataRequest(QSessionManager &sessionManager)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QGuiApplication::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("focusObjectChanged(QObject *)", "focusObjectChanged", gsi::arg("focusObject"), "@brief Signal declaration for QGuiApplication::focusObjectChanged(QObject *focusObject)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QWindow * > ("focusWindowChanged(QWindow *)", "focusWindowChanged", gsi::arg("focusWindow"), "@brief Signal declaration for QGuiApplication::focusWindowChanged(QWindow *focusWindow)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("fontDatabaseChanged()", "fontDatabaseChanged", "@brief Signal declaration for QGuiApplication::fontDatabaseChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("lastWindowClosed()", "lastWindowClosed", "@brief Signal declaration for QGuiApplication::lastWindowClosed()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > ("layoutDirectionChanged(Qt::LayoutDirection)", "layoutDirectionChanged", gsi::arg("direction"), "@brief Signal declaration for QGuiApplication::layoutDirectionChanged(Qt::LayoutDirection direction)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("organizationDomainChanged()", "organizationDomainChanged", "@brief Signal declaration for QGuiApplication::organizationDomainChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("organizationNameChanged()", "organizationNameChanged", "@brief Signal declaration for QGuiApplication::organizationNameChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPalette & > ("paletteChanged(const QPalette &)", "paletteChanged", gsi::arg("pal"), "@brief Signal declaration for QGuiApplication::paletteChanged(const QPalette &pal)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QSessionManager & > ("saveStateRequest(QSessionManager &)", "saveStateRequest", gsi::arg("sessionManager"), "@brief Signal declaration for QGuiApplication::saveStateRequest(QSessionManager &sessionManager)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QScreen * > ("screenAdded(QScreen *)", "screenAdded", gsi::arg("screen"), "@brief Signal declaration for QGuiApplication::screenAdded(QScreen *screen)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QScreen * > ("screenRemoved(QScreen *)", "screenRemoved", gsi::arg("screen"), "@brief Signal declaration for QGuiApplication::screenRemoved(QScreen *screen)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("allWindows", "@brief Static method QList<QWindow *> QGuiApplication::allWindows()\nThis method is static and can be called without an instance.", &_init_f_allWindows_0, &_call_f_allWindows_0);
  methods += new qt_gsi::GenericStaticMethod (":applicationDisplayName", "@brief Static method QString QGuiApplication::applicationDisplayName()\nThis method is static and can be called without an instance.", &_init_f_applicationDisplayName_0, &_call_f_applicationDisplayName_0);
  methods += new qt_gsi::GenericStaticMethod ("applicationState", "@brief Static method Qt::ApplicationState QGuiApplication::applicationState()\nThis method is static and can be called without an instance.", &_init_f_applicationState_0, &_call_f_applicationState_0);
  methods += new qt_gsi::GenericStaticMethod ("changeOverrideCursor", "@brief Static method void QGuiApplication::changeOverrideCursor(const QCursor &)\nThis method is static and can be called without an instance.", &_init_f_changeOverrideCursor_2032, &_call_f_changeOverrideCursor_2032);
  methods += new qt_gsi::GenericStaticMethod ("clipboard", "@brief Static method QClipboard *QGuiApplication::clipboard()\nThis method is static and can be called without an instance.", &_init_f_clipboard_0, &_call_f_clipboard_0);
  methods += new qt_gsi::GenericStaticMethod (":desktopSettingsAware", "@brief Static method bool QGuiApplication::desktopSettingsAware()\nThis method is static and can be called without an instance.", &_init_f_desktopSettingsAware_0, &_call_f_desktopSettingsAware_0);
  methods += new qt_gsi::GenericStaticMethod ("exec", "@brief Static method int QGuiApplication::exec()\nThis method is static and can be called without an instance.", &_init_f_exec_0, &_call_f_exec_0);
  methods += new qt_gsi::GenericStaticMethod ("focusObject", "@brief Static method QObject *QGuiApplication::focusObject()\nThis method is static and can be called without an instance.", &_init_f_focusObject_0, &_call_f_focusObject_0);
  methods += new qt_gsi::GenericStaticMethod ("focusWindow", "@brief Static method QWindow *QGuiApplication::focusWindow()\nThis method is static and can be called without an instance.", &_init_f_focusWindow_0, &_call_f_focusWindow_0);
  methods += new qt_gsi::GenericStaticMethod (":font", "@brief Static method QFont QGuiApplication::font()\nThis method is static and can be called without an instance.", &_init_f_font_0, &_call_f_font_0);
  methods += new qt_gsi::GenericStaticMethod ("inputMethod", "@brief Static method QInputMethod *QGuiApplication::inputMethod()\nThis method is static and can be called without an instance.", &_init_f_inputMethod_0, &_call_f_inputMethod_0);
  methods += new qt_gsi::GenericStaticMethod ("isLeftToRight?", "@brief Static method bool QGuiApplication::isLeftToRight()\nThis method is static and can be called without an instance.", &_init_f_isLeftToRight_0, &_call_f_isLeftToRight_0);
  methods += new qt_gsi::GenericStaticMethod ("isRightToLeft?", "@brief Static method bool QGuiApplication::isRightToLeft()\nThis method is static and can be called without an instance.", &_init_f_isRightToLeft_0, &_call_f_isRightToLeft_0);
  methods += new qt_gsi::GenericStaticMethod ("keyboardModifiers", "@brief Static method QFlags<Qt::KeyboardModifier> QGuiApplication::keyboardModifiers()\nThis method is static and can be called without an instance.", &_init_f_keyboardModifiers_0, &_call_f_keyboardModifiers_0);
  methods += new qt_gsi::GenericStaticMethod (":layoutDirection", "@brief Static method Qt::LayoutDirection QGuiApplication::layoutDirection()\nThis method is static and can be called without an instance.", &_init_f_layoutDirection_0, &_call_f_layoutDirection_0);
  methods += new qt_gsi::GenericStaticMethod ("modalWindow", "@brief Static method QWindow *QGuiApplication::modalWindow()\nThis method is static and can be called without an instance.", &_init_f_modalWindow_0, &_call_f_modalWindow_0);
  methods += new qt_gsi::GenericStaticMethod ("mouseButtons", "@brief Static method QFlags<Qt::MouseButton> QGuiApplication::mouseButtons()\nThis method is static and can be called without an instance.", &_init_f_mouseButtons_0, &_call_f_mouseButtons_0);
  methods += new qt_gsi::GenericStaticMethod ("overrideCursor", "@brief Static method QCursor *QGuiApplication::overrideCursor()\nThis method is static and can be called without an instance.", &_init_f_overrideCursor_0, &_call_f_overrideCursor_0);
  methods += new qt_gsi::GenericStaticMethod (":palette", "@brief Static method QPalette QGuiApplication::palette()\nThis method is static and can be called without an instance.", &_init_f_palette_0, &_call_f_palette_0);
  methods += new qt_gsi::GenericStaticMethod (":platformName", "@brief Static method QString QGuiApplication::platformName()\nThis method is static and can be called without an instance.", &_init_f_platformName_0, &_call_f_platformName_0);
  methods += new qt_gsi::GenericStaticMethod ("primaryScreen", "@brief Static method QScreen *QGuiApplication::primaryScreen()\nThis method is static and can be called without an instance.", &_init_f_primaryScreen_0, &_call_f_primaryScreen_0);
  methods += new qt_gsi::GenericStaticMethod ("queryKeyboardModifiers", "@brief Static method QFlags<Qt::KeyboardModifier> QGuiApplication::queryKeyboardModifiers()\nThis method is static and can be called without an instance.", &_init_f_queryKeyboardModifiers_0, &_call_f_queryKeyboardModifiers_0);
  methods += new qt_gsi::GenericStaticMethod (":quitOnLastWindowClosed", "@brief Static method bool QGuiApplication::quitOnLastWindowClosed()\nThis method is static and can be called without an instance.", &_init_f_quitOnLastWindowClosed_0, &_call_f_quitOnLastWindowClosed_0);
  methods += new qt_gsi::GenericStaticMethod ("restoreOverrideCursor", "@brief Static method void QGuiApplication::restoreOverrideCursor()\nThis method is static and can be called without an instance.", &_init_f_restoreOverrideCursor_0, &_call_f_restoreOverrideCursor_0);
  methods += new qt_gsi::GenericStaticMethod ("screens", "@brief Static method QList<QScreen *> QGuiApplication::screens()\nThis method is static and can be called without an instance.", &_init_f_screens_0, &_call_f_screens_0);
  methods += new qt_gsi::GenericStaticMethod ("setApplicationDisplayName|applicationDisplayName=", "@brief Static method void QGuiApplication::setApplicationDisplayName(const QString &name)\nThis method is static and can be called without an instance.", &_init_f_setApplicationDisplayName_2025, &_call_f_setApplicationDisplayName_2025);
  methods += new qt_gsi::GenericStaticMethod ("setDesktopSettingsAware|desktopSettingsAware=", "@brief Static method void QGuiApplication::setDesktopSettingsAware(bool on)\nThis method is static and can be called without an instance.", &_init_f_setDesktopSettingsAware_864, &_call_f_setDesktopSettingsAware_864);
  methods += new qt_gsi::GenericStaticMethod ("setFont|font=", "@brief Static method void QGuiApplication::setFont(const QFont &)\nThis method is static and can be called without an instance.", &_init_f_setFont_1801, &_call_f_setFont_1801);
  methods += new qt_gsi::GenericStaticMethod ("setLayoutDirection|layoutDirection=", "@brief Static method void QGuiApplication::setLayoutDirection(Qt::LayoutDirection direction)\nThis method is static and can be called without an instance.", &_init_f_setLayoutDirection_2316, &_call_f_setLayoutDirection_2316);
  methods += new qt_gsi::GenericStaticMethod ("setOverrideCursor", "@brief Static method void QGuiApplication::setOverrideCursor(const QCursor &)\nThis method is static and can be called without an instance.", &_init_f_setOverrideCursor_2032, &_call_f_setOverrideCursor_2032);
  methods += new qt_gsi::GenericStaticMethod ("setPalette|palette=", "@brief Static method void QGuiApplication::setPalette(const QPalette &pal)\nThis method is static and can be called without an instance.", &_init_f_setPalette_2113, &_call_f_setPalette_2113);
  methods += new qt_gsi::GenericStaticMethod ("setQuitOnLastWindowClosed|quitOnLastWindowClosed=", "@brief Static method void QGuiApplication::setQuitOnLastWindowClosed(bool quit)\nThis method is static and can be called without an instance.", &_init_f_setQuitOnLastWindowClosed_864, &_call_f_setQuitOnLastWindowClosed_864);
  methods += new qt_gsi::GenericStaticMethod ("setWindowIcon|windowIcon=", "@brief Static method void QGuiApplication::setWindowIcon(const QIcon &icon)\nThis method is static and can be called without an instance.", &_init_f_setWindowIcon_1787, &_call_f_setWindowIcon_1787);
  methods += new qt_gsi::GenericStaticMethod ("styleHints", "@brief Static method QStyleHints *QGuiApplication::styleHints()\nThis method is static and can be called without an instance.", &_init_f_styleHints_0, &_call_f_styleHints_0);
  methods += new qt_gsi::GenericStaticMethod ("sync", "@brief Static method void QGuiApplication::sync()\nThis method is static and can be called without an instance.", &_init_f_sync_0, &_call_f_sync_0);
  methods += new qt_gsi::GenericStaticMethod ("topLevelAt", "@brief Static method QWindow *QGuiApplication::topLevelAt(const QPoint &pos)\nThis method is static and can be called without an instance.", &_init_f_topLevelAt_1916, &_call_f_topLevelAt_1916);
  methods += new qt_gsi::GenericStaticMethod ("topLevelWindows", "@brief Static method QList<QWindow *> QGuiApplication::topLevelWindows()\nThis method is static and can be called without an instance.", &_init_f_topLevelWindows_0, &_call_f_topLevelWindows_0);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGuiApplication::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGuiApplication::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  methods += new qt_gsi::GenericStaticMethod (":windowIcon", "@brief Static method QIcon QGuiApplication::windowIcon()\nThis method is static and can be called without an instance.", &_init_f_windowIcon_0, &_call_f_windowIcon_0);
  return methods;
}

gsi::Class<QCoreApplication> &qtdecl_QCoreApplication ();

qt_gsi::QtNativeClass<QGuiApplication> decl_QGuiApplication (qtdecl_QCoreApplication (), "QtGui", "QGuiApplication_Native",
  methods_QGuiApplication (),
  "@hide\n@alias QGuiApplication");

GSI_QTGUI_PUBLIC gsi::Class<QGuiApplication> &qtdecl_QGuiApplication () { return decl_QGuiApplication; }

}


class QGuiApplication_Adaptor : public QGuiApplication, public qt_gsi::QtObjectBase
{
public:
  static QGuiApplication *ctor_QGuiApplication_Adaptor_args(const std::vector<std::string> &args)
  {
    //  QGuiApplication needs static sources, so we give it some.
    static char **argv = 0;
    static std::vector<std::string> args_copy;
    static int argc = 0;

    if (argv != 0) {
      throw tl::Exception(tl::to_string(QObject::tr("QGuiApplication cannot be instantiated twice")));
    }
    argv = new char *[args.size ()];
    args_copy = args;
    argc = int (args.size ());
    for (std::vector<std::string>::const_iterator a = args_copy.begin (); a != args_copy.end (); ++a) {
      argv[a - args_copy.begin ()] = (char *) a->c_str ();
    }

    return new QGuiApplication_Adaptor (argc, argv);
  }

  QGuiApplication_Adaptor (int &argc, char **argv) : QGuiApplication (argc, argv) { }

  virtual ~QGuiApplication_Adaptor();

  //  [expose] bool QGuiApplication::isSignalConnected(const QMetaMethod &signal)
  bool fp_QGuiApplication_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QGuiApplication::isSignalConnected(signal);
  }

  //  [expose] int QGuiApplication::receivers(const char *signal)
  int fp_QGuiApplication_receivers_c1731 (const char *signal) const {
    return QGuiApplication::receivers(signal);
  }

  //  [expose] QObject *QGuiApplication::sender()
  QObject * fp_QGuiApplication_sender_c0 () const {
    return QGuiApplication::sender();
  }

  //  [expose] int QGuiApplication::senderSignalIndex()
  int fp_QGuiApplication_senderSignalIndex_c0 () const {
    return QGuiApplication::senderSignalIndex();
  }

  //  [emitter impl] void QGuiApplication::applicationNameChanged()
  void emitter_QGuiApplication_applicationNameChanged_0()
  {
    emit QGuiApplication::applicationNameChanged();
  }

  //  [emitter impl] void QGuiApplication::applicationStateChanged(Qt::ApplicationState state)
  void emitter_QGuiApplication_applicationStateChanged_2402(Qt::ApplicationState state)
  {
    emit QGuiApplication::applicationStateChanged(state);
  }

  //  [emitter impl] void QGuiApplication::applicationVersionChanged()
  void emitter_QGuiApplication_applicationVersionChanged_0()
  {
    emit QGuiApplication::applicationVersionChanged();
  }

  //  [emitter impl] void QGuiApplication::commitDataRequest(QSessionManager &sessionManager)
  void emitter_QGuiApplication_commitDataRequest_2138(QSessionManager &sessionManager)
  {
    emit QGuiApplication::commitDataRequest(sessionManager);
  }

  //  [emitter impl] void QGuiApplication::destroyed(QObject *)
  void emitter_QGuiApplication_destroyed_1302(QObject *arg1)
  {
    emit QGuiApplication::destroyed(arg1);
  }

  //  [adaptor impl] bool QGuiApplication::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QGuiApplication::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGuiApplication_Adaptor, bool, QObject *, QEvent *>(&QGuiApplication_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QGuiApplication::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QGuiApplication::focusObjectChanged(QObject *focusObject)
  void emitter_QGuiApplication_focusObjectChanged_1302(QObject *focusObject)
  {
    emit QGuiApplication::focusObjectChanged(focusObject);
  }

  //  [emitter impl] void QGuiApplication::focusWindowChanged(QWindow *focusWindow)
  void emitter_QGuiApplication_focusWindowChanged_1335(QWindow *focusWindow)
  {
    emit QGuiApplication::focusWindowChanged(focusWindow);
  }

  //  [emitter impl] void QGuiApplication::fontDatabaseChanged()
  void emitter_QGuiApplication_fontDatabaseChanged_0()
  {
    emit QGuiApplication::fontDatabaseChanged();
  }

  //  [emitter impl] void QGuiApplication::lastWindowClosed()
  void emitter_QGuiApplication_lastWindowClosed_0()
  {
    emit QGuiApplication::lastWindowClosed();
  }

  //  [emitter impl] void QGuiApplication::layoutDirectionChanged(Qt::LayoutDirection direction)
  void emitter_QGuiApplication_layoutDirectionChanged_2316(Qt::LayoutDirection direction)
  {
    emit QGuiApplication::layoutDirectionChanged(direction);
  }

  //  [adaptor impl] bool QGuiApplication::notify(QObject *, QEvent *)
  bool cbs_notify_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QGuiApplication::notify(arg1, arg2);
  }

  virtual bool notify(QObject *arg1, QEvent *arg2)
  {
    if (cb_notify_2411_0.can_issue()) {
      return cb_notify_2411_0.issue<QGuiApplication_Adaptor, bool, QObject *, QEvent *>(&QGuiApplication_Adaptor::cbs_notify_2411_0, arg1, arg2);
    } else {
      return QGuiApplication::notify(arg1, arg2);
    }
  }

  //  [emitter impl] void QGuiApplication::organizationDomainChanged()
  void emitter_QGuiApplication_organizationDomainChanged_0()
  {
    emit QGuiApplication::organizationDomainChanged();
  }

  //  [emitter impl] void QGuiApplication::organizationNameChanged()
  void emitter_QGuiApplication_organizationNameChanged_0()
  {
    emit QGuiApplication::organizationNameChanged();
  }

  //  [emitter impl] void QGuiApplication::paletteChanged(const QPalette &pal)
  void emitter_QGuiApplication_paletteChanged_2113(const QPalette &pal)
  {
    emit QGuiApplication::paletteChanged(pal);
  }

  //  [emitter impl] void QGuiApplication::saveStateRequest(QSessionManager &sessionManager)
  void emitter_QGuiApplication_saveStateRequest_2138(QSessionManager &sessionManager)
  {
    emit QGuiApplication::saveStateRequest(sessionManager);
  }

  //  [emitter impl] void QGuiApplication::screenAdded(QScreen *screen)
  void emitter_QGuiApplication_screenAdded_1311(QScreen *screen)
  {
    emit QGuiApplication::screenAdded(screen);
  }

  //  [emitter impl] void QGuiApplication::screenRemoved(QScreen *screen)
  void emitter_QGuiApplication_screenRemoved_1311(QScreen *screen)
  {
    emit QGuiApplication::screenRemoved(screen);
  }

  //  [adaptor impl] void QGuiApplication::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QGuiApplication::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGuiApplication_Adaptor, QChildEvent *>(&QGuiApplication_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QGuiApplication::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QGuiApplication::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QGuiApplication::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGuiApplication_Adaptor, QEvent *>(&QGuiApplication_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QGuiApplication::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QGuiApplication::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QGuiApplication::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QGuiApplication_Adaptor, const QMetaMethod &>(&QGuiApplication_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QGuiApplication::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QGuiApplication::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QGuiApplication::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGuiApplication_Adaptor, bool, QEvent *>(&QGuiApplication_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QGuiApplication::event(arg1);
    }
  }

  //  [adaptor impl] void QGuiApplication::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QGuiApplication::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGuiApplication_Adaptor, QTimerEvent *>(&QGuiApplication_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QGuiApplication::timerEvent(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_notify_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QGuiApplication_Adaptor::~QGuiApplication_Adaptor() { }

// emitter void QGuiApplication::applicationNameChanged()

static void _init_emitter_applicationNameChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_applicationNameChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGuiApplication_Adaptor *)cls)->emitter_QGuiApplication_applicationNameChanged_0 ();
}


// emitter void QGuiApplication::applicationStateChanged(Qt::ApplicationState state)

static void _init_emitter_applicationStateChanged_2402 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<Qt::ApplicationState>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_applicationStateChanged_2402 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ApplicationState>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ApplicationState>::target_type & >() (args, heap);
  ((QGuiApplication_Adaptor *)cls)->emitter_QGuiApplication_applicationStateChanged_2402 (arg1);
}


// emitter void QGuiApplication::applicationVersionChanged()

static void _init_emitter_applicationVersionChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_applicationVersionChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGuiApplication_Adaptor *)cls)->emitter_QGuiApplication_applicationVersionChanged_0 ();
}


// void QGuiApplication::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGuiApplication_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGuiApplication_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QGuiApplication::commitDataRequest(QSessionManager &sessionManager)

static void _init_emitter_commitDataRequest_2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sessionManager");
  decl->add_arg<QSessionManager & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_commitDataRequest_2138 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QSessionManager &arg1 = gsi::arg_reader<QSessionManager & >() (args, heap);
  ((QGuiApplication_Adaptor *)cls)->emitter_QGuiApplication_commitDataRequest_2138 (arg1);
}


// void QGuiApplication::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGuiApplication_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGuiApplication_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QGuiApplication::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QGuiApplication_Adaptor *)cls)->emitter_QGuiApplication_destroyed_1302 (arg1);
}


// void QGuiApplication::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGuiApplication_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QGuiApplication_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QGuiApplication::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGuiApplication_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGuiApplication_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QGuiApplication::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGuiApplication_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGuiApplication_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QGuiApplication::focusObjectChanged(QObject *focusObject)

static void _init_emitter_focusObjectChanged_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("focusObject");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_focusObjectChanged_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  ((QGuiApplication_Adaptor *)cls)->emitter_QGuiApplication_focusObjectChanged_1302 (arg1);
}


// emitter void QGuiApplication::focusWindowChanged(QWindow *focusWindow)

static void _init_emitter_focusWindowChanged_1335 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("focusWindow");
  decl->add_arg<QWindow * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_focusWindowChanged_1335 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWindow *arg1 = gsi::arg_reader<QWindow * >() (args, heap);
  ((QGuiApplication_Adaptor *)cls)->emitter_QGuiApplication_focusWindowChanged_1335 (arg1);
}


// emitter void QGuiApplication::fontDatabaseChanged()

static void _init_emitter_fontDatabaseChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_fontDatabaseChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGuiApplication_Adaptor *)cls)->emitter_QGuiApplication_fontDatabaseChanged_0 ();
}


// exposed bool QGuiApplication::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QGuiApplication_Adaptor *)cls)->fp_QGuiApplication_isSignalConnected_c2394 (arg1));
}


// emitter void QGuiApplication::lastWindowClosed()

static void _init_emitter_lastWindowClosed_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_lastWindowClosed_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGuiApplication_Adaptor *)cls)->emitter_QGuiApplication_lastWindowClosed_0 ();
}


// emitter void QGuiApplication::layoutDirectionChanged(Qt::LayoutDirection direction)

static void _init_emitter_layoutDirectionChanged_2316 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_layoutDirectionChanged_2316 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & >() (args, heap);
  ((QGuiApplication_Adaptor *)cls)->emitter_QGuiApplication_layoutDirectionChanged_2316 (arg1);
}


// bool QGuiApplication::notify(QObject *, QEvent *)

static void _init_cbs_notify_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_notify_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGuiApplication_Adaptor *)cls)->cbs_notify_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_notify_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGuiApplication_Adaptor *)cls)->cb_notify_2411_0 = cb;
}


// emitter void QGuiApplication::organizationDomainChanged()

static void _init_emitter_organizationDomainChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_organizationDomainChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGuiApplication_Adaptor *)cls)->emitter_QGuiApplication_organizationDomainChanged_0 ();
}


// emitter void QGuiApplication::organizationNameChanged()

static void _init_emitter_organizationNameChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_organizationNameChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGuiApplication_Adaptor *)cls)->emitter_QGuiApplication_organizationNameChanged_0 ();
}


// emitter void QGuiApplication::paletteChanged(const QPalette &pal)

static void _init_emitter_paletteChanged_2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pal");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_paletteChanged_2113 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = gsi::arg_reader<const QPalette & >() (args, heap);
  ((QGuiApplication_Adaptor *)cls)->emitter_QGuiApplication_paletteChanged_2113 (arg1);
}


// exposed int QGuiApplication::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QGuiApplication_Adaptor *)cls)->fp_QGuiApplication_receivers_c1731 (arg1));
}


// emitter void QGuiApplication::saveStateRequest(QSessionManager &sessionManager)

static void _init_emitter_saveStateRequest_2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sessionManager");
  decl->add_arg<QSessionManager & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_saveStateRequest_2138 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QSessionManager &arg1 = gsi::arg_reader<QSessionManager & >() (args, heap);
  ((QGuiApplication_Adaptor *)cls)->emitter_QGuiApplication_saveStateRequest_2138 (arg1);
}


// emitter void QGuiApplication::screenAdded(QScreen *screen)

static void _init_emitter_screenAdded_1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("screen");
  decl->add_arg<QScreen * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_screenAdded_1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QScreen *arg1 = gsi::arg_reader<QScreen * >() (args, heap);
  ((QGuiApplication_Adaptor *)cls)->emitter_QGuiApplication_screenAdded_1311 (arg1);
}


// emitter void QGuiApplication::screenRemoved(QScreen *screen)

static void _init_emitter_screenRemoved_1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("screen");
  decl->add_arg<QScreen * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_screenRemoved_1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QScreen *arg1 = gsi::arg_reader<QScreen * >() (args, heap);
  ((QGuiApplication_Adaptor *)cls)->emitter_QGuiApplication_screenRemoved_1311 (arg1);
}


// exposed QObject *QGuiApplication::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QGuiApplication_Adaptor *)cls)->fp_QGuiApplication_sender_c0 ());
}


// exposed int QGuiApplication::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGuiApplication_Adaptor *)cls)->fp_QGuiApplication_senderSignalIndex_c0 ());
}


// void QGuiApplication::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGuiApplication_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGuiApplication_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QGuiApplication> &qtdecl_QGuiApplication ();

static gsi::Methods methods_QGuiApplication_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("emit_applicationNameChanged", "@brief Emitter for signal void QGuiApplication::applicationNameChanged()\nCall this method to emit this signal.", false, &_init_emitter_applicationNameChanged_0, &_call_emitter_applicationNameChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_applicationStateChanged", "@brief Emitter for signal void QGuiApplication::applicationStateChanged(Qt::ApplicationState state)\nCall this method to emit this signal.", false, &_init_emitter_applicationStateChanged_2402, &_call_emitter_applicationStateChanged_2402);
  methods += new qt_gsi::GenericMethod ("emit_applicationVersionChanged", "@brief Emitter for signal void QGuiApplication::applicationVersionChanged()\nCall this method to emit this signal.", false, &_init_emitter_applicationVersionChanged_0, &_call_emitter_applicationVersionChanged_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGuiApplication::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_commitDataRequest", "@brief Emitter for signal void QGuiApplication::commitDataRequest(QSessionManager &sessionManager)\nCall this method to emit this signal.", false, &_init_emitter_commitDataRequest_2138, &_call_emitter_commitDataRequest_2138);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGuiApplication::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QGuiApplication::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGuiApplication::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QGuiApplication::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGuiApplication::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_focusObjectChanged", "@brief Emitter for signal void QGuiApplication::focusObjectChanged(QObject *focusObject)\nCall this method to emit this signal.", false, &_init_emitter_focusObjectChanged_1302, &_call_emitter_focusObjectChanged_1302);
  methods += new qt_gsi::GenericMethod ("emit_focusWindowChanged", "@brief Emitter for signal void QGuiApplication::focusWindowChanged(QWindow *focusWindow)\nCall this method to emit this signal.", false, &_init_emitter_focusWindowChanged_1335, &_call_emitter_focusWindowChanged_1335);
  methods += new qt_gsi::GenericMethod ("emit_fontDatabaseChanged", "@brief Emitter for signal void QGuiApplication::fontDatabaseChanged()\nCall this method to emit this signal.", false, &_init_emitter_fontDatabaseChanged_0, &_call_emitter_fontDatabaseChanged_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QGuiApplication::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_lastWindowClosed", "@brief Emitter for signal void QGuiApplication::lastWindowClosed()\nCall this method to emit this signal.", false, &_init_emitter_lastWindowClosed_0, &_call_emitter_lastWindowClosed_0);
  methods += new qt_gsi::GenericMethod ("emit_layoutDirectionChanged", "@brief Emitter for signal void QGuiApplication::layoutDirectionChanged(Qt::LayoutDirection direction)\nCall this method to emit this signal.", false, &_init_emitter_layoutDirectionChanged_2316, &_call_emitter_layoutDirectionChanged_2316);
  methods += new qt_gsi::GenericMethod ("notify", "@hide", false, &_init_cbs_notify_2411_0, &_call_cbs_notify_2411_0);
  methods += new qt_gsi::GenericMethod ("notify", "@brief Virtual method bool QGuiApplication::notify(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_notify_2411_0, &_call_cbs_notify_2411_0, &_set_callback_cbs_notify_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_organizationDomainChanged", "@brief Emitter for signal void QGuiApplication::organizationDomainChanged()\nCall this method to emit this signal.", false, &_init_emitter_organizationDomainChanged_0, &_call_emitter_organizationDomainChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_organizationNameChanged", "@brief Emitter for signal void QGuiApplication::organizationNameChanged()\nCall this method to emit this signal.", false, &_init_emitter_organizationNameChanged_0, &_call_emitter_organizationNameChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_paletteChanged", "@brief Emitter for signal void QGuiApplication::paletteChanged(const QPalette &pal)\nCall this method to emit this signal.", false, &_init_emitter_paletteChanged_2113, &_call_emitter_paletteChanged_2113);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QGuiApplication::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("emit_saveStateRequest", "@brief Emitter for signal void QGuiApplication::saveStateRequest(QSessionManager &sessionManager)\nCall this method to emit this signal.", false, &_init_emitter_saveStateRequest_2138, &_call_emitter_saveStateRequest_2138);
  methods += new qt_gsi::GenericMethod ("emit_screenAdded", "@brief Emitter for signal void QGuiApplication::screenAdded(QScreen *screen)\nCall this method to emit this signal.", false, &_init_emitter_screenAdded_1311, &_call_emitter_screenAdded_1311);
  methods += new qt_gsi::GenericMethod ("emit_screenRemoved", "@brief Emitter for signal void QGuiApplication::screenRemoved(QScreen *screen)\nCall this method to emit this signal.", false, &_init_emitter_screenRemoved_1311, &_call_emitter_screenRemoved_1311);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QGuiApplication::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QGuiApplication::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGuiApplication::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QGuiApplication_Adaptor> decl_QGuiApplication_Adaptor (qtdecl_QGuiApplication (), "QtGui", "QGuiApplication",
    gsi::constructor("new", &QGuiApplication_Adaptor::ctor_QGuiApplication_Adaptor_args, gsi::arg ("argv"), "@brief Creates a new QGuiApplication object\n\n@param argv The command line arguments to pass to Qt")
+
  methods_QGuiApplication_Adaptor (),
  "@qt\n@brief Binding of QGuiApplication");

}

