
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQXmlSimpleReader.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QXmlSimpleReader>
#include <QXmlContentHandler>
#include <QXmlDTDHandler>
#include <QXmlDeclHandler>
#include <QXmlEntityResolver>
#include <QXmlErrorHandler>
#include <QXmlInputSource>
#include <QXmlLexicalHandler>
#include "gsiQt.h"
#include "gsiQtXmlCommon.h"
#include "gsiDeclQtXmlTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QXmlSimpleReader

// QXmlDTDHandler *QXmlSimpleReader::DTDHandler()


static void _init_f_DTDHandler_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlDTDHandler * > ();
}

static void _call_f_DTDHandler_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlDTDHandler * > ((QXmlDTDHandler *)((QXmlSimpleReader *)cls)->DTDHandler ());
}


// QXmlContentHandler *QXmlSimpleReader::contentHandler()


static void _init_f_contentHandler_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlContentHandler * > ();
}

static void _call_f_contentHandler_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlContentHandler * > ((QXmlContentHandler *)((QXmlSimpleReader *)cls)->contentHandler ());
}


// QXmlDeclHandler *QXmlSimpleReader::declHandler()


static void _init_f_declHandler_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlDeclHandler * > ();
}

static void _call_f_declHandler_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlDeclHandler * > ((QXmlDeclHandler *)((QXmlSimpleReader *)cls)->declHandler ());
}


// QXmlEntityResolver *QXmlSimpleReader::entityResolver()


static void _init_f_entityResolver_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlEntityResolver * > ();
}

static void _call_f_entityResolver_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlEntityResolver * > ((QXmlEntityResolver *)((QXmlSimpleReader *)cls)->entityResolver ());
}


// QXmlErrorHandler *QXmlSimpleReader::errorHandler()


static void _init_f_errorHandler_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlErrorHandler * > ();
}

static void _call_f_errorHandler_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlErrorHandler * > ((QXmlErrorHandler *)((QXmlSimpleReader *)cls)->errorHandler ());
}


// bool QXmlSimpleReader::feature(const QString &name, bool *ok)


static void _init_f_feature_c2967 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_feature_c2967 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<bool > ((bool)((QXmlSimpleReader *)cls)->feature (arg1, arg2));
}


// bool QXmlSimpleReader::hasFeature(const QString &name)


static void _init_f_hasFeature_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasFeature_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QXmlSimpleReader *)cls)->hasFeature (arg1));
}


// bool QXmlSimpleReader::hasProperty(const QString &name)


static void _init_f_hasProperty_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasProperty_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QXmlSimpleReader *)cls)->hasProperty (arg1));
}


// QXmlLexicalHandler *QXmlSimpleReader::lexicalHandler()


static void _init_f_lexicalHandler_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlLexicalHandler * > ();
}

static void _call_f_lexicalHandler_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlLexicalHandler * > ((QXmlLexicalHandler *)((QXmlSimpleReader *)cls)->lexicalHandler ());
}


// bool QXmlSimpleReader::parse(const QXmlInputSource *input)


static void _init_f_parse_2856 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("input");
  decl->add_arg<const QXmlInputSource * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_parse_2856 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlInputSource *arg1 = gsi::arg_reader<const QXmlInputSource * >() (args, heap);
  ret.write<bool > ((bool)((QXmlSimpleReader *)cls)->parse (arg1));
}


// bool QXmlSimpleReader::parse(const QXmlInputSource *input, bool incremental)


static void _init_f_parse_3612 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("input");
  decl->add_arg<const QXmlInputSource * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("incremental");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_parse_3612 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlInputSource *arg1 = gsi::arg_reader<const QXmlInputSource * >() (args, heap);
  bool arg2 = gsi::arg_reader<bool >() (args, heap);
  ret.write<bool > ((bool)((QXmlSimpleReader *)cls)->parse (arg1, arg2));
}


// bool QXmlSimpleReader::parseContinue()


static void _init_f_parseContinue_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_parseContinue_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlSimpleReader *)cls)->parseContinue ());
}


// void *QXmlSimpleReader::property(const QString &name, bool *ok)


static void _init_f_property_c2967 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<void * > ();
}

static void _call_f_property_c2967 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<void * > ((void *)((QXmlSimpleReader *)cls)->property (arg1, arg2));
}


// void QXmlSimpleReader::setContentHandler(QXmlContentHandler *handler)


static void _init_f_setContentHandler_2441 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlContentHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setContentHandler_2441 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlContentHandler *arg1 = gsi::arg_reader<QXmlContentHandler * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlSimpleReader *)cls)->setContentHandler (arg1);
}


// void QXmlSimpleReader::setDTDHandler(QXmlDTDHandler *handler)


static void _init_f_setDTDHandler_1930 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlDTDHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDTDHandler_1930 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlDTDHandler *arg1 = gsi::arg_reader<QXmlDTDHandler * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlSimpleReader *)cls)->setDTDHandler (arg1);
}


// void QXmlSimpleReader::setDeclHandler(QXmlDeclHandler *handler)


static void _init_f_setDeclHandler_2086 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlDeclHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDeclHandler_2086 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlDeclHandler *arg1 = gsi::arg_reader<QXmlDeclHandler * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlSimpleReader *)cls)->setDeclHandler (arg1);
}


// void QXmlSimpleReader::setEntityResolver(QXmlEntityResolver *handler)


static void _init_f_setEntityResolver_2495 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlEntityResolver * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEntityResolver_2495 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlEntityResolver *arg1 = gsi::arg_reader<QXmlEntityResolver * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlSimpleReader *)cls)->setEntityResolver (arg1);
}


// void QXmlSimpleReader::setErrorHandler(QXmlErrorHandler *handler)


static void _init_f_setErrorHandler_2232 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlErrorHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setErrorHandler_2232 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlErrorHandler *arg1 = gsi::arg_reader<QXmlErrorHandler * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlSimpleReader *)cls)->setErrorHandler (arg1);
}


// void QXmlSimpleReader::setFeature(const QString &name, bool value)


static void _init_f_setFeature_2781 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFeature_2781 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  bool arg2 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlSimpleReader *)cls)->setFeature (arg1, arg2);
}


// void QXmlSimpleReader::setLexicalHandler(QXmlLexicalHandler *handler)


static void _init_f_setLexicalHandler_2416 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlLexicalHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLexicalHandler_2416 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlLexicalHandler *arg1 = gsi::arg_reader<QXmlLexicalHandler * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlSimpleReader *)cls)->setLexicalHandler (arg1);
}


// void QXmlSimpleReader::setProperty(const QString &name, void *value)


static void _init_f_setProperty_2973 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<void * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setProperty_2973 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  void *arg2 = gsi::arg_reader<void * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlSimpleReader *)cls)->setProperty (arg1, arg2);
}


namespace gsi
{

static gsi::Methods methods_QXmlSimpleReader () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("DTDHandler", "@brief Method QXmlDTDHandler *QXmlSimpleReader::DTDHandler()\nThis is a reimplementation of QXmlReader::DTDHandler", true, &_init_f_DTDHandler_c0, &_call_f_DTDHandler_c0);
  methods += new qt_gsi::GenericMethod (":contentHandler", "@brief Method QXmlContentHandler *QXmlSimpleReader::contentHandler()\nThis is a reimplementation of QXmlReader::contentHandler", true, &_init_f_contentHandler_c0, &_call_f_contentHandler_c0);
  methods += new qt_gsi::GenericMethod (":declHandler", "@brief Method QXmlDeclHandler *QXmlSimpleReader::declHandler()\nThis is a reimplementation of QXmlReader::declHandler", true, &_init_f_declHandler_c0, &_call_f_declHandler_c0);
  methods += new qt_gsi::GenericMethod (":entityResolver", "@brief Method QXmlEntityResolver *QXmlSimpleReader::entityResolver()\nThis is a reimplementation of QXmlReader::entityResolver", true, &_init_f_entityResolver_c0, &_call_f_entityResolver_c0);
  methods += new qt_gsi::GenericMethod (":errorHandler", "@brief Method QXmlErrorHandler *QXmlSimpleReader::errorHandler()\nThis is a reimplementation of QXmlReader::errorHandler", true, &_init_f_errorHandler_c0, &_call_f_errorHandler_c0);
  methods += new qt_gsi::GenericMethod ("feature", "@brief Method bool QXmlSimpleReader::feature(const QString &name, bool *ok)\nThis is a reimplementation of QXmlReader::feature", true, &_init_f_feature_c2967, &_call_f_feature_c2967);
  methods += new qt_gsi::GenericMethod ("hasFeature", "@brief Method bool QXmlSimpleReader::hasFeature(const QString &name)\nThis is a reimplementation of QXmlReader::hasFeature", true, &_init_f_hasFeature_c2025, &_call_f_hasFeature_c2025);
  methods += new qt_gsi::GenericMethod ("hasProperty", "@brief Method bool QXmlSimpleReader::hasProperty(const QString &name)\nThis is a reimplementation of QXmlReader::hasProperty", true, &_init_f_hasProperty_c2025, &_call_f_hasProperty_c2025);
  methods += new qt_gsi::GenericMethod (":lexicalHandler", "@brief Method QXmlLexicalHandler *QXmlSimpleReader::lexicalHandler()\nThis is a reimplementation of QXmlReader::lexicalHandler", true, &_init_f_lexicalHandler_c0, &_call_f_lexicalHandler_c0);
  methods += new qt_gsi::GenericMethod ("parse", "@brief Method bool QXmlSimpleReader::parse(const QXmlInputSource *input)\nThis is a reimplementation of QXmlReader::parse", false, &_init_f_parse_2856, &_call_f_parse_2856);
  methods += new qt_gsi::GenericMethod ("parse", "@brief Method bool QXmlSimpleReader::parse(const QXmlInputSource *input, bool incremental)\n", false, &_init_f_parse_3612, &_call_f_parse_3612);
  methods += new qt_gsi::GenericMethod ("parseContinue", "@brief Method bool QXmlSimpleReader::parseContinue()\n", false, &_init_f_parseContinue_0, &_call_f_parseContinue_0);
  methods += new qt_gsi::GenericMethod ("property", "@brief Method void *QXmlSimpleReader::property(const QString &name, bool *ok)\nThis is a reimplementation of QXmlReader::property", true, &_init_f_property_c2967, &_call_f_property_c2967);
  methods += new qt_gsi::GenericMethod ("setContentHandler|contentHandler=", "@brief Method void QXmlSimpleReader::setContentHandler(QXmlContentHandler *handler)\nThis is a reimplementation of QXmlReader::setContentHandler", false, &_init_f_setContentHandler_2441, &_call_f_setContentHandler_2441);
  methods += new qt_gsi::GenericMethod ("setDTDHandler", "@brief Method void QXmlSimpleReader::setDTDHandler(QXmlDTDHandler *handler)\nThis is a reimplementation of QXmlReader::setDTDHandler", false, &_init_f_setDTDHandler_1930, &_call_f_setDTDHandler_1930);
  methods += new qt_gsi::GenericMethod ("setDeclHandler|declHandler=", "@brief Method void QXmlSimpleReader::setDeclHandler(QXmlDeclHandler *handler)\nThis is a reimplementation of QXmlReader::setDeclHandler", false, &_init_f_setDeclHandler_2086, &_call_f_setDeclHandler_2086);
  methods += new qt_gsi::GenericMethod ("setEntityResolver|entityResolver=", "@brief Method void QXmlSimpleReader::setEntityResolver(QXmlEntityResolver *handler)\nThis is a reimplementation of QXmlReader::setEntityResolver", false, &_init_f_setEntityResolver_2495, &_call_f_setEntityResolver_2495);
  methods += new qt_gsi::GenericMethod ("setErrorHandler|errorHandler=", "@brief Method void QXmlSimpleReader::setErrorHandler(QXmlErrorHandler *handler)\nThis is a reimplementation of QXmlReader::setErrorHandler", false, &_init_f_setErrorHandler_2232, &_call_f_setErrorHandler_2232);
  methods += new qt_gsi::GenericMethod ("setFeature", "@brief Method void QXmlSimpleReader::setFeature(const QString &name, bool value)\nThis is a reimplementation of QXmlReader::setFeature", false, &_init_f_setFeature_2781, &_call_f_setFeature_2781);
  methods += new qt_gsi::GenericMethod ("setLexicalHandler|lexicalHandler=", "@brief Method void QXmlSimpleReader::setLexicalHandler(QXmlLexicalHandler *handler)\nThis is a reimplementation of QXmlReader::setLexicalHandler", false, &_init_f_setLexicalHandler_2416, &_call_f_setLexicalHandler_2416);
  methods += new qt_gsi::GenericMethod ("setProperty", "@brief Method void QXmlSimpleReader::setProperty(const QString &name, void *value)\nThis is a reimplementation of QXmlReader::setProperty", false, &_init_f_setProperty_2973, &_call_f_setProperty_2973);
  return methods;
}

gsi::Class<QXmlReader> &qtdecl_QXmlReader ();

gsi::Class<QXmlSimpleReader> decl_QXmlSimpleReader (qtdecl_QXmlReader (), "QtXml", "QXmlSimpleReader_Native",
  methods_QXmlSimpleReader (),
  "@hide\n@alias QXmlSimpleReader");

GSI_QTXML_PUBLIC gsi::Class<QXmlSimpleReader> &qtdecl_QXmlSimpleReader () { return decl_QXmlSimpleReader; }

}


class QXmlSimpleReader_Adaptor : public QXmlSimpleReader, public qt_gsi::QtObjectBase
{
public:

  virtual ~QXmlSimpleReader_Adaptor();

  //  [adaptor ctor] QXmlSimpleReader::QXmlSimpleReader()
  QXmlSimpleReader_Adaptor() : QXmlSimpleReader()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] QXmlDTDHandler *QXmlSimpleReader::DTDHandler()
  QXmlDTDHandler * cbs_DTDHandler_c0_0() const
  {
    return QXmlSimpleReader::DTDHandler();
  }

  virtual QXmlDTDHandler * DTDHandler() const
  {
    if (cb_DTDHandler_c0_0.can_issue()) {
      return cb_DTDHandler_c0_0.issue<QXmlSimpleReader_Adaptor, QXmlDTDHandler *>(&QXmlSimpleReader_Adaptor::cbs_DTDHandler_c0_0);
    } else {
      return QXmlSimpleReader::DTDHandler();
    }
  }

  //  [adaptor impl] QXmlContentHandler *QXmlSimpleReader::contentHandler()
  QXmlContentHandler * cbs_contentHandler_c0_0() const
  {
    return QXmlSimpleReader::contentHandler();
  }

  virtual QXmlContentHandler * contentHandler() const
  {
    if (cb_contentHandler_c0_0.can_issue()) {
      return cb_contentHandler_c0_0.issue<QXmlSimpleReader_Adaptor, QXmlContentHandler *>(&QXmlSimpleReader_Adaptor::cbs_contentHandler_c0_0);
    } else {
      return QXmlSimpleReader::contentHandler();
    }
  }

  //  [adaptor impl] QXmlDeclHandler *QXmlSimpleReader::declHandler()
  QXmlDeclHandler * cbs_declHandler_c0_0() const
  {
    return QXmlSimpleReader::declHandler();
  }

  virtual QXmlDeclHandler * declHandler() const
  {
    if (cb_declHandler_c0_0.can_issue()) {
      return cb_declHandler_c0_0.issue<QXmlSimpleReader_Adaptor, QXmlDeclHandler *>(&QXmlSimpleReader_Adaptor::cbs_declHandler_c0_0);
    } else {
      return QXmlSimpleReader::declHandler();
    }
  }

  //  [adaptor impl] QXmlEntityResolver *QXmlSimpleReader::entityResolver()
  QXmlEntityResolver * cbs_entityResolver_c0_0() const
  {
    return QXmlSimpleReader::entityResolver();
  }

  virtual QXmlEntityResolver * entityResolver() const
  {
    if (cb_entityResolver_c0_0.can_issue()) {
      return cb_entityResolver_c0_0.issue<QXmlSimpleReader_Adaptor, QXmlEntityResolver *>(&QXmlSimpleReader_Adaptor::cbs_entityResolver_c0_0);
    } else {
      return QXmlSimpleReader::entityResolver();
    }
  }

  //  [adaptor impl] QXmlErrorHandler *QXmlSimpleReader::errorHandler()
  QXmlErrorHandler * cbs_errorHandler_c0_0() const
  {
    return QXmlSimpleReader::errorHandler();
  }

  virtual QXmlErrorHandler * errorHandler() const
  {
    if (cb_errorHandler_c0_0.can_issue()) {
      return cb_errorHandler_c0_0.issue<QXmlSimpleReader_Adaptor, QXmlErrorHandler *>(&QXmlSimpleReader_Adaptor::cbs_errorHandler_c0_0);
    } else {
      return QXmlSimpleReader::errorHandler();
    }
  }

  //  [adaptor impl] bool QXmlSimpleReader::feature(const QString &name, bool *ok)
  bool cbs_feature_c2967_1(const QString &name, bool *ok) const
  {
    return QXmlSimpleReader::feature(name, ok);
  }

  virtual bool feature(const QString &name, bool *ok) const
  {
    if (cb_feature_c2967_1.can_issue()) {
      return cb_feature_c2967_1.issue<QXmlSimpleReader_Adaptor, bool, const QString &, bool *>(&QXmlSimpleReader_Adaptor::cbs_feature_c2967_1, name, ok);
    } else {
      return QXmlSimpleReader::feature(name, ok);
    }
  }

  //  [adaptor impl] bool QXmlSimpleReader::hasFeature(const QString &name)
  bool cbs_hasFeature_c2025_0(const QString &name) const
  {
    return QXmlSimpleReader::hasFeature(name);
  }

  virtual bool hasFeature(const QString &name) const
  {
    if (cb_hasFeature_c2025_0.can_issue()) {
      return cb_hasFeature_c2025_0.issue<QXmlSimpleReader_Adaptor, bool, const QString &>(&QXmlSimpleReader_Adaptor::cbs_hasFeature_c2025_0, name);
    } else {
      return QXmlSimpleReader::hasFeature(name);
    }
  }

  //  [adaptor impl] bool QXmlSimpleReader::hasProperty(const QString &name)
  bool cbs_hasProperty_c2025_0(const QString &name) const
  {
    return QXmlSimpleReader::hasProperty(name);
  }

  virtual bool hasProperty(const QString &name) const
  {
    if (cb_hasProperty_c2025_0.can_issue()) {
      return cb_hasProperty_c2025_0.issue<QXmlSimpleReader_Adaptor, bool, const QString &>(&QXmlSimpleReader_Adaptor::cbs_hasProperty_c2025_0, name);
    } else {
      return QXmlSimpleReader::hasProperty(name);
    }
  }

  //  [adaptor impl] QXmlLexicalHandler *QXmlSimpleReader::lexicalHandler()
  QXmlLexicalHandler * cbs_lexicalHandler_c0_0() const
  {
    return QXmlSimpleReader::lexicalHandler();
  }

  virtual QXmlLexicalHandler * lexicalHandler() const
  {
    if (cb_lexicalHandler_c0_0.can_issue()) {
      return cb_lexicalHandler_c0_0.issue<QXmlSimpleReader_Adaptor, QXmlLexicalHandler *>(&QXmlSimpleReader_Adaptor::cbs_lexicalHandler_c0_0);
    } else {
      return QXmlSimpleReader::lexicalHandler();
    }
  }

  //  [adaptor impl] bool QXmlSimpleReader::parse(const QXmlInputSource *input)
  bool cbs_parse_2856_0(const QXmlInputSource *input)
  {
    return QXmlSimpleReader::parse(input);
  }

  virtual bool parse(const QXmlInputSource *input)
  {
    if (cb_parse_2856_0.can_issue()) {
      return cb_parse_2856_0.issue<QXmlSimpleReader_Adaptor, bool, const QXmlInputSource *>(&QXmlSimpleReader_Adaptor::cbs_parse_2856_0, input);
    } else {
      return QXmlSimpleReader::parse(input);
    }
  }

  //  [adaptor impl] bool QXmlSimpleReader::parse(const QXmlInputSource *input, bool incremental)
  bool cbs_parse_3612_0(const QXmlInputSource *input, bool incremental)
  {
    return QXmlSimpleReader::parse(input, incremental);
  }

  virtual bool parse(const QXmlInputSource *input, bool incremental)
  {
    if (cb_parse_3612_0.can_issue()) {
      return cb_parse_3612_0.issue<QXmlSimpleReader_Adaptor, bool, const QXmlInputSource *, bool>(&QXmlSimpleReader_Adaptor::cbs_parse_3612_0, input, incremental);
    } else {
      return QXmlSimpleReader::parse(input, incremental);
    }
  }

  //  [adaptor impl] bool QXmlSimpleReader::parseContinue()
  bool cbs_parseContinue_0_0()
  {
    return QXmlSimpleReader::parseContinue();
  }

  virtual bool parseContinue()
  {
    if (cb_parseContinue_0_0.can_issue()) {
      return cb_parseContinue_0_0.issue<QXmlSimpleReader_Adaptor, bool>(&QXmlSimpleReader_Adaptor::cbs_parseContinue_0_0);
    } else {
      return QXmlSimpleReader::parseContinue();
    }
  }

  //  [adaptor impl] void *QXmlSimpleReader::property(const QString &name, bool *ok)
  void * cbs_property_c2967_1(const QString &name, bool *ok) const
  {
    return QXmlSimpleReader::property(name, ok);
  }

  virtual void * property(const QString &name, bool *ok) const
  {
    if (cb_property_c2967_1.can_issue()) {
      return cb_property_c2967_1.issue<QXmlSimpleReader_Adaptor, void *, const QString &, bool *>(&QXmlSimpleReader_Adaptor::cbs_property_c2967_1, name, ok);
    } else {
      return QXmlSimpleReader::property(name, ok);
    }
  }

  //  [adaptor impl] void QXmlSimpleReader::setContentHandler(QXmlContentHandler *handler)
  void cbs_setContentHandler_2441_0(QXmlContentHandler *handler)
  {
    QXmlSimpleReader::setContentHandler(handler);
  }

  virtual void setContentHandler(QXmlContentHandler *handler)
  {
    if (cb_setContentHandler_2441_0.can_issue()) {
      cb_setContentHandler_2441_0.issue<QXmlSimpleReader_Adaptor, QXmlContentHandler *>(&QXmlSimpleReader_Adaptor::cbs_setContentHandler_2441_0, handler);
    } else {
      QXmlSimpleReader::setContentHandler(handler);
    }
  }

  //  [adaptor impl] void QXmlSimpleReader::setDTDHandler(QXmlDTDHandler *handler)
  void cbs_setDTDHandler_1930_0(QXmlDTDHandler *handler)
  {
    QXmlSimpleReader::setDTDHandler(handler);
  }

  virtual void setDTDHandler(QXmlDTDHandler *handler)
  {
    if (cb_setDTDHandler_1930_0.can_issue()) {
      cb_setDTDHandler_1930_0.issue<QXmlSimpleReader_Adaptor, QXmlDTDHandler *>(&QXmlSimpleReader_Adaptor::cbs_setDTDHandler_1930_0, handler);
    } else {
      QXmlSimpleReader::setDTDHandler(handler);
    }
  }

  //  [adaptor impl] void QXmlSimpleReader::setDeclHandler(QXmlDeclHandler *handler)
  void cbs_setDeclHandler_2086_0(QXmlDeclHandler *handler)
  {
    QXmlSimpleReader::setDeclHandler(handler);
  }

  virtual void setDeclHandler(QXmlDeclHandler *handler)
  {
    if (cb_setDeclHandler_2086_0.can_issue()) {
      cb_setDeclHandler_2086_0.issue<QXmlSimpleReader_Adaptor, QXmlDeclHandler *>(&QXmlSimpleReader_Adaptor::cbs_setDeclHandler_2086_0, handler);
    } else {
      QXmlSimpleReader::setDeclHandler(handler);
    }
  }

  //  [adaptor impl] void QXmlSimpleReader::setEntityResolver(QXmlEntityResolver *handler)
  void cbs_setEntityResolver_2495_0(QXmlEntityResolver *handler)
  {
    QXmlSimpleReader::setEntityResolver(handler);
  }

  virtual void setEntityResolver(QXmlEntityResolver *handler)
  {
    if (cb_setEntityResolver_2495_0.can_issue()) {
      cb_setEntityResolver_2495_0.issue<QXmlSimpleReader_Adaptor, QXmlEntityResolver *>(&QXmlSimpleReader_Adaptor::cbs_setEntityResolver_2495_0, handler);
    } else {
      QXmlSimpleReader::setEntityResolver(handler);
    }
  }

  //  [adaptor impl] void QXmlSimpleReader::setErrorHandler(QXmlErrorHandler *handler)
  void cbs_setErrorHandler_2232_0(QXmlErrorHandler *handler)
  {
    QXmlSimpleReader::setErrorHandler(handler);
  }

  virtual void setErrorHandler(QXmlErrorHandler *handler)
  {
    if (cb_setErrorHandler_2232_0.can_issue()) {
      cb_setErrorHandler_2232_0.issue<QXmlSimpleReader_Adaptor, QXmlErrorHandler *>(&QXmlSimpleReader_Adaptor::cbs_setErrorHandler_2232_0, handler);
    } else {
      QXmlSimpleReader::setErrorHandler(handler);
    }
  }

  //  [adaptor impl] void QXmlSimpleReader::setFeature(const QString &name, bool value)
  void cbs_setFeature_2781_0(const QString &name, bool value)
  {
    QXmlSimpleReader::setFeature(name, value);
  }

  virtual void setFeature(const QString &name, bool value)
  {
    if (cb_setFeature_2781_0.can_issue()) {
      cb_setFeature_2781_0.issue<QXmlSimpleReader_Adaptor, const QString &, bool>(&QXmlSimpleReader_Adaptor::cbs_setFeature_2781_0, name, value);
    } else {
      QXmlSimpleReader::setFeature(name, value);
    }
  }

  //  [adaptor impl] void QXmlSimpleReader::setLexicalHandler(QXmlLexicalHandler *handler)
  void cbs_setLexicalHandler_2416_0(QXmlLexicalHandler *handler)
  {
    QXmlSimpleReader::setLexicalHandler(handler);
  }

  virtual void setLexicalHandler(QXmlLexicalHandler *handler)
  {
    if (cb_setLexicalHandler_2416_0.can_issue()) {
      cb_setLexicalHandler_2416_0.issue<QXmlSimpleReader_Adaptor, QXmlLexicalHandler *>(&QXmlSimpleReader_Adaptor::cbs_setLexicalHandler_2416_0, handler);
    } else {
      QXmlSimpleReader::setLexicalHandler(handler);
    }
  }

  //  [adaptor impl] void QXmlSimpleReader::setProperty(const QString &name, void *value)
  void cbs_setProperty_2973_0(const QString &name, void *value)
  {
    QXmlSimpleReader::setProperty(name, value);
  }

  virtual void setProperty(const QString &name, void *value)
  {
    if (cb_setProperty_2973_0.can_issue()) {
      cb_setProperty_2973_0.issue<QXmlSimpleReader_Adaptor, const QString &, void *>(&QXmlSimpleReader_Adaptor::cbs_setProperty_2973_0, name, value);
    } else {
      QXmlSimpleReader::setProperty(name, value);
    }
  }

  gsi::Callback cb_DTDHandler_c0_0;
  gsi::Callback cb_contentHandler_c0_0;
  gsi::Callback cb_declHandler_c0_0;
  gsi::Callback cb_entityResolver_c0_0;
  gsi::Callback cb_errorHandler_c0_0;
  gsi::Callback cb_feature_c2967_1;
  gsi::Callback cb_hasFeature_c2025_0;
  gsi::Callback cb_hasProperty_c2025_0;
  gsi::Callback cb_lexicalHandler_c0_0;
  gsi::Callback cb_parse_2856_0;
  gsi::Callback cb_parse_3612_0;
  gsi::Callback cb_parseContinue_0_0;
  gsi::Callback cb_property_c2967_1;
  gsi::Callback cb_setContentHandler_2441_0;
  gsi::Callback cb_setDTDHandler_1930_0;
  gsi::Callback cb_setDeclHandler_2086_0;
  gsi::Callback cb_setEntityResolver_2495_0;
  gsi::Callback cb_setErrorHandler_2232_0;
  gsi::Callback cb_setFeature_2781_0;
  gsi::Callback cb_setLexicalHandler_2416_0;
  gsi::Callback cb_setProperty_2973_0;
};

QXmlSimpleReader_Adaptor::~QXmlSimpleReader_Adaptor() { }

//  Constructor QXmlSimpleReader::QXmlSimpleReader() (adaptor class)

static void _init_ctor_QXmlSimpleReader_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QXmlSimpleReader_Adaptor> ();
}

static void _call_ctor_QXmlSimpleReader_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlSimpleReader_Adaptor *> (new QXmlSimpleReader_Adaptor ());
}


// QXmlDTDHandler *QXmlSimpleReader::DTDHandler()

static void _init_cbs_DTDHandler_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlDTDHandler * > ();
}

static void _call_cbs_DTDHandler_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlDTDHandler * > ((QXmlDTDHandler *)((QXmlSimpleReader_Adaptor *)cls)->cbs_DTDHandler_c0_0 ());
}

static void _set_callback_cbs_DTDHandler_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_DTDHandler_c0_0 = cb;
}


// QXmlContentHandler *QXmlSimpleReader::contentHandler()

static void _init_cbs_contentHandler_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlContentHandler * > ();
}

static void _call_cbs_contentHandler_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlContentHandler * > ((QXmlContentHandler *)((QXmlSimpleReader_Adaptor *)cls)->cbs_contentHandler_c0_0 ());
}

static void _set_callback_cbs_contentHandler_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_contentHandler_c0_0 = cb;
}


// QXmlDeclHandler *QXmlSimpleReader::declHandler()

static void _init_cbs_declHandler_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlDeclHandler * > ();
}

static void _call_cbs_declHandler_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlDeclHandler * > ((QXmlDeclHandler *)((QXmlSimpleReader_Adaptor *)cls)->cbs_declHandler_c0_0 ());
}

static void _set_callback_cbs_declHandler_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_declHandler_c0_0 = cb;
}


// QXmlEntityResolver *QXmlSimpleReader::entityResolver()

static void _init_cbs_entityResolver_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlEntityResolver * > ();
}

static void _call_cbs_entityResolver_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlEntityResolver * > ((QXmlEntityResolver *)((QXmlSimpleReader_Adaptor *)cls)->cbs_entityResolver_c0_0 ());
}

static void _set_callback_cbs_entityResolver_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_entityResolver_c0_0 = cb;
}


// QXmlErrorHandler *QXmlSimpleReader::errorHandler()

static void _init_cbs_errorHandler_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlErrorHandler * > ();
}

static void _call_cbs_errorHandler_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlErrorHandler * > ((QXmlErrorHandler *)((QXmlSimpleReader_Adaptor *)cls)->cbs_errorHandler_c0_0 ());
}

static void _set_callback_cbs_errorHandler_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_errorHandler_c0_0 = cb;
}


// bool QXmlSimpleReader::feature(const QString &name, bool *ok)

static void _init_cbs_feature_c2967_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_feature_c2967_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  bool *arg2 = args.read<bool * > (heap);
  ret.write<bool > ((bool)((QXmlSimpleReader_Adaptor *)cls)->cbs_feature_c2967_1 (arg1, arg2));
}

static void _set_callback_cbs_feature_c2967_1 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_feature_c2967_1 = cb;
}


// bool QXmlSimpleReader::hasFeature(const QString &name)

static void _init_cbs_hasFeature_c2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_hasFeature_c2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QXmlSimpleReader_Adaptor *)cls)->cbs_hasFeature_c2025_0 (arg1));
}

static void _set_callback_cbs_hasFeature_c2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_hasFeature_c2025_0 = cb;
}


// bool QXmlSimpleReader::hasProperty(const QString &name)

static void _init_cbs_hasProperty_c2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_hasProperty_c2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QXmlSimpleReader_Adaptor *)cls)->cbs_hasProperty_c2025_0 (arg1));
}

static void _set_callback_cbs_hasProperty_c2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_hasProperty_c2025_0 = cb;
}


// QXmlLexicalHandler *QXmlSimpleReader::lexicalHandler()

static void _init_cbs_lexicalHandler_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlLexicalHandler * > ();
}

static void _call_cbs_lexicalHandler_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlLexicalHandler * > ((QXmlLexicalHandler *)((QXmlSimpleReader_Adaptor *)cls)->cbs_lexicalHandler_c0_0 ());
}

static void _set_callback_cbs_lexicalHandler_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_lexicalHandler_c0_0 = cb;
}


// bool QXmlSimpleReader::parse(const QXmlInputSource *input)

static void _init_cbs_parse_2856_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("input");
  decl->add_arg<const QXmlInputSource * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_parse_2856_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlInputSource *arg1 = args.read<const QXmlInputSource * > (heap);
  ret.write<bool > ((bool)((QXmlSimpleReader_Adaptor *)cls)->cbs_parse_2856_0 (arg1));
}

static void _set_callback_cbs_parse_2856_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_parse_2856_0 = cb;
}


// bool QXmlSimpleReader::parse(const QXmlInputSource *input, bool incremental)

static void _init_cbs_parse_3612_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("input");
  decl->add_arg<const QXmlInputSource * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("incremental");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_parse_3612_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlInputSource *arg1 = args.read<const QXmlInputSource * > (heap);
  bool arg2 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QXmlSimpleReader_Adaptor *)cls)->cbs_parse_3612_0 (arg1, arg2));
}

static void _set_callback_cbs_parse_3612_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_parse_3612_0 = cb;
}


// bool QXmlSimpleReader::parseContinue()

static void _init_cbs_parseContinue_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_parseContinue_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QXmlSimpleReader_Adaptor *)cls)->cbs_parseContinue_0_0 ());
}

static void _set_callback_cbs_parseContinue_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_parseContinue_0_0 = cb;
}


// void *QXmlSimpleReader::property(const QString &name, bool *ok)

static void _init_cbs_property_c2967_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<void * > ();
}

static void _call_cbs_property_c2967_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  bool *arg2 = args.read<bool * > (heap);
  ret.write<void * > ((void *)((QXmlSimpleReader_Adaptor *)cls)->cbs_property_c2967_1 (arg1, arg2));
}

static void _set_callback_cbs_property_c2967_1 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_property_c2967_1 = cb;
}


// void QXmlSimpleReader::setContentHandler(QXmlContentHandler *handler)

static void _init_cbs_setContentHandler_2441_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlContentHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setContentHandler_2441_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlContentHandler *arg1 = args.read<QXmlContentHandler * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlSimpleReader_Adaptor *)cls)->cbs_setContentHandler_2441_0 (arg1);
}

static void _set_callback_cbs_setContentHandler_2441_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_setContentHandler_2441_0 = cb;
}


// void QXmlSimpleReader::setDTDHandler(QXmlDTDHandler *handler)

static void _init_cbs_setDTDHandler_1930_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlDTDHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setDTDHandler_1930_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlDTDHandler *arg1 = args.read<QXmlDTDHandler * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlSimpleReader_Adaptor *)cls)->cbs_setDTDHandler_1930_0 (arg1);
}

static void _set_callback_cbs_setDTDHandler_1930_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_setDTDHandler_1930_0 = cb;
}


// void QXmlSimpleReader::setDeclHandler(QXmlDeclHandler *handler)

static void _init_cbs_setDeclHandler_2086_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlDeclHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setDeclHandler_2086_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlDeclHandler *arg1 = args.read<QXmlDeclHandler * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlSimpleReader_Adaptor *)cls)->cbs_setDeclHandler_2086_0 (arg1);
}

static void _set_callback_cbs_setDeclHandler_2086_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_setDeclHandler_2086_0 = cb;
}


// void QXmlSimpleReader::setEntityResolver(QXmlEntityResolver *handler)

static void _init_cbs_setEntityResolver_2495_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlEntityResolver * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setEntityResolver_2495_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlEntityResolver *arg1 = args.read<QXmlEntityResolver * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlSimpleReader_Adaptor *)cls)->cbs_setEntityResolver_2495_0 (arg1);
}

static void _set_callback_cbs_setEntityResolver_2495_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_setEntityResolver_2495_0 = cb;
}


// void QXmlSimpleReader::setErrorHandler(QXmlErrorHandler *handler)

static void _init_cbs_setErrorHandler_2232_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlErrorHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setErrorHandler_2232_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlErrorHandler *arg1 = args.read<QXmlErrorHandler * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlSimpleReader_Adaptor *)cls)->cbs_setErrorHandler_2232_0 (arg1);
}

static void _set_callback_cbs_setErrorHandler_2232_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_setErrorHandler_2232_0 = cb;
}


// void QXmlSimpleReader::setFeature(const QString &name, bool value)

static void _init_cbs_setFeature_2781_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setFeature_2781_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  bool arg2 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlSimpleReader_Adaptor *)cls)->cbs_setFeature_2781_0 (arg1, arg2);
}

static void _set_callback_cbs_setFeature_2781_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_setFeature_2781_0 = cb;
}


// void QXmlSimpleReader::setLexicalHandler(QXmlLexicalHandler *handler)

static void _init_cbs_setLexicalHandler_2416_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlLexicalHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setLexicalHandler_2416_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlLexicalHandler *arg1 = args.read<QXmlLexicalHandler * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlSimpleReader_Adaptor *)cls)->cbs_setLexicalHandler_2416_0 (arg1);
}

static void _set_callback_cbs_setLexicalHandler_2416_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_setLexicalHandler_2416_0 = cb;
}


// void QXmlSimpleReader::setProperty(const QString &name, void *value)

static void _init_cbs_setProperty_2973_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<void * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setProperty_2973_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  void *arg2 = args.read<void * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlSimpleReader_Adaptor *)cls)->cbs_setProperty_2973_0 (arg1, arg2);
}

static void _set_callback_cbs_setProperty_2973_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlSimpleReader_Adaptor *)cls)->cb_setProperty_2973_0 = cb;
}


namespace gsi
{

gsi::Class<QXmlSimpleReader> &qtdecl_QXmlSimpleReader ();

static gsi::Methods methods_QXmlSimpleReader_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QXmlSimpleReader::QXmlSimpleReader()\nThis method creates an object of class QXmlSimpleReader.", &_init_ctor_QXmlSimpleReader_Adaptor_0, &_call_ctor_QXmlSimpleReader_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("DTDHandler", "@hide", true, &_init_cbs_DTDHandler_c0_0, &_call_cbs_DTDHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("DTDHandler", "@brief Virtual method QXmlDTDHandler *QXmlSimpleReader::DTDHandler()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_DTDHandler_c0_0, &_call_cbs_DTDHandler_c0_0, &_set_callback_cbs_DTDHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("contentHandler", "@hide", true, &_init_cbs_contentHandler_c0_0, &_call_cbs_contentHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("contentHandler", "@brief Virtual method QXmlContentHandler *QXmlSimpleReader::contentHandler()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_contentHandler_c0_0, &_call_cbs_contentHandler_c0_0, &_set_callback_cbs_contentHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("declHandler", "@hide", true, &_init_cbs_declHandler_c0_0, &_call_cbs_declHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("declHandler", "@brief Virtual method QXmlDeclHandler *QXmlSimpleReader::declHandler()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_declHandler_c0_0, &_call_cbs_declHandler_c0_0, &_set_callback_cbs_declHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("entityResolver", "@hide", true, &_init_cbs_entityResolver_c0_0, &_call_cbs_entityResolver_c0_0);
  methods += new qt_gsi::GenericMethod ("entityResolver", "@brief Virtual method QXmlEntityResolver *QXmlSimpleReader::entityResolver()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_entityResolver_c0_0, &_call_cbs_entityResolver_c0_0, &_set_callback_cbs_entityResolver_c0_0);
  methods += new qt_gsi::GenericMethod ("errorHandler", "@hide", true, &_init_cbs_errorHandler_c0_0, &_call_cbs_errorHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("errorHandler", "@brief Virtual method QXmlErrorHandler *QXmlSimpleReader::errorHandler()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_errorHandler_c0_0, &_call_cbs_errorHandler_c0_0, &_set_callback_cbs_errorHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("feature", "@hide", true, &_init_cbs_feature_c2967_1, &_call_cbs_feature_c2967_1);
  methods += new qt_gsi::GenericMethod ("feature", "@brief Virtual method bool QXmlSimpleReader::feature(const QString &name, bool *ok)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_feature_c2967_1, &_call_cbs_feature_c2967_1, &_set_callback_cbs_feature_c2967_1);
  methods += new qt_gsi::GenericMethod ("hasFeature", "@hide", true, &_init_cbs_hasFeature_c2025_0, &_call_cbs_hasFeature_c2025_0);
  methods += new qt_gsi::GenericMethod ("hasFeature", "@brief Virtual method bool QXmlSimpleReader::hasFeature(const QString &name)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasFeature_c2025_0, &_call_cbs_hasFeature_c2025_0, &_set_callback_cbs_hasFeature_c2025_0);
  methods += new qt_gsi::GenericMethod ("hasProperty", "@hide", true, &_init_cbs_hasProperty_c2025_0, &_call_cbs_hasProperty_c2025_0);
  methods += new qt_gsi::GenericMethod ("hasProperty", "@brief Virtual method bool QXmlSimpleReader::hasProperty(const QString &name)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasProperty_c2025_0, &_call_cbs_hasProperty_c2025_0, &_set_callback_cbs_hasProperty_c2025_0);
  methods += new qt_gsi::GenericMethod ("lexicalHandler", "@hide", true, &_init_cbs_lexicalHandler_c0_0, &_call_cbs_lexicalHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("lexicalHandler", "@brief Virtual method QXmlLexicalHandler *QXmlSimpleReader::lexicalHandler()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_lexicalHandler_c0_0, &_call_cbs_lexicalHandler_c0_0, &_set_callback_cbs_lexicalHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("parse", "@hide", false, &_init_cbs_parse_2856_0, &_call_cbs_parse_2856_0);
  methods += new qt_gsi::GenericMethod ("parse", "@brief Virtual method bool QXmlSimpleReader::parse(const QXmlInputSource *input)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_parse_2856_0, &_call_cbs_parse_2856_0, &_set_callback_cbs_parse_2856_0);
  methods += new qt_gsi::GenericMethod ("parse", "@hide", false, &_init_cbs_parse_3612_0, &_call_cbs_parse_3612_0);
  methods += new qt_gsi::GenericMethod ("parse", "@brief Virtual method bool QXmlSimpleReader::parse(const QXmlInputSource *input, bool incremental)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_parse_3612_0, &_call_cbs_parse_3612_0, &_set_callback_cbs_parse_3612_0);
  methods += new qt_gsi::GenericMethod ("parseContinue", "@hide", false, &_init_cbs_parseContinue_0_0, &_call_cbs_parseContinue_0_0);
  methods += new qt_gsi::GenericMethod ("parseContinue", "@brief Virtual method bool QXmlSimpleReader::parseContinue()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_parseContinue_0_0, &_call_cbs_parseContinue_0_0, &_set_callback_cbs_parseContinue_0_0);
  methods += new qt_gsi::GenericMethod ("property", "@hide", true, &_init_cbs_property_c2967_1, &_call_cbs_property_c2967_1);
  methods += new qt_gsi::GenericMethod ("property", "@brief Virtual method void *QXmlSimpleReader::property(const QString &name, bool *ok)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_property_c2967_1, &_call_cbs_property_c2967_1, &_set_callback_cbs_property_c2967_1);
  methods += new qt_gsi::GenericMethod ("setContentHandler", "@hide", false, &_init_cbs_setContentHandler_2441_0, &_call_cbs_setContentHandler_2441_0);
  methods += new qt_gsi::GenericMethod ("setContentHandler", "@brief Virtual method void QXmlSimpleReader::setContentHandler(QXmlContentHandler *handler)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setContentHandler_2441_0, &_call_cbs_setContentHandler_2441_0, &_set_callback_cbs_setContentHandler_2441_0);
  methods += new qt_gsi::GenericMethod ("setDTDHandler", "@hide", false, &_init_cbs_setDTDHandler_1930_0, &_call_cbs_setDTDHandler_1930_0);
  methods += new qt_gsi::GenericMethod ("setDTDHandler", "@brief Virtual method void QXmlSimpleReader::setDTDHandler(QXmlDTDHandler *handler)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setDTDHandler_1930_0, &_call_cbs_setDTDHandler_1930_0, &_set_callback_cbs_setDTDHandler_1930_0);
  methods += new qt_gsi::GenericMethod ("setDeclHandler", "@hide", false, &_init_cbs_setDeclHandler_2086_0, &_call_cbs_setDeclHandler_2086_0);
  methods += new qt_gsi::GenericMethod ("setDeclHandler", "@brief Virtual method void QXmlSimpleReader::setDeclHandler(QXmlDeclHandler *handler)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setDeclHandler_2086_0, &_call_cbs_setDeclHandler_2086_0, &_set_callback_cbs_setDeclHandler_2086_0);
  methods += new qt_gsi::GenericMethod ("setEntityResolver", "@hide", false, &_init_cbs_setEntityResolver_2495_0, &_call_cbs_setEntityResolver_2495_0);
  methods += new qt_gsi::GenericMethod ("setEntityResolver", "@brief Virtual method void QXmlSimpleReader::setEntityResolver(QXmlEntityResolver *handler)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setEntityResolver_2495_0, &_call_cbs_setEntityResolver_2495_0, &_set_callback_cbs_setEntityResolver_2495_0);
  methods += new qt_gsi::GenericMethod ("setErrorHandler", "@hide", false, &_init_cbs_setErrorHandler_2232_0, &_call_cbs_setErrorHandler_2232_0);
  methods += new qt_gsi::GenericMethod ("setErrorHandler", "@brief Virtual method void QXmlSimpleReader::setErrorHandler(QXmlErrorHandler *handler)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setErrorHandler_2232_0, &_call_cbs_setErrorHandler_2232_0, &_set_callback_cbs_setErrorHandler_2232_0);
  methods += new qt_gsi::GenericMethod ("setFeature", "@hide", false, &_init_cbs_setFeature_2781_0, &_call_cbs_setFeature_2781_0);
  methods += new qt_gsi::GenericMethod ("setFeature", "@brief Virtual method void QXmlSimpleReader::setFeature(const QString &name, bool value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setFeature_2781_0, &_call_cbs_setFeature_2781_0, &_set_callback_cbs_setFeature_2781_0);
  methods += new qt_gsi::GenericMethod ("setLexicalHandler", "@hide", false, &_init_cbs_setLexicalHandler_2416_0, &_call_cbs_setLexicalHandler_2416_0);
  methods += new qt_gsi::GenericMethod ("setLexicalHandler", "@brief Virtual method void QXmlSimpleReader::setLexicalHandler(QXmlLexicalHandler *handler)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setLexicalHandler_2416_0, &_call_cbs_setLexicalHandler_2416_0, &_set_callback_cbs_setLexicalHandler_2416_0);
  methods += new qt_gsi::GenericMethod ("setProperty", "@hide", false, &_init_cbs_setProperty_2973_0, &_call_cbs_setProperty_2973_0);
  methods += new qt_gsi::GenericMethod ("setProperty", "@brief Virtual method void QXmlSimpleReader::setProperty(const QString &name, void *value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setProperty_2973_0, &_call_cbs_setProperty_2973_0, &_set_callback_cbs_setProperty_2973_0);
  return methods;
}

gsi::Class<QXmlSimpleReader_Adaptor> decl_QXmlSimpleReader_Adaptor (qtdecl_QXmlSimpleReader (), "QtXml", "QXmlSimpleReader",
  methods_QXmlSimpleReader_Adaptor (),
  "@qt\n@brief Binding of QXmlSimpleReader");

}

