/*
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.joni.test;

import org.joni.Option;
import org.joni.Syntax;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF16BEEncoding;

public class TestU extends Test {

    public int option() {
        return Option.DEFAULT;
    }

    public Encoding encoding() {
        return UTF16BEEncoding.INSTANCE;
    }

    public String testEncoding() {
        return "iso-8859-1";
    }

    public Syntax syntax() {
        return Syntax.DEFAULT;
    }

    private int ulen(byte[]bytes) {
        return encoding().strByteLengthNull(bytes, 0, bytes.length);
    }

    private String uconv(byte []bytes, int len) {
        StringBuilder sb = new StringBuilder();

        for (int i = 0; i < len; i += 2) {
            int c = bytes[i] & 0xff;
            // sb.append(String.format("\\%03o", c));
            if (c == 0) {
                c = bytes[i+1] & 0xff;
                if (c < 0x20 || c >= 0x7f || c == 0x5c || c == 0x22) {
                    sb.append(String.format("\\%03o", c));
                } else {
                    sb.append(new String(new byte[]{(byte)c}));
                }
            } else {
                sb.append(String.format("\\%03o", c));
                c = bytes[i+1] & 0xff;
                sb.append(String.format("\\%03o", c));
            }
        }

        return sb.toString();
    }

    protected String repr(byte[]bytes) {
        return uconv(bytes, ulen(bytes));
    }

    protected int length(byte[]bytes) {
        return ulen(bytes);
    }

    public void test() throws InterruptedException {
        x2s("\000\000", "\000\000", 0, 0);
        x2s("\000^\000\000", "\000\000", 0, 0);
        x2s("\000$\000\000", "\000\000", 0, 0);
        x2s("\000\134\000G\000\000", "\000\000", 0, 0);
        x2s("\000\134\000A\000\000", "\000\000", 0, 0);
        x2s("\000\134\000Z\000\000", "\000\000", 0, 0);
        x2s("\000\134\000z\000\000", "\000\000", 0, 0);
        x2s("\000^\000$\000\000", "\000\000", 0, 0);
        x2s("\000\134\000c\000a\000\000", "\000\001\000\000", 0, 2);
        x2s("\000\134\000C\000-\000b\000\000", "\000\002\000\000", 0, 2);
        x2s("\000\134\000c\000\134\000\134\000\000", "\000\034\000\000", 0, 2);
        x2s("\000q\000[\000\134\000c\000\134\000\134\000]\000\000", "\000q\000\034\000\000", 0, 4);
        x2s("\000\000", "\000a\000\000", 0, 0);
        x2s("\000a\000\000", "\000a\000\000", 0, 2);
        x2s("\000\134\000x\0000\0000\000\134\000x\0006\0001\000\000", "\000a\000\000", 0, 2);
        x2s("\000a\000a\000\000", "\000a\000a\000\000", 0, 4);
        x2s("\000a\000a\000a\000\000", "\000a\000a\000a\000\000", 0, 6);
        x2s("\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000\000", "\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000a\000\000", 0, 70);
        x2s("\000a\000b\000\000", "\000a\000b\000\000", 0, 4);
        x2s("\000b\000\000", "\000a\000b\000\000", 2, 4);
        x2s("\000b\000c\000\000", "\000a\000b\000c\000\000", 2, 6);
        x2s("\000(\000?\000i\000:\000#\000R\000E\000T\000#\000)\000\000", "\000#\000I\000N\000S\000#\000#\000R\000E\000T\000#\000\000", 10, 20);
        x2s("\000\134\0000\0000\0000\000\134\0001\0007\000\000", "\000\017\000\000", 0, 2);
        x2s("\000\134\000x\0000\0000\000\134\000x\0001\000f\000\000", "\000\037\000\000", 0, 2);
        x2s("\000a\000(\000?\000#\000.\000.\000.\000.\000\134\000\134\000J\000J\000J\000J\000)\000b\000\000", "\000a\000b\000\000", 0, 4);
        x2s("\000(\000?\000x\000)\000 \000 \000G\000 \000(\000o\000 \000O\000(\000?\000-\000x\000)\000o\000O\000)\000 \000g\000 \000L\000\000", "\000G\000o\000O\000o\000O\000g\000L\000e\000\000", 0, 14);
        x2s("\000.\000\000", "\000a\000\000", 0, 2);
        ns("\000.\000\000", "\000\000");
        x2s("\000.\000.\000\000", "\000a\000b\000\000", 0, 4);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000\134\000w\000\000", "\000e\000\000", 0, 2);
        if (!org.joni.Config.NON_UNICODE_SDW) ns("\000\134\000W\000\000", "\000e\000\000");
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000\134\000s\000\000", "\000 \000\000", 0, 2);
        x2s("\000\134\000S\000\000", "\000b\000\000", 0, 2);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000\134\000d\000\000", "\0004\000\000", 0, 2);
        if (!org.joni.Config.NON_UNICODE_SDW) ns("\000\134\000D\000\000", "\0004\000\000");
        x2s("\000\134\000b\000\000", "\000z\000 \000\000", 0, 0);
        x2s("\000\134\000b\000\000", "\000 \000z\000\000", 2, 2);
        x2s("\000\134\000B\000\000", "\000z\000z\000 \000\000", 2, 2);
        x2s("\000\134\000B\000\000", "\000z\000 \000\000", 4, 4);
        x2s("\000\134\000B\000\000", "\000 \000z\000\000", 0, 0);
        x2s("\000[\000a\000b\000]\000\000", "\000b\000\000", 0, 2);
        ns("\000[\000a\000b\000]\000\000", "\000c\000\000");
        x2s("\000[\000a\000-\000z\000]\000\000", "\000t\000\000", 0, 2);
        ns("\000[\000^\000a\000]\000\000", "\000a\000\000");
        x2s("\000[\000^\000a\000]\000\000", "\000\012\000\000", 0, 2);
        x2s("\000[\000]\000]\000\000", "\000]\000\000", 0, 2);
        ns("\000[\000^\000]\000]\000\000", "\000]\000\000");
        x2s("\000[\000\134\000^\000]\000+\000\000", "\0000\000^\000^\0001\000\000", 2, 6);
        x2s("\000[\000b\000-\000]\000\000", "\000b\000\000", 0, 2);
        x2s("\000[\000b\000-\000]\000\000", "\000-\000\000", 0, 2);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000[\000\134\000w\000]\000\000", "\000z\000\000", 0, 2);
        ns("\000[\000\134\000w\000]\000\000", "\000 \000\000");
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000[\000\134\000W\000]\000\000", "\000b\000$\000\000", 2, 4);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000[\000\134\000d\000]\000\000", "\0005\000\000", 0, 2);
        ns("\000[\000\134\000d\000]\000\000", "\000e\000\000");
        x2s("\000[\000\134\000D\000]\000\000", "\000t\000\000", 0, 2);
        if (!org.joni.Config.NON_UNICODE_SDW) ns("\000[\000\134\000D\000]\000\000", "\0003\000\000");
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000[\000\134\000s\000]\000\000", "\000 \000\000", 0, 2);
        ns("\000[\000\134\000s\000]\000\000", "\000a\000\000");
        x2s("\000[\000\134\000S\000]\000\000", "\000b\000\000", 0, 2);
        if (!org.joni.Config.NON_UNICODE_SDW) ns("\000[\000\134\000S\000]\000\000", "\000 \000\000");
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000[\000\134\000w\000\134\000d\000]\000\000", "\0002\000\000", 0, 2);
        ns("\000[\000\134\000w\000\134\000d\000]\000\000", "\000 \000\000");
        x2s("\000[\000[\000:\000u\000p\000p\000e\000r\000:\000]\000]\000\000", "\000B\000\000", 0, 2);
        x2s("\000[\000*\000[\000:\000x\000d\000i\000g\000i\000t\000:\000]\000+\000]\000\000", "\000+\000\000", 0, 2);
        x2s("\000[\000*\000[\000:\000x\000d\000i\000g\000i\000t\000:\000]\000+\000]\000\000", "\000G\000H\000I\000K\000K\000-\0009\000+\000*\000\000", 12, 14);
        x2s("\000[\000*\000[\000:\000x\000d\000i\000g\000i\000t\000:\000]\000+\000]\000\000", "\000-\000@\000^\000+\000\000", 6, 8);
        ns("\000[\000[\000:\000u\000p\000p\000e\000r\000]\000]\000\000", "\000A\000\000");
        x2s("\000[\000[\000:\000u\000p\000p\000e\000r\000]\000]\000\000", "\000:\000\000", 0, 2);
        x2s("\000[\000\134\0000\0000\0000\000\134\0000\0004\0004\000-\000\134\0000\0000\0000\000\134\0000\0004\0007\000]\000\000", "\000&\000\000", 0, 2);
        x2s("\000[\000\134\000x\0000\0000\000\134\000x\0005\000a\000-\000\134\000x\0000\0000\000\134\000x\0005\000c\000]\000\000", "\000[\000\000", 0, 2);
        x2s("\000[\000\134\000x\0000\0000\000\134\000x\0006\000A\000-\000\134\000x\0000\0000\000\134\000x\0006\000D\000]\000\000", "\000l\000\000", 0, 2);
        ns("\000[\000\134\000x\0000\0000\000\134\000x\0006\000A\000-\000\134\000x\0000\0000\000\134\000x\0006\000D\000]\000\000", "\000n\000\000");
        ns("\000^\000[\0000\000-\0009\000A\000-\000F\000]\000+\000 \0000\000+\000 \000U\000N\000D\000E\000F\000 \000\000", "\0007\0005\000F\000 \0000\0000\0000\0000\0000\0000\0000\0000\000 \000S\000E\000C\000T\0001\0004\000A\000 \000n\000o\000t\000y\000p\000e\000 \000(\000)\000 \000 \000 \000 \000E\000x\000t\000e\000r\000n\000a\000l\000 \000 \000 \000 \000|\000 \000_\000r\000b\000_\000a\000p\000p\000l\000y\000\000");
        x2s("\000[\000\134\000[\000]\000\000", "\000[\000\000", 0, 2);
        x2s("\000[\000\134\000]\000]\000\000", "\000]\000\000", 0, 2);
        x2s("\000[\000&\000]\000\000", "\000&\000\000", 0, 2);
        x2s("\000[\000[\000a\000b\000]\000]\000\000", "\000b\000\000", 0, 2);
        x2s("\000[\000[\000a\000b\000]\000c\000]\000\000", "\000c\000\000", 0, 2);
        ns("\000[\000[\000^\000a\000]\000]\000\000", "\000a\000\000");
        ns("\000[\000^\000[\000a\000]\000]\000\000", "\000a\000\000");
        x2s("\000[\000[\000a\000b\000]\000&\000&\000b\000c\000]\000\000", "\000b\000\000", 0, 2);
        ns("\000[\000[\000a\000b\000]\000&\000&\000b\000c\000]\000\000", "\000a\000\000");
        ns("\000[\000[\000a\000b\000]\000&\000&\000b\000c\000]\000\000", "\000c\000\000");
        x2s("\000[\000a\000-\000z\000&\000&\000b\000-\000y\000&\000&\000c\000-\000x\000]\000\000", "\000w\000\000", 0, 2);
        ns("\000[\000^\000a\000-\000z\000&\000&\000b\000-\000y\000&\000&\000c\000-\000x\000]\000\000", "\000w\000\000");
        x2s("\000[\000[\000^\000a\000&\000&\000a\000]\000&\000&\000a\000-\000z\000]\000\000", "\000b\000\000", 0, 2);
        ns("\000[\000[\000^\000a\000&\000&\000a\000]\000&\000&\000a\000-\000z\000]\000\000", "\000a\000\000");
        x2s("\000[\000[\000^\000a\000-\000z\000&\000&\000b\000c\000d\000e\000f\000]\000&\000&\000[\000^\000c\000-\000g\000]\000]\000\000", "\000h\000\000", 0, 2);
        ns("\000[\000[\000^\000a\000-\000z\000&\000&\000b\000c\000d\000e\000f\000]\000&\000&\000[\000^\000c\000-\000g\000]\000]\000\000", "\000c\000\000");
        x2s("\000[\000^\000[\000^\000a\000b\000c\000]\000&\000&\000[\000^\000c\000d\000e\000]\000]\000\000", "\000c\000\000", 0, 2);
        x2s("\000[\000^\000[\000^\000a\000b\000c\000]\000&\000&\000[\000^\000c\000d\000e\000]\000]\000\000", "\000e\000\000", 0, 2);
        ns("\000[\000^\000[\000^\000a\000b\000c\000]\000&\000&\000[\000^\000c\000d\000e\000]\000]\000\000", "\000f\000\000");
        x2s("\000[\000a\000-\000&\000&\000-\000a\000]\000\000", "\000-\000\000", 0, 2);
        ns("\000[\000a\000\134\000-\000&\000&\000\134\000-\000a\000]\000\000", "\000&\000\000");
        ns("\000\134\000w\000a\000b\000c\000\000", "\000 \000a\000b\000c\000\000");
        x2s("\000a\000\134\000W\000b\000c\000\000", "\000a\000 \000b\000c\000\000", 0, 8);
        x2s("\000a\000.\000b\000.\000c\000\000", "\000a\000a\000b\000b\000c\000\000", 0, 10);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000.\000\134\000w\000b\000\134\000W\000.\000.\000c\000\000", "\000a\000b\000b\000 \000b\000c\000c\000\000", 0, 14);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000\134\000s\000\134\000w\000z\000z\000z\000\000", "\000 \000z\000z\000z\000z\000\000", 0, 10);
        x2s("\000a\000a\000.\000b\000\000", "\000a\000a\000b\000b\000\000", 0, 8);
        ns("\000.\000a\000\000", "\000a\000b\000\000");
        x2s("\000.\000a\000\000", "\000a\000a\000\000", 0, 4);
        x2s("\000^\000a\000\000", "\000a\000\000", 0, 2);
        x2s("\000^\000a\000$\000\000", "\000a\000\000", 0, 2);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000^\000\134\000w\000$\000\000", "\000a\000\000", 0, 2);
        ns("\000^\000\134\000w\000$\000\000", "\000 \000\000");
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000^\000\134\000w\000a\000b\000$\000\000", "\000z\000a\000b\000\000", 0, 6);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000^\000\134\000w\000a\000b\000c\000d\000e\000f\000$\000\000", "\000z\000a\000b\000c\000d\000e\000f\000\000", 0, 14);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000^\000\134\000w\000.\000.\000.\000d\000e\000f\000$\000\000", "\000z\000a\000b\000c\000d\000e\000f\000\000", 0, 14);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000\134\000w\000\134\000w\000\134\000s\000\134\000W\000a\000a\000a\000\134\000d\000\000", "\000a\000a\000 \000 \000a\000a\000a\0004\000\000", 0, 16);
        x2s("\000\134\000A\000\134\000Z\000\000", "\000\000", 0, 0);
        x2s("\000\134\000A\000x\000y\000z\000\000", "\000x\000y\000z\000\000", 0, 6);
        x2s("\000x\000y\000z\000\134\000Z\000\000", "\000x\000y\000z\000\000", 0, 6);
        x2s("\000x\000y\000z\000\134\000z\000\000", "\000x\000y\000z\000\000", 0, 6);
        x2s("\000a\000\134\000Z\000\000", "\000a\000\000", 0, 2);
        x2s("\000\134\000G\000a\000z\000\000", "\000a\000z\000\000", 0, 4);
        ns("\000\134\000G\000z\000\000", "\000b\000z\000a\000\000");
        ns("\000a\000z\000\134\000G\000\000", "\000a\000z\000\000");
        ns("\000a\000z\000\134\000A\000\000", "\000a\000z\000\000");
        ns("\000a\000\134\000A\000z\000\000", "\000a\000z\000\000");
        x2s("\000\134\000^\000\134\000$\000\000", "\000^\000$\000\000", 0, 4);
        x2s("\000^\000x\000?\000y\000\000", "\000x\000y\000\000", 0, 4);
        x2s("\000^\000(\000x\000?\000y\000)\000\000", "\000x\000y\000\000", 0, 4);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000\134\000w\000\000", "\000_\000\000", 0, 2);
        if (!org.joni.Config.NON_UNICODE_SDW) ns("\000\134\000W\000\000", "\000_\000\000");
        x2s("\000(\000?\000=\000z\000)\000z\000\000", "\000z\000\000", 0, 2);
        ns("\000(\000?\000=\000z\000)\000.\000\000", "\000a\000\000");
        x2s("\000(\000?\000!\000z\000)\000a\000\000", "\000a\000\000", 0, 2);
        ns("\000(\000?\000!\000z\000)\000a\000\000", "\000z\000\000");
        x2s("\000(\000?\000i\000:\000a\000)\000\000", "\000a\000\000", 0, 2);
        x2s("\000(\000?\000i\000:\000a\000)\000\000", "\000A\000\000", 0, 2);
        x2s("\000(\000?\000i\000:\000A\000)\000\000", "\000a\000\000", 0, 2);
        ns("\000(\000?\000i\000:\000A\000)\000\000", "\000b\000\000");
        x2s("\000(\000?\000i\000:\000[\000A\000-\000Z\000]\000)\000\000", "\000a\000\000", 0, 2);
        x2s("\000(\000?\000i\000:\000[\000f\000-\000m\000]\000)\000\000", "\000H\000\000", 0, 2);
        x2s("\000(\000?\000i\000:\000[\000f\000-\000m\000]\000)\000\000", "\000h\000\000", 0, 2);
        ns("\000(\000?\000i\000:\000[\000f\000-\000m\000]\000)\000\000", "\000e\000\000");
        x2s("\000(\000?\000i\000:\000[\000A\000-\000c\000]\000)\000\000", "\000D\000\000", 0, 2);
        ns("\000(\000?\000i\000:\000[\000^\000a\000-\000z\000]\000)\000\000", "\000A\000\000");
        ns("\000(\000?\000i\000:\000[\000^\000a\000-\000z\000]\000)\000\000", "\000a\000\000");
        x2s("\000(\000?\000i\000:\000[\000!\000-\000k\000]\000)\000\000", "\000Z\000\000", 0, 2);
        x2s("\000(\000?\000i\000:\000[\000!\000-\000k\000]\000)\000\000", "\0007\000\000", 0, 2);
        x2s("\000(\000?\000i\000:\000[\000T\000-\000}\000]\000)\000\000", "\000b\000\000", 0, 2);
        x2s("\000(\000?\000i\000:\000[\000T\000-\000}\000]\000)\000\000", "\000{\000\000", 0, 2);
        x2s("\000(\000?\000i\000:\000\134\000?\000a\000)\000\000", "\000?\000A\000\000", 0, 4);
        x2s("\000(\000?\000i\000:\000\134\000*\000A\000)\000\000", "\000*\000a\000\000", 0, 4);
        ns("\000.\000\000", "\000\012\000\000");
        x2s("\000(\000?\000m\000:\000.\000)\000\000", "\000\012\000\000", 0, 2);
        x2s("\000(\000?\000m\000:\000a\000.\000)\000\000", "\000a\000\012\000\000", 0, 4);
        x2s("\000(\000?\000m\000:\000.\000b\000)\000\000", "\000a\000\012\000b\000\000", 2, 6);
        x2s("\000.\000*\000a\000b\000c\000\000", "\000d\000d\000d\000a\000b\000d\000d\000\012\000d\000d\000a\000b\000c\000\000", 16, 26);
        x2s("\000(\000?\000m\000:\000.\000*\000a\000b\000c\000)\000\000", "\000d\000d\000d\000a\000b\000d\000d\000a\000b\000c\000\000", 0, 20);
        ns("\000(\000?\000i\000)\000(\000?\000-\000i\000)\000a\000\000", "\000A\000\000");
        ns("\000(\000?\000i\000)\000(\000?\000-\000i\000:\000a\000)\000\000", "\000A\000\000");
        x2s("\000a\000?\000\000", "\000\000", 0, 0);
        x2s("\000a\000?\000\000", "\000b\000\000", 0, 0);
        x2s("\000a\000?\000\000", "\000a\000\000", 0, 2);
        x2s("\000a\000*\000\000", "\000\000", 0, 0);
        x2s("\000a\000*\000\000", "\000a\000\000", 0, 2);
        x2s("\000a\000*\000\000", "\000a\000a\000a\000\000", 0, 6);
        x2s("\000a\000*\000\000", "\000b\000a\000a\000a\000a\000\000", 0, 0);
        ns("\000a\000+\000\000", "\000\000");
        x2s("\000a\000+\000\000", "\000a\000\000", 0, 2);
        x2s("\000a\000+\000\000", "\000a\000a\000a\000a\000\000", 0, 8);
        x2s("\000a\000+\000\000", "\000a\000a\000b\000b\000b\000\000", 0, 4);
        x2s("\000a\000+\000\000", "\000b\000a\000a\000a\000a\000\000", 2, 10);
        x2s("\000.\000?\000\000", "\000\000", 0, 0);
        x2s("\000.\000?\000\000", "\000f\000\000", 0, 2);
        x2s("\000.\000?\000\000", "\000\012\000\000", 0, 0);
        x2s("\000.\000*\000\000", "\000\000", 0, 0);
        x2s("\000.\000*\000\000", "\000a\000b\000c\000d\000e\000\000", 0, 10);
        x2s("\000.\000+\000\000", "\000z\000\000", 0, 2);
        x2s("\000.\000+\000\000", "\000z\000d\000s\000w\000e\000r\000\012\000\000", 0, 12);
        x2s("\000(\000.\000*\000)\000a\000\134\0001\000f\000\000", "\000b\000a\000b\000f\000b\000a\000c\000\000", 0, 8);
        x2s("\000(\000.\000*\000)\000a\000\134\0001\000f\000\000", "\000b\000a\000c\000b\000a\000b\000f\000\000", 6, 14);
        x2s("\000(\000(\000.\000*\000)\000a\000\134\0002\000f\000)\000\000", "\000b\000a\000c\000b\000a\000b\000f\000\000", 6, 14);
        x2s("\000(\000.\000*\000)\000a\000\134\0001\000f\000\000", "\000b\000a\000c\000z\000z\000z\000z\000z\000z\000\012\000b\000a\000z\000z\000\012\000z\000z\000z\000z\000b\000a\000b\000f\000\000", 38, 46);
        x2s("\000a\000|\000b\000\000", "\000a\000\000", 0, 2);
        x2s("\000a\000|\000b\000\000", "\000b\000\000", 0, 2);
        x2s("\000|\000a\000\000", "\000a\000\000", 0, 0);
        x2s("\000(\000|\000a\000)\000\000", "\000a\000\000", 0, 0);
        x2s("\000a\000b\000|\000b\000c\000\000", "\000a\000b\000\000", 0, 4);
        x2s("\000a\000b\000|\000b\000c\000\000", "\000b\000c\000\000", 0, 4);
        x2s("\000z\000(\000?\000:\000a\000b\000|\000b\000c\000)\000\000", "\000z\000b\000c\000\000", 0, 6);
        x2s("\000a\000(\000?\000:\000a\000b\000|\000b\000c\000)\000c\000\000", "\000a\000a\000b\000c\000\000", 0, 8);
        x2s("\000a\000b\000|\000(\000?\000:\000a\000c\000|\000a\000z\000)\000\000", "\000a\000z\000\000", 0, 4);
        x2s("\000a\000|\000b\000|\000c\000\000", "\000d\000c\000\000", 2, 4);
        x2s("\000a\000|\000b\000|\000c\000d\000|\000e\000f\000g\000|\000h\000|\000i\000j\000k\000|\000l\000m\000n\000|\000o\000|\000p\000q\000|\000r\000s\000t\000u\000v\000w\000x\000|\000y\000z\000\000", "\000p\000q\000r\000\000", 0, 4);
        ns("\000a\000|\000b\000|\000c\000d\000|\000e\000f\000g\000|\000h\000|\000i\000j\000k\000|\000l\000m\000n\000|\000o\000|\000p\000q\000|\000r\000s\000t\000u\000v\000w\000x\000|\000y\000z\000\000", "\000m\000n\000\000");
        x2s("\000a\000|\000^\000z\000\000", "\000b\000a\000\000", 2, 4);
        x2s("\000a\000|\000^\000z\000\000", "\000z\000a\000\000", 0, 2);
        x2s("\000a\000|\000\134\000G\000z\000\000", "\000b\000z\000a\000\000", 4, 6);
        x2s("\000a\000|\000\134\000G\000z\000\000", "\000z\000a\000\000", 0, 2);
        x2s("\000a\000|\000\134\000A\000z\000\000", "\000b\000z\000a\000\000", 4, 6);
        x2s("\000a\000|\000\134\000A\000z\000\000", "\000z\000a\000\000", 0, 2);
        x2s("\000a\000|\000b\000\134\000Z\000\000", "\000b\000a\000\000", 2, 4);
        x2s("\000a\000|\000b\000\134\000Z\000\000", "\000b\000\000", 0, 2);
        x2s("\000a\000|\000b\000\134\000z\000\000", "\000b\000a\000\000", 2, 4);
        x2s("\000a\000|\000b\000\134\000z\000\000", "\000b\000\000", 0, 2);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000\134\000w\000|\000\134\000s\000\000", "\000 \000\000", 0, 2);
        ns("\000\134\000w\000|\000\134\000w\000\000", "\000 \000\000");
        x2s("\000\134\000w\000|\000%\000\000", "\000%\000\000", 0, 2);
        x2s("\000\134\000w\000|\000[\000&\000$\000]\000\000", "\000&\000\000", 0, 2);
        x2s("\000[\000b\000-\000d\000]\000|\000[\000^\000e\000-\000z\000]\000\000", "\000a\000\000", 0, 2);
        x2s("\000(\000?\000:\000a\000|\000[\000c\000-\000f\000]\000)\000|\000b\000z\000\000", "\000d\000z\000\000", 0, 2);
        x2s("\000(\000?\000:\000a\000|\000[\000c\000-\000f\000]\000)\000|\000b\000z\000\000", "\000b\000z\000\000", 0, 4);
        x2s("\000a\000b\000c\000|\000(\000?\000=\000z\000z\000)\000.\000.\000f\000\000", "\000z\000z\000f\000\000", 0, 6);
        x2s("\000a\000b\000c\000|\000(\000?\000!\000z\000z\000)\000.\000.\000f\000\000", "\000a\000b\000f\000\000", 0, 6);
        x2s("\000(\000?\000=\000z\000a\000)\000.\000.\000a\000|\000(\000?\000=\000z\000z\000)\000.\000.\000a\000\000", "\000z\000z\000a\000\000", 0, 6);
        ns("\000(\000?\000>\000a\000|\000a\000b\000d\000)\000c\000\000", "\000a\000b\000d\000c\000\000");
        x2s("\000(\000?\000>\000a\000b\000d\000|\000a\000)\000c\000\000", "\000a\000b\000d\000c\000\000", 0, 8);
        x2s("\000a\000?\000|\000b\000\000", "\000a\000\000", 0, 2);
        x2s("\000a\000?\000|\000b\000\000", "\000b\000\000", 0, 0);
        x2s("\000a\000?\000|\000b\000\000", "\000\000", 0, 0);
        x2s("\000a\000*\000|\000b\000\000", "\000a\000a\000\000", 0, 4);
        x2s("\000a\000*\000|\000b\000*\000\000", "\000b\000a\000\000", 0, 0);
        x2s("\000a\000*\000|\000b\000*\000\000", "\000a\000b\000\000", 0, 2);
        x2s("\000a\000+\000|\000b\000*\000\000", "\000\000", 0, 0);
        x2s("\000a\000+\000|\000b\000*\000\000", "\000b\000b\000b\000\000", 0, 6);
        x2s("\000a\000+\000|\000b\000*\000\000", "\000a\000b\000b\000b\000\000", 0, 2);
        ns("\000a\000+\000|\000b\000+\000\000", "\000\000");
        x2s("\000(\000a\000|\000b\000)\000?\000\000", "\000b\000\000", 0, 2);
        x2s("\000(\000a\000|\000b\000)\000*\000\000", "\000b\000a\000\000", 0, 4);
        x2s("\000(\000a\000|\000b\000)\000+\000\000", "\000b\000a\000b\000\000", 0, 6);
        x2s("\000(\000a\000b\000|\000c\000a\000)\000+\000\000", "\000c\000a\000a\000b\000b\000c\000\000", 0, 8);
        x2s("\000(\000a\000b\000|\000c\000a\000)\000+\000\000", "\000a\000a\000b\000c\000a\000\000", 2, 10);
        x2s("\000(\000a\000b\000|\000c\000a\000)\000+\000\000", "\000a\000b\000z\000c\000a\000\000", 0, 4);
        x2s("\000(\000a\000|\000b\000a\000b\000)\000+\000\000", "\000a\000b\000a\000b\000a\000\000", 0, 10);
        x2s("\000(\000a\000|\000b\000a\000b\000)\000+\000\000", "\000b\000a\000\000", 2, 4);
        x2s("\000(\000a\000|\000b\000a\000b\000)\000+\000\000", "\000b\000a\000a\000a\000b\000a\000\000", 2, 8);
        x2s("\000(\000?\000:\000a\000|\000b\000)\000(\000?\000:\000a\000|\000b\000)\000\000", "\000a\000b\000\000", 0, 4);
        x2s("\000(\000?\000:\000a\000*\000|\000b\000*\000)\000(\000?\000:\000a\000*\000|\000b\000*\000)\000\000", "\000a\000a\000a\000b\000b\000b\000\000", 0, 6);
        x2s("\000(\000?\000:\000a\000*\000|\000b\000*\000)\000(\000?\000:\000a\000+\000|\000b\000+\000)\000\000", "\000a\000a\000a\000b\000b\000b\000\000", 0, 12);
        x2s("\000(\000?\000:\000a\000+\000|\000b\000+\000)\000{\0002\000}\000\000", "\000a\000a\000a\000b\000b\000b\000\000", 0, 12);
        x2s("\000h\000{\0000\000,\000}\000\000", "\000h\000h\000h\000h\000\000", 0, 8);
        x2s("\000(\000?\000:\000a\000+\000|\000b\000+\000)\000{\0001\000,\0002\000}\000\000", "\000a\000a\000a\000b\000b\000b\000\000", 0, 12);
        ns("\000a\000x\000{\0002\000}\000*\000a\000\000", "\0000\000a\000x\000x\000x\000a\0001\000\000");
        ns("\000a\000.\000{\0000\000,\0002\000}\000a\000\000", "\0000\000a\000X\000X\000X\000a\0000\000\000");
        ns("\000a\000.\000{\0000\000,\0002\000}\000?\000a\000\000", "\0000\000a\000X\000X\000X\000a\0000\000\000");
        ns("\000a\000.\000{\0000\000,\0002\000}\000?\000a\000\000", "\0000\000a\000X\000X\000X\000X\000a\0000\000\000");
        x2s("\000^\000a\000{\0002\000,\000}\000?\000a\000$\000\000", "\000a\000a\000a\000\000", 0, 6);
        x2s("\000^\000[\000a\000-\000z\000]\000{\0002\000,\000}\000?\000$\000\000", "\000a\000a\000a\000\000", 0, 6);
        x2s("\000(\000?\000:\000a\000+\000|\000\134\000A\000b\000*\000)\000c\000c\000\000", "\000c\000c\000\000", 0, 4);
        ns("\000(\000?\000:\000a\000+\000|\000\134\000A\000b\000*\000)\000c\000c\000\000", "\000a\000b\000c\000c\000\000");
        x2s("\000(\000?\000:\000^\000a\000+\000|\000b\000+\000)\000*\000c\000\000", "\000a\000a\000b\000b\000b\000a\000b\000c\000\000", 12, 16);
        x2s("\000(\000?\000:\000^\000a\000+\000|\000b\000+\000)\000*\000c\000\000", "\000a\000a\000b\000b\000b\000b\000c\000\000", 0, 14);
        x2s("\000a\000|\000(\000?\000i\000)\000c\000\000", "\000C\000\000", 0, 2);
        x2s("\000(\000?\000i\000)\000c\000|\000a\000\000", "\000C\000\000", 0, 2);
        x2s("\000(\000?\000i\000)\000c\000|\000a\000\000", "\000A\000\000", 0, 2);
        x2s("\000(\000?\000i\000:\000c\000)\000|\000a\000\000", "\000C\000\000", 0, 2);
        ns("\000(\000?\000i\000:\000c\000)\000|\000a\000\000", "\000A\000\000");
        x2s("\000[\000a\000b\000c\000]\000?\000\000", "\000a\000b\000c\000\000", 0, 2);
        x2s("\000[\000a\000b\000c\000]\000*\000\000", "\000a\000b\000c\000\000", 0, 6);
        x2s("\000[\000^\000a\000b\000c\000]\000*\000\000", "\000a\000b\000c\000\000", 0, 0);
        ns("\000[\000^\000a\000b\000c\000]\000+\000\000", "\000a\000b\000c\000\000");
        x2s("\000a\000?\000?\000\000", "\000a\000a\000a\000\000", 0, 0);
        x2s("\000b\000a\000?\000?\000b\000\000", "\000b\000a\000b\000\000", 0, 6);
        x2s("\000a\000*\000?\000\000", "\000a\000a\000a\000\000", 0, 0);
        x2s("\000b\000a\000*\000?\000\000", "\000b\000a\000a\000\000", 0, 2);
        x2s("\000b\000a\000*\000?\000b\000\000", "\000b\000a\000a\000b\000\000", 0, 8);
        x2s("\000a\000+\000?\000\000", "\000a\000a\000a\000\000", 0, 2);
        x2s("\000b\000a\000+\000?\000\000", "\000b\000a\000a\000\000", 0, 4);
        x2s("\000b\000a\000+\000?\000b\000\000", "\000b\000a\000a\000b\000\000", 0, 8);
        x2s("\000(\000?\000:\000a\000?\000)\000?\000?\000\000", "\000a\000\000", 0, 0);
        x2s("\000(\000?\000:\000a\000?\000?\000)\000?\000\000", "\000a\000\000", 0, 0);
        x2s("\000(\000?\000:\000a\000?\000)\000+\000?\000\000", "\000a\000a\000a\000\000", 0, 2);
        x2s("\000(\000?\000:\000a\000+\000)\000?\000?\000\000", "\000a\000a\000a\000\000", 0, 0);
        x2s("\000(\000?\000:\000a\000+\000)\000?\000?\000b\000\000", "\000a\000a\000a\000b\000\000", 0, 8);
        x2s("\000(\000?\000:\000a\000b\000)\000?\000{\0002\000}\000\000", "\000\000", 0, 0);
        x2s("\000(\000?\000:\000a\000b\000)\000?\000{\0002\000}\000\000", "\000a\000b\000a\000b\000a\000\000", 0, 8);
        x2s("\000(\000?\000:\000a\000b\000)\000*\000{\0000\000}\000\000", "\000a\000b\000a\000b\000a\000\000", 0, 0);
        x2s("\000(\000?\000:\000a\000b\000)\000{\0003\000,\000}\000\000", "\000a\000b\000a\000b\000a\000b\000a\000b\000\000", 0, 16);
        ns("\000(\000?\000:\000a\000b\000)\000{\0003\000,\000}\000\000", "\000a\000b\000a\000b\000\000");
        x2s("\000(\000?\000:\000a\000b\000)\000{\0002\000,\0004\000}\000\000", "\000a\000b\000a\000b\000a\000b\000\000", 0, 12);
        x2s("\000(\000?\000:\000a\000b\000)\000{\0002\000,\0004\000}\000\000", "\000a\000b\000a\000b\000a\000b\000a\000b\000a\000b\000\000", 0, 16);
        x2s("\000(\000?\000:\000a\000b\000)\000{\0002\000,\0004\000}\000?\000\000", "\000a\000b\000a\000b\000a\000b\000a\000b\000a\000b\000\000", 0, 8);
        x2s("\000(\000?\000:\000a\000b\000)\000{\000,\000}\000\000", "\000a\000b\000{\000,\000}\000\000", 0, 10);
        x2s("\000(\000?\000:\000a\000b\000c\000)\000+\000?\000{\0002\000}\000\000", "\000a\000b\000c\000a\000b\000c\000a\000b\000c\000\000", 0, 12);
        x2s("\000(\000?\000:\000X\000*\000)\000(\000?\000i\000:\000x\000a\000)\000\000", "\000X\000X\000X\000a\000\000", 0, 8);
        x2s("\000(\000d\000+\000)\000(\000[\000^\000a\000b\000c\000]\000z\000)\000\000", "\000d\000d\000d\000z\000\000", 0, 8);
        x2s("\000(\000[\000^\000a\000b\000c\000]\000*\000)\000(\000[\000^\000a\000b\000c\000]\000z\000)\000\000", "\000d\000d\000d\000z\000\000", 0, 8);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000(\000\134\000w\000+\000)\000(\000\134\000w\000z\000)\000\000", "\000d\000d\000d\000z\000\000", 0, 8);
        x3s("\000(\000a\000)\000\000", "\000a\000\000", 0, 2, 1);
        x3s("\000(\000a\000b\000)\000\000", "\000a\000b\000\000", 0, 4, 1);
        x2s("\000(\000(\000a\000b\000)\000)\000\000", "\000a\000b\000\000", 0, 4);
        x3s("\000(\000(\000a\000b\000)\000)\000\000", "\000a\000b\000\000", 0, 4, 1);
        x3s("\000(\000(\000a\000b\000)\000)\000\000", "\000a\000b\000\000", 0, 4, 2);
        x3s("\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000a\000b\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000\000", "\000a\000b\000\000", 0, 4, 20);
        x3s("\000(\000a\000b\000)\000(\000c\000d\000)\000\000", "\000a\000b\000c\000d\000\000", 0, 4, 1);
        x3s("\000(\000a\000b\000)\000(\000c\000d\000)\000\000", "\000a\000b\000c\000d\000\000", 4, 8, 2);
        x3s("\000(\000)\000(\000a\000)\000b\000c\000(\000d\000e\000f\000)\000g\000h\000i\000j\000k\000\000", "\000a\000b\000c\000d\000e\000f\000g\000h\000i\000j\000k\000\000", 6, 12, 3);
        x3s("\000(\000(\000)\000(\000a\000)\000b\000c\000(\000d\000e\000f\000)\000g\000h\000i\000j\000k\000)\000\000", "\000a\000b\000c\000d\000e\000f\000g\000h\000i\000j\000k\000\000", 6, 12, 4);
        x2s("\000(\000^\000a\000)\000\000", "\000a\000\000", 0, 2);
        x3s("\000(\000a\000)\000|\000(\000a\000)\000\000", "\000b\000a\000\000", 2, 4, 1);
        x3s("\000(\000^\000a\000)\000|\000(\000a\000)\000\000", "\000b\000a\000\000", 2, 4, 2);
        x3s("\000(\000a\000?\000)\000\000", "\000a\000a\000a\000\000", 0, 2, 1);
        x3s("\000(\000a\000*\000)\000\000", "\000a\000a\000a\000\000", 0, 6, 1);
        x3s("\000(\000a\000*\000)\000\000", "\000\000", 0, 0, 1);
        x3s("\000(\000a\000+\000)\000\000", "\000a\000a\000a\000a\000a\000a\000a\000\000", 0, 14, 1);
        x3s("\000(\000a\000+\000|\000b\000*\000)\000\000", "\000b\000b\000b\000a\000a\000\000", 0, 6, 1);
        x3s("\000(\000a\000+\000|\000b\000?\000)\000\000", "\000b\000b\000b\000a\000a\000\000", 0, 2, 1);
        x3s("\000(\000a\000b\000c\000)\000?\000\000", "\000a\000b\000c\000\000", 0, 6, 1);
        x3s("\000(\000a\000b\000c\000)\000*\000\000", "\000a\000b\000c\000\000", 0, 6, 1);
        x3s("\000(\000a\000b\000c\000)\000+\000\000", "\000a\000b\000c\000\000", 0, 6, 1);
        x3s("\000(\000x\000y\000z\000|\000a\000b\000c\000)\000+\000\000", "\000a\000b\000c\000\000", 0, 6, 1);
        x3s("\000(\000[\000x\000y\000z\000]\000[\000a\000b\000c\000]\000|\000a\000b\000c\000)\000+\000\000", "\000a\000b\000c\000\000", 0, 6, 1);
        x3s("\000(\000(\000?\000i\000:\000a\000b\000c\000)\000)\000\000", "\000A\000b\000C\000\000", 0, 6, 1);
        x2s("\000(\000a\000b\000c\000)\000(\000?\000i\000:\000\134\0001\000)\000\000", "\000a\000b\000c\000A\000B\000C\000\000", 0, 12);
        x3s("\000(\000(\000?\000m\000:\000a\000.\000c\000)\000)\000\000", "\000a\000\012\000c\000\000", 0, 6, 1);
        x3s("\000(\000(\000?\000=\000a\000z\000)\000a\000)\000\000", "\000a\000z\000b\000\000", 0, 2, 1);
        x3s("\000a\000b\000c\000|\000(\000.\000a\000b\000d\000)\000\000", "\000z\000a\000b\000d\000\000", 0, 8, 1);
        x2s("\000(\000?\000:\000a\000b\000c\000)\000|\000(\000A\000B\000C\000)\000\000", "\000a\000b\000c\000\000", 0, 6);
        x3s("\000(\000?\000i\000:\000(\000a\000b\000c\000)\000)\000|\000(\000z\000z\000z\000)\000\000", "\000A\000B\000C\000\000", 0, 6, 1);
        x3s("\000a\000*\000(\000.\000)\000\000", "\000a\000a\000a\000a\000z\000\000", 8, 10, 1);
        x3s("\000a\000*\000?\000(\000.\000)\000\000", "\000a\000a\000a\000a\000z\000\000", 0, 2, 1);
        x3s("\000a\000*\000?\000(\000c\000)\000\000", "\000a\000a\000a\000a\000c\000\000", 8, 10, 1);
        x3s("\000[\000b\000c\000d\000]\000a\000*\000(\000.\000)\000\000", "\000c\000a\000a\000a\000a\000z\000\000", 10, 12, 1);
        x3s("\000(\000\134\000A\000b\000b\000)\000c\000c\000\000", "\000b\000b\000c\000c\000\000", 0, 4, 1);
        ns("\000(\000\134\000A\000b\000b\000)\000c\000c\000\000", "\000z\000b\000b\000c\000c\000\000");
        x3s("\000(\000^\000b\000b\000)\000c\000c\000\000", "\000b\000b\000c\000c\000\000", 0, 4, 1);
        ns("\000(\000^\000b\000b\000)\000c\000c\000\000", "\000z\000b\000b\000c\000c\000\000");
        x3s("\000c\000c\000(\000b\000b\000$\000)\000\000", "\000c\000c\000b\000b\000\000", 4, 8, 1);
        ns("\000c\000c\000(\000b\000b\000$\000)\000\000", "\000c\000c\000b\000b\000b\000\000");
        ns("\000(\000\134\0001\000)\000\000", "\000\000");
        ns("\000\134\0001\000(\000a\000)\000\000", "\000a\000a\000\000");
        ns("\000(\000a\000(\000b\000)\000\134\0001\000)\000\134\0002\000+\000\000", "\000a\000b\000a\000b\000b\000\000");
        ns("\000(\000?\000:\000(\000?\000:\000\134\0001\000|\000z\000)\000(\000a\000)\000)\000+\000$\000\000", "\000z\000a\000a\000\000");
        x2s("\000(\000?\000:\000(\000?\000:\000\134\0001\000|\000z\000)\000(\000a\000)\000)\000+\000$\000\000", "\000z\000a\000a\000a\000\000", 0, 8);
        x2s("\000(\000a\000)\000(\000?\000=\000\134\0001\000)\000\000", "\000a\000a\000\000", 0, 2);
        ns("\000(\000a\000)\000$\000|\000\134\0001\000\000", "\000a\000z\000\000");
        x2s("\000(\000a\000)\000\134\0001\000\000", "\000a\000a\000\000", 0, 4);
        ns("\000(\000a\000)\000\134\0001\000\000", "\000a\000b\000\000");
        x2s("\000(\000a\000?\000)\000\134\0001\000\000", "\000a\000a\000\000", 0, 4);
        x2s("\000(\000a\000?\000?\000)\000\134\0001\000\000", "\000a\000a\000\000", 0, 0);
        x2s("\000(\000a\000*\000)\000\134\0001\000\000", "\000a\000a\000a\000a\000a\000\000", 0, 8);
        x3s("\000(\000a\000*\000)\000\134\0001\000\000", "\000a\000a\000a\000a\000a\000\000", 0, 4, 1);
        x2s("\000a\000(\000b\000*\000)\000\134\0001\000\000", "\000a\000b\000b\000b\000b\000\000", 0, 10);
        x2s("\000a\000(\000b\000*\000)\000\134\0001\000\000", "\000a\000b\000\000", 0, 2);
        x2s("\000(\000a\000*\000)\000(\000b\000*\000)\000\134\0001\000\134\0002\000\000", "\000a\000a\000a\000b\000b\000a\000a\000a\000b\000b\000\000", 0, 20);
        x2s("\000(\000a\000*\000)\000(\000b\000*\000)\000\134\0002\000\000", "\000a\000a\000a\000b\000b\000b\000b\000\000", 0, 14);
        x2s("\000(\000(\000(\000(\000(\000(\000(\000a\000*\000)\000b\000)\000)\000)\000)\000)\000)\000c\000\134\0007\000\000", "\000a\000a\000a\000b\000c\000a\000a\000a\000\000", 0, 16);
        x3s("\000(\000(\000(\000(\000(\000(\000(\000a\000*\000)\000b\000)\000)\000)\000)\000)\000)\000c\000\134\0007\000\000", "\000a\000a\000a\000b\000c\000a\000a\000a\000\000", 0, 6, 7);
        x2s("\000(\000a\000)\000(\000b\000)\000(\000c\000)\000\134\0002\000\134\0001\000\134\0003\000\000", "\000a\000b\000c\000b\000a\000c\000\000", 0, 12);
        x2s("\000(\000[\000a\000-\000d\000]\000)\000\134\0001\000\000", "\000c\000c\000\000", 0, 4);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000(\000\134\000w\000\134\000d\000\134\000s\000)\000\134\0001\000\000", "\000f\0005\000 \000f\0005\000 \000\000", 0, 12);
        ns("\000(\000\134\000w\000\134\000d\000\134\000s\000)\000\134\0001\000\000", "\000f\0005\000 \000f\0005\000\000");
        x2s("\000(\000w\000h\000o\000|\000[\000a\000-\000c\000]\000{\0003\000}\000)\000\134\0001\000\000", "\000w\000h\000o\000w\000h\000o\000\000", 0, 12);
        x2s("\000.\000.\000.\000(\000w\000h\000o\000|\000[\000a\000-\000c\000]\000{\0003\000}\000)\000\134\0001\000\000", "\000a\000b\000c\000w\000h\000o\000w\000h\000o\000\000", 0, 18);
        x2s("\000(\000w\000h\000o\000|\000[\000a\000-\000c\000]\000{\0003\000}\000)\000\134\0001\000\000", "\000c\000b\000c\000c\000b\000c\000\000", 0, 12);
        x2s("\000(\000^\000a\000)\000\134\0001\000\000", "\000a\000a\000\000", 0, 4);
        ns("\000(\000^\000a\000)\000\134\0001\000\000", "\000b\000a\000a\000\000");
        ns("\000(\000a\000$\000)\000\134\0001\000\000", "\000a\000a\000\000");
        ns("\000(\000a\000b\000\134\000Z\000)\000\134\0001\000\000", "\000a\000b\000\000");
        x2s("\000(\000a\000*\000\134\000Z\000)\000\134\0001\000\000", "\000a\000\000", 2, 2);
        x2s("\000.\000(\000a\000*\000\134\000Z\000)\000\134\0001\000\000", "\000b\000a\000\000", 2, 4);
        x3s("\000(\000.\000(\000a\000b\000c\000)\000\134\0002\000)\000\000", "\000z\000a\000b\000c\000a\000b\000c\000\000", 0, 14, 1);
        if (!org.joni.Config.NON_UNICODE_SDW) x3s("\000(\000.\000(\000.\000.\000\134\000d\000.\000)\000\134\0002\000)\000\000", "\000z\0001\0002\0003\0004\0001\0002\0003\0004\000\000", 0, 18, 1);
        x2s("\000(\000(\000?\000i\000:\000a\000z\000)\000)\000\134\0001\000\000", "\000A\000z\000A\000z\000\000", 0, 8);
        ns("\000(\000(\000?\000i\000:\000a\000z\000)\000)\000\134\0001\000\000", "\000A\000z\000a\000z\000\000");
        x2s("\000(\000?\000<\000=\000a\000)\000b\000\000", "\000a\000b\000\000", 2, 4);
        ns("\000(\000?\000<\000=\000a\000)\000b\000\000", "\000b\000b\000\000");
        x2s("\000(\000?\000<\000=\000a\000|\000b\000)\000b\000\000", "\000b\000b\000\000", 2, 4);
        x2s("\000(\000?\000<\000=\000a\000|\000b\000c\000)\000b\000\000", "\000b\000c\000b\000\000", 4, 6);
        x2s("\000(\000?\000<\000=\000a\000|\000b\000c\000)\000b\000\000", "\000a\000b\000\000", 2, 4);
        x2s("\000(\000?\000<\000=\000a\000|\000b\000c\000|\000|\000d\000e\000f\000g\000h\000i\000j\000|\000k\000l\000m\000n\000o\000p\000q\000|\000r\000)\000z\000\000", "\000r\000z\000\000", 2, 4);
        x2s("\000(\000a\000)\000\134\000g\000<\0001\000>\000\000", "\000a\000a\000\000", 0, 4);
        x2s("\000(\000?\000<\000!\000a\000)\000b\000\000", "\000c\000b\000\000", 2, 4);
        ns("\000(\000?\000<\000!\000a\000)\000b\000\000", "\000a\000b\000\000");
        x2s("\000(\000?\000<\000!\000a\000|\000b\000c\000)\000b\000\000", "\000b\000b\000b\000\000", 0, 2);
        ns("\000(\000?\000<\000!\000a\000|\000b\000c\000)\000z\000\000", "\000b\000c\000z\000\000");
        x2s("\000(\000?\000<\000n\000a\000m\000e\0001\000>\000a\000)\000\000", "\000a\000\000", 0, 2);
        x2s("\000(\000?\000<\000n\000a\000m\000e\000_\0002\000>\000a\000b\000)\000\134\000g\000<\000n\000a\000m\000e\000_\0002\000>\000\000", "\000a\000b\000a\000b\000\000", 0, 8);
        x2s("\000(\000?\000<\000n\000a\000m\000e\000_\0003\000>\000.\000z\000v\000.\000)\000\134\000k\000<\000n\000a\000m\000e\000_\0003\000>\000\000", "\000a\000z\000v\000b\000a\000z\000v\000b\000\000", 0, 16);
        x2s("\000(\000?\000<\000=\000\134\000g\000<\000a\000b\000>\000)\000|\000-\000\134\000z\000E\000N\000D\000 \000(\000?\000<\000a\000b\000>\000X\000y\000Z\000)\000\000", "\000X\000y\000Z\000\000", 6, 6);
        x2s("\000(\000?\000<\000n\000>\000|\000a\000\134\000g\000<\000n\000>\000)\000+\000\000", "\000\000", 0, 0);
        x2s("\000(\000?\000<\000n\000>\000|\000\134\000(\000\134\000g\000<\000n\000>\000\134\000)\000)\000+\000$\000\000", "\000(\000)\000(\000(\000)\000)\000\000", 0, 12);
        x3s("\000\134\000g\000<\000n\000>\000(\000?\000<\000n\000>\000.\000)\000{\0000\000}\000\000", "\000X\000\000", 0, 2, 1);
        x2s("\000\134\000g\000<\000n\000>\000(\000a\000b\000c\000|\000d\000f\000(\000?\000<\000n\000>\000.\000Y\000Z\000)\000{\0002\000,\0008\000}\000)\000{\0000\000}\000\000", "\000X\000Y\000Z\000\000", 0, 6);
        x2s("\000\134\000A\000(\000?\000<\000n\000>\000(\000a\000\134\000g\000<\000n\000>\000)\000|\000)\000\134\000z\000\000", "\000a\000a\000a\000a\000\000", 0, 8);
        x2s("\000(\000?\000<\000n\000>\000|\000\134\000g\000<\000m\000>\000\134\000g\000<\000n\000>\000)\000\134\000z\000|\000\134\000z\000E\000N\000D\000 \000(\000?\000<\000m\000>\000a\000|\000(\000b\000)\000\134\000g\000<\000m\000>\000)\000\000", "\000b\000b\000b\000b\000a\000b\000b\000a\000\000", 0, 16);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000(\000?\000<\000n\000a\000m\000e\0001\0002\0004\0000\000>\000\134\000w\000+\000\134\000s\000x\000)\000a\000+\000\134\000k\000<\000n\000a\000m\000e\0001\0002\0004\0000\000>\000\000", "\000 \000 \000f\000g\000 \000x\000a\000a\000a\000a\000a\000a\000a\000a\000f\000g\000 \000x\000\000", 4, 36);
        x3s("\000(\000z\000)\000(\000)\000(\000)\000(\000?\000<\000_\0009\000>\000a\000)\000\134\000g\000<\000_\0009\000>\000\000", "\000z\000a\000a\000\000", 4, 6, 1);
        x2s("\000(\000.\000)\000(\000(\000(\000?\000<\000_\000>\000a\000)\000)\000)\000\134\000k\000<\000_\000>\000\000", "\000z\000a\000a\000\000", 0, 6);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000(\000(\000?\000<\000n\000a\000m\000e\0001\000>\000\134\000d\000)\000|\000(\000?\000<\000n\000a\000m\000e\0002\000>\000\134\000w\000)\000)\000(\000\134\000k\000<\000n\000a\000m\000e\0001\000>\000|\000\134\000k\000<\000n\000a\000m\000e\0002\000>\000)\000\000", "\000f\000f\000\000", 0, 4);
        x2s("\000(\000?\000:\000(\000?\000<\000x\000>\000)\000|\000(\000?\000<\000x\000>\000e\000f\000g\000)\000)\000\134\000k\000<\000x\000>\000\000", "\000\000", 0, 0);
        x2s("\000(\000?\000:\000(\000?\000<\000x\000>\000a\000b\000c\000)\000|\000(\000?\000<\000x\000>\000e\000f\000g\000)\000)\000\134\000k\000<\000x\000>\000\000", "\000a\000b\000c\000e\000f\000g\000e\000f\000g\000\000", 6, 18);
        ns("\000(\000?\000:\000(\000?\000<\000x\000>\000a\000b\000c\000)\000|\000(\000?\000<\000x\000>\000e\000f\000g\000)\000)\000\134\000k\000<\000x\000>\000\000", "\000a\000b\000c\000e\000f\000g\000\000");
        x2s("\000(\000?\000:\000(\000?\000<\000n\0001\000>\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000)\000)\000\134\000k\000<\000n\0001\000>\000$\000\000", "\000a\000-\000p\000y\000u\000m\000p\000y\000u\000m\000\000", 4, 20);
        x3s("\000(\000?\000:\000(\000?\000<\000n\0001\000>\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000)\000|\000(\000?\000<\000n\0001\000>\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000.\000)\000)\000\134\000k\000<\000n\0001\000>\000$\000\000", "\000x\000x\000x\000x\000a\000b\000c\000d\000e\000f\000g\000h\000i\000j\000k\000l\000m\000n\000a\000b\000c\000d\000e\000f\000g\000h\000i\000j\000k\000l\000m\000n\000\000", 8, 36, 14);
        x3s("\000(\000?\000<\000n\000a\000m\000e\0001\000>\000)\000(\000?\000<\000n\000a\000m\000e\0002\000>\000)\000(\000?\000<\000n\000a\000m\000e\0003\000>\000)\000(\000?\000<\000n\000a\000m\000e\0004\000>\000)\000(\000?\000<\000n\000a\000m\000e\0005\000>\000)\000(\000?\000<\000n\000a\000m\000e\0006\000>\000)\000(\000?\000<\000n\000a\000m\000e\0007\000>\000)\000(\000?\000<\000n\000a\000m\000e\0008\000>\000)\000(\000?\000<\000n\000a\000m\000e\0009\000>\000)\000(\000?\000<\000n\000a\000m\000e\0001\0000\000>\000)\000(\000?\000<\000n\000a\000m\000e\0001\0001\000>\000)\000(\000?\000<\000n\000a\000m\000e\0001\0002\000>\000)\000(\000?\000<\000n\000a\000m\000e\0001\0003\000>\000)\000(\000?\000<\000n\000a\000m\000e\0001\0004\000>\000)\000(\000?\000<\000n\000a\000m\000e\0001\0005\000>\000)\000(\000?\000<\000n\000a\000m\000e\0001\0006\000>\000a\000a\000a\000)\000(\000?\000<\000n\000a\000m\000e\0001\0007\000>\000)\000$\000\000", "\000a\000a\000a\000\000", 0, 6, 16);
        x2s("\000(\000?\000<\000f\000o\000o\000>\000a\000|\000\134\000(\000\134\000g\000<\000f\000o\000o\000>\000\134\000)\000)\000\000", "\000a\000\000", 0, 2);
        x2s("\000(\000?\000<\000f\000o\000o\000>\000a\000|\000\134\000(\000\134\000g\000<\000f\000o\000o\000>\000\134\000)\000)\000\000", "\000(\000(\000(\000(\000(\000(\000a\000)\000)\000)\000)\000)\000)\000\000", 0, 26);
        x3s("\000(\000?\000<\000f\000o\000o\000>\000a\000|\000\134\000(\000\134\000g\000<\000f\000o\000o\000>\000\134\000)\000)\000\000", "\000(\000(\000(\000(\000(\000(\000(\000(\000a\000)\000)\000)\000)\000)\000)\000)\000)\000\000", 0, 34, 1);
        x2s("\000\134\000g\000<\000b\000a\000r\000>\000|\000\134\000z\000E\000N\000D\000(\000?\000<\000b\000a\000r\000>\000.\000*\000a\000b\000c\000$\000)\000\000", "\000a\000b\000c\000x\000x\000x\000a\000b\000c\000\000", 0, 18);
        x2s("\000\134\000g\000<\0001\000>\000|\000\134\000z\000E\000N\000D\000(\000.\000a\000.\000)\000\000", "\000b\000a\000c\000\000", 0, 6);
        x3s("\000\134\000g\000<\000_\000A\000>\000\134\000g\000<\000_\000A\000>\000|\000\134\000z\000E\000N\000D\000(\000.\000a\000.\000)\000(\000?\000<\000_\000A\000>\000.\000b\000.\000)\000\000", "\000x\000b\000x\000y\000b\000y\000\000", 6, 12, 1);
        x2s("\000\134\000A\000(\000?\000:\000\134\000g\000<\000p\000o\000n\000>\000|\000\134\000g\000<\000p\000a\000n\000>\000|\000\134\000z\000E\000N\000D\000 \000 \000(\000?\000<\000p\000a\000n\000>\000a\000|\000c\000\134\000g\000<\000p\000o\000n\000>\000c\000)\000(\000?\000<\000p\000o\000n\000>\000b\000|\000d\000\134\000g\000<\000p\000a\000n\000>\000d\000)\000)\000$\000\000", "\000c\000d\000c\000b\000c\000d\000c\000\000", 0, 14);
        x2s("\000\134\000A\000(\000?\000<\000n\000>\000|\000a\000\134\000g\000<\000m\000>\000)\000\134\000z\000|\000\134\000z\000E\000N\000D\000 \000(\000?\000<\000m\000>\000\134\000g\000<\000n\000>\000)\000\000", "\000a\000a\000a\000a\000\000", 0, 8);
        x2s("\000(\000?\000<\000n\000>\000(\000a\000|\000b\000\134\000g\000<\000n\000>\000c\000)\000{\0003\000,\0005\000}\000)\000\000", "\000b\000a\000a\000a\000a\000c\000a\000\000", 2, 10);
        x2s("\000(\000?\000<\000n\000>\000(\000a\000|\000b\000\134\000g\000<\000n\000>\000c\000)\000{\0003\000,\0005\000}\000)\000\000", "\000b\000a\000a\000a\000a\000c\000a\000a\000a\000a\000a\000\000", 0, 20);
        x2s("\000(\000?\000<\000p\000a\000r\000e\000>\000\134\000(\000(\000[\000^\000\134\000(\000\134\000)\000]\000+\000+\000|\000\134\000g\000<\000p\000a\000r\000e\000>\000)\000*\000+\000\134\000)\000)\000\000", "\000(\000(\000a\000)\000)\000\000", 0, 10);
        x2s("\000(\000)\000*\000\134\0001\000\000", "\000\000", 0, 0);
        x2s("\000(\000?\000:\000(\000)\000|\000(\000)\000)\000*\000\134\0001\000\134\0002\000\000", "\000\000", 0, 0);
        x3s("\000(\000?\000:\000\134\0001\000a\000|\000(\000)\000)\000*\000\000", "\000a\000\000", 0, 0, 1);
        x2s("\000x\000(\000(\000.\000)\000*\000)\000*\000x\000\000", "\0000\000x\0001\000x\0002\000x\0003\000\000", 2, 12);
        x2s("\000x\000(\000(\000.\000)\000*\000)\000*\000x\000(\000?\000i\000:\000\134\0001\000)\000\134\000Z\000\000", "\0000\000x\0001\000x\0002\000x\0001\000X\0002\000\000", 2, 18);
        x2s("\000(\000?\000:\000(\000)\000|\000(\000)\000|\000(\000)\000|\000(\000)\000|\000(\000)\000|\000(\000)\000)\000*\000\134\0002\000\134\0005\000\000", "\000\000", 0, 0);
        x2s("\000(\000?\000:\000(\000)\000|\000(\000)\000|\000(\000)\000|\000(\000x\000)\000|\000(\000)\000|\000(\000)\000)\000*\000\134\0002\000b\000\134\0005\000\000", "\000b\000\000", 0, 2);
        x2s("\217\372\000\000", "\217\372\000\000", 0, 2);
        x2s("\000\000", "0B\000\000", 0, 0);
        x2s("0B\000\000", "0B\000\000", 0, 2);
        ns("0D\000\000", "0B\000\000");
        x2s("0F0F\000\000", "0F0F\000\000", 0, 4);
        x2s("0B0D0F\000\000", "0B0D0F\000\000", 0, 6);
        x2s("0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S\000\000", "0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S0S\000\000", 0, 70);
        x2s("0B\000\000", "0D0B\000\000", 2, 4);
        x2s("0D0F\000\000", "0B0D0F\000\000", 2, 6);
        x2s("e\207\000\000", "e\207\000\000", 0, 2);
        x2s("\000.\000\000", "0B\000\000", 0, 2);
        x2s("\000.\000.\000\000", "0K0M\000\000", 0, 4);
        x2s("\000\134\000w\000\000", "0J\000\000", 0, 2);
        ns("\000\134\000W\000\000", "0B\000\000");
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000[\000\134\000W\000]\000\000", "0F\000$\000\000", 2, 4);
        x2s("\000\134\000S\000\000", "0]\000\000", 0, 2);
        x2s("\000\134\000S\000\000", "o\042\000\000", 0, 2);
        x2s("\000\134\000b\000\000", "l\027\000 \000\000", 0, 0);
        x2s("\000\134\000b\000\000", "\000 0{\000\000", 2, 2);
        x2s("\000\134\000B\000\000", "0[0]\000 \000\000", 2, 2);
        x2s("\000\134\000B\000\000", "0F\000 \000\000", 4, 4);
        x2s("\000\134\000B\000\000", "\000 0D\000\000", 0, 0);
        x2s("\000[0_0a\000]\000\000", "0a\000\000", 0, 2);
        ns("\000[0j0k\000]\000\000", "0l\000\000");
        x2s("\000[0F\000-0J\000]\000\000", "0H\000\000", 0, 2);
        ns("\000[\000^0Q\000]\000\000", "0Q\000\000");
        x2s("\000[\000\134\000w\000]\000\000", "0m\000\000", 0, 2);
        if (!org.joni.Config.NON_UNICODE_SDW) ns("\000[\000\134\000d\000]\000\000", "0u\000\000");
        x2s("\000[\000\134\000D\000]\000\000", "0o\000\000", 0, 2);
        ns("\000[\000\134\000s\000]\000\000", "0O\000\000");
        x2s("\000[\000\134\000S\000]\000\000", "0x\000\000", 0, 2);
        x2s("\000[\000\134\000w\000\134\000d\000]\000\000", "0\210\000\000", 0, 2);
        x2s("\000[\000\134\000w\000\134\000d\000]\000\000", "\000 \000 \000 0\210\000\000", 6, 8);
        ns("\000\134\000w\233<\216\312\000\000", "\000 \233<\216\312\000\000");
        x2s("\233<\000\134\000W\216\312\000\000", "\233<\000 \216\312\000\000", 0, 6);
        x2s("0B\000.0D\000.0F\000\000", "0B0B0D0D0F\000\000", 0, 10);
        x2s("\000.\000\134\000w0F\000\134\000W\000.\000.0^\000\000", "0H0F0F\000 0F0^0^\000\000", 0, 14);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000\134\000s\000\134\000w0S0S0S\000\000", "\000 0S0S0S0S\000\000", 0, 10);
        x2s("0B0B\000.0Q\000\000", "0B0B0Q0Q\000\000", 0, 8);
        ns("\000.0D\000\000", "0D0H\000\000");
        x2s("\000.0J\000\000", "0J0J\000\000", 0, 4);
        x2s("\000^0B\000\000", "0B\000\000", 0, 2);
        x2s("\000^0\200\000$\000\000", "0\200\000\000", 0, 2);
        x2s("\000^\000\134\000w\000$\000\000", "0k\000\000", 0, 2);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000^\000\134\000w0K0M0O0Q0S\000$\000\000", "\000z0K0M0O0Q0S\000\000", 0, 12);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000^\000\134\000w\000.\000.\000.0F0H0J\000$\000\000", "\000z0B0D0F0F0H0J\000\000", 0, 14);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000\134\000w\000\134\000w\000\134\000s\000\134\000W0J0J0J\000\134\000d\000\000", "\000a0J\000 \000 0J0J0J\0004\000\000", 0, 16);
        x2s("\000\134\000A0_0a0d\000\000", "0_0a0d\000\000", 0, 6);
        x2s("0\2000\2010\202\000\134\000Z\000\000", "0\2000\2010\202\000\000", 0, 6);
        x2s("0K0M0O\000\134\000z\000\000", "0K0M0O\000\000", 0, 6);
        x2s("0K0M0O\000\134\000Z\000\000", "0K0M0O\000\012\000\000", 0, 6);
        x2s("\000\134\000G0}0t\000\000", "0}0t\000\000", 0, 4);
        ns("\000\134\000G0H\000\000", "0F0H0J\000\000");
        ns("0h0f\000\134\000G\000\000", "0h0f\000\000");
        ns("0~0\177\000\134\000A\000\000", "0~0\177\000\000");
        ns("0~\000\134\000A0\177\000\000", "0~0\177\000\000");
        x2s("\000(\000?\000=0[\000)0[\000\000", "0[\000\000", 0, 2);
        ns("\000(\000?\000=0F\000)\000.\000\000", "0D\000\000");
        x2s("\000(\000?\000!0F\000)0K\000\000", "0K\000\000", 0, 2);
        ns("\000(\000?\000!0h\000)0B\000\000", "0h\000\000");
        x2s("\000(\000?\000i\000:0B\000)\000\000", "0B\000\000", 0, 2);
        x2s("\000(\000?\000i\000:0v0y\000)\000\000", "0v0y\000\000", 0, 4);
        ns("\000(\000?\000i\000:0D\000)\000\000", "0F\000\000");
        x2s("\000(\000?\000m\000:0\210\000.\000)\000\000", "0\210\000\012\000\000", 0, 4);
        x2s("\000(\000?\000m\000:\000.0\201\000)\000\000", "0~\000\0120\201\000\000", 2, 6);
        x2s("0B\000?\000\000", "\000\000", 0, 0);
        x2s("Y\011\000?\000\000", "S\026\000\000", 0, 0);
        x2s("Y\011\000?\000\000", "Y\011\000\000", 0, 2);
        x2s("\221\317\000*\000\000", "\000\000", 0, 0);
        x2s("\221\317\000*\000\000", "\221\317\000\000", 0, 2);
        x2s("[P\000*\000\000", "[P[P[P\000\000", 0, 6);
        x2s("\231\254\000*\000\000", "\236\177\231\254\231\254\231\254\231\254\000\000", 0, 0);
        ns("\134q\000+\000\000", "\000\000");
        x2s("l\263\000+\000\000", "l\263\000\000", 0, 2);
        x2s("fB\000+\000\000", "fBfBfBfB\000\000", 0, 8);
        x2s("0H\000+\000\000", "0H0H0F0F0F\000\000", 0, 4);
        x2s("0F\000+\000\000", "0J0F0F0F0F\000\000", 2, 10);
        x2s("\000.\000?\000\000", "0_\000\000", 0, 2);
        x2s("\000.\000*\000\000", "0q0t0w0z\000\000", 0, 8);
        x2s("\000.\000+\000\000", "0\215\000\000", 0, 2);
        x2s("\000.\000+\000\000", "0D0F0H0K\000\012\000\000", 0, 8);
        x2s("0B\000|0D\000\000", "0B\000\000", 0, 2);
        x2s("0B\000|0D\000\000", "0D\000\000", 0, 2);
        x2s("0B0D\000|0D0F\000\000", "0B0D\000\000", 0, 4);
        x2s("0B0D\000|0D0F\000\000", "0D0F\000\000", 0, 4);
        x2s("0\222\000(\000?\000:0K0M\000|0M0O\000)\000\000", "0\2220K0M\000\000", 0, 6);
        x2s("0\222\000(\000?\000:0K0M\000|0M0O\000)0Q\000\000", "0\2220M0O0Q\000\000", 0, 8);
        x2s("0B0D\000|\000(\000?\000:0B0F\000|0B0\222\000)\000\000", "0B0\222\000\000", 0, 4);
        x2s("0B\000|0D\000|0F\000\000", "0H0F\000\000", 2, 4);
        x2s("0B\000|0D\000|0F0H\000|0J0K0M\000|0O\000|0Q0S0U\000|0W0Y0[\000|0]\000|0_0a\000|0d0f0h0j0k\000|0l0m\000\000", "0W0Y0[\000\000", 0, 6);
        ns("0B\000|0D\000|0F0H\000|0J0K0M\000|0O\000|0Q0S0U\000|0W0Y0[\000|0]\000|0_0a\000|0d0f0h0j0k\000|0l0m\000\000", "0Y0[\000\000");
        x2s("0B\000|\000^0\217\000\000", "0v0B\000\000", 2, 4);
        x2s("0B\000|\000^0\222\000\000", "0\2220B\000\000", 0, 2);
        x2s("\233<\000|\000\134\000G\216\312\000\000", "0Q\216\312\233<\000\000", 4, 6);
        x2s("\233<\000|\000\134\000G\216\312\000\000", "\216\312\233<\000\000", 0, 2);
        x2s("\233<\000|\000\134\000A\216\312\000\000", "\000b\216\312\233<\000\000", 4, 6);
        x2s("\233<\000|\000\134\000A\216\312\000\000", "\216\312\000\000", 0, 2);
        x2s("\233<\000|\216\312\000\134\000Z\000\000", "\216\312\233<\000\000", 2, 4);
        x2s("\233<\000|\216\312\000\134\000Z\000\000", "\216\312\000\000", 0, 2);
        x2s("\233<\000|\216\312\000\134\000Z\000\000", "\216\312\000\012\000\000", 0, 2);
        x2s("\233<\000|\216\312\000\134\000z\000\000", "\216\312\233<\000\000", 2, 4);
        x2s("\233<\000|\216\312\000\134\000z\000\000", "\216\312\000\000", 0, 2);
        x2s("\000\134\000w\000|\000\134\000s\000\000", "0J\000\000", 0, 2);
        x2s("\000\134\000w\000|\000%\000\000", "\000%0J\000\000", 0, 2);
        x2s("\000\134\000w\000|\000[\000&\000$\000]\000\000", "0F\000&\000\000", 0, 2);
        x2s("\000[0D\000-0Q\000]\000\000", "0F\000\000", 0, 2);
        x2s("\000[0D\000-0Q\000]\000|\000[\000^0K\000-0S\000]\000\000", "0B\000\000", 0, 2);
        x2s("\000[0D\000-0Q\000]\000|\000[\000^0K\000-0S\000]\000\000", "0K\000\000", 0, 2);
        x2s("\000[\000^0B\000]\000\000", "\000\012\000\000", 0, 2);
        x2s("\000(\000?\000:0B\000|\000[0F\000-0M\000]\000)\000|0D0\222\000\000", "0F0\222\000\000", 0, 2);
        x2s("\000(\000?\000:0B\000|\000[0F\000-0M\000]\000)\000|0D0\222\000\000", "0D0\222\000\000", 0, 4);
        x2s("0B0D0F\000|\000(\000?\000=0Q0Q\000)\000.\000.0{\000\000", "0Q0Q0{\000\000", 0, 6);
        x2s("0B0D0F\000|\000(\000?\000!0Q0Q\000)\000.\000.0{\000\000", "0B0D0{\000\000", 0, 6);
        x2s("\000(\000?\000=0\2220B\000)\000.\000.0B\000|\000(\000?\000=0\2220\222\000)\000.\000.0B\000\000", "0\2220\2220B\000\000", 0, 6);
        x2s("\000(\000?\000<\000=0B\000|0D0F\000)0D\000\000", "0D0F0D\000\000", 4, 6);
        ns("\000(\000?\000>0B\000|0B0D0H\000)0F\000\000", "0B0D0H0F\000\000");
        x2s("\000(\000?\000>0B0D0H\000|0B\000)0F\000\000", "0B0D0H0F\000\000", 0, 8);
        x2s("0B\000?\000|0D\000\000", "0B\000\000", 0, 2);
        x2s("0B\000?\000|0D\000\000", "0D\000\000", 0, 0);
        x2s("0B\000?\000|0D\000\000", "\000\000", 0, 0);
        x2s("0B\000*\000|0D\000\000", "0B0B\000\000", 0, 4);
        x2s("0B\000*\000|0D\000*\000\000", "0D0B\000\000", 0, 0);
        x2s("0B\000*\000|0D\000*\000\000", "0B0D\000\000", 0, 2);
        x2s("\000[\000a0B\000]\000*\000|0D\000*\000\000", "\000a0B0D0D0D\000\000", 0, 4);
        x2s("0B\000+\000|0D\000*\000\000", "\000\000", 0, 0);
        x2s("0B\000+\000|0D\000*\000\000", "0D0D0D\000\000", 0, 6);
        x2s("0B\000+\000|0D\000*\000\000", "0B0D0D0D\000\000", 0, 2);
        x2s("0B\000+\000|0D\000*\000\000", "\000a0B0D0D0D\000\000", 0, 0);
        ns("0B\000+\000|0D\000+\000\000", "\000\000");
        x2s("\000(0B\000|0D\000)\000?\000\000", "0D\000\000", 0, 2);
        x2s("\000(0B\000|0D\000)\000*\000\000", "0D0B\000\000", 0, 4);
        x2s("\000(0B\000|0D\000)\000+\000\000", "0D0B0D\000\000", 0, 6);
        x2s("\000(0B0D\000|0F0B\000)\000+\000\000", "0F0B0B0D0F0H\000\000", 0, 8);
        x2s("\000(0B0D\000|0F0H\000)\000+\000\000", "0F0B0B0D0F0H\000\000", 4, 12);
        x2s("\000(0B0D\000|0F0B\000)\000+\000\000", "0B0B0D0F0B\000\000", 2, 10);
        x2s("\000(0B0D\000|0F0B\000)\000+\000\000", "0B0D0\2220F0B\000\000", 0, 4);
        x2s("\000(0B0D\000|0F0B\000)\000+\000\000", "\000$\000$\000z\000z\000z\000z0B0D0\2220F0B\000\000", 12, 16);
        x2s("\000(0B\000|0D0B0D\000)\000+\000\000", "0B0D0B0D0B\000\000", 0, 10);
        x2s("\000(0B\000|0D0B0D\000)\000+\000\000", "0D0B\000\000", 2, 4);
        x2s("\000(0B\000|0D0B0D\000)\000+\000\000", "0D0B0B0B0D0B\000\000", 2, 8);
        x2s("\000(\000?\000:0B\000|0D\000)\000(\000?\000:0B\000|0D\000)\000\000", "0B0D\000\000", 0, 4);
        x2s("\000(\000?\000:0B\000*\000|0D\000*\000)\000(\000?\000:0B\000*\000|0D\000*\000)\000\000", "0B0B0B0D0D0D\000\000", 0, 6);
        x2s("\000(\000?\000:0B\000*\000|0D\000*\000)\000(\000?\000:0B\000+\000|0D\000+\000)\000\000", "0B0B0B0D0D0D\000\000", 0, 12);
        x2s("\000(\000?\000:0B\000+\000|0D\000+\000)\000{\0002\000}\000\000", "0B0B0B0D0D0D\000\000", 0, 12);
        x2s("\000(\000?\000:0B\000+\000|0D\000+\000)\000{\0001\000,\0002\000}\000\000", "0B0B0B0D0D0D\000\000", 0, 12);
        x2s("\000(\000?\000:0B\000+\000|\000\134\000A0D\000*\000)0F0F\000\000", "0F0F\000\000", 0, 4);
        ns("\000(\000?\000:0B\000+\000|\000\134\000A0D\000*\000)0F0F\000\000", "0B0D0F0F\000\000");
        x2s("\000(\000?\000:\000^0B\000+\000|0D\000+\000)\000*0F\000\000", "0B0B0D0D0D0B0D0F\000\000", 12, 16);
        x2s("\000(\000?\000:\000^0B\000+\000|0D\000+\000)\000*0F\000\000", "0B0B0D0D0D0D0F\000\000", 0, 14);
        x2s("0F\000{\0000\000,\000}\000\000", "0F0F0F0F\000\000", 0, 8);
        x2s("0B\000|\000(\000?\000i\000)\000c\000\000", "\000C\000\000", 0, 2);
        x2s("\000(\000?\000i\000)\000c\000|0B\000\000", "\000C\000\000", 0, 2);
        x2s("\000(\000?\000i\000:0B\000)\000|\000a\000\000", "\000a\000\000", 0, 2);
        ns("\000(\000?\000i\000:0B\000)\000|\000a\000\000", "\000A\000\000");
        x2s("\000[0B0D0F\000]\000?\000\000", "0B0D0F\000\000", 0, 2);
        x2s("\000[0B0D0F\000]\000*\000\000", "0B0D0F\000\000", 0, 6);
        x2s("\000[\000^0B0D0F\000]\000*\000\000", "0B0D0F\000\000", 0, 0);
        ns("\000[\000^0B0D0F\000]\000+\000\000", "0B0D0F\000\000");
        x2s("0B\000?\000?\000\000", "0B0B0B\000\000", 0, 0);
        x2s("0D0B\000?\000?0D\000\000", "0D0B0D\000\000", 0, 6);
        x2s("0B\000*\000?\000\000", "0B0B0B\000\000", 0, 0);
        x2s("0D0B\000*\000?\000\000", "0D0B0B\000\000", 0, 2);
        x2s("0D0B\000*\000?0D\000\000", "0D0B0B0D\000\000", 0, 8);
        x2s("0B\000+\000?\000\000", "0B0B0B\000\000", 0, 2);
        x2s("0D0B\000+\000?\000\000", "0D0B0B\000\000", 0, 4);
        x2s("0D0B\000+\000?0D\000\000", "0D0B0B0D\000\000", 0, 8);
        x2s("\000(\000?\000:Y)\000?\000)\000?\000?\000\000", "Y)\000\000", 0, 0);
        x2s("\000(\000?\000:Y)\000?\000?\000)\000?\000\000", "Y)\000\000", 0, 0);
        x2s("\000(\000?\000:Y\042\000?\000)\000+\000?\000\000", "Y\042Y\042Y\042\000\000", 0, 2);
        x2s("\000(\000?\000:\230\250\000+\000)\000?\000?\000\000", "\230\250\230\250\230\250\000\000", 0, 0);
        x2s("\000(\000?\000:\226\352\000+\000)\000?\000?\227\034\000\000", "\226\352\226\352\226\352\227\034\000\000", 0, 8);
        x2s("\000(\000?\000:0B0D\000)\000?\000{\0002\000}\000\000", "\000\000", 0, 0);
        x2s("\000(\000?\000:\233<\216\312\000)\000?\000{\0002\000}\000\000", "\233<\216\312\233<\216\312\233<\000\000", 0, 8);
        x2s("\000(\000?\000:\233<\216\312\000)\000*\000{\0000\000}\000\000", "\233<\216\312\233<\216\312\233<\000\000", 0, 0);
        x2s("\000(\000?\000:\233<\216\312\000)\000{\0003\000,\000}\000\000", "\233<\216\312\233<\216\312\233<\216\312\233<\216\312\000\000", 0, 16);
        ns("\000(\000?\000:\233<\216\312\000)\000{\0003\000,\000}\000\000", "\233<\216\312\233<\216\312\000\000");
        x2s("\000(\000?\000:\233<\216\312\000)\000{\0002\000,\0004\000}\000\000", "\233<\216\312\233<\216\312\233<\216\312\000\000", 0, 12);
        x2s("\000(\000?\000:\233<\216\312\000)\000{\0002\000,\0004\000}\000\000", "\233<\216\312\233<\216\312\233<\216\312\233<\216\312\233<\216\312\000\000", 0, 16);
        x2s("\000(\000?\000:\233<\216\312\000)\000{\0002\000,\0004\000}\000?\000\000", "\233<\216\312\233<\216\312\233<\216\312\233<\216\312\233<\216\312\000\000", 0, 8);
        x2s("\000(\000?\000:\233<\216\312\000)\000{\000,\000}\000\000", "\233<\216\312\000{\000,\000}\000\000", 0, 10);
        x2s("\000(\000?\000:0K0M0O\000)\000+\000?\000{\0002\000}\000\000", "0K0M0O0K0M0O0K0M0O\000\000", 0, 12);
        x3s("\000(pk\000)\000\000", "pk\000\000", 0, 2, 1);
        x3s("\000(pkl4\000)\000\000", "pkl4\000\000", 0, 4, 1);
        x2s("\000(\000(fB\225\223\000)\000)\000\000", "fB\225\223\000\000", 0, 4);
        x3s("\000(\000(\230\250l4\000)\000)\000\000", "\230\250l4\000\000", 0, 4, 1);
        x3s("\000(\000(f(e\345\000)\000)\000\000", "f(e\345\000\000", 0, 4, 2);
        x3s("\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\000(\221\317[P\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000)\000\000", "\221\317[P\000\000", 0, 4, 20);
        x3s("\000(0B0D\000)\000(0F0H\000)\000\000", "0B0D0F0H\000\000", 0, 4, 1);
        x3s("\000(0B0D\000)\000(0F0H\000)\000\000", "0B0D0F0H\000\000", 4, 8, 2);
        x3s("\000(\000)\000(0B\000)0D0F\000(0H0J0K\000)0M0O0Q0S\000\000", "0B0D0F0H0J0K0M0O0Q0S\000\000", 6, 12, 3);
        x3s("\000(\000(\000)\000(0B\000)0D0F\000(0H0J0K\000)0M0O0Q0S\000)\000\000", "0B0D0F0H0J0K0M0O0Q0S\000\000", 6, 12, 4);
        x3s("\000.\000*\000(0\3250\251\000)0\3630\3730\336\000(0\363\000(\000)0\2670\3450\277\000)0\2440\363\000\000", "0\3250\2510\3630\3730\3360\3630\2670\3450\2770\2440\363\000\000", 10, 18, 2);
        x2s("\000(\000^0B\000)\000\000", "0B\000\000", 0, 2);
        x3s("\000(0B\000)\000|\000(0B\000)\000\000", "0D0B\000\000", 2, 4, 1);
        x3s("\000(\000^0B\000)\000|\000(0B\000)\000\000", "0D0B\000\000", 2, 4, 2);
        x3s("\000(0B\000?\000)\000\000", "0B0B0B\000\000", 0, 2, 1);
        x3s("\000(0~\000*\000)\000\000", "0~0~0~\000\000", 0, 6, 1);
        x3s("\000(0h\000*\000)\000\000", "\000\000", 0, 0, 1);
        x3s("\000(0\213\000+\000)\000\000", "0\2130\2130\2130\2130\2130\2130\213\000\000", 0, 14, 1);
        x3s("\000(0u\000+\000|0x\000*\000)\000\000", "0u0u0u0x0x\000\000", 0, 6, 1);
        x3s("\000(0B\000+\000|0D\000?\000)\000\000", "0D0D0D0B0B\000\000", 0, 2, 1);
        x3s("\000(0B0D0F\000)\000?\000\000", "0B0D0F\000\000", 0, 6, 1);
        x3s("\000(0B0D0F\000)\000*\000\000", "0B0D0F\000\000", 0, 6, 1);
        x3s("\000(0B0D0F\000)\000+\000\000", "0B0D0F\000\000", 0, 6, 1);
        x3s("\000(0U0W0Y\000|0B0D0F\000)\000+\000\000", "0B0D0F\000\000", 0, 6, 1);
        x3s("\000(\000[0j0k0l\000]\000[0K0M0O\000]\000|0K0M0O\000)\000+\000\000", "0K0M0O\000\000", 0, 6, 1);
        x3s("\000(\000(\000?\000i\000:0B0D0F\000)\000)\000\000", "0B0D0F\000\000", 0, 6, 1);
        x3s("\000(\000(\000?\000m\000:0B\000.0F\000)\000)\000\000", "0B\000\0120F\000\000", 0, 6, 1);
        x3s("\000(\000(\000?\000=0B0\223\000)0B\000)\000\000", "0B0\2230D\000\000", 0, 2, 1);
        x3s("0B0D0F\000|\000(\000.0B0D0H\000)\000\000", "0\2230B0D0H\000\000", 0, 8, 1);
        x3s("0B\000*\000(\000.\000)\000\000", "0B0B0B0B0\223\000\000", 8, 10, 1);
        x3s("0B\000*\000?\000(\000.\000)\000\000", "0B0B0B0B0\223\000\000", 0, 2, 1);
        x3s("0B\000*\000?\000(0\223\000)\000\000", "0B0B0B0B0\223\000\000", 8, 10, 1);
        x3s("\000[0D0F0H\000]0B\000*\000(\000.\000)\000\000", "0H0B0B0B0B0\223\000\000", 10, 12, 1);
        x3s("\000(\000\134\000A0D0D\000)0F0F\000\000", "0D0D0F0F\000\000", 0, 4, 1);
        ns("\000(\000\134\000A0D0D\000)0F0F\000\000", "0\2230D0D0F0F\000\000");
        x3s("\000(\000^0D0D\000)0F0F\000\000", "0D0D0F0F\000\000", 0, 4, 1);
        ns("\000(\000^0D0D\000)0F0F\000\000", "0\2230D0D0F0F\000\000");
        x3s("0\2150\215\000(0\2130\213\000$\000)\000\000", "0\2150\2150\2130\213\000\000", 4, 8, 1);
        ns("0\2150\215\000(0\2130\213\000$\000)\000\000", "0\2150\2150\2130\2130\213\000\000");
        x2s("\000(q!\000)\000\134\0001\000\000", "q!q!\000\000", 0, 4);
        ns("\000(q!\000)\000\134\0001\000\000", "q!kf\000\000");
        x2s("\000(zz\000?\000)\000\134\0001\000\000", "zzzz\000\000", 0, 4);
        x2s("\000(zz\000?\000?\000)\000\134\0001\000\000", "zzzz\000\000", 0, 0);
        x2s("\000(zz\000*\000)\000\134\0001\000\000", "zzzzzzzzzz\000\000", 0, 8);
        x3s("\000(zz\000*\000)\000\134\0001\000\000", "zzzzzzzzzz\000\000", 0, 4, 1);
        x2s("0B\000(0D\000*\000)\000\134\0001\000\000", "0B0D0D0D0D\000\000", 0, 10);
        x2s("0B\000(0D\000*\000)\000\134\0001\000\000", "0B0D\000\000", 0, 2);
        x2s("\000(0B\000*\000)\000(0D\000*\000)\000\134\0001\000\134\0002\000\000", "0B0B0B0D0D0B0B0B0D0D\000\000", 0, 20);
        x2s("\000(0B\000*\000)\000(0D\000*\000)\000\134\0002\000\000", "0B0B0B0D0D0D0D\000\000", 0, 14);
        x3s("\000(0B\000*\000)\000(0D\000*\000)\000\134\0002\000\000", "0B0B0B0D0D0D0D\000\000", 6, 10, 2);
        x2s("\000(\000(\000(\000(\000(\000(\000(0}\000*\000)0z\000)\000)\000)\000)\000)\000)0t\000\134\0007\000\000", "0}0}0}0z0t0}0}0}\000\000", 0, 16);
        x3s("\000(\000(\000(\000(\000(\000(\000(0}\000*\000)0z\000)\000)\000)\000)\000)\000)0t\000\134\0007\000\000", "0}0}0}0z0t0}0}0}\000\000", 0, 6, 7);
        x2s("\000(0o\000)\000(0r\000)\000(0u\000)\000\134\0002\000\134\0001\000\134\0003\000\000", "0o0r0u0r0o0u\000\000", 0, 12);
        x2s("\000(\000[0M\000-0Q\000]\000)\000\134\0001\000\000", "0O0O\000\000", 0, 4);
        if (!org.joni.Config.NON_UNICODE_SDW) x2s("\000(\000\134\000w\000\134\000d\000\134\000s\000)\000\134\0001\000\000", "0B\0005\000 0B\0005\000 \000\000", 0, 12);
        ns("\000(\000\134\000w\000\134\000d\000\134\000s\000)\000\134\0001\000\000", "0B\0005\000 0B\0005\000\000");
        x2s("\000(\212\260\377\037\000|\000[0B\000-0F\000]\000{\0003\000}\000)\000\134\0001\000\000", "\212\260\377\037\212\260\377\037\000\000", 0, 8);
        x2s("\000.\000.\000.\000(\212\260\377\037\000|\000[0B\000-0F\000]\000{\0003\000}\000)\000\134\0001\000\000", "0B\000a0B\212\260\377\037\212\260\377\037\000\000", 0, 14);
        x2s("\000(\212\260\377\037\000|\000[0B\000-0F\000]\000{\0003\000}\000)\000\134\0001\000\000", "0F0D0F0F0D0F\000\000", 0, 12);
        x2s("\000(\000^0S\000)\000\134\0001\000\000", "0S0S\000\000", 0, 4);
        ns("\000(\000^0\200\000)\000\134\0001\000\000", "0\2010\2000\200\000\000");
        ns("\000(0B\000$\000)\000\134\0001\000\000", "0B0B\000\000");
        ns("\000(0B0D\000\134\000Z\000)\000\134\0001\000\000", "0B0D\000\000");
        x2s("\000(0B\000*\000\134\000Z\000)\000\134\0001\000\000", "0B\000\000", 2, 2);
        x2s("\000.\000(0B\000*\000\134\000Z\000)\000\134\0001\000\000", "0D0B\000\000", 2, 4);
        x3s("\000(\000.\000(0\2040D0\206\000)\000\134\0002\000)\000\000", "\000z0\2040D0\2060\2040D0\206\000\000", 0, 14, 1);
        if (!org.joni.Config.NON_UNICODE_SDW) x3s("\000(\000.\000(\000.\000.\000\134\000d\000.\000)\000\134\0002\000)\000\000", "0B\0001\0002\0003\0004\0001\0002\0003\0004\000\000", 0, 18, 1);
        x2s("\000(\000(\000?\000i\000:0B\000v0Z\000)\000)\000\134\0001\000\000", "0B\000v0Z0B\000v0Z\000\000", 0, 12);
        x2s("\000(\000?\000<a\0320K\000>Y\011\000|\000\134\000(\000\134\000g\000<a\0320K\000>\000\134\000)\000)\000\000", "\000(\000(\000(\000(\000(\000(Y\011\000)\000)\000)\000)\000)\000)\000\000", 0, 26);
        x2s("\000\134\000A\000(\000?\000:\000\134\000g\000<\226?\000_\0001\000>\000|\000\134\000g\000<N\221\000_\0002\000>\000|\000\134\000z}BN\206\000 \000 \000(\000?\000<\226?\000_\0001\000>\211\263\000|\201\352\000\134\000g\000<N\221\000_\0002\000>\201\352\000)\000(\000?\000<N\221\000_\0002\000>W(\000|\203\351\205\251\000\134\000g\000<\226?\000_\0001\000>\203\351\205\251\000)\000)\000$\000\000", "\203\351\205\251\201\352\203\351\205\251\201\352W(\201\352\203\351\205\251\201\352\203\351\205\251\000\000", 0, 26);
        x2s("\000[\000[0r0u\000]\000]\000\000", "0u\000\000", 0, 2);
        x2s("\000[\000[0D0J0F\000]0K\000]\000\000", "0K\000\000", 0, 2);
        ns("\000[\000[\000^0B\000]\000]\000\000", "0B\000\000");
        ns("\000[\000^\000[0B\000]\000]\000\000", "0B\000\000");
        x2s("\000[\000^\000[\000^0B\000]\000]\000\000", "0B\000\000", 0, 2);
        x2s("\000[\000[0K0M0O\000]\000&\000&0M0O\000]\000\000", "0O\000\000", 0, 2);
        ns("\000[\000[0K0M0O\000]\000&\000&0M0O\000]\000\000", "0K\000\000");
        ns("\000[\000[0K0M0O\000]\000&\000&0M0O\000]\000\000", "0Q\000\000");
        x2s("\000[0B\000-0\223\000&\000&0D\000-0\222\000&\000&0F\000-0\221\000]\000\000", "0\221\000\000", 0, 2);
        ns("\000[\000^0B\000-0\223\000&\000&0D\000-0\222\000&\000&0F\000-0\221\000]\000\000", "0\221\000\000");
        x2s("\000[\000[\000^0B\000&\000&0B\000]\000&\000&0B\000-0\223\000]\000\000", "0D\000\000", 0, 2);
        ns("\000[\000[\000^0B\000&\000&0B\000]\000&\000&0B\000-0\223\000]\000\000", "0B\000\000");
        x2s("\000[\000[\000^0B\000-0\223\000&\000&0D0F0H0J\000]\000&\000&\000[\000^0F\000-0K\000]\000]\000\000", "0M\000\000", 0, 2);
        ns("\000[\000[\000^0B\000-0\223\000&\000&0D0F0H0J\000]\000&\000&\000[\000^0F\000-0K\000]\000]\000\000", "0D\000\000");
        x2s("\000[\000^\000[\000^0B0D0F\000]\000&\000&\000[\000^0F0H0J\000]\000]\000\000", "0F\000\000", 0, 2);
        x2s("\000[\000^\000[\000^0B0D0F\000]\000&\000&\000[\000^0F0H0J\000]\000]\000\000", "0H\000\000", 0, 2);
        ns("\000[\000^\000[\000^0B0D0F\000]\000&\000&\000[\000^0F0H0J\000]\000]\000\000", "0K\000\000");
        x2s("\000[0B\000-\000&\000&\000-0B\000]\000\000", "\000-\000\000", 0, 2);
        x2s("\000[\000^\000[\000^\000a\000-\000z0B0D0F\000]\000&\000&\000[\000^\000b\000c\000d\000e\000f\000g0F0H0J\000]\000q\000-\000w\000]\000\000", "0H\000\000", 0, 2);
        x2s("\000[\000^\000[\000^\000a\000-\000z0B0D0F\000]\000&\000&\000[\000^\000b\000c\000d\000e\000f\000g0F0H0J\000]\000g\000-\000w\000]\000\000", "\000f\000\000", 0, 2);
        x2s("\000[\000^\000[\000^\000a\000-\000z0B0D0F\000]\000&\000&\000[\000^\000b\000c\000d\000e\000f\000g0F0H0J\000]\000g\000-\000w\000]\000\000", "\000g\000\000", 0, 2);
        ns("\000[\000^\000[\000^\000a\000-\000z0B0D0F\000]\000&\000&\000[\000^\000b\000c\000d\000e\000f\000g0F0H0J\000]\000g\000-\000w\000]\000\000", "\0002\000\000");
        x2s("\000a\000<\000b\000>0\3200\3740\2700\3470\3630n0\3000\2460\3630\3550\3740\311\000<\000\134\000/\000b\000>\000\000", "\000a\000<\000b\000>0\3200\3740\2700\3470\3630n0\3000\2460\3630\3550\3740\311\000<\000/\000b\000>\000\000", 0, 40);
        x2s("\000.\000<\000b\000>0\3200\3740\2700\3470\3630n0\3000\2460\3630\3550\3740\311\000<\000\134\000/\000b\000>\000\000", "\000a\000<\000b\000>0\3200\3740\2700\3470\3630n0\3000\2460\3630\3550\3740\311\000<\000/\000b\000>\000\000", 0, 40);
    }

    public static void main(String[] args) throws Throwable {
        new TestU().run();
    }
}
