+++
title = "Server-Side Examples"
+++

There are many examples of integrating htmx with server-side frameworks available on GitHub. Generally speaking,
most server-side frameworks are already pretty well set up to integrate with htmx - after all, most of them were
rendering HTML long before JSON became popular.

Different frameworks and platforms may offer alternative systems for installing htmx - for example, in the Java / JVM
ecosystem, [WebJars](https://www.webjars.org) allows the use of npm packages with popular Java build tools such as
Maven and Gradle.

These examples may make it a bit easier to get started using htmx with your platform of choice.

## General Resources

- <https://github.com/rajasegar/awesome-htmx>

## JavaScript

### Node.js

- <https://github.com/rajasegar/todomvc-htmx>
- <https://github.com/rajasegar/htmx-twitter-clone>
- <https://github.com/rajasegar/htmx-trello>

### hapi

- <https://github.com/DamianStanger/hapi-htmx>

## Python

- <https://github.com/PyHAT-stack/awesome-python-htmx>

### Django

- <https://github.com/adamchainz/django-htmx>
- <https://github.com/spookylukey/django-htmx-patterns/>
- <https://github.com/idlesign/django-siteajax>
- <https://github.com/guettli/django-htmx-fun/>
- <https://www.photondesigner.com/articles/submit-async-django-form-with-htmx>

### FastAPI

- <https://github.com/renceInbox/fastapi-todo>
- <https://github.com/AutomationPanda/bulldoggy-reminders-app>
- <https://github.com/volfpeter/fastapi-htmx-tailwind-example>

### Flask

- <https://github.com/edmondchuc/flask-htmx>
- <https://github.com/cscortes/htmxflask>
- <https://github.com/Konfuzian/htmx-examples-with-flask/>

### py4web

- <https://github.com/jpsteil/py4web_htmx_demo>

## Java

### Spring Boot

- <https://github.com/wiverson/htmx-demo>
- <https://github.com/wimdeblauwe/blog-example-code/tree/master/todomvc-htmx>

### Quarkus

- <https://github.com/ia3andy/renotes>
- <https://github.com/ia3andy/htmx-todo>

## ColdFusion (CFML - a JVM Language)

### CFWheels Framework

- <https://github.com/bpamiri/cfwheels-todomvc-htmx>
- <https://www.forgebox.io/view/cfwheels-htmx-plugin>
- <https://github.com/chapmandu/cfwheels-htmx-crud>

## C#

### ASP.NET Core

- <https://github.com/jerriepelser-blog/htmx-with-aspnet-core>
- <https://github.com/mryderie/aspnet-core-htmx-example>
- <https://github.com/khalidabuhakmeh/Htmx.Net>
- <https://github.com/khalidabuhakmeh/Htmx.Net#htmxtaghelpers>
- <https://github.com/hlaueriksson/Markupolation/tree/main/samples>

## Prolog

- <https://github.com/Anniepoo/declswiplweb>

## Lisp

- <https://github.com/rajasegar/ccl-demo-raja>
- <https://github.com/rajasegar/cl-trello-clone>
- <https://github.com/rajasegar/cl-github-timeline>

## Clojure

- <https://github.com/whamtet/ctmx>
- <https://github.com/jcpsantiago/htmx-clj-dashboard>
- <https://github.com/prestancedesign/babashka-htmx-todoapp>
- <https://github.com/dharrigan/startrek>

## Ruby

- <https://alchemists.io/projects/htmx>

### Rails

- <https://github.com/rootstrap/htmx-rails>
- <https://github.com/guilleiguaran/rails-htmx>

### Sinatra

- <https://github.com/libsyz/htmx-to-do-app>
- <https://github.com/beechnut/pokebutt-htmx>

## Rust

- <https://github.com/paultuckey/example-todo-app-rust-htmx>

## Scala
  
### http4s
- <https://github.com/martinprobson/http4s-htmx-demo>

### zio-http
- <https://github.com/rockthejvm/scalatags-htmx-demo>

## Kotlin

### Ktor

<https://github.com/Rattlyy/htmx-ktor>

### Http4k

<https://github.com/corlaez/todo-hda-kt>

## Julia

- <https://github.com/clarkevans/TodoMVC.jl>

## OCaml

- <https://ocaml.org/p/dream-htmx>
- <https://github.com/yawaramin/dream-html>

## PHP

### CodeIgniter 4

- <https://github.com/michalsn/codeigniter-htmx-demo>


### Laravel

- <https://spirofloropoulos.com/laravel-htmx-hard-mode-1.html>

### Symfony

- <https://github.com/tomcri/htmxfony>

## Elixir

### Phoenix

- <https://github.com/hungle00/todo-htmx>

### Bandit with Plug Application

- <https://github.com/lorantkurthy/todo-htmex>

## F#

### Giraffe

- <https://hamy.xyz/labs/2023-12-fsharp-htmx>
- <https://github.com/bit-badger/Giraffe.Htmx>

### Feliz.ViewEngine.Htmx

- <https://github.com/Zaid-Ajaj/Feliz.ViewEngine.Htmx>
- <https://github.com/jkone27/todo-mvc-feliz-htmx>

### Falco.Htmx

- <https://github.com/dpraimeyuu/Falco.Htmx>

### Suave (with Feliz)

- <https://jkone27-3876.medium.com/htmx-and-f-c1ffdc18fbb5>

## Go

### templ

- <https://templ.guide/server-side-rendering/htmx>
- <https://github.com/jritsema/go-htmx-tailwind-example>

### elem-go

- <https://github.com/chasefleming/elem-go/tree/main/examples/htmx-fiber-counter>
- <https://github.com/chasefleming/elem-go/tree/main/examples/htmx-fiber-todo>

## Delphi

### DelphiMVCFramework

- <https://github.com/danieleteti/delphi-dmvcframework-htmx-todo>
- <https://github.com/danieleteti/delphimvcframework/tree/master/samples/htmx>
